/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.error;

import java.util.Arrays;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;

public final class ErrorType
extends SimpleType {
    private final TypeConstructor constructor;
    private final MemberScope memberScope;
    private final ErrorTypeKind kind;
    private final List<TypeProjection> arguments;
    private final boolean isMarkedNullable;
    private final String[] formatParams;
    private final String debugMessage;

    public ErrorType(TypeConstructor object, MemberScope stringArray, ErrorTypeKind errorTypeKind, List<? extends TypeProjection> list, boolean bl, String ... stringArray2) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)errorTypeKind), (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray2, (String)"");
        this.constructor = object;
        this.memberScope = stringArray;
        this.kind = errorTypeKind;
        this.arguments = list;
        this.isMarkedNullable = bl;
        this.formatParams = stringArray2;
        object = this.kind.getDebugMessage();
        stringArray = this.formatParams;
        stringArray = Arrays.copyOf(this.formatParams, stringArray.length);
        String string = String.format((String)object, Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        this.debugMessage = string;
    }

    public /* synthetic */ ErrorType(TypeConstructor typeConstructor2, MemberScope memberScope2, ErrorTypeKind errorTypeKind, List list, boolean bl, String[] stringArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(typeConstructor2, memberScope2, errorTypeKind, (List<? extends TypeProjection>)list, bl, stringArray);
    }

    @Override
    public final TypeConstructor getConstructor() {
        return this.constructor;
    }

    @Override
    public final MemberScope getMemberScope() {
        return this.memberScope;
    }

    public final ErrorTypeKind getKind() {
        return this.kind;
    }

    @Override
    public final List<TypeProjection> getArguments() {
        return this.arguments;
    }

    @Override
    public final boolean isMarkedNullable() {
        return this.isMarkedNullable;
    }

    public final String getDebugMessage() {
        return this.debugMessage;
    }

    @Override
    public final TypeAttributes getAttributes() {
        return TypeAttributes.Companion.getEmpty();
    }

    @Override
    public final SimpleType replaceAttributes(TypeAttributes typeAttributes) {
        Intrinsics.checkNotNullParameter((Object)typeAttributes, (String)"");
        return this;
    }

    public final ErrorType replaceArguments(List<? extends TypeProjection> stringArray) {
        Intrinsics.checkNotNullParameter(stringArray, (String)"");
        String[] stringArray2 = stringArray;
        stringArray = this.formatParams;
        return new ErrorType(this.getConstructor(), this.getMemberScope(), this.kind, (List<? extends TypeProjection>)stringArray2, this.isMarkedNullable(), Arrays.copyOf(this.formatParams, stringArray.length));
    }

    @Override
    public final SimpleType makeNullableAsSpecified(boolean bl) {
        String[] stringArray = this.formatParams;
        return new ErrorType(this.getConstructor(), this.getMemberScope(), this.kind, this.getArguments(), bl, Arrays.copyOf(this.formatParams, stringArray.length));
    }

    @Override
    public final ErrorType refine(KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"");
        return this;
    }
}

