/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import org.apache.fontbox.ttf.HorizontalHeaderTable;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;

public class HorizontalMetricsTable
extends TTFTable {
    public static final String TAG = "hmtx";
    private int[] advanceWidth;
    private short[] leftSideBearing;
    private short[] nonHorizontalLeftSideBearing;
    private int numHMetrics;

    HorizontalMetricsTable() {
    }

    @Override
    void read(TrueTypeFont trueTypeFont, TTFDataStream tTFDataStream) {
        int n;
        HorizontalHeaderTable horizontalHeaderTable = trueTypeFont.getHorizontalHeader();
        if (horizontalHeaderTable == null) {
            throw new IOException("Could not get hmtx table");
        }
        this.numHMetrics = horizontalHeaderTable.getNumberOfHMetrics();
        int n2 = trueTypeFont.getNumberOfGlyphs();
        int n3 = 0;
        this.advanceWidth = new int[this.numHMetrics];
        this.leftSideBearing = new short[this.numHMetrics];
        for (n = 0; n < this.numHMetrics; ++n) {
            this.advanceWidth[n] = tTFDataStream.readUnsignedShort();
            this.leftSideBearing[n] = tTFDataStream.readSignedShort();
            n3 += 4;
        }
        n = n2 - this.numHMetrics;
        if (n < 0) {
            n = n2;
        }
        this.nonHorizontalLeftSideBearing = new short[n];
        if ((long)n3 < this.getLength()) {
            for (n2 = 0; n2 < n; ++n2) {
                if ((long)n3 >= this.getLength()) continue;
                this.nonHorizontalLeftSideBearing[n2] = tTFDataStream.readSignedShort();
                n3 += 2;
            }
        }
        this.initialized = true;
    }

    public int getAdvanceWidth(int n) {
        if (this.advanceWidth.length == 0) {
            return 250;
        }
        if (n < this.numHMetrics) {
            return this.advanceWidth[n];
        }
        return this.advanceWidth[this.advanceWidth.length - 1];
    }

    public int getLeftSideBearing(int n) {
        if (this.leftSideBearing.length == 0) {
            return 0;
        }
        if (n < this.numHMetrics) {
            return this.leftSideBearing[n];
        }
        return this.nonHorizontalLeftSideBearing[n - this.numHMetrics];
    }
}

