/*
 * Decompiled with CFR 0.152.
 */
package org.quartz;

import java.util.Date;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.spi.MutableTrigger;
import org.quartz.utils.Key;

public class TriggerBuilder<T extends Trigger> {
    private TriggerKey key;
    private String description;
    private Date startTime = new Date();
    private Date endTime;
    private int priority = 5;
    private String calendarName;
    private JobKey jobKey;
    private JobDataMap jobDataMap = new JobDataMap();
    private ScheduleBuilder<?> scheduleBuilder = null;

    private TriggerBuilder() {
    }

    public static TriggerBuilder<Trigger> newTrigger() {
        return new TriggerBuilder<Trigger>();
    }

    public T build() {
        if (this.scheduleBuilder == null) {
            this.scheduleBuilder = SimpleScheduleBuilder.simpleSchedule();
        }
        MutableTrigger mutableTrigger = this.scheduleBuilder.build();
        mutableTrigger.setCalendarName(this.calendarName);
        mutableTrigger.setDescription(this.description);
        mutableTrigger.setStartTime(this.startTime);
        mutableTrigger.setEndTime(this.endTime);
        if (this.key == null) {
            this.key = new TriggerKey(Key.createUniqueName(null), null);
        }
        mutableTrigger.setKey(this.key);
        if (this.jobKey != null) {
            mutableTrigger.setJobKey(this.jobKey);
        }
        mutableTrigger.setPriority(this.priority);
        if (!this.jobDataMap.isEmpty()) {
            mutableTrigger.setJobDataMap(this.jobDataMap);
        }
        return (T)mutableTrigger;
    }

    public TriggerBuilder<T> withIdentity(String string) {
        this.key = new TriggerKey(string, null);
        return this;
    }

    public TriggerBuilder<T> withIdentity(String string, String string2) {
        this.key = new TriggerKey(string, string2);
        return this;
    }

    public TriggerBuilder<T> withIdentity(TriggerKey triggerKey) {
        this.key = triggerKey;
        return this;
    }

    public TriggerBuilder<T> withDescription(String string) {
        this.description = string;
        return this;
    }

    public TriggerBuilder<T> withPriority(int n) {
        this.priority = n;
        return this;
    }

    public TriggerBuilder<T> modifiedByCalendar(String string) {
        this.calendarName = string;
        return this;
    }

    public TriggerBuilder<T> startAt(Date date) {
        this.startTime = date;
        return this;
    }

    public TriggerBuilder<T> startNow() {
        this.startTime = new Date();
        return this;
    }

    public TriggerBuilder<T> endAt(Date date) {
        this.endTime = date;
        return this;
    }

    public <SBT extends T> TriggerBuilder<SBT> withSchedule(ScheduleBuilder<SBT> scheduleBuilder) {
        this.scheduleBuilder = scheduleBuilder;
        return this;
    }

    public TriggerBuilder<T> forJob(JobKey jobKey) {
        this.jobKey = jobKey;
        return this;
    }

    public TriggerBuilder<T> forJob(String string) {
        this.jobKey = new JobKey(string, null);
        return this;
    }

    public TriggerBuilder<T> forJob(String string, String string2) {
        this.jobKey = new JobKey(string, string2);
        return this;
    }

    public TriggerBuilder<T> forJob(JobDetail serializable) {
        if (((Key)(serializable = serializable.getKey())).getName() == null) {
            throw new IllegalArgumentException("The given job has not yet had a name assigned to it.");
        }
        this.jobKey = serializable;
        return this;
    }

    public TriggerBuilder<T> usingJobData(String string, String string2) {
        this.jobDataMap.put(string, string2);
        return this;
    }

    public TriggerBuilder<T> usingJobData(String string, Integer n) {
        this.jobDataMap.put(string, (Object)n);
        return this;
    }

    public TriggerBuilder<T> usingJobData(String string, Long l) {
        this.jobDataMap.put(string, (Object)l);
        return this;
    }

    public TriggerBuilder<T> usingJobData(String string, Float f) {
        this.jobDataMap.put(string, (Object)f);
        return this;
    }

    public TriggerBuilder<T> usingJobData(String string, Double d) {
        this.jobDataMap.put(string, (Object)d);
        return this;
    }

    public TriggerBuilder<T> usingJobData(String string, Boolean bl) {
        this.jobDataMap.put(string, (Object)bl);
        return this;
    }

    public TriggerBuilder<T> usingJobData(JobDataMap jobDataMap) {
        for (String string : this.jobDataMap.keySet()) {
            jobDataMap.put(string, this.jobDataMap.get(string));
        }
        this.jobDataMap = jobDataMap;
        return this;
    }
}

