/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.ee.jta;

import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.quartz.SchedulerException;
import org.quartz.ee.jta.UserTransactionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UserTransactionHelper$UserTransactionWithContext
implements UserTransaction {
    InitialContext context;
    UserTransaction userTransaction;

    public UserTransactionHelper$UserTransactionWithContext() {
        try {
            this.context = new InitialContext();
        }
        catch (Throwable throwable) {
            throw new SchedulerException("UserTransactionHelper failed to create InitialContext to lookup/create UserTransaction.", throwable);
        }
        try {
            this.userTransaction = (UserTransaction)this.context.lookup(UserTransactionHelper.access$000());
        }
        catch (Throwable throwable) {
            this.closeContext();
            throw new SchedulerException("UserTransactionHelper could not lookup/create UserTransaction.", throwable);
        }
        if (this.userTransaction == null) {
            this.closeContext();
            throw new SchedulerException("UserTransactionHelper could not lookup/create UserTransaction from the InitialContext.");
        }
    }

    public void closeContext() {
        try {
            if (this.context != null) {
                this.context.close();
            }
        }
        catch (Throwable throwable) {
            UserTransactionHelper$UserTransactionWithContext.getLog().warn("Failed to close InitialContext used to get a UserTransaction.", throwable);
        }
        this.context = null;
    }

    protected void finalize() {
        try {
            if (this.context != null) {
                UserTransactionHelper$UserTransactionWithContext.getLog().warn("UserTransaction was never returned to the UserTransactionHelper.");
                this.closeContext();
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    private static Logger getLog() {
        return LoggerFactory.getLogger(UserTransactionHelper$UserTransactionWithContext.class);
    }

    public void begin() {
        this.userTransaction.begin();
    }

    public void commit() {
        this.userTransaction.commit();
    }

    public void rollback() {
        this.userTransaction.rollback();
    }

    public void setRollbackOnly() {
        this.userTransaction.setRollbackOnly();
    }

    public int getStatus() {
        return this.userTransaction.getStatus();
    }

    public void setTransactionTimeout(int n) {
        this.userTransaction.setTransactionTimeout(n);
    }
}

