/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.calendar;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import org.quartz.Calendar;
import org.quartz.impl.calendar.BaseCalendar;

public class HolidayCalendar
extends BaseCalendar
implements Serializable,
Calendar {
    static final long serialVersionUID = -7590908752291814693L;
    private TreeSet<Date> dates = new TreeSet();

    public HolidayCalendar() {
    }

    public HolidayCalendar(Calendar calendar) {
        super(calendar);
    }

    public HolidayCalendar(TimeZone timeZone) {
        super(timeZone);
    }

    public HolidayCalendar(Calendar calendar, TimeZone timeZone) {
        super(calendar, timeZone);
    }

    @Override
    public Object clone() {
        HolidayCalendar holidayCalendar = (HolidayCalendar)super.clone();
        ((HolidayCalendar)super.clone()).dates = new TreeSet<Date>((SortedSet<Date>)this.dates);
        return holidayCalendar;
    }

    @Override
    public boolean isTimeIncluded(long l) {
        if (!super.isTimeIncluded(l)) {
            return false;
        }
        Date date = this.getStartOfDayJavaCalendar(l).getTime();
        return !this.dates.contains(date);
    }

    @Override
    public long getNextIncludedTime(long l) {
        long l2 = super.getNextIncludedTime(l);
        if (l2 > 0L && l2 > l) {
            l = l2;
        }
        java.util.Calendar calendar = this.getStartOfDayJavaCalendar(l);
        while (!this.isTimeIncluded(calendar.getTime().getTime())) {
            calendar.add(5, 1);
        }
        return calendar.getTime().getTime();
    }

    public void addExcludedDate(Date date) {
        date = this.getStartOfDayJavaCalendar(date.getTime()).getTime();
        this.dates.add(date);
    }

    public void removeExcludedDate(Date date) {
        date = this.getStartOfDayJavaCalendar(date.getTime()).getTime();
        this.dates.remove(date);
    }

    public SortedSet<Date> getExcludedDates() {
        return Collections.unmodifiableSortedSet(this.dates);
    }
}

