/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.cff.CharStringCommand;
import org.apache.fontbox.cff.Type1CharString$1;
import org.apache.fontbox.encoding.StandardEncoding;
import org.apache.fontbox.type1.Type1CharStringReader;

public class Type1CharString {
    private static final Log LOG = LogFactory.getLog(Type1CharString.class);
    private final Type1CharStringReader font;
    private final String fontName;
    private final String glyphName;
    private GeneralPath path = null;
    private int width = 0;
    private Point2D.Float leftSideBearing = null;
    private Point2D.Float current = null;
    private boolean isFlex = false;
    private final List<Point2D.Float> flexPoints = new ArrayList<Point2D.Float>();
    private final List<Object> type1Sequence = new ArrayList<Object>();
    private int commandCount = 0;

    public Type1CharString(Type1CharStringReader type1CharStringReader, String string, String string2, List<Object> list) {
        this(type1CharStringReader, string, string2);
        this.type1Sequence.addAll(list);
    }

    protected Type1CharString(Type1CharStringReader type1CharStringReader, String string, String string2) {
        this.font = type1CharStringReader;
        this.fontName = string;
        this.glyphName = string2;
        this.current = new Point2D.Float(0.0f, 0.0f);
    }

    public String getName() {
        return this.glyphName;
    }

    public Rectangle2D getBounds() {
        Log log = LOG;
        synchronized (log) {
            if (this.path == null) {
                this.render();
            }
        }
        return this.path.getBounds2D();
    }

    public int getWidth() {
        Log log = LOG;
        synchronized (log) {
            if (this.path == null) {
                this.render();
            }
        }
        return this.width;
    }

    public GeneralPath getPath() {
        Log log = LOG;
        synchronized (log) {
            if (this.path == null) {
                this.render();
            }
        }
        return this.path;
    }

    private void render() {
        this.path = new GeneralPath();
        this.leftSideBearing = new Point2D.Float(0.0f, 0.0f);
        this.width = 0;
        ArrayList arrayList = new ArrayList();
        this.type1Sequence.forEach(list2 -> {
            if (list2 instanceof CharStringCommand) {
                list2 = this.handleType1Command(arrayList, (CharStringCommand)((Object)list2));
                arrayList.clear();
                arrayList.addAll(list2);
                return;
            }
            arrayList.add((Number)((Object)list2));
        });
    }

    private List<Number> handleType1Command(List<Number> list, CharStringCommand object) {
        ++this.commandCount;
        if ((object = ((CharStringCommand)object).getType1KeyWord()) == null) {
            LOG.warn((Object)("Unknown charstring command in glyph " + this.glyphName + " of font " + this.fontName));
            return Collections.emptyList();
        }
        switch (Type1CharString$1.$SwitchMap$org$apache$fontbox$cff$CharStringCommand$Type1KeyWord[((Enum)object).ordinal()]) {
            case 1: {
                if (list.size() < 2) break;
                if (this.isFlex) {
                    this.flexPoints.add(new Point2D.Float(list.get(0).floatValue(), list.get(1).floatValue()));
                    break;
                }
                this.rmoveTo(list.get(0), list.get(1));
                break;
            }
            case 2: {
                if (list.isEmpty()) break;
                if (this.isFlex) {
                    this.flexPoints.add(new Point2D.Float(0.0f, list.get(0).floatValue()));
                    break;
                }
                this.rmoveTo(0, list.get(0));
                break;
            }
            case 3: {
                if (list.isEmpty()) break;
                if (this.isFlex) {
                    this.flexPoints.add(new Point2D.Float(list.get(0).floatValue(), 0.0f));
                    break;
                }
                this.rmoveTo(list.get(0), 0);
                break;
            }
            case 4: {
                if (list.size() < 2) break;
                this.rlineTo(list.get(0), list.get(1));
                break;
            }
            case 5: {
                if (list.isEmpty()) break;
                this.rlineTo(list.get(0), 0);
                break;
            }
            case 6: {
                if (list.isEmpty()) break;
                this.rlineTo(0, list.get(0));
                break;
            }
            case 7: {
                if (list.size() < 6) break;
                this.rrcurveTo(list.get(0), list.get(1), list.get(2), list.get(3), list.get(4), list.get(5));
                break;
            }
            case 8: {
                this.closeCharString1Path();
                break;
            }
            case 9: {
                if (list.size() < 3) break;
                this.leftSideBearing = new Point2D.Float(list.get(0).floatValue(), list.get(1).floatValue());
                this.width = list.get(2).intValue();
                this.current.setLocation(this.leftSideBearing);
                break;
            }
            case 10: {
                if (list.size() < 2) break;
                this.leftSideBearing = new Point2D.Float(list.get(0).floatValue(), 0.0f);
                this.width = list.get(1).intValue();
                this.current.setLocation(this.leftSideBearing);
                break;
            }
            case 11: {
                if (list.size() < 4) break;
                this.rrcurveTo(0, list.get(0), list.get(1), list.get(2), list.get(3), 0);
                break;
            }
            case 12: {
                if (list.size() < 4) break;
                this.rrcurveTo(list.get(0), 0, list.get(1), list.get(2), 0, list.get(3));
                break;
            }
            case 13: {
                if (list.size() < 5) break;
                this.seac(list.get(0), list.get(1), list.get(2), list.get(3), list.get(4));
                break;
            }
            case 14: {
                if (list.size() < 2) break;
                this.setcurrentpoint(list.get(0), list.get(1));
                break;
            }
            case 15: {
                if (list.isEmpty()) break;
                this.callothersubr(list.get(0).intValue());
                break;
            }
            case 16: {
                if (list.size() < 2) break;
                List<Number> list2 = list;
                float f = list2.get(list2.size() - 1).floatValue();
                List<Number> list3 = list;
                float f2 = list3.get(list3.size() - 2).floatValue();
                f = f2 / f;
                list = new ArrayList<Number>(list);
                list.remove(list.size() - 1);
                List<Number> list4 = list;
                list4.remove(list4.size() - 1);
                list.add(Float.valueOf(f));
                return list;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 22: {
                break;
            }
            case 23: 
            case 24: {
                LOG.warn((Object)("Unexpected charstring command: " + object + " in glyph " + this.glyphName + " of font " + this.fontName));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled command: " + object);
            }
        }
        return Collections.emptyList();
    }

    private void setcurrentpoint(Number number, Number number2) {
        this.current.setLocation(number.floatValue(), number2.floatValue());
    }

    private void callothersubr(int n) {
        if (n == 0) {
            this.isFlex = false;
            if (this.flexPoints.size() < 7) {
                LOG.warn((Object)("flex without moveTo in font " + this.fontName + ", glyph " + this.glyphName + ", command " + this.commandCount));
                return;
            }
            Point2D.Float float_ = this.flexPoints.get(0);
            float_.setLocation(this.current.getX() + float_.getX(), this.current.getY() + float_.getY());
            Point2D.Float float_2 = this.flexPoints.get(1);
            float_2.setLocation(float_.getX() + float_2.getX(), float_.getY() + float_2.getY());
            Point2D.Float float_3 = float_2;
            float_3.setLocation(float_3.getX() - this.current.getX(), float_2.getY() - this.current.getY());
            float_ = this.flexPoints.get(1);
            float_2 = this.flexPoints.get(2);
            Point2D.Float float_4 = this.flexPoints.get(3);
            this.rrcurveTo(float_.getX(), float_.getY(), float_2.getX(), float_2.getY(), float_4.getX(), float_4.getY());
            float_ = this.flexPoints.get(4);
            float_2 = this.flexPoints.get(5);
            float_4 = this.flexPoints.get(6);
            this.rrcurveTo(float_.getX(), float_.getY(), float_2.getX(), float_2.getY(), float_4.getX(), float_4.getY());
            this.flexPoints.clear();
            return;
        }
        if (n == 1) {
            this.isFlex = true;
            return;
        }
        LOG.warn((Object)("Invalid callothersubr parameter: " + n));
    }

    private void rmoveTo(Number number, Number number2) {
        float f = (float)this.current.getX() + number.floatValue();
        float f2 = (float)this.current.getY() + number2.floatValue();
        this.path.moveTo(f, f2);
        this.current.setLocation(f, f2);
    }

    private void rlineTo(Number number, Number number2) {
        float f = (float)this.current.getX() + number.floatValue();
        float f2 = (float)this.current.getY() + number2.floatValue();
        if (this.path.getCurrentPoint() == null) {
            LOG.warn((Object)("rlineTo without initial moveTo in font " + this.fontName + ", glyph " + this.glyphName));
            this.path.moveTo(f, f2);
        } else {
            this.path.lineTo(f, f2);
        }
        this.current.setLocation(f, f2);
    }

    private void rrcurveTo(Number number, Number number2, Number number3, Number number4, Number number5, Number number6) {
        float f = (float)this.current.getX() + number.floatValue();
        float f2 = (float)this.current.getY() + number2.floatValue();
        float f3 = f + number3.floatValue();
        float f4 = f2 + number4.floatValue();
        float f5 = f3 + number5.floatValue();
        float f6 = f4 + number6.floatValue();
        if (this.path.getCurrentPoint() == null) {
            LOG.warn((Object)("rrcurveTo without initial moveTo in font " + this.fontName + ", glyph " + this.glyphName));
            this.path.moveTo(f5, f6);
        } else {
            this.path.curveTo(f, f2, f3, f4, f5, f6);
        }
        this.current.setLocation(f5, f6);
    }

    private void closeCharString1Path() {
        if (this.path.getCurrentPoint() == null) {
            LOG.warn((Object)("closepath without initial moveTo in font " + this.fontName + ", glyph " + this.glyphName));
        } else {
            this.path.closePath();
        }
        this.path.moveTo(this.current.getX(), this.current.getY());
    }

    private void seac(Number serializable, Number number, Number number2, Number object, Number object2) {
        Object object3;
        object = StandardEncoding.INSTANCE.getName(((Number)object).intValue());
        try {
            object3 = this.font.getType1CharString((String)object);
            this.path.append(((Type1CharString)object3).getPath().getPathIterator(null), false);
        }
        catch (IOException iOException) {
            LOG.warn((Object)("invalid seac character in glyph " + this.glyphName + " of font " + this.fontName), (Throwable)iOException);
        }
        object3 = StandardEncoding.INSTANCE.getName(((Number)object2).intValue());
        try {
            object2 = this.font.getType1CharString((String)object3);
            object2 = ((Type1CharString)object2).getPath();
            if (this.path == object2) {
                LOG.warn((Object)("Path for " + (String)object + " and for accent " + (String)object3 + " are same, ignored"));
                return;
            }
            serializable = AffineTransform.getTranslateInstance(this.leftSideBearing.getX() + (double)number.floatValue() - (double)serializable.floatValue(), this.leftSideBearing.getY() + (double)number2.floatValue());
            this.path.append(((Path2D.Float)object2).getPathIterator((AffineTransform)serializable), false);
            return;
        }
        catch (IOException iOException) {
            LOG.warn((Object)("invalid seac character in glyph " + this.glyphName + " of font " + this.fontName), (Throwable)iOException);
            return;
        }
    }

    protected void addCommand(List<Number> list, CharStringCommand charStringCommand) {
        this.type1Sequence.addAll(list);
        this.type1Sequence.add(charStringCommand);
    }

    protected boolean isSequenceEmpty() {
        return this.type1Sequence.isEmpty();
    }

    protected Object getLastSequenceEntry() {
        if (!this.type1Sequence.isEmpty()) {
            return this.type1Sequence.get(this.type1Sequence.size() - 1);
        }
        return null;
    }

    public String toString() {
        return this.type1Sequence.toString().replace("|", "\n").replace(",", " ");
    }
}

