/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.a.d.e;
import org.apache.a.d.f;
import org.apache.a.d.g;
import org.apache.fontbox.ttf.OTFParser;
import org.apache.fontbox.ttf.RandomAccessReadDataStream;
import org.apache.fontbox.ttf.TTCDataStream;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeCollection$TrueTypeFontProcessor;
import org.apache.fontbox.ttf.TrueTypeFont;

public class TrueTypeCollection
implements Closeable {
    private final TTFDataStream stream;
    private final int numFonts;
    private final long[] fontOffsets;

    public TrueTypeCollection(File file) {
        this((e)new g(file));
    }

    public TrueTypeCollection(InputStream inputStream) {
        this((e)new f(inputStream));
    }

    TrueTypeCollection(e object) {
        this.stream = new RandomAccessReadDataStream((e)object);
        object = this.stream.readTag();
        if (!object.equals("ttcf")) {
            throw new IOException("Missing TTC header");
        }
        float f2 = this.stream.read32Fixed();
        this.numFonts = (int)this.stream.readUnsignedInt();
        if (this.numFonts <= 0 || this.numFonts > 1024) {
            throw new IOException("Invalid number of fonts " + this.numFonts);
        }
        this.fontOffsets = new long[this.numFonts];
        for (int i = 0; i < this.numFonts; ++i) {
            this.fontOffsets[i] = this.stream.readUnsignedInt();
        }
        if (f2 >= 2.0f) {
            this.stream.readUnsignedShort();
            this.stream.readUnsignedShort();
            this.stream.readUnsignedShort();
        }
    }

    public void processAllFonts(TrueTypeCollection$TrueTypeFontProcessor trueTypeCollection$TrueTypeFontProcessor) {
        for (int i = 0; i < this.numFonts; ++i) {
            TrueTypeFont trueTypeFont = this.getFontAtIndex(i);
            trueTypeCollection$TrueTypeFontProcessor.process(trueTypeFont);
        }
    }

    private TrueTypeFont getFontAtIndex(int n) {
        this.stream.seek(this.fontOffsets[n]);
        TTFParser tTFParser = this.stream.readTag().equals("OTTO") ? new OTFParser(false) : new TTFParser(false);
        this.stream.seek(this.fontOffsets[n]);
        return tTFParser.parse(new TTCDataStream(this.stream));
    }

    public TrueTypeFont getFontByName(String string) {
        for (int i = 0; i < this.numFonts; ++i) {
            TrueTypeFont trueTypeFont = this.getFontAtIndex(i);
            if (!trueTypeFont.getName().equals(string)) continue;
            return trueTypeFont;
        }
        return null;
    }

    @Override
    public void close() {
        this.stream.close();
    }
}

