/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.util.LoggerNameUtil;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import ch.qos.logback.core.spi.FilterReply;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.spi.DefaultLoggingEventBuilder;
import org.slf4j.spi.LocationAwareLogger;
import org.slf4j.spi.LoggingEventAware;
import org.slf4j.spi.LoggingEventBuilder;

public final class Logger
implements AppenderAttachable<ILoggingEvent>,
Serializable,
org.slf4j.Logger,
LocationAwareLogger,
LoggingEventAware {
    private static final long serialVersionUID = 5454405123156820674L;
    public static final String FQCN = Logger.class.getName();
    private String name;
    private transient Level level;
    private transient int effectiveLevelInt;
    private transient Logger parent;
    private transient List<Logger> childrenList;
    private transient AppenderAttachableImpl<ILoggingEvent> aai;
    private transient boolean additive = true;
    final transient LoggerContext loggerContext;

    Logger(String string, Logger logger, LoggerContext loggerContext) {
        this.name = string;
        this.parent = logger;
        this.loggerContext = loggerContext;
    }

    public final Level getEffectiveLevel() {
        return Level.toLevel(this.effectiveLevelInt);
    }

    final int getEffectiveLevelInt() {
        return this.effectiveLevelInt;
    }

    public final Level getLevel() {
        return this.level;
    }

    public final String getName() {
        return this.name;
    }

    private boolean isRootLogger() {
        return this.parent == null;
    }

    final Logger getChildByName(String string) {
        if (this.childrenList == null) {
            return null;
        }
        int n = this.childrenList.size();
        for (int i = 0; i < n; ++i) {
            Logger logger = this.childrenList.get(i);
            String string2 = logger.getName();
            if (!string.equals(string2)) continue;
            return logger;
        }
        return null;
    }

    public final synchronized void setLevel(Level level) {
        if (this.level == level) {
            return;
        }
        if (level == null && this.isRootLogger()) {
            throw new IllegalArgumentException("The level of the root logger cannot be set to null");
        }
        this.level = level;
        if (level == null) {
            this.effectiveLevelInt = this.parent.effectiveLevelInt;
            level = this.parent.getEffectiveLevel();
        } else {
            this.effectiveLevelInt = level.levelInt;
        }
        if (this.childrenList != null) {
            int n = this.childrenList.size();
            for (int i = 0; i < n; ++i) {
                Logger logger = this.childrenList.get(i);
                logger.handleParentLevelChange(this.effectiveLevelInt);
            }
        }
        this.loggerContext.fireOnLevelChange(this, level);
    }

    private synchronized void handleParentLevelChange(int n) {
        if (this.level == null) {
            this.effectiveLevelInt = n;
            if (this.childrenList != null) {
                int n2 = this.childrenList.size();
                for (int i = 0; i < n2; ++i) {
                    Logger logger = this.childrenList.get(i);
                    logger.handleParentLevelChange(n);
                }
            }
        }
    }

    public final void detachAndStopAllAppenders() {
        if (this.aai != null) {
            this.aai.detachAndStopAllAppenders();
        }
    }

    public final boolean detachAppender(String string) {
        if (this.aai == null) {
            return false;
        }
        return this.aai.detachAppender(string);
    }

    public final synchronized void addAppender(Appender<ILoggingEvent> appender) {
        if (this.aai == null) {
            this.aai = new AppenderAttachableImpl();
        }
        this.aai.addAppender(appender);
    }

    public final boolean isAttached(Appender<ILoggingEvent> appender) {
        if (this.aai == null) {
            return false;
        }
        return this.aai.isAttached(appender);
    }

    public final Iterator<Appender<ILoggingEvent>> iteratorForAppenders() {
        if (this.aai == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.aai.iteratorForAppenders();
    }

    public final Appender<ILoggingEvent> getAppender(String string) {
        if (this.aai == null) {
            return null;
        }
        return this.aai.getAppender(string);
    }

    public final void callAppenders(ILoggingEvent iLoggingEvent) {
        int n = 0;
        Logger logger = this;
        while (logger != null) {
            n += logger.appendLoopOnAppenders(iLoggingEvent);
            if (!logger.additive) break;
            logger = logger.parent;
        }
        if (n == 0) {
            this.loggerContext.noAppenderDefinedWarning(this);
        }
    }

    private int appendLoopOnAppenders(ILoggingEvent iLoggingEvent) {
        if (this.aai != null) {
            return this.aai.appendLoopOnAppenders((Object)iLoggingEvent);
        }
        return 0;
    }

    public final boolean detachAppender(Appender<ILoggingEvent> appender) {
        if (this.aai == null) {
            return false;
        }
        return this.aai.detachAppender(appender);
    }

    final Logger createChildByLastNamePart(String object) {
        int n = LoggerNameUtil.getFirstSeparatorIndexOf((String)object);
        if (n != -1) {
            throw new IllegalArgumentException("Child name [" + (String)object + " passed as parameter, may not include [.]");
        }
        if (this.childrenList == null) {
            this.childrenList = new CopyOnWriteArrayList<Logger>();
        }
        if (this.isRootLogger()) {
            Logger logger = this;
            object = new Logger((String)object, logger, logger.loggerContext);
        } else {
            Logger logger = this;
            object = new Logger(this.name + "." + (String)object, logger, logger.loggerContext);
        }
        this.childrenList.add((Logger)object);
        ((Logger)object).effectiveLevelInt = this.effectiveLevelInt;
        return object;
    }

    private void localLevelReset() {
        this.effectiveLevelInt = 10000;
        if (this.isRootLogger()) {
            this.level = Level.DEBUG;
            return;
        }
        this.level = null;
    }

    final void recursiveReset() {
        this.detachAndStopAllAppenders();
        this.localLevelReset();
        this.additive = true;
        if (this.childrenList == null) {
            return;
        }
        for (Logger logger : this.childrenList) {
            logger.recursiveReset();
        }
    }

    final Logger createChildByName(String object) {
        int n = LoggerNameUtil.getSeparatorIndexOf((String)object, this.name.length() + 1);
        if (n != -1) {
            throw new IllegalArgumentException("For logger [" + this.name + "] child name [" + (String)object + " passed as parameter, may not include '.' after index" + (this.name.length() + 1));
        }
        if (this.childrenList == null) {
            this.childrenList = new CopyOnWriteArrayList<Logger>();
        }
        Logger logger = this;
        object = new Logger((String)object, logger, logger.loggerContext);
        this.childrenList.add((Logger)object);
        ((Logger)object).effectiveLevelInt = this.effectiveLevelInt;
        return object;
    }

    private void filterAndLog_0_Or3Plus(String string, Marker marker, Level level, String string2, Object[] objectArray, Throwable throwable) {
        FilterReply filterReply = this.loggerContext.getTurboFilterChainDecision_0_3OrMore(marker, this, level, string2, objectArray, throwable);
        if (filterReply == FilterReply.NEUTRAL ? this.effectiveLevelInt > level.levelInt : filterReply == FilterReply.DENY) {
            return;
        }
        this.buildLoggingEventAndAppend(string, marker, level, string2, objectArray, throwable);
    }

    private void filterAndLog_1(String string, Marker marker, Level level, String string2, Object object, Throwable throwable) {
        FilterReply filterReply = this.loggerContext.getTurboFilterChainDecision_1(marker, this, level, string2, object, throwable);
        if (filterReply == FilterReply.NEUTRAL ? this.effectiveLevelInt > level.levelInt : filterReply == FilterReply.DENY) {
            return;
        }
        this.buildLoggingEventAndAppend(string, marker, level, string2, new Object[]{object}, throwable);
    }

    private void filterAndLog_2(String string, Marker marker, Level level, String string2, Object object, Object object2, Throwable throwable) {
        FilterReply filterReply = this.loggerContext.getTurboFilterChainDecision_2(marker, this, level, string2, object, object2, throwable);
        if (filterReply == FilterReply.NEUTRAL ? this.effectiveLevelInt > level.levelInt : filterReply == FilterReply.DENY) {
            return;
        }
        this.buildLoggingEventAndAppend(string, marker, level, string2, new Object[]{object, object2}, throwable);
    }

    private void buildLoggingEventAndAppend(String object, Marker marker, Level level, String string, Object[] objectArray, Throwable throwable) {
        object = new LoggingEvent((String)object, this, level, string, throwable, objectArray);
        ((LoggingEvent)object).addMarker(marker);
        this.callAppenders((ILoggingEvent)object);
    }

    public final void trace(String string) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.TRACE, string, null, null);
    }

    public final void trace(String string, Object object) {
        this.filterAndLog_1(FQCN, null, Level.TRACE, string, object, null);
    }

    public final void trace(String string, Object object, Object object2) {
        this.filterAndLog_2(FQCN, null, Level.TRACE, string, object, object2, null);
    }

    public final void trace(String string, Object ... objectArray) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.TRACE, string, objectArray, null);
    }

    public final void trace(String string, Throwable throwable) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.TRACE, string, null, throwable);
    }

    public final void trace(Marker marker, String string) {
        this.filterAndLog_0_Or3Plus(FQCN, marker, Level.TRACE, string, null, null);
    }

    public final void trace(Marker marker, String string, Object object) {
        this.filterAndLog_1(FQCN, marker, Level.TRACE, string, object, null);
    }

    public final void trace(Marker marker, String string, Object object, Object object2) {
        this.filterAndLog_2(FQCN, marker, Level.TRACE, string, object, object2, null);
    }

    public final void trace(Marker marker, String string, Object ... objectArray) {
        this.filterAndLog_0_Or3Plus(FQCN, marker, Level.TRACE, string, objectArray, null);
    }

    public final void trace(Marker marker, String string, Throwable throwable) {
        this.filterAndLog_0_Or3Plus(FQCN, marker, Level.TRACE, string, null, throwable);
    }

    public final boolean isDebugEnabled() {
        return this.isDebugEnabled(null);
    }

    public final boolean isDebugEnabled(Marker marker) {
        if ((marker = this.callTurboFilters(marker, Level.DEBUG)) == FilterReply.NEUTRAL) {
            return this.effectiveLevelInt <= 10000;
        }
        if (marker == FilterReply.DENY) {
            return false;
        }
        if (marker == FilterReply.ACCEPT) {
            return true;
        }
        throw new IllegalStateException("Unknown FilterReply value: " + String.valueOf(marker));
    }

    public final void debug(String string) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.DEBUG, string, null, null);
    }

    public final void debug(String string, Object object) {
        this.filterAndLog_1(FQCN, null, Level.DEBUG, string, object, null);
    }

    public final void debug(String string, Object object, Object object2) {
        this.filterAndLog_2(FQCN, null, Level.DEBUG, string, object, object2, null);
    }

    public final void debug(String string, Object ... objectArray) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.DEBUG, string, objectArray, null);
    }

    public final void debug(String string, Throwable throwable) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.DEBUG, string, null, throwable);
    }

    public final void debug(Marker marker, String string) {
        this.filterAndLog_0_Or3Plus(FQCN, marker, Level.DEBUG, string, null, null);
    }

    public final void debug(Marker marker, String string, Object object) {
        this.filterAndLog_1(FQCN, marker, Level.DEBUG, string, object, null);
    }

    public final void debug(Marker marker, String string, Object object, Object object2) {
        this.filterAndLog_2(FQCN, marker, Level.DEBUG, string, object, object2, null);
    }

    public final void debug(Marker marker, String string, Object ... objectArray) {
        this.filterAndLog_0_Or3Plus(FQCN, marker, Level.DEBUG, string, objectArray, null);
    }

    public final void debug(Marker marker, String string, Throwable throwable) {
        this.filterAndLog_0_Or3Plus(FQCN, marker, Level.DEBUG, string, null, throwable);
    }

    public final void error(String string) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.ERROR, string, null, null);
    }

    public final void error(String string, Object object) {
        this.filterAndLog_1(FQCN, null, Level.ERROR, string, object, null);
    }

    public final void error(String string, Object object, Object object2) {
        this.filterAndLog_2(FQCN, null, Level.ERROR, string, object, object2, null);
    }

    public final void error(String string, Object ... objectArray) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.ERROR, string, objectArray, null);
    }

    public final void error(String string, Throwable throwable) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.ERROR, string, null, throwable);
    }

    public final void error(Marker marker, String string) {
        this.filterAndLog_0_Or3Plus(FQCN, marker, Level.ERROR, string, null, null);
    }

    public final void error(Marker marker, String string, Object object) {
        this.filterAndLog_1(FQCN, marker, Level.ERROR, string, object, null);
    }

    public final void error(Marker marker, String string, Object object, Object object2) {
        this.filterAndLog_2(FQCN, marker, Level.ERROR, string, object, object2, null);
    }

    public final void error(Marker marker, String string, Object ... objectArray) {
        this.filterAndLog_0_Or3Plus(FQCN, marker, Level.ERROR, string, objectArray, null);
    }

    public final void error(Marker marker, String string, Throwable throwable) {
        this.filterAndLog_0_Or3Plus(FQCN, marker, Level.ERROR, string, null, throwable);
    }

    public final boolean isInfoEnabled() {
        return this.isInfoEnabled(null);
    }

    public final boolean isInfoEnabled(Marker marker) {
        if ((marker = this.callTurboFilters(marker, Level.INFO)) == FilterReply.NEUTRAL) {
            return this.effectiveLevelInt <= 20000;
        }
        if (marker == FilterReply.DENY) {
            return false;
        }
        if (marker == FilterReply.ACCEPT) {
            return true;
        }
        throw new IllegalStateException("Unknown FilterReply value: " + String.valueOf(marker));
    }

    public final void info(String string) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.INFO, string, null, null);
    }

    public final void info(String string, Object object) {
        this.filterAndLog_1(FQCN, null, Level.INFO, string, object, null);
    }

    public final void info(String string, Object object, Object object2) {
        this.filterAndLog_2(FQCN, null, Level.INFO, string, object, object2, null);
    }

    public final void info(String string, Object ... objectArray) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.INFO, string, objectArray, null);
    }

    public final void info(String string, Throwable throwable) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.INFO, string, null, throwable);
    }

    public final void info(Marker marker, String string) {
        this.filterAndLog_0_Or3Plus(FQCN, marker, Level.INFO, string, null, null);
    }

    public final void info(Marker marker, String string, Object object) {
        this.filterAndLog_1(FQCN, marker, Level.INFO, string, object, null);
    }

    public final void info(Marker marker, String string, Object object, Object object2) {
        this.filterAndLog_2(FQCN, marker, Level.INFO, string, object, object2, null);
    }

    public final void info(Marker marker, String string, Object ... objectArray) {
        this.filterAndLog_0_Or3Plus(FQCN, marker, Level.INFO, string, objectArray, null);
    }

    public final void info(Marker marker, String string, Throwable throwable) {
        this.filterAndLog_0_Or3Plus(FQCN, marker, Level.INFO, string, null, throwable);
    }

    public final boolean isTraceEnabled() {
        return this.isTraceEnabled(null);
    }

    public final boolean isTraceEnabled(Marker marker) {
        if ((marker = this.callTurboFilters(marker, Level.TRACE)) == FilterReply.NEUTRAL) {
            return this.effectiveLevelInt <= 5000;
        }
        if (marker == FilterReply.DENY) {
            return false;
        }
        if (marker == FilterReply.ACCEPT) {
            return true;
        }
        throw new IllegalStateException("Unknown FilterReply value: " + String.valueOf(marker));
    }

    public final boolean isErrorEnabled() {
        return this.isErrorEnabled(null);
    }

    public final boolean isErrorEnabled(Marker marker) {
        if ((marker = this.callTurboFilters(marker, Level.ERROR)) == FilterReply.NEUTRAL) {
            return this.effectiveLevelInt <= 40000;
        }
        if (marker == FilterReply.DENY) {
            return false;
        }
        if (marker == FilterReply.ACCEPT) {
            return true;
        }
        throw new IllegalStateException("Unknown FilterReply value: " + String.valueOf(marker));
    }

    public final boolean isWarnEnabled() {
        return this.isWarnEnabled(null);
    }

    public final boolean isWarnEnabled(Marker marker) {
        if ((marker = this.callTurboFilters(marker, Level.WARN)) == FilterReply.NEUTRAL) {
            return this.effectiveLevelInt <= 30000;
        }
        if (marker == FilterReply.DENY) {
            return false;
        }
        if (marker == FilterReply.ACCEPT) {
            return true;
        }
        throw new IllegalStateException("Unknown FilterReply value: " + String.valueOf(marker));
    }

    public final boolean isEnabledFor(Marker marker, Level level) {
        if ((marker = this.callTurboFilters(marker, level)) == FilterReply.NEUTRAL) {
            return this.effectiveLevelInt <= level.levelInt;
        }
        if (marker == FilterReply.DENY) {
            return false;
        }
        if (marker == FilterReply.ACCEPT) {
            return true;
        }
        throw new IllegalStateException("Unknown FilterReply value: " + String.valueOf(marker));
    }

    public final boolean isEnabledFor(Level level) {
        return this.isEnabledFor(null, level);
    }

    public final void warn(String string) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.WARN, string, null, null);
    }

    public final void warn(String string, Throwable throwable) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.WARN, string, null, throwable);
    }

    public final void warn(String string, Object object) {
        this.filterAndLog_1(FQCN, null, Level.WARN, string, object, null);
    }

    public final void warn(String string, Object object, Object object2) {
        this.filterAndLog_2(FQCN, null, Level.WARN, string, object, object2, null);
    }

    public final void warn(String string, Object ... objectArray) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.WARN, string, objectArray, null);
    }

    public final void warn(Marker marker, String string) {
        this.filterAndLog_0_Or3Plus(FQCN, marker, Level.WARN, string, null, null);
    }

    public final void warn(Marker marker, String string, Object object) {
        this.filterAndLog_1(FQCN, marker, Level.WARN, string, object, null);
    }

    public final void warn(Marker marker, String string, Object ... objectArray) {
        this.filterAndLog_0_Or3Plus(FQCN, marker, Level.WARN, string, objectArray, null);
    }

    public final void warn(Marker marker, String string, Object object, Object object2) {
        this.filterAndLog_2(FQCN, marker, Level.WARN, string, object, object2, null);
    }

    public final void warn(Marker marker, String string, Throwable throwable) {
        this.filterAndLog_0_Or3Plus(FQCN, marker, Level.WARN, string, null, throwable);
    }

    public final boolean isAdditive() {
        return this.additive;
    }

    public final void setAdditive(boolean bl) {
        this.additive = bl;
    }

    public final String toString() {
        return "Logger[" + this.name + "]";
    }

    private FilterReply callTurboFilters(Marker marker, Level level) {
        return this.loggerContext.getTurboFilterChainDecision_0_3OrMore(marker, this, level, null, null, null);
    }

    public final LoggerContext getLoggerContext() {
        return this.loggerContext;
    }

    public final LoggingEventBuilder makeLoggingEventBuilder(org.slf4j.event.Level level) {
        return new DefaultLoggingEventBuilder((org.slf4j.Logger)this, level);
    }

    public final void log(Marker marker, String string, int n, String string2, Object[] objectArray, Throwable throwable) {
        Level level = Level.fromLocationAwareLoggerInteger(n);
        this.filterAndLog_0_Or3Plus(string, marker, level, string2, objectArray, throwable);
    }

    public final void log(org.slf4j.event.LoggingEvent loggingEvent) {
        Object object = loggingEvent.getLevel();
        object = Level.convertAnSLF4JLevel((org.slf4j.event.Level)object);
        Object object2 = loggingEvent.getCallerBoundary();
        if (object2 == null) {
            object2 = FQCN;
        }
        object = new LoggingEvent((String)object2, this, (Level)object, loggingEvent.getMessage(), loggingEvent.getThrowable(), loggingEvent.getArgumentArray());
        object2 = loggingEvent.getMarkers();
        if (object2 != null) {
            object2.forEach(arg_0 -> Logger.lambda$log$0((LoggingEvent)object, arg_0));
        }
        ((LoggingEvent)object).setKeyValuePairs(loggingEvent.getKeyValuePairs());
        this.callAppenders((ILoggingEvent)object);
    }

    protected final Object readResolve() {
        return LoggerFactory.getLogger((String)this.getName());
    }

    private static /* synthetic */ void lambda$log$0(LoggingEvent loggingEvent, Marker marker) {
        loggingEvent.addMarker(marker);
    }
}

