/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.helpers;

import java.util.LinkedList;
import java.util.List;

public class ThrowableToStringArray {
    public static String[] convert(Throwable throwable) {
        LinkedList<String> linkedList = new LinkedList<String>();
        ThrowableToStringArray.extract(linkedList, throwable, null);
        return linkedList.toArray(new String[0]);
    }

    private static void extract(List<String> list, Throwable object, StackTraceElement[] object2) {
        while (true) {
            StackTraceElement[] stackTraceElementArray = object.getStackTrace();
            int n = ThrowableToStringArray.findNumberOfCommonFrames(stackTraceElementArray, object2);
            list.add(ThrowableToStringArray.formatFirstLine((Throwable)object, object2));
            for (int i = 0; i < stackTraceElementArray.length - n; ++i) {
                list.add("\tat " + stackTraceElementArray[i].toString());
            }
            if (n != 0) {
                list.add("\t... " + n + " common frames omitted");
            }
            if ((object2 = object.getCause()) == null) break;
            Object object3 = object2;
            object2 = stackTraceElementArray;
            object = object3;
        }
    }

    private static String formatFirstLine(Throwable throwable, StackTraceElement[] object) {
        String string = "";
        if (object != null) {
            string = "Caused by: ";
        }
        object = string + throwable.getClass().getName();
        if (throwable.getMessage() != null) {
            object = (String)object + ": " + throwable.getMessage();
        }
        return object;
    }

    private static int findNumberOfCommonFrames(StackTraceElement[] stackTraceElementArray, StackTraceElement[] stackTraceElementArray2) {
        if (stackTraceElementArray2 == null) {
            return 0;
        }
        int n = stackTraceElementArray.length - 1;
        int n2 = 0;
        for (int i = stackTraceElementArray2.length - 1; n >= 0 && i >= 0 && stackTraceElementArray[n].equals(stackTraceElementArray2[i]); --n, --i) {
            ++n2;
        }
        return n2;
    }
}

