/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net.ssl;

import ch.qos.logback.core.net.ssl.KeyManagerFactoryFactoryBean;
import ch.qos.logback.core.net.ssl.KeyStoreFactoryBean;
import ch.qos.logback.core.net.ssl.SecureRandomFactoryBean;
import ch.qos.logback.core.net.ssl.TrustManagerFactoryFactoryBean;
import ch.qos.logback.core.spi.ContextAware;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class SSLContextFactoryBean {
    private static final String JSSE_KEY_STORE_PROPERTY = "javax.net.ssl.keyStore";
    private static final String JSSE_TRUST_STORE_PROPERTY = "javax.net.ssl.trustStore";
    private KeyStoreFactoryBean keyStore;
    private KeyStoreFactoryBean trustStore;
    private SecureRandomFactoryBean secureRandom;
    private KeyManagerFactoryFactoryBean keyManagerFactory;
    private TrustManagerFactoryFactoryBean trustManagerFactory;
    private String protocol;
    private String provider;

    public SSLContext createContext(ContextAware object) {
        SSLContext sSLContext = this.getProvider() != null ? SSLContext.getInstance(this.getProtocol(), this.getProvider()) : SSLContext.getInstance(this.getProtocol());
        object.addInfo("SSL protocol '" + sSLContext.getProtocol() + "' provider '" + String.valueOf(sSLContext.getProvider()) + "'");
        KeyManager[] keyManagerArray = this.createKeyManagers((ContextAware)object);
        TrustManager[] trustManagerArray = this.createTrustManagers((ContextAware)object);
        object = this.createSecureRandom((ContextAware)object);
        sSLContext.init(keyManagerArray, trustManagerArray, (SecureRandom)object);
        return sSLContext;
    }

    private KeyManager[] createKeyManagers(ContextAware object) {
        if (this.getKeyStore() == null) {
            return null;
        }
        KeyStore keyStore = this.getKeyStore().createKeyStore();
        object.addInfo("key store of type '" + keyStore.getType() + "' provider '" + String.valueOf(keyStore.getProvider()) + "': " + this.getKeyStore().getLocation());
        KeyManagerFactory keyManagerFactory = this.getKeyManagerFactory().createKeyManagerFactory();
        object.addInfo("key manager algorithm '" + keyManagerFactory.getAlgorithm() + "' provider '" + String.valueOf(keyManagerFactory.getProvider()) + "'");
        object = this.getKeyStore().getPassword().toCharArray();
        keyManagerFactory.init(keyStore, (char[])object);
        return keyManagerFactory.getKeyManagers();
    }

    private TrustManager[] createTrustManagers(ContextAware contextAware) {
        if (this.getTrustStore() == null) {
            return null;
        }
        KeyStore keyStore = this.getTrustStore().createKeyStore();
        contextAware.addInfo("trust store of type '" + keyStore.getType() + "' provider '" + String.valueOf(keyStore.getProvider()) + "': " + this.getTrustStore().getLocation());
        TrustManagerFactory trustManagerFactory = this.getTrustManagerFactory().createTrustManagerFactory();
        contextAware.addInfo("trust manager algorithm '" + trustManagerFactory.getAlgorithm() + "' provider '" + String.valueOf(trustManagerFactory.getProvider()) + "'");
        trustManagerFactory.init(keyStore);
        return trustManagerFactory.getTrustManagers();
    }

    private SecureRandom createSecureRandom(ContextAware contextAware) {
        SecureRandom secureRandom = this.getSecureRandom().createSecureRandom();
        contextAware.addInfo("secure random algorithm '" + secureRandom.getAlgorithm() + "' provider '" + String.valueOf(secureRandom.getProvider()) + "'");
        return secureRandom;
    }

    public KeyStoreFactoryBean getKeyStore() {
        if (this.keyStore == null) {
            this.keyStore = this.keyStoreFromSystemProperties(JSSE_KEY_STORE_PROPERTY);
        }
        return this.keyStore;
    }

    public void setKeyStore(KeyStoreFactoryBean keyStoreFactoryBean) {
        this.keyStore = keyStoreFactoryBean;
    }

    public KeyStoreFactoryBean getTrustStore() {
        if (this.trustStore == null) {
            this.trustStore = this.keyStoreFromSystemProperties(JSSE_TRUST_STORE_PROPERTY);
        }
        return this.trustStore;
    }

    public void setTrustStore(KeyStoreFactoryBean keyStoreFactoryBean) {
        this.trustStore = keyStoreFactoryBean;
    }

    private KeyStoreFactoryBean keyStoreFromSystemProperties(String string) {
        if (System.getProperty(string) == null) {
            return null;
        }
        KeyStoreFactoryBean keyStoreFactoryBean = new KeyStoreFactoryBean();
        keyStoreFactoryBean.setLocation(this.locationFromSystemProperty(string));
        keyStoreFactoryBean.setProvider(System.getProperty(string + "Provider"));
        keyStoreFactoryBean.setPassword(System.getProperty(string + "Password"));
        keyStoreFactoryBean.setType(System.getProperty(string + "Type"));
        return keyStoreFactoryBean;
    }

    private String locationFromSystemProperty(String object) {
        if ((object = System.getProperty((String)object)) != null && !((String)object).startsWith("file:")) {
            object = "file:" + (String)object;
        }
        return object;
    }

    public SecureRandomFactoryBean getSecureRandom() {
        if (this.secureRandom == null) {
            return new SecureRandomFactoryBean();
        }
        return this.secureRandom;
    }

    public void setSecureRandom(SecureRandomFactoryBean secureRandomFactoryBean) {
        this.secureRandom = secureRandomFactoryBean;
    }

    public KeyManagerFactoryFactoryBean getKeyManagerFactory() {
        if (this.keyManagerFactory == null) {
            return new KeyManagerFactoryFactoryBean();
        }
        return this.keyManagerFactory;
    }

    public void setKeyManagerFactory(KeyManagerFactoryFactoryBean keyManagerFactoryFactoryBean) {
        this.keyManagerFactory = keyManagerFactoryFactoryBean;
    }

    public TrustManagerFactoryFactoryBean getTrustManagerFactory() {
        if (this.trustManagerFactory == null) {
            return new TrustManagerFactoryFactoryBean();
        }
        return this.trustManagerFactory;
    }

    public void setTrustManagerFactory(TrustManagerFactoryFactoryBean trustManagerFactoryFactoryBean) {
        this.trustManagerFactory = trustManagerFactoryFactoryBean;
    }

    public String getProtocol() {
        if (this.protocol == null) {
            return "SSL";
        }
        return this.protocol;
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String string) {
        this.provider = string;
    }
}

