/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.core;

import java.sql.SQLException;
import org.sqlite.core.DB;
import org.sqlite.core.SafeStmtPtr$SafePtrConsumer;
import org.sqlite.core.SafeStmtPtr$SafePtrDoubleFunction;
import org.sqlite.core.SafeStmtPtr$SafePtrFunction;
import org.sqlite.core.SafeStmtPtr$SafePtrIntFunction;
import org.sqlite.core.SafeStmtPtr$SafePtrLongFunction;

public class SafeStmtPtr {
    private final DB db;
    private final long ptr;
    private volatile boolean closed = false;
    private int closedRC;
    private SQLException closeException;

    public SafeStmtPtr(DB dB, long l) {
        this.db = dB;
        this.ptr = l;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public int close() {
        DB dB = this.db;
        synchronized (dB) {
            return this.internalClose();
        }
    }

    private int internalClose() {
        try {
            if (this.closed) {
                if (this.closeException != null) {
                    throw this.closeException;
                }
                int n = this.closedRC;
                return n;
            }
            SafeStmtPtr safeStmtPtr = this;
            int n = this.closedRC = this.db.finalize(safeStmtPtr, safeStmtPtr.ptr);
            return n;
        }
        catch (SQLException sQLException) {
            this.closeException = sQLException;
            throw sQLException;
        }
        finally {
            this.closed = true;
        }
    }

    public <E extends Throwable> int safeRunInt(SafeStmtPtr$SafePtrIntFunction<E> safeStmtPtr$SafePtrIntFunction) {
        DB dB = this.db;
        synchronized (dB) {
            this.ensureOpen();
            return safeStmtPtr$SafePtrIntFunction.run(this.db, this.ptr);
        }
    }

    public <E extends Throwable> long safeRunLong(SafeStmtPtr$SafePtrLongFunction<E> safeStmtPtr$SafePtrLongFunction) {
        DB dB = this.db;
        synchronized (dB) {
            this.ensureOpen();
            return safeStmtPtr$SafePtrLongFunction.run(this.db, this.ptr);
        }
    }

    public <E extends Throwable> double safeRunDouble(SafeStmtPtr$SafePtrDoubleFunction<E> safeStmtPtr$SafePtrDoubleFunction) {
        DB dB = this.db;
        synchronized (dB) {
            this.ensureOpen();
            return safeStmtPtr$SafePtrDoubleFunction.run(this.db, this.ptr);
        }
    }

    public <T, E extends Throwable> T safeRun(SafeStmtPtr$SafePtrFunction<T, E> safeStmtPtr$SafePtrFunction) {
        DB dB = this.db;
        synchronized (dB) {
            this.ensureOpen();
            return safeStmtPtr$SafePtrFunction.run(this.db, this.ptr);
        }
    }

    public <E extends Throwable> void safeRunConsume(SafeStmtPtr$SafePtrConsumer<E> safeStmtPtr$SafePtrConsumer) {
        DB dB = this.db;
        synchronized (dB) {
            this.ensureOpen();
            safeStmtPtr$SafePtrConsumer.run(this.db, this.ptr);
            return;
        }
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new SQLException("stmt pointer is closed");
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (SafeStmtPtr)object;
        return this.ptr == ((SafeStmtPtr)object).ptr;
    }

    public int hashCode() {
        return Long.hashCode(this.ptr);
    }
}

