/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins.functions;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;

public abstract class FunctionTypeKind {
    private final FqName packageFqName;
    private final String classNamePrefix;
    private final boolean isReflectType;
    private final ClassId annotationOnInvokeClassId;

    public FunctionTypeKind(FqName fqName2, String string, boolean bl, ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        this.packageFqName = fqName2;
        this.classNamePrefix = string;
        this.isReflectType = bl;
        this.annotationOnInvokeClassId = classId;
    }

    public final FqName getPackageFqName() {
        return this.packageFqName;
    }

    public final String getClassNamePrefix() {
        return this.classNamePrefix;
    }

    public final Name numberedClassName(int n) {
        Name name = Name.identifier(this.classNamePrefix + n);
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
        return name;
    }

    public String toString() {
        return this.packageFqName + '.' + this.classNamePrefix + 'N';
    }
}

