/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins.jvm;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames$FqNames;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.load.kotlin.SignatureBuildingComponents;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;

public final class JvmBuiltInsSignatures {
    public static final JvmBuiltInsSignatures INSTANCE = new JvmBuiltInsSignatures();
    private static final Set<String> DROP_LIST_METHOD_SIGNATURES;
    private static final Set<String> HIDDEN_METHOD_SIGNATURES;
    private static final Set<String> DEPRECATED_LIST_METHODS;
    private static final Set<String> VISIBLE_METHOD_SIGNATURES;
    private static final Set<String> MUTABLE_METHOD_SIGNATURES;
    private static final Set<String> HIDDEN_CONSTRUCTOR_SIGNATURES;
    private static final Set<String> VISIBLE_CONSTRUCTOR_SIGNATURES;

    private JvmBuiltInsSignatures() {
    }

    public final Set<String> getDROP_LIST_METHOD_SIGNATURES() {
        return DROP_LIST_METHOD_SIGNATURES;
    }

    public final Set<String> getHIDDEN_METHOD_SIGNATURES() {
        return HIDDEN_METHOD_SIGNATURES;
    }

    private final Set<String> buildPrimitiveValueMethodsSet() {
        SignatureBuildingComponents signatureBuildingComponents = SignatureBuildingComponents.INSTANCE;
        JvmPrimitiveType[] jvmPrimitiveTypeArray = new JvmPrimitiveType[2];
        Object object = jvmPrimitiveTypeArray;
        jvmPrimitiveTypeArray[0] = JvmPrimitiveType.BOOLEAN;
        object[1] = JvmPrimitiveType.CHAR;
        object = CollectionsKt.listOf((Object[])object);
        Collection collection = new LinkedHashSet();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = (JvmPrimitiveType)((Object)object2);
            String string = ((JvmPrimitiveType)((Object)object2)).getWrapperFqName().shortName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            String[] stringArray = new String[1];
            String[] stringArray2 = stringArray;
            stringArray[0] = ((JvmPrimitiveType)((Object)object2)).getJavaKeywordName() + "Value()" + ((JvmPrimitiveType)((Object)object2)).getDesc();
            object2 = signatureBuildingComponents.inJavaLang(string, stringArray2);
            CollectionsKt.addAll((Collection)collection, (Iterable)object2);
        }
        return (LinkedHashSet)collection;
    }

    public final Set<String> getDEPRECATED_LIST_METHODS() {
        return DEPRECATED_LIST_METHODS;
    }

    public final Set<String> getVISIBLE_METHOD_SIGNATURES() {
        return VISIBLE_METHOD_SIGNATURES;
    }

    public final Set<String> getMUTABLE_METHOD_SIGNATURES() {
        return MUTABLE_METHOD_SIGNATURES;
    }

    public final Set<String> getHIDDEN_CONSTRUCTOR_SIGNATURES() {
        return HIDDEN_CONSTRUCTOR_SIGNATURES;
    }

    public final Set<String> getVISIBLE_CONSTRUCTOR_SIGNATURES() {
        return VISIBLE_CONSTRUCTOR_SIGNATURES;
    }

    private final Set<String> buildPrimitiveStringConstructorsSet() {
        SignatureBuildingComponents signatureBuildingComponents = SignatureBuildingComponents.INSTANCE;
        JvmPrimitiveType[] jvmPrimitiveTypeArray = new JvmPrimitiveType[8];
        Object object = jvmPrimitiveTypeArray;
        jvmPrimitiveTypeArray[0] = JvmPrimitiveType.BOOLEAN;
        object[1] = JvmPrimitiveType.BYTE;
        object[2] = JvmPrimitiveType.DOUBLE;
        object[3] = JvmPrimitiveType.FLOAT;
        object[4] = JvmPrimitiveType.BYTE;
        object[5] = JvmPrimitiveType.INT;
        object[6] = JvmPrimitiveType.LONG;
        object[7] = JvmPrimitiveType.SHORT;
        object = CollectionsKt.listOf((Object[])object);
        Collection collection = new LinkedHashSet();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = (JvmPrimitiveType)((Object)object2);
            String string = ((JvmPrimitiveType)((Object)object2)).getWrapperFqName().shortName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            String[] stringArray = new String[1];
            object2 = stringArray;
            stringArray[0] = "Ljava/lang/String;";
            object2 = signatureBuildingComponents.constructors((String[])object2);
            object2 = signatureBuildingComponents.inJavaLang(string, Arrays.copyOf(object2, ((Object)object2).length));
            CollectionsKt.addAll((Collection)collection, (Iterable)object2);
        }
        return (LinkedHashSet)collection;
    }

    public final boolean isSerializableInJava(FqNameUnsafe clazz) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"");
        if (this.isArrayOrPrimitiveArray((FqNameUnsafe)((Object)clazz))) {
            return true;
        }
        ClassId classId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava((FqNameUnsafe)((Object)clazz));
        if (classId == null) {
            return false;
        }
        clazz = classId;
        try {
            clazz = Class.forName(((ClassId)((Object)clazz)).asSingleFqName().asString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return Serializable.class.isAssignableFrom(clazz);
    }

    public final boolean isArrayOrPrimitiveArray(FqNameUnsafe fqNameUnsafe) {
        Intrinsics.checkNotNullParameter((Object)fqNameUnsafe, (String)"");
        return Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames$FqNames.array) || StandardNames.isPrimitiveArray(fqNameUnsafe);
    }

    static {
        String[] stringArray = new String[2];
        Object object = stringArray;
        stringArray[0] = "toArray()[Ljava/lang/Object;";
        object[1] = "toArray([Ljava/lang/Object;)[Ljava/lang/Object;";
        DROP_LIST_METHOD_SIGNATURES = SetsKt.plus(SignatureBuildingComponents.INSTANCE.inJavaUtil("Collection", (String[])object), (Object)"java/lang/annotation/Annotation.annotationType()Ljava/lang/Class;");
        object = SignatureBuildingComponents.INSTANCE;
        String[] stringArray2 = new String[2];
        String[] stringArray3 = stringArray2;
        stringArray2[0] = "sort(Ljava/util/Comparator;)V";
        stringArray3[1] = "reversed()Ljava/util/List;";
        Set set = SetsKt.plus(INSTANCE.buildPrimitiveValueMethodsSet(), (Iterable)((SignatureBuildingComponents)object).inJavaUtil("List", stringArray3));
        String[] stringArray4 = new String[48];
        stringArray3 = stringArray4;
        stringArray4[0] = "codePointAt(I)I";
        stringArray3[1] = "codePointBefore(I)I";
        stringArray3[2] = "codePointCount(II)I";
        stringArray3[3] = "compareToIgnoreCase(Ljava/lang/String;)I";
        stringArray3[4] = "concat(Ljava/lang/String;)Ljava/lang/String;";
        stringArray3[5] = "contains(Ljava/lang/CharSequence;)Z";
        stringArray3[6] = "contentEquals(Ljava/lang/CharSequence;)Z";
        stringArray3[7] = "contentEquals(Ljava/lang/StringBuffer;)Z";
        stringArray3[8] = "endsWith(Ljava/lang/String;)Z";
        stringArray3[9] = "equalsIgnoreCase(Ljava/lang/String;)Z";
        stringArray3[10] = "getBytes()[B";
        stringArray3[11] = "getBytes(II[BI)V";
        stringArray3[12] = "getBytes(Ljava/lang/String;)[B";
        stringArray3[13] = "getBytes(Ljava/nio/charset/Charset;)[B";
        stringArray3[14] = "getChars(II[CI)V";
        stringArray3[15] = "indexOf(I)I";
        stringArray3[16] = "indexOf(II)I";
        stringArray3[17] = "indexOf(Ljava/lang/String;)I";
        stringArray3[18] = "indexOf(Ljava/lang/String;I)I";
        stringArray3[19] = "intern()Ljava/lang/String;";
        stringArray3[20] = "isEmpty()Z";
        stringArray3[21] = "lastIndexOf(I)I";
        stringArray3[22] = "lastIndexOf(II)I";
        stringArray3[23] = "lastIndexOf(Ljava/lang/String;)I";
        stringArray3[24] = "lastIndexOf(Ljava/lang/String;I)I";
        stringArray3[25] = "matches(Ljava/lang/String;)Z";
        stringArray3[26] = "offsetByCodePoints(II)I";
        stringArray3[27] = "regionMatches(ILjava/lang/String;II)Z";
        stringArray3[28] = "regionMatches(ZILjava/lang/String;II)Z";
        stringArray3[29] = "replaceAll(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;";
        stringArray3[30] = "replace(CC)Ljava/lang/String;";
        stringArray3[31] = "replaceFirst(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;";
        stringArray3[32] = "replace(Ljava/lang/CharSequence;Ljava/lang/CharSequence;)Ljava/lang/String;";
        stringArray3[33] = "split(Ljava/lang/String;I)[Ljava/lang/String;";
        stringArray3[34] = "split(Ljava/lang/String;)[Ljava/lang/String;";
        stringArray3[35] = "startsWith(Ljava/lang/String;I)Z";
        stringArray3[36] = "startsWith(Ljava/lang/String;)Z";
        stringArray3[37] = "substring(II)Ljava/lang/String;";
        stringArray3[38] = "substring(I)Ljava/lang/String;";
        stringArray3[39] = "toCharArray()[C";
        stringArray3[40] = "toLowerCase()Ljava/lang/String;";
        stringArray3[41] = "toLowerCase(Ljava/util/Locale;)Ljava/lang/String;";
        stringArray3[42] = "toUpperCase()Ljava/lang/String;";
        stringArray3[43] = "toUpperCase(Ljava/util/Locale;)Ljava/lang/String;";
        stringArray3[44] = "trim()Ljava/lang/String;";
        stringArray3[45] = "isBlank()Z";
        stringArray3[46] = "lines()Ljava/util/stream/Stream;";
        stringArray3[47] = "repeat(I)Ljava/lang/String;";
        Set set2 = SetsKt.plus((Set)set, (Iterable)((SignatureBuildingComponents)object).inJavaLang("String", stringArray3));
        String[] stringArray5 = new String[2];
        stringArray3 = stringArray5;
        stringArray5[0] = "isInfinite()Z";
        stringArray3[1] = "isNaN()Z";
        Set set3 = SetsKt.plus((Set)set2, (Iterable)((SignatureBuildingComponents)object).inJavaLang("Double", stringArray3));
        String[] stringArray6 = new String[2];
        stringArray3 = stringArray6;
        stringArray6[0] = "isInfinite()Z";
        stringArray3[1] = "isNaN()Z";
        Set set4 = SetsKt.plus((Set)set3, (Iterable)((SignatureBuildingComponents)object).inJavaLang("Float", stringArray3));
        String[] stringArray7 = new String[2];
        stringArray3 = stringArray7;
        stringArray7[0] = "getDeclaringClass()Ljava/lang/Class;";
        stringArray3[1] = "finalize()V";
        Set set5 = SetsKt.plus((Set)set4, (Iterable)((SignatureBuildingComponents)object).inJavaLang("Enum", stringArray3));
        String[] stringArray8 = new String[1];
        stringArray3 = stringArray8;
        stringArray8[0] = "isEmpty()Z";
        HIDDEN_METHOD_SIGNATURES = SetsKt.plus((Set)set5, (Iterable)((SignatureBuildingComponents)object).inJavaLang("CharSequence", stringArray3));
        object = SignatureBuildingComponents.INSTANCE;
        String[] stringArray9 = new String[2];
        stringArray3 = stringArray9;
        stringArray9[0] = "getFirst()Ljava/lang/Object;";
        stringArray3[1] = "getLast()Ljava/lang/Object;";
        DEPRECATED_LIST_METHODS = ((SignatureBuildingComponents)object).inJavaUtil("List", stringArray3);
        object = SignatureBuildingComponents.INSTANCE;
        String[] stringArray10 = new String[2];
        stringArray3 = stringArray10;
        stringArray10[0] = "codePoints()Ljava/util/stream/IntStream;";
        stringArray3[1] = "chars()Ljava/util/stream/IntStream;";
        Set<String> set6 = ((SignatureBuildingComponents)object).inJavaLang("CharSequence", stringArray3);
        String[] stringArray11 = new String[1];
        stringArray3 = stringArray11;
        stringArray11[0] = "forEachRemaining(Ljava/util/function/Consumer;)V";
        Set set7 = SetsKt.plus(set6, (Iterable)((SignatureBuildingComponents)object).inJavaUtil("Iterator", stringArray3));
        String[] stringArray12 = new String[2];
        stringArray3 = stringArray12;
        stringArray12[0] = "forEach(Ljava/util/function/Consumer;)V";
        stringArray3[1] = "spliterator()Ljava/util/Spliterator;";
        Set set8 = SetsKt.plus((Set)set7, (Iterable)((SignatureBuildingComponents)object).inJavaLang("Iterable", stringArray3));
        String[] stringArray13 = new String[10];
        stringArray3 = stringArray13;
        stringArray13[0] = "setStackTrace([Ljava/lang/StackTraceElement;)V";
        stringArray3[1] = "fillInStackTrace()Ljava/lang/Throwable;";
        stringArray3[2] = "getLocalizedMessage()Ljava/lang/String;";
        stringArray3[3] = "printStackTrace()V";
        stringArray3[4] = "printStackTrace(Ljava/io/PrintStream;)V";
        stringArray3[5] = "printStackTrace(Ljava/io/PrintWriter;)V";
        stringArray3[6] = "getStackTrace()[Ljava/lang/StackTraceElement;";
        stringArray3[7] = "initCause(Ljava/lang/Throwable;)Ljava/lang/Throwable;";
        stringArray3[8] = "getSuppressed()[Ljava/lang/Throwable;";
        stringArray3[9] = "addSuppressed(Ljava/lang/Throwable;)V";
        Set set9 = SetsKt.plus((Set)set8, (Iterable)((SignatureBuildingComponents)object).inJavaLang("Throwable", stringArray3));
        String[] stringArray14 = new String[4];
        stringArray3 = stringArray14;
        stringArray14[0] = "spliterator()Ljava/util/Spliterator;";
        stringArray3[1] = "parallelStream()Ljava/util/stream/Stream;";
        stringArray3[2] = "stream()Ljava/util/stream/Stream;";
        stringArray3[3] = "removeIf(Ljava/util/function/Predicate;)Z";
        Set set10 = SetsKt.plus((Set)set9, (Iterable)((SignatureBuildingComponents)object).inJavaUtil("Collection", stringArray3));
        String[] stringArray15 = new String[5];
        stringArray3 = stringArray15;
        stringArray15[0] = "replaceAll(Ljava/util/function/UnaryOperator;)V";
        stringArray3[1] = "addFirst(Ljava/lang/Object;)V";
        stringArray3[2] = "addLast(Ljava/lang/Object;)V";
        stringArray3[3] = "removeFirst()Ljava/lang/Object;";
        stringArray3[4] = "removeLast()Ljava/lang/Object;";
        Set set11 = SetsKt.plus((Set)set10, (Iterable)((SignatureBuildingComponents)object).inJavaUtil("List", stringArray3));
        String[] stringArray16 = new String[10];
        stringArray3 = stringArray16;
        stringArray16[0] = "getOrDefault(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;";
        stringArray3[1] = "forEach(Ljava/util/function/BiConsumer;)V";
        stringArray3[2] = "replaceAll(Ljava/util/function/BiFunction;)V";
        stringArray3[3] = "merge(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;";
        stringArray3[4] = "computeIfPresent(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;";
        stringArray3[5] = "putIfAbsent(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;";
        stringArray3[6] = "replace(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z";
        stringArray3[7] = "replace(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;";
        stringArray3[8] = "computeIfAbsent(Ljava/lang/Object;Ljava/util/function/Function;)Ljava/lang/Object;";
        stringArray3[9] = "compute(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;";
        VISIBLE_METHOD_SIGNATURES = SetsKt.plus((Set)set11, (Iterable)((SignatureBuildingComponents)object).inJavaUtil("Map", stringArray3));
        object = SignatureBuildingComponents.INSTANCE;
        String[] stringArray17 = new String[1];
        stringArray3 = stringArray17;
        stringArray17[0] = "removeIf(Ljava/util/function/Predicate;)Z";
        Set<String> set12 = ((SignatureBuildingComponents)object).inJavaUtil("Collection", stringArray3);
        String[] stringArray18 = new String[2];
        stringArray3 = stringArray18;
        stringArray18[0] = "replaceAll(Ljava/util/function/UnaryOperator;)V";
        stringArray3[1] = "sort(Ljava/util/Comparator;)V";
        Set set13 = SetsKt.plus(set12, (Iterable)((SignatureBuildingComponents)object).inJavaUtil("List", stringArray3));
        String[] stringArray19 = new String[9];
        stringArray3 = stringArray19;
        stringArray19[0] = "computeIfAbsent(Ljava/lang/Object;Ljava/util/function/Function;)Ljava/lang/Object;";
        stringArray3[1] = "computeIfPresent(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;";
        stringArray3[2] = "compute(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;";
        stringArray3[3] = "merge(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;";
        stringArray3[4] = "putIfAbsent(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;";
        stringArray3[5] = "remove(Ljava/lang/Object;Ljava/lang/Object;)Z";
        stringArray3[6] = "replaceAll(Ljava/util/function/BiFunction;)V";
        stringArray3[7] = "replace(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;";
        stringArray3[8] = "replace(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z";
        MUTABLE_METHOD_SIGNATURES = SetsKt.plus((Set)set13, (Iterable)((SignatureBuildingComponents)object).inJavaUtil("Map", stringArray3));
        object = SignatureBuildingComponents.INSTANCE;
        String[] stringArray20 = new String[1];
        stringArray3 = stringArray20;
        stringArray20[0] = "D";
        stringArray3 = ((SignatureBuildingComponents)object).constructors(stringArray3);
        Set set14 = SetsKt.plus(INSTANCE.buildPrimitiveStringConstructorsSet(), (Iterable)((SignatureBuildingComponents)object).inJavaLang("Float", Arrays.copyOf(stringArray3, stringArray3.length)));
        String[] stringArray21 = new String[11];
        stringArray3 = stringArray21;
        stringArray21[0] = "[C";
        stringArray3[1] = "[CII";
        stringArray3[2] = "[III";
        stringArray3[3] = "[BIILjava/lang/String;";
        stringArray3[4] = "[BIILjava/nio/charset/Charset;";
        stringArray3[5] = "[BLjava/lang/String;";
        stringArray3[6] = "[BLjava/nio/charset/Charset;";
        stringArray3[7] = "[BII";
        stringArray3[8] = "[B";
        stringArray3[9] = "Ljava/lang/StringBuffer;";
        stringArray3[10] = "Ljava/lang/StringBuilder;";
        stringArray3 = ((SignatureBuildingComponents)object).constructors(stringArray3);
        HIDDEN_CONSTRUCTOR_SIGNATURES = SetsKt.plus((Set)set14, (Iterable)((SignatureBuildingComponents)object).inJavaLang("String", Arrays.copyOf(stringArray3, stringArray3.length)));
        object = SignatureBuildingComponents.INSTANCE;
        String[] stringArray22 = new String[1];
        stringArray3 = stringArray22;
        stringArray22[0] = "Ljava/lang/String;Ljava/lang/Throwable;ZZ";
        stringArray3 = ((SignatureBuildingComponents)object).constructors(stringArray3);
        VISIBLE_CONSTRUCTOR_SIGNATURES = ((SignatureBuildingComponents)object).inJavaLang("Throwable", Arrays.copyOf(stringArray3, stringArray3.length));
    }
}

