/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.kotlin.SignatureBuildingComponents$jvmDescriptor$1;

public final class SignatureBuildingComponents {
    public static final SignatureBuildingComponents INSTANCE = new SignatureBuildingComponents();

    private SignatureBuildingComponents() {
    }

    public final String javaLang(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return "java/lang/" + string;
    }

    public final String javaUtil(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return "java/util/" + string;
    }

    public final String javaFunction(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return "java/util/function/" + string;
    }

    public final String[] constructors(String ... object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Object object2 = object;
        object = new ArrayList(((Object)object).length);
        for (Object object3 : object2) {
            Object object4 = object;
            object4.add("<init>(" + (String)object3 + ")V");
        }
        object = (List)object;
        Collection collection = object;
        return object.toArray(new String[0]);
    }

    public final Set<String> inJavaLang(String string, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        SignatureBuildingComponents signatureBuildingComponents = this;
        return signatureBuildingComponents.inClass(signatureBuildingComponents.javaLang(string), Arrays.copyOf(stringArray, stringArray.length));
    }

    public final Set<String> inJavaUtil(String string, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        SignatureBuildingComponents signatureBuildingComponents = this;
        return signatureBuildingComponents.inClass(signatureBuildingComponents.javaUtil(string), Arrays.copyOf(stringArray, stringArray.length));
    }

    public final Set<String> inClass(String string, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        Collection collection = new LinkedHashSet();
        for (String string2 : stringArray) {
            Collection collection2 = collection;
            collection2.add(string + '.' + string2);
        }
        return (Set)collection;
    }

    public final String signature(String string, String string2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        return string + '.' + string2;
    }

    public final String jvmDescriptor(String string, List<String> list, String string2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        return string + '(' + CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"", null, null, (int)0, null, (Function1)SignatureBuildingComponents$jvmDescriptor$1.INSTANCE, (int)30, null) + ')' + this.escapeClassName(string2);
    }

    private final String escapeClassName(String string) {
        if (string.length() > 1) {
            return "L" + string + ';';
        }
        return string;
    }

    public static final /* synthetic */ String access$escapeClassName(SignatureBuildingComponents signatureBuildingComponents, String string) {
        return signatureBuildingComponents.escapeClassName(string);
    }
}

