/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.name;

import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.text.Regex;

public final class NameUtils {
    public static final NameUtils INSTANCE = new NameUtils();
    private static final Regex SANITIZE_AS_JAVA_INVALID_CHARACTERS = new Regex("[^\\p{L}\\p{Digit}]");
    private static final String CONTEXT_RECEIVER_PREFIX = "$context_receiver";

    private NameUtils() {
    }

    @JvmStatic
    public static final String sanitizeAsJavaIdentifier(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return SANITIZE_AS_JAVA_INVALID_CHARACTERS.replace((CharSequence)string, "_");
    }

    @JvmStatic
    public static final Name contextReceiverName(int n) {
        Name name = Name.identifier(CONTEXT_RECEIVER_PREFIX + '_' + n);
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
        return name;
    }
}

