/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.protobuf;

import java.io.OutputStream;
import java.util.ArrayList;
import kotlin.reflect.jvm.internal.impl.protobuf.ByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.LiteralByteString;

public final class ByteString$Output
extends OutputStream {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final int initialCapacity;
    private final ArrayList<ByteString> flushedBuffers;
    private int flushedBuffersTotalBytes;
    private byte[] buffer;
    private int bufferPos;

    ByteString$Output(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Buffer size < 0");
        }
        this.initialCapacity = n;
        this.flushedBuffers = new ArrayList();
        this.buffer = new byte[n];
    }

    @Override
    public final synchronized void write(int n) {
        if (this.bufferPos == this.buffer.length) {
            this.flushFullBuffer(1);
        }
        this.buffer[this.bufferPos++] = (byte)n;
    }

    @Override
    public final synchronized void write(byte[] byArray, int n, int n2) {
        if (n2 <= this.buffer.length - this.bufferPos) {
            System.arraycopy(byArray, n, this.buffer, this.bufferPos, n2);
            this.bufferPos += n2;
            return;
        }
        int n3 = this.buffer.length - this.bufferPos;
        System.arraycopy(byArray, n, this.buffer, this.bufferPos, n3);
        this.flushFullBuffer(n2 -= n3);
        System.arraycopy(byArray, n += n3, this.buffer, 0, n2);
        this.bufferPos = n2;
    }

    public final synchronized ByteString toByteString() {
        this.flushLastBuffer();
        return ByteString.copyFrom(this.flushedBuffers);
    }

    private byte[] copyArray(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, n));
        return byArray2;
    }

    public final synchronized int size() {
        return this.flushedBuffersTotalBytes + this.bufferPos;
    }

    public final String toString() {
        return String.format("<ByteString.Output@%s size=%d>", Integer.toHexString(System.identityHashCode(this)), this.size());
    }

    private void flushFullBuffer(int n) {
        this.flushedBuffers.add(new LiteralByteString(this.buffer));
        this.flushedBuffersTotalBytes += this.buffer.length;
        n = Math.max(this.initialCapacity, Math.max(n, this.flushedBuffersTotalBytes >>> 1));
        this.buffer = new byte[n];
        this.bufferPos = 0;
    }

    private void flushLastBuffer() {
        if (this.bufferPos < this.buffer.length) {
            if (this.bufferPos > 0) {
                ByteString$Output byteString$Output = this;
                byte[] byArray = byteString$Output.copyArray(byteString$Output.buffer, this.bufferPos);
                this.flushedBuffers.add(new LiteralByteString(byArray));
            }
        } else {
            this.flushedBuffers.add(new LiteralByteString(this.buffer));
            this.buffer = EMPTY_BYTE_ARRAY;
        }
        this.flushedBuffersTotalBytes += this.bufferPos;
        this.bufferPos = 0;
    }
}

