/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.scopes;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptorWithTypeParameters;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SimpleFunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.ChainedMemberScope$Companion;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindFilter;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScopeKt;
import kotlin.reflect.jvm.internal.impl.util.collectionUtils.ScopeUtilsKt;

public final class ChainedMemberScope
implements MemberScope {
    public static final ChainedMemberScope$Companion Companion = new ChainedMemberScope$Companion(null);
    private final String debugName;
    private final MemberScope[] scopes;

    private ChainedMemberScope(String string, MemberScope[] memberScopeArray) {
        this.debugName = string;
        this.scopes = memberScopeArray;
    }

    @Override
    public final ClassifierDescriptor getContributedClassifier(Name name, LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"");
        MemberScope[] memberScopeArray = this.scopes;
        Object object = null;
        for (MemberScope memberScope2 : memberScopeArray) {
            Object object2 = memberScope2;
            object2 = memberScope2;
            object2 = memberScope2.getContributedClassifier(name, lookupLocation);
            if (object2 == null) continue;
            if (object2 instanceof ClassifierDescriptorWithTypeParameters && ((ClassifierDescriptorWithTypeParameters)object2).isExpect()) {
                if (object != null) continue;
                object = object2;
                continue;
            }
            return object2;
        }
        return object;
    }

    public final Collection<PropertyDescriptor> getContributedVariables(Name name, LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"");
        MemberScope[] memberScopeArray = this.scopes;
        switch (this.scopes.length) {
            case 0: {
                return CollectionsKt.emptyList();
            }
            case 1: {
                MemberScope memberScope2 = memberScopeArray[0];
                return memberScope2.getContributedVariables(name, lookupLocation);
            }
        }
        Collection<? extends PropertyDescriptor> collection = null;
        for (MemberScope memberScope3 : memberScopeArray) {
            collection = ScopeUtilsKt.concat(collection, memberScope3.getContributedVariables(name, lookupLocation));
        }
        Collection<? extends PropertyDescriptor> collection2 = collection;
        if (collection2 == null) {
            collection2 = SetsKt.emptySet();
        }
        return collection2;
    }

    public final Collection<SimpleFunctionDescriptor> getContributedFunctions(Name name, LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"");
        MemberScope[] memberScopeArray = this.scopes;
        switch (this.scopes.length) {
            case 0: {
                return CollectionsKt.emptyList();
            }
            case 1: {
                MemberScope memberScope2 = memberScopeArray[0];
                return memberScope2.getContributedFunctions(name, lookupLocation);
            }
        }
        Collection<? extends SimpleFunctionDescriptor> collection = null;
        for (MemberScope memberScope3 : memberScopeArray) {
            collection = ScopeUtilsKt.concat(collection, memberScope3.getContributedFunctions(name, lookupLocation));
        }
        Collection<? extends SimpleFunctionDescriptor> collection2 = collection;
        if (collection2 == null) {
            collection2 = SetsKt.emptySet();
        }
        return collection2;
    }

    @Override
    public final Collection<DeclarationDescriptor> getContributedDescriptors(DescriptorKindFilter descriptorKindFilter, Function1<? super Name, Boolean> function1) {
        Intrinsics.checkNotNullParameter((Object)descriptorKindFilter, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        MemberScope[] memberScopeArray = this.scopes;
        switch (this.scopes.length) {
            case 0: {
                return CollectionsKt.emptyList();
            }
            case 1: {
                MemberScope memberScope2 = memberScopeArray[0];
                return memberScope2.getContributedDescriptors(descriptorKindFilter, function1);
            }
        }
        Collection<DeclarationDescriptor> collection = null;
        for (MemberScope memberScope3 : memberScopeArray) {
            collection = ScopeUtilsKt.concat(collection, memberScope3.getContributedDescriptors(descriptorKindFilter, function1));
        }
        Collection<DeclarationDescriptor> collection2 = collection;
        if (collection2 == null) {
            collection2 = SetsKt.emptySet();
        }
        return collection2;
    }

    @Override
    public final Set<Name> getFunctionNames() {
        MemberScope[] memberScopeArray = this.scopes;
        Collection collection = new LinkedHashSet();
        for (MemberScope memberScope2 : memberScopeArray) {
            Object object = memberScope2;
            object = memberScope2;
            object = memberScope2.getFunctionNames();
            CollectionsKt.addAll((Collection)collection, (Iterable)object);
        }
        return (Set)collection;
    }

    @Override
    public final Set<Name> getVariableNames() {
        MemberScope[] memberScopeArray = this.scopes;
        Collection collection = new LinkedHashSet();
        for (MemberScope memberScope2 : memberScopeArray) {
            Object object = memberScope2;
            object = memberScope2;
            object = memberScope2.getVariableNames();
            CollectionsKt.addAll((Collection)collection, (Iterable)object);
        }
        return (Set)collection;
    }

    @Override
    public final Set<Name> getClassifierNames() {
        return MemberScopeKt.flatMapClassifierNamesOrNull(ArraysKt.asIterable((Object[])this.scopes));
    }

    @Override
    public final void recordLookup(Name name, LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"");
        for (MemberScope memberScope2 : this.scopes) {
            MemberScope memberScope3 = memberScope2;
            memberScope3 = memberScope2;
            memberScope2.recordLookup(name, lookupLocation);
        }
    }

    public final String toString() {
        return this.debugName;
    }

    public static final /* synthetic */ MemberScope[] access$getScopes$p(ChainedMemberScope chainedMemberScope) {
        return chainedMemberScope.scopes;
    }

    public /* synthetic */ ChainedMemberScope(String string, MemberScope[] memberScopeArray, DefaultConstructorMarker defaultConstructorMarker) {
        this(string, memberScopeArray);
    }
}

