/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.DelegatingSimpleType;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.NotNullTypeParameter;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancementKt;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

public final class NotNullTypeParameterImpl
extends DelegatingSimpleType
implements NotNullTypeParameter {
    private final SimpleType delegate;

    public NotNullTypeParameterImpl(SimpleType simpleType2) {
        Intrinsics.checkNotNullParameter((Object)simpleType2, (String)"");
        this.delegate = simpleType2;
    }

    @Override
    protected final SimpleType getDelegate() {
        return this.delegate;
    }

    @Override
    public final boolean isTypeParameter() {
        return true;
    }

    @Override
    public final KotlinType substitutionResult(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        kotlinType = kotlinType.unwrap();
        if (!TypeUtilsKt.isTypeParameter(kotlinType) && !TypeUtils.isNullableType(kotlinType)) {
            return kotlinType;
        }
        KotlinType kotlinType2 = kotlinType;
        if (kotlinType2 instanceof SimpleType) {
            return this.prepareReplacement((SimpleType)kotlinType);
        }
        if (kotlinType2 instanceof FlexibleType) {
            return TypeWithEnhancementKt.wrapEnhancement(KotlinTypeFactory.flexibleType(this.prepareReplacement(((FlexibleType)kotlinType).getLowerBound()), this.prepareReplacement(((FlexibleType)kotlinType).getUpperBound())), TypeWithEnhancementKt.getEnhancement(kotlinType));
        }
        throw new IllegalStateException(("Incorrect type: " + kotlinType).toString());
    }

    @Override
    public final boolean isMarkedNullable() {
        return false;
    }

    private final SimpleType prepareReplacement(SimpleType simpleType2) {
        SimpleType simpleType3 = simpleType2.makeNullableAsSpecified(false);
        if (!TypeUtilsKt.isTypeParameter(simpleType2)) {
            return simpleType3;
        }
        return new NotNullTypeParameterImpl(simpleType3);
    }

    @Override
    public final NotNullTypeParameterImpl replaceAttributes(TypeAttributes typeAttributes) {
        Intrinsics.checkNotNullParameter((Object)typeAttributes, (String)"");
        return new NotNullTypeParameterImpl(this.getDelegate().replaceAttributes(typeAttributes));
    }

    @Override
    public final SimpleType makeNullableAsSpecified(boolean bl) {
        if (bl) {
            return this.getDelegate().makeNullableAsSpecified(true);
        }
        return this;
    }

    @Override
    public final NotNullTypeParameterImpl replaceDelegate(SimpleType simpleType2) {
        Intrinsics.checkNotNullParameter((Object)simpleType2, (String)"");
        return new NotNullTypeParameterImpl(simpleType2);
    }
}

