/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.matchers;

import org.quartz.Matcher;
import org.quartz.utils.Key;

public class OrMatcher<T extends Key<?>>
implements Matcher<T> {
    private static final long serialVersionUID = -2867392824539403712L;
    protected Matcher<T> leftOperand;
    protected Matcher<T> rightOperand;

    protected OrMatcher(Matcher<T> matcher, Matcher<T> matcher2) {
        if (matcher == null || matcher2 == null) {
            throw new IllegalArgumentException("Two non-null operands required!");
        }
        this.leftOperand = matcher;
        this.rightOperand = matcher2;
    }

    public static <U extends Key<?>> OrMatcher<U> or(Matcher<U> matcher, Matcher<U> matcher2) {
        return new OrMatcher<U>(matcher, matcher2);
    }

    @Override
    public boolean isMatch(T t) {
        return this.leftOperand.isMatch(t) || this.rightOperand.isMatch(t);
    }

    public Matcher<T> getLeftOperand() {
        return this.leftOperand;
    }

    public Matcher<T> getRightOperand() {
        return this.rightOperand;
    }

    @Override
    public int hashCode() {
        int n = 31 + (this.leftOperand == null ? 0 : this.leftOperand.hashCode());
        n = n * 31 + (this.rightOperand == null ? 0 : this.rightOperand.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (OrMatcher)object;
        if (this.leftOperand == null ? ((OrMatcher)object).leftOperand != null : !this.leftOperand.equals(((OrMatcher)object).leftOperand)) {
            return false;
        }
        return !(this.rightOperand == null ? ((OrMatcher)object).rightOperand != null : !this.rightOperand.equals(((OrMatcher)object).rightOperand));
    }
}

