/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.triggers;

import java.util.Date;
import java.util.TimeZone;
import org.quartz.Calendar;
import org.quartz.CalendarIntervalScheduleBuilder;
import org.quartz.CalendarIntervalTrigger;
import org.quartz.DateBuilder$IntervalUnit;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.impl.triggers.AbstractTrigger;
import org.quartz.impl.triggers.CoreTrigger;

public class CalendarIntervalTriggerImpl
extends AbstractTrigger<CalendarIntervalTrigger>
implements CalendarIntervalTrigger,
CoreTrigger {
    private static final long serialVersionUID = -2635982274232850343L;
    private static final int YEAR_TO_GIVEUP_SCHEDULING_AT = java.util.Calendar.getInstance().get(1) + 100;
    private Date startTime = null;
    private Date endTime = null;
    private Date nextFireTime = null;
    private Date previousFireTime = null;
    private int repeatInterval = 0;
    private DateBuilder$IntervalUnit repeatIntervalUnit = DateBuilder$IntervalUnit.DAY;
    private TimeZone timeZone;
    private boolean preserveHourOfDayAcrossDaylightSavings = false;
    private boolean skipDayIfHourDoesNotExist = false;
    private int timesTriggered = 0;
    private boolean complete = false;

    public CalendarIntervalTriggerImpl() {
    }

    public CalendarIntervalTriggerImpl(String string, DateBuilder$IntervalUnit dateBuilder$IntervalUnit, int n) {
        this(string, null, dateBuilder$IntervalUnit, n);
    }

    public CalendarIntervalTriggerImpl(String string, String string2, DateBuilder$IntervalUnit dateBuilder$IntervalUnit, int n) {
        this(string, string2, new Date(), null, dateBuilder$IntervalUnit, n);
    }

    public CalendarIntervalTriggerImpl(String string, Date date, Date date2, DateBuilder$IntervalUnit dateBuilder$IntervalUnit, int n) {
        this(string, null, date, date2, dateBuilder$IntervalUnit, n);
    }

    public CalendarIntervalTriggerImpl(String string, String string2, Date date, Date date2, DateBuilder$IntervalUnit dateBuilder$IntervalUnit, int n) {
        super(string, string2);
        this.setStartTime(date);
        this.setEndTime(date2);
        this.setRepeatIntervalUnit(dateBuilder$IntervalUnit);
        this.setRepeatInterval(n);
    }

    public CalendarIntervalTriggerImpl(String string, String string2, String string3, String string4, Date date, Date date2, DateBuilder$IntervalUnit dateBuilder$IntervalUnit, int n) {
        super(string, string2, string3, string4);
        this.setStartTime(date);
        this.setEndTime(date2);
        this.setRepeatIntervalUnit(dateBuilder$IntervalUnit);
        this.setRepeatInterval(n);
    }

    @Override
    public Date getStartTime() {
        if (this.startTime == null) {
            this.startTime = new Date();
        }
        return this.startTime;
    }

    @Override
    public void setStartTime(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Start time cannot be null");
        }
        Date date2 = this.getEndTime();
        if (date2 != null && date2.before(date)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        this.startTime = date;
    }

    @Override
    public Date getEndTime() {
        return this.endTime;
    }

    @Override
    public void setEndTime(Date date) {
        Date date2 = this.getStartTime();
        if (date2 != null && date != null && date2.after(date)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        this.endTime = date;
    }

    @Override
    public DateBuilder$IntervalUnit getRepeatIntervalUnit() {
        return this.repeatIntervalUnit;
    }

    public void setRepeatIntervalUnit(DateBuilder$IntervalUnit dateBuilder$IntervalUnit) {
        this.repeatIntervalUnit = dateBuilder$IntervalUnit;
    }

    @Override
    public int getRepeatInterval() {
        return this.repeatInterval;
    }

    public void setRepeatInterval(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Repeat interval must be >= 1");
        }
        this.repeatInterval = n;
    }

    @Override
    public TimeZone getTimeZone() {
        if (this.timeZone == null) {
            this.timeZone = TimeZone.getDefault();
        }
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public boolean isPreserveHourOfDayAcrossDaylightSavings() {
        return this.preserveHourOfDayAcrossDaylightSavings;
    }

    public void setPreserveHourOfDayAcrossDaylightSavings(boolean bl) {
        this.preserveHourOfDayAcrossDaylightSavings = bl;
    }

    @Override
    public boolean isSkipDayIfHourDoesNotExist() {
        return this.skipDayIfHourDoesNotExist;
    }

    public void setSkipDayIfHourDoesNotExist(boolean bl) {
        this.skipDayIfHourDoesNotExist = bl;
    }

    @Override
    public int getTimesTriggered() {
        return this.timesTriggered;
    }

    public void setTimesTriggered(int n) {
        this.timesTriggered = n;
    }

    @Override
    protected boolean validateMisfireInstruction(int n) {
        if (n < -1) {
            return false;
        }
        return n <= 2;
    }

    @Override
    public void updateAfterMisfire(Calendar calendar) {
        int n = this.getMisfireInstruction();
        if (n == -1) {
            return;
        }
        if (n == 0) {
            n = 1;
        }
        if (n == 2) {
            Date date = this.getFireTimeAfter(new Date());
            while (date != null && calendar != null && !calendar.isTimeIncluded(date.getTime())) {
                date = this.getFireTimeAfter(date);
            }
            this.setNextFireTime(date);
            return;
        }
        if (n == 1) {
            this.setNextFireTime(new Date());
        }
    }

    @Override
    public void triggered(Calendar calendar) {
        ++this.timesTriggered;
        this.previousFireTime = this.nextFireTime;
        this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        while (this.nextFireTime != null && calendar != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
            if (this.nextFireTime == null) break;
            java.util.Calendar calendar2 = java.util.Calendar.getInstance();
            calendar2.setTime(this.nextFireTime);
            if (calendar2.get(1) <= YEAR_TO_GIVEUP_SCHEDULING_AT) continue;
            this.nextFireTime = null;
        }
    }

    @Override
    public void updateWithNewCalendar(Calendar calendar, long l) {
        this.nextFireTime = this.getFireTimeAfter(this.previousFireTime);
        if (this.nextFireTime == null || calendar == null) {
            return;
        }
        Date date = new Date();
        while (this.nextFireTime != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
            long l2;
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
            if (this.nextFireTime == null) break;
            java.util.Calendar calendar2 = java.util.Calendar.getInstance();
            calendar2.setTime(this.nextFireTime);
            if (calendar2.get(1) > YEAR_TO_GIVEUP_SCHEDULING_AT) {
                this.nextFireTime = null;
            }
            if (this.nextFireTime == null || !this.nextFireTime.before(date) || (l2 = date.getTime() - this.nextFireTime.getTime()) < l) continue;
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        }
    }

    @Override
    public Date computeFirstFireTime(Calendar calendar) {
        this.nextFireTime = this.getStartTime();
        while (this.nextFireTime != null && calendar != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
            if (this.nextFireTime == null) break;
            java.util.Calendar calendar2 = java.util.Calendar.getInstance();
            calendar2.setTime(this.nextFireTime);
            if (calendar2.get(1) <= YEAR_TO_GIVEUP_SCHEDULING_AT) continue;
            return null;
        }
        return this.nextFireTime;
    }

    @Override
    public Date getNextFireTime() {
        return this.nextFireTime;
    }

    @Override
    public Date getPreviousFireTime() {
        return this.previousFireTime;
    }

    @Override
    public void setNextFireTime(Date date) {
        this.nextFireTime = date;
    }

    @Override
    public void setPreviousFireTime(Date date) {
        this.previousFireTime = date;
    }

    @Override
    public Date getFireTimeAfter(Date date) {
        return this.getFireTimeAfter(date, false);
    }

    protected Date getFireTimeAfter(Date date, boolean bl) {
        Date date2;
        long l;
        block30: {
            java.util.Calendar calendar;
            block27: {
                long l2;
                long l3;
                block29: {
                    block28: {
                        block26: {
                            if (this.complete) {
                                return null;
                            }
                            if (date == null) {
                                date = new Date();
                            }
                            long l4 = this.getStartTime().getTime();
                            long l5 = date.getTime();
                            long l6 = l = this.getEndTime() == null ? Long.MAX_VALUE : this.getEndTime().getTime();
                            if (!bl && l <= l5) {
                                return null;
                            }
                            if (l5 < l4) {
                                return new Date(l4);
                            }
                            l3 = 1L + (l5 - l4) / 1000L;
                            date2 = null;
                            l2 = this.getRepeatInterval();
                            calendar = java.util.Calendar.getInstance();
                            calendar.setTime(date);
                            calendar = java.util.Calendar.getInstance();
                            if (this.timeZone != null) {
                                calendar.setTimeZone(this.timeZone);
                            }
                            calendar.setTime(this.getStartTime());
                            calendar.setLenient(true);
                            if (!this.getRepeatIntervalUnit().equals((Object)DateBuilder$IntervalUnit.SECOND)) break block26;
                            long l7 = l3 / l2;
                            if (l3 % l2 != 0L) {
                                ++l7;
                            }
                            calendar.add(13, this.getRepeatInterval() * (int)l7);
                            break block27;
                        }
                        if (!this.getRepeatIntervalUnit().equals((Object)DateBuilder$IntervalUnit.MINUTE)) break block28;
                        long l8 = l3 / (l2 * 60L);
                        if (l3 % (l2 * 60L) != 0L) {
                            ++l8;
                        }
                        calendar.add(12, this.getRepeatInterval() * (int)l8);
                        break block27;
                    }
                    if (!this.getRepeatIntervalUnit().equals((Object)DateBuilder$IntervalUnit.HOUR)) break block29;
                    long l9 = l3 / (l2 * 60L * 60L);
                    if (l3 % (l2 * 60L * 60L) != 0L) {
                        ++l9;
                    }
                    calendar.add(11, this.getRepeatInterval() * (int)l9);
                    break block27;
                }
                int n = calendar.get(11);
                if (this.getRepeatIntervalUnit().equals((Object)DateBuilder$IntervalUnit.DAY)) {
                    calendar.setLenient(true);
                    long l10 = l3 / (l2 * 24L * 60L * 60L);
                    if (l10 > 20L) {
                        l10 = l10 < 50L ? (long)((double)l10 * 0.8) : (l10 < 500L ? (long)((double)l10 * 0.9) : (long)((double)l10 * 0.95));
                        calendar.add(6, (int)((long)this.getRepeatInterval() * l10));
                    }
                    while (!calendar.getTime().after(date) && calendar.get(1) < YEAR_TO_GIVEUP_SCHEDULING_AT) {
                        calendar.add(6, this.getRepeatInterval());
                    }
                    while (this.daylightSavingHourShiftOccurredAndAdvanceNeeded(calendar, n, date) && calendar.get(1) < YEAR_TO_GIVEUP_SCHEDULING_AT) {
                        calendar.add(6, this.getRepeatInterval());
                    }
                    date2 = calendar.getTime();
                } else if (this.getRepeatIntervalUnit().equals((Object)DateBuilder$IntervalUnit.WEEK)) {
                    calendar.setLenient(true);
                    long l11 = l3 / (l2 * 7L * 24L * 60L * 60L);
                    if (l11 > 20L) {
                        l11 = l11 < 50L ? (long)((double)l11 * 0.8) : (l11 < 500L ? (long)((double)l11 * 0.9) : (long)((double)l11 * 0.95));
                        calendar.add(3, (int)((long)this.getRepeatInterval() * l11));
                    }
                    while (!calendar.getTime().after(date) && calendar.get(1) < YEAR_TO_GIVEUP_SCHEDULING_AT) {
                        calendar.add(3, this.getRepeatInterval());
                    }
                    while (this.daylightSavingHourShiftOccurredAndAdvanceNeeded(calendar, n, date) && calendar.get(1) < YEAR_TO_GIVEUP_SCHEDULING_AT) {
                        calendar.add(3, this.getRepeatInterval());
                    }
                    date2 = calendar.getTime();
                } else if (this.getRepeatIntervalUnit().equals((Object)DateBuilder$IntervalUnit.MONTH)) {
                    calendar.setLenient(true);
                    while (!calendar.getTime().after(date) && calendar.get(1) < YEAR_TO_GIVEUP_SCHEDULING_AT) {
                        calendar.add(2, this.getRepeatInterval());
                    }
                    while (this.daylightSavingHourShiftOccurredAndAdvanceNeeded(calendar, n, date) && calendar.get(1) < YEAR_TO_GIVEUP_SCHEDULING_AT) {
                        calendar.add(2, this.getRepeatInterval());
                    }
                    date2 = calendar.getTime();
                } else if (this.getRepeatIntervalUnit().equals((Object)DateBuilder$IntervalUnit.YEAR)) {
                    while (!calendar.getTime().after(date) && calendar.get(1) < YEAR_TO_GIVEUP_SCHEDULING_AT) {
                        calendar.add(1, this.getRepeatInterval());
                    }
                    while (this.daylightSavingHourShiftOccurredAndAdvanceNeeded(calendar, n, date) && calendar.get(1) < YEAR_TO_GIVEUP_SCHEDULING_AT) {
                        calendar.add(1, this.getRepeatInterval());
                    }
                }
                break block30;
            }
            date2 = calendar.getTime();
        }
        if (!bl && l <= date2.getTime()) {
            return null;
        }
        return date2;
    }

    private boolean daylightSavingHourShiftOccurredAndAdvanceNeeded(java.util.Calendar calendar, int n, Date date) {
        if (this.isPreserveHourOfDayAcrossDaylightSavings() && calendar.get(11) != n) {
            calendar.set(11, n);
            if (calendar.get(11) != n) {
                return this.isSkipDayIfHourDoesNotExist();
            }
            return !calendar.getTime().after(date);
        }
        return false;
    }

    @Override
    public Date getFinalFireTime() {
        if (this.complete || this.getEndTime() == null) {
            return null;
        }
        Date date = new Date(this.getEndTime().getTime() - 1000L);
        if ((date = this.getFireTimeAfter(date, true)).equals(this.getEndTime())) {
            return date;
        }
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        if (this.timeZone != null) {
            calendar.setTimeZone(this.timeZone);
        }
        calendar.setTime(date);
        calendar.setLenient(true);
        if (this.getRepeatIntervalUnit().equals((Object)DateBuilder$IntervalUnit.SECOND)) {
            calendar.add(13, -1 * this.getRepeatInterval());
        } else if (this.getRepeatIntervalUnit().equals((Object)DateBuilder$IntervalUnit.MINUTE)) {
            calendar.add(12, -1 * this.getRepeatInterval());
        } else if (this.getRepeatIntervalUnit().equals((Object)DateBuilder$IntervalUnit.HOUR)) {
            calendar.add(11, -1 * this.getRepeatInterval());
        } else if (this.getRepeatIntervalUnit().equals((Object)DateBuilder$IntervalUnit.DAY)) {
            calendar.add(6, -1 * this.getRepeatInterval());
        } else if (this.getRepeatIntervalUnit().equals((Object)DateBuilder$IntervalUnit.WEEK)) {
            calendar.add(3, -1 * this.getRepeatInterval());
        } else if (this.getRepeatIntervalUnit().equals((Object)DateBuilder$IntervalUnit.MONTH)) {
            calendar.add(2, -1 * this.getRepeatInterval());
        } else if (this.getRepeatIntervalUnit().equals((Object)DateBuilder$IntervalUnit.YEAR)) {
            calendar.add(1, -1 * this.getRepeatInterval());
        }
        return calendar.getTime();
    }

    @Override
    public boolean mayFireAgain() {
        return this.getNextFireTime() != null;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.repeatInterval <= 0) {
            throw new SchedulerException("Repeat Interval cannot be zero.");
        }
    }

    @Override
    public ScheduleBuilder<CalendarIntervalTrigger> getScheduleBuilder() {
        CalendarIntervalScheduleBuilder calendarIntervalScheduleBuilder = CalendarIntervalScheduleBuilder.calendarIntervalSchedule().withInterval(this.getRepeatInterval(), this.getRepeatIntervalUnit());
        switch (this.getMisfireInstruction()) {
            case 2: {
                calendarIntervalScheduleBuilder.withMisfireHandlingInstructionDoNothing();
                break;
            }
            case 1: {
                calendarIntervalScheduleBuilder.withMisfireHandlingInstructionFireAndProceed();
            }
        }
        return calendarIntervalScheduleBuilder;
    }

    @Override
    public boolean hasAdditionalProperties() {
        return false;
    }
}

