/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core;

import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.quartz.Calendar;
import org.quartz.InterruptableJob;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.ListenerManager;
import org.quartz.Matcher;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.SchedulerMetaData;
import org.quartz.Trigger;
import org.quartz.Trigger$CompletedExecutionInstruction;
import org.quartz.Trigger$TriggerState;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.TriggerListener;
import org.quartz.UnableToInterruptJobException;
import org.quartz.core.ErrorLogger;
import org.quartz.core.ExecutingJobsManager;
import org.quartz.core.ListenerManagerImpl;
import org.quartz.core.QuartzScheduler$1;
import org.quartz.core.QuartzSchedulerMBeanImpl;
import org.quartz.core.QuartzSchedulerResources;
import org.quartz.core.QuartzSchedulerThread;
import org.quartz.core.RemotableQuartzScheduler;
import org.quartz.core.SchedulerSignalerImpl;
import org.quartz.core.jmx.QuartzSchedulerMBean;
import org.quartz.impl.SchedulerRepository;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.simpl.PropertySettingJobFactory;
import org.quartz.spi.JobFactory;
import org.quartz.spi.OperableTrigger;
import org.quartz.spi.SchedulerPlugin;
import org.quartz.spi.SchedulerSignaler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzScheduler
implements RemotableQuartzScheduler {
    private static String VERSION_MAJOR = "UNKNOWN";
    private static String VERSION_MINOR = "UNKNOWN";
    private static String VERSION_ITERATION = "UNKNOWN";
    private QuartzSchedulerResources resources;
    private QuartzSchedulerThread schedThread;
    private ThreadGroup threadGroup;
    private SchedulerContext context = new SchedulerContext();
    private ListenerManager listenerManager = new ListenerManagerImpl();
    private HashMap<String, JobListener> internalJobListeners = new HashMap(10);
    private HashMap<String, TriggerListener> internalTriggerListeners = new HashMap(10);
    private ArrayList<SchedulerListener> internalSchedulerListeners = new ArrayList(10);
    private JobFactory jobFactory = new PropertySettingJobFactory();
    ExecutingJobsManager jobMgr = null;
    ErrorLogger errLogger = null;
    private SchedulerSignaler signaler;
    private Random random = new Random();
    private ArrayList<Object> holdToPreventGC = new ArrayList(5);
    private boolean signalOnSchedulingChange = true;
    private volatile boolean closed = false;
    private volatile boolean shuttingDown = false;
    private boolean boundRemotely = false;
    private QuartzSchedulerMBean jmxBean = null;
    private Date initialStart = null;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public QuartzScheduler(QuartzSchedulerResources object, long l, long l2) {
        this.resources = object;
        if (((QuartzSchedulerResources)object).getJobStore() instanceof JobListener) {
            this.addInternalJobListener((JobListener)((Object)((QuartzSchedulerResources)object).getJobStore()));
        }
        this.schedThread = new QuartzSchedulerThread(this, (QuartzSchedulerResources)object);
        object = ((QuartzSchedulerResources)object).getThreadExecutor();
        object.execute(this.schedThread);
        if (l > 0L) {
            this.schedThread.setIdleWaitTime(l);
        }
        this.jobMgr = new ExecutingJobsManager();
        QuartzScheduler quartzScheduler = this;
        quartzScheduler.addInternalJobListener(quartzScheduler.jobMgr);
        this.errLogger = new ErrorLogger();
        QuartzScheduler quartzScheduler2 = this;
        quartzScheduler2.addInternalSchedulerListener(quartzScheduler2.errLogger);
        QuartzScheduler quartzScheduler3 = this;
        this.signaler = new SchedulerSignalerImpl(quartzScheduler3, quartzScheduler3.schedThread);
        this.getLog().info("Quartz Scheduler v." + this.getVersion() + " created.");
    }

    public void initialize() {
        try {
            this.bind();
        }
        catch (Exception exception) {
            throw new SchedulerException("Unable to bind scheduler to RMI Registry.", exception);
        }
        if (this.resources.getJMXExport()) {
            try {
                this.registerJMX();
            }
            catch (Exception exception) {
                throw new SchedulerException("Unable to register scheduler with MBeanServer.", exception);
            }
        }
        this.getLog().info("Scheduler meta-data: " + new SchedulerMetaData(this.getSchedulerName(), this.getSchedulerInstanceId(), this.getClass(), this.boundRemotely, this.runningSince() != null, this.isInStandbyMode(), this.isShutdown(), this.runningSince(), this.numJobsExecuted(), this.getJobStoreClass(), this.supportsPersistence(), this.isClustered(), this.getThreadPoolClass(), this.getThreadPoolSize(), this.getVersion()).toString());
    }

    @Override
    public String getVersion() {
        return QuartzScheduler.getVersionMajor() + "." + QuartzScheduler.getVersionMinor() + "." + QuartzScheduler.getVersionIteration();
    }

    public static String getVersionMajor() {
        return VERSION_MAJOR;
    }

    public static String getVersionMinor() {
        return VERSION_MINOR;
    }

    public static String getVersionIteration() {
        return VERSION_ITERATION;
    }

    public SchedulerSignaler getSchedulerSignaler() {
        return this.signaler;
    }

    public Logger getLog() {
        return this.log;
    }

    private void registerJMX() {
        String string = this.resources.getJMXObjectName();
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        this.jmxBean = new QuartzSchedulerMBeanImpl(this);
        mBeanServer.registerMBean(this.jmxBean, new ObjectName(string));
    }

    private void unregisterJMX() {
        String string = this.resources.getJMXObjectName();
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        mBeanServer.unregisterMBean(new ObjectName(string));
        this.jmxBean.setSampledStatisticsEnabled(false);
        this.getLog().info("Scheduler unregistered from name '" + string + "' in the local MBeanServer.");
    }

    private void bind() {
        Registry registry;
        Object object = this.resources.getRMIRegistryHost();
        if (object == null || ((String)object).length() == 0) {
            return;
        }
        if (this.resources.getRMIServerPort() > 0) {
            QuartzScheduler quartzScheduler = this;
            object = (RemotableQuartzScheduler)UnicastRemoteObject.exportObject((Remote)quartzScheduler, quartzScheduler.resources.getRMIServerPort());
        } else {
            object = (RemotableQuartzScheduler)((Object)UnicastRemoteObject.exportObject(this));
        }
        if (this.resources.getRMICreateRegistryStrategy().equals("as_needed")) {
            try {
                registry = LocateRegistry.getRegistry(this.resources.getRMIRegistryPort());
                registry.list();
            }
            catch (Exception exception) {
                registry = LocateRegistry.createRegistry(this.resources.getRMIRegistryPort());
            }
        } else if (this.resources.getRMICreateRegistryStrategy().equals("always")) {
            try {
                registry = LocateRegistry.createRegistry(this.resources.getRMIRegistryPort());
            }
            catch (Exception exception) {
                registry = LocateRegistry.getRegistry(this.resources.getRMIRegistryPort());
            }
        } else {
            registry = LocateRegistry.getRegistry(this.resources.getRMIRegistryHost(), this.resources.getRMIRegistryPort());
        }
        String string = this.resources.getRMIBindName();
        registry.rebind(string, (Remote)object);
        this.boundRemotely = true;
        this.getLog().info("Scheduler bound to RMI registry under name '" + string + "'");
    }

    private void unBind() {
        Object object = this.resources.getRMIRegistryHost();
        if (object == null || ((String)object).length() == 0) {
            return;
        }
        object = LocateRegistry.getRegistry(this.resources.getRMIRegistryHost(), this.resources.getRMIRegistryPort());
        String string = this.resources.getRMIBindName();
        try {
            object.unbind(string);
            UnicastRemoteObject.unexportObject(this, true);
        }
        catch (NotBoundException notBoundException) {}
        this.getLog().info("Scheduler un-bound from name '" + string + "' in RMI registry");
    }

    @Override
    public String getSchedulerName() {
        return this.resources.getName();
    }

    @Override
    public String getSchedulerInstanceId() {
        return this.resources.getInstanceId();
    }

    public ThreadGroup getSchedulerThreadGroup() {
        if (this.threadGroup == null) {
            this.threadGroup = new ThreadGroup("QuartzScheduler:" + this.getSchedulerName());
            if (this.resources.getMakeSchedulerThreadDaemon()) {
                this.threadGroup.setDaemon(true);
            }
        }
        return this.threadGroup;
    }

    public void addNoGCObject(Object object) {
        this.holdToPreventGC.add(object);
    }

    public boolean removeNoGCObject(Object object) {
        return this.holdToPreventGC.remove(object);
    }

    @Override
    public SchedulerContext getSchedulerContext() {
        return this.context;
    }

    public boolean isSignalOnSchedulingChange() {
        return this.signalOnSchedulingChange;
    }

    public void setSignalOnSchedulingChange(boolean bl) {
        this.signalOnSchedulingChange = bl;
    }

    @Override
    public void start() {
        if (this.shuttingDown || this.closed) {
            throw new SchedulerException("The Scheduler cannot be restarted after shutdown() has been called.");
        }
        this.notifySchedulerListenersStarting();
        if (this.initialStart == null) {
            this.initialStart = new Date();
            this.resources.getJobStore().schedulerStarted();
            this.startPlugins();
        } else {
            this.resources.getJobStore().schedulerResumed();
        }
        this.schedThread.togglePause(false);
        this.getLog().info("Scheduler " + this.resources.getUniqueIdentifier() + " started.");
        this.notifySchedulerListenersStarted();
    }

    @Override
    public void startDelayed(int n) {
        if (this.shuttingDown || this.closed) {
            throw new SchedulerException("The Scheduler cannot be restarted after shutdown() has been called.");
        }
        Thread thread = new Thread(new QuartzScheduler$1(this, n));
        thread.start();
    }

    @Override
    public void standby() {
        this.resources.getJobStore().schedulerPaused();
        this.schedThread.togglePause(true);
        this.getLog().info("Scheduler " + this.resources.getUniqueIdentifier() + " paused.");
        this.notifySchedulerListenersInStandbyMode();
    }

    @Override
    public boolean isInStandbyMode() {
        return this.schedThread.isPaused();
    }

    @Override
    public Date runningSince() {
        if (this.initialStart == null) {
            return null;
        }
        return new Date(this.initialStart.getTime());
    }

    @Override
    public int numJobsExecuted() {
        return this.jobMgr.getNumJobsFired();
    }

    @Override
    public Class<?> getJobStoreClass() {
        return this.resources.getJobStore().getClass();
    }

    @Override
    public boolean supportsPersistence() {
        return this.resources.getJobStore().supportsPersistence();
    }

    @Override
    public boolean isClustered() {
        return this.resources.getJobStore().isClustered();
    }

    @Override
    public Class<?> getThreadPoolClass() {
        return this.resources.getThreadPool().getClass();
    }

    @Override
    public int getThreadPoolSize() {
        return this.resources.getThreadPool().getPoolSize();
    }

    @Override
    public void shutdown() {
        this.shutdown(false);
    }

    @Override
    public void shutdown(boolean bl) {
        if (this.shuttingDown || this.closed) {
            return;
        }
        this.shuttingDown = true;
        this.getLog().info("Scheduler " + this.resources.getUniqueIdentifier() + " shutting down.");
        this.standby();
        this.schedThread.halt(bl);
        this.notifySchedulerListenersShuttingdown();
        if (this.resources.isInterruptJobsOnShutdown() && !bl || this.resources.isInterruptJobsOnShutdownWithWait() && bl) {
            Object object = this.getCurrentlyExecutingJobs();
            object = object.iterator();
            while (object.hasNext()) {
                JobExecutionContext jobExecutionContext = (JobExecutionContext)object.next();
                if (!(jobExecutionContext.getJobInstance() instanceof InterruptableJob)) continue;
                try {
                    ((InterruptableJob)jobExecutionContext.getJobInstance()).interrupt();
                }
                catch (Throwable throwable) {
                    this.getLog().warn("Encountered error when interrupting job {} during shutdown: {}", (Object)jobExecutionContext.getJobDetail().getKey(), (Object)throwable);
                }
            }
        }
        this.resources.getThreadPool().shutdown(bl);
        this.closed = true;
        if (this.resources.getJMXExport()) {
            try {
                this.unregisterJMX();
            }
            catch (Exception exception) {}
        }
        if (this.boundRemotely) {
            try {
                this.unBind();
            }
            catch (RemoteException remoteException) {}
        }
        this.shutdownPlugins();
        this.resources.getJobStore().shutdown();
        this.notifySchedulerListenersShutdown();
        SchedulerRepository.getInstance().remove(this.resources.getName());
        this.holdToPreventGC.clear();
        this.getLog().info("Scheduler " + this.resources.getUniqueIdentifier() + " shutdown complete.");
    }

    @Override
    public boolean isShutdown() {
        return this.closed;
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    public boolean isStarted() {
        return !this.shuttingDown && !this.closed && !this.isInStandbyMode() && this.initialStart != null;
    }

    public void validateState() {
        if (this.isShutdown()) {
            throw new SchedulerException("The Scheduler has been shutdown.");
        }
    }

    @Override
    public List<JobExecutionContext> getCurrentlyExecutingJobs() {
        return this.jobMgr.getExecutingJobs();
    }

    @Override
    public Date scheduleJob(JobDetail jobDetail, Trigger trigger) {
        this.validateState();
        if (jobDetail == null) {
            throw new SchedulerException("JobDetail cannot be null");
        }
        if (trigger == null) {
            throw new SchedulerException("Trigger cannot be null");
        }
        if (jobDetail.getKey() == null) {
            throw new SchedulerException("Job's key cannot be null");
        }
        if (jobDetail.getJobClass() == null) {
            throw new SchedulerException("Job's class cannot be null");
        }
        OperableTrigger operableTrigger = (OperableTrigger)trigger;
        if (trigger.getJobKey() == null) {
            operableTrigger.setJobKey(jobDetail.getKey());
        } else if (!trigger.getJobKey().equals(jobDetail.getKey())) {
            throw new SchedulerException("Trigger does not reference given job!");
        }
        operableTrigger.validate();
        Cloneable cloneable = null;
        if (trigger.getCalendarName() != null) {
            cloneable = this.resources.getJobStore().retrieveCalendar(trigger.getCalendarName());
        }
        if ((cloneable = operableTrigger.computeFirstFireTime((Calendar)cloneable)) == null) {
            throw new SchedulerException("Based on configured schedule, the given trigger '" + trigger.getKey() + "' will never fire.");
        }
        this.resources.getJobStore().storeJobAndTrigger(jobDetail, operableTrigger);
        this.notifySchedulerListenersJobAdded(jobDetail);
        this.notifySchedulerThread(trigger.getNextFireTime().getTime());
        this.notifySchedulerListenersSchduled(trigger);
        return cloneable;
    }

    @Override
    public Date scheduleJob(Trigger trigger) {
        this.validateState();
        if (trigger == null) {
            throw new SchedulerException("Trigger cannot be null");
        }
        OperableTrigger operableTrigger = (OperableTrigger)trigger;
        operableTrigger.validate();
        Cloneable cloneable = null;
        if (trigger.getCalendarName() != null && (cloneable = this.resources.getJobStore().retrieveCalendar(trigger.getCalendarName())) == null) {
            throw new SchedulerException("Calendar not found: " + trigger.getCalendarName());
        }
        if ((cloneable = operableTrigger.computeFirstFireTime((Calendar)cloneable)) == null) {
            throw new SchedulerException("Based on configured schedule, the given trigger '" + trigger.getKey() + "' will never fire.");
        }
        this.resources.getJobStore().storeTrigger(operableTrigger, false);
        this.notifySchedulerThread(trigger.getNextFireTime().getTime());
        this.notifySchedulerListenersSchduled(trigger);
        return cloneable;
    }

    @Override
    public void addJob(JobDetail jobDetail, boolean bl) {
        this.addJob(jobDetail, bl, false);
    }

    @Override
    public void addJob(JobDetail jobDetail, boolean bl, boolean bl2) {
        this.validateState();
        if (!bl2 && !jobDetail.isDurable()) {
            throw new SchedulerException("Jobs added with no trigger must be durable.");
        }
        this.resources.getJobStore().storeJob(jobDetail, bl);
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersJobAdded(jobDetail);
    }

    @Override
    public boolean deleteJob(JobKey comparable) {
        this.validateState();
        boolean bl = false;
        Object object = this.getTriggersOfJob((JobKey)comparable);
        object = object.iterator();
        while (object.hasNext()) {
            Trigger trigger = (Trigger)object.next();
            if (!this.unscheduleJob(trigger.getKey())) {
                comparable = new StringBuilder("Unable to unschedule trigger [").append(trigger.getKey()).append("] while deleting job [").append(comparable).append("]");
                throw new SchedulerException(((StringBuilder)comparable).toString());
            }
            bl = true;
        }
        bl = this.resources.getJobStore().removeJob((JobKey)comparable) || bl;
        if (bl) {
            this.notifySchedulerThread(0L);
            this.notifySchedulerListenersJobDeleted((JobKey)comparable);
        }
        return bl;
    }

    @Override
    public boolean deleteJobs(List<JobKey> object) {
        this.validateState();
        boolean bl = this.resources.getJobStore().removeJobs((List<JobKey>)object);
        this.notifySchedulerThread(0L);
        object = object.iterator();
        while (object.hasNext()) {
            JobKey jobKey = (JobKey)object.next();
            this.notifySchedulerListenersJobDeleted(jobKey);
        }
        return bl;
    }

    @Override
    public void scheduleJobs(Map<JobDetail, Set<? extends Trigger>> map, boolean bl) {
        Object object;
        this.validateState();
        for (Map.Entry<JobDetail, Set<? extends Trigger>> entry : map.entrySet()) {
            Set<? extends Trigger> set;
            object = entry.getKey();
            if (object == null || (set = entry.getValue()) == null) continue;
            for (Trigger trigger : set) {
                OperableTrigger operableTrigger = (OperableTrigger)trigger;
                operableTrigger.setJobKey(object.getKey());
                operableTrigger.validate();
                Calendar calendar = null;
                if (trigger.getCalendarName() != null && (calendar = this.resources.getJobStore().retrieveCalendar(trigger.getCalendarName())) == null) {
                    throw new SchedulerException("Calendar '" + trigger.getCalendarName() + "' not found for trigger: " + trigger.getKey());
                }
                Date date = operableTrigger.computeFirstFireTime(calendar);
                if (date != null) continue;
                throw new SchedulerException("Based on configured schedule, the given trigger will never fire.");
            }
        }
        this.resources.getJobStore().storeJobsAndTriggers(map, bl);
        this.notifySchedulerThread(0L);
        for (JobDetail jobDetail : map.keySet()) {
            this.notifySchedulerListenersJobAdded(jobDetail);
            object = map.get(jobDetail);
            Iterator<? extends Trigger> iterator = object.iterator();
            while (iterator.hasNext()) {
                Trigger trigger = iterator.next();
                this.notifySchedulerListenersSchduled(trigger);
            }
        }
    }

    @Override
    public void scheduleJob(JobDetail jobDetail, Set<? extends Trigger> set, boolean bl) {
        HashMap<JobDetail, Set<? extends Trigger>> hashMap = new HashMap<JobDetail, Set<? extends Trigger>>();
        hashMap.put(jobDetail, set);
        this.scheduleJobs(hashMap, bl);
    }

    @Override
    public boolean unscheduleJobs(List<TriggerKey> object) {
        this.validateState();
        boolean bl = this.resources.getJobStore().removeTriggers((List<TriggerKey>)object);
        this.notifySchedulerThread(0L);
        object = object.iterator();
        while (object.hasNext()) {
            TriggerKey triggerKey = (TriggerKey)object.next();
            this.notifySchedulerListenersUnscheduled(triggerKey);
        }
        return bl;
    }

    @Override
    public boolean unscheduleJob(TriggerKey triggerKey) {
        this.validateState();
        if (!this.resources.getJobStore().removeTrigger(triggerKey)) {
            return false;
        }
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersUnscheduled(triggerKey);
        return true;
    }

    @Override
    public Date rescheduleJob(TriggerKey triggerKey, Trigger trigger) {
        this.validateState();
        if (triggerKey == null) {
            throw new IllegalArgumentException("triggerKey cannot be null");
        }
        if (trigger == null) {
            throw new IllegalArgumentException("newTrigger cannot be null");
        }
        OperableTrigger operableTrigger = (OperableTrigger)trigger;
        Cloneable cloneable = this.getTrigger(triggerKey);
        if (cloneable == null) {
            return null;
        }
        operableTrigger.setJobKey(cloneable.getJobKey());
        operableTrigger.validate();
        cloneable = null;
        if (trigger.getCalendarName() != null) {
            cloneable = this.resources.getJobStore().retrieveCalendar(trigger.getCalendarName());
        }
        if ((cloneable = operableTrigger.computeFirstFireTime((Calendar)cloneable)) == null) {
            throw new SchedulerException("Based on configured schedule, the given trigger will never fire.");
        }
        if (!this.resources.getJobStore().replaceTrigger(triggerKey, operableTrigger)) {
            return null;
        }
        this.notifySchedulerThread(trigger.getNextFireTime().getTime());
        this.notifySchedulerListenersUnscheduled(triggerKey);
        this.notifySchedulerListenersSchduled(trigger);
        return cloneable;
    }

    private String newTriggerId() {
        long l = this.random.nextLong();
        if (l < 0L) {
            l = -l;
        }
        return "MT_" + Long.toString(l, 30 + (int)(System.currentTimeMillis() % 7L));
    }

    @Override
    public void triggerJob(JobKey comparable, JobDataMap jobDataMap) {
        this.validateState();
        comparable = (OperableTrigger)TriggerBuilder.newTrigger().withIdentity(this.newTriggerId(), "DEFAULT").forJob((JobKey)comparable).build();
        comparable.computeFirstFireTime(null);
        if (jobDataMap != null) {
            comparable.setJobDataMap(jobDataMap);
        }
        boolean bl = true;
        while (bl) {
            try {
                this.resources.getJobStore().storeTrigger((OperableTrigger)comparable, false);
                bl = false;
            }
            catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
                comparable.setKey(new TriggerKey(this.newTriggerId(), "DEFAULT"));
            }
        }
        this.notifySchedulerThread(comparable.getNextFireTime().getTime());
        this.notifySchedulerListenersSchduled((Trigger)comparable);
    }

    @Override
    public void triggerJob(OperableTrigger operableTrigger) {
        this.validateState();
        operableTrigger.computeFirstFireTime(null);
        boolean bl = true;
        while (bl) {
            try {
                this.resources.getJobStore().storeTrigger(operableTrigger, false);
                bl = false;
            }
            catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
                operableTrigger.setKey(new TriggerKey(this.newTriggerId(), "DEFAULT"));
            }
        }
        this.notifySchedulerThread(operableTrigger.getNextFireTime().getTime());
        this.notifySchedulerListenersSchduled(operableTrigger);
    }

    @Override
    public void pauseTrigger(TriggerKey triggerKey) {
        this.validateState();
        this.resources.getJobStore().pauseTrigger(triggerKey);
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersPausedTrigger(triggerKey);
    }

    @Override
    public void pauseTriggers(GroupMatcher<TriggerKey> iterator) {
        this.validateState();
        if (iterator == null) {
            iterator = GroupMatcher.groupEquals("DEFAULT");
        }
        iterator = this.resources.getJobStore().pauseTriggers((GroupMatcher<TriggerKey>)((Object)iterator));
        this.notifySchedulerThread(0L);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.notifySchedulerListenersPausedTriggers(string);
        }
    }

    @Override
    public void pauseJob(JobKey jobKey) {
        this.validateState();
        this.resources.getJobStore().pauseJob(jobKey);
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersPausedJob(jobKey);
    }

    @Override
    public void pauseJobs(GroupMatcher<JobKey> iterator) {
        this.validateState();
        if (iterator == null) {
            iterator = GroupMatcher.groupEquals("DEFAULT");
        }
        iterator = this.resources.getJobStore().pauseJobs((GroupMatcher<JobKey>)((Object)iterator));
        this.notifySchedulerThread(0L);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.notifySchedulerListenersPausedJobs(string);
        }
    }

    @Override
    public void resumeTrigger(TriggerKey triggerKey) {
        this.validateState();
        this.resources.getJobStore().resumeTrigger(triggerKey);
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersResumedTrigger(triggerKey);
    }

    @Override
    public void resumeTriggers(GroupMatcher<TriggerKey> iterator) {
        this.validateState();
        if (iterator == null) {
            iterator = GroupMatcher.groupEquals("DEFAULT");
        }
        iterator = this.resources.getJobStore().resumeTriggers((GroupMatcher<TriggerKey>)((Object)iterator));
        this.notifySchedulerThread(0L);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.notifySchedulerListenersResumedTriggers(string);
        }
    }

    @Override
    public Set<String> getPausedTriggerGroups() {
        return this.resources.getJobStore().getPausedTriggerGroups();
    }

    @Override
    public void resumeJob(JobKey jobKey) {
        this.validateState();
        this.resources.getJobStore().resumeJob(jobKey);
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersResumedJob(jobKey);
    }

    @Override
    public void resumeJobs(GroupMatcher<JobKey> iterator) {
        this.validateState();
        if (iterator == null) {
            iterator = GroupMatcher.groupEquals("DEFAULT");
        }
        iterator = this.resources.getJobStore().resumeJobs((GroupMatcher<JobKey>)((Object)iterator));
        this.notifySchedulerThread(0L);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.notifySchedulerListenersResumedJobs(string);
        }
    }

    @Override
    public void pauseAll() {
        this.validateState();
        this.resources.getJobStore().pauseAll();
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersPausedTriggers(null);
    }

    @Override
    public void resumeAll() {
        this.validateState();
        this.resources.getJobStore().resumeAll();
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersResumedTrigger(null);
    }

    @Override
    public List<String> getJobGroupNames() {
        this.validateState();
        return this.resources.getJobStore().getJobGroupNames();
    }

    @Override
    public Set<JobKey> getJobKeys(GroupMatcher<JobKey> groupMatcher) {
        this.validateState();
        if (groupMatcher == null) {
            groupMatcher = GroupMatcher.groupEquals("DEFAULT");
        }
        return this.resources.getJobStore().getJobKeys(groupMatcher);
    }

    @Override
    public List<? extends Trigger> getTriggersOfJob(JobKey jobKey) {
        this.validateState();
        return this.resources.getJobStore().getTriggersForJob(jobKey);
    }

    @Override
    public List<String> getTriggerGroupNames() {
        this.validateState();
        return this.resources.getJobStore().getTriggerGroupNames();
    }

    @Override
    public Set<TriggerKey> getTriggerKeys(GroupMatcher<TriggerKey> groupMatcher) {
        this.validateState();
        if (groupMatcher == null) {
            groupMatcher = GroupMatcher.groupEquals("DEFAULT");
        }
        return this.resources.getJobStore().getTriggerKeys(groupMatcher);
    }

    @Override
    public JobDetail getJobDetail(JobKey jobKey) {
        this.validateState();
        return this.resources.getJobStore().retrieveJob(jobKey);
    }

    @Override
    public Trigger getTrigger(TriggerKey triggerKey) {
        this.validateState();
        return this.resources.getJobStore().retrieveTrigger(triggerKey);
    }

    @Override
    public boolean checkExists(JobKey jobKey) {
        this.validateState();
        return this.resources.getJobStore().checkExists(jobKey);
    }

    @Override
    public boolean checkExists(TriggerKey triggerKey) {
        this.validateState();
        return this.resources.getJobStore().checkExists(triggerKey);
    }

    @Override
    public void clear() {
        this.validateState();
        this.resources.getJobStore().clearAllSchedulingData();
        this.notifySchedulerListenersUnscheduled(null);
    }

    @Override
    public Trigger$TriggerState getTriggerState(TriggerKey triggerKey) {
        this.validateState();
        return this.resources.getJobStore().getTriggerState(triggerKey);
    }

    @Override
    public void resetTriggerFromErrorState(TriggerKey triggerKey) {
        this.validateState();
        this.resources.getJobStore().resetTriggerFromErrorState(triggerKey);
    }

    @Override
    public void addCalendar(String string, Calendar calendar, boolean bl, boolean bl2) {
        this.validateState();
        this.resources.getJobStore().storeCalendar(string, calendar, bl, bl2);
    }

    @Override
    public boolean deleteCalendar(String string) {
        this.validateState();
        return this.resources.getJobStore().removeCalendar(string);
    }

    @Override
    public Calendar getCalendar(String string) {
        this.validateState();
        return this.resources.getJobStore().retrieveCalendar(string);
    }

    @Override
    public List<String> getCalendarNames() {
        this.validateState();
        return this.resources.getJobStore().getCalendarNames();
    }

    public ListenerManager getListenerManager() {
        return this.listenerManager;
    }

    public void addInternalJobListener(JobListener jobListener) {
        if (jobListener.getName() == null || jobListener.getName().length() == 0) {
            throw new IllegalArgumentException("JobListener name cannot be empty.");
        }
        HashMap<String, JobListener> hashMap = this.internalJobListeners;
        synchronized (hashMap) {
            this.internalJobListeners.put(jobListener.getName(), jobListener);
            return;
        }
    }

    public boolean removeInternalJobListener(String string) {
        HashMap<String, JobListener> hashMap = this.internalJobListeners;
        synchronized (hashMap) {
            return this.internalJobListeners.remove(string) != null;
        }
    }

    public List<JobListener> getInternalJobListeners() {
        HashMap<String, JobListener> hashMap = this.internalJobListeners;
        synchronized (hashMap) {
            return Collections.unmodifiableList(new LinkedList<JobListener>(this.internalJobListeners.values()));
        }
    }

    public JobListener getInternalJobListener(String string) {
        HashMap<String, JobListener> hashMap = this.internalJobListeners;
        synchronized (hashMap) {
            return this.internalJobListeners.get(string);
        }
    }

    public void addInternalTriggerListener(TriggerListener triggerListener) {
        if (triggerListener.getName() == null || triggerListener.getName().length() == 0) {
            throw new IllegalArgumentException("TriggerListener name cannot be empty.");
        }
        HashMap<String, TriggerListener> hashMap = this.internalTriggerListeners;
        synchronized (hashMap) {
            this.internalTriggerListeners.put(triggerListener.getName(), triggerListener);
            return;
        }
    }

    public boolean removeinternalTriggerListener(String string) {
        HashMap<String, TriggerListener> hashMap = this.internalTriggerListeners;
        synchronized (hashMap) {
            return this.internalTriggerListeners.remove(string) != null;
        }
    }

    public List<TriggerListener> getInternalTriggerListeners() {
        HashMap<String, TriggerListener> hashMap = this.internalTriggerListeners;
        synchronized (hashMap) {
            return Collections.unmodifiableList(new LinkedList<TriggerListener>(this.internalTriggerListeners.values()));
        }
    }

    public TriggerListener getInternalTriggerListener(String string) {
        HashMap<String, TriggerListener> hashMap = this.internalTriggerListeners;
        synchronized (hashMap) {
            return this.internalTriggerListeners.get(string);
        }
    }

    public void addInternalSchedulerListener(SchedulerListener schedulerListener) {
        ArrayList<SchedulerListener> arrayList = this.internalSchedulerListeners;
        synchronized (arrayList) {
            this.internalSchedulerListeners.add(schedulerListener);
            return;
        }
    }

    public boolean removeInternalSchedulerListener(SchedulerListener schedulerListener) {
        ArrayList<SchedulerListener> arrayList = this.internalSchedulerListeners;
        synchronized (arrayList) {
            return this.internalSchedulerListeners.remove(schedulerListener);
        }
    }

    public List<SchedulerListener> getInternalSchedulerListeners() {
        ArrayList<SchedulerListener> arrayList = this.internalSchedulerListeners;
        synchronized (arrayList) {
            return Collections.unmodifiableList(new ArrayList<SchedulerListener>(this.internalSchedulerListeners));
        }
    }

    protected void notifyJobStoreJobComplete(OperableTrigger operableTrigger, JobDetail jobDetail, Trigger$CompletedExecutionInstruction trigger$CompletedExecutionInstruction) {
        this.resources.getJobStore().triggeredJobComplete(operableTrigger, jobDetail, trigger$CompletedExecutionInstruction);
    }

    protected void notifyJobStoreJobVetoed(OperableTrigger operableTrigger, JobDetail jobDetail, Trigger$CompletedExecutionInstruction trigger$CompletedExecutionInstruction) {
        this.resources.getJobStore().triggeredJobComplete(operableTrigger, jobDetail, trigger$CompletedExecutionInstruction);
    }

    protected void notifySchedulerThread(long l) {
        if (this.isSignalOnSchedulingChange()) {
            this.signaler.signalSchedulingChange(l);
        }
    }

    private List<TriggerListener> buildTriggerListenerList() {
        LinkedList<TriggerListener> linkedList = new LinkedList<TriggerListener>();
        linkedList.addAll(this.getListenerManager().getTriggerListeners());
        linkedList.addAll(this.getInternalTriggerListeners());
        return linkedList;
    }

    private List<JobListener> buildJobListenerList() {
        LinkedList<JobListener> linkedList = new LinkedList<JobListener>();
        linkedList.addAll(this.getListenerManager().getJobListeners());
        linkedList.addAll(this.getInternalJobListeners());
        return linkedList;
    }

    private List<SchedulerListener> buildSchedulerListenerList() {
        LinkedList<SchedulerListener> linkedList = new LinkedList<SchedulerListener>();
        linkedList.addAll(this.getListenerManager().getSchedulerListeners());
        linkedList.addAll(this.getInternalSchedulerListeners());
        return linkedList;
    }

    private boolean matchJobListener(JobListener object, JobKey jobKey) {
        object = this.getListenerManager().getJobListenerMatchers(object.getName());
        if (object == null) {
            return true;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Matcher matcher = (Matcher)object.next();
            if (!matcher.isMatch(jobKey)) continue;
            return true;
        }
        return false;
    }

    private boolean matchTriggerListener(TriggerListener object, TriggerKey triggerKey) {
        object = this.getListenerManager().getTriggerListenerMatchers(object.getName());
        if (object == null) {
            return true;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Matcher matcher = (Matcher)object.next();
            if (!matcher.isMatch(triggerKey)) continue;
            return true;
        }
        return false;
    }

    public boolean notifyTriggerListenersFired(JobExecutionContext jobExecutionContext) {
        boolean bl = false;
        Object object = this.buildTriggerListenerList();
        object = object.iterator();
        while (object.hasNext()) {
            TriggerListener triggerListener = (TriggerListener)object.next();
            try {
                if (!this.matchTriggerListener(triggerListener, jobExecutionContext.getTrigger().getKey())) continue;
                triggerListener.triggerFired(jobExecutionContext.getTrigger(), jobExecutionContext);
                if (!triggerListener.vetoJobExecution(jobExecutionContext.getTrigger(), jobExecutionContext)) continue;
                bl = true;
            }
            catch (Exception exception) {
                SchedulerException schedulerException = new SchedulerException("TriggerListener '" + triggerListener.getName() + "' threw exception: " + exception.getMessage(), exception);
                throw schedulerException;
            }
        }
        return bl;
    }

    public void notifyTriggerListenersMisfired(Trigger trigger) {
        Object object = this.buildTriggerListenerList();
        object = object.iterator();
        while (object.hasNext()) {
            TriggerListener triggerListener = (TriggerListener)object.next();
            try {
                if (!this.matchTriggerListener(triggerListener, trigger.getKey())) continue;
                triggerListener.triggerMisfired(trigger);
            }
            catch (Exception exception) {
                SchedulerException schedulerException = new SchedulerException("TriggerListener '" + triggerListener.getName() + "' threw exception: " + exception.getMessage(), exception);
                throw schedulerException;
            }
        }
    }

    public void notifyTriggerListenersComplete(JobExecutionContext jobExecutionContext, Trigger$CompletedExecutionInstruction trigger$CompletedExecutionInstruction) {
        Object object = this.buildTriggerListenerList();
        object = object.iterator();
        while (object.hasNext()) {
            TriggerListener triggerListener = (TriggerListener)object.next();
            try {
                if (!this.matchTriggerListener(triggerListener, jobExecutionContext.getTrigger().getKey())) continue;
                triggerListener.triggerComplete(jobExecutionContext.getTrigger(), jobExecutionContext, trigger$CompletedExecutionInstruction);
            }
            catch (Exception exception) {
                SchedulerException schedulerException = new SchedulerException("TriggerListener '" + triggerListener.getName() + "' threw exception: " + exception.getMessage(), exception);
                throw schedulerException;
            }
        }
    }

    public void notifyJobListenersToBeExecuted(JobExecutionContext jobExecutionContext) {
        Object object = this.buildJobListenerList();
        object = object.iterator();
        while (object.hasNext()) {
            JobListener jobListener = (JobListener)object.next();
            try {
                if (!this.matchJobListener(jobListener, jobExecutionContext.getJobDetail().getKey())) continue;
                jobListener.jobToBeExecuted(jobExecutionContext);
            }
            catch (Exception exception) {
                SchedulerException schedulerException = new SchedulerException("JobListener '" + jobListener.getName() + "' threw exception: " + exception.getMessage(), exception);
                throw schedulerException;
            }
        }
    }

    public void notifyJobListenersWasVetoed(JobExecutionContext jobExecutionContext) {
        Object object = this.buildJobListenerList();
        object = object.iterator();
        while (object.hasNext()) {
            JobListener jobListener = (JobListener)object.next();
            try {
                if (!this.matchJobListener(jobListener, jobExecutionContext.getJobDetail().getKey())) continue;
                jobListener.jobExecutionVetoed(jobExecutionContext);
            }
            catch (Exception exception) {
                SchedulerException schedulerException = new SchedulerException("JobListener '" + jobListener.getName() + "' threw exception: " + exception.getMessage(), exception);
                throw schedulerException;
            }
        }
    }

    public void notifyJobListenersWasExecuted(JobExecutionContext jobExecutionContext, JobExecutionException jobExecutionException) {
        Object object = this.buildJobListenerList();
        object = object.iterator();
        while (object.hasNext()) {
            JobListener jobListener = (JobListener)object.next();
            try {
                if (!this.matchJobListener(jobListener, jobExecutionContext.getJobDetail().getKey())) continue;
                jobListener.jobWasExecuted(jobExecutionContext, jobExecutionException);
            }
            catch (Exception exception) {
                SchedulerException schedulerException = new SchedulerException("JobListener '" + jobListener.getName() + "' threw exception: " + exception.getMessage(), exception);
                throw schedulerException;
            }
        }
    }

    public void notifySchedulerListenersError(String string, SchedulerException schedulerException) {
        Object object = this.buildSchedulerListenerList();
        object = object.iterator();
        while (object.hasNext()) {
            SchedulerListener schedulerListener = (SchedulerListener)object.next();
            try {
                schedulerListener.schedulerError(string, schedulerException);
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of error: ", (Throwable)exception);
                this.getLog().error("  Original error (for notification) was: " + string, (Throwable)schedulerException);
            }
        }
    }

    public void notifySchedulerListenersSchduled(Trigger trigger) {
        Object object = this.buildSchedulerListenerList();
        object = object.iterator();
        while (object.hasNext()) {
            SchedulerListener schedulerListener = (SchedulerListener)object.next();
            try {
                schedulerListener.jobScheduled(trigger);
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of scheduled job.  Triger=" + trigger.getKey(), (Throwable)exception);
            }
        }
    }

    public void notifySchedulerListenersUnscheduled(TriggerKey triggerKey) {
        Object object = this.buildSchedulerListenerList();
        object = object.iterator();
        while (object.hasNext()) {
            SchedulerListener schedulerListener = (SchedulerListener)object.next();
            try {
                if (triggerKey == null) {
                    schedulerListener.schedulingDataCleared();
                    continue;
                }
                schedulerListener.jobUnscheduled(triggerKey);
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of unscheduled job.  Triger=" + (triggerKey == null ? "ALL DATA" : triggerKey), (Throwable)exception);
            }
        }
    }

    public void notifySchedulerListenersFinalized(Trigger trigger) {
        Object object = this.buildSchedulerListenerList();
        object = object.iterator();
        while (object.hasNext()) {
            SchedulerListener schedulerListener = (SchedulerListener)object.next();
            try {
                schedulerListener.triggerFinalized(trigger);
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of finalized trigger.  Triger=" + trigger.getKey(), (Throwable)exception);
            }
        }
    }

    public void notifySchedulerListenersPausedTrigger(TriggerKey triggerKey) {
        Object object = this.buildSchedulerListenerList();
        object = object.iterator();
        while (object.hasNext()) {
            SchedulerListener schedulerListener = (SchedulerListener)object.next();
            try {
                schedulerListener.triggerPaused(triggerKey);
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of paused trigger: " + triggerKey, (Throwable)exception);
            }
        }
    }

    public void notifySchedulerListenersPausedTriggers(String string) {
        Object object = this.buildSchedulerListenerList();
        object = object.iterator();
        while (object.hasNext()) {
            SchedulerListener schedulerListener = (SchedulerListener)object.next();
            try {
                schedulerListener.triggersPaused(string);
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of paused trigger group." + string, (Throwable)exception);
            }
        }
    }

    public void notifySchedulerListenersResumedTrigger(TriggerKey triggerKey) {
        Object object = this.buildSchedulerListenerList();
        object = object.iterator();
        while (object.hasNext()) {
            SchedulerListener schedulerListener = (SchedulerListener)object.next();
            try {
                schedulerListener.triggerResumed(triggerKey);
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of resumed trigger: " + triggerKey, (Throwable)exception);
            }
        }
    }

    public void notifySchedulerListenersResumedTriggers(String string) {
        Object object = this.buildSchedulerListenerList();
        object = object.iterator();
        while (object.hasNext()) {
            SchedulerListener schedulerListener = (SchedulerListener)object.next();
            try {
                schedulerListener.triggersResumed(string);
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of resumed group: " + string, (Throwable)exception);
            }
        }
    }

    public void notifySchedulerListenersPausedJob(JobKey jobKey) {
        Object object = this.buildSchedulerListenerList();
        object = object.iterator();
        while (object.hasNext()) {
            SchedulerListener schedulerListener = (SchedulerListener)object.next();
            try {
                schedulerListener.jobPaused(jobKey);
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of paused job: " + jobKey, (Throwable)exception);
            }
        }
    }

    public void notifySchedulerListenersPausedJobs(String string) {
        Object object = this.buildSchedulerListenerList();
        object = object.iterator();
        while (object.hasNext()) {
            SchedulerListener schedulerListener = (SchedulerListener)object.next();
            try {
                schedulerListener.jobsPaused(string);
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of paused job group: " + string, (Throwable)exception);
            }
        }
    }

    public void notifySchedulerListenersResumedJob(JobKey jobKey) {
        Object object = this.buildSchedulerListenerList();
        object = object.iterator();
        while (object.hasNext()) {
            SchedulerListener schedulerListener = (SchedulerListener)object.next();
            try {
                schedulerListener.jobResumed(jobKey);
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of resumed job: " + jobKey, (Throwable)exception);
            }
        }
    }

    public void notifySchedulerListenersResumedJobs(String string) {
        Object object = this.buildSchedulerListenerList();
        object = object.iterator();
        while (object.hasNext()) {
            SchedulerListener schedulerListener = (SchedulerListener)object.next();
            try {
                schedulerListener.jobsResumed(string);
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of resumed job group: " + string, (Throwable)exception);
            }
        }
    }

    public void notifySchedulerListenersInStandbyMode() {
        Object object = this.buildSchedulerListenerList();
        object = object.iterator();
        while (object.hasNext()) {
            SchedulerListener schedulerListener = (SchedulerListener)object.next();
            try {
                schedulerListener.schedulerInStandbyMode();
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of inStandByMode.", (Throwable)exception);
            }
        }
    }

    public void notifySchedulerListenersStarted() {
        Object object = this.buildSchedulerListenerList();
        object = object.iterator();
        while (object.hasNext()) {
            SchedulerListener schedulerListener = (SchedulerListener)object.next();
            try {
                schedulerListener.schedulerStarted();
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of startup.", (Throwable)exception);
            }
        }
    }

    public void notifySchedulerListenersStarting() {
        Object object = this.buildSchedulerListenerList();
        object = object.iterator();
        while (object.hasNext()) {
            SchedulerListener schedulerListener = (SchedulerListener)object.next();
            try {
                schedulerListener.schedulerStarting();
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of startup.", (Throwable)exception);
            }
        }
    }

    public void notifySchedulerListenersShutdown() {
        Object object = this.buildSchedulerListenerList();
        object = object.iterator();
        while (object.hasNext()) {
            SchedulerListener schedulerListener = (SchedulerListener)object.next();
            try {
                schedulerListener.schedulerShutdown();
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of shutdown.", (Throwable)exception);
            }
        }
    }

    public void notifySchedulerListenersShuttingdown() {
        Object object = this.buildSchedulerListenerList();
        object = object.iterator();
        while (object.hasNext()) {
            SchedulerListener schedulerListener = (SchedulerListener)object.next();
            try {
                schedulerListener.schedulerShuttingdown();
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of shutdown.", (Throwable)exception);
            }
        }
    }

    public void notifySchedulerListenersJobAdded(JobDetail jobDetail) {
        Object object = this.buildSchedulerListenerList();
        object = object.iterator();
        while (object.hasNext()) {
            SchedulerListener schedulerListener = (SchedulerListener)object.next();
            try {
                schedulerListener.jobAdded(jobDetail);
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of JobAdded.", (Throwable)exception);
            }
        }
    }

    public void notifySchedulerListenersJobDeleted(JobKey jobKey) {
        Object object = this.buildSchedulerListenerList();
        object = object.iterator();
        while (object.hasNext()) {
            SchedulerListener schedulerListener = (SchedulerListener)object.next();
            try {
                schedulerListener.jobDeleted(jobKey);
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of JobAdded.", (Throwable)exception);
            }
        }
    }

    public void setJobFactory(JobFactory jobFactory) {
        if (jobFactory == null) {
            throw new IllegalArgumentException("JobFactory cannot be set to null!");
        }
        this.getLog().info("JobFactory set to: " + jobFactory);
        this.jobFactory = jobFactory;
    }

    public JobFactory getJobFactory() {
        return this.jobFactory;
    }

    @Override
    public boolean interrupt(JobKey jobKey) {
        Object object = this.getCurrentlyExecutingJobs();
        boolean bl = false;
        Iterator<JobExecutionContext> iterator = object.iterator();
        while (iterator.hasNext()) {
            JobExecutionContext jobExecutionContext = iterator.next();
            object = jobExecutionContext.getJobDetail();
            if (!jobKey.equals(object.getKey())) continue;
            Job job = jobExecutionContext.getJobInstance();
            if (job instanceof InterruptableJob) {
                ((InterruptableJob)job).interrupt();
                bl = true;
                continue;
            }
            throw new UnableToInterruptJobException("Job " + object.getKey() + " can not be interrupted, since it does not implement " + InterruptableJob.class.getName());
        }
        return bl;
    }

    @Override
    public boolean interrupt(String object) {
        Object object2 = this.getCurrentlyExecutingJobs();
        object2 = object2.iterator();
        while (object2.hasNext()) {
            JobExecutionContext jobExecutionContext = (JobExecutionContext)object2.next();
            if (!jobExecutionContext.getFireInstanceId().equals(object)) continue;
            object = jobExecutionContext.getJobInstance();
            if (object instanceof InterruptableJob) {
                ((InterruptableJob)object).interrupt();
                return true;
            }
            throw new UnableToInterruptJobException("Job " + jobExecutionContext.getJobDetail().getKey() + " can not be interrupted, since it does not implement " + InterruptableJob.class.getName());
        }
        return false;
    }

    private void shutdownPlugins() {
        for (SchedulerPlugin schedulerPlugin : this.resources.getSchedulerPlugins()) {
            schedulerPlugin.shutdown();
        }
    }

    private void startPlugins() {
        for (SchedulerPlugin schedulerPlugin : this.resources.getSchedulerPlugins()) {
            schedulerPlugin.start();
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        String[] stringArray = new Properties();
        InputStream inputStream = null;
        inputStream = QuartzScheduler.class.getResourceAsStream("quartz-build.properties");
        if (inputStream != null) {
            stringArray.load(inputStream);
            stringArray = stringArray.getProperty("version");
            if (stringArray != null) {
                stringArray = stringArray.split("\\.");
                VERSION_MAJOR = stringArray[0];
                VERSION_MINOR = stringArray[1];
                VERSION_ITERATION = stringArray.length > 2 ? stringArray[2] : "0";
            } else {
                LoggerFactory.getLogger(QuartzScheduler.class).error("Can't parse Quartz version from quartz-build.properties");
            }
        }
        if (inputStream == null) return;
        try {
            inputStream.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
        catch (Exception exception) {
            try {
                LoggerFactory.getLogger(QuartzScheduler.class).error("Error loading version info from quartz-build.properties.", (Throwable)exception);
                if (inputStream == null) return;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (Exception exception2) {}
                throw throwable;
            }
            try {
                inputStream.close();
                return;
            }
            catch (Exception exception3) {
                return;
            }
        }
    }
}

