/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.plugins;

import javax.transaction.UserTransaction;
import org.quartz.Scheduler;
import org.quartz.ee.jta.UserTransactionHelper;
import org.quartz.spi.SchedulerPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SchedulerPluginWithUserTransactionSupport
implements SchedulerPlugin {
    private String name;
    private Scheduler scheduler;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean wrapInUserTransaction = false;

    protected void start(UserTransaction userTransaction) {
    }

    protected void shutdown(UserTransaction userTransaction) {
    }

    protected Logger getLog() {
        return this.log;
    }

    protected String getName() {
        return this.name;
    }

    protected Scheduler getScheduler() {
        return this.scheduler;
    }

    public void initialize(String string, Scheduler scheduler) {
        this.name = string;
        this.scheduler = scheduler;
    }

    public boolean getWrapInUserTransaction() {
        return this.wrapInUserTransaction;
    }

    public void setWrapInUserTransaction(boolean bl) {
        this.wrapInUserTransaction = bl;
    }

    @Override
    public void start() {
        UserTransaction userTransaction = this.startUserTransaction();
        try {
            this.start(userTransaction);
            return;
        }
        finally {
            this.resolveUserTransaction(userTransaction);
        }
    }

    @Override
    public void shutdown() {
        UserTransaction userTransaction = this.startUserTransaction();
        try {
            this.shutdown(userTransaction);
            return;
        }
        finally {
            this.resolveUserTransaction(userTransaction);
        }
    }

    private UserTransaction startUserTransaction() {
        if (!this.wrapInUserTransaction) {
            return null;
        }
        UserTransaction userTransaction = null;
        try {
            userTransaction = UserTransactionHelper.lookupUserTransaction();
            userTransaction.begin();
        }
        catch (Throwable throwable) {
            UserTransactionHelper.returnUserTransaction(userTransaction);
            userTransaction = null;
            this.getLog().error("Failed to start UserTransaction for plugin: " + this.getName(), throwable);
        }
        return userTransaction;
    }

    private void resolveUserTransaction(UserTransaction userTransaction) {
        if (userTransaction != null) {
            try {
                if (userTransaction.getStatus() == 1) {
                    userTransaction.rollback();
                } else {
                    userTransaction.commit();
                }
                return;
            }
            catch (Throwable throwable) {
                this.getLog().error("Failed to resolve UserTransaction for plugin: " + this.getName(), throwable);
                return;
            }
            finally {
                UserTransactionHelper.returnUserTransaction(userTransaction);
            }
        }
    }
}

