/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ColorInfo$Companion;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.ColorType;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 $2\u00020\u0001:\u0001$B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u0019\u001a\u00020\u00142\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001b\u001a\u00020\fH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0005J\u0010\u0010 \u001a\u00020\u00002\b\u0010!\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0017\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000e\u00a8\u0006%"}, d2={"Lorg/jetbrains/skia/ColorInfo;", "", "colorType", "Lorg/jetbrains/skia/ColorType;", "alphaType", "Lorg/jetbrains/skia/ColorAlphaType;", "colorSpace", "Lorg/jetbrains/skia/ColorSpace;", "(Lorg/jetbrains/skia/ColorType;Lorg/jetbrains/skia/ColorAlphaType;Lorg/jetbrains/skia/ColorSpace;)V", "getAlphaType", "()Lorg/jetbrains/skia/ColorAlphaType;", "bytesPerPixel", "", "getBytesPerPixel", "()I", "getColorSpace", "()Lorg/jetbrains/skia/ColorSpace;", "getColorType", "()Lorg/jetbrains/skia/ColorType;", "isGammaCloseToSRGB", "", "()Z", "isOpaque", "shiftPerPixel", "getShiftPerPixel", "equals", "other", "hashCode", "toString", "", "withAlphaType", "_alphaType", "withColorSpace", "_colorSpace", "withColorType", "_colorType", "Companion", "skiko"})
public final class ColorInfo {
    public static final ColorInfo$Companion Companion = new ColorInfo$Companion(null);
    private final ColorType colorType;
    private final ColorAlphaType alphaType;
    private final ColorSpace colorSpace;
    private static final ColorInfo DEFAULT = new ColorInfo(ColorType.UNKNOWN, ColorAlphaType.UNKNOWN, null);

    public ColorInfo(ColorType colorType, ColorAlphaType colorAlphaType, ColorSpace colorSpace) {
        Intrinsics.checkNotNullParameter((Object)((Object)colorType), (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)colorAlphaType), (String)"");
        this.colorType = colorType;
        this.alphaType = colorAlphaType;
        this.colorSpace = colorSpace;
    }

    public final ColorType getColorType() {
        return this.colorType;
    }

    public final ColorAlphaType getAlphaType() {
        return this.alphaType;
    }

    public final ColorSpace getColorSpace() {
        return this.colorSpace;
    }

    public final boolean isOpaque() {
        return this.alphaType == ColorAlphaType.OPAQUE || this.colorType.isAlwaysOpaque();
    }

    public final int getBytesPerPixel() {
        return this.colorType.getBytesPerPixel();
    }

    public final int getShiftPerPixel() {
        return this.colorType.getShiftPerPixel();
    }

    public final boolean isGammaCloseToSRGB() {
        return this.colorSpace != null && this.colorSpace.isGammaCloseToSRGB();
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ColorInfo)) {
            return false;
        }
        if (this.colorType != ((ColorInfo)object).colorType) {
            return false;
        }
        if (this.alphaType != ((ColorInfo)object).alphaType) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.colorSpace, (Object)((ColorInfo)object).colorSpace);
    }

    public final int hashCode() {
        int n = 59 + this.colorType.hashCode();
        n = n * 59 + this.alphaType.hashCode();
        ColorSpace colorSpace = this.colorSpace;
        n = n * 59 + (colorSpace != null ? ((Object)colorSpace).hashCode() : 0);
        return n;
    }

    public final String toString() {
        return "ColorInfo(_colorType=" + (Object)((Object)this.colorType) + ", _alphaType=" + (Object)((Object)this.alphaType) + ", _colorSpace=" + this.colorSpace + ')';
    }

    public final ColorInfo withColorType(ColorType colorType) {
        Intrinsics.checkNotNullParameter((Object)((Object)colorType), (String)"");
        if (this.colorType == colorType) {
            return this;
        }
        return new ColorInfo(colorType, this.alphaType, this.colorSpace);
    }

    public final ColorInfo withAlphaType(ColorAlphaType colorAlphaType) {
        Intrinsics.checkNotNullParameter((Object)((Object)colorAlphaType), (String)"");
        if (this.alphaType == colorAlphaType) {
            return this;
        }
        return new ColorInfo(this.colorType, colorAlphaType, this.colorSpace);
    }

    public final ColorInfo withColorSpace(ColorSpace colorSpace) {
        if (this.colorSpace == colorSpace) {
            return this;
        }
        return new ColorInfo(this.colorType, this.alphaType, colorSpace);
    }

    public static final /* synthetic */ ColorInfo access$getDEFAULT$cp() {
        return DEFAULT;
    }
}

