/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io.path;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.internal.PlatformImplementationsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;

@Metadata(mv={1, 9, 0}, k=5, xi=49, d1={"\u0000\u0082\u0001\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0087\b\u001a%\u0010\u0005\u001a\u00020\u0002*\u00020\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\nH\u0087\b\u001a%\u0010\u0005\u001a\u00020\u0002*\u00020\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0087\b\u001a\u001e\u0010\f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\r\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0007\u001a:\u0010\u000e\u001a\u00020\u000f*\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0087\b\u00a2\u0006\u0002\u0010\u0015\u001a:\u0010\u0016\u001a\u00020\u0017*\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0087\b\u00a2\u0006\u0002\u0010\u0018\u001a=\u0010\u0019\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\n2!\u0010\u001a\u001a\u001d\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u00010\u001bH\u0087\b\u00f8\u0001\u0000\u001a&\u0010 \u001a\u00020!*\u00020\u00022\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0087\b\u00a2\u0006\u0002\u0010\"\u001a&\u0010#\u001a\u00020$*\u00020\u00022\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0087\b\u00a2\u0006\u0002\u0010%\u001a\r\u0010&\u001a\u00020\u0004*\u00020\u0002H\u0087\b\u001a\u001d\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001c0(*\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\nH\u0087\b\u001a\u0016\u0010)\u001a\u00020\u001c*\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\nH\u0007\u001a0\u0010*\u001a\u00020+*\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\n2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0087\b\u00a2\u0006\u0002\u0010,\u001a?\u0010-\u001a\u0002H.\"\u0004\b\u0000\u0010.*\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\n2\u0018\u0010/\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u000b\u0012\u0004\u0012\u0002H.0\u001bH\u0087\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u00100\u001a.\u00101\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0087\b\u00a2\u0006\u0002\u00102\u001a>\u00103\u001a\u00020\u0002*\u00020\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0087\b\u00a2\u0006\u0002\u00104\u001a>\u00103\u001a\u00020\u0002*\u00020\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\b\b\u0002\u0010\t\u001a\u00020\n2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0087\b\u00a2\u0006\u0002\u00105\u001a7\u00106\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\r\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0007\u00a2\u0006\u0002\u00107\u001a0\u00108\u001a\u000209*\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\n2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0087\b\u00a2\u0006\u0002\u0010:\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006;"}, d2={"appendBytes", "", "Ljava/nio/file/Path;", "array", "", "appendLines", "lines", "", "", "charset", "Ljava/nio/charset/Charset;", "Lkotlin/sequences/Sequence;", "appendText", "text", "bufferedReader", "Ljava/io/BufferedReader;", "bufferSize", "", "options", "", "Ljava/nio/file/OpenOption;", "(Ljava/nio/file/Path;Ljava/nio/charset/Charset;I[Ljava/nio/file/OpenOption;)Ljava/io/BufferedReader;", "bufferedWriter", "Ljava/io/BufferedWriter;", "(Ljava/nio/file/Path;Ljava/nio/charset/Charset;I[Ljava/nio/file/OpenOption;)Ljava/io/BufferedWriter;", "forEachLine", "action", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "line", "inputStream", "Ljava/io/InputStream;", "(Ljava/nio/file/Path;[Ljava/nio/file/OpenOption;)Ljava/io/InputStream;", "outputStream", "Ljava/io/OutputStream;", "(Ljava/nio/file/Path;[Ljava/nio/file/OpenOption;)Ljava/io/OutputStream;", "readBytes", "readLines", "", "readText", "reader", "Ljava/io/InputStreamReader;", "(Ljava/nio/file/Path;Ljava/nio/charset/Charset;[Ljava/nio/file/OpenOption;)Ljava/io/InputStreamReader;", "useLines", "T", "block", "(Ljava/nio/file/Path;Ljava/nio/charset/Charset;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "writeBytes", "(Ljava/nio/file/Path;[B[Ljava/nio/file/OpenOption;)V", "writeLines", "(Ljava/nio/file/Path;Ljava/lang/Iterable;Ljava/nio/charset/Charset;[Ljava/nio/file/OpenOption;)Ljava/nio/file/Path;", "(Ljava/nio/file/Path;Lkotlin/sequences/Sequence;Ljava/nio/charset/Charset;[Ljava/nio/file/OpenOption;)Ljava/nio/file/Path;", "writeText", "(Ljava/nio/file/Path;Ljava/lang/CharSequence;Ljava/nio/charset/Charset;[Ljava/nio/file/OpenOption;)V", "writer", "Ljava/io/OutputStreamWriter;", "(Ljava/nio/file/Path;Ljava/nio/charset/Charset;[Ljava/nio/file/OpenOption;)Ljava/io/OutputStreamWriter;", "kotlin-stdlib-jdk7"}, xs="kotlin/io/path/PathsKt")
class PathsKt__PathReadWriteKt {
    private static final InputStreamReader reader(Path path, Charset charset, OpenOption ... openOptionArray) {
        Intrinsics.checkNotNullParameter(path, "");
        Intrinsics.checkNotNullParameter(charset, "");
        Intrinsics.checkNotNullParameter(openOptionArray, "");
        return new InputStreamReader(Files.newInputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length)), charset);
    }

    static /* synthetic */ InputStreamReader reader$default(Path path, Charset charset, OpenOption[] openOptionArray, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter(path, "");
        Intrinsics.checkNotNullParameter(charset, "");
        Intrinsics.checkNotNullParameter(openOptionArray, "");
        return new InputStreamReader(Files.newInputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length)), charset);
    }

    private static final BufferedReader bufferedReader(Path path, Charset charset, int n, OpenOption ... openOptionArray) {
        Intrinsics.checkNotNullParameter(path, "");
        Intrinsics.checkNotNullParameter(charset, "");
        Intrinsics.checkNotNullParameter(openOptionArray, "");
        return new BufferedReader(new InputStreamReader(Files.newInputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length)), charset), n);
    }

    static /* synthetic */ BufferedReader bufferedReader$default(Path path, Charset charset, int n, OpenOption[] openOptionArray, int n2, Object object) {
        if ((n2 & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        if ((n2 & 2) != 0) {
            n = 8192;
        }
        Intrinsics.checkNotNullParameter(path, "");
        Intrinsics.checkNotNullParameter(charset, "");
        Intrinsics.checkNotNullParameter(openOptionArray, "");
        return new BufferedReader(new InputStreamReader(Files.newInputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length)), charset), n);
    }

    private static final OutputStreamWriter writer(Path path, Charset charset, OpenOption ... openOptionArray) {
        Intrinsics.checkNotNullParameter(path, "");
        Intrinsics.checkNotNullParameter(charset, "");
        Intrinsics.checkNotNullParameter(openOptionArray, "");
        return new OutputStreamWriter(Files.newOutputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length)), charset);
    }

    static /* synthetic */ OutputStreamWriter writer$default(Path path, Charset charset, OpenOption[] openOptionArray, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter(path, "");
        Intrinsics.checkNotNullParameter(charset, "");
        Intrinsics.checkNotNullParameter(openOptionArray, "");
        return new OutputStreamWriter(Files.newOutputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length)), charset);
    }

    private static final BufferedWriter bufferedWriter(Path path, Charset charset, int n, OpenOption ... openOptionArray) {
        Intrinsics.checkNotNullParameter(path, "");
        Intrinsics.checkNotNullParameter(charset, "");
        Intrinsics.checkNotNullParameter(openOptionArray, "");
        return new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length)), charset), n);
    }

    static /* synthetic */ BufferedWriter bufferedWriter$default(Path path, Charset charset, int n, OpenOption[] openOptionArray, int n2, Object object) {
        if ((n2 & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        if ((n2 & 2) != 0) {
            n = 8192;
        }
        Intrinsics.checkNotNullParameter(path, "");
        Intrinsics.checkNotNullParameter(charset, "");
        Intrinsics.checkNotNullParameter(openOptionArray, "");
        return new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length)), charset), n);
    }

    private static final byte[] readBytes(Path path) {
        Intrinsics.checkNotNullParameter(path, "");
        byte[] byArray = Files.readAllBytes(path);
        Intrinsics.checkNotNullExpressionValue(byArray, "");
        return byArray;
    }

    private static final void writeBytes(Path path, byte[] byArray, OpenOption ... openOptionArray) {
        Intrinsics.checkNotNullParameter(path, "");
        Intrinsics.checkNotNullParameter(byArray, "");
        Intrinsics.checkNotNullParameter(openOptionArray, "");
        Files.write(path, byArray, Arrays.copyOf(openOptionArray, openOptionArray.length));
    }

    private static final void appendBytes(Path openOptionArray, byte[] byArray) {
        Intrinsics.checkNotNullParameter(openOptionArray, "");
        Intrinsics.checkNotNullParameter(byArray, "");
        OpenOption[] openOptionArray2 = openOptionArray;
        OpenOption[] openOptionArray3 = new OpenOption[1];
        openOptionArray = openOptionArray3;
        openOptionArray3[0] = StandardOpenOption.APPEND;
        Files.write((Path)openOptionArray2, byArray, openOptionArray);
    }

    public static final String readText(Path object, Charset object2) {
        Intrinsics.checkNotNullParameter(object, "");
        Intrinsics.checkNotNullParameter(object2, "");
        Object object3 = new OpenOption[]{};
        object = new InputStreamReader(Files.newInputStream((Path)object, Arrays.copyOf(object3, 0)), (Charset)object2);
        object3 = null;
        try {
            object2 = (InputStreamReader)object;
            object2 = TextStreamsKt.readText((Reader)object2);
            return object2;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            object3 = throwable;
            throw object2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object3);
        }
    }

    public static /* synthetic */ String readText$default(Path path, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return PathsKt.readText(path, charset);
    }

    public static final void writeText(Path object, CharSequence charSequence, Charset object2, OpenOption ... object3) {
        Intrinsics.checkNotNullParameter(object, "");
        Intrinsics.checkNotNullParameter(charSequence, "");
        Intrinsics.checkNotNullParameter(object2, "");
        Intrinsics.checkNotNullParameter(object3, "");
        OutputStream outputStream = Files.newOutputStream((Path)object, Arrays.copyOf(object3, ((OpenOption[])object3).length));
        Intrinsics.checkNotNullExpressionValue(outputStream, "");
        object = outputStream;
        object = new OutputStreamWriter((OutputStream)object, (Charset)object2);
        object2 = null;
        try {
            object3 = (OutputStreamWriter)object;
            object3.append(charSequence);
            return;
        }
        catch (Throwable throwable) {
            object3 = throwable;
            object2 = throwable;
            throw object3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    public static /* synthetic */ void writeText$default(Path path, CharSequence charSequence, Charset charset, OpenOption[] openOptionArray, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        PathsKt.writeText(path, charSequence, charset, openOptionArray);
    }

    public static final void appendText(Path object, CharSequence charSequence, Charset object2) {
        Intrinsics.checkNotNullParameter(object, "");
        Intrinsics.checkNotNullParameter(charSequence, "");
        Intrinsics.checkNotNullParameter(object2, "");
        OpenOption[] openOptionArray = new OpenOption[1];
        Object object3 = openOptionArray;
        openOptionArray[0] = StandardOpenOption.APPEND;
        OutputStream outputStream = Files.newOutputStream((Path)object, object3);
        Intrinsics.checkNotNullExpressionValue(outputStream, "");
        object = outputStream;
        object = new OutputStreamWriter((OutputStream)object, (Charset)object2);
        object3 = null;
        try {
            object2 = (OutputStreamWriter)object;
            ((OutputStreamWriter)object2).append(charSequence);
            return;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            object3 = throwable;
            throw object2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object3);
        }
    }

    public static /* synthetic */ void appendText$default(Path path, CharSequence charSequence, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        PathsKt.appendText(path, charSequence, charset);
    }

    private static final void forEachLine(Path object, Charset object2, Function1<? super String, Unit> function1) {
        Intrinsics.checkNotNullParameter(object, "");
        Intrinsics.checkNotNullParameter(object2, "");
        Intrinsics.checkNotNullParameter(function1, "");
        BufferedReader bufferedReader = Files.newBufferedReader((Path)object, (Charset)object2);
        Intrinsics.checkNotNullExpressionValue(bufferedReader, "");
        Reader reader = bufferedReader;
        object = reader;
        object = reader;
        object = (BufferedReader)reader;
        object2 = null;
        try {
            Object object3 = (BufferedReader)object;
            Sequence<String> sequence = TextStreamsKt.lineSequence((BufferedReader)object3);
            object3 = sequence;
            object3 = sequence;
            object3 = sequence.iterator();
            while (object3.hasNext()) {
                Object e = object3.next();
                function1.invoke((String)e);
            }
        }
        catch (Throwable throwable) {
            try {
                Throwable throwable2 = throwable;
                object2 = throwable;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                InlineMarker.finallyStart(1);
                if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                } else if (object2 == null) {
                    object.close();
                } else {
                    try {
                        object.close();
                    }
                    catch (Throwable throwable4) {}
                }
                InlineMarker.finallyEnd(1);
                throw throwable3;
            }
        }
        InlineMarker.finallyStart(1);
        if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        } else {
            object.close();
        }
        InlineMarker.finallyEnd(1);
        return;
    }

    static /* synthetic */ void forEachLine$default(Path object, Charset object2, Function1 function1, int n, Object object3) {
        Object object4;
        if ((n & 1) != 0) {
            object2 = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter(object, "");
        Intrinsics.checkNotNullParameter(object2, "");
        Intrinsics.checkNotNullParameter(function1, "");
        BufferedReader bufferedReader = Files.newBufferedReader((Path)object, (Charset)object2);
        Intrinsics.checkNotNullExpressionValue(bufferedReader, "");
        object = object4 = (Reader)bufferedReader;
        object = (BufferedReader)object4;
        object2 = null;
        try {
            object4 = (BufferedReader)object;
            Sequence<String> sequence = TextStreamsKt.lineSequence((BufferedReader)object4);
            object4 = sequence;
            object4 = sequence;
            object4 = sequence.iterator();
            while (object4.hasNext()) {
                object3 = object4.next();
                function1.invoke(object3);
            }
        }
        catch (Throwable throwable) {
            try {
                object4 = throwable;
                object2 = throwable;
                throw object4;
            }
            catch (Throwable throwable2) {
                InlineMarker.finallyStart(1);
                if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                } else if (object2 == null) {
                    object.close();
                } else {
                    try {
                        object.close();
                    }
                    catch (Throwable throwable3) {}
                }
                InlineMarker.finallyEnd(1);
                throw throwable2;
            }
        }
        InlineMarker.finallyStart(1);
        if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        } else {
            object.close();
        }
        InlineMarker.finallyEnd(1);
        return;
    }

    private static final InputStream inputStream(Path path, OpenOption ... openOptionArray) {
        Intrinsics.checkNotNullParameter(path, "");
        Intrinsics.checkNotNullParameter(openOptionArray, "");
        InputStream inputStream = Files.newInputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue(inputStream, "");
        return inputStream;
    }

    private static final OutputStream outputStream(Path path, OpenOption ... openOptionArray) {
        Intrinsics.checkNotNullParameter(path, "");
        Intrinsics.checkNotNullParameter(openOptionArray, "");
        OutputStream outputStream = Files.newOutputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue(outputStream, "");
        return outputStream;
    }

    private static final List<String> readLines(Path path, Charset charset) {
        Intrinsics.checkNotNullParameter(path, "");
        Intrinsics.checkNotNullParameter(charset, "");
        List<String> list = Files.readAllLines(path, charset);
        Intrinsics.checkNotNullExpressionValue(list, "");
        return list;
    }

    static /* synthetic */ List readLines$default(Path path, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter(path, "");
        Intrinsics.checkNotNullParameter(charset, "");
        List<String> list = Files.readAllLines(path, charset);
        Intrinsics.checkNotNullExpressionValue(list, "");
        return list;
    }

    private static final <T> T useLines(Path object, Charset object2, Function1<? super Sequence<String>, ? extends T> function1) {
        BufferedReader bufferedReader;
        Intrinsics.checkNotNullParameter(object, "");
        Intrinsics.checkNotNullParameter(object2, "");
        Intrinsics.checkNotNullParameter(function1, "");
        object = Files.newBufferedReader((Path)object, (Charset)object2);
        object2 = null;
        try {
            bufferedReader = (BufferedReader)object;
            Intrinsics.checkNotNull(bufferedReader);
            bufferedReader = function1.invoke(TextStreamsKt.lineSequence(bufferedReader));
        }
        catch (Throwable throwable) {
            try {
                Throwable throwable2 = throwable;
                object2 = throwable;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                InlineMarker.finallyStart(1);
                if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                } else if (object != null) {
                    if (object2 == null) {
                        object.close();
                    } else {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable4) {}
                    }
                }
                InlineMarker.finallyEnd(1);
                throw throwable3;
            }
        }
        InlineMarker.finallyStart(1);
        if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        } else if (object != null) {
            object.close();
        }
        InlineMarker.finallyEnd(1);
        return (T)bufferedReader;
    }

    static /* synthetic */ Object useLines$default(Path object, Charset charset, Function1 function1, int n, Object object2) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter(object, "");
        Intrinsics.checkNotNullParameter(charset, "");
        Intrinsics.checkNotNullParameter(function1, "");
        Closeable closeable = Files.newBufferedReader((Path)object, charset);
        object2 = null;
        try {
            object = (BufferedReader)closeable;
            Intrinsics.checkNotNull(object);
            object = function1.invoke(TextStreamsKt.lineSequence((BufferedReader)object));
        }
        catch (Throwable throwable) {
            try {
                object = throwable;
                object2 = throwable;
                throw object;
            }
            catch (Throwable throwable2) {
                InlineMarker.finallyStart(1);
                if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
                    CloseableKt.closeFinally(closeable, (Throwable)object2);
                } else if (closeable != null) {
                    if (object2 == null) {
                        closeable.close();
                    } else {
                        try {
                            closeable.close();
                        }
                        catch (Throwable throwable3) {}
                    }
                }
                InlineMarker.finallyEnd(1);
                throw throwable2;
            }
        }
        InlineMarker.finallyStart(1);
        if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
            CloseableKt.closeFinally(closeable, (Throwable)object2);
        } else if (closeable != null) {
            closeable.close();
        }
        InlineMarker.finallyEnd(1);
        return object;
    }

    private static final Path writeLines(Path path, Iterable<? extends CharSequence> iterable, Charset charset, OpenOption ... openOptionArray) {
        Intrinsics.checkNotNullParameter(path, "");
        Intrinsics.checkNotNullParameter(iterable, "");
        Intrinsics.checkNotNullParameter(charset, "");
        Intrinsics.checkNotNullParameter(openOptionArray, "");
        Path path2 = Files.write(path, iterable, charset, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue(path2, "");
        return path2;
    }

    static /* synthetic */ Path writeLines$default(Path path, Iterable iterable, Charset charset, OpenOption[] openOptionArray, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter(path, "");
        Intrinsics.checkNotNullParameter(iterable, "");
        Intrinsics.checkNotNullParameter(charset, "");
        Intrinsics.checkNotNullParameter(openOptionArray, "");
        Path path2 = Files.write(path, (Iterable<? extends CharSequence>)iterable, charset, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue(path2, "");
        return path2;
    }

    private static final Path writeLines(Path path, Sequence<? extends CharSequence> sequence, Charset charset, OpenOption ... openOptionArray) {
        Intrinsics.checkNotNullParameter(path, "");
        Intrinsics.checkNotNullParameter(sequence, "");
        Intrinsics.checkNotNullParameter(charset, "");
        Intrinsics.checkNotNullParameter(openOptionArray, "");
        Path path2 = Files.write(path, SequencesKt.asIterable(sequence), charset, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue(path2, "");
        return path2;
    }

    static /* synthetic */ Path writeLines$default(Path path, Sequence sequence, Charset charset, OpenOption[] openOptionArray, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter(path, "");
        Intrinsics.checkNotNullParameter(sequence, "");
        Intrinsics.checkNotNullParameter(charset, "");
        Intrinsics.checkNotNullParameter(openOptionArray, "");
        Path path2 = Files.write(path, SequencesKt.asIterable(sequence), charset, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue(path2, "");
        return path2;
    }

    private static final Path appendLines(Path openOptionArray, Iterable<? extends CharSequence> iterable, Charset charset) {
        Intrinsics.checkNotNullParameter(openOptionArray, "");
        Intrinsics.checkNotNullParameter(iterable, "");
        Intrinsics.checkNotNullParameter(charset, "");
        OpenOption[] openOptionArray2 = openOptionArray;
        OpenOption[] openOptionArray3 = new OpenOption[1];
        openOptionArray = openOptionArray3;
        openOptionArray3[0] = StandardOpenOption.APPEND;
        Path path = Files.write((Path)openOptionArray2, iterable, charset, openOptionArray);
        Intrinsics.checkNotNullExpressionValue(path, "");
        return path;
    }

    static /* synthetic */ Path appendLines$default(Path path, Iterable iterable, Charset charset, int n, Object openOptionArray) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter(path, "");
        Intrinsics.checkNotNullParameter(iterable, "");
        Intrinsics.checkNotNullParameter(charset, "");
        OpenOption[] openOptionArray2 = new OpenOption[1];
        openOptionArray = openOptionArray2;
        openOptionArray2[0] = StandardOpenOption.APPEND;
        Path path2 = Files.write(path, (Iterable<? extends CharSequence>)iterable, charset, openOptionArray);
        Intrinsics.checkNotNullExpressionValue(path2, "");
        return path2;
    }

    private static final Path appendLines(Path openOptionArray, Sequence<? extends CharSequence> sequence, Charset charset) {
        Intrinsics.checkNotNullParameter(openOptionArray, "");
        Intrinsics.checkNotNullParameter(sequence, "");
        Intrinsics.checkNotNullParameter(charset, "");
        OpenOption[] openOptionArray2 = openOptionArray;
        OpenOption[] openOptionArray3 = new OpenOption[1];
        openOptionArray = openOptionArray3;
        openOptionArray3[0] = StandardOpenOption.APPEND;
        Path path = Files.write((Path)openOptionArray2, SequencesKt.asIterable(sequence), charset, openOptionArray);
        Intrinsics.checkNotNullExpressionValue(path, "");
        return path;
    }

    static /* synthetic */ Path appendLines$default(Path path, Sequence sequence, Charset charset, int n, Object openOptionArray) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter(path, "");
        Intrinsics.checkNotNullParameter(sequence, "");
        Intrinsics.checkNotNullParameter(charset, "");
        OpenOption[] openOptionArray2 = new OpenOption[1];
        openOptionArray = openOptionArray2;
        openOptionArray2[0] = StandardOpenOption.APPEND;
        Path path2 = Files.write(path, SequencesKt.asIterable(sequence), charset, openOptionArray);
        Intrinsics.checkNotNullExpressionValue(path2, "");
        return path2;
    }
}

