/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.action.ActionUtil;
import ch.qos.logback.core.joran.action.ActionUtil$Scope;
import ch.qos.logback.core.model.ComponentModel;
import ch.qos.logback.core.model.DefineModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.NamedComponentModel;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.spi.PropertyDefiner;
import ch.qos.logback.core.util.OptionHelper;

public class DefineModelHandler
extends ModelHandlerBase {
    boolean inError;
    PropertyDefiner definer;
    String propertyName;
    ActionUtil$Scope scope;

    public DefineModelHandler(Context context) {
        super(context);
    }

    public static DefineModelHandler makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new DefineModelHandler(context);
    }

    protected Class<DefineModel> getSupportedModelClass() {
        return DefineModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext modelInterpretationContext, Model model) {
        this.definer = null;
        this.inError = false;
        this.propertyName = null;
        Object object = (DefineModel)model;
        this.propertyName = ((NamedComponentModel)object).getName();
        String string = ((DefineModel)object).getScopeStr();
        this.scope = ActionUtil.stringToScope(string);
        if (OptionHelper.isNullOrEmpty(this.propertyName)) {
            this.addError("Missing property name for property definer. Near [" + model.getTag() + "] line " + model.getLineNumber());
            this.inError = true;
        }
        if (OptionHelper.isNullOrEmpty((String)(object = ((ComponentModel)object).getClassName()))) {
            this.addError("Missing class name for property definer. Near [" + model.getTag() + "] line " + model.getLineNumber());
            this.inError = true;
        } else {
            object = modelInterpretationContext.getImport((String)object);
        }
        if (this.inError) {
            return;
        }
        try {
            this.addInfo("About to instantiate property definer of type [" + (String)object + "]");
            this.definer = (PropertyDefiner)OptionHelper.instantiateByClassName((String)object, PropertyDefiner.class, this.context);
            this.definer.setContext(this.context);
            modelInterpretationContext.pushObject(this.definer);
            return;
        }
        catch (Exception exception) {
            this.inError = true;
            this.addError("Could not create an PropertyDefiner of type [" + (String)object + "].", exception);
            throw new ModelHandlerException(exception);
        }
    }

    @Override
    public void postHandle(ModelInterpretationContext modelInterpretationContext, Model object) {
        if (this.inError) {
            return;
        }
        object = modelInterpretationContext.peekObject();
        if (object != this.definer) {
            DefineModelHandler defineModelHandler = this;
            defineModelHandler.addWarn("The object at the of the stack is not the property definer for property named [" + defineModelHandler.propertyName + "] pushed earlier.");
            return;
        }
        modelInterpretationContext.popObject();
        if (this.definer instanceof LifeCycle) {
            ((LifeCycle)((Object)this.definer)).start();
        }
        if ((object = this.definer.getPropertyValue()) != null) {
            DefineModelHandler defineModelHandler = this;
            defineModelHandler.addInfo("Setting property " + defineModelHandler.propertyName + "=" + (String)object + " in scope " + String.valueOf((Object)this.scope));
            ActionUtil.setProperty(modelInterpretationContext, this.propertyName, (String)object, this.scope);
        }
    }
}

