/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.afm;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.StringTokenizer;
import org.apache.fontbox.afm.CharMetric;
import org.apache.fontbox.afm.Composite;
import org.apache.fontbox.afm.CompositePart;
import org.apache.fontbox.afm.FontMetrics;
import org.apache.fontbox.afm.KernPair;
import org.apache.fontbox.afm.Ligature;
import org.apache.fontbox.afm.TrackKern;
import org.apache.fontbox.util.BoundingBox;

public class AFMParser {
    public static final String COMMENT = "Comment";
    public static final String START_FONT_METRICS = "StartFontMetrics";
    public static final String END_FONT_METRICS = "EndFontMetrics";
    public static final String FONT_NAME = "FontName";
    public static final String FULL_NAME = "FullName";
    public static final String FAMILY_NAME = "FamilyName";
    public static final String WEIGHT = "Weight";
    public static final String FONT_BBOX = "FontBBox";
    public static final String VERSION = "Version";
    public static final String NOTICE = "Notice";
    public static final String ENCODING_SCHEME = "EncodingScheme";
    public static final String MAPPING_SCHEME = "MappingScheme";
    public static final String ESC_CHAR = "EscChar";
    public static final String CHARACTER_SET = "CharacterSet";
    public static final String CHARACTERS = "Characters";
    public static final String IS_BASE_FONT = "IsBaseFont";
    public static final String V_VECTOR = "VVector";
    public static final String IS_FIXED_V = "IsFixedV";
    public static final String CAP_HEIGHT = "CapHeight";
    public static final String X_HEIGHT = "XHeight";
    public static final String ASCENDER = "Ascender";
    public static final String DESCENDER = "Descender";
    public static final String UNDERLINE_POSITION = "UnderlinePosition";
    public static final String UNDERLINE_THICKNESS = "UnderlineThickness";
    public static final String ITALIC_ANGLE = "ItalicAngle";
    public static final String CHAR_WIDTH = "CharWidth";
    public static final String IS_FIXED_PITCH = "IsFixedPitch";
    public static final String START_CHAR_METRICS = "StartCharMetrics";
    public static final String END_CHAR_METRICS = "EndCharMetrics";
    public static final String CHARMETRICS_C = "C";
    public static final String CHARMETRICS_CH = "CH";
    public static final String CHARMETRICS_WX = "WX";
    public static final String CHARMETRICS_W0X = "W0X";
    public static final String CHARMETRICS_W1X = "W1X";
    public static final String CHARMETRICS_WY = "WY";
    public static final String CHARMETRICS_W0Y = "W0Y";
    public static final String CHARMETRICS_W1Y = "W1Y";
    public static final String CHARMETRICS_W = "W";
    public static final String CHARMETRICS_W0 = "W0";
    public static final String CHARMETRICS_W1 = "W1";
    public static final String CHARMETRICS_VV = "VV";
    public static final String CHARMETRICS_N = "N";
    public static final String CHARMETRICS_B = "B";
    public static final String CHARMETRICS_L = "L";
    public static final String STD_HW = "StdHW";
    public static final String STD_VW = "StdVW";
    public static final String START_TRACK_KERN = "StartTrackKern";
    public static final String END_TRACK_KERN = "EndTrackKern";
    public static final String START_KERN_DATA = "StartKernData";
    public static final String END_KERN_DATA = "EndKernData";
    public static final String START_KERN_PAIRS = "StartKernPairs";
    public static final String END_KERN_PAIRS = "EndKernPairs";
    public static final String START_KERN_PAIRS0 = "StartKernPairs0";
    public static final String START_KERN_PAIRS1 = "StartKernPairs1";
    public static final String START_COMPOSITES = "StartComposites";
    public static final String END_COMPOSITES = "EndComposites";
    public static final String CC = "CC";
    public static final String PCC = "PCC";
    public static final String KERN_PAIR_KP = "KP";
    public static final String KERN_PAIR_KPH = "KPH";
    public static final String KERN_PAIR_KPX = "KPX";
    public static final String KERN_PAIR_KPY = "KPY";
    private static final int BITS_IN_HEX = 16;
    private final InputStream input;

    public AFMParser(InputStream inputStream) {
        this.input = inputStream;
    }

    public FontMetrics parse() {
        return this.parseFontMetric(false);
    }

    public FontMetrics parse(boolean bl) {
        return this.parseFontMetric(bl);
    }

    private FontMetrics parseFontMetric(boolean bl) {
        Object object;
        this.readCommand(START_FONT_METRICS);
        FontMetrics fontMetrics = new FontMetrics();
        fontMetrics.setAFMVersion(this.readFloat());
        boolean bl2 = false;
        block64: while (!END_FONT_METRICS.equals(object = this.readString())) {
            switch (object) {
                case "FontName": {
                    fontMetrics.setFontName(this.readLine());
                    continue block64;
                }
                case "FullName": {
                    fontMetrics.setFullName(this.readLine());
                    continue block64;
                }
                case "FamilyName": {
                    fontMetrics.setFamilyName(this.readLine());
                    continue block64;
                }
                case "Weight": {
                    fontMetrics.setWeight(this.readLine());
                    continue block64;
                }
                case "FontBBox": {
                    object = new BoundingBox();
                    ((BoundingBox)object).setLowerLeftX(this.readFloat());
                    ((BoundingBox)object).setLowerLeftY(this.readFloat());
                    ((BoundingBox)object).setUpperRightX(this.readFloat());
                    ((BoundingBox)object).setUpperRightY(this.readFloat());
                    fontMetrics.setFontBBox((BoundingBox)object);
                    continue block64;
                }
                case "Version": {
                    fontMetrics.setFontVersion(this.readLine());
                    continue block64;
                }
                case "Notice": {
                    fontMetrics.setNotice(this.readLine());
                    continue block64;
                }
                case "EncodingScheme": {
                    fontMetrics.setEncodingScheme(this.readLine());
                    continue block64;
                }
                case "MappingScheme": {
                    fontMetrics.setMappingScheme(this.readInt());
                    continue block64;
                }
                case "EscChar": {
                    fontMetrics.setEscChar(this.readInt());
                    continue block64;
                }
                case "CharacterSet": {
                    fontMetrics.setCharacterSet(this.readLine());
                    continue block64;
                }
                case "Characters": {
                    fontMetrics.setCharacters(this.readInt());
                    continue block64;
                }
                case "IsBaseFont": {
                    fontMetrics.setIsBaseFont(this.readBoolean());
                    continue block64;
                }
                case "VVector": {
                    float[] fArray = new float[2];
                    object = fArray;
                    fArray[0] = this.readFloat();
                    object[1] = this.readFloat();
                    fontMetrics.setVVector((float[])object);
                    continue block64;
                }
                case "IsFixedV": {
                    fontMetrics.setIsFixedV(this.readBoolean());
                    continue block64;
                }
                case "CapHeight": {
                    fontMetrics.setCapHeight(this.readFloat());
                    continue block64;
                }
                case "XHeight": {
                    fontMetrics.setXHeight(this.readFloat());
                    continue block64;
                }
                case "Ascender": {
                    fontMetrics.setAscender(this.readFloat());
                    continue block64;
                }
                case "Descender": {
                    fontMetrics.setDescender(this.readFloat());
                    continue block64;
                }
                case "StdHW": {
                    fontMetrics.setStandardHorizontalWidth(this.readFloat());
                    continue block64;
                }
                case "StdVW": {
                    fontMetrics.setStandardVerticalWidth(this.readFloat());
                    continue block64;
                }
                case "Comment": {
                    fontMetrics.addComment(this.readLine());
                    continue block64;
                }
                case "UnderlinePosition": {
                    fontMetrics.setUnderlinePosition(this.readFloat());
                    continue block64;
                }
                case "UnderlineThickness": {
                    fontMetrics.setUnderlineThickness(this.readFloat());
                    continue block64;
                }
                case "ItalicAngle": {
                    fontMetrics.setItalicAngle(this.readFloat());
                    continue block64;
                }
                case "CharWidth": {
                    float[] fArray = new float[2];
                    object = fArray;
                    fArray[0] = this.readFloat();
                    object[1] = this.readFloat();
                    fontMetrics.setCharWidth((float[])object);
                    continue block64;
                }
                case "IsFixedPitch": {
                    fontMetrics.setFixedPitch(this.readBoolean());
                    continue block64;
                }
                case "StartCharMetrics": {
                    bl2 = this.parseCharMetrics(fontMetrics);
                    continue block64;
                }
                case "StartKernData": {
                    if (bl) continue block64;
                    this.parseKernData(fontMetrics);
                    continue block64;
                }
                case "StartComposites": {
                    if (bl) continue block64;
                    this.parseComposites(fontMetrics);
                    continue block64;
                }
            }
            if (bl && bl2) continue;
            throw new IOException("Unknown AFM key '" + (String)object + "'");
        }
        return fontMetrics;
    }

    private void parseKernData(FontMetrics fontMetrics) {
        String string;
        block12: while (!(string = this.readString()).equals(END_KERN_DATA)) {
            switch (string) {
                case "StartTrackKern": {
                    int n = this.readInt();
                    for (int i = 0; i < n; ++i) {
                        fontMetrics.addTrackKern(new TrackKern(this.readInt(), this.readFloat(), this.readFloat(), this.readFloat(), this.readFloat()));
                    }
                    this.readCommand(END_TRACK_KERN);
                    continue block12;
                }
                case "StartKernPairs": {
                    this.parseKernPairs(fontMetrics);
                    continue block12;
                }
                case "StartKernPairs0": {
                    this.parseKernPairs0(fontMetrics);
                    continue block12;
                }
                case "StartKernPairs1": {
                    this.parseKernPairs1(fontMetrics);
                    continue block12;
                }
            }
            throw new IOException("Unknown kerning data type '" + string + "'");
        }
    }

    private void parseKernPairs(FontMetrics fontMetrics) {
        int n = this.readInt();
        for (int i = 0; i < n; ++i) {
            fontMetrics.addKernPair(this.parseKernPair());
        }
        this.readCommand(END_KERN_PAIRS);
    }

    private void parseKernPairs0(FontMetrics fontMetrics) {
        int n = this.readInt();
        for (int i = 0; i < n; ++i) {
            fontMetrics.addKernPair0(this.parseKernPair());
        }
        this.readCommand(END_KERN_PAIRS);
    }

    private void parseKernPairs1(FontMetrics fontMetrics) {
        int n = this.readInt();
        for (int i = 0; i < n; ++i) {
            fontMetrics.addKernPair1(this.parseKernPair());
        }
        this.readCommand(END_KERN_PAIRS);
    }

    private KernPair parseKernPair() {
        String string;
        switch (string = this.readString()) {
            case "KP": {
                return new KernPair(this.readString(), this.readString(), this.readFloat(), this.readFloat());
            }
            case "KPH": {
                AFMParser aFMParser = this;
                AFMParser aFMParser2 = this;
                return new KernPair(aFMParser.hexToString(aFMParser.readString()), aFMParser2.hexToString(aFMParser2.readString()), this.readFloat(), this.readFloat());
            }
            case "KPX": {
                return new KernPair(this.readString(), this.readString(), this.readFloat(), 0.0f);
            }
            case "KPY": {
                return new KernPair(this.readString(), this.readString(), 0.0f, this.readFloat());
            }
        }
        throw new IOException("Error expected kern pair command actual='" + string + "'");
    }

    private String hexToString(String string) {
        block6: {
            block5: {
                if (string.length() < 2) {
                    throw new IOException("Error: Expected hex string of length >= 2 not='" + string);
                }
                if (string.charAt(0) != '<') break block5;
                String string2 = string;
                if (string2.charAt(string2.length() - 1) == '>') break block6;
            }
            throw new IOException("String should be enclosed by angle brackets '" + string + "'");
        }
        string = string.substring(1, string.length() - 1);
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < string.length(); i += 2) {
            String string3 = Character.toString(string.charAt(i)) + string.charAt(i + 1);
            byArray[i / 2] = (byte)this.parseInt(string3, 16);
        }
        return new String(byArray, StandardCharsets.ISO_8859_1);
    }

    private void parseComposites(FontMetrics fontMetrics) {
        int n = this.readInt();
        for (int i = 0; i < n; ++i) {
            fontMetrics.addComposite(this.parseComposite());
        }
        this.readCommand(END_COMPOSITES);
    }

    private Composite parseComposite() {
        Object object = this.readLine();
        Object object2 = ((StringTokenizer)(object = new StringTokenizer((String)object, " ;"))).nextToken();
        if (!((String)object2).equals(CC)) {
            throw new IOException("Expected 'CC' actual='" + (String)object2 + "'");
        }
        object2 = ((StringTokenizer)object).nextToken();
        object2 = new Composite((String)object2);
        int n = this.parseInt(((StringTokenizer)object).nextToken());
        for (int i = 0; i < n; ++i) {
            String string = ((StringTokenizer)object).nextToken();
            if (!string.equals(PCC)) {
                throw new IOException("Expected 'PCC' actual='" + string + "'");
            }
            string = ((StringTokenizer)object).nextToken();
            int n2 = this.parseInt(((StringTokenizer)object).nextToken());
            int n3 = this.parseInt(((StringTokenizer)object).nextToken());
            ((Composite)object2).addPart(new CompositePart(string, n2, n3));
        }
        return object2;
    }

    private boolean parseCharMetrics(FontMetrics fontMetrics) {
        int n = this.readInt();
        for (int i = 0; i < n; ++i) {
            fontMetrics.addCharMetric(this.parseCharMetric());
        }
        this.readCommand(END_CHAR_METRICS);
        return true;
    }

    private CharMetric parseCharMetric() {
        CharMetric charMetric = new CharMetric();
        Object object = this.readLine();
        object = new StringTokenizer((String)object);
        block34: while (((StringTokenizer)object).hasMoreTokens()) {
            Object object2 = ((StringTokenizer)object).nextToken();
            switch (object2) {
                case "C": {
                    object2 = ((StringTokenizer)object).nextToken();
                    charMetric.setCharacterCode(this.parseInt((String)object2));
                    this.verifySemicolon((StringTokenizer)object);
                    continue block34;
                }
                case "CH": {
                    object2 = ((StringTokenizer)object).nextToken();
                    charMetric.setCharacterCode(this.parseInt((String)object2, 16));
                    this.verifySemicolon((StringTokenizer)object);
                    continue block34;
                }
                case "WX": {
                    charMetric.setWx(this.parseFloat(((StringTokenizer)object).nextToken()));
                    this.verifySemicolon((StringTokenizer)object);
                    continue block34;
                }
                case "W0X": {
                    charMetric.setW0x(this.parseFloat(((StringTokenizer)object).nextToken()));
                    this.verifySemicolon((StringTokenizer)object);
                    continue block34;
                }
                case "W1X": {
                    charMetric.setW1x(this.parseFloat(((StringTokenizer)object).nextToken()));
                    this.verifySemicolon((StringTokenizer)object);
                    continue block34;
                }
                case "WY": {
                    charMetric.setWy(this.parseFloat(((StringTokenizer)object).nextToken()));
                    this.verifySemicolon((StringTokenizer)object);
                    continue block34;
                }
                case "W0Y": {
                    charMetric.setW0y(this.parseFloat(((StringTokenizer)object).nextToken()));
                    this.verifySemicolon((StringTokenizer)object);
                    continue block34;
                }
                case "W1Y": {
                    charMetric.setW1y(this.parseFloat(((StringTokenizer)object).nextToken()));
                    this.verifySemicolon((StringTokenizer)object);
                    continue block34;
                }
                case "W": {
                    float[] fArray = new float[2];
                    object2 = fArray;
                    fArray[0] = this.parseFloat(((StringTokenizer)object).nextToken());
                    object2[1] = this.parseFloat(((StringTokenizer)object).nextToken());
                    charMetric.setW((float[])object2);
                    this.verifySemicolon((StringTokenizer)object);
                    continue block34;
                }
                case "W0": {
                    float[] fArray = new float[2];
                    object2 = fArray;
                    fArray[0] = this.parseFloat(((StringTokenizer)object).nextToken());
                    object2[1] = this.parseFloat(((StringTokenizer)object).nextToken());
                    charMetric.setW0((float[])object2);
                    this.verifySemicolon((StringTokenizer)object);
                    continue block34;
                }
                case "W1": {
                    float[] fArray = new float[2];
                    object2 = fArray;
                    fArray[0] = this.parseFloat(((StringTokenizer)object).nextToken());
                    object2[1] = this.parseFloat(((StringTokenizer)object).nextToken());
                    charMetric.setW1((float[])object2);
                    this.verifySemicolon((StringTokenizer)object);
                    continue block34;
                }
                case "VV": {
                    float[] fArray = new float[2];
                    object2 = fArray;
                    fArray[0] = this.parseFloat(((StringTokenizer)object).nextToken());
                    object2[1] = this.parseFloat(((StringTokenizer)object).nextToken());
                    charMetric.setVv((float[])object2);
                    this.verifySemicolon((StringTokenizer)object);
                    continue block34;
                }
                case "N": {
                    charMetric.setName(((StringTokenizer)object).nextToken());
                    this.verifySemicolon((StringTokenizer)object);
                    continue block34;
                }
                case "B": {
                    object2 = new BoundingBox();
                    ((BoundingBox)object2).setLowerLeftX(this.parseFloat(((StringTokenizer)object).nextToken()));
                    ((BoundingBox)object2).setLowerLeftY(this.parseFloat(((StringTokenizer)object).nextToken()));
                    ((BoundingBox)object2).setUpperRightX(this.parseFloat(((StringTokenizer)object).nextToken()));
                    ((BoundingBox)object2).setUpperRightY(this.parseFloat(((StringTokenizer)object).nextToken()));
                    charMetric.setBoundingBox((BoundingBox)object2);
                    this.verifySemicolon((StringTokenizer)object);
                    continue block34;
                }
                case "L": {
                    object2 = new Ligature(((StringTokenizer)object).nextToken(), ((StringTokenizer)object).nextToken());
                    charMetric.addLigature((Ligature)object2);
                    this.verifySemicolon((StringTokenizer)object);
                    continue block34;
                }
            }
            throw new IOException("Unknown CharMetrics command '" + (String)object2 + "'");
        }
        return charMetric;
    }

    private void verifySemicolon(StringTokenizer object) {
        if (((StringTokenizer)object).hasMoreTokens()) {
            if (!";".equals(object = ((StringTokenizer)object).nextToken())) {
                throw new IOException("Error: Expected semicolon in stream actual='" + (String)object + "'");
            }
            return;
        }
        throw new IOException("CharMetrics is missing a semicolon after a command");
    }

    private boolean readBoolean() {
        return Boolean.parseBoolean(this.readString());
    }

    private int readInt() {
        AFMParser aFMParser = this;
        return aFMParser.parseInt(aFMParser.readString(), 10);
    }

    private int parseInt(String string) {
        return this.parseInt(string, 10);
    }

    private int parseInt(String string, int n) {
        try {
            return Integer.parseInt(string, n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Error parsing AFM document:" + numberFormatException, numberFormatException);
        }
    }

    private float readFloat() {
        AFMParser aFMParser = this;
        return aFMParser.parseFloat(aFMParser.readString());
    }

    private float parseFloat(String string) {
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Error parsing AFM document:" + numberFormatException, numberFormatException);
        }
    }

    private String readLine() {
        StringBuilder stringBuilder = new StringBuilder(60);
        int n = this.input.read();
        while (this.isWhitespace(n)) {
            n = this.input.read();
        }
        stringBuilder.append((char)n);
        n = this.input.read();
        while (n != -1 && !this.isEOL(n)) {
            stringBuilder.append((char)n);
            n = this.input.read();
        }
        return stringBuilder.toString();
    }

    private String readString() {
        StringBuilder stringBuilder = new StringBuilder(24);
        int n = this.input.read();
        while (this.isWhitespace(n)) {
            n = this.input.read();
        }
        stringBuilder.append((char)n);
        n = this.input.read();
        while (n != -1 && !this.isWhitespace(n)) {
            stringBuilder.append((char)n);
            n = this.input.read();
        }
        return stringBuilder.toString();
    }

    private void readCommand(String string) {
        String string2 = this.readString();
        if (!string.equals(string2)) {
            throw new IOException("Error: Expected '" + string + "' actual '" + string2 + "'");
        }
    }

    private boolean isEOL(int n) {
        return n == 13 || n == 10;
    }

    private boolean isWhitespace(int n) {
        return n == 32 || n == 9 || n == 13 || n == 10;
    }
}

