/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.util.autodetect;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.util.autodetect.FontDirFinder;

public class WindowsFontDirFinder
implements FontDirFinder {
    private static final Log LOG = LogFactory.getLog(WindowsFontDirFinder.class);

    private String getWinDir(String object) {
        Object object2 = Runtime.getRuntime();
        object = ((String)object).startsWith("Windows 9") ? ((Runtime)object2).exec("command.com /c echo %windir%") : ((Runtime)object2).exec("cmd.exe /c echo %windir%");
        object = new BufferedReader(new InputStreamReader(((Process)object).getInputStream(), StandardCharsets.ISO_8859_1));
        object2 = null;
        try {
            String string = ((BufferedReader)object).readLine();
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            object2 = throwable;
            throw throwable2;
        }
        finally {
            if (object2 != null) {
                try {
                    ((BufferedReader)object).close();
                }
                catch (Throwable throwable) {
                    ((Throwable)object2).addSuppressed(throwable);
                }
            } else {
                ((BufferedReader)object).close();
            }
        }
    }

    @Override
    public List<File> find() {
        ArrayList<File> arrayList = new ArrayList<File>();
        Object object = null;
        try {
            object = System.getProperty("env.windir");
        }
        catch (SecurityException securityException) {
            LOG.debug((Object)"Couldn't get Windows font directories - ignoring", (Throwable)securityException);
        }
        String string = System.getProperty("os.name");
        if (object == null) {
            try {
                object = this.getWinDir(string);
            }
            catch (IOException | SecurityException exception) {
                LOG.debug((Object)"Couldn't get Windows font directories - ignoring", (Throwable)exception);
            }
        }
        if (object != null && ((String)object).length() > 2) {
            File file;
            if (((String)object).endsWith("/")) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
            if ((file = new File((String)object + File.separator + "FONTS")).exists() && file.canRead()) {
                arrayList.add(file);
            }
            if (((File)(object = new File(((String)object).substring(0, 2) + File.separator + "PSFONTS"))).exists() && ((File)object).canRead()) {
                arrayList.add((File)object);
            }
        } else {
            char c;
            object = string.endsWith("NT") ? "WINNT" : "WINDOWS";
            for (c = 'C'; c <= 'E'; c = (char)(c + '\u0001')) {
                File file = new File(c + ":" + File.separator + (String)object + File.separator + "FONTS");
                try {
                    if (!file.exists() || !file.canRead()) continue;
                    arrayList.add(file);
                    break;
                }
                catch (SecurityException securityException) {
                    LOG.debug((Object)"Couldn't get Windows font directories - ignoring", (Throwable)securityException);
                }
            }
            for (c = 'C'; c <= 'E'; c = (char)(c + '\u0001')) {
                object = new File(c + ":" + File.separator + "PSFONTS");
                try {
                    if (!((File)object).exists() || !((File)object).canRead()) continue;
                    arrayList.add((File)object);
                    break;
                }
                catch (SecurityException securityException) {
                    LOG.debug((Object)"Couldn't get Windows font directories - ignoring", (Throwable)securityException);
                }
            }
        }
        try {
            File file;
            object = System.getenv("LOCALAPPDATA");
            if (object != null && !((String)object).isEmpty() && (file = new File((String)object + File.separator + "Microsoft" + File.separator + "Windows" + File.separator + "Fonts")).exists() && file.canRead()) {
                arrayList.add(file);
            }
        }
        catch (SecurityException securityException) {
            LOG.debug((Object)"Couldn't get LOCALAPPDATA directory - ignoring", (Throwable)securityException);
        }
        return arrayList;
    }
}

