/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import org.apache.fontbox.ttf.HeaderTable;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;

public class IndexToLocationTable
extends TTFTable {
    private static final short SHORT_OFFSETS = 0;
    private static final short LONG_OFFSETS = 1;
    public static final String TAG = "loca";
    private long[] offsets;

    IndexToLocationTable() {
    }

    @Override
    void read(TrueTypeFont trueTypeFont, TTFDataStream tTFDataStream) {
        HeaderTable headerTable = trueTypeFont.getHeader();
        if (headerTable == null) {
            throw new IOException("Could not get head table");
        }
        int n = trueTypeFont.getNumberOfGlyphs();
        this.offsets = new long[n + 1];
        for (int i = 0; i < n + 1; ++i) {
            if (headerTable.getIndexToLocFormat() == 0) {
                this.offsets[i] = (long)tTFDataStream.readUnsignedShort() << 1;
                continue;
            }
            if (headerTable.getIndexToLocFormat() == 1) {
                this.offsets[i] = tTFDataStream.readUnsignedInt();
                continue;
            }
            throw new IOException("Error:TTF.loca unknown offset format: " + headerTable.getIndexToLocFormat());
        }
        this.initialized = true;
    }

    public long[] getOffsets() {
        return this.offsets;
    }

    public void setOffsets(long[] lArray) {
        this.offsets = lArray;
    }
}

