/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf.gsub;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.CmapLookup;
import org.apache.fontbox.ttf.gsub.GlyphArraySplitterRegexImpl;
import org.apache.fontbox.ttf.gsub.GsubWorker;
import org.apache.fontbox.ttf.gsub.GsubWorkerForBengali$BeforeAndAfterSpanComponent;
import org.apache.fontbox.ttf.model.GsubData;
import org.apache.fontbox.ttf.model.ScriptFeature;

public class GsubWorkerForBengali
implements GsubWorker {
    private static final Log LOG = LogFactory.getLog(GsubWorkerForBengali.class);
    private static final String INIT_FEATURE = "init";
    private static final List<String> FEATURES_IN_ORDER = Arrays.asList("locl", "nukt", "akhn", "rphf", "blwf", "pstf", "half", "vatu", "cjct", "init", "pres", "abvs", "blws", "psts", "haln", "calt");
    private static final char[] BEFORE_HALF_CHARS = new char[]{'\u09bf', '\u09c7', '\u09c8'};
    private static final GsubWorkerForBengali$BeforeAndAfterSpanComponent[] BEFORE_AND_AFTER_SPAN_CHARS = new GsubWorkerForBengali$BeforeAndAfterSpanComponent[]{new GsubWorkerForBengali$BeforeAndAfterSpanComponent('\u09cb', '\u09c7', '\u09be'), new GsubWorkerForBengali$BeforeAndAfterSpanComponent('\u09cc', '\u09c7', '\u09d7')};
    private final CmapLookup cmapLookup;
    private final GsubData gsubData;
    private final List<Integer> beforeHalfGlyphIds;
    private final Map<Integer, GsubWorkerForBengali$BeforeAndAfterSpanComponent> beforeAndAfterSpanGlyphIds;

    GsubWorkerForBengali(CmapLookup cmapLookup, GsubData gsubData) {
        this.cmapLookup = cmapLookup;
        this.gsubData = gsubData;
        this.beforeHalfGlyphIds = this.getBeforeHalfGlyphIds();
        this.beforeAndAfterSpanGlyphIds = this.getBeforeAndAfterSpanGlyphIds();
    }

    @Override
    public List<Integer> applyTransforms(List<Integer> list) {
        for (String string : FEATURES_IN_ORDER) {
            if (!this.gsubData.isFeatureSupported(string)) {
                LOG.debug((Object)("the feature " + string + " was not found"));
                continue;
            }
            LOG.debug((Object)("applying the feature " + string));
            ScriptFeature scriptFeature = this.gsubData.getFeature(string);
            list = this.applyGsubFeature(scriptFeature, list);
        }
        return Collections.unmodifiableList(this.repositionGlyphs(list));
    }

    private List<Integer> repositionGlyphs(List<Integer> list) {
        list = this.repositionBeforeHalfGlyphIds(list);
        return this.repositionBeforeAndAfterSpanGlyphIds(list);
    }

    private List<Integer> repositionBeforeHalfGlyphIds(List<Integer> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(list);
        for (int i = 1; i < list.size(); ++i) {
            int n = list.get(i);
            if (!this.beforeHalfGlyphIds.contains(n)) continue;
            int n2 = list.get(i - 1);
            arrayList.set(i, n2);
            arrayList.set(i - 1, n);
        }
        return arrayList;
    }

    private List<Integer> repositionBeforeAndAfterSpanGlyphIds(List<Integer> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(list);
        for (int i = 1; i < list.size(); ++i) {
            int n = list.get(i);
            GsubWorkerForBengali$BeforeAndAfterSpanComponent gsubWorkerForBengali$BeforeAndAfterSpanComponent = this.beforeAndAfterSpanGlyphIds.get(n);
            if (gsubWorkerForBengali$BeforeAndAfterSpanComponent == null) continue;
            int n2 = list.get(i - 1);
            arrayList.set(i, n2);
            arrayList.set(i - 1, this.getGlyphId(GsubWorkerForBengali$BeforeAndAfterSpanComponent.access$000(gsubWorkerForBengali$BeforeAndAfterSpanComponent)));
            arrayList.add(i + 1, this.getGlyphId(GsubWorkerForBengali$BeforeAndAfterSpanComponent.access$100(gsubWorkerForBengali$BeforeAndAfterSpanComponent)));
        }
        return arrayList;
    }

    private List<Integer> applyGsubFeature(ScriptFeature scriptFeature, List<Integer> list) {
        Collection<List<Integer>> collection = scriptFeature.getAllGlyphIdsForSubstitution();
        if (collection.isEmpty()) {
            LOG.debug((Object)("getAllGlyphIdsForSubstitution() for " + scriptFeature.getName() + " is empty"));
            return list;
        }
        collection = new GlyphArraySplitterRegexImpl((Set<List<Integer>>)collection);
        collection = collection.split(list);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(collection.size());
        collection.forEach(list2 -> {
            if (scriptFeature.canReplaceGlyphs((List<Integer>)list2)) {
                scriptFeature = scriptFeature.getReplacementForGlyphs((List<Integer>)list2);
                arrayList.add((Integer)((Object)scriptFeature));
                return;
            }
            arrayList.addAll((Collection<Integer>)list2);
        });
        LOG.debug((Object)("originalGlyphs: " + list + ", gsubProcessedGlyphs: " + arrayList));
        return arrayList;
    }

    private List<Integer> getBeforeHalfGlyphIds() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(BEFORE_HALF_CHARS.length);
        Object object = BEFORE_HALF_CHARS;
        int n = BEFORE_HALF_CHARS.length;
        for (int i = 0; i < n; ++i) {
            char c = object[i];
            arrayList.add(this.getGlyphId(c));
        }
        if (this.gsubData.isFeatureSupported(INIT_FEATURE)) {
            ScriptFeature scriptFeature = this.gsubData.getFeature(INIT_FEATURE);
            object = scriptFeature;
            for (List<Integer> list : scriptFeature.getAllGlyphIdsForSubstitution()) {
                arrayList.add(object.getReplacementForGlyphs(list));
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    private Integer getGlyphId(char c) {
        return this.cmapLookup.getGlyphId(c);
    }

    private Map<Integer, GsubWorkerForBengali$BeforeAndAfterSpanComponent> getBeforeAndAfterSpanGlyphIds() {
        HashMap<Integer, GsubWorkerForBengali$BeforeAndAfterSpanComponent> hashMap = new HashMap<Integer, GsubWorkerForBengali$BeforeAndAfterSpanComponent>();
        GsubWorkerForBengali$BeforeAndAfterSpanComponent[] gsubWorkerForBengali$BeforeAndAfterSpanComponentArray = BEFORE_AND_AFTER_SPAN_CHARS;
        int n = BEFORE_AND_AFTER_SPAN_CHARS.length;
        for (int i = 0; i < n; ++i) {
            GsubWorkerForBengali$BeforeAndAfterSpanComponent gsubWorkerForBengali$BeforeAndAfterSpanComponent = gsubWorkerForBengali$BeforeAndAfterSpanComponentArray[i];
            hashMap.put(this.getGlyphId(GsubWorkerForBengali$BeforeAndAfterSpanComponent.access$200(gsubWorkerForBengali$BeforeAndAfterSpanComponent)), gsubWorkerForBengali$BeforeAndAfterSpanComponent);
        }
        return Collections.unmodifiableMap(hashMap);
    }
}

