/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko;

import java.awt.Font;
import java.awt.color.ColorSpace;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.af;
import kotlinx.coroutines.l;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.FontSlant;
import org.jetbrains.skia.Image;
import org.jetbrains.skia.ImageInfo;
import org.jetbrains.skia.Pixmap;
import org.jetbrains.skia.Typeface;
import org.jetbrains.skia.impl.BufferUtil;
import org.jetbrains.skiko.Convertors_jvmKt$WhenMappings;
import org.jetbrains.skiko.Convertors_jvmKt$toSkikoTypefaceOrNull$2;
import org.jetbrains.skiko.DirectDataBuffer;
import org.jetbrains.skiko.SkikoInputEvent;
import org.jetbrains.skiko.SkikoInputModifiers;
import org.jetbrains.skiko.SkikoKey;
import org.jetbrains.skiko.SkikoKeyboardEvent;
import org.jetbrains.skiko.SkikoKeyboardEventKind;
import org.jetbrains.skiko.SkikoMouseButtons;
import org.jetbrains.skiko.SkikoPointerEvent;
import org.jetbrains.skiko.SkikoPointerEventKind;
import org.jetbrains.skiko.awt.font.AwtFontManager;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u000e\u0010\u0010\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0015\u001a\u000e\u0010\u0010\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0016\u001a\u0010\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0001H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001b\u001a\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u0015H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001e\u001a\u0018\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u0015H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001e\u001a\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u0012\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0013\u001a\u0018\u0010\"\u001a\u00020#2\u0006\u0010&\u001a\u00020\u00132\b\u0010%\u001a\u0004\u0018\u00010\u0013\u001a\u0010\u0010'\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0007H\u0000\u001a\u0010\u0010(\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0007H\u0000\u001a\n\u0010)\u001a\u00020**\u00020+\u001a\n\u0010,\u001a\u00020+*\u00020*\u001a\n\u0010-\u001a\u00020.*\u00020+\u001a\u001f\u0010/\u001a\u0004\u0018\u000100*\u00020\t2\u0006\u00101\u001a\u000202H\u0087@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00103\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0003\" \u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007*\u00020\t8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\" \u0010\f\u001a\n \b*\u0004\u0018\u00010\u00070\u0007*\u00020\t8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\" \u0010\u000e\u001a\n \b*\u0004\u0018\u00010\u00070\u0007*\u00020\t8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00064"}, d2={"MouseEventButton4", "", "getMouseEventButton4", "()I", "MouseEventButton5", "getMouseEventButton5", "posture", "", "kotlin.jvm.PlatformType", "Ljava/awt/Font;", "getPosture", "(Ljava/awt/Font;)Ljava/lang/Float;", "weight", "getWeight", "width", "getWidth", "toSkikoEvent", "Lorg/jetbrains/skiko/SkikoKeyboardEvent;", "event", "Ljava/awt/event/KeyEvent;", "Lorg/jetbrains/skiko/SkikoPointerEvent;", "Ljava/awt/event/MouseEvent;", "Ljava/awt/event/MouseWheelEvent;", "toSkikoKey", "toSkikoModifiers", "Lorg/jetbrains/skiko/SkikoInputModifiers;", "modifiers", "(I)I", "toSkikoMouseButton", "Lorg/jetbrains/skiko/SkikoMouseButtons;", "(Ljava/awt/event/MouseEvent;)I", "toSkikoPressedMouseButtons", "toSkikoSlant", "Lorg/jetbrains/skia/FontSlant;", "toSkikoTypeEvent", "Lorg/jetbrains/skiko/SkikoInputEvent;", "Ljava/awt/event/InputMethodEvent;", "keyEvent", "typeEvent", "toSkikoWeight", "toSkikoWidth", "toBitmap", "Lorg/jetbrains/skia/Bitmap;", "Ljava/awt/image/BufferedImage;", "toBufferedImage", "toImage", "Lorg/jetbrains/skia/Image;", "toSkikoTypefaceOrNull", "Lorg/jetbrains/skia/Typeface;", "fontManager", "Lorg/jetbrains/skiko/awt/font/AwtFontManager;", "(Ljava/awt/Font;Lorg/jetbrains/skiko/awt/font/AwtFontManager;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "skiko"})
public final class Convertors_jvmKt {
    public static final BufferedImage toBufferedImage(Bitmap object) {
        int[] nArray;
        int[] nArray2;
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Pixmap pixmap = ((Bitmap)object).peekPixels();
        Intrinsics.checkNotNull((Object)pixmap);
        long l = pixmap.getAddr();
        Object object2 = BufferUtil.INSTANCE.getByteBufferFromPointer(l, ((Bitmap)object).getRowBytes() * ((Bitmap)object).getHeight());
        switch (Convertors_jvmKt$WhenMappings.$EnumSwitchMapping$0[((Bitmap)object).getColorInfo().getColorType().ordinal()]) {
            case 1: {
                int[] nArray3 = new int[4];
                nArray2 = nArray3;
                nArray3[0] = 0;
                nArray2[1] = 1;
                nArray2[2] = 2;
                nArray2[3] = 3;
                nArray = nArray2;
                break;
            }
            case 2: {
                int[] nArray4 = new int[4];
                nArray2 = nArray4;
                nArray4[0] = 2;
                nArray2[1] = 1;
                nArray2[2] = 0;
                nArray2[3] = 3;
                nArray = nArray2;
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported color type " + (Object)((Object)((Bitmap)object).getColorInfo().getColorType()));
            }
        }
        nArray2 = nArray;
        object = Raster.createInterleavedRaster(new DirectDataBuffer((ByteBuffer)object2), ((Bitmap)object).getWidth(), ((Bitmap)object).getHeight(), ((Bitmap)object).getWidth() << 2, 4, nArray2, null);
        object2 = new ComponentColorModel(ColorSpace.getInstance(1000), true, false, 3, 0);
        ColorModel colorModel = (ColorModel)object2;
        Object object3 = object;
        Intrinsics.checkNotNull((Object)object3);
        return new BufferedImage(colorModel, (WritableRaster)object3, false, null);
    }

    public static final Bitmap toBitmap(BufferedImage bufferedImage) {
        Intrinsics.checkNotNullParameter((Object)bufferedImage, (String)"");
        byte[] byArray = new byte[bufferedImage.getWidth() * bufferedImage.getHeight() << 2];
        int n = 0;
        int n2 = bufferedImage.getHeight();
        for (int i = 0; i < n2; ++i) {
            int n3 = bufferedImage.getWidth();
            for (int j = 0; j < n3; ++j) {
                int n4 = bufferedImage.getRGB(j, i);
                int n5 = n4 >>> 24;
                int n6 = n4 >> 16 & 0xFF;
                int n7 = n4 >> 8 & 0xFF;
                byArray[n++] = (byte)(n4 &= 0xFF);
                byArray[n++] = (byte)n7;
                byArray[n++] = (byte)n6;
                byArray[n++] = (byte)n5;
            }
        }
        Bitmap bitmap = new Bitmap();
        bitmap.allocPixels(ImageInfo.Companion.makeS32(bufferedImage.getWidth(), bufferedImage.getHeight(), ColorAlphaType.UNPREMUL));
        bitmap.installPixels(byArray);
        return bitmap;
    }

    public static final Image toImage(BufferedImage bufferedImage) {
        Intrinsics.checkNotNullParameter((Object)bufferedImage, (String)"");
        return Image.Companion.makeFromBitmap(Convertors_jvmKt.toBitmap(bufferedImage));
    }

    private static final int getMouseEventButton4() {
        return 4;
    }

    private static final int getMouseEventButton5() {
        return 5;
    }

    public static final SkikoPointerEvent toSkikoEvent(MouseEvent mouseEvent) {
        SkikoPointerEventKind skikoPointerEventKind;
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"");
        double d = mouseEvent.getX();
        double d2 = mouseEvent.getY();
        int n = Convertors_jvmKt.toSkikoPressedMouseButtons(mouseEvent);
        int n2 = Convertors_jvmKt.toSkikoMouseButton(mouseEvent);
        int n3 = Convertors_jvmKt.toSkikoModifiers(mouseEvent.getModifiersEx());
        switch (mouseEvent.getID()) {
            case 501: {
                skikoPointerEventKind = SkikoPointerEventKind.DOWN;
                break;
            }
            case 502: {
                skikoPointerEventKind = SkikoPointerEventKind.UP;
                break;
            }
            case 506: {
                skikoPointerEventKind = SkikoPointerEventKind.DRAG;
                break;
            }
            case 503: {
                skikoPointerEventKind = SkikoPointerEventKind.MOVE;
                break;
            }
            case 504: {
                skikoPointerEventKind = SkikoPointerEventKind.ENTER;
                break;
            }
            case 505: {
                skikoPointerEventKind = SkikoPointerEventKind.EXIT;
                break;
            }
            default: {
                skikoPointerEventKind = SkikoPointerEventKind.UNKNOWN;
            }
        }
        SkikoPointerEventKind skikoPointerEventKind2 = skikoPointerEventKind;
        long l = mouseEvent.getWhen();
        return new SkikoPointerEvent(d, d2, skikoPointerEventKind2, 0.0, 0.0, n, n2, n3, l, null, mouseEvent, 536, null);
    }

    public static final SkikoPointerEvent toSkikoEvent(MouseWheelEvent mouseWheelEvent) {
        Intrinsics.checkNotNullParameter((Object)mouseWheelEvent, (String)"");
        double d = mouseWheelEvent.getPreciseWheelRotation();
        int n = Convertors_jvmKt.toSkikoModifiers(mouseWheelEvent.getModifiersEx());
        boolean bl = SkikoInputModifiers.has-TH98kIg(n, SkikoInputModifiers.Companion.getSHIFT-kKhcapQ());
        double d2 = bl ? d : 0.0;
        double d3 = bl ? 0.0 : d;
        double d4 = mouseWheelEvent.getX();
        double d5 = mouseWheelEvent.getY();
        int n2 = Convertors_jvmKt.toSkikoPressedMouseButtons(mouseWheelEvent);
        int n3 = Convertors_jvmKt.toSkikoMouseButton(mouseWheelEvent);
        SkikoPointerEventKind skikoPointerEventKind = mouseWheelEvent.getID() == 507 ? SkikoPointerEventKind.SCROLL : SkikoPointerEventKind.UNKNOWN;
        long l = mouseWheelEvent.getWhen();
        return new SkikoPointerEvent(d4, d5, skikoPointerEventKind, d2, d3, n2, n3, n, l, null, mouseWheelEvent, 512, null);
    }

    public static final SkikoKeyboardEvent toSkikoEvent(KeyEvent keyEvent) {
        SkikoKeyboardEventKind skikoKeyboardEventKind;
        Intrinsics.checkNotNullParameter((Object)keyEvent, (String)"");
        SkikoKey skikoKey = SkikoKey.Companion.valueOf(Convertors_jvmKt.toSkikoKey(keyEvent));
        int n = Convertors_jvmKt.toSkikoModifiers(keyEvent.getModifiersEx());
        switch (keyEvent.getID()) {
            case 401: {
                skikoKeyboardEventKind = SkikoKeyboardEventKind.DOWN;
                break;
            }
            case 402: {
                skikoKeyboardEventKind = SkikoKeyboardEventKind.UP;
                break;
            }
            default: {
                skikoKeyboardEventKind = SkikoKeyboardEventKind.UNKNOWN;
            }
        }
        return new SkikoKeyboardEvent(skikoKey, n, skikoKeyboardEventKind, keyEvent.getWhen(), keyEvent, null);
    }

    public static final SkikoInputEvent toSkikoTypeEvent(KeyEvent keyEvent, KeyEvent keyEvent2) {
        Intrinsics.checkNotNullParameter((Object)keyEvent, (String)"");
        int n = -1;
        int n2 = SkikoInputModifiers.Companion.getEMPTY-kKhcapQ();
        if (keyEvent2 != null) {
            n = Convertors_jvmKt.toSkikoKey(keyEvent2);
            n2 = Convertors_jvmKt.toSkikoModifiers(keyEvent2.getModifiersEx());
        }
        return new SkikoInputEvent(String.valueOf(keyEvent.getKeyChar()), SkikoKey.Companion.valueOf(n), n2, SkikoKeyboardEventKind.TYPE, keyEvent, null);
    }

    public static final SkikoInputEvent toSkikoTypeEvent(InputMethodEvent inputMethodEvent, KeyEvent keyEvent) {
        Intrinsics.checkNotNullParameter((Object)inputMethodEvent, (String)"");
        int n = -1;
        int n2 = SkikoInputModifiers.Companion.getEMPTY-kKhcapQ();
        if (keyEvent != null) {
            n = Convertors_jvmKt.toSkikoKey(keyEvent);
            n2 = Convertors_jvmKt.toSkikoModifiers(keyEvent.getModifiersEx());
        }
        return new SkikoInputEvent("", SkikoKey.Companion.valueOf(n), n2, SkikoKeyboardEventKind.TYPE, inputMethodEvent, null);
    }

    private static final int toSkikoPressedMouseButtons(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiersEx();
        int n2 = 0;
        if ((n & 0x400) != 0 || mouseEvent.getID() == 501 && mouseEvent.getButton() == 1) {
            n2 = 0 | SkikoMouseButtons.Companion.getLEFT-CuO1FYg();
        }
        if ((n & 0x800) != 0 || mouseEvent.getID() == 501 && mouseEvent.getButton() == 2) {
            n2 |= SkikoMouseButtons.Companion.getMIDDLE-CuO1FYg();
        }
        if ((n & 0x1000) != 0 || mouseEvent.getID() == 501 && mouseEvent.getButton() == 3) {
            n2 |= SkikoMouseButtons.Companion.getRIGHT-CuO1FYg();
        }
        if ((n & MouseEvent.getMaskForButton(Convertors_jvmKt.getMouseEventButton4())) != 0 || mouseEvent.getID() == 501 && mouseEvent.getButton() == Convertors_jvmKt.getMouseEventButton4()) {
            n2 |= SkikoMouseButtons.Companion.getBUTTON_4-CuO1FYg();
        }
        if ((n & MouseEvent.getMaskForButton(Convertors_jvmKt.getMouseEventButton5())) != 0 || mouseEvent.getID() == 501 && mouseEvent.getButton() == Convertors_jvmKt.getMouseEventButton5()) {
            n2 |= SkikoMouseButtons.Companion.getBUTTON_5-CuO1FYg();
        }
        return SkikoMouseButtons.constructor-impl(n2);
    }

    private static final int toSkikoMouseButton(MouseEvent mouseEvent) {
        int n = mouseEvent.getButton();
        if (n == 1) {
            return SkikoMouseButtons.Companion.getLEFT-CuO1FYg();
        }
        if (n == 2) {
            return SkikoMouseButtons.Companion.getMIDDLE-CuO1FYg();
        }
        if (n == 3) {
            return SkikoMouseButtons.Companion.getRIGHT-CuO1FYg();
        }
        if (n == Convertors_jvmKt.getMouseEventButton4()) {
            return SkikoMouseButtons.Companion.getBUTTON_4-CuO1FYg();
        }
        if (n == Convertors_jvmKt.getMouseEventButton5()) {
            return SkikoMouseButtons.Companion.getBUTTON_5-CuO1FYg();
        }
        return SkikoMouseButtons.constructor-impl(mouseEvent.getButton());
    }

    private static final int toSkikoModifiers(int n) {
        int n2 = 0;
        if ((n & 0x200) != 0) {
            n2 = SkikoInputModifiers.Companion.getALT-kKhcapQ();
        }
        if ((n & 0x40) != 0) {
            n2 |= SkikoInputModifiers.Companion.getSHIFT-kKhcapQ();
        }
        if ((n & 0x80) != 0) {
            n2 |= SkikoInputModifiers.Companion.getCONTROL-kKhcapQ();
        }
        if ((n & 0x100) != 0) {
            n2 |= SkikoInputModifiers.Companion.getMETA-kKhcapQ();
        }
        return SkikoInputModifiers.constructor-impl(n2);
    }

    private static final int toSkikoKey(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getKeyLocation();
        if (n2 == 3 && (n == SkikoKey.KEY_LEFT_CONTROL.getPlatformKeyCode() || n == SkikoKey.KEY_LEFT_SHIFT.getPlatformKeyCode() || n == SkikoKey.KEY_LEFT_META.getPlatformKeyCode())) {
            n |= Integer.MIN_VALUE;
        }
        if (n2 == 4 && n == SkikoKey.KEY_ENTER.getPlatformKeyCode()) {
            n |= Integer.MIN_VALUE;
        }
        return n;
    }

    public static final Object toSkikoTypefaceOrNull(Font font, AwtFontManager awtFontManager, Continuation<? super Typeface> continuation) {
        return l.a((CoroutineContext)((CoroutineContext)af.a()), (Function2)new Convertors_jvmKt$toSkikoTypefaceOrNull$2(font, awtFontManager, null), continuation);
    }

    public static final int toSkikoWeight(float f) {
        if (f <= 0.01f) {
            return 0;
        }
        Float f2 = TextAttribute.WEIGHT_EXTRA_LIGHT;
        Intrinsics.checkNotNullExpressionValue((Object)f2, (String)"");
        if (f <= ((Number)f2).floatValue()) {
            return 100;
        }
        Float f3 = TextAttribute.WEIGHT_LIGHT;
        Intrinsics.checkNotNullExpressionValue((Object)f3, (String)"");
        if (f <= ((Number)f3).floatValue()) {
            return 200;
        }
        Float f4 = TextAttribute.WEIGHT_DEMILIGHT;
        Intrinsics.checkNotNullExpressionValue((Object)f4, (String)"");
        if (f <= ((Number)f4).floatValue()) {
            return 300;
        }
        Float f5 = TextAttribute.WEIGHT_REGULAR;
        Intrinsics.checkNotNullExpressionValue((Object)f5, (String)"");
        if (f <= ((Number)f5).floatValue()) {
            return 400;
        }
        Float f6 = TextAttribute.WEIGHT_MEDIUM;
        Intrinsics.checkNotNullExpressionValue((Object)f6, (String)"");
        if (f <= ((Number)f6).floatValue()) {
            return 500;
        }
        Float f7 = TextAttribute.WEIGHT_DEMIBOLD;
        Intrinsics.checkNotNullExpressionValue((Object)f7, (String)"");
        if (f <= ((Number)f7).floatValue()) {
            return 600;
        }
        Float f8 = TextAttribute.WEIGHT_BOLD;
        Intrinsics.checkNotNullExpressionValue((Object)f8, (String)"");
        if (f <= ((Number)f8).floatValue()) {
            return 700;
        }
        Float f9 = TextAttribute.WEIGHT_HEAVY;
        Intrinsics.checkNotNullExpressionValue((Object)f9, (String)"");
        if (f <= ((Number)f9).floatValue()) {
            return 800;
        }
        Float f10 = TextAttribute.WEIGHT_EXTRABOLD;
        Intrinsics.checkNotNullExpressionValue((Object)f10, (String)"");
        if (f <= ((Number)f10).floatValue()) {
            return 900;
        }
        return 1000;
    }

    public static final int toSkikoWidth(float f) {
        Float f2 = TextAttribute.WIDTH_CONDENSED;
        Intrinsics.checkNotNullExpressionValue((Object)f2, (String)"");
        if (f <= ((Number)f2).floatValue()) {
            return 3;
        }
        Float f3 = TextAttribute.WIDTH_SEMI_CONDENSED;
        Intrinsics.checkNotNullExpressionValue((Object)f3, (String)"");
        if (f <= ((Number)f3).floatValue()) {
            return 4;
        }
        Float f4 = TextAttribute.WIDTH_REGULAR;
        Intrinsics.checkNotNullExpressionValue((Object)f4, (String)"");
        if (f <= ((Number)f4).floatValue()) {
            return 5;
        }
        Float f5 = TextAttribute.WIDTH_SEMI_EXTENDED;
        Intrinsics.checkNotNullExpressionValue((Object)f5, (String)"");
        if (f <= ((Number)f5).floatValue()) {
            return 6;
        }
        return 7;
    }

    public static final FontSlant toSkikoSlant(float f) {
        Float f2 = TextAttribute.POSTURE_REGULAR;
        Intrinsics.checkNotNullExpressionValue((Object)f2, (String)"");
        if (f <= ((Number)f2).floatValue()) {
            return FontSlant.UPRIGHT;
        }
        return FontSlant.ITALIC;
    }

    public static final Float getWeight(Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"");
        font = font.getAttributes().get(TextAttribute.WEIGHT);
        Float f = font instanceof Float ? (Float)((Object)font) : null;
        if (f == null) {
            f = TextAttribute.WEIGHT_REGULAR;
        }
        return f;
    }

    public static final Float getWidth(Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"");
        font = font.getAttributes().get(TextAttribute.WIDTH);
        Float f = font instanceof Float ? (Float)((Object)font) : null;
        if (f == null) {
            f = TextAttribute.WIDTH_REGULAR;
        }
        return f;
    }

    public static final Float getPosture(Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"");
        font = font.getAttributes().get(TextAttribute.POSTURE);
        Float f = font instanceof Float ? (Float)((Object)font) : null;
        if (f == null) {
            f = TextAttribute.POSTURE_REGULAR;
        }
        return f;
    }
}

