/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.Surface;
import org.jetbrains.skiko.CloseScope;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.GraphicsApi_jvmKt;
import org.jetbrains.skiko.Library;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.ResourceUtilsKt;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkikoView;
import org.jetbrains.skiko.swing.Direct3DSwingRedrawer$Companion;
import org.jetbrains.skiko.swing.Direct3DSwingRedrawer$onRender$1;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingOffscreenDrawer;
import org.jetbrains.skiko.swing.SwingRedrawerBase;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 32\u00020\u0001:\u00013B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0011H\u0082 J\u0011\u0010\u0018\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0082 J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0011\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\nH\u0082 J\u0011\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\nH\u0082 J\u0016\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\t\u0010\"\u001a\u00020\nH\u0082 J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0011\u0010'\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0082 J\u0011\u0010(\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0082 J)\u0010)\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u0011H\u0082 J\b\u0010-\u001a\u00020.H\u0002J(\u0010/\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!2\u0006\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u00112\u0006\u00100\u001a\u00020\nH\u0014J!\u00101\u001a\u00020$2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u00102\u001a\u00020\fH\u0082 R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/jetbrains/skiko/swing/Direct3DSwingRedrawer;", "Lorg/jetbrains/skiko/swing/SwingRedrawerBase;", "swingLayerProperties", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;", "skikoView", "Lorg/jetbrains/skiko/SkikoView;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "(Lorg/jetbrains/skiko/swing/SwingLayerProperties;Lorg/jetbrains/skiko/SkikoView;Lorg/jetbrains/skiko/SkiaLayerAnalytics;)V", "adapter", "", "bytesToDraw", "", "context", "Lorg/jetbrains/skia/DirectContext;", "device", "rowBytesAlignment", "", "swingOffscreenDrawer", "Lorg/jetbrains/skiko/swing/SwingOffscreenDrawer;", "texturePtr", "widthSizeAlignment", "chooseAdapter", "adapterPriority", "createDirectXOffscreenDevice", "dispose", "", "disposeDevice", "disposeDirectXTexture", "flush", "surface", "Lorg/jetbrains/skia/Surface;", "g", "Ljava/awt/Graphics2D;", "getAlignment", "isAdapterSupported", "", "name", "", "makeDirectXContext", "makeDirectXRenderTargetOffScreen", "makeDirectXTexture", "oldTexturePtr", "width", "height", "makeRenderTarget", "Lorg/jetbrains/skia/BackendRenderTarget;", "onRender", "nanoTime", "readPixels", "byteArray", "Companion", "skiko"})
public final class Direct3DSwingRedrawer
extends SwingRedrawerBase {
    public static final Direct3DSwingRedrawer$Companion Companion = new Direct3DSwingRedrawer$Companion(null);
    private final SkikoView skikoView;
    private final long adapter;
    private final long device;
    private final SwingOffscreenDrawer swingOffscreenDrawer;
    private final DirectContext context;
    private long texturePtr;
    private byte[] bytesToDraw;
    private final int rowBytesAlignment;
    private final int widthSizeAlignment;

    public Direct3DSwingRedrawer(SwingLayerProperties swingLayerProperties2, SkikoView object, SkiaLayerAnalytics skiaLayerAnalytics) {
        Intrinsics.checkNotNullParameter((Object)swingLayerProperties2, (String)"");
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)skiaLayerAnalytics, (String)"");
        super(swingLayerProperties2, skiaLayerAnalytics, GraphicsApi.DIRECT3D);
        this.skikoView = object;
        Direct3DSwingRedrawer direct3DSwingRedrawer = this;
        long l2 = direct3DSwingRedrawer.chooseAdapter(swingLayerProperties2.getAdapterPriority().ordinal());
        object = direct3DSwingRedrawer;
        this.onDeviceChosen("DirectX12");
        ((Direct3DSwingRedrawer)object).adapter = l2;
        this.device = this.createDirectXOffscreenDevice(this.adapter);
        this.swingOffscreenDrawer = new SwingOffscreenDrawer(swingLayerProperties2);
        Direct3DSwingRedrawer direct3DSwingRedrawer2 = this;
        this.context = new DirectContext(direct3DSwingRedrawer2.makeDirectXContext(direct3DSwingRedrawer2.device));
        this.bytesToDraw = new byte[0];
        this.rowBytesAlignment = (int)this.getAlignment();
        this.widthSizeAlignment = this.rowBytesAlignment / 4;
        this.onContextInit();
    }

    @Override
    public final void dispose() {
        this.bytesToDraw = new byte[0];
        this.context.close();
        Direct3DSwingRedrawer direct3DSwingRedrawer = this;
        direct3DSwingRedrawer.disposeDirectXTexture(direct3DSwingRedrawer.texturePtr);
        Direct3DSwingRedrawer direct3DSwingRedrawer2 = this;
        direct3DSwingRedrawer2.disposeDevice(direct3DSwingRedrawer2.device);
        super.dispose();
    }

    @Override
    protected final void onRender(Graphics2D graphics2D, int n, int n2, long l2) {
        Intrinsics.checkNotNullParameter((Object)graphics2D, (String)"");
        ResourceUtilsKt.autoCloseScope((Function1<? super CloseScope, Unit>)((Function1)new Direct3DSwingRedrawer$onRender$1(n, this, n2, l2, graphics2D)));
    }

    public final void flush(Surface surface, Graphics2D graphics2D) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"");
        Intrinsics.checkNotNullParameter((Object)graphics2D, (String)"");
        surface.flushAndSubmit(false);
        int n = surface.getWidth() * surface.getHeight() << 2;
        if (this.bytesToDraw.length != n) {
            this.bytesToDraw = new byte[n];
        }
        Direct3DSwingRedrawer direct3DSwingRedrawer = this;
        if (!direct3DSwingRedrawer.readPixels(direct3DSwingRedrawer.device, this.texturePtr, this.bytesToDraw)) {
            throw new RenderException("Couldn't read pixels", null, 2, null);
        }
        this.swingOffscreenDrawer.draw(graphics2D, this.bytesToDraw, surface.getWidth(), surface.getHeight());
    }

    private final BackendRenderTarget makeRenderTarget() {
        Direct3DSwingRedrawer direct3DSwingRedrawer = this;
        return new BackendRenderTarget(direct3DSwingRedrawer.makeDirectXRenderTargetOffScreen(direct3DSwingRedrawer.texturePtr));
    }

    private final boolean isAdapterSupported(String string) {
        return GraphicsApi_jvmKt.isVideoCardSupported(GraphicsApi.DIRECT3D, OsArch_jvmKt.getHostOs(), string);
    }

    private final native long chooseAdapter(int var1);

    private final native long createDirectXOffscreenDevice(long var1);

    private final native long makeDirectXContext(long var1);

    private final native boolean readPixels(long var1, long var3, byte[] var5);

    private final native long getAlignment();

    private final native long makeDirectXTexture(long var1, long var3, int var5, int var6);

    private final native void disposeDirectXTexture(long var1);

    private final native long makeDirectXRenderTargetOffScreen(long var1);

    private final native void disposeDevice(long var1);

    public static final /* synthetic */ int access$getWidthSizeAlignment$p(Direct3DSwingRedrawer direct3DSwingRedrawer) {
        return direct3DSwingRedrawer.widthSizeAlignment;
    }

    public static final /* synthetic */ void access$setTexturePtr$p(Direct3DSwingRedrawer direct3DSwingRedrawer, long l2) {
        direct3DSwingRedrawer.texturePtr = l2;
    }

    public static final /* synthetic */ long access$makeDirectXTexture(Direct3DSwingRedrawer direct3DSwingRedrawer, long l2, long l3, int n, int n2) {
        return direct3DSwingRedrawer.makeDirectXTexture(l2, l3, n, n2);
    }

    public static final /* synthetic */ long access$getDevice$p(Direct3DSwingRedrawer direct3DSwingRedrawer) {
        return direct3DSwingRedrawer.device;
    }

    public static final /* synthetic */ long access$getTexturePtr$p(Direct3DSwingRedrawer direct3DSwingRedrawer) {
        return direct3DSwingRedrawer.texturePtr;
    }

    public static final /* synthetic */ BackendRenderTarget access$makeRenderTarget(Direct3DSwingRedrawer direct3DSwingRedrawer) {
        return direct3DSwingRedrawer.makeRenderTarget();
    }

    public static final /* synthetic */ DirectContext access$getContext$p(Direct3DSwingRedrawer direct3DSwingRedrawer) {
        return direct3DSwingRedrawer.context;
    }

    public static final /* synthetic */ SkikoView access$getSkikoView$p(Direct3DSwingRedrawer direct3DSwingRedrawer) {
        return direct3DSwingRedrawer.skikoView;
    }

    static {
        Library.INSTANCE.load();
    }
}

