/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.VolatileImage;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingLayerPropertiesKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0080\u0001\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0012\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\f2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(H\u0002Jv\u0010)\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020(2\u0006\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0012\u001a\u00020\u00172\b\u0010*\u001a\u0004\u0018\u00010\u00102\b\u0010%\u001a\u0004\u0018\u00010&H\u0002J&\u0010+\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJd\u0010,\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u00172\b\b\u0002\u0010-\u001a\u00020\f2\b\b\u0002\u0010.\u001a\u00020\f2\b\b\u0002\u0010\u001c\u001a\u00020\f2\b\b\u0002\u0010\u001d\u001a\u00020\f2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&H\u0002J\u0018\u0010/\u001a\u00020\u00142\u0006\u00100\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0018\u00101\u001a\u00020\f2\u0006\u00102\u001a\u00020\f2\u0006\u0010'\u001a\u00020(H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/skiko/swing/SwingOffscreenDrawer;", "", "swingLayerProperties", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;", "(Lorg/jetbrains/skiko/swing/SwingLayerProperties;)V", "volatileImage", "Ljava/awt/image/VolatileImage;", "createImageFromBytes", "Ljava/awt/image/BufferedImage;", "bytes", "", "width", "", "height", "dirtyRectangles", "", "Ljava/awt/Rectangle;", "createVolatileImage", "image", "doDraw", "", "op", "Ljava/awt/image/BufferedImageOp;", "Ljava/awt/Image;", "invG", "Ljava/awt/Graphics2D;", "hasDestinationSize", "", "dw", "dh", "sourceBounds", "userWidth", "userHeight", "g", "Ljava/awt/Graphics;", "dx", "dy", "observer", "Ljava/awt/image/ImageObserver;", "scale", "", "doDrawHiDpi", "srcBounds", "draw", "drawImage", "x", "y", "drawVolatileImage", "vi", "scaleSize", "size", "skiko"})
public final class SwingOffscreenDrawer {
    private final SwingLayerProperties swingLayerProperties;
    private volatile VolatileImage volatileImage;

    public SwingOffscreenDrawer(SwingLayerProperties swingLayerProperties2) {
        Intrinsics.checkNotNullParameter((Object)swingLayerProperties2, (String)"");
        this.swingLayerProperties = swingLayerProperties2;
    }

    public final void draw(Graphics2D graphics2D, byte[] object, int n, int n2) {
        VolatileImage volatileImage;
        Intrinsics.checkNotNullParameter((Object)graphics2D, (String)"");
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        List list2 = CollectionsKt.listOf((Object)new Rectangle(0, 0, n, n2));
        object = this.createImageFromBytes((byte[])object, n, n2, list2);
        VolatileImage volatileImage2 = this.volatileImage;
        do {
            if (volatileImage2 == null || volatileImage2.getWidth() != this.swingLayerProperties.getWidth() || volatileImage2.getHeight() != this.swingLayerProperties.getHeight()) {
                volatileImage2 = this.createVolatileImage((BufferedImage)object);
            }
            this.drawVolatileImage(volatileImage2, (BufferedImage)object);
            switch (volatileImage2.validate(this.swingLayerProperties.getGraphicsConfiguration())) {
                case 1: {
                    this.drawVolatileImage(volatileImage2, (BufferedImage)object);
                    break;
                }
                case 2: {
                    volatileImage2 = this.createVolatileImage((BufferedImage)object);
                }
            }
            graphics2D.drawImage(volatileImage2, 0, 0, null);
            volatileImage = volatileImage2;
            Intrinsics.checkNotNull((Object)volatileImage);
        } while (volatileImage.contentsLost());
        this.volatileImage = volatileImage2;
    }

    private final BufferedImage createImageFromBytes(byte[] object, int n, int n2, List<? extends Rectangle> object2) {
        object = ByteBuffer.wrap((byte[])object);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 3);
        DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
        Intrinsics.checkNotNull((Object)dataBuffer);
        int[] nArray = ((DataBufferInt)dataBuffer).getData();
        IntBuffer intBuffer = ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)intBuffer, (String)"");
        IntBuffer intBuffer2 = intBuffer;
        object2 = object2.iterator();
        while (object2.hasNext()) {
            int n3;
            Rectangle rectangle = (Rectangle)object2.next();
            if (rectangle.width < bufferedImage.getWidth()) {
                int n4 = rectangle.y + rectangle.height;
                for (n3 = rectangle.y; n3 < n4; ++n3) {
                    int n5 = n3 * bufferedImage.getWidth() + rectangle.x;
                    intBuffer2.position(n5).get(nArray, n5, (int)Math.min((double)rectangle.width, (double)(((Buffer)object).capacity() - n5)));
                }
                continue;
            }
            n3 = rectangle.y * bufferedImage.getWidth();
            intBuffer2.position(n3).get(nArray, n3, (int)Math.min((double)(rectangle.height * bufferedImage.getWidth()), (double)(((Buffer)object).capacity() - n3)));
        }
        return bufferedImage;
    }

    private final VolatileImage createVolatileImage(BufferedImage bufferedImage) {
        VolatileImage volatileImage = this.swingLayerProperties.getGraphicsConfiguration().createCompatibleVolatileImage(this.swingLayerProperties.getWidth(), this.swingLayerProperties.getHeight(), 3);
        Intrinsics.checkNotNullExpressionValue((Object)volatileImage, (String)"");
        this.drawVolatileImage(volatileImage, bufferedImage);
        return volatileImage;
    }

    private final void drawVolatileImage(VolatileImage object, BufferedImage bufferedImage) {
        Graphics graphics = ((VolatileImage)object).getGraphics().create();
        Intrinsics.checkNotNull((Object)graphics);
        object = (Graphics2D)graphics;
        try {
            ((Graphics2D)object).setBackground(new Color(0, 0, 0, 0));
            ((Graphics2D)object).setComposite(AlphaComposite.Src);
            ((Graphics)object).clearRect(0, 0, this.swingLayerProperties.getWidth(), this.swingLayerProperties.getHeight());
            Rectangle rectangle = new Rectangle(0, 0, this.swingLayerProperties.getWidth(), this.swingLayerProperties.getHeight());
            SwingOffscreenDrawer.drawImage$default(this, (Graphics)object, bufferedImage, 0, 0, 0, 0, rectangle, null, null, 444, null);
            return;
        }
        finally {
            ((Graphics)object).dispose();
        }
    }

    private final void drawImage(Graphics graphics, Image image, int n, int n2, int n3, int n4, Rectangle rectangle, BufferedImageOp bufferedImageOp, ImageObserver imageObserver) {
        boolean bl = n3 >= 0 && n4 >= 0;
        SwingOffscreenDrawer swingOffscreenDrawer = this;
        swingOffscreenDrawer.doDrawHiDpi(swingOffscreenDrawer.swingLayerProperties.getWidth(), this.swingLayerProperties.getHeight(), graphics, SwingLayerPropertiesKt.getScale(this.swingLayerProperties), n, n2, n3, n4, bl, bufferedImageOp, image, rectangle, imageObserver);
    }

    static /* synthetic */ void drawImage$default(SwingOffscreenDrawer swingOffscreenDrawer, Graphics graphics, Image image, int n, int n2, int n3, int n4, Rectangle rectangle, BufferedImageOp bufferedImageOp, ImageObserver imageObserver, int n5, Object object) {
        if ((n5 & 4) != 0) {
            n = 0;
        }
        if ((n5 & 8) != 0) {
            n2 = 0;
        }
        if ((n5 & 0x10) != 0) {
            n3 = -1;
        }
        if ((n5 & 0x20) != 0) {
            n4 = -1;
        }
        if ((n5 & 0x40) != 0) {
            rectangle = null;
        }
        if ((n5 & 0x80) != 0) {
            bufferedImageOp = null;
        }
        if ((n5 & 0x100) != 0) {
            imageObserver = null;
        }
        swingOffscreenDrawer.drawImage(graphics, image, n, n2, n3, n4, rectangle, bufferedImageOp, imageObserver);
    }

    private final void doDrawHiDpi(int n, int n2, Graphics graphics, double d, int n3, int n4, int n5, int n6, boolean bl, BufferedImageOp bufferedImageOp, Image image, Rectangle rectangle, ImageObserver imageObserver) {
        Graphics graphics2;
        double d2;
        double d3 = d;
        int n7 = n3;
        int n8 = n4;
        double d4 = 0.0;
        int n9 = Math.max(n, n2);
        if (n9 < 0x3FFFFFFF) {
            double d5;
            int n10 = 1;
            while (true) {
                double d6 = d2 = Math.pow(10.0, n10);
                double d7 = n9;
                d5 = d6;
                if (!(d7 > d2)) break;
                ++n10;
            }
            d4 = 1.0 / d5;
        }
        Graphics graphics3 = graphics;
        Intrinsics.checkNotNull((Object)graphics3);
        AffineTransform affineTransform = ((Graphics2D)graphics3).getTransform();
        Graphics graphics4 = null;
        if ((affineTransform.getType() & 0x18) == 0 && Math.abs(d - affineTransform.getScaleX()) <= d4) {
            d3 = affineTransform.getScaleX();
            d2 = affineTransform.getScaleX();
            double d8 = affineTransform.getScaleY();
            affineTransform.scale(1.0 / d2, 1.0 / d8);
            affineTransform.translate((double)n3 * d2, (double)n4 * d8);
            n8 = 0;
            n7 = 0;
            Graphics graphics5 = graphics.create();
            Intrinsics.checkNotNull((Object)graphics5);
            graphics4 = (Graphics2D)graphics5;
            graphics = graphics4;
            ((Graphics2D)graphics4).setTransform(affineTransform);
        }
        try {
            int n11 = n5;
            int n12 = n6;
            if (graphics4 != null && bl) {
                n11 = this.scaleSize(n5, d3);
                n12 = this.scaleSize(n6, d3);
            }
            this.doDraw(bufferedImageOp, image, (Graphics2D)graphics4, bl, n11, n12, rectangle, n, n2, graphics, n7, n8, imageObserver, d3);
            graphics2 = graphics4;
        }
        catch (Throwable throwable) {
            Graphics graphics6 = graphics4;
            if (graphics6 != null) {
                graphics6.dispose();
            }
            throw throwable;
        }
        if (graphics2 == null) {
            return;
        }
        graphics2.dispose();
    }

    private final int scaleSize(int n, double d) {
        return MathKt.roundToInt((double)((double)n * d));
    }

    private final void doDraw(BufferedImageOp bufferedImageOp, Image image, Graphics2D graphics2D, boolean bl, int n, int n2, Rectangle rectangle, int n3, int n4, Graphics graphics, int n5, int n6, ImageObserver imageObserver, double d) {
        if (bufferedImageOp != null && image instanceof BufferedImage) {
            BufferedImage bufferedImage = bufferedImageOp.filter((BufferedImage)image, null);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"");
            image = bufferedImage;
        }
        if (rectangle != null) {
            int n7;
            int n8 = SwingOffscreenDrawer.doDraw$size(this, d, rectangle.x);
            int n9 = SwingOffscreenDrawer.doDraw$size(this, d, rectangle.y);
            int n10 = rectangle.width >= 0 ? SwingOffscreenDrawer.doDraw$size(this, d, rectangle.width) : SwingOffscreenDrawer.doDraw$size(this, d, n3) - n8;
            int n11 = n7 = rectangle.height >= 0 ? SwingOffscreenDrawer.doDraw$size(this, d, rectangle.height) : SwingOffscreenDrawer.doDraw$size(this, d, n4) - n9;
            if (!bl) {
                n = SwingOffscreenDrawer.doDraw$size(this, d, n3);
                n2 = SwingOffscreenDrawer.doDraw$size(this, d, n4);
            }
            graphics.drawImage(image, n5, n6, n5 + n, n6 + n2, n8, n9, n8 + n10, n9 + n7, imageObserver);
            return;
        }
        if (bl) {
            graphics.drawImage(image, n5, n6, n, n2, imageObserver);
            return;
        }
        if (graphics2D == null) {
            graphics.drawImage(image, n5, n6, n3, n4, imageObserver);
            return;
        }
        graphics.drawImage(image, n5, n6, imageObserver);
    }

    private static final int doDraw$size(SwingOffscreenDrawer swingOffscreenDrawer, double d, int n) {
        return swingOffscreenDrawer.scaleSize(n, d);
    }
}

