(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', './kotlin-kotlin-stdlib.js'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('./kotlin-kotlin-stdlib.js'));
  else {
    if (typeof this['kotlin-kotlin-stdlib'] === 'undefined') {
      throw new Error("Error loading module 'Napier-napier-js-ir'. Its dependency 'kotlin-kotlin-stdlib' was not found. Please, check whether 'kotlin-kotlin-stdlib' is loaded prior to 'Napier-napier-js-ir'.");
    }
    root['Napier-napier-js-ir'] = factory(typeof this['Napier-napier-js-ir'] === 'undefined' ? {} : this['Napier-napier-js-ir'], this['kotlin-kotlin-stdlib']);
  }
}(this, function (_, kotlin_kotlin) {
  'use strict';
  //region block: imports
  var protoOf = kotlin_kotlin.$_$.w9;
  var classMeta = kotlin_kotlin.$_$.q8;
  var setMetadataFor = kotlin_kotlin.$_$.x9;
  var Unit_instance = kotlin_kotlin.$_$.p4;
  var Enum = kotlin_kotlin.$_$.sc;
  var Collection = kotlin_kotlin.$_$.s4;
  var isInterface = kotlin_kotlin.$_$.i9;
  var VOID = kotlin_kotlin.$_$.d;
  var objectMeta = kotlin_kotlin.$_$.v9;
  var emptyList = kotlin_kotlin.$_$.t5;
  var objectCreate = kotlin_kotlin.$_$.u9;
  var ArrayList_init_$Create$ = kotlin_kotlin.$_$.i;
  var AbstractList = kotlin_kotlin.$_$.q4;
  var THROW_CCE = kotlin_kotlin.$_$.bd;
  //endregion
  //region block: pre-declaration
  setMetadataFor(Antilog, 'Antilog', classMeta);
  setMetadataFor(LogLevel, 'LogLevel', classMeta, Enum);
  setMetadataFor(Napier, 'Napier', objectMeta);
  setMetadataFor(AtomicMutableList, 'AtomicMutableList', classMeta, AbstractList, VOID, AtomicMutableList_init_$Create$);
  setMetadataFor(DebugAntilog, 'DebugAntilog', classMeta, Antilog, VOID, DebugAntilog);
  setMetadataFor(AtomicRef, 'AtomicRef', classMeta);
  //endregion
  function Antilog() {
  }
  protoOf(Antilog).x3u = function (priority, tag) {
    return true;
  };
  protoOf(Antilog).y3u = function (priority, tag, throwable, message) {
    this.z3u(priority, tag, throwable, message);
  };
  var LogLevel_VERBOSE_instance;
  var LogLevel_DEBUG_instance;
  var LogLevel_INFO_instance;
  var LogLevel_WARNING_instance;
  var LogLevel_ERROR_instance;
  var LogLevel_ASSERT_instance;
  var LogLevel_entriesInitialized;
  function LogLevel_initEntries() {
    if (LogLevel_entriesInitialized)
      return Unit_instance;
    LogLevel_entriesInitialized = true;
    LogLevel_VERBOSE_instance = new LogLevel('VERBOSE', 0);
    LogLevel_DEBUG_instance = new LogLevel('DEBUG', 1);
    LogLevel_INFO_instance = new LogLevel('INFO', 2);
    LogLevel_WARNING_instance = new LogLevel('WARNING', 3);
    LogLevel_ERROR_instance = new LogLevel('ERROR', 4);
    LogLevel_ASSERT_instance = new LogLevel('ASSERT', 5);
  }
  function LogLevel(name, ordinal) {
    Enum.call(this, name, ordinal);
  }
  function LogLevel_VERBOSE_getInstance() {
    LogLevel_initEntries();
    return LogLevel_VERBOSE_instance;
  }
  function LogLevel_DEBUG_getInstance() {
    LogLevel_initEntries();
    return LogLevel_DEBUG_instance;
  }
  function LogLevel_INFO_getInstance() {
    LogLevel_initEntries();
    return LogLevel_INFO_instance;
  }
  function LogLevel_WARNING_getInstance() {
    LogLevel_initEntries();
    return LogLevel_WARNING_instance;
  }
  function LogLevel_ERROR_getInstance() {
    LogLevel_initEntries();
    return LogLevel_ERROR_instance;
  }
  function LogLevel_ASSERT_getInstance() {
    LogLevel_initEntries();
    return LogLevel_ASSERT_instance;
  }
  function Napier() {
    Napier_instance = this;
    this.a3v_1 = AtomicMutableList_init_$Create$();
  }
  protoOf(Napier).b3v = function (antilog) {
    this.a3v_1.d3v(antilog);
  };
  protoOf(Napier).x3u = function (priority, tag) {
    var tmp$ret$0;
    $l$block_0: {
      // Inline function 'kotlin.collections.any' call
      var this_0 = this.a3v_1;
      var tmp;
      if (isInterface(this_0, Collection)) {
        tmp = this_0.b1();
      } else {
        tmp = false;
      }
      if (tmp) {
        tmp$ret$0 = false;
        break $l$block_0;
      }
      var tmp0_iterator = this_0.u();
      while (tmp0_iterator.v()) {
        var element = tmp0_iterator.w();
        // Inline function 'io.github.aakira.napier.Napier.isEnable.<anonymous>' call
        if (element.x3u(priority, tag)) {
          tmp$ret$0 = true;
          break $l$block_0;
        }
      }
      tmp$ret$0 = false;
    }
    return tmp$ret$0;
  };
  protoOf(Napier).y3u = function (priority, tag, throwable, message) {
    // Inline function 'kotlin.collections.forEach' call
    var tmp0_iterator = this.a3v_1.u();
    while (tmp0_iterator.v()) {
      var element = tmp0_iterator.w();
      // Inline function 'io.github.aakira.napier.Napier.rawLog.<anonymous>' call
      element.y3u(priority, tag, throwable, message);
    }
  };
  protoOf(Napier).e3v = function (message, throwable, tag) {
    this.f3v(LogLevel_VERBOSE_getInstance(), tag, throwable, message);
  };
  protoOf(Napier).g3v = function (message, throwable, tag, $super) {
    throwable = throwable === VOID ? null : throwable;
    tag = tag === VOID ? null : tag;
    var tmp;
    if ($super === VOID) {
      this.e3v(message, throwable, tag);
      tmp = Unit_instance;
    } else {
      tmp = $super.e3v.call(this, message, throwable, tag);
    }
    return tmp;
  };
  protoOf(Napier).h3v = function (throwable, tag, message) {
    this.f3v(LogLevel_VERBOSE_getInstance(), tag, throwable, message());
  };
  protoOf(Napier).i3v = function (throwable, tag, message, $super) {
    throwable = throwable === VOID ? null : throwable;
    tag = tag === VOID ? null : tag;
    var tmp;
    if ($super === VOID) {
      this.h3v(throwable, tag, message);
      tmp = Unit_instance;
    } else {
      tmp = $super.h3v.call(this, throwable, tag, message);
    }
    return tmp;
  };
  protoOf(Napier).j3v = function (message, throwable, tag) {
    this.f3v(LogLevel_INFO_getInstance(), tag, throwable, message);
  };
  protoOf(Napier).k3v = function (message, throwable, tag, $super) {
    throwable = throwable === VOID ? null : throwable;
    tag = tag === VOID ? null : tag;
    var tmp;
    if ($super === VOID) {
      this.j3v(message, throwable, tag);
      tmp = Unit_instance;
    } else {
      tmp = $super.j3v.call(this, message, throwable, tag);
    }
    return tmp;
  };
  protoOf(Napier).l3v = function (message, throwable, tag) {
    this.f3v(LogLevel_DEBUG_getInstance(), tag, throwable, message);
  };
  protoOf(Napier).m3v = function (message, throwable, tag, $super) {
    throwable = throwable === VOID ? null : throwable;
    tag = tag === VOID ? null : tag;
    var tmp;
    if ($super === VOID) {
      this.l3v(message, throwable, tag);
      tmp = Unit_instance;
    } else {
      tmp = $super.l3v.call(this, message, throwable, tag);
    }
    return tmp;
  };
  protoOf(Napier).n3v = function (throwable, tag, message) {
    this.f3v(LogLevel_WARNING_getInstance(), tag, throwable, message());
  };
  protoOf(Napier).o3v = function (message, throwable, tag) {
    this.f3v(LogLevel_ERROR_getInstance(), tag, throwable, message);
  };
  protoOf(Napier).p3v = function (message, throwable, tag, $super) {
    throwable = throwable === VOID ? null : throwable;
    tag = tag === VOID ? null : tag;
    var tmp;
    if ($super === VOID) {
      this.o3v(message, throwable, tag);
      tmp = Unit_instance;
    } else {
      tmp = $super.o3v.call(this, message, throwable, tag);
    }
    return tmp;
  };
  protoOf(Napier).f3v = function (priority, tag, throwable, message) {
    if (this.x3u(priority, tag)) {
      this.y3u(priority, tag, throwable, message);
    }
  };
  var Napier_instance;
  function Napier_getInstance() {
    if (Napier_instance == null)
      new Napier();
    return Napier_instance;
  }
  function AtomicMutableList_init_$Init$($this) {
    // Inline function 'kotlin.collections.listOf' call
    var tmp$ret$0 = emptyList();
    AtomicMutableList.call($this, tmp$ret$0);
    return $this;
  }
  function AtomicMutableList_init_$Create$() {
    return AtomicMutableList_init_$Init$(objectCreate(protoOf(AtomicMutableList)));
  }
  function modify($this, capacityDiff, block) {
    var newValue = ArrayList_init_$Create$($this.n() + capacityDiff | 0);
    newValue.s($this);
    var result = block(newValue);
    $this.c3v_1.q3v_1 = newValue;
    return result;
  }
  function AtomicMutableList$add$lambda($index, $element) {
    return function ($this$modify) {
      $this$modify.n1($index, $element);
      return Unit_instance;
    };
  }
  function AtomicMutableList(value) {
    AbstractList.call(this);
    this.c3v_1 = new AtomicRef(value);
  }
  protoOf(AtomicMutableList).r3v = function (element, index) {
    return modify(this, 1, AtomicMutableList$add$lambda(index, element));
  };
  protoOf(AtomicMutableList).d3v = function (element, index, $super) {
    var tmp;
    if (index === VOID) {
      // Inline function 'kotlin.collections.count' call
      tmp = this.n();
    } else {
      tmp = index;
    }
    index = tmp;
    var tmp_0;
    if ($super === VOID) {
      this.r3v(element, index);
      tmp_0 = Unit_instance;
    } else {
      tmp_0 = $super.r3v.call(this, element, index);
    }
    return tmp_0;
  };
  protoOf(AtomicMutableList).n = function () {
    return this.c3v_1.q3v_1.n();
  };
  protoOf(AtomicMutableList).b1 = function () {
    return this.c3v_1.q3v_1.b1();
  };
  protoOf(AtomicMutableList).ec = function (element) {
    return this.c3v_1.q3v_1.z(element);
  };
  protoOf(AtomicMutableList).z = function (element) {
    if (!(element == null ? true : !(element == null)))
      return false;
    return this.ec((element == null ? true : !(element == null)) ? element : THROW_CCE());
  };
  protoOf(AtomicMutableList).f1 = function (index) {
    return this.c3v_1.q3v_1.f1(index);
  };
  protoOf(AtomicMutableList).u = function () {
    return this.c3v_1.q3v_1.u();
  };
  function DebugAntilog(defaultTag) {
    defaultTag = defaultTag === VOID ? 'app' : defaultTag;
    Antilog.call(this);
    this.s3v_1 = defaultTag;
  }
  protoOf(DebugAntilog).z3u = function (priority, tag, throwable, message) {
    var logTag = tag == null ? this.s3v_1 : tag;
    var tmp;
    if (!(message == null)) {
      var tmp_0;
      if (!(throwable == null)) {
        tmp_0 = '' + message + '\n' + throwable.message;
      } else {
        tmp_0 = message;
      }
      tmp = tmp_0;
    } else {
      var tmp2_elvis_lhs = throwable == null ? null : throwable.message;
      var tmp_1;
      if (tmp2_elvis_lhs == null) {
        return Unit_instance;
      } else {
        tmp_1 = tmp2_elvis_lhs;
      }
      tmp = tmp_1;
    }
    var fullMessage = tmp;
    switch (priority.g8_1) {
      case 0:
        console.log('VERBOSE ' + logTag + ' : ' + fullMessage);
        break;
      case 1:
        console.log('DEBUG ' + logTag + ' : ' + fullMessage);
        break;
      case 2:
        console.info('INFO ' + logTag + ' : ' + fullMessage);
        break;
      case 3:
        console.warn('WARNING ' + logTag + ' : ' + fullMessage);
        break;
      case 4:
        console.error('ERROR ' + logTag + ' : ' + fullMessage);
        break;
      case 5:
        console.error('ASSERT ' + logTag + ' : ' + fullMessage);
        break;
    }
  };
  function AtomicRef(value) {
    this.q3v_1 = value;
  }
  //region block: exports
  _.$_$ = _.$_$ || {};
  _.$_$.a = LogLevel_ASSERT_getInstance;
  _.$_$.b = LogLevel_DEBUG_getInstance;
  _.$_$.c = LogLevel_ERROR_getInstance;
  _.$_$.d = LogLevel_INFO_getInstance;
  _.$_$.e = LogLevel_VERBOSE_getInstance;
  _.$_$.f = LogLevel_WARNING_getInstance;
  _.$_$.g = Napier_getInstance;
  _.$_$.h = DebugAntilog;
  //endregion
  return _;
}));

//# sourceMappingURL=Napier-napier-js-ir.js.map
