(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', './kotlin-kotlin-stdlib.js'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('./kotlin-kotlin-stdlib.js'));
  else {
    if (typeof this['kotlin-kotlin-stdlib'] === 'undefined') {
      throw new Error("Error loading module 'kotlinx-serialization-kotlinx-serialization-core'. Its dependency 'kotlin-kotlin-stdlib' was not found. Please, check whether 'kotlin-kotlin-stdlib' is loaded prior to 'kotlinx-serialization-kotlinx-serialization-core'.");
    }
    root['kotlinx-serialization-kotlinx-serialization-core'] = factory(typeof this['kotlinx-serialization-kotlinx-serialization-core'] === 'undefined' ? {} : this['kotlinx-serialization-kotlinx-serialization-core'], this['kotlin-kotlin-stdlib']);
  }
}(this, function (_, kotlin_kotlin) {
  'use strict';
  //region block: imports
  var imul = Math.imul;
  var protoOf = kotlin_kotlin.$_$.w9;
  var interfaceMeta = kotlin_kotlin.$_$.a9;
  var setMetadataFor = kotlin_kotlin.$_$.x9;
  var VOID = kotlin_kotlin.$_$.d;
  var getKClassFromExpression = kotlin_kotlin.$_$.b;
  var classMeta = kotlin_kotlin.$_$.q8;
  var IllegalArgumentException_init_$Init$ = kotlin_kotlin.$_$.f1;
  var objectCreate = kotlin_kotlin.$_$.u9;
  var captureStack = kotlin_kotlin.$_$.k8;
  var IllegalArgumentException_init_$Init$_0 = kotlin_kotlin.$_$.g1;
  var IllegalArgumentException_init_$Init$_1 = kotlin_kotlin.$_$.i1;
  var IllegalArgumentException = kotlin_kotlin.$_$.vc;
  var emptyList = kotlin_kotlin.$_$.t5;
  var isBlank = kotlin_kotlin.$_$.bb;
  var toString = kotlin_kotlin.$_$.ba;
  var IllegalArgumentException_init_$Create$ = kotlin_kotlin.$_$.h1;
  var equals = kotlin_kotlin.$_$.t8;
  var toList = kotlin_kotlin.$_$.j7;
  var ArrayList_init_$Create$ = kotlin_kotlin.$_$.j;
  var HashSet_init_$Create$ = kotlin_kotlin.$_$.o;
  var Unit_instance = kotlin_kotlin.$_$.p4;
  var toHashSet = kotlin_kotlin.$_$.g7;
  var copyToArray = kotlin_kotlin.$_$.r5;
  var toBooleanArray = kotlin_kotlin.$_$.f7;
  var withIndex = kotlin_kotlin.$_$.o7;
  var collectionSizeOrDefault = kotlin_kotlin.$_$.f5;
  var ArrayList_init_$Create$_0 = kotlin_kotlin.$_$.i;
  var to = kotlin_kotlin.$_$.ce;
  var toMap = kotlin_kotlin.$_$.k7;
  var lazy = kotlin_kotlin.$_$.wd;
  var contentEquals = kotlin_kotlin.$_$.g5;
  var until = kotlin_kotlin.$_$.ma;
  var joinToString = kotlin_kotlin.$_$.e6;
  var KProperty1 = kotlin_kotlin.$_$.oa;
  var getPropertyCallableRef = kotlin_kotlin.$_$.x8;
  var objectMeta = kotlin_kotlin.$_$.v9;
  var ensureNotNull = kotlin_kotlin.$_$.qd;
  var getStringHashCode = kotlin_kotlin.$_$.y8;
  var THROW_CCE = kotlin_kotlin.$_$.bd;
  var Long = kotlin_kotlin.$_$.xc;
  var Char = kotlin_kotlin.$_$.oc;
  var Duration__toIsoString_impl_9h6wsm = kotlin_kotlin.$_$.z1;
  var Duration = kotlin_kotlin.$_$.mc;
  var Companion_getInstance = kotlin_kotlin.$_$.h4;
  var toIntOrNull = kotlin_kotlin.$_$.yb;
  var hashCode = kotlin_kotlin.$_$.z8;
  var IllegalStateException_init_$Create$ = kotlin_kotlin.$_$.l1;
  var ArrayList = kotlin_kotlin.$_$.r4;
  var ArrayList_init_$Create$_1 = kotlin_kotlin.$_$.k;
  var List = kotlin_kotlin.$_$.u4;
  var isInterface = kotlin_kotlin.$_$.i9;
  var Map = kotlin_kotlin.$_$.w4;
  var LinkedHashMap_init_$Create$ = kotlin_kotlin.$_$.q;
  var LinkedHashMap = kotlin_kotlin.$_$.t4;
  var LinkedHashMap_init_$Create$_0 = kotlin_kotlin.$_$.r;
  var Collection = kotlin_kotlin.$_$.s4;
  var step = kotlin_kotlin.$_$.la;
  var MutableMap = kotlin_kotlin.$_$.z4;
  var getValue = kotlin_kotlin.$_$.a6;
  var longArray = kotlin_kotlin.$_$.o9;
  var Companion_getInstance_0 = kotlin_kotlin.$_$.j4;
  var get_lastIndex = kotlin_kotlin.$_$.h6;
  var countTrailingZeroBits = kotlin_kotlin.$_$.od;
  var LazyThreadSafetyMode_PUBLICATION_getInstance = kotlin_kotlin.$_$.g;
  var lazy_0 = kotlin_kotlin.$_$.vd;
  var HashSet_init_$Create$_0 = kotlin_kotlin.$_$.n;
  var HashMap_init_$Create$ = kotlin_kotlin.$_$.m;
  var fillArrayVal = kotlin_kotlin.$_$.v8;
  var booleanArray = kotlin_kotlin.$_$.j8;
  var emptyMap = kotlin_kotlin.$_$.u5;
  var contentHashCode = kotlin_kotlin.$_$.h5;
  var Companion_getInstance_1 = kotlin_kotlin.$_$.i4;
  var isCharArray = kotlin_kotlin.$_$.d9;
  var charArray = kotlin_kotlin.$_$.m8;
  var DoubleCompanionObject_instance = kotlin_kotlin.$_$.a4;
  var isDoubleArray = kotlin_kotlin.$_$.f9;
  var FloatCompanionObject_instance = kotlin_kotlin.$_$.b4;
  var isFloatArray = kotlin_kotlin.$_$.g9;
  var isLongArray = kotlin_kotlin.$_$.j9;
  var Companion_getInstance_2 = kotlin_kotlin.$_$.n4;
  var _ULongArray___get_size__impl__ju6dtr = kotlin_kotlin.$_$.l3;
  var ULongArray = kotlin_kotlin.$_$.gd;
  var _ULongArray___init__impl__twm1l3 = kotlin_kotlin.$_$.h3;
  var _ULong___init__impl__c78o9k = kotlin_kotlin.$_$.e3;
  var ULongArray__get_impl_pr71q9 = kotlin_kotlin.$_$.j3;
  var _ULong___get_data__impl__fggpzb = kotlin_kotlin.$_$.f3;
  var IntCompanionObject_instance = kotlin_kotlin.$_$.c4;
  var isIntArray = kotlin_kotlin.$_$.h9;
  var Companion_getInstance_3 = kotlin_kotlin.$_$.m4;
  var _UIntArray___get_size__impl__r6l8ci = kotlin_kotlin.$_$.c3;
  var UIntArray = kotlin_kotlin.$_$.ed;
  var _UIntArray___init__impl__ghjpc6 = kotlin_kotlin.$_$.y2;
  var _UInt___init__impl__l7qpdl = kotlin_kotlin.$_$.v2;
  var UIntArray__get_impl_gp5kza = kotlin_kotlin.$_$.a3;
  var _UInt___get_data__impl__f0vqqw = kotlin_kotlin.$_$.w2;
  var ShortCompanionObject_instance = kotlin_kotlin.$_$.d4;
  var isShortArray = kotlin_kotlin.$_$.k9;
  var Companion_getInstance_4 = kotlin_kotlin.$_$.o4;
  var _UShortArray___get_size__impl__jqto1b = kotlin_kotlin.$_$.u3;
  var UShortArray = kotlin_kotlin.$_$.id;
  var _UShortArray___init__impl__9b26ef = kotlin_kotlin.$_$.q3;
  var _UShort___init__impl__jigrne = kotlin_kotlin.$_$.n3;
  var UShortArray__get_impl_fnbhmx = kotlin_kotlin.$_$.s3;
  var _UShort___get_data__impl__g0245 = kotlin_kotlin.$_$.o3;
  var ByteCompanionObject_instance = kotlin_kotlin.$_$.z3;
  var isByteArray = kotlin_kotlin.$_$.c9;
  var Companion_getInstance_5 = kotlin_kotlin.$_$.l4;
  var _UByteArray___get_size__impl__h6pkdv = kotlin_kotlin.$_$.t2;
  var UByteArray = kotlin_kotlin.$_$.cd;
  var _UByteArray___init__impl__ip4y9n = kotlin_kotlin.$_$.q2;
  var _UByte___init__impl__g9hnc4 = kotlin_kotlin.$_$.m2;
  var UByteArray__get_impl_t5f3hv = kotlin_kotlin.$_$.r2;
  var _UByte___get_data__impl__jof9qr = kotlin_kotlin.$_$.n2;
  var BooleanCompanionObject_instance = kotlin_kotlin.$_$.y3;
  var isBooleanArray = kotlin_kotlin.$_$.b9;
  var coerceAtLeast = kotlin_kotlin.$_$.fa;
  var copyOf = kotlin_kotlin.$_$.l5;
  var copyOf_0 = kotlin_kotlin.$_$.n5;
  var copyOf_1 = kotlin_kotlin.$_$.o5;
  var copyOf_2 = kotlin_kotlin.$_$.j5;
  var _ULongArray___get_storage__impl__28e64j = kotlin_kotlin.$_$.m3;
  var _ULongArray___init__impl__twm1l3_0 = kotlin_kotlin.$_$.i3;
  var ULongArray__set_impl_z19mvh = kotlin_kotlin.$_$.k3;
  var copyOf_3 = kotlin_kotlin.$_$.q5;
  var _UIntArray___get_storage__impl__92a0v0 = kotlin_kotlin.$_$.d3;
  var _UIntArray___init__impl__ghjpc6_0 = kotlin_kotlin.$_$.z2;
  var UIntArray__set_impl_7f2zu2 = kotlin_kotlin.$_$.b3;
  var copyOf_4 = kotlin_kotlin.$_$.i5;
  var _UShortArray___get_storage__impl__t2jpv5 = kotlin_kotlin.$_$.v3;
  var _UShortArray___init__impl__9b26ef_0 = kotlin_kotlin.$_$.r3;
  var UShortArray__set_impl_6d8whp = kotlin_kotlin.$_$.t3;
  var copyOf_5 = kotlin_kotlin.$_$.m5;
  var _UByteArray___get_storage__impl__d4kctt = kotlin_kotlin.$_$.u2;
  var _UByteArray___init__impl__ip4y9n_0 = kotlin_kotlin.$_$.p2;
  var UByteArray__set_impl_jvcicn = kotlin_kotlin.$_$.s2;
  var copyOf_6 = kotlin_kotlin.$_$.k5;
  var Unit = kotlin_kotlin.$_$.kd;
  var trimIndent = kotlin_kotlin.$_$.jc;
  var equals_0 = kotlin_kotlin.$_$.wa;
  var charSequenceLength = kotlin_kotlin.$_$.o8;
  var charSequenceGet = kotlin_kotlin.$_$.n8;
  var toString_0 = kotlin_kotlin.$_$.h2;
  var titlecase = kotlin_kotlin.$_$.ub;
  var isLowerCase = kotlin_kotlin.$_$.eb;
  var PrimitiveClasses_getInstance = kotlin_kotlin.$_$.g4;
  var StringCompanionObject_instance = kotlin_kotlin.$_$.e4;
  var getKClass = kotlin_kotlin.$_$.c;
  var ULong = kotlin_kotlin.$_$.hd;
  var UInt = kotlin_kotlin.$_$.fd;
  var UShort = kotlin_kotlin.$_$.jd;
  var UByte = kotlin_kotlin.$_$.dd;
  var mapOf = kotlin_kotlin.$_$.p6;
  var lastOrNull = kotlin_kotlin.$_$.k6;
  var get_lastIndex_0 = kotlin_kotlin.$_$.i6;
  var KClass = kotlin_kotlin.$_$.na;
  var get_indices = kotlin_kotlin.$_$.d6;
  var IndexOutOfBoundsException_init_$Create$ = kotlin_kotlin.$_$.p1;
  var get_indices_0 = kotlin_kotlin.$_$.c6;
  //endregion
  //region block: pre-declaration
  setMetadataFor(SerializationStrategy, 'SerializationStrategy', interfaceMeta);
  setMetadataFor(DeserializationStrategy, 'DeserializationStrategy', interfaceMeta);
  setMetadataFor(KSerializer, 'KSerializer', interfaceMeta, VOID, [SerializationStrategy, DeserializationStrategy]);
  setMetadataFor(AbstractPolymorphicSerializer, 'AbstractPolymorphicSerializer', classMeta, VOID, [KSerializer]);
  setMetadataFor(SealedClassSerializer, 'SealedClassSerializer', classMeta, AbstractPolymorphicSerializer);
  setMetadataFor(SerializationException, 'SerializationException', classMeta, IllegalArgumentException, VOID, SerializationException_init_$Create$);
  setMetadataFor(MissingFieldException, 'MissingFieldException', classMeta, SerializationException);
  setMetadataFor(UnknownFieldException, 'UnknownFieldException', classMeta, SerializationException);
  function get_isNullable() {
    return false;
  }
  function get_isInline() {
    return false;
  }
  function get_annotations() {
    return emptyList();
  }
  setMetadataFor(SerialDescriptor, 'SerialDescriptor', interfaceMeta);
  setMetadataFor(ContextDescriptor, 'ContextDescriptor', classMeta, VOID, [SerialDescriptor]);
  setMetadataFor(elementDescriptors$1$1, VOID, classMeta);
  setMetadataFor(_no_name_provided__qut3iv, VOID, classMeta);
  setMetadataFor(ClassSerialDescriptorBuilder, 'ClassSerialDescriptorBuilder', classMeta);
  setMetadataFor(CachedNames, 'CachedNames', interfaceMeta);
  setMetadataFor(SerialDescriptorImpl, 'SerialDescriptorImpl', classMeta, VOID, [SerialDescriptor, CachedNames]);
  setMetadataFor(SerialKind, 'SerialKind', classMeta);
  setMetadataFor(ENUM, 'ENUM', objectMeta, SerialKind);
  setMetadataFor(CONTEXTUAL, 'CONTEXTUAL', objectMeta, SerialKind);
  setMetadataFor(PrimitiveKind, 'PrimitiveKind', classMeta, SerialKind);
  setMetadataFor(BOOLEAN, 'BOOLEAN', objectMeta, PrimitiveKind);
  setMetadataFor(BYTE, 'BYTE', objectMeta, PrimitiveKind);
  setMetadataFor(CHAR, 'CHAR', objectMeta, PrimitiveKind);
  setMetadataFor(SHORT, 'SHORT', objectMeta, PrimitiveKind);
  setMetadataFor(INT, 'INT', objectMeta, PrimitiveKind);
  setMetadataFor(LONG, 'LONG', objectMeta, PrimitiveKind);
  setMetadataFor(FLOAT, 'FLOAT', objectMeta, PrimitiveKind);
  setMetadataFor(DOUBLE, 'DOUBLE', objectMeta, PrimitiveKind);
  setMetadataFor(STRING, 'STRING', objectMeta, PrimitiveKind);
  setMetadataFor(StructureKind, 'StructureKind', classMeta, SerialKind);
  setMetadataFor(CLASS, 'CLASS', objectMeta, StructureKind);
  setMetadataFor(LIST, 'LIST', objectMeta, StructureKind);
  setMetadataFor(MAP, 'MAP', objectMeta, StructureKind);
  setMetadataFor(OBJECT, 'OBJECT', objectMeta, StructureKind);
  setMetadataFor(PolymorphicKind, 'PolymorphicKind', classMeta, SerialKind);
  setMetadataFor(SEALED, 'SEALED', objectMeta, PolymorphicKind);
  function decodeSerializableValue(deserializer) {
    return deserializer.r18(this);
  }
  setMetadataFor(Decoder, 'Decoder', interfaceMeta);
  function decodeSequentially() {
    return false;
  }
  function decodeCollectionSize(descriptor) {
    return -1;
  }
  function decodeSerializableElement$default(descriptor, index, deserializer, previousValue, $super) {
    previousValue = previousValue === VOID ? null : previousValue;
    return $super === VOID ? this.k1b(descriptor, index, deserializer, previousValue) : $super.k1b.call(this, descriptor, index, deserializer, previousValue);
  }
  setMetadataFor(CompositeDecoder, 'CompositeDecoder', interfaceMeta);
  setMetadataFor(AbstractDecoder, 'AbstractDecoder', classMeta, VOID, [Decoder, CompositeDecoder]);
  function beginCollection(descriptor, collectionSize) {
    return this.z1a(descriptor);
  }
  function encodeSerializableValue(serializer, value) {
    serializer.q18(this, value);
  }
  setMetadataFor(Encoder, 'Encoder', interfaceMeta);
  setMetadataFor(AbstractEncoder, 'AbstractEncoder', classMeta, VOID, [Encoder]);
  setMetadataFor(Companion, 'Companion', objectMeta);
  setMetadataFor(NothingSerializer_0, 'NothingSerializer', objectMeta, VOID, [KSerializer]);
  setMetadataFor(DurationSerializer, 'DurationSerializer', objectMeta, VOID, [KSerializer]);
  setMetadataFor(ListLikeDescriptor, 'ListLikeDescriptor', classMeta, VOID, [SerialDescriptor]);
  setMetadataFor(ArrayListClassDesc, 'ArrayListClassDesc', classMeta, ListLikeDescriptor);
  setMetadataFor(MapLikeDescriptor, 'MapLikeDescriptor', classMeta, VOID, [SerialDescriptor]);
  setMetadataFor(LinkedHashMapClassDesc, 'LinkedHashMapClassDesc', classMeta, MapLikeDescriptor);
  setMetadataFor(PrimitiveArrayDescriptor, 'PrimitiveArrayDescriptor', classMeta, ListLikeDescriptor);
  setMetadataFor(AbstractCollectionSerializer, 'AbstractCollectionSerializer', classMeta, VOID, [KSerializer]);
  setMetadataFor(CollectionLikeSerializer, 'CollectionLikeSerializer', classMeta, AbstractCollectionSerializer);
  setMetadataFor(CollectionSerializer, 'CollectionSerializer', classMeta, CollectionLikeSerializer);
  setMetadataFor(ArrayListSerializer, 'ArrayListSerializer', classMeta, CollectionSerializer);
  setMetadataFor(MapLikeSerializer, 'MapLikeSerializer', classMeta, AbstractCollectionSerializer);
  setMetadataFor(LinkedHashMapSerializer, 'LinkedHashMapSerializer', classMeta, MapLikeSerializer);
  setMetadataFor(PrimitiveArraySerializer, 'PrimitiveArraySerializer', classMeta, CollectionLikeSerializer);
  setMetadataFor(PrimitiveArrayBuilder, 'PrimitiveArrayBuilder', classMeta);
  setMetadataFor(Companion_0, 'Companion', objectMeta);
  setMetadataFor(ElementMarker, 'ElementMarker', classMeta);
  setMetadataFor(PluginGeneratedSerialDescriptor, 'PluginGeneratedSerialDescriptor', classMeta, VOID, [SerialDescriptor, CachedNames]);
  setMetadataFor(InlineClassDescriptor, 'InlineClassDescriptor', classMeta, PluginGeneratedSerialDescriptor);
  function typeParametersSerializers() {
    return get_EMPTY_SERIALIZER_ARRAY();
  }
  setMetadataFor(GeneratedSerializer, 'GeneratedSerializer', interfaceMeta, VOID, [KSerializer]);
  setMetadataFor(InlinePrimitiveDescriptor$1, VOID, classMeta, VOID, [GeneratedSerializer]);
  setMetadataFor(NoOpEncoder, 'NoOpEncoder', objectMeta, AbstractEncoder);
  setMetadataFor(NothingSerialDescriptor, 'NothingSerialDescriptor', objectMeta, VOID, [SerialDescriptor]);
  setMetadataFor(SerialDescriptorForNullable, 'SerialDescriptorForNullable', classMeta, VOID, [SerialDescriptor, CachedNames]);
  setMetadataFor(ObjectSerializer, 'ObjectSerializer', classMeta, VOID, [KSerializer]);
  setMetadataFor(CharArraySerializer_0, 'CharArraySerializer', objectMeta, PrimitiveArraySerializer, [KSerializer, PrimitiveArraySerializer]);
  setMetadataFor(DoubleArraySerializer_0, 'DoubleArraySerializer', objectMeta, PrimitiveArraySerializer, [KSerializer, PrimitiveArraySerializer]);
  setMetadataFor(FloatArraySerializer_0, 'FloatArraySerializer', objectMeta, PrimitiveArraySerializer, [KSerializer, PrimitiveArraySerializer]);
  setMetadataFor(LongArraySerializer_0, 'LongArraySerializer', objectMeta, PrimitiveArraySerializer, [KSerializer, PrimitiveArraySerializer]);
  setMetadataFor(ULongArraySerializer_0, 'ULongArraySerializer', objectMeta, PrimitiveArraySerializer, [KSerializer, PrimitiveArraySerializer]);
  setMetadataFor(IntArraySerializer_0, 'IntArraySerializer', objectMeta, PrimitiveArraySerializer, [KSerializer, PrimitiveArraySerializer]);
  setMetadataFor(UIntArraySerializer_0, 'UIntArraySerializer', objectMeta, PrimitiveArraySerializer, [KSerializer, PrimitiveArraySerializer]);
  setMetadataFor(ShortArraySerializer_0, 'ShortArraySerializer', objectMeta, PrimitiveArraySerializer, [KSerializer, PrimitiveArraySerializer]);
  setMetadataFor(UShortArraySerializer_0, 'UShortArraySerializer', objectMeta, PrimitiveArraySerializer, [KSerializer, PrimitiveArraySerializer]);
  setMetadataFor(ByteArraySerializer_0, 'ByteArraySerializer', objectMeta, PrimitiveArraySerializer, [KSerializer, PrimitiveArraySerializer]);
  setMetadataFor(UByteArraySerializer_0, 'UByteArraySerializer', objectMeta, PrimitiveArraySerializer, [KSerializer, PrimitiveArraySerializer]);
  setMetadataFor(BooleanArraySerializer_0, 'BooleanArraySerializer', objectMeta, PrimitiveArraySerializer, [KSerializer, PrimitiveArraySerializer]);
  setMetadataFor(CharArrayBuilder, 'CharArrayBuilder', classMeta, PrimitiveArrayBuilder);
  setMetadataFor(DoubleArrayBuilder, 'DoubleArrayBuilder', classMeta, PrimitiveArrayBuilder);
  setMetadataFor(FloatArrayBuilder, 'FloatArrayBuilder', classMeta, PrimitiveArrayBuilder);
  setMetadataFor(LongArrayBuilder, 'LongArrayBuilder', classMeta, PrimitiveArrayBuilder);
  setMetadataFor(ULongArrayBuilder, 'ULongArrayBuilder', classMeta, PrimitiveArrayBuilder);
  setMetadataFor(IntArrayBuilder, 'IntArrayBuilder', classMeta, PrimitiveArrayBuilder);
  setMetadataFor(UIntArrayBuilder, 'UIntArrayBuilder', classMeta, PrimitiveArrayBuilder);
  setMetadataFor(ShortArrayBuilder, 'ShortArrayBuilder', classMeta, PrimitiveArrayBuilder);
  setMetadataFor(UShortArrayBuilder, 'UShortArrayBuilder', classMeta, PrimitiveArrayBuilder);
  setMetadataFor(ByteArrayBuilder, 'ByteArrayBuilder', classMeta, PrimitiveArrayBuilder);
  setMetadataFor(UByteArrayBuilder, 'UByteArrayBuilder', classMeta, PrimitiveArrayBuilder);
  setMetadataFor(BooleanArrayBuilder, 'BooleanArrayBuilder', classMeta, PrimitiveArrayBuilder);
  setMetadataFor(StringSerializer, 'StringSerializer', objectMeta, VOID, [KSerializer]);
  setMetadataFor(CharSerializer, 'CharSerializer', objectMeta, VOID, [KSerializer]);
  setMetadataFor(DoubleSerializer, 'DoubleSerializer', objectMeta, VOID, [KSerializer]);
  setMetadataFor(FloatSerializer, 'FloatSerializer', objectMeta, VOID, [KSerializer]);
  setMetadataFor(LongSerializer, 'LongSerializer', objectMeta, VOID, [KSerializer]);
  setMetadataFor(IntSerializer, 'IntSerializer', objectMeta, VOID, [KSerializer]);
  setMetadataFor(ShortSerializer, 'ShortSerializer', objectMeta, VOID, [KSerializer]);
  setMetadataFor(ByteSerializer, 'ByteSerializer', objectMeta, VOID, [KSerializer]);
  setMetadataFor(BooleanSerializer, 'BooleanSerializer', objectMeta, VOID, [KSerializer]);
  setMetadataFor(UnitSerializer, 'UnitSerializer', objectMeta, VOID, [KSerializer]);
  setMetadataFor(PrimitiveSerialDescriptor_0, 'PrimitiveSerialDescriptor', classMeta, VOID, [SerialDescriptor]);
  setMetadataFor(TaggedDecoder, 'TaggedDecoder', classMeta, VOID, [Decoder, CompositeDecoder]);
  setMetadataFor(NamedValueDecoder, 'NamedValueDecoder', classMeta, TaggedDecoder);
  setMetadataFor(ULongSerializer, 'ULongSerializer', objectMeta, VOID, [KSerializer]);
  setMetadataFor(UIntSerializer, 'UIntSerializer', objectMeta, VOID, [KSerializer]);
  setMetadataFor(UShortSerializer, 'UShortSerializer', objectMeta, VOID, [KSerializer]);
  setMetadataFor(UByteSerializer, 'UByteSerializer', objectMeta, VOID, [KSerializer]);
  setMetadataFor(SerializersModule, 'SerializersModule', classMeta);
  setMetadataFor(SerialModuleImpl, 'SerialModuleImpl', classMeta, SerializersModule);
  setMetadataFor(ContextualProvider, 'ContextualProvider', classMeta);
  setMetadataFor(Argless, 'Argless', classMeta, ContextualProvider);
  setMetadataFor(WithTypeArguments, 'WithTypeArguments', classMeta, ContextualProvider);
  function contextual(kClass, serializer) {
    return this.b1o(kClass, SerializersModuleCollector$contextual$lambda(serializer));
  }
  setMetadataFor(SerializersModuleCollector, 'SerializersModuleCollector', interfaceMeta);
  setMetadataFor(SerializableWith, 'SerializableWith', classMeta, VOID, VOID, VOID, 0);
  //endregion
  function KSerializer() {
  }
  function SerializationStrategy() {
  }
  function DeserializationStrategy() {
  }
  function findPolymorphicSerializer(_this__u8e3s4, encoder, value) {
    var tmp0_elvis_lhs = _this__u8e3s4.s18(encoder, value);
    var tmp;
    if (tmp0_elvis_lhs == null) {
      throwSubtypeNotRegistered(getKClassFromExpression(value), _this__u8e3s4.t18());
    } else {
      tmp = tmp0_elvis_lhs;
    }
    return tmp;
  }
  function findPolymorphicSerializer_0(_this__u8e3s4, decoder, klassName) {
    var tmp0_elvis_lhs = _this__u8e3s4.u18(decoder, klassName);
    var tmp;
    if (tmp0_elvis_lhs == null) {
      throwSubtypeNotRegistered_0(klassName, _this__u8e3s4.t18());
    } else {
      tmp = tmp0_elvis_lhs;
    }
    return tmp;
  }
  function SealedClassSerializer() {
  }
  function SerializationException_init_$Init$($this) {
    IllegalArgumentException_init_$Init$($this);
    SerializationException.call($this);
    return $this;
  }
  function SerializationException_init_$Create$() {
    var tmp = SerializationException_init_$Init$(objectCreate(protoOf(SerializationException)));
    captureStack(tmp, SerializationException_init_$Create$);
    return tmp;
  }
  function SerializationException_init_$Init$_0(message, $this) {
    IllegalArgumentException_init_$Init$_0(message, $this);
    SerializationException.call($this);
    return $this;
  }
  function SerializationException_init_$Create$_0(message) {
    var tmp = SerializationException_init_$Init$_0(message, objectCreate(protoOf(SerializationException)));
    captureStack(tmp, SerializationException_init_$Create$_0);
    return tmp;
  }
  function SerializationException_init_$Init$_1(message, cause, $this) {
    IllegalArgumentException_init_$Init$_1(message, cause, $this);
    SerializationException.call($this);
    return $this;
  }
  function SerializationException() {
    captureStack(this, SerializationException);
  }
  function MissingFieldException_init_$Init$(missingFields, serialName, $this) {
    MissingFieldException.call($this, missingFields, missingFields.n() === 1 ? "Field '" + missingFields.f1(0) + "' is required for type with serial name '" + serialName + "', but it was missing" : 'Fields ' + missingFields + " are required for type with serial name '" + serialName + "', but they were missing", null);
    return $this;
  }
  function MissingFieldException_init_$Create$(missingFields, serialName) {
    var tmp = MissingFieldException_init_$Init$(missingFields, serialName, objectCreate(protoOf(MissingFieldException)));
    captureStack(tmp, MissingFieldException_init_$Create$);
    return tmp;
  }
  function MissingFieldException(missingFields, message, cause) {
    SerializationException_init_$Init$_1(message, cause, this);
    captureStack(this, MissingFieldException);
    this.v18_1 = missingFields;
  }
  function UnknownFieldException_init_$Init$(index, $this) {
    UnknownFieldException.call($this, 'An unknown field for index ' + index);
    return $this;
  }
  function UnknownFieldException_init_$Create$(index) {
    var tmp = UnknownFieldException_init_$Init$(index, objectCreate(protoOf(UnknownFieldException)));
    captureStack(tmp, UnknownFieldException_init_$Create$);
    return tmp;
  }
  function UnknownFieldException(message) {
    SerializationException_init_$Init$_0(message, this);
    captureStack(this, UnknownFieldException);
  }
  function serializer(_this__u8e3s4) {
    return StringSerializer_getInstance();
  }
  function serializer_0(_this__u8e3s4) {
    return CharSerializer_getInstance();
  }
  function CharArraySerializer() {
    return CharArraySerializer_getInstance();
  }
  function serializer_1(_this__u8e3s4) {
    return DoubleSerializer_getInstance();
  }
  function DoubleArraySerializer() {
    return DoubleArraySerializer_getInstance();
  }
  function serializer_2(_this__u8e3s4) {
    return FloatSerializer_getInstance();
  }
  function FloatArraySerializer() {
    return FloatArraySerializer_getInstance();
  }
  function serializer_3(_this__u8e3s4) {
    return LongSerializer_getInstance();
  }
  function LongArraySerializer() {
    return LongArraySerializer_getInstance();
  }
  function serializer_4(_this__u8e3s4) {
    return ULongSerializer_getInstance();
  }
  function ULongArraySerializer() {
    return ULongArraySerializer_getInstance();
  }
  function serializer_5(_this__u8e3s4) {
    return IntSerializer_getInstance();
  }
  function IntArraySerializer() {
    return IntArraySerializer_getInstance();
  }
  function serializer_6(_this__u8e3s4) {
    return UIntSerializer_getInstance();
  }
  function UIntArraySerializer() {
    return UIntArraySerializer_getInstance();
  }
  function serializer_7(_this__u8e3s4) {
    return ShortSerializer_getInstance();
  }
  function ShortArraySerializer() {
    return ShortArraySerializer_getInstance();
  }
  function serializer_8(_this__u8e3s4) {
    return UShortSerializer_getInstance();
  }
  function UShortArraySerializer() {
    return UShortArraySerializer_getInstance();
  }
  function serializer_9(_this__u8e3s4) {
    return ByteSerializer_getInstance();
  }
  function ByteArraySerializer() {
    return ByteArraySerializer_getInstance();
  }
  function serializer_10(_this__u8e3s4) {
    return UByteSerializer_getInstance();
  }
  function UByteArraySerializer() {
    return UByteArraySerializer_getInstance();
  }
  function serializer_11(_this__u8e3s4) {
    return BooleanSerializer_getInstance();
  }
  function BooleanArraySerializer() {
    return BooleanArraySerializer_getInstance();
  }
  function serializer_12(_this__u8e3s4) {
    return UnitSerializer_getInstance();
  }
  function NothingSerializer() {
    return NothingSerializer_getInstance();
  }
  function serializer_13(_this__u8e3s4) {
    return DurationSerializer_getInstance();
  }
  function MapSerializer(keySerializer, valueSerializer) {
    return new LinkedHashMapSerializer(keySerializer, valueSerializer);
  }
  function ListSerializer(elementSerializer) {
    return new ArrayListSerializer(elementSerializer);
  }
  function ContextDescriptor() {
  }
  function getContextualDescriptor(_this__u8e3s4, descriptor) {
    var tmp0_safe_receiver = get_capturedKClass(descriptor);
    var tmp;
    if (tmp0_safe_receiver == null) {
      tmp = null;
    } else {
      // Inline function 'kotlin.let' call
      // Inline function 'kotlin.contracts.contract' call
      // Inline function 'kotlinx.serialization.descriptors.getContextualDescriptor.<anonymous>' call
      var tmp0_safe_receiver_0 = _this__u8e3s4.w18(tmp0_safe_receiver);
      tmp = tmp0_safe_receiver_0 == null ? null : tmp0_safe_receiver_0.p18();
    }
    return tmp;
  }
  function get_capturedKClass(_this__u8e3s4) {
    var tmp;
    if (_this__u8e3s4 instanceof ContextDescriptor) {
      tmp = _this__u8e3s4.y18_1;
    } else {
      if (_this__u8e3s4 instanceof SerialDescriptorForNullable) {
        tmp = get_capturedKClass(_this__u8e3s4.x18_1);
      } else {
        tmp = null;
      }
    }
    return tmp;
  }
  function SerialDescriptor() {
  }
  function get_elementDescriptors(_this__u8e3s4) {
    // Inline function 'kotlin.collections.Iterable' call
    return new _no_name_provided__qut3iv(_this__u8e3s4);
  }
  function elementDescriptors$1$1($this_elementDescriptors) {
    this.l19_1 = $this_elementDescriptors;
    this.k19_1 = $this_elementDescriptors.d19();
  }
  protoOf(elementDescriptors$1$1).v = function () {
    return this.k19_1 > 0;
  };
  protoOf(elementDescriptors$1$1).w = function () {
    var tmp = this.l19_1.d19();
    var tmp1 = this.k19_1;
    this.k19_1 = tmp1 - 1 | 0;
    return this.l19_1.i19(tmp - tmp1 | 0);
  };
  function _no_name_provided__qut3iv($this_elementDescriptors) {
    this.m19_1 = $this_elementDescriptors;
  }
  protoOf(_no_name_provided__qut3iv).u = function () {
    // Inline function 'kotlinx.serialization.descriptors.<get-elementDescriptors>.<anonymous>' call
    return new elementDescriptors$1$1(this.m19_1);
  };
  function buildSerialDescriptor(serialName, kind, typeParameters, builder) {
    var tmp;
    if (builder === VOID) {
      tmp = buildSerialDescriptor$lambda;
    } else {
      tmp = builder;
    }
    builder = tmp;
    // Inline function 'kotlin.require' call
    // Inline function 'kotlin.text.isNotBlank' call
    // Inline function 'kotlin.contracts.contract' call
    if (!!isBlank(serialName)) {
      // Inline function 'kotlinx.serialization.descriptors.buildSerialDescriptor.<anonymous>' call
      var message = 'Blank serial names are prohibited';
      throw IllegalArgumentException_init_$Create$(toString(message));
    }
    // Inline function 'kotlin.require' call
    // Inline function 'kotlin.contracts.contract' call
    if (!!equals(kind, CLASS_getInstance())) {
      // Inline function 'kotlinx.serialization.descriptors.buildSerialDescriptor.<anonymous>' call
      var message_0 = "For StructureKind.CLASS please use 'buildClassSerialDescriptor' instead";
      throw IllegalArgumentException_init_$Create$(toString(message_0));
    }
    var sdBuilder = new ClassSerialDescriptorBuilder(serialName);
    builder(sdBuilder);
    return new SerialDescriptorImpl(serialName, kind, sdBuilder.q19_1.n(), toList(typeParameters), sdBuilder);
  }
  function ClassSerialDescriptorBuilder(serialName) {
    this.n19_1 = serialName;
    this.o19_1 = false;
    this.p19_1 = emptyList();
    this.q19_1 = ArrayList_init_$Create$();
    this.r19_1 = HashSet_init_$Create$();
    this.s19_1 = ArrayList_init_$Create$();
    this.t19_1 = ArrayList_init_$Create$();
    this.u19_1 = ArrayList_init_$Create$();
  }
  protoOf(ClassSerialDescriptorBuilder).v19 = function (elementName, descriptor, annotations, isOptional) {
    // Inline function 'kotlin.require' call
    // Inline function 'kotlin.contracts.contract' call
    if (!this.r19_1.r(elementName)) {
      // Inline function 'kotlinx.serialization.descriptors.ClassSerialDescriptorBuilder.element.<anonymous>' call
      var message = "Element with name '" + elementName + "' is already registered in " + this.n19_1;
      throw IllegalArgumentException_init_$Create$(toString(message));
    }
    // Inline function 'kotlin.collections.plusAssign' call
    this.q19_1.r(elementName);
    // Inline function 'kotlin.collections.plusAssign' call
    this.s19_1.r(descriptor);
    // Inline function 'kotlin.collections.plusAssign' call
    this.t19_1.r(annotations);
    // Inline function 'kotlin.collections.plusAssign' call
    this.u19_1.r(isOptional);
  };
  protoOf(ClassSerialDescriptorBuilder).w19 = function (elementName, descriptor, annotations, isOptional, $super) {
    annotations = annotations === VOID ? emptyList() : annotations;
    isOptional = isOptional === VOID ? false : isOptional;
    var tmp;
    if ($super === VOID) {
      this.v19(elementName, descriptor, annotations, isOptional);
      tmp = Unit_instance;
    } else {
      tmp = $super.v19.call(this, elementName, descriptor, annotations, isOptional);
    }
    return tmp;
  };
  function _get__hashCode__tgwhef($this) {
    // Inline function 'kotlin.getValue' call
    var this_0 = $this.i1a_1;
    _hashCode$factory();
    return this_0.f2();
  }
  function SerialDescriptorImpl$_hashCode$delegate$lambda(this$0) {
    return function () {
      return hashCodeImpl(this$0, this$0.h1a_1);
    };
  }
  function SerialDescriptorImpl$toString$lambda(this$0) {
    return function (it) {
      return this$0.f19(it) + ': ' + this$0.i19(it).z18();
    };
  }
  function SerialDescriptorImpl(serialName, kind, elementsCount, typeParameters, builder) {
    this.x19_1 = serialName;
    this.y19_1 = kind;
    this.z19_1 = elementsCount;
    this.a1a_1 = builder.p19_1;
    this.b1a_1 = toHashSet(builder.q19_1);
    var tmp = this;
    // Inline function 'kotlin.collections.toTypedArray' call
    var this_0 = builder.q19_1;
    tmp.c1a_1 = copyToArray(this_0);
    this.d1a_1 = compactArray(builder.s19_1);
    var tmp_0 = this;
    // Inline function 'kotlin.collections.toTypedArray' call
    var this_1 = builder.t19_1;
    tmp_0.e1a_1 = copyToArray(this_1);
    this.f1a_1 = toBooleanArray(builder.u19_1);
    var tmp_1 = this;
    // Inline function 'kotlin.collections.map' call
    var this_2 = withIndex(this.c1a_1);
    // Inline function 'kotlin.collections.mapTo' call
    var destination = ArrayList_init_$Create$_0(collectionSizeOrDefault(this_2, 10));
    var tmp0_iterator = this_2.u();
    while (tmp0_iterator.v()) {
      var item = tmp0_iterator.w();
      // Inline function 'kotlinx.serialization.descriptors.SerialDescriptorImpl.name2Index.<anonymous>' call
      var tmp$ret$2 = to(item.hc_1, item.gc_1);
      destination.r(tmp$ret$2);
    }
    tmp_1.g1a_1 = toMap(destination);
    this.h1a_1 = compactArray(typeParameters);
    var tmp_2 = this;
    tmp_2.i1a_1 = lazy(SerialDescriptorImpl$_hashCode$delegate$lambda(this));
  }
  protoOf(SerialDescriptorImpl).z18 = function () {
    return this.x19_1;
  };
  protoOf(SerialDescriptorImpl).a19 = function () {
    return this.y19_1;
  };
  protoOf(SerialDescriptorImpl).d19 = function () {
    return this.z19_1;
  };
  protoOf(SerialDescriptorImpl).e19 = function () {
    return this.a1a_1;
  };
  protoOf(SerialDescriptorImpl).j1a = function () {
    return this.b1a_1;
  };
  protoOf(SerialDescriptorImpl).f19 = function (index) {
    return getChecked(this.c1a_1, index);
  };
  protoOf(SerialDescriptorImpl).g19 = function (name) {
    var tmp0_elvis_lhs = this.g1a_1.m2(name);
    var tmp;
    if (tmp0_elvis_lhs == null) {
      tmp = -3;
    } else {
      tmp = tmp0_elvis_lhs;
    }
    return tmp;
  };
  protoOf(SerialDescriptorImpl).h19 = function (index) {
    return getChecked(this.e1a_1, index);
  };
  protoOf(SerialDescriptorImpl).i19 = function (index) {
    return getChecked(this.d1a_1, index);
  };
  protoOf(SerialDescriptorImpl).j19 = function (index) {
    return getChecked_0(this.f1a_1, index);
  };
  protoOf(SerialDescriptorImpl).equals = function (other) {
    var tmp$ret$0;
    $l$block_5: {
      // Inline function 'kotlinx.serialization.internal.equalsImpl' call
      if (this === other) {
        tmp$ret$0 = true;
        break $l$block_5;
      }
      if (!(other instanceof SerialDescriptorImpl)) {
        tmp$ret$0 = false;
        break $l$block_5;
      }
      if (!(this.z18() === other.z18())) {
        tmp$ret$0 = false;
        break $l$block_5;
      }
      // Inline function 'kotlinx.serialization.descriptors.SerialDescriptorImpl.equals.<anonymous>' call
      if (!contentEquals(this.h1a_1, other.h1a_1)) {
        tmp$ret$0 = false;
        break $l$block_5;
      }
      if (!(this.d19() === other.d19())) {
        tmp$ret$0 = false;
        break $l$block_5;
      }
      var inductionVariable = 0;
      var last = this.d19();
      if (inductionVariable < last)
        do {
          var index = inductionVariable;
          inductionVariable = inductionVariable + 1 | 0;
          if (!(this.i19(index).z18() === other.i19(index).z18())) {
            tmp$ret$0 = false;
            break $l$block_5;
          }
          if (!equals(this.i19(index).a19(), other.i19(index).a19())) {
            tmp$ret$0 = false;
            break $l$block_5;
          }
        }
         while (inductionVariable < last);
      tmp$ret$0 = true;
    }
    return tmp$ret$0;
  };
  protoOf(SerialDescriptorImpl).hashCode = function () {
    return _get__hashCode__tgwhef(this);
  };
  protoOf(SerialDescriptorImpl).toString = function () {
    var tmp = until(0, this.z19_1);
    var tmp_0 = this.x19_1 + '(';
    return joinToString(tmp, ', ', tmp_0, ')', VOID, VOID, SerialDescriptorImpl$toString$lambda(this));
  };
  function PrimitiveSerialDescriptor(serialName, kind) {
    // Inline function 'kotlin.require' call
    // Inline function 'kotlin.text.isNotBlank' call
    // Inline function 'kotlin.contracts.contract' call
    if (!!isBlank(serialName)) {
      // Inline function 'kotlinx.serialization.descriptors.PrimitiveSerialDescriptor.<anonymous>' call
      var message = 'Blank serial names are prohibited';
      throw IllegalArgumentException_init_$Create$(toString(message));
    }
    return PrimitiveDescriptorSafe(serialName, kind);
  }
  function buildSerialDescriptor$lambda($this$null) {
    return Unit_instance;
  }
  function _hashCode$factory() {
    return getPropertyCallableRef('_hashCode', 1, KProperty1, function (receiver) {
      return _get__hashCode__tgwhef(receiver);
    }, null);
  }
  function ENUM() {
    ENUM_instance = this;
    SerialKind.call(this);
  }
  var ENUM_instance;
  function ENUM_getInstance() {
    if (ENUM_instance == null)
      new ENUM();
    return ENUM_instance;
  }
  function CONTEXTUAL() {
    CONTEXTUAL_instance = this;
    SerialKind.call(this);
  }
  var CONTEXTUAL_instance;
  function CONTEXTUAL_getInstance() {
    if (CONTEXTUAL_instance == null)
      new CONTEXTUAL();
    return CONTEXTUAL_instance;
  }
  function SerialKind() {
  }
  protoOf(SerialKind).toString = function () {
    return ensureNotNull(getKClassFromExpression(this).g6());
  };
  protoOf(SerialKind).hashCode = function () {
    return getStringHashCode(this.toString());
  };
  function BOOLEAN() {
    BOOLEAN_instance = this;
    PrimitiveKind.call(this);
  }
  var BOOLEAN_instance;
  function BOOLEAN_getInstance() {
    if (BOOLEAN_instance == null)
      new BOOLEAN();
    return BOOLEAN_instance;
  }
  function BYTE() {
    BYTE_instance = this;
    PrimitiveKind.call(this);
  }
  var BYTE_instance;
  function BYTE_getInstance() {
    if (BYTE_instance == null)
      new BYTE();
    return BYTE_instance;
  }
  function CHAR() {
    CHAR_instance = this;
    PrimitiveKind.call(this);
  }
  var CHAR_instance;
  function CHAR_getInstance() {
    if (CHAR_instance == null)
      new CHAR();
    return CHAR_instance;
  }
  function SHORT() {
    SHORT_instance = this;
    PrimitiveKind.call(this);
  }
  var SHORT_instance;
  function SHORT_getInstance() {
    if (SHORT_instance == null)
      new SHORT();
    return SHORT_instance;
  }
  function INT() {
    INT_instance = this;
    PrimitiveKind.call(this);
  }
  var INT_instance;
  function INT_getInstance() {
    if (INT_instance == null)
      new INT();
    return INT_instance;
  }
  function LONG() {
    LONG_instance = this;
    PrimitiveKind.call(this);
  }
  var LONG_instance;
  function LONG_getInstance() {
    if (LONG_instance == null)
      new LONG();
    return LONG_instance;
  }
  function FLOAT() {
    FLOAT_instance = this;
    PrimitiveKind.call(this);
  }
  var FLOAT_instance;
  function FLOAT_getInstance() {
    if (FLOAT_instance == null)
      new FLOAT();
    return FLOAT_instance;
  }
  function DOUBLE() {
    DOUBLE_instance = this;
    PrimitiveKind.call(this);
  }
  var DOUBLE_instance;
  function DOUBLE_getInstance() {
    if (DOUBLE_instance == null)
      new DOUBLE();
    return DOUBLE_instance;
  }
  function STRING() {
    STRING_instance = this;
    PrimitiveKind.call(this);
  }
  var STRING_instance;
  function STRING_getInstance() {
    if (STRING_instance == null)
      new STRING();
    return STRING_instance;
  }
  function PrimitiveKind() {
    SerialKind.call(this);
  }
  function CLASS() {
    CLASS_instance = this;
    StructureKind.call(this);
  }
  var CLASS_instance;
  function CLASS_getInstance() {
    if (CLASS_instance == null)
      new CLASS();
    return CLASS_instance;
  }
  function LIST() {
    LIST_instance = this;
    StructureKind.call(this);
  }
  var LIST_instance;
  function LIST_getInstance() {
    if (LIST_instance == null)
      new LIST();
    return LIST_instance;
  }
  function MAP() {
    MAP_instance = this;
    StructureKind.call(this);
  }
  var MAP_instance;
  function MAP_getInstance() {
    if (MAP_instance == null)
      new MAP();
    return MAP_instance;
  }
  function OBJECT() {
    OBJECT_instance = this;
    StructureKind.call(this);
  }
  var OBJECT_instance;
  function OBJECT_getInstance() {
    if (OBJECT_instance == null)
      new OBJECT();
    return OBJECT_instance;
  }
  function StructureKind() {
    SerialKind.call(this);
  }
  function SEALED() {
    SEALED_instance = this;
    PolymorphicKind.call(this);
  }
  var SEALED_instance;
  function SEALED_getInstance() {
    if (SEALED_instance == null)
      new SEALED();
    return SEALED_instance;
  }
  function PolymorphicKind() {
    SerialKind.call(this);
  }
  function AbstractDecoder() {
  }
  protoOf(AbstractDecoder).k1a = function () {
    throw SerializationException_init_$Create$_0('' + getKClassFromExpression(this) + " can't retrieve untyped values");
  };
  protoOf(AbstractDecoder).l1a = function () {
    return true;
  };
  protoOf(AbstractDecoder).m1a = function () {
    return null;
  };
  protoOf(AbstractDecoder).n1a = function () {
    var tmp = this.k1a();
    return typeof tmp === 'boolean' ? tmp : THROW_CCE();
  };
  protoOf(AbstractDecoder).o1a = function () {
    var tmp = this.k1a();
    return typeof tmp === 'number' ? tmp : THROW_CCE();
  };
  protoOf(AbstractDecoder).p1a = function () {
    var tmp = this.k1a();
    return typeof tmp === 'number' ? tmp : THROW_CCE();
  };
  protoOf(AbstractDecoder).q1a = function () {
    var tmp = this.k1a();
    return typeof tmp === 'number' ? tmp : THROW_CCE();
  };
  protoOf(AbstractDecoder).r1a = function () {
    var tmp = this.k1a();
    return tmp instanceof Long ? tmp : THROW_CCE();
  };
  protoOf(AbstractDecoder).s1a = function () {
    var tmp = this.k1a();
    return typeof tmp === 'number' ? tmp : THROW_CCE();
  };
  protoOf(AbstractDecoder).t1a = function () {
    var tmp = this.k1a();
    return typeof tmp === 'number' ? tmp : THROW_CCE();
  };
  protoOf(AbstractDecoder).u1a = function () {
    var tmp = this.k1a();
    return tmp instanceof Char ? tmp.s8_1 : THROW_CCE();
  };
  protoOf(AbstractDecoder).v1a = function () {
    var tmp = this.k1a();
    return typeof tmp === 'string' ? tmp : THROW_CCE();
  };
  protoOf(AbstractDecoder).w1a = function (descriptor) {
    return this;
  };
  protoOf(AbstractDecoder).x1a = function (deserializer, previousValue) {
    return this.y1a(deserializer);
  };
  protoOf(AbstractDecoder).z1a = function (descriptor) {
    return this;
  };
  protoOf(AbstractDecoder).a1b = function (descriptor) {
  };
  protoOf(AbstractDecoder).b1b = function (descriptor, index) {
    return this.n1a();
  };
  protoOf(AbstractDecoder).c1b = function (descriptor, index) {
    return this.o1a();
  };
  protoOf(AbstractDecoder).d1b = function (descriptor, index) {
    return this.p1a();
  };
  protoOf(AbstractDecoder).e1b = function (descriptor, index) {
    return this.q1a();
  };
  protoOf(AbstractDecoder).f1b = function (descriptor, index) {
    return this.r1a();
  };
  protoOf(AbstractDecoder).g1b = function (descriptor, index) {
    return this.s1a();
  };
  protoOf(AbstractDecoder).h1b = function (descriptor, index) {
    return this.t1a();
  };
  protoOf(AbstractDecoder).i1b = function (descriptor, index) {
    return this.u1a();
  };
  protoOf(AbstractDecoder).j1b = function (descriptor, index) {
    return this.w1a(descriptor.i19(index));
  };
  protoOf(AbstractDecoder).k1b = function (descriptor, index, deserializer, previousValue) {
    return this.x1a(deserializer, previousValue);
  };
  function AbstractEncoder() {
  }
  protoOf(AbstractEncoder).z1a = function (descriptor) {
    return this;
  };
  protoOf(AbstractEncoder).a1b = function (descriptor) {
  };
  protoOf(AbstractEncoder).q1b = function (descriptor, index) {
    return true;
  };
  protoOf(AbstractEncoder).r1b = function (value) {
    throw SerializationException_init_$Create$_0('Non-serializable ' + getKClassFromExpression(value) + ' is not supported by ' + getKClassFromExpression(this) + ' encoder');
  };
  protoOf(AbstractEncoder).s1b = function () {
    throw SerializationException_init_$Create$_0("'null' is not supported by default");
  };
  protoOf(AbstractEncoder).t1b = function (value) {
    return this.r1b(value);
  };
  protoOf(AbstractEncoder).u1b = function (value) {
    return this.r1b(value);
  };
  protoOf(AbstractEncoder).v1b = function (value) {
    return this.r1b(value);
  };
  protoOf(AbstractEncoder).w1b = function (value) {
    return this.r1b(value);
  };
  protoOf(AbstractEncoder).x1b = function (value) {
    return this.r1b(value);
  };
  protoOf(AbstractEncoder).y1b = function (value) {
    return this.r1b(value);
  };
  protoOf(AbstractEncoder).z1b = function (value) {
    return this.r1b(value);
  };
  protoOf(AbstractEncoder).a1c = function (value) {
    return this.r1b(new Char(value));
  };
  protoOf(AbstractEncoder).b1c = function (value) {
    return this.r1b(value);
  };
  protoOf(AbstractEncoder).c1c = function (descriptor) {
    return this;
  };
  protoOf(AbstractEncoder).d1c = function (descriptor, index, value) {
    if (this.q1b(descriptor, index)) {
      this.t1b(value);
    }
  };
  protoOf(AbstractEncoder).e1c = function (descriptor, index, value) {
    if (this.q1b(descriptor, index)) {
      this.u1b(value);
    }
  };
  protoOf(AbstractEncoder).f1c = function (descriptor, index, value) {
    if (this.q1b(descriptor, index)) {
      this.v1b(value);
    }
  };
  protoOf(AbstractEncoder).g1c = function (descriptor, index, value) {
    if (this.q1b(descriptor, index)) {
      this.w1b(value);
    }
  };
  protoOf(AbstractEncoder).h1c = function (descriptor, index, value) {
    if (this.q1b(descriptor, index)) {
      this.x1b(value);
    }
  };
  protoOf(AbstractEncoder).i1c = function (descriptor, index, value) {
    if (this.q1b(descriptor, index)) {
      this.y1b(value);
    }
  };
  protoOf(AbstractEncoder).j1c = function (descriptor, index, value) {
    if (this.q1b(descriptor, index)) {
      this.z1b(value);
    }
  };
  protoOf(AbstractEncoder).k1c = function (descriptor, index, value) {
    if (this.q1b(descriptor, index)) {
      this.a1c(value);
    }
  };
  protoOf(AbstractEncoder).l1c = function (descriptor, index) {
    return this.q1b(descriptor, index) ? this.c1c(descriptor.i19(index)) : NoOpEncoder_getInstance();
  };
  protoOf(AbstractEncoder).m1c = function (descriptor, index, serializer, value) {
    if (this.q1b(descriptor, index)) {
      this.n1c(serializer, value);
    }
  };
  function Decoder() {
  }
  function Companion() {
    this.p1c_1 = -1;
    this.q1c_1 = -3;
  }
  var Companion_instance;
  function Companion_getInstance_6() {
    return Companion_instance;
  }
  function CompositeDecoder() {
  }
  function Encoder() {
  }
  function AbstractPolymorphicSerializer() {
  }
  protoOf(AbstractPolymorphicSerializer).u18 = function (decoder, klassName) {
    return decoder.m1b().r1c(this.t18(), klassName);
  };
  protoOf(AbstractPolymorphicSerializer).s18 = function (encoder, value) {
    return encoder.m1b().s1c(this.t18(), value);
  };
  function throwSubtypeNotRegistered(subClass, baseClass) {
    var tmp0_elvis_lhs = subClass.g6();
    throwSubtypeNotRegistered_0(tmp0_elvis_lhs == null ? '' + subClass : tmp0_elvis_lhs, baseClass);
  }
  function throwSubtypeNotRegistered_0(subClassName, baseClass) {
    var scope = "in the polymorphic scope of '" + baseClass.g6() + "'";
    throw SerializationException_init_$Create$_0(subClassName == null ? 'Class discriminator was missing and no default serializers were registered ' + scope + '.' : "Serializer for subclass '" + subClassName + "' is not found " + scope + '.\n' + ("Check if class with serial name '" + subClassName + "' exists and serializer is registered in a corresponding SerializersModule.\n") + ("To be registered automatically, class '" + subClassName + "' has to be '@Serializable', and the base class '" + baseClass.g6() + "' has to be sealed and '@Serializable'."));
  }
  function NothingSerializer_0() {
    NothingSerializer_instance = this;
    this.t1c_1 = NothingSerialDescriptor_getInstance();
  }
  protoOf(NothingSerializer_0).p18 = function () {
    return this.t1c_1;
  };
  protoOf(NothingSerializer_0).u1c = function (encoder, value) {
    throw SerializationException_init_$Create$_0("'kotlin.Nothing' cannot be serialized");
  };
  protoOf(NothingSerializer_0).q18 = function (encoder, value) {
    var tmp;
    if (false) {
      tmp = value;
    } else {
      tmp = THROW_CCE();
    }
    return this.u1c(encoder, tmp);
  };
  protoOf(NothingSerializer_0).r18 = function (decoder) {
    throw SerializationException_init_$Create$_0("'kotlin.Nothing' does not have instances");
  };
  var NothingSerializer_instance;
  function NothingSerializer_getInstance() {
    if (NothingSerializer_instance == null)
      new NothingSerializer_0();
    return NothingSerializer_instance;
  }
  function DurationSerializer() {
    DurationSerializer_instance = this;
    this.v1c_1 = new PrimitiveSerialDescriptor_0('kotlin.time.Duration', STRING_getInstance());
  }
  protoOf(DurationSerializer).p18 = function () {
    return this.v1c_1;
  };
  protoOf(DurationSerializer).w1c = function (encoder, value) {
    encoder.b1c(Duration__toIsoString_impl_9h6wsm(value));
  };
  protoOf(DurationSerializer).q18 = function (encoder, value) {
    return this.w1c(encoder, value instanceof Duration ? value.of_1 : THROW_CCE());
  };
  protoOf(DurationSerializer).x1c = function (decoder) {
    return Companion_getInstance().nf(decoder.v1a());
  };
  protoOf(DurationSerializer).r18 = function (decoder) {
    return new Duration(this.x1c(decoder));
  };
  var DurationSerializer_instance;
  function DurationSerializer_getInstance() {
    if (DurationSerializer_instance == null)
      new DurationSerializer();
    return DurationSerializer_instance;
  }
  function CachedNames() {
  }
  function ArrayListClassDesc(elementDesc) {
    ListLikeDescriptor.call(this, elementDesc);
  }
  protoOf(ArrayListClassDesc).z18 = function () {
    return 'kotlin.collections.ArrayList';
  };
  function LinkedHashMapClassDesc(keyDesc, valueDesc) {
    MapLikeDescriptor.call(this, 'kotlin.collections.LinkedHashMap', keyDesc, valueDesc);
  }
  function ListLikeDescriptor(elementDescriptor) {
    this.a1d_1 = elementDescriptor;
    this.b1d_1 = 1;
  }
  protoOf(ListLikeDescriptor).a19 = function () {
    return LIST_getInstance();
  };
  protoOf(ListLikeDescriptor).d19 = function () {
    return this.b1d_1;
  };
  protoOf(ListLikeDescriptor).f19 = function (index) {
    return index.toString();
  };
  protoOf(ListLikeDescriptor).g19 = function (name) {
    var tmp0_elvis_lhs = toIntOrNull(name);
    var tmp;
    if (tmp0_elvis_lhs == null) {
      throw IllegalArgumentException_init_$Create$(name + ' is not a valid list index');
    } else {
      tmp = tmp0_elvis_lhs;
    }
    return tmp;
  };
  protoOf(ListLikeDescriptor).j19 = function (index) {
    // Inline function 'kotlin.require' call
    // Inline function 'kotlin.contracts.contract' call
    if (!(index >= 0)) {
      // Inline function 'kotlinx.serialization.internal.ListLikeDescriptor.isElementOptional.<anonymous>' call
      var message = 'Illegal index ' + index + ', ' + this.z18() + ' expects only non-negative indices';
      throw IllegalArgumentException_init_$Create$(toString(message));
    }
    return false;
  };
  protoOf(ListLikeDescriptor).h19 = function (index) {
    // Inline function 'kotlin.require' call
    // Inline function 'kotlin.contracts.contract' call
    if (!(index >= 0)) {
      // Inline function 'kotlinx.serialization.internal.ListLikeDescriptor.getElementAnnotations.<anonymous>' call
      var message = 'Illegal index ' + index + ', ' + this.z18() + ' expects only non-negative indices';
      throw IllegalArgumentException_init_$Create$(toString(message));
    }
    return emptyList();
  };
  protoOf(ListLikeDescriptor).i19 = function (index) {
    // Inline function 'kotlin.require' call
    // Inline function 'kotlin.contracts.contract' call
    if (!(index >= 0)) {
      // Inline function 'kotlinx.serialization.internal.ListLikeDescriptor.getElementDescriptor.<anonymous>' call
      var message = 'Illegal index ' + index + ', ' + this.z18() + ' expects only non-negative indices';
      throw IllegalArgumentException_init_$Create$(toString(message));
    }
    return this.a1d_1;
  };
  protoOf(ListLikeDescriptor).equals = function (other) {
    if (this === other)
      return true;
    if (!(other instanceof ListLikeDescriptor))
      return false;
    if (equals(this.a1d_1, other.a1d_1) ? this.z18() === other.z18() : false)
      return true;
    return false;
  };
  protoOf(ListLikeDescriptor).hashCode = function () {
    return imul(hashCode(this.a1d_1), 31) + getStringHashCode(this.z18()) | 0;
  };
  protoOf(ListLikeDescriptor).toString = function () {
    return this.z18() + '(' + this.a1d_1 + ')';
  };
  function MapLikeDescriptor(serialName, keyDescriptor, valueDescriptor) {
    this.c1d_1 = serialName;
    this.d1d_1 = keyDescriptor;
    this.e1d_1 = valueDescriptor;
    this.f1d_1 = 2;
  }
  protoOf(MapLikeDescriptor).z18 = function () {
    return this.c1d_1;
  };
  protoOf(MapLikeDescriptor).a19 = function () {
    return MAP_getInstance();
  };
  protoOf(MapLikeDescriptor).d19 = function () {
    return this.f1d_1;
  };
  protoOf(MapLikeDescriptor).f19 = function (index) {
    return index.toString();
  };
  protoOf(MapLikeDescriptor).g19 = function (name) {
    var tmp0_elvis_lhs = toIntOrNull(name);
    var tmp;
    if (tmp0_elvis_lhs == null) {
      throw IllegalArgumentException_init_$Create$(name + ' is not a valid map index');
    } else {
      tmp = tmp0_elvis_lhs;
    }
    return tmp;
  };
  protoOf(MapLikeDescriptor).j19 = function (index) {
    // Inline function 'kotlin.require' call
    // Inline function 'kotlin.contracts.contract' call
    if (!(index >= 0)) {
      // Inline function 'kotlinx.serialization.internal.MapLikeDescriptor.isElementOptional.<anonymous>' call
      var message = 'Illegal index ' + index + ', ' + this.z18() + ' expects only non-negative indices';
      throw IllegalArgumentException_init_$Create$(toString(message));
    }
    return false;
  };
  protoOf(MapLikeDescriptor).h19 = function (index) {
    // Inline function 'kotlin.require' call
    // Inline function 'kotlin.contracts.contract' call
    if (!(index >= 0)) {
      // Inline function 'kotlinx.serialization.internal.MapLikeDescriptor.getElementAnnotations.<anonymous>' call
      var message = 'Illegal index ' + index + ', ' + this.z18() + ' expects only non-negative indices';
      throw IllegalArgumentException_init_$Create$(toString(message));
    }
    return emptyList();
  };
  protoOf(MapLikeDescriptor).i19 = function (index) {
    // Inline function 'kotlin.require' call
    // Inline function 'kotlin.contracts.contract' call
    if (!(index >= 0)) {
      // Inline function 'kotlinx.serialization.internal.MapLikeDescriptor.getElementDescriptor.<anonymous>' call
      var message = 'Illegal index ' + index + ', ' + this.z18() + ' expects only non-negative indices';
      throw IllegalArgumentException_init_$Create$(toString(message));
    }
    var tmp;
    switch (index % 2 | 0) {
      case 0:
        tmp = this.d1d_1;
        break;
      case 1:
        tmp = this.e1d_1;
        break;
      default:
        var message_0 = 'Unreached';
        throw IllegalStateException_init_$Create$(toString(message_0));
    }
    return tmp;
  };
  protoOf(MapLikeDescriptor).equals = function (other) {
    if (this === other)
      return true;
    if (!(other instanceof MapLikeDescriptor))
      return false;
    if (!(this.z18() === other.z18()))
      return false;
    if (!equals(this.d1d_1, other.d1d_1))
      return false;
    if (!equals(this.e1d_1, other.e1d_1))
      return false;
    return true;
  };
  protoOf(MapLikeDescriptor).hashCode = function () {
    var result = getStringHashCode(this.z18());
    result = imul(31, result) + hashCode(this.d1d_1) | 0;
    result = imul(31, result) + hashCode(this.e1d_1) | 0;
    return result;
  };
  protoOf(MapLikeDescriptor).toString = function () {
    return this.z18() + '(' + this.d1d_1 + ', ' + this.e1d_1 + ')';
  };
  function PrimitiveArrayDescriptor(primitive) {
    ListLikeDescriptor.call(this, primitive);
    this.i1d_1 = primitive.z18() + 'Array';
  }
  protoOf(PrimitiveArrayDescriptor).z18 = function () {
    return this.i1d_1;
  };
  function ArrayListSerializer(element) {
    CollectionSerializer.call(this, element);
    this.k1d_1 = new ArrayListClassDesc(element.p18());
  }
  protoOf(ArrayListSerializer).p18 = function () {
    return this.k1d_1;
  };
  protoOf(ArrayListSerializer).l1d = function () {
    // Inline function 'kotlin.collections.arrayListOf' call
    return ArrayList_init_$Create$();
  };
  protoOf(ArrayListSerializer).m1d = function (_this__u8e3s4) {
    return _this__u8e3s4.n();
  };
  protoOf(ArrayListSerializer).n1d = function (_this__u8e3s4) {
    return this.m1d(_this__u8e3s4 instanceof ArrayList ? _this__u8e3s4 : THROW_CCE());
  };
  protoOf(ArrayListSerializer).o1d = function (_this__u8e3s4) {
    return _this__u8e3s4;
  };
  protoOf(ArrayListSerializer).p1d = function (_this__u8e3s4) {
    return this.o1d(_this__u8e3s4 instanceof ArrayList ? _this__u8e3s4 : THROW_CCE());
  };
  protoOf(ArrayListSerializer).q1d = function (_this__u8e3s4) {
    var tmp0_elvis_lhs = _this__u8e3s4 instanceof ArrayList ? _this__u8e3s4 : null;
    return tmp0_elvis_lhs == null ? ArrayList_init_$Create$_1(_this__u8e3s4) : tmp0_elvis_lhs;
  };
  protoOf(ArrayListSerializer).r1d = function (_this__u8e3s4) {
    return this.q1d((!(_this__u8e3s4 == null) ? isInterface(_this__u8e3s4, List) : false) ? _this__u8e3s4 : THROW_CCE());
  };
  protoOf(ArrayListSerializer).s1d = function (_this__u8e3s4, size) {
    return _this__u8e3s4.v2(size);
  };
  protoOf(ArrayListSerializer).t1d = function (_this__u8e3s4, size) {
    return this.s1d(_this__u8e3s4 instanceof ArrayList ? _this__u8e3s4 : THROW_CCE(), size);
  };
  protoOf(ArrayListSerializer).u1d = function (_this__u8e3s4, index, element) {
    _this__u8e3s4.n1(index, element);
  };
  protoOf(ArrayListSerializer).v1d = function (_this__u8e3s4, index, element) {
    var tmp = _this__u8e3s4 instanceof ArrayList ? _this__u8e3s4 : THROW_CCE();
    return this.u1d(tmp, index, (element == null ? true : !(element == null)) ? element : THROW_CCE());
  };
  function LinkedHashMapSerializer(kSerializer, vSerializer) {
    MapLikeSerializer.call(this, kSerializer, vSerializer);
    this.h1e_1 = new LinkedHashMapClassDesc(kSerializer.p18(), vSerializer.p18());
  }
  protoOf(LinkedHashMapSerializer).p18 = function () {
    return this.h1e_1;
  };
  protoOf(LinkedHashMapSerializer).i1e = function (_this__u8e3s4) {
    return _this__u8e3s4.n();
  };
  protoOf(LinkedHashMapSerializer).j1e = function (_this__u8e3s4) {
    return this.i1e((!(_this__u8e3s4 == null) ? isInterface(_this__u8e3s4, Map) : false) ? _this__u8e3s4 : THROW_CCE());
  };
  protoOf(LinkedHashMapSerializer).k1e = function (_this__u8e3s4) {
    // Inline function 'kotlin.collections.iterator' call
    return _this__u8e3s4.b2().u();
  };
  protoOf(LinkedHashMapSerializer).l1e = function (_this__u8e3s4) {
    return this.k1e((!(_this__u8e3s4 == null) ? isInterface(_this__u8e3s4, Map) : false) ? _this__u8e3s4 : THROW_CCE());
  };
  protoOf(LinkedHashMapSerializer).l1d = function () {
    return LinkedHashMap_init_$Create$();
  };
  protoOf(LinkedHashMapSerializer).m1e = function (_this__u8e3s4) {
    return imul(_this__u8e3s4.n(), 2);
  };
  protoOf(LinkedHashMapSerializer).n1d = function (_this__u8e3s4) {
    return this.m1e(_this__u8e3s4 instanceof LinkedHashMap ? _this__u8e3s4 : THROW_CCE());
  };
  protoOf(LinkedHashMapSerializer).n1e = function (_this__u8e3s4) {
    return _this__u8e3s4;
  };
  protoOf(LinkedHashMapSerializer).p1d = function (_this__u8e3s4) {
    return this.n1e(_this__u8e3s4 instanceof LinkedHashMap ? _this__u8e3s4 : THROW_CCE());
  };
  protoOf(LinkedHashMapSerializer).o1e = function (_this__u8e3s4) {
    var tmp0_elvis_lhs = _this__u8e3s4 instanceof LinkedHashMap ? _this__u8e3s4 : null;
    return tmp0_elvis_lhs == null ? LinkedHashMap_init_$Create$_0(_this__u8e3s4) : tmp0_elvis_lhs;
  };
  protoOf(LinkedHashMapSerializer).r1d = function (_this__u8e3s4) {
    return this.o1e((!(_this__u8e3s4 == null) ? isInterface(_this__u8e3s4, Map) : false) ? _this__u8e3s4 : THROW_CCE());
  };
  protoOf(LinkedHashMapSerializer).p1e = function (_this__u8e3s4, size) {
  };
  protoOf(LinkedHashMapSerializer).t1d = function (_this__u8e3s4, size) {
    return this.p1e(_this__u8e3s4 instanceof LinkedHashMap ? _this__u8e3s4 : THROW_CCE(), size);
  };
  function CollectionSerializer(element) {
    CollectionLikeSerializer.call(this, element);
  }
  protoOf(CollectionSerializer).x1d = function (_this__u8e3s4) {
    return _this__u8e3s4.n();
  };
  protoOf(CollectionSerializer).j1e = function (_this__u8e3s4) {
    return this.x1d((!(_this__u8e3s4 == null) ? isInterface(_this__u8e3s4, Collection) : false) ? _this__u8e3s4 : THROW_CCE());
  };
  protoOf(CollectionSerializer).y1d = function (_this__u8e3s4) {
    return _this__u8e3s4.u();
  };
  protoOf(CollectionSerializer).l1e = function (_this__u8e3s4) {
    return this.y1d((!(_this__u8e3s4 == null) ? isInterface(_this__u8e3s4, Collection) : false) ? _this__u8e3s4 : THROW_CCE());
  };
  function MapLikeSerializer(keySerializer, valueSerializer) {
    AbstractCollectionSerializer.call(this);
    this.q1e_1 = keySerializer;
    this.r1e_1 = valueSerializer;
  }
  protoOf(MapLikeSerializer).s1e = function (decoder, builder, startIndex, size) {
    // Inline function 'kotlin.require' call
    // Inline function 'kotlin.contracts.contract' call
    if (!(size >= 0)) {
      // Inline function 'kotlinx.serialization.internal.MapLikeSerializer.readAll.<anonymous>' call
      var message = 'Size must be known in advance when using READ_ALL';
      throw IllegalArgumentException_init_$Create$(toString(message));
    }
    var progression = step(until(0, imul(size, 2)), 2);
    var inductionVariable = progression.m8_1;
    var last = progression.n8_1;
    var step_0 = progression.o8_1;
    if ((step_0 > 0 ? inductionVariable <= last : false) ? true : step_0 < 0 ? last <= inductionVariable : false)
      do {
        var index = inductionVariable;
        inductionVariable = inductionVariable + step_0 | 0;
        this.t1e(decoder, startIndex + index | 0, builder, false);
      }
       while (!(index === last));
  };
  protoOf(MapLikeSerializer).b1e = function (decoder, builder, startIndex, size) {
    return this.s1e(decoder, (!(builder == null) ? isInterface(builder, MutableMap) : false) ? builder : THROW_CCE(), startIndex, size);
  };
  protoOf(MapLikeSerializer).t1e = function (decoder, index, builder, checkIndex) {
    var key = decoder.l1b(this.p18(), index, this.q1e_1);
    var tmp;
    if (checkIndex) {
      // Inline function 'kotlin.also' call
      var this_0 = decoder.o1b(this.p18());
      // Inline function 'kotlin.contracts.contract' call
      // Inline function 'kotlinx.serialization.internal.MapLikeSerializer.readElement.<anonymous>' call
      // Inline function 'kotlin.require' call
      // Inline function 'kotlin.contracts.contract' call
      if (!(this_0 === (index + 1 | 0))) {
        // Inline function 'kotlinx.serialization.internal.MapLikeSerializer.readElement.<anonymous>.<anonymous>' call
        var message = 'Value must follow key in a map, index for key: ' + index + ', returned index for value: ' + this_0;
        throw IllegalArgumentException_init_$Create$(toString(message));
      }
      tmp = this_0;
    } else {
      tmp = index + 1 | 0;
    }
    var vIndex = tmp;
    var tmp_0;
    var tmp_1;
    if (builder.j2(key)) {
      var tmp_2 = this.r1e_1.p18().a19();
      tmp_1 = !(tmp_2 instanceof PrimitiveKind);
    } else {
      tmp_1 = false;
    }
    if (tmp_1) {
      tmp_0 = decoder.k1b(this.p18(), vIndex, this.r1e_1, getValue(builder, key));
    } else {
      tmp_0 = decoder.l1b(this.p18(), vIndex, this.r1e_1);
    }
    var value = tmp_0;
    // Inline function 'kotlin.collections.set' call
    builder.c2(key, value);
  };
  protoOf(MapLikeSerializer).c1e = function (decoder, index, builder, checkIndex) {
    return this.t1e(decoder, index, (!(builder == null) ? isInterface(builder, MutableMap) : false) ? builder : THROW_CCE(), checkIndex);
  };
  protoOf(MapLikeSerializer).a1e = function (encoder, value) {
    var size = this.j1e(value);
    // Inline function 'kotlinx.serialization.encoding.encodeCollection' call
    var descriptor = this.p18();
    var composite = encoder.o1c(descriptor, size);
    // Inline function 'kotlinx.serialization.internal.MapLikeSerializer.serialize.<anonymous>' call
    var iterator = this.l1e(value);
    var index = 0;
    // Inline function 'kotlin.collections.forEach' call
    // Inline function 'kotlin.collections.iterator' call
    var tmp0_iterator = iterator;
    while (tmp0_iterator.v()) {
      var element = tmp0_iterator.w();
      // Inline function 'kotlinx.serialization.internal.MapLikeSerializer.serialize.<anonymous>.<anonymous>' call
      // Inline function 'kotlin.collections.component1' call
      var k = element.e2();
      // Inline function 'kotlin.collections.component2' call
      var v = element.f2();
      var tmp = this.p18();
      var tmp0 = index;
      index = tmp0 + 1 | 0;
      composite.m1c(tmp, tmp0, this.q1e_1, k);
      var tmp_0 = this.p18();
      var tmp1 = index;
      index = tmp1 + 1 | 0;
      composite.m1c(tmp_0, tmp1, this.r1e_1, v);
    }
    composite.a1b(descriptor);
  };
  protoOf(MapLikeSerializer).q18 = function (encoder, value) {
    return this.a1e(encoder, (value == null ? true : !(value == null)) ? value : THROW_CCE());
  };
  function CollectionLikeSerializer(elementSerializer) {
    AbstractCollectionSerializer.call(this);
    this.z1d_1 = elementSerializer;
  }
  protoOf(CollectionLikeSerializer).a1e = function (encoder, value) {
    var size = this.j1e(value);
    // Inline function 'kotlinx.serialization.encoding.encodeCollection' call
    var descriptor = this.p18();
    var composite = encoder.o1c(descriptor, size);
    // Inline function 'kotlinx.serialization.internal.CollectionLikeSerializer.serialize.<anonymous>' call
    var iterator = this.l1e(value);
    var inductionVariable = 0;
    if (inductionVariable < size)
      do {
        var index = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        composite.m1c(this.p18(), index, this.z1d_1, iterator.w());
      }
       while (inductionVariable < size);
    composite.a1b(descriptor);
  };
  protoOf(CollectionLikeSerializer).q18 = function (encoder, value) {
    return this.a1e(encoder, (value == null ? true : !(value == null)) ? value : THROW_CCE());
  };
  protoOf(CollectionLikeSerializer).b1e = function (decoder, builder, startIndex, size) {
    // Inline function 'kotlin.require' call
    // Inline function 'kotlin.contracts.contract' call
    if (!(size >= 0)) {
      // Inline function 'kotlinx.serialization.internal.CollectionLikeSerializer.readAll.<anonymous>' call
      var message = 'Size must be known in advance when using READ_ALL';
      throw IllegalArgumentException_init_$Create$(toString(message));
    }
    var inductionVariable = 0;
    if (inductionVariable < size)
      do {
        var index = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        this.c1e(decoder, startIndex + index | 0, builder, false);
      }
       while (inductionVariable < size);
  };
  protoOf(CollectionLikeSerializer).c1e = function (decoder, index, builder, checkIndex) {
    this.v1d(builder, index, decoder.l1b(this.p18(), index, this.z1d_1));
  };
  function readSize($this, decoder, builder) {
    var size = decoder.p1b($this.p18());
    $this.t1d(builder, size);
    return size;
  }
  function AbstractCollectionSerializer() {
  }
  protoOf(AbstractCollectionSerializer).e1e = function (decoder, previous) {
    var tmp1_elvis_lhs = previous == null ? null : this.r1d(previous);
    var builder = tmp1_elvis_lhs == null ? this.l1d() : tmp1_elvis_lhs;
    var startIndex = this.n1d(builder);
    var compositeDecoder = decoder.z1a(this.p18());
    if (compositeDecoder.n1b()) {
      this.b1e(compositeDecoder, builder, startIndex, readSize(this, compositeDecoder, builder));
    } else {
      $l$loop: while (true) {
        var index = compositeDecoder.o1b(this.p18());
        if (index === -1)
          break $l$loop;
        this.d1e(compositeDecoder, startIndex + index | 0, builder);
      }
    }
    compositeDecoder.a1b(this.p18());
    return this.p1d(builder);
  };
  protoOf(AbstractCollectionSerializer).r18 = function (decoder) {
    return this.e1e(decoder, null);
  };
  protoOf(AbstractCollectionSerializer).d1e = function (decoder, index, builder, checkIndex, $super) {
    checkIndex = checkIndex === VOID ? true : checkIndex;
    var tmp;
    if ($super === VOID) {
      this.c1e(decoder, index, builder, checkIndex);
      tmp = Unit_instance;
    } else {
      tmp = $super.c1e.call(this, decoder, index, builder, checkIndex);
    }
    return tmp;
  };
  function PrimitiveArraySerializer(primitiveSerializer) {
    CollectionLikeSerializer.call(this, primitiveSerializer);
    this.v1e_1 = new PrimitiveArrayDescriptor(primitiveSerializer.p18());
  }
  protoOf(PrimitiveArraySerializer).p18 = function () {
    return this.v1e_1;
  };
  protoOf(PrimitiveArraySerializer).w1e = function (_this__u8e3s4) {
    return _this__u8e3s4.x1e();
  };
  protoOf(PrimitiveArraySerializer).n1d = function (_this__u8e3s4) {
    return this.w1e(_this__u8e3s4 instanceof PrimitiveArrayBuilder ? _this__u8e3s4 : THROW_CCE());
  };
  protoOf(PrimitiveArraySerializer).y1e = function (_this__u8e3s4) {
    return _this__u8e3s4.u2();
  };
  protoOf(PrimitiveArraySerializer).p1d = function (_this__u8e3s4) {
    return this.y1e(_this__u8e3s4 instanceof PrimitiveArrayBuilder ? _this__u8e3s4 : THROW_CCE());
  };
  protoOf(PrimitiveArraySerializer).z1e = function (_this__u8e3s4, size) {
    return _this__u8e3s4.v2(size);
  };
  protoOf(PrimitiveArraySerializer).t1d = function (_this__u8e3s4, size) {
    return this.z1e(_this__u8e3s4 instanceof PrimitiveArrayBuilder ? _this__u8e3s4 : THROW_CCE(), size);
  };
  protoOf(PrimitiveArraySerializer).a1f = function (_this__u8e3s4) {
    var message = 'This method lead to boxing and must not be used, use writeContents instead';
    throw IllegalStateException_init_$Create$(toString(message));
  };
  protoOf(PrimitiveArraySerializer).l1e = function (_this__u8e3s4) {
    return this.a1f((_this__u8e3s4 == null ? true : !(_this__u8e3s4 == null)) ? _this__u8e3s4 : THROW_CCE());
  };
  protoOf(PrimitiveArraySerializer).b1f = function (_this__u8e3s4, index, element) {
    var message = 'This method lead to boxing and must not be used, use Builder.append instead';
    throw IllegalStateException_init_$Create$(toString(message));
  };
  protoOf(PrimitiveArraySerializer).v1d = function (_this__u8e3s4, index, element) {
    var tmp = _this__u8e3s4 instanceof PrimitiveArrayBuilder ? _this__u8e3s4 : THROW_CCE();
    return this.b1f(tmp, index, (element == null ? true : !(element == null)) ? element : THROW_CCE());
  };
  protoOf(PrimitiveArraySerializer).l1d = function () {
    return this.r1d(this.c1f());
  };
  protoOf(PrimitiveArraySerializer).f1f = function (encoder, value) {
    var size = this.j1e(value);
    // Inline function 'kotlinx.serialization.encoding.encodeCollection' call
    var descriptor = this.v1e_1;
    var composite = encoder.o1c(descriptor, size);
    // Inline function 'kotlinx.serialization.internal.PrimitiveArraySerializer.serialize.<anonymous>' call
    this.e1f(composite, value, size);
    composite.a1b(descriptor);
  };
  protoOf(PrimitiveArraySerializer).q18 = function (encoder, value) {
    return this.f1f(encoder, (value == null ? true : !(value == null)) ? value : THROW_CCE());
  };
  protoOf(PrimitiveArraySerializer).a1e = function (encoder, value) {
    return this.f1f(encoder, (value == null ? true : !(value == null)) ? value : THROW_CCE());
  };
  protoOf(PrimitiveArraySerializer).r18 = function (decoder) {
    return this.e1e(decoder, null);
  };
  function PrimitiveArrayBuilder() {
  }
  protoOf(PrimitiveArrayBuilder).g1f = function (requiredCapacity, $super) {
    requiredCapacity = requiredCapacity === VOID ? this.x1e() + 1 | 0 : requiredCapacity;
    var tmp;
    if ($super === VOID) {
      this.v2(requiredCapacity);
      tmp = Unit_instance;
    } else {
      tmp = $super.v2.call(this, requiredCapacity);
    }
    return tmp;
  };
  function Companion_0() {
    Companion_instance_0 = this;
    this.h1f_1 = longArray(0);
  }
  var Companion_instance_0;
  function Companion_getInstance_7() {
    if (Companion_instance_0 == null)
      new Companion_0();
    return Companion_instance_0;
  }
  function prepareHighMarksArray($this, elementsCount) {
    var slotsCount = (elementsCount - 1 | 0) >>> 6 | 0;
    Companion_getInstance_0();
    var elementsInLastSlot = elementsCount & (64 - 1 | 0);
    var highMarks = longArray(slotsCount);
    if (!(elementsInLastSlot === 0)) {
      highMarks[get_lastIndex(highMarks)] = (new Long(-1, -1)).q9(elementsCount);
    }
    return highMarks;
  }
  function markHigh($this, index) {
    var slot = (index >>> 6 | 0) - 1 | 0;
    Companion_getInstance_0();
    var offsetInSlot = index & (64 - 1 | 0);
    $this.l1f_1[slot] = $this.l1f_1[slot].u9((new Long(1, 0)).q9(offsetInSlot));
  }
  function nextUnmarkedHighIndex($this) {
    var inductionVariable = 0;
    var last = $this.l1f_1.length - 1 | 0;
    if (inductionVariable <= last)
      do {
        var slot = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        var tmp = slot + 1 | 0;
        Companion_getInstance_0();
        var slotOffset = imul(tmp, 64);
        var slotMarks = $this.l1f_1[slot];
        while (!slotMarks.equals(new Long(-1, -1))) {
          var indexInSlot = countTrailingZeroBits(slotMarks.p9());
          slotMarks = slotMarks.u9((new Long(1, 0)).q9(indexInSlot));
          var index = slotOffset + indexInSlot | 0;
          if ($this.j1f_1($this.i1f_1, index)) {
            $this.l1f_1[slot] = slotMarks;
            return index;
          }
        }
        $this.l1f_1[slot] = slotMarks;
      }
       while (inductionVariable <= last);
    return -1;
  }
  function ElementMarker(descriptor, readIfAbsent) {
    Companion_getInstance_7();
    this.i1f_1 = descriptor;
    this.j1f_1 = readIfAbsent;
    var elementsCount = this.i1f_1.d19();
    Companion_getInstance_0();
    if (elementsCount <= 64) {
      var tmp = this;
      var tmp_0;
      Companion_getInstance_0();
      if (elementsCount === 64) {
        tmp_0 = new Long(0, 0);
      } else {
        tmp_0 = (new Long(-1, -1)).q9(elementsCount);
      }
      tmp.k1f_1 = tmp_0;
      this.l1f_1 = Companion_getInstance_7().h1f_1;
    } else {
      this.k1f_1 = new Long(0, 0);
      this.l1f_1 = prepareHighMarksArray(this, elementsCount);
    }
  }
  protoOf(ElementMarker).m1f = function (index) {
    Companion_getInstance_0();
    if (index < 64) {
      this.k1f_1 = this.k1f_1.u9((new Long(1, 0)).q9(index));
    } else {
      markHigh(this, index);
    }
  };
  protoOf(ElementMarker).n1f = function () {
    var elementsCount = this.i1f_1.d19();
    while (!this.k1f_1.equals(new Long(-1, -1))) {
      var index = countTrailingZeroBits(this.k1f_1.p9());
      this.k1f_1 = this.k1f_1.u9((new Long(1, 0)).q9(index));
      if (this.j1f_1(this.i1f_1, index)) {
        return index;
      }
    }
    Companion_getInstance_0();
    if (elementsCount > 64) {
      return nextUnmarkedHighIndex(this);
    }
    return -1;
  };
  function InlinePrimitiveDescriptor(name, primitiveSerializer) {
    return new InlineClassDescriptor(name, new InlinePrimitiveDescriptor$1(primitiveSerializer));
  }
  function InlineClassDescriptor(name, generatedSerializer) {
    PluginGeneratedSerialDescriptor.call(this, name, generatedSerializer, 1);
    this.a1g_1 = true;
  }
  protoOf(InlineClassDescriptor).c19 = function () {
    return this.a1g_1;
  };
  protoOf(InlineClassDescriptor).hashCode = function () {
    return imul(protoOf(PluginGeneratedSerialDescriptor).hashCode.call(this), 31);
  };
  protoOf(InlineClassDescriptor).equals = function (other) {
    var tmp$ret$0;
    $l$block_5: {
      // Inline function 'kotlinx.serialization.internal.equalsImpl' call
      if (this === other) {
        tmp$ret$0 = true;
        break $l$block_5;
      }
      if (!(other instanceof InlineClassDescriptor)) {
        tmp$ret$0 = false;
        break $l$block_5;
      }
      if (!(this.z18() === other.z18())) {
        tmp$ret$0 = false;
        break $l$block_5;
      }
      // Inline function 'kotlinx.serialization.internal.InlineClassDescriptor.equals.<anonymous>' call
      if (!(other.a1g_1 ? contentEquals(this.n1g(), other.n1g()) : false)) {
        tmp$ret$0 = false;
        break $l$block_5;
      }
      if (!(this.d19() === other.d19())) {
        tmp$ret$0 = false;
        break $l$block_5;
      }
      var inductionVariable = 0;
      var last = this.d19();
      if (inductionVariable < last)
        do {
          var index = inductionVariable;
          inductionVariable = inductionVariable + 1 | 0;
          if (!(this.i19(index).z18() === other.i19(index).z18())) {
            tmp$ret$0 = false;
            break $l$block_5;
          }
          if (!equals(this.i19(index).a19(), other.i19(index).a19())) {
            tmp$ret$0 = false;
            break $l$block_5;
          }
        }
         while (inductionVariable < last);
      tmp$ret$0 = true;
    }
    return tmp$ret$0;
  };
  function InlinePrimitiveDescriptor$1($primitiveSerializer) {
    this.p1g_1 = $primitiveSerializer;
  }
  protoOf(InlinePrimitiveDescriptor$1).q1g = function () {
    // Inline function 'kotlin.arrayOf' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    return [this.p1g_1];
  };
  protoOf(InlinePrimitiveDescriptor$1).p18 = function () {
    var message = 'unsupported';
    throw IllegalStateException_init_$Create$(toString(message));
  };
  protoOf(InlinePrimitiveDescriptor$1).q18 = function (encoder, value) {
    // Inline function 'kotlin.error' call
    var message = 'unsupported';
    throw IllegalStateException_init_$Create$(toString(message));
  };
  protoOf(InlinePrimitiveDescriptor$1).r18 = function (decoder) {
    // Inline function 'kotlin.error' call
    var message = 'unsupported';
    throw IllegalStateException_init_$Create$(toString(message));
  };
  function jsonCachedSerialNames(_this__u8e3s4) {
    return cachedSerialNames(_this__u8e3s4);
  }
  function NoOpEncoder() {
    NoOpEncoder_instance = this;
    AbstractEncoder.call(this);
    this.s1g_1 = EmptySerializersModule_0();
  }
  protoOf(NoOpEncoder).m1b = function () {
    return this.s1g_1;
  };
  protoOf(NoOpEncoder).r1b = function (value) {
    return Unit_instance;
  };
  protoOf(NoOpEncoder).s1b = function () {
    return Unit_instance;
  };
  protoOf(NoOpEncoder).t1b = function (value) {
    return Unit_instance;
  };
  protoOf(NoOpEncoder).u1b = function (value) {
    return Unit_instance;
  };
  protoOf(NoOpEncoder).v1b = function (value) {
    return Unit_instance;
  };
  protoOf(NoOpEncoder).w1b = function (value) {
    return Unit_instance;
  };
  protoOf(NoOpEncoder).x1b = function (value) {
    return Unit_instance;
  };
  protoOf(NoOpEncoder).y1b = function (value) {
    return Unit_instance;
  };
  protoOf(NoOpEncoder).z1b = function (value) {
    return Unit_instance;
  };
  protoOf(NoOpEncoder).a1c = function (value) {
    return Unit_instance;
  };
  protoOf(NoOpEncoder).b1c = function (value) {
    return Unit_instance;
  };
  var NoOpEncoder_instance;
  function NoOpEncoder_getInstance() {
    if (NoOpEncoder_instance == null)
      new NoOpEncoder();
    return NoOpEncoder_instance;
  }
  function error($this) {
    throw IllegalStateException_init_$Create$('Descriptor for type `kotlin.Nothing` does not have elements');
  }
  function NothingSerialDescriptor() {
    NothingSerialDescriptor_instance = this;
    this.t1g_1 = OBJECT_getInstance();
    this.u1g_1 = 'kotlin.Nothing';
  }
  protoOf(NothingSerialDescriptor).a19 = function () {
    return this.t1g_1;
  };
  protoOf(NothingSerialDescriptor).z18 = function () {
    return this.u1g_1;
  };
  protoOf(NothingSerialDescriptor).d19 = function () {
    return 0;
  };
  protoOf(NothingSerialDescriptor).f19 = function (index) {
    error(this);
  };
  protoOf(NothingSerialDescriptor).g19 = function (name) {
    error(this);
  };
  protoOf(NothingSerialDescriptor).j19 = function (index) {
    error(this);
  };
  protoOf(NothingSerialDescriptor).i19 = function (index) {
    error(this);
  };
  protoOf(NothingSerialDescriptor).h19 = function (index) {
    error(this);
  };
  protoOf(NothingSerialDescriptor).toString = function () {
    return 'NothingSerialDescriptor';
  };
  protoOf(NothingSerialDescriptor).equals = function (other) {
    return this === other;
  };
  protoOf(NothingSerialDescriptor).hashCode = function () {
    return getStringHashCode(this.u1g_1) + imul(31, this.t1g_1.hashCode()) | 0;
  };
  var NothingSerialDescriptor_instance;
  function NothingSerialDescriptor_getInstance() {
    if (NothingSerialDescriptor_instance == null)
      new NothingSerialDescriptor();
    return NothingSerialDescriptor_instance;
  }
  function SerialDescriptorForNullable() {
  }
  function ObjectSerializer$descriptor$delegate$lambda$lambda(this$0) {
    return function ($this$buildSerialDescriptor) {
      $this$buildSerialDescriptor.p19_1 = this$0.w1g_1;
      return Unit_instance;
    };
  }
  function ObjectSerializer$descriptor$delegate$lambda($serialName, this$0) {
    return function () {
      var tmp = OBJECT_getInstance();
      return buildSerialDescriptor($serialName, tmp, [], ObjectSerializer$descriptor$delegate$lambda$lambda(this$0));
    };
  }
  function ObjectSerializer(serialName, objectInstance) {
    this.v1g_1 = objectInstance;
    this.w1g_1 = emptyList();
    var tmp = this;
    var tmp_0 = LazyThreadSafetyMode_PUBLICATION_getInstance();
    tmp.x1g_1 = lazy_0(tmp_0, ObjectSerializer$descriptor$delegate$lambda(serialName, this));
  }
  protoOf(ObjectSerializer).p18 = function () {
    // Inline function 'kotlin.getValue' call
    var this_0 = this.x1g_1;
    descriptor$factory();
    return this_0.f2();
  };
  protoOf(ObjectSerializer).y1g = function (encoder, value) {
    encoder.z1a(this.p18()).a1b(this.p18());
  };
  protoOf(ObjectSerializer).q18 = function (encoder, value) {
    return this.y1g(encoder, !(value == null) ? value : THROW_CCE());
  };
  protoOf(ObjectSerializer).r18 = function (decoder) {
    // Inline function 'kotlinx.serialization.encoding.decodeStructure' call
    var descriptor = this.p18();
    var composite = decoder.z1a(descriptor);
    var tmp$ret$0;
    $l$block_0: {
      // Inline function 'kotlinx.serialization.internal.ObjectSerializer.deserialize.<anonymous>' call
      if (composite.n1b()) {
        tmp$ret$0 = Unit_instance;
        break $l$block_0;
      }
      var index = composite.o1b(this.p18());
      if (index === -1) {
        tmp$ret$0 = Unit_instance;
        break $l$block_0;
      } else {
        throw SerializationException_init_$Create$_0('Unexpected index ' + index);
      }
    }
    var result = tmp$ret$0;
    composite.a1b(descriptor);
    return this.v1g_1;
  };
  function descriptor$factory() {
    return getPropertyCallableRef('descriptor', 1, KProperty1, function (receiver) {
      return receiver.p18();
    }, null);
  }
  function get_EMPTY_DESCRIPTOR_ARRAY() {
    _init_properties_Platform_common_kt__3qzecs();
    return EMPTY_DESCRIPTOR_ARRAY;
  }
  var EMPTY_DESCRIPTOR_ARRAY;
  function cachedSerialNames(_this__u8e3s4) {
    _init_properties_Platform_common_kt__3qzecs();
    if (isInterface(_this__u8e3s4, CachedNames))
      return _this__u8e3s4.j1a();
    var result = HashSet_init_$Create$_0(_this__u8e3s4.d19());
    var inductionVariable = 0;
    var last = _this__u8e3s4.d19();
    if (inductionVariable < last)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        // Inline function 'kotlin.collections.plusAssign' call
        var element = _this__u8e3s4.f19(i);
        result.r(element);
      }
       while (inductionVariable < last);
    return result;
  }
  function compactArray(_this__u8e3s4) {
    _init_properties_Platform_common_kt__3qzecs();
    // Inline function 'kotlin.takeUnless' call
    // Inline function 'kotlin.contracts.contract' call
    var tmp;
    // Inline function 'kotlinx.serialization.internal.compactArray.<anonymous>' call
    // Inline function 'kotlin.collections.isNullOrEmpty' call
    // Inline function 'kotlin.contracts.contract' call
    if (!(_this__u8e3s4 == null ? true : _this__u8e3s4.b1())) {
      tmp = _this__u8e3s4;
    } else {
      tmp = null;
    }
    var tmp0_safe_receiver = tmp;
    var tmp_0;
    if (tmp0_safe_receiver == null) {
      tmp_0 = null;
    } else {
      // Inline function 'kotlin.collections.toTypedArray' call
      tmp_0 = copyToArray(tmp0_safe_receiver);
    }
    var tmp1_elvis_lhs = tmp_0;
    return tmp1_elvis_lhs == null ? get_EMPTY_DESCRIPTOR_ARRAY() : tmp1_elvis_lhs;
  }
  var properties_initialized_Platform_common_kt_i7q4ty;
  function _init_properties_Platform_common_kt__3qzecs() {
    if (!properties_initialized_Platform_common_kt_i7q4ty) {
      properties_initialized_Platform_common_kt_i7q4ty = true;
      // Inline function 'kotlin.arrayOf' call
      // Inline function 'kotlin.js.unsafeCast' call
      // Inline function 'kotlin.js.asDynamic' call
      EMPTY_DESCRIPTOR_ARRAY = [];
    }
  }
  function throwMissingFieldException(seen, goldenMask, descriptor) {
    // Inline function 'kotlin.collections.mutableListOf' call
    var missingFields = ArrayList_init_$Create$();
    var missingFieldsBits = goldenMask & ~seen;
    var inductionVariable = 0;
    if (inductionVariable < 32)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        if (!((missingFieldsBits & 1) === 0)) {
          // Inline function 'kotlin.collections.plusAssign' call
          var element = descriptor.f19(i);
          missingFields.r(element);
        }
        missingFieldsBits = missingFieldsBits >>> 1 | 0;
      }
       while (inductionVariable < 32);
    throw MissingFieldException_init_$Create$(missingFields, descriptor.z18());
  }
  function _get_childSerializers__7vnyfa($this) {
    // Inline function 'kotlin.getValue' call
    var this_0 = $this.k1g_1;
    childSerializers$factory();
    return this_0.f2();
  }
  function _get__hashCode__tgwhef_0($this) {
    // Inline function 'kotlin.getValue' call
    var this_0 = $this.m1g_1;
    _hashCode$factory_0();
    return this_0.f2();
  }
  function buildIndices($this) {
    var indices = HashMap_init_$Create$();
    var inductionVariable = 0;
    var last = $this.f1g_1.length - 1 | 0;
    if (inductionVariable <= last)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        // Inline function 'kotlin.collections.set' call
        var key = $this.f1g_1[i];
        indices.c2(key, i);
      }
       while (inductionVariable <= last);
    return indices;
  }
  function PluginGeneratedSerialDescriptor$childSerializers$delegate$lambda(this$0) {
    return function () {
      var tmp0_safe_receiver = this$0.c1g_1;
      var tmp1_elvis_lhs = tmp0_safe_receiver == null ? null : tmp0_safe_receiver.q1g();
      return tmp1_elvis_lhs == null ? get_EMPTY_SERIALIZER_ARRAY() : tmp1_elvis_lhs;
    };
  }
  function PluginGeneratedSerialDescriptor$typeParameterDescriptors$delegate$lambda(this$0) {
    return function () {
      var tmp0_safe_receiver = this$0.c1g_1;
      var tmp1_safe_receiver = tmp0_safe_receiver == null ? null : tmp0_safe_receiver.r1g();
      var tmp;
      if (tmp1_safe_receiver == null) {
        tmp = null;
      } else {
        // Inline function 'kotlin.collections.map' call
        // Inline function 'kotlin.collections.mapTo' call
        var destination = ArrayList_init_$Create$_0(tmp1_safe_receiver.length);
        var inductionVariable = 0;
        var last = tmp1_safe_receiver.length;
        while (inductionVariable < last) {
          var item = tmp1_safe_receiver[inductionVariable];
          inductionVariable = inductionVariable + 1 | 0;
          // Inline function 'kotlinx.serialization.internal.PluginGeneratedSerialDescriptor.typeParameterDescriptors$delegate.<anonymous>.<anonymous>' call
          var tmp$ret$0 = item.p18();
          destination.r(tmp$ret$0);
        }
        tmp = destination;
      }
      return compactArray(tmp);
    };
  }
  function PluginGeneratedSerialDescriptor$_hashCode$delegate$lambda(this$0) {
    return function () {
      return hashCodeImpl(this$0, this$0.n1g());
    };
  }
  function PluginGeneratedSerialDescriptor$toString$lambda(this$0) {
    return function (i) {
      return this$0.f19(i) + ': ' + this$0.i19(i).z18();
    };
  }
  function PluginGeneratedSerialDescriptor(serialName, generatedSerializer, elementsCount) {
    generatedSerializer = generatedSerializer === VOID ? null : generatedSerializer;
    this.b1g_1 = serialName;
    this.c1g_1 = generatedSerializer;
    this.d1g_1 = elementsCount;
    this.e1g_1 = -1;
    var tmp = this;
    var tmp_0 = 0;
    var tmp_1 = this.d1g_1;
    // Inline function 'kotlin.arrayOfNulls' call
    var tmp_2 = fillArrayVal(Array(tmp_1), null);
    while (tmp_0 < tmp_1) {
      tmp_2[tmp_0] = '[UNINITIALIZED]';
      tmp_0 = tmp_0 + 1 | 0;
    }
    tmp.f1g_1 = tmp_2;
    var tmp_3 = this;
    // Inline function 'kotlin.arrayOfNulls' call
    var size = this.d1g_1;
    tmp_3.g1g_1 = fillArrayVal(Array(size), null);
    this.h1g_1 = null;
    this.i1g_1 = booleanArray(this.d1g_1);
    this.j1g_1 = emptyMap();
    var tmp_4 = this;
    var tmp_5 = LazyThreadSafetyMode_PUBLICATION_getInstance();
    tmp_4.k1g_1 = lazy_0(tmp_5, PluginGeneratedSerialDescriptor$childSerializers$delegate$lambda(this));
    var tmp_6 = this;
    var tmp_7 = LazyThreadSafetyMode_PUBLICATION_getInstance();
    tmp_6.l1g_1 = lazy_0(tmp_7, PluginGeneratedSerialDescriptor$typeParameterDescriptors$delegate$lambda(this));
    var tmp_8 = this;
    var tmp_9 = LazyThreadSafetyMode_PUBLICATION_getInstance();
    tmp_8.m1g_1 = lazy_0(tmp_9, PluginGeneratedSerialDescriptor$_hashCode$delegate$lambda(this));
  }
  protoOf(PluginGeneratedSerialDescriptor).z18 = function () {
    return this.b1g_1;
  };
  protoOf(PluginGeneratedSerialDescriptor).d19 = function () {
    return this.d1g_1;
  };
  protoOf(PluginGeneratedSerialDescriptor).a19 = function () {
    return CLASS_getInstance();
  };
  protoOf(PluginGeneratedSerialDescriptor).e19 = function () {
    var tmp0_elvis_lhs = this.h1g_1;
    return tmp0_elvis_lhs == null ? emptyList() : tmp0_elvis_lhs;
  };
  protoOf(PluginGeneratedSerialDescriptor).j1a = function () {
    return this.j1g_1.z1();
  };
  protoOf(PluginGeneratedSerialDescriptor).n1g = function () {
    // Inline function 'kotlin.getValue' call
    var this_0 = this.l1g_1;
    typeParameterDescriptors$factory();
    return this_0.f2();
  };
  protoOf(PluginGeneratedSerialDescriptor).o1g = function (name, isOptional) {
    this.e1g_1 = this.e1g_1 + 1 | 0;
    this.f1g_1[this.e1g_1] = name;
    this.i1g_1[this.e1g_1] = isOptional;
    this.g1g_1[this.e1g_1] = null;
    if (this.e1g_1 === (this.d1g_1 - 1 | 0)) {
      this.j1g_1 = buildIndices(this);
    }
  };
  protoOf(PluginGeneratedSerialDescriptor).i19 = function (index) {
    return getChecked(_get_childSerializers__7vnyfa(this), index).p18();
  };
  protoOf(PluginGeneratedSerialDescriptor).j19 = function (index) {
    return getChecked_0(this.i1g_1, index);
  };
  protoOf(PluginGeneratedSerialDescriptor).h19 = function (index) {
    var tmp0_elvis_lhs = getChecked(this.g1g_1, index);
    return tmp0_elvis_lhs == null ? emptyList() : tmp0_elvis_lhs;
  };
  protoOf(PluginGeneratedSerialDescriptor).f19 = function (index) {
    return getChecked(this.f1g_1, index);
  };
  protoOf(PluginGeneratedSerialDescriptor).g19 = function (name) {
    var tmp0_elvis_lhs = this.j1g_1.m2(name);
    var tmp;
    if (tmp0_elvis_lhs == null) {
      tmp = -3;
    } else {
      tmp = tmp0_elvis_lhs;
    }
    return tmp;
  };
  protoOf(PluginGeneratedSerialDescriptor).equals = function (other) {
    var tmp$ret$0;
    $l$block_5: {
      // Inline function 'kotlinx.serialization.internal.equalsImpl' call
      if (this === other) {
        tmp$ret$0 = true;
        break $l$block_5;
      }
      if (!(other instanceof PluginGeneratedSerialDescriptor)) {
        tmp$ret$0 = false;
        break $l$block_5;
      }
      if (!(this.z18() === other.z18())) {
        tmp$ret$0 = false;
        break $l$block_5;
      }
      // Inline function 'kotlinx.serialization.internal.PluginGeneratedSerialDescriptor.equals.<anonymous>' call
      if (!contentEquals(this.n1g(), other.n1g())) {
        tmp$ret$0 = false;
        break $l$block_5;
      }
      if (!(this.d19() === other.d19())) {
        tmp$ret$0 = false;
        break $l$block_5;
      }
      var inductionVariable = 0;
      var last = this.d19();
      if (inductionVariable < last)
        do {
          var index = inductionVariable;
          inductionVariable = inductionVariable + 1 | 0;
          if (!(this.i19(index).z18() === other.i19(index).z18())) {
            tmp$ret$0 = false;
            break $l$block_5;
          }
          if (!equals(this.i19(index).a19(), other.i19(index).a19())) {
            tmp$ret$0 = false;
            break $l$block_5;
          }
        }
         while (inductionVariable < last);
      tmp$ret$0 = true;
    }
    return tmp$ret$0;
  };
  protoOf(PluginGeneratedSerialDescriptor).hashCode = function () {
    return _get__hashCode__tgwhef_0(this);
  };
  protoOf(PluginGeneratedSerialDescriptor).toString = function () {
    var tmp = until(0, this.d1g_1);
    var tmp_0 = this.z18() + '(';
    return joinToString(tmp, ', ', tmp_0, ')', VOID, VOID, PluginGeneratedSerialDescriptor$toString$lambda(this));
  };
  function hashCodeImpl(_this__u8e3s4, typeParams) {
    var result = getStringHashCode(_this__u8e3s4.z18());
    result = imul(31, result) + contentHashCode(typeParams) | 0;
    var elementDescriptors = get_elementDescriptors(_this__u8e3s4);
    // Inline function 'kotlinx.serialization.internal.elementsHashCodeBy' call
    // Inline function 'kotlin.collections.fold' call
    var accumulator = 1;
    var tmp0_iterator = elementDescriptors.u();
    while (tmp0_iterator.v()) {
      var element = tmp0_iterator.w();
      // Inline function 'kotlinx.serialization.internal.elementsHashCodeBy.<anonymous>' call
      var hash = accumulator;
      var tmp = imul(31, hash);
      // Inline function 'kotlin.hashCode' call
      // Inline function 'kotlinx.serialization.internal.hashCodeImpl.<anonymous>' call
      var tmp0_safe_receiver = element.z18();
      var tmp1_elvis_lhs = tmp0_safe_receiver == null ? null : hashCode(tmp0_safe_receiver);
      accumulator = tmp + (tmp1_elvis_lhs == null ? 0 : tmp1_elvis_lhs) | 0;
    }
    var namesHash = accumulator;
    // Inline function 'kotlinx.serialization.internal.elementsHashCodeBy' call
    // Inline function 'kotlin.collections.fold' call
    var accumulator_0 = 1;
    var tmp0_iterator_0 = elementDescriptors.u();
    while (tmp0_iterator_0.v()) {
      var element_0 = tmp0_iterator_0.w();
      // Inline function 'kotlinx.serialization.internal.elementsHashCodeBy.<anonymous>' call
      var hash_0 = accumulator_0;
      var tmp_0 = imul(31, hash_0);
      // Inline function 'kotlin.hashCode' call
      // Inline function 'kotlinx.serialization.internal.hashCodeImpl.<anonymous>' call
      var tmp0_safe_receiver_0 = element_0.a19();
      var tmp1_elvis_lhs_0 = tmp0_safe_receiver_0 == null ? null : hashCode(tmp0_safe_receiver_0);
      accumulator_0 = tmp_0 + (tmp1_elvis_lhs_0 == null ? 0 : tmp1_elvis_lhs_0) | 0;
    }
    var kindHash = accumulator_0;
    result = imul(31, result) + namesHash | 0;
    result = imul(31, result) + kindHash | 0;
    return result;
  }
  function childSerializers$factory() {
    return getPropertyCallableRef('childSerializers', 1, KProperty1, function (receiver) {
      return _get_childSerializers__7vnyfa(receiver);
    }, null);
  }
  function typeParameterDescriptors$factory() {
    return getPropertyCallableRef('typeParameterDescriptors', 1, KProperty1, function (receiver) {
      return receiver.n1g();
    }, null);
  }
  function _hashCode$factory_0() {
    return getPropertyCallableRef('_hashCode', 1, KProperty1, function (receiver) {
      return _get__hashCode__tgwhef_0(receiver);
    }, null);
  }
  function get_EMPTY_SERIALIZER_ARRAY() {
    _init_properties_PluginHelperInterfaces_kt__xgvzfp();
    return EMPTY_SERIALIZER_ARRAY;
  }
  var EMPTY_SERIALIZER_ARRAY;
  function GeneratedSerializer() {
  }
  var properties_initialized_PluginHelperInterfaces_kt_ap8in1;
  function _init_properties_PluginHelperInterfaces_kt__xgvzfp() {
    if (!properties_initialized_PluginHelperInterfaces_kt_ap8in1) {
      properties_initialized_PluginHelperInterfaces_kt_ap8in1 = true;
      // Inline function 'kotlin.arrayOf' call
      // Inline function 'kotlin.js.unsafeCast' call
      // Inline function 'kotlin.js.asDynamic' call
      EMPTY_SERIALIZER_ARRAY = [];
    }
  }
  function CharArraySerializer_0() {
    CharArraySerializer_instance = this;
    PrimitiveArraySerializer.call(this, serializer_0(Companion_getInstance_1()));
  }
  protoOf(CharArraySerializer_0).b1h = function (_this__u8e3s4) {
    return _this__u8e3s4.length;
  };
  protoOf(CharArraySerializer_0).j1e = function (_this__u8e3s4) {
    return this.b1h((!(_this__u8e3s4 == null) ? isCharArray(_this__u8e3s4) : false) ? _this__u8e3s4 : THROW_CCE());
  };
  protoOf(CharArraySerializer_0).c1h = function (_this__u8e3s4) {
    return new CharArrayBuilder(_this__u8e3s4);
  };
  protoOf(CharArraySerializer_0).r1d = function (_this__u8e3s4) {
    return this.c1h((!(_this__u8e3s4 == null) ? isCharArray(_this__u8e3s4) : false) ? _this__u8e3s4 : THROW_CCE());
  };
  protoOf(CharArraySerializer_0).c1f = function () {
    return charArray(0);
  };
  protoOf(CharArraySerializer_0).d1h = function (decoder, index, builder, checkIndex) {
    builder.g1h(decoder.i1b(this.v1e_1, index));
  };
  protoOf(CharArraySerializer_0).c1e = function (decoder, index, builder, checkIndex) {
    return this.d1h(decoder, index, builder instanceof CharArrayBuilder ? builder : THROW_CCE(), checkIndex);
  };
  protoOf(CharArraySerializer_0).d1f = function (decoder, index, builder, checkIndex) {
    return this.d1h(decoder, index, builder instanceof CharArrayBuilder ? builder : THROW_CCE(), checkIndex);
  };
  protoOf(CharArraySerializer_0).h1h = function (encoder, content, size) {
    var inductionVariable = 0;
    if (inductionVariable < size)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        encoder.k1c(this.v1e_1, i, content[i]);
      }
       while (inductionVariable < size);
  };
  protoOf(CharArraySerializer_0).e1f = function (encoder, content, size) {
    return this.h1h(encoder, (!(content == null) ? isCharArray(content) : false) ? content : THROW_CCE(), size);
  };
  var CharArraySerializer_instance;
  function CharArraySerializer_getInstance() {
    if (CharArraySerializer_instance == null)
      new CharArraySerializer_0();
    return CharArraySerializer_instance;
  }
  function DoubleArraySerializer_0() {
    DoubleArraySerializer_instance = this;
    PrimitiveArraySerializer.call(this, serializer_1(DoubleCompanionObject_instance));
  }
  protoOf(DoubleArraySerializer_0).k1h = function (_this__u8e3s4) {
    return _this__u8e3s4.length;
  };
  protoOf(DoubleArraySerializer_0).j1e = function (_this__u8e3s4) {
    return this.k1h((!(_this__u8e3s4 == null) ? isDoubleArray(_this__u8e3s4) : false) ? _this__u8e3s4 : THROW_CCE());
  };
  protoOf(DoubleArraySerializer_0).l1h = function (_this__u8e3s4) {
    return new DoubleArrayBuilder(_this__u8e3s4);
  };
  protoOf(DoubleArraySerializer_0).r1d = function (_this__u8e3s4) {
    return this.l1h((!(_this__u8e3s4 == null) ? isDoubleArray(_this__u8e3s4) : false) ? _this__u8e3s4 : THROW_CCE());
  };
  protoOf(DoubleArraySerializer_0).c1f = function () {
    return new Float64Array(0);
  };
  protoOf(DoubleArraySerializer_0).m1h = function (decoder, index, builder, checkIndex) {
    builder.p1h(decoder.h1b(this.v1e_1, index));
  };
  protoOf(DoubleArraySerializer_0).c1e = function (decoder, index, builder, checkIndex) {
    return this.m1h(decoder, index, builder instanceof DoubleArrayBuilder ? builder : THROW_CCE(), checkIndex);
  };
  protoOf(DoubleArraySerializer_0).d1f = function (decoder, index, builder, checkIndex) {
    return this.m1h(decoder, index, builder instanceof DoubleArrayBuilder ? builder : THROW_CCE(), checkIndex);
  };
  protoOf(DoubleArraySerializer_0).q1h = function (encoder, content, size) {
    var inductionVariable = 0;
    if (inductionVariable < size)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        encoder.j1c(this.v1e_1, i, content[i]);
      }
       while (inductionVariable < size);
  };
  protoOf(DoubleArraySerializer_0).e1f = function (encoder, content, size) {
    return this.q1h(encoder, (!(content == null) ? isDoubleArray(content) : false) ? content : THROW_CCE(), size);
  };
  var DoubleArraySerializer_instance;
  function DoubleArraySerializer_getInstance() {
    if (DoubleArraySerializer_instance == null)
      new DoubleArraySerializer_0();
    return DoubleArraySerializer_instance;
  }
  function FloatArraySerializer_0() {
    FloatArraySerializer_instance = this;
    PrimitiveArraySerializer.call(this, serializer_2(FloatCompanionObject_instance));
  }
  protoOf(FloatArraySerializer_0).t1h = function (_this__u8e3s4) {
    return _this__u8e3s4.length;
  };
  protoOf(FloatArraySerializer_0).j1e = function (_this__u8e3s4) {
    return this.t1h((!(_this__u8e3s4 == null) ? isFloatArray(_this__u8e3s4) : false) ? _this__u8e3s4 : THROW_CCE());
  };
  protoOf(FloatArraySerializer_0).u1h = function (_this__u8e3s4) {
    return new FloatArrayBuilder(_this__u8e3s4);
  };
  protoOf(FloatArraySerializer_0).r1d = function (_this__u8e3s4) {
    return this.u1h((!(_this__u8e3s4 == null) ? isFloatArray(_this__u8e3s4) : false) ? _this__u8e3s4 : THROW_CCE());
  };
  protoOf(FloatArraySerializer_0).c1f = function () {
    return new Float32Array(0);
  };
  protoOf(FloatArraySerializer_0).v1h = function (decoder, index, builder, checkIndex) {
    builder.y1h(decoder.g1b(this.v1e_1, index));
  };
  protoOf(FloatArraySerializer_0).c1e = function (decoder, index, builder, checkIndex) {
    return this.v1h(decoder, index, builder instanceof FloatArrayBuilder ? builder : THROW_CCE(), checkIndex);
  };
  protoOf(FloatArraySerializer_0).d1f = function (decoder, index, builder, checkIndex) {
    return this.v1h(decoder, index, builder instanceof FloatArrayBuilder ? builder : THROW_CCE(), checkIndex);
  };
  protoOf(FloatArraySerializer_0).z1h = function (encoder, content, size) {
    var inductionVariable = 0;
    if (inductionVariable < size)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        encoder.i1c(this.v1e_1, i, content[i]);
      }
       while (inductionVariable < size);
  };
  protoOf(FloatArraySerializer_0).e1f = function (encoder, content, size) {
    return this.z1h(encoder, (!(content == null) ? isFloatArray(content) : false) ? content : THROW_CCE(), size);
  };
  var FloatArraySerializer_instance;
  function FloatArraySerializer_getInstance() {
    if (FloatArraySerializer_instance == null)
      new FloatArraySerializer_0();
    return FloatArraySerializer_instance;
  }
  function LongArraySerializer_0() {
    LongArraySerializer_instance = this;
    PrimitiveArraySerializer.call(this, serializer_3(Companion_getInstance_0()));
  }
  protoOf(LongArraySerializer_0).c1i = function (_this__u8e3s4) {
    return _this__u8e3s4.length;
  };
  protoOf(LongArraySerializer_0).j1e = function (_this__u8e3s4) {
    return this.c1i((!(_this__u8e3s4 == null) ? isLongArray(_this__u8e3s4) : false) ? _this__u8e3s4 : THROW_CCE());
  };
  protoOf(LongArraySerializer_0).d1i = function (_this__u8e3s4) {
    return new LongArrayBuilder(_this__u8e3s4);
  };
  protoOf(LongArraySerializer_0).r1d = function (_this__u8e3s4) {
    return this.d1i((!(_this__u8e3s4 == null) ? isLongArray(_this__u8e3s4) : false) ? _this__u8e3s4 : THROW_CCE());
  };
  protoOf(LongArraySerializer_0).c1f = function () {
    return longArray(0);
  };
  protoOf(LongArraySerializer_0).e1i = function (decoder, index, builder, checkIndex) {
    builder.h1i(decoder.f1b(this.v1e_1, index));
  };
  protoOf(LongArraySerializer_0).c1e = function (decoder, index, builder, checkIndex) {
    return this.e1i(decoder, index, builder instanceof LongArrayBuilder ? builder : THROW_CCE(), checkIndex);
  };
  protoOf(LongArraySerializer_0).d1f = function (decoder, index, builder, checkIndex) {
    return this.e1i(decoder, index, builder instanceof LongArrayBuilder ? builder : THROW_CCE(), checkIndex);
  };
  protoOf(LongArraySerializer_0).i1i = function (encoder, content, size) {
    var inductionVariable = 0;
    if (inductionVariable < size)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        encoder.h1c(this.v1e_1, i, content[i]);
      }
       while (inductionVariable < size);
  };
  protoOf(LongArraySerializer_0).e1f = function (encoder, content, size) {
    return this.i1i(encoder, (!(content == null) ? isLongArray(content) : false) ? content : THROW_CCE(), size);
  };
  var LongArraySerializer_instance;
  function LongArraySerializer_getInstance() {
    if (LongArraySerializer_instance == null)
      new LongArraySerializer_0();
    return LongArraySerializer_instance;
  }
  function ULongArraySerializer_0() {
    ULongArraySerializer_instance = this;
    PrimitiveArraySerializer.call(this, serializer_4(Companion_getInstance_2()));
  }
  protoOf(ULongArraySerializer_0).l1i = function (_this__u8e3s4) {
    return _ULongArray___get_size__impl__ju6dtr(_this__u8e3s4);
  };
  protoOf(ULongArraySerializer_0).j1e = function (_this__u8e3s4) {
    return this.l1i(_this__u8e3s4 instanceof ULongArray ? _this__u8e3s4.jh_1 : THROW_CCE());
  };
  protoOf(ULongArraySerializer_0).m1i = function (_this__u8e3s4) {
    return new ULongArrayBuilder(_this__u8e3s4);
  };
  protoOf(ULongArraySerializer_0).r1d = function (_this__u8e3s4) {
    return this.m1i(_this__u8e3s4 instanceof ULongArray ? _this__u8e3s4.jh_1 : THROW_CCE());
  };
  protoOf(ULongArraySerializer_0).n1i = function () {
    return _ULongArray___init__impl__twm1l3(0);
  };
  protoOf(ULongArraySerializer_0).c1f = function () {
    return new ULongArray(this.n1i());
  };
  protoOf(ULongArraySerializer_0).o1i = function (decoder, index, builder, checkIndex) {
    // Inline function 'kotlin.toULong' call
    var this_0 = decoder.j1b(this.v1e_1, index).r1a();
    var tmp$ret$0 = _ULong___init__impl__c78o9k(this_0);
    builder.r1i(tmp$ret$0);
  };
  protoOf(ULongArraySerializer_0).c1e = function (decoder, index, builder, checkIndex) {
    return this.o1i(decoder, index, builder instanceof ULongArrayBuilder ? builder : THROW_CCE(), checkIndex);
  };
  protoOf(ULongArraySerializer_0).d1f = function (decoder, index, builder, checkIndex) {
    return this.o1i(decoder, index, builder instanceof ULongArrayBuilder ? builder : THROW_CCE(), checkIndex);
  };
  protoOf(ULongArraySerializer_0).s1i = function (encoder, content, size) {
    var inductionVariable = 0;
    if (inductionVariable < size)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        var tmp = encoder.l1c(this.v1e_1, i);
        // Inline function 'kotlin.ULong.toLong' call
        var this_0 = ULongArray__get_impl_pr71q9(content, i);
        var tmp$ret$0 = _ULong___get_data__impl__fggpzb(this_0);
        tmp.x1b(tmp$ret$0);
      }
       while (inductionVariable < size);
  };
  protoOf(ULongArraySerializer_0).e1f = function (encoder, content, size) {
    return this.s1i(encoder, content instanceof ULongArray ? content.jh_1 : THROW_CCE(), size);
  };
  var ULongArraySerializer_instance;
  function ULongArraySerializer_getInstance() {
    if (ULongArraySerializer_instance == null)
      new ULongArraySerializer_0();
    return ULongArraySerializer_instance;
  }
  function IntArraySerializer_0() {
    IntArraySerializer_instance = this;
    PrimitiveArraySerializer.call(this, serializer_5(IntCompanionObject_instance));
  }
  protoOf(IntArraySerializer_0).v1i = function (_this__u8e3s4) {
    return _this__u8e3s4.length;
  };
  protoOf(IntArraySerializer_0).j1e = function (_this__u8e3s4) {
    return this.v1i((!(_this__u8e3s4 == null) ? isIntArray(_this__u8e3s4) : false) ? _this__u8e3s4 : THROW_CCE());
  };
  protoOf(IntArraySerializer_0).w1i = function (_this__u8e3s4) {
    return new IntArrayBuilder(_this__u8e3s4);
  };
  protoOf(IntArraySerializer_0).r1d = function (_this__u8e3s4) {
    return this.w1i((!(_this__u8e3s4 == null) ? isIntArray(_this__u8e3s4) : false) ? _this__u8e3s4 : THROW_CCE());
  };
  protoOf(IntArraySerializer_0).c1f = function () {
    return new Int32Array(0);
  };
  protoOf(IntArraySerializer_0).x1i = function (decoder, index, builder, checkIndex) {
    builder.a1j(decoder.e1b(this.v1e_1, index));
  };
  protoOf(IntArraySerializer_0).c1e = function (decoder, index, builder, checkIndex) {
    return this.x1i(decoder, index, builder instanceof IntArrayBuilder ? builder : THROW_CCE(), checkIndex);
  };
  protoOf(IntArraySerializer_0).d1f = function (decoder, index, builder, checkIndex) {
    return this.x1i(decoder, index, builder instanceof IntArrayBuilder ? builder : THROW_CCE(), checkIndex);
  };
  protoOf(IntArraySerializer_0).b1j = function (encoder, content, size) {
    var inductionVariable = 0;
    if (inductionVariable < size)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        encoder.g1c(this.v1e_1, i, content[i]);
      }
       while (inductionVariable < size);
  };
  protoOf(IntArraySerializer_0).e1f = function (encoder, content, size) {
    return this.b1j(encoder, (!(content == null) ? isIntArray(content) : false) ? content : THROW_CCE(), size);
  };
  var IntArraySerializer_instance;
  function IntArraySerializer_getInstance() {
    if (IntArraySerializer_instance == null)
      new IntArraySerializer_0();
    return IntArraySerializer_instance;
  }
  function UIntArraySerializer_0() {
    UIntArraySerializer_instance = this;
    PrimitiveArraySerializer.call(this, serializer_6(Companion_getInstance_3()));
  }
  protoOf(UIntArraySerializer_0).e1j = function (_this__u8e3s4) {
    return _UIntArray___get_size__impl__r6l8ci(_this__u8e3s4);
  };
  protoOf(UIntArraySerializer_0).j1e = function (_this__u8e3s4) {
    return this.e1j(_this__u8e3s4 instanceof UIntArray ? _this__u8e3s4.yg_1 : THROW_CCE());
  };
  protoOf(UIntArraySerializer_0).f1j = function (_this__u8e3s4) {
    return new UIntArrayBuilder(_this__u8e3s4);
  };
  protoOf(UIntArraySerializer_0).r1d = function (_this__u8e3s4) {
    return this.f1j(_this__u8e3s4 instanceof UIntArray ? _this__u8e3s4.yg_1 : THROW_CCE());
  };
  protoOf(UIntArraySerializer_0).g1j = function () {
    return _UIntArray___init__impl__ghjpc6(0);
  };
  protoOf(UIntArraySerializer_0).c1f = function () {
    return new UIntArray(this.g1j());
  };
  protoOf(UIntArraySerializer_0).h1j = function (decoder, index, builder, checkIndex) {
    // Inline function 'kotlin.toUInt' call
    var this_0 = decoder.j1b(this.v1e_1, index).q1a();
    var tmp$ret$0 = _UInt___init__impl__l7qpdl(this_0);
    builder.k1j(tmp$ret$0);
  };
  protoOf(UIntArraySerializer_0).c1e = function (decoder, index, builder, checkIndex) {
    return this.h1j(decoder, index, builder instanceof UIntArrayBuilder ? builder : THROW_CCE(), checkIndex);
  };
  protoOf(UIntArraySerializer_0).d1f = function (decoder, index, builder, checkIndex) {
    return this.h1j(decoder, index, builder instanceof UIntArrayBuilder ? builder : THROW_CCE(), checkIndex);
  };
  protoOf(UIntArraySerializer_0).l1j = function (encoder, content, size) {
    var inductionVariable = 0;
    if (inductionVariable < size)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        var tmp = encoder.l1c(this.v1e_1, i);
        // Inline function 'kotlin.UInt.toInt' call
        var this_0 = UIntArray__get_impl_gp5kza(content, i);
        var tmp$ret$0 = _UInt___get_data__impl__f0vqqw(this_0);
        tmp.w1b(tmp$ret$0);
      }
       while (inductionVariable < size);
  };
  protoOf(UIntArraySerializer_0).e1f = function (encoder, content, size) {
    return this.l1j(encoder, content instanceof UIntArray ? content.yg_1 : THROW_CCE(), size);
  };
  var UIntArraySerializer_instance;
  function UIntArraySerializer_getInstance() {
    if (UIntArraySerializer_instance == null)
      new UIntArraySerializer_0();
    return UIntArraySerializer_instance;
  }
  function ShortArraySerializer_0() {
    ShortArraySerializer_instance = this;
    PrimitiveArraySerializer.call(this, serializer_7(ShortCompanionObject_instance));
  }
  protoOf(ShortArraySerializer_0).o1j = function (_this__u8e3s4) {
    return _this__u8e3s4.length;
  };
  protoOf(ShortArraySerializer_0).j1e = function (_this__u8e3s4) {
    return this.o1j((!(_this__u8e3s4 == null) ? isShortArray(_this__u8e3s4) : false) ? _this__u8e3s4 : THROW_CCE());
  };
  protoOf(ShortArraySerializer_0).p1j = function (_this__u8e3s4) {
    return new ShortArrayBuilder(_this__u8e3s4);
  };
  protoOf(ShortArraySerializer_0).r1d = function (_this__u8e3s4) {
    return this.p1j((!(_this__u8e3s4 == null) ? isShortArray(_this__u8e3s4) : false) ? _this__u8e3s4 : THROW_CCE());
  };
  protoOf(ShortArraySerializer_0).c1f = function () {
    return new Int16Array(0);
  };
  protoOf(ShortArraySerializer_0).q1j = function (decoder, index, builder, checkIndex) {
    builder.t1j(decoder.d1b(this.v1e_1, index));
  };
  protoOf(ShortArraySerializer_0).c1e = function (decoder, index, builder, checkIndex) {
    return this.q1j(decoder, index, builder instanceof ShortArrayBuilder ? builder : THROW_CCE(), checkIndex);
  };
  protoOf(ShortArraySerializer_0).d1f = function (decoder, index, builder, checkIndex) {
    return this.q1j(decoder, index, builder instanceof ShortArrayBuilder ? builder : THROW_CCE(), checkIndex);
  };
  protoOf(ShortArraySerializer_0).u1j = function (encoder, content, size) {
    var inductionVariable = 0;
    if (inductionVariable < size)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        encoder.f1c(this.v1e_1, i, content[i]);
      }
       while (inductionVariable < size);
  };
  protoOf(ShortArraySerializer_0).e1f = function (encoder, content, size) {
    return this.u1j(encoder, (!(content == null) ? isShortArray(content) : false) ? content : THROW_CCE(), size);
  };
  var ShortArraySerializer_instance;
  function ShortArraySerializer_getInstance() {
    if (ShortArraySerializer_instance == null)
      new ShortArraySerializer_0();
    return ShortArraySerializer_instance;
  }
  function UShortArraySerializer_0() {
    UShortArraySerializer_instance = this;
    PrimitiveArraySerializer.call(this, serializer_8(Companion_getInstance_4()));
  }
  protoOf(UShortArraySerializer_0).x1j = function (_this__u8e3s4) {
    return _UShortArray___get_size__impl__jqto1b(_this__u8e3s4);
  };
  protoOf(UShortArraySerializer_0).j1e = function (_this__u8e3s4) {
    return this.x1j(_this__u8e3s4 instanceof UShortArray ? _this__u8e3s4.uh_1 : THROW_CCE());
  };
  protoOf(UShortArraySerializer_0).y1j = function (_this__u8e3s4) {
    return new UShortArrayBuilder(_this__u8e3s4);
  };
  protoOf(UShortArraySerializer_0).r1d = function (_this__u8e3s4) {
    return this.y1j(_this__u8e3s4 instanceof UShortArray ? _this__u8e3s4.uh_1 : THROW_CCE());
  };
  protoOf(UShortArraySerializer_0).z1j = function () {
    return _UShortArray___init__impl__9b26ef(0);
  };
  protoOf(UShortArraySerializer_0).c1f = function () {
    return new UShortArray(this.z1j());
  };
  protoOf(UShortArraySerializer_0).a1k = function (decoder, index, builder, checkIndex) {
    // Inline function 'kotlin.toUShort' call
    var this_0 = decoder.j1b(this.v1e_1, index).p1a();
    var tmp$ret$0 = _UShort___init__impl__jigrne(this_0);
    builder.d1k(tmp$ret$0);
  };
  protoOf(UShortArraySerializer_0).c1e = function (decoder, index, builder, checkIndex) {
    return this.a1k(decoder, index, builder instanceof UShortArrayBuilder ? builder : THROW_CCE(), checkIndex);
  };
  protoOf(UShortArraySerializer_0).d1f = function (decoder, index, builder, checkIndex) {
    return this.a1k(decoder, index, builder instanceof UShortArrayBuilder ? builder : THROW_CCE(), checkIndex);
  };
  protoOf(UShortArraySerializer_0).e1k = function (encoder, content, size) {
    var inductionVariable = 0;
    if (inductionVariable < size)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        var tmp = encoder.l1c(this.v1e_1, i);
        // Inline function 'kotlin.UShort.toShort' call
        var this_0 = UShortArray__get_impl_fnbhmx(content, i);
        var tmp$ret$0 = _UShort___get_data__impl__g0245(this_0);
        tmp.v1b(tmp$ret$0);
      }
       while (inductionVariable < size);
  };
  protoOf(UShortArraySerializer_0).e1f = function (encoder, content, size) {
    return this.e1k(encoder, content instanceof UShortArray ? content.uh_1 : THROW_CCE(), size);
  };
  var UShortArraySerializer_instance;
  function UShortArraySerializer_getInstance() {
    if (UShortArraySerializer_instance == null)
      new UShortArraySerializer_0();
    return UShortArraySerializer_instance;
  }
  function ByteArraySerializer_0() {
    ByteArraySerializer_instance = this;
    PrimitiveArraySerializer.call(this, serializer_9(ByteCompanionObject_instance));
  }
  protoOf(ByteArraySerializer_0).h1k = function (_this__u8e3s4) {
    return _this__u8e3s4.length;
  };
  protoOf(ByteArraySerializer_0).j1e = function (_this__u8e3s4) {
    return this.h1k((!(_this__u8e3s4 == null) ? isByteArray(_this__u8e3s4) : false) ? _this__u8e3s4 : THROW_CCE());
  };
  protoOf(ByteArraySerializer_0).i1k = function (_this__u8e3s4) {
    return new ByteArrayBuilder(_this__u8e3s4);
  };
  protoOf(ByteArraySerializer_0).r1d = function (_this__u8e3s4) {
    return this.i1k((!(_this__u8e3s4 == null) ? isByteArray(_this__u8e3s4) : false) ? _this__u8e3s4 : THROW_CCE());
  };
  protoOf(ByteArraySerializer_0).c1f = function () {
    return new Int8Array(0);
  };
  protoOf(ByteArraySerializer_0).j1k = function (decoder, index, builder, checkIndex) {
    builder.m1k(decoder.c1b(this.v1e_1, index));
  };
  protoOf(ByteArraySerializer_0).c1e = function (decoder, index, builder, checkIndex) {
    return this.j1k(decoder, index, builder instanceof ByteArrayBuilder ? builder : THROW_CCE(), checkIndex);
  };
  protoOf(ByteArraySerializer_0).d1f = function (decoder, index, builder, checkIndex) {
    return this.j1k(decoder, index, builder instanceof ByteArrayBuilder ? builder : THROW_CCE(), checkIndex);
  };
  protoOf(ByteArraySerializer_0).n1k = function (encoder, content, size) {
    var inductionVariable = 0;
    if (inductionVariable < size)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        encoder.e1c(this.v1e_1, i, content[i]);
      }
       while (inductionVariable < size);
  };
  protoOf(ByteArraySerializer_0).e1f = function (encoder, content, size) {
    return this.n1k(encoder, (!(content == null) ? isByteArray(content) : false) ? content : THROW_CCE(), size);
  };
  var ByteArraySerializer_instance;
  function ByteArraySerializer_getInstance() {
    if (ByteArraySerializer_instance == null)
      new ByteArraySerializer_0();
    return ByteArraySerializer_instance;
  }
  function UByteArraySerializer_0() {
    UByteArraySerializer_instance = this;
    PrimitiveArraySerializer.call(this, serializer_10(Companion_getInstance_5()));
  }
  protoOf(UByteArraySerializer_0).q1k = function (_this__u8e3s4) {
    return _UByteArray___get_size__impl__h6pkdv(_this__u8e3s4);
  };
  protoOf(UByteArraySerializer_0).j1e = function (_this__u8e3s4) {
    return this.q1k(_this__u8e3s4 instanceof UByteArray ? _this__u8e3s4.ng_1 : THROW_CCE());
  };
  protoOf(UByteArraySerializer_0).r1k = function (_this__u8e3s4) {
    return new UByteArrayBuilder(_this__u8e3s4);
  };
  protoOf(UByteArraySerializer_0).r1d = function (_this__u8e3s4) {
    return this.r1k(_this__u8e3s4 instanceof UByteArray ? _this__u8e3s4.ng_1 : THROW_CCE());
  };
  protoOf(UByteArraySerializer_0).s1k = function () {
    return _UByteArray___init__impl__ip4y9n(0);
  };
  protoOf(UByteArraySerializer_0).c1f = function () {
    return new UByteArray(this.s1k());
  };
  protoOf(UByteArraySerializer_0).t1k = function (decoder, index, builder, checkIndex) {
    // Inline function 'kotlin.toUByte' call
    var this_0 = decoder.j1b(this.v1e_1, index).o1a();
    var tmp$ret$0 = _UByte___init__impl__g9hnc4(this_0);
    builder.w1k(tmp$ret$0);
  };
  protoOf(UByteArraySerializer_0).c1e = function (decoder, index, builder, checkIndex) {
    return this.t1k(decoder, index, builder instanceof UByteArrayBuilder ? builder : THROW_CCE(), checkIndex);
  };
  protoOf(UByteArraySerializer_0).d1f = function (decoder, index, builder, checkIndex) {
    return this.t1k(decoder, index, builder instanceof UByteArrayBuilder ? builder : THROW_CCE(), checkIndex);
  };
  protoOf(UByteArraySerializer_0).x1k = function (encoder, content, size) {
    var inductionVariable = 0;
    if (inductionVariable < size)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        var tmp = encoder.l1c(this.v1e_1, i);
        // Inline function 'kotlin.UByte.toByte' call
        var this_0 = UByteArray__get_impl_t5f3hv(content, i);
        var tmp$ret$0 = _UByte___get_data__impl__jof9qr(this_0);
        tmp.u1b(tmp$ret$0);
      }
       while (inductionVariable < size);
  };
  protoOf(UByteArraySerializer_0).e1f = function (encoder, content, size) {
    return this.x1k(encoder, content instanceof UByteArray ? content.ng_1 : THROW_CCE(), size);
  };
  var UByteArraySerializer_instance;
  function UByteArraySerializer_getInstance() {
    if (UByteArraySerializer_instance == null)
      new UByteArraySerializer_0();
    return UByteArraySerializer_instance;
  }
  function BooleanArraySerializer_0() {
    BooleanArraySerializer_instance = this;
    PrimitiveArraySerializer.call(this, serializer_11(BooleanCompanionObject_instance));
  }
  protoOf(BooleanArraySerializer_0).a1l = function (_this__u8e3s4) {
    return _this__u8e3s4.length;
  };
  protoOf(BooleanArraySerializer_0).j1e = function (_this__u8e3s4) {
    return this.a1l((!(_this__u8e3s4 == null) ? isBooleanArray(_this__u8e3s4) : false) ? _this__u8e3s4 : THROW_CCE());
  };
  protoOf(BooleanArraySerializer_0).b1l = function (_this__u8e3s4) {
    return new BooleanArrayBuilder(_this__u8e3s4);
  };
  protoOf(BooleanArraySerializer_0).r1d = function (_this__u8e3s4) {
    return this.b1l((!(_this__u8e3s4 == null) ? isBooleanArray(_this__u8e3s4) : false) ? _this__u8e3s4 : THROW_CCE());
  };
  protoOf(BooleanArraySerializer_0).c1f = function () {
    return booleanArray(0);
  };
  protoOf(BooleanArraySerializer_0).c1l = function (decoder, index, builder, checkIndex) {
    builder.f1l(decoder.b1b(this.v1e_1, index));
  };
  protoOf(BooleanArraySerializer_0).c1e = function (decoder, index, builder, checkIndex) {
    return this.c1l(decoder, index, builder instanceof BooleanArrayBuilder ? builder : THROW_CCE(), checkIndex);
  };
  protoOf(BooleanArraySerializer_0).d1f = function (decoder, index, builder, checkIndex) {
    return this.c1l(decoder, index, builder instanceof BooleanArrayBuilder ? builder : THROW_CCE(), checkIndex);
  };
  protoOf(BooleanArraySerializer_0).g1l = function (encoder, content, size) {
    var inductionVariable = 0;
    if (inductionVariable < size)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        encoder.d1c(this.v1e_1, i, content[i]);
      }
       while (inductionVariable < size);
  };
  protoOf(BooleanArraySerializer_0).e1f = function (encoder, content, size) {
    return this.g1l(encoder, (!(content == null) ? isBooleanArray(content) : false) ? content : THROW_CCE(), size);
  };
  var BooleanArraySerializer_instance;
  function BooleanArraySerializer_getInstance() {
    if (BooleanArraySerializer_instance == null)
      new BooleanArraySerializer_0();
    return BooleanArraySerializer_instance;
  }
  function CharArrayBuilder(bufferWithData) {
    PrimitiveArrayBuilder.call(this);
    this.e1h_1 = bufferWithData;
    this.f1h_1 = bufferWithData.length;
    this.v2(10);
  }
  protoOf(CharArrayBuilder).x1e = function () {
    return this.f1h_1;
  };
  protoOf(CharArrayBuilder).v2 = function (requiredCapacity) {
    if (this.e1h_1.length < requiredCapacity)
      this.e1h_1 = copyOf(this.e1h_1, coerceAtLeast(requiredCapacity, imul(this.e1h_1.length, 2)));
  };
  protoOf(CharArrayBuilder).g1h = function (c) {
    this.g1f();
    var tmp = this.e1h_1;
    var tmp1 = this.f1h_1;
    this.f1h_1 = tmp1 + 1 | 0;
    tmp[tmp1] = c;
  };
  protoOf(CharArrayBuilder).u2 = function () {
    return copyOf(this.e1h_1, this.f1h_1);
  };
  function DoubleArrayBuilder(bufferWithData) {
    PrimitiveArrayBuilder.call(this);
    this.n1h_1 = bufferWithData;
    this.o1h_1 = bufferWithData.length;
    this.v2(10);
  }
  protoOf(DoubleArrayBuilder).x1e = function () {
    return this.o1h_1;
  };
  protoOf(DoubleArrayBuilder).v2 = function (requiredCapacity) {
    if (this.n1h_1.length < requiredCapacity)
      this.n1h_1 = copyOf_0(this.n1h_1, coerceAtLeast(requiredCapacity, imul(this.n1h_1.length, 2)));
  };
  protoOf(DoubleArrayBuilder).p1h = function (c) {
    this.g1f();
    var tmp = this.n1h_1;
    var tmp1 = this.o1h_1;
    this.o1h_1 = tmp1 + 1 | 0;
    tmp[tmp1] = c;
  };
  protoOf(DoubleArrayBuilder).u2 = function () {
    return copyOf_0(this.n1h_1, this.o1h_1);
  };
  function FloatArrayBuilder(bufferWithData) {
    PrimitiveArrayBuilder.call(this);
    this.w1h_1 = bufferWithData;
    this.x1h_1 = bufferWithData.length;
    this.v2(10);
  }
  protoOf(FloatArrayBuilder).x1e = function () {
    return this.x1h_1;
  };
  protoOf(FloatArrayBuilder).v2 = function (requiredCapacity) {
    if (this.w1h_1.length < requiredCapacity)
      this.w1h_1 = copyOf_1(this.w1h_1, coerceAtLeast(requiredCapacity, imul(this.w1h_1.length, 2)));
  };
  protoOf(FloatArrayBuilder).y1h = function (c) {
    this.g1f();
    var tmp = this.w1h_1;
    var tmp1 = this.x1h_1;
    this.x1h_1 = tmp1 + 1 | 0;
    tmp[tmp1] = c;
  };
  protoOf(FloatArrayBuilder).u2 = function () {
    return copyOf_1(this.w1h_1, this.x1h_1);
  };
  function LongArrayBuilder(bufferWithData) {
    PrimitiveArrayBuilder.call(this);
    this.f1i_1 = bufferWithData;
    this.g1i_1 = bufferWithData.length;
    this.v2(10);
  }
  protoOf(LongArrayBuilder).x1e = function () {
    return this.g1i_1;
  };
  protoOf(LongArrayBuilder).v2 = function (requiredCapacity) {
    if (this.f1i_1.length < requiredCapacity)
      this.f1i_1 = copyOf_2(this.f1i_1, coerceAtLeast(requiredCapacity, imul(this.f1i_1.length, 2)));
  };
  protoOf(LongArrayBuilder).h1i = function (c) {
    this.g1f();
    var tmp = this.f1i_1;
    var tmp1 = this.g1i_1;
    this.g1i_1 = tmp1 + 1 | 0;
    tmp[tmp1] = c;
  };
  protoOf(LongArrayBuilder).u2 = function () {
    return copyOf_2(this.f1i_1, this.g1i_1);
  };
  function ULongArrayBuilder(bufferWithData) {
    PrimitiveArrayBuilder.call(this);
    this.p1i_1 = bufferWithData;
    this.q1i_1 = _ULongArray___get_size__impl__ju6dtr(bufferWithData);
    this.v2(10);
  }
  protoOf(ULongArrayBuilder).x1e = function () {
    return this.q1i_1;
  };
  protoOf(ULongArrayBuilder).v2 = function (requiredCapacity) {
    if (_ULongArray___get_size__impl__ju6dtr(this.p1i_1) < requiredCapacity) {
      var tmp = this;
      // Inline function 'kotlin.collections.copyOf' call
      var this_0 = this.p1i_1;
      var newSize = coerceAtLeast(requiredCapacity, imul(_ULongArray___get_size__impl__ju6dtr(this.p1i_1), 2));
      tmp.p1i_1 = _ULongArray___init__impl__twm1l3_0(copyOf_2(_ULongArray___get_storage__impl__28e64j(this_0), newSize));
    }
  };
  protoOf(ULongArrayBuilder).r1i = function (c) {
    this.g1f();
    var tmp = this.p1i_1;
    var tmp1 = this.q1i_1;
    this.q1i_1 = tmp1 + 1 | 0;
    ULongArray__set_impl_z19mvh(tmp, tmp1, c);
  };
  protoOf(ULongArrayBuilder).h1l = function () {
    // Inline function 'kotlin.collections.copyOf' call
    var this_0 = this.p1i_1;
    var newSize = this.q1i_1;
    return _ULongArray___init__impl__twm1l3_0(copyOf_2(_ULongArray___get_storage__impl__28e64j(this_0), newSize));
  };
  protoOf(ULongArrayBuilder).u2 = function () {
    return new ULongArray(this.h1l());
  };
  function IntArrayBuilder(bufferWithData) {
    PrimitiveArrayBuilder.call(this);
    this.y1i_1 = bufferWithData;
    this.z1i_1 = bufferWithData.length;
    this.v2(10);
  }
  protoOf(IntArrayBuilder).x1e = function () {
    return this.z1i_1;
  };
  protoOf(IntArrayBuilder).v2 = function (requiredCapacity) {
    if (this.y1i_1.length < requiredCapacity)
      this.y1i_1 = copyOf_3(this.y1i_1, coerceAtLeast(requiredCapacity, imul(this.y1i_1.length, 2)));
  };
  protoOf(IntArrayBuilder).a1j = function (c) {
    this.g1f();
    var tmp = this.y1i_1;
    var tmp1 = this.z1i_1;
    this.z1i_1 = tmp1 + 1 | 0;
    tmp[tmp1] = c;
  };
  protoOf(IntArrayBuilder).u2 = function () {
    return copyOf_3(this.y1i_1, this.z1i_1);
  };
  function UIntArrayBuilder(bufferWithData) {
    PrimitiveArrayBuilder.call(this);
    this.i1j_1 = bufferWithData;
    this.j1j_1 = _UIntArray___get_size__impl__r6l8ci(bufferWithData);
    this.v2(10);
  }
  protoOf(UIntArrayBuilder).x1e = function () {
    return this.j1j_1;
  };
  protoOf(UIntArrayBuilder).v2 = function (requiredCapacity) {
    if (_UIntArray___get_size__impl__r6l8ci(this.i1j_1) < requiredCapacity) {
      var tmp = this;
      // Inline function 'kotlin.collections.copyOf' call
      var this_0 = this.i1j_1;
      var newSize = coerceAtLeast(requiredCapacity, imul(_UIntArray___get_size__impl__r6l8ci(this.i1j_1), 2));
      tmp.i1j_1 = _UIntArray___init__impl__ghjpc6_0(copyOf_3(_UIntArray___get_storage__impl__92a0v0(this_0), newSize));
    }
  };
  protoOf(UIntArrayBuilder).k1j = function (c) {
    this.g1f();
    var tmp = this.i1j_1;
    var tmp1 = this.j1j_1;
    this.j1j_1 = tmp1 + 1 | 0;
    UIntArray__set_impl_7f2zu2(tmp, tmp1, c);
  };
  protoOf(UIntArrayBuilder).i1l = function () {
    // Inline function 'kotlin.collections.copyOf' call
    var this_0 = this.i1j_1;
    var newSize = this.j1j_1;
    return _UIntArray___init__impl__ghjpc6_0(copyOf_3(_UIntArray___get_storage__impl__92a0v0(this_0), newSize));
  };
  protoOf(UIntArrayBuilder).u2 = function () {
    return new UIntArray(this.i1l());
  };
  function ShortArrayBuilder(bufferWithData) {
    PrimitiveArrayBuilder.call(this);
    this.r1j_1 = bufferWithData;
    this.s1j_1 = bufferWithData.length;
    this.v2(10);
  }
  protoOf(ShortArrayBuilder).x1e = function () {
    return this.s1j_1;
  };
  protoOf(ShortArrayBuilder).v2 = function (requiredCapacity) {
    if (this.r1j_1.length < requiredCapacity)
      this.r1j_1 = copyOf_4(this.r1j_1, coerceAtLeast(requiredCapacity, imul(this.r1j_1.length, 2)));
  };
  protoOf(ShortArrayBuilder).t1j = function (c) {
    this.g1f();
    var tmp = this.r1j_1;
    var tmp1 = this.s1j_1;
    this.s1j_1 = tmp1 + 1 | 0;
    tmp[tmp1] = c;
  };
  protoOf(ShortArrayBuilder).u2 = function () {
    return copyOf_4(this.r1j_1, this.s1j_1);
  };
  function UShortArrayBuilder(bufferWithData) {
    PrimitiveArrayBuilder.call(this);
    this.b1k_1 = bufferWithData;
    this.c1k_1 = _UShortArray___get_size__impl__jqto1b(bufferWithData);
    this.v2(10);
  }
  protoOf(UShortArrayBuilder).x1e = function () {
    return this.c1k_1;
  };
  protoOf(UShortArrayBuilder).v2 = function (requiredCapacity) {
    if (_UShortArray___get_size__impl__jqto1b(this.b1k_1) < requiredCapacity) {
      var tmp = this;
      // Inline function 'kotlin.collections.copyOf' call
      var this_0 = this.b1k_1;
      var newSize = coerceAtLeast(requiredCapacity, imul(_UShortArray___get_size__impl__jqto1b(this.b1k_1), 2));
      tmp.b1k_1 = _UShortArray___init__impl__9b26ef_0(copyOf_4(_UShortArray___get_storage__impl__t2jpv5(this_0), newSize));
    }
  };
  protoOf(UShortArrayBuilder).d1k = function (c) {
    this.g1f();
    var tmp = this.b1k_1;
    var tmp1 = this.c1k_1;
    this.c1k_1 = tmp1 + 1 | 0;
    UShortArray__set_impl_6d8whp(tmp, tmp1, c);
  };
  protoOf(UShortArrayBuilder).j1l = function () {
    // Inline function 'kotlin.collections.copyOf' call
    var this_0 = this.b1k_1;
    var newSize = this.c1k_1;
    return _UShortArray___init__impl__9b26ef_0(copyOf_4(_UShortArray___get_storage__impl__t2jpv5(this_0), newSize));
  };
  protoOf(UShortArrayBuilder).u2 = function () {
    return new UShortArray(this.j1l());
  };
  function ByteArrayBuilder(bufferWithData) {
    PrimitiveArrayBuilder.call(this);
    this.k1k_1 = bufferWithData;
    this.l1k_1 = bufferWithData.length;
    this.v2(10);
  }
  protoOf(ByteArrayBuilder).x1e = function () {
    return this.l1k_1;
  };
  protoOf(ByteArrayBuilder).v2 = function (requiredCapacity) {
    if (this.k1k_1.length < requiredCapacity)
      this.k1k_1 = copyOf_5(this.k1k_1, coerceAtLeast(requiredCapacity, imul(this.k1k_1.length, 2)));
  };
  protoOf(ByteArrayBuilder).m1k = function (c) {
    this.g1f();
    var tmp = this.k1k_1;
    var tmp1 = this.l1k_1;
    this.l1k_1 = tmp1 + 1 | 0;
    tmp[tmp1] = c;
  };
  protoOf(ByteArrayBuilder).u2 = function () {
    return copyOf_5(this.k1k_1, this.l1k_1);
  };
  function UByteArrayBuilder(bufferWithData) {
    PrimitiveArrayBuilder.call(this);
    this.u1k_1 = bufferWithData;
    this.v1k_1 = _UByteArray___get_size__impl__h6pkdv(bufferWithData);
    this.v2(10);
  }
  protoOf(UByteArrayBuilder).x1e = function () {
    return this.v1k_1;
  };
  protoOf(UByteArrayBuilder).v2 = function (requiredCapacity) {
    if (_UByteArray___get_size__impl__h6pkdv(this.u1k_1) < requiredCapacity) {
      var tmp = this;
      // Inline function 'kotlin.collections.copyOf' call
      var this_0 = this.u1k_1;
      var newSize = coerceAtLeast(requiredCapacity, imul(_UByteArray___get_size__impl__h6pkdv(this.u1k_1), 2));
      tmp.u1k_1 = _UByteArray___init__impl__ip4y9n_0(copyOf_5(_UByteArray___get_storage__impl__d4kctt(this_0), newSize));
    }
  };
  protoOf(UByteArrayBuilder).w1k = function (c) {
    this.g1f();
    var tmp = this.u1k_1;
    var tmp1 = this.v1k_1;
    this.v1k_1 = tmp1 + 1 | 0;
    UByteArray__set_impl_jvcicn(tmp, tmp1, c);
  };
  protoOf(UByteArrayBuilder).k1l = function () {
    // Inline function 'kotlin.collections.copyOf' call
    var this_0 = this.u1k_1;
    var newSize = this.v1k_1;
    return _UByteArray___init__impl__ip4y9n_0(copyOf_5(_UByteArray___get_storage__impl__d4kctt(this_0), newSize));
  };
  protoOf(UByteArrayBuilder).u2 = function () {
    return new UByteArray(this.k1l());
  };
  function BooleanArrayBuilder(bufferWithData) {
    PrimitiveArrayBuilder.call(this);
    this.d1l_1 = bufferWithData;
    this.e1l_1 = bufferWithData.length;
    this.v2(10);
  }
  protoOf(BooleanArrayBuilder).x1e = function () {
    return this.e1l_1;
  };
  protoOf(BooleanArrayBuilder).v2 = function (requiredCapacity) {
    if (this.d1l_1.length < requiredCapacity)
      this.d1l_1 = copyOf_6(this.d1l_1, coerceAtLeast(requiredCapacity, imul(this.d1l_1.length, 2)));
  };
  protoOf(BooleanArrayBuilder).f1l = function (c) {
    this.g1f();
    var tmp = this.d1l_1;
    var tmp1 = this.e1l_1;
    this.e1l_1 = tmp1 + 1 | 0;
    tmp[tmp1] = c;
  };
  protoOf(BooleanArrayBuilder).u2 = function () {
    return copyOf_6(this.d1l_1, this.e1l_1);
  };
  function get_BUILTIN_SERIALIZERS() {
    _init_properties_Primitives_kt__k0eto4();
    return BUILTIN_SERIALIZERS;
  }
  var BUILTIN_SERIALIZERS;
  function StringSerializer() {
    StringSerializer_instance = this;
    this.l1l_1 = new PrimitiveSerialDescriptor_0('kotlin.String', STRING_getInstance());
  }
  protoOf(StringSerializer).p18 = function () {
    return this.l1l_1;
  };
  protoOf(StringSerializer).m1l = function (encoder, value) {
    return encoder.b1c(value);
  };
  protoOf(StringSerializer).q18 = function (encoder, value) {
    return this.m1l(encoder, (!(value == null) ? typeof value === 'string' : false) ? value : THROW_CCE());
  };
  protoOf(StringSerializer).r18 = function (decoder) {
    return decoder.v1a();
  };
  var StringSerializer_instance;
  function StringSerializer_getInstance() {
    if (StringSerializer_instance == null)
      new StringSerializer();
    return StringSerializer_instance;
  }
  function CharSerializer() {
    CharSerializer_instance = this;
    this.n1l_1 = new PrimitiveSerialDescriptor_0('kotlin.Char', CHAR_getInstance());
  }
  protoOf(CharSerializer).p18 = function () {
    return this.n1l_1;
  };
  protoOf(CharSerializer).o1l = function (encoder, value) {
    return encoder.a1c(value);
  };
  protoOf(CharSerializer).q18 = function (encoder, value) {
    return this.o1l(encoder, value instanceof Char ? value.s8_1 : THROW_CCE());
  };
  protoOf(CharSerializer).p1l = function (decoder) {
    return decoder.u1a();
  };
  protoOf(CharSerializer).r18 = function (decoder) {
    return new Char(this.p1l(decoder));
  };
  var CharSerializer_instance;
  function CharSerializer_getInstance() {
    if (CharSerializer_instance == null)
      new CharSerializer();
    return CharSerializer_instance;
  }
  function DoubleSerializer() {
    DoubleSerializer_instance = this;
    this.q1l_1 = new PrimitiveSerialDescriptor_0('kotlin.Double', DOUBLE_getInstance());
  }
  protoOf(DoubleSerializer).p18 = function () {
    return this.q1l_1;
  };
  protoOf(DoubleSerializer).r1l = function (encoder, value) {
    return encoder.z1b(value);
  };
  protoOf(DoubleSerializer).q18 = function (encoder, value) {
    return this.r1l(encoder, (!(value == null) ? typeof value === 'number' : false) ? value : THROW_CCE());
  };
  protoOf(DoubleSerializer).r18 = function (decoder) {
    return decoder.t1a();
  };
  var DoubleSerializer_instance;
  function DoubleSerializer_getInstance() {
    if (DoubleSerializer_instance == null)
      new DoubleSerializer();
    return DoubleSerializer_instance;
  }
  function FloatSerializer() {
    FloatSerializer_instance = this;
    this.s1l_1 = new PrimitiveSerialDescriptor_0('kotlin.Float', FLOAT_getInstance());
  }
  protoOf(FloatSerializer).p18 = function () {
    return this.s1l_1;
  };
  protoOf(FloatSerializer).t1l = function (encoder, value) {
    return encoder.y1b(value);
  };
  protoOf(FloatSerializer).q18 = function (encoder, value) {
    return this.t1l(encoder, (!(value == null) ? typeof value === 'number' : false) ? value : THROW_CCE());
  };
  protoOf(FloatSerializer).r18 = function (decoder) {
    return decoder.s1a();
  };
  var FloatSerializer_instance;
  function FloatSerializer_getInstance() {
    if (FloatSerializer_instance == null)
      new FloatSerializer();
    return FloatSerializer_instance;
  }
  function LongSerializer() {
    LongSerializer_instance = this;
    this.u1l_1 = new PrimitiveSerialDescriptor_0('kotlin.Long', LONG_getInstance());
  }
  protoOf(LongSerializer).p18 = function () {
    return this.u1l_1;
  };
  protoOf(LongSerializer).v1l = function (encoder, value) {
    return encoder.x1b(value);
  };
  protoOf(LongSerializer).q18 = function (encoder, value) {
    return this.v1l(encoder, value instanceof Long ? value : THROW_CCE());
  };
  protoOf(LongSerializer).r18 = function (decoder) {
    return decoder.r1a();
  };
  var LongSerializer_instance;
  function LongSerializer_getInstance() {
    if (LongSerializer_instance == null)
      new LongSerializer();
    return LongSerializer_instance;
  }
  function IntSerializer() {
    IntSerializer_instance = this;
    this.w1l_1 = new PrimitiveSerialDescriptor_0('kotlin.Int', INT_getInstance());
  }
  protoOf(IntSerializer).p18 = function () {
    return this.w1l_1;
  };
  protoOf(IntSerializer).x1l = function (encoder, value) {
    return encoder.w1b(value);
  };
  protoOf(IntSerializer).q18 = function (encoder, value) {
    return this.x1l(encoder, (!(value == null) ? typeof value === 'number' : false) ? value : THROW_CCE());
  };
  protoOf(IntSerializer).r18 = function (decoder) {
    return decoder.q1a();
  };
  var IntSerializer_instance;
  function IntSerializer_getInstance() {
    if (IntSerializer_instance == null)
      new IntSerializer();
    return IntSerializer_instance;
  }
  function ShortSerializer() {
    ShortSerializer_instance = this;
    this.y1l_1 = new PrimitiveSerialDescriptor_0('kotlin.Short', SHORT_getInstance());
  }
  protoOf(ShortSerializer).p18 = function () {
    return this.y1l_1;
  };
  protoOf(ShortSerializer).z1l = function (encoder, value) {
    return encoder.v1b(value);
  };
  protoOf(ShortSerializer).q18 = function (encoder, value) {
    return this.z1l(encoder, (!(value == null) ? typeof value === 'number' : false) ? value : THROW_CCE());
  };
  protoOf(ShortSerializer).r18 = function (decoder) {
    return decoder.p1a();
  };
  var ShortSerializer_instance;
  function ShortSerializer_getInstance() {
    if (ShortSerializer_instance == null)
      new ShortSerializer();
    return ShortSerializer_instance;
  }
  function ByteSerializer() {
    ByteSerializer_instance = this;
    this.a1m_1 = new PrimitiveSerialDescriptor_0('kotlin.Byte', BYTE_getInstance());
  }
  protoOf(ByteSerializer).p18 = function () {
    return this.a1m_1;
  };
  protoOf(ByteSerializer).b1m = function (encoder, value) {
    return encoder.u1b(value);
  };
  protoOf(ByteSerializer).q18 = function (encoder, value) {
    return this.b1m(encoder, (!(value == null) ? typeof value === 'number' : false) ? value : THROW_CCE());
  };
  protoOf(ByteSerializer).r18 = function (decoder) {
    return decoder.o1a();
  };
  var ByteSerializer_instance;
  function ByteSerializer_getInstance() {
    if (ByteSerializer_instance == null)
      new ByteSerializer();
    return ByteSerializer_instance;
  }
  function BooleanSerializer() {
    BooleanSerializer_instance = this;
    this.c1m_1 = new PrimitiveSerialDescriptor_0('kotlin.Boolean', BOOLEAN_getInstance());
  }
  protoOf(BooleanSerializer).p18 = function () {
    return this.c1m_1;
  };
  protoOf(BooleanSerializer).d1m = function (encoder, value) {
    return encoder.t1b(value);
  };
  protoOf(BooleanSerializer).q18 = function (encoder, value) {
    return this.d1m(encoder, (!(value == null) ? typeof value === 'boolean' : false) ? value : THROW_CCE());
  };
  protoOf(BooleanSerializer).r18 = function (decoder) {
    return decoder.n1a();
  };
  var BooleanSerializer_instance;
  function BooleanSerializer_getInstance() {
    if (BooleanSerializer_instance == null)
      new BooleanSerializer();
    return BooleanSerializer_instance;
  }
  function UnitSerializer() {
    UnitSerializer_instance = this;
    this.e1m_1 = new ObjectSerializer('kotlin.Unit', Unit_instance);
  }
  protoOf(UnitSerializer).p18 = function () {
    return this.e1m_1.p18();
  };
  protoOf(UnitSerializer).f1m = function (decoder) {
    this.e1m_1.r18(decoder);
  };
  protoOf(UnitSerializer).r18 = function (decoder) {
    this.f1m(decoder);
    return Unit_instance;
  };
  protoOf(UnitSerializer).g1m = function (encoder, value) {
    this.e1m_1.y1g(encoder, Unit_instance);
  };
  protoOf(UnitSerializer).q18 = function (encoder, value) {
    return this.g1m(encoder, value instanceof Unit ? value : THROW_CCE());
  };
  var UnitSerializer_instance;
  function UnitSerializer_getInstance() {
    if (UnitSerializer_instance == null)
      new UnitSerializer();
    return UnitSerializer_instance;
  }
  function error_0($this) {
    throw IllegalStateException_init_$Create$('Primitive descriptor does not have elements');
  }
  function PrimitiveSerialDescriptor_0(serialName, kind) {
    this.h1m_1 = serialName;
    this.i1m_1 = kind;
  }
  protoOf(PrimitiveSerialDescriptor_0).z18 = function () {
    return this.h1m_1;
  };
  protoOf(PrimitiveSerialDescriptor_0).a19 = function () {
    return this.i1m_1;
  };
  protoOf(PrimitiveSerialDescriptor_0).d19 = function () {
    return 0;
  };
  protoOf(PrimitiveSerialDescriptor_0).f19 = function (index) {
    error_0(this);
  };
  protoOf(PrimitiveSerialDescriptor_0).g19 = function (name) {
    error_0(this);
  };
  protoOf(PrimitiveSerialDescriptor_0).j19 = function (index) {
    error_0(this);
  };
  protoOf(PrimitiveSerialDescriptor_0).i19 = function (index) {
    error_0(this);
  };
  protoOf(PrimitiveSerialDescriptor_0).h19 = function (index) {
    error_0(this);
  };
  protoOf(PrimitiveSerialDescriptor_0).toString = function () {
    return 'PrimitiveDescriptor(' + this.h1m_1 + ')';
  };
  protoOf(PrimitiveSerialDescriptor_0).equals = function (other) {
    if (this === other)
      return true;
    if (!(other instanceof PrimitiveSerialDescriptor_0))
      return false;
    if (this.h1m_1 === other.h1m_1 ? equals(this.i1m_1, other.i1m_1) : false)
      return true;
    return false;
  };
  protoOf(PrimitiveSerialDescriptor_0).hashCode = function () {
    return getStringHashCode(this.h1m_1) + imul(31, this.i1m_1.hashCode()) | 0;
  };
  function PrimitiveDescriptorSafe(serialName, kind) {
    _init_properties_Primitives_kt__k0eto4();
    checkName(serialName);
    return new PrimitiveSerialDescriptor_0(serialName, kind);
  }
  function checkName(serialName) {
    _init_properties_Primitives_kt__k0eto4();
    var keys = get_BUILTIN_SERIALIZERS().z1();
    var tmp0_iterator = keys.u();
    while (tmp0_iterator.v()) {
      var primitive = tmp0_iterator.w();
      var simpleName = capitalize(ensureNotNull(primitive.g6()));
      var qualifiedName = 'kotlin.' + simpleName;
      if (equals_0(serialName, qualifiedName, true) ? true : equals_0(serialName, simpleName, true)) {
        throw IllegalArgumentException_init_$Create$(trimIndent('\n                The name of serial descriptor should uniquely identify associated serializer.\n                For serial name ' + serialName + ' there already exist ' + capitalize(simpleName) + 'Serializer.\n                Please refer to SerialDescriptor documentation for additional information.\n            '));
      }
    }
  }
  function capitalize(_this__u8e3s4) {
    _init_properties_Primitives_kt__k0eto4();
    // Inline function 'kotlin.text.replaceFirstChar' call
    var tmp;
    // Inline function 'kotlin.text.isNotEmpty' call
    if (charSequenceLength(_this__u8e3s4) > 0) {
      // Inline function 'kotlinx.serialization.internal.capitalize.<anonymous>' call
      var it = charSequenceGet(_this__u8e3s4, 0);
      var tmp$ret$1 = isLowerCase(it) ? titlecase(it) : toString_0(it);
      var tmp_0 = toString(tmp$ret$1);
      // Inline function 'kotlin.text.substring' call
      // Inline function 'kotlin.js.asDynamic' call
      tmp = tmp_0 + _this__u8e3s4.substring(1);
    } else {
      tmp = _this__u8e3s4;
    }
    return tmp;
  }
  var properties_initialized_Primitives_kt_6dpii6;
  function _init_properties_Primitives_kt__k0eto4() {
    if (!properties_initialized_Primitives_kt_6dpii6) {
      properties_initialized_Primitives_kt_6dpii6 = true;
      BUILTIN_SERIALIZERS = mapOf([to(PrimitiveClasses_getInstance().c7(), serializer(StringCompanionObject_instance)), to(getKClass(Char), serializer_0(Companion_getInstance_1())), to(PrimitiveClasses_getInstance().f7(), CharArraySerializer()), to(PrimitiveClasses_getInstance().a7(), serializer_1(DoubleCompanionObject_instance)), to(PrimitiveClasses_getInstance().l7(), DoubleArraySerializer()), to(PrimitiveClasses_getInstance().z6(), serializer_2(FloatCompanionObject_instance)), to(PrimitiveClasses_getInstance().k7(), FloatArraySerializer()), to(getKClass(Long), serializer_3(Companion_getInstance_0())), to(PrimitiveClasses_getInstance().j7(), LongArraySerializer()), to(getKClass(ULong), serializer_4(Companion_getInstance_2())), to(getKClass(ULongArray), ULongArraySerializer()), to(PrimitiveClasses_getInstance().y6(), serializer_5(IntCompanionObject_instance)), to(PrimitiveClasses_getInstance().i7(), IntArraySerializer()), to(getKClass(UInt), serializer_6(Companion_getInstance_3())), to(getKClass(UIntArray), UIntArraySerializer()), to(PrimitiveClasses_getInstance().x6(), serializer_7(ShortCompanionObject_instance)), to(PrimitiveClasses_getInstance().h7(), ShortArraySerializer()), to(getKClass(UShort), serializer_8(Companion_getInstance_4())), to(getKClass(UShortArray), UShortArraySerializer()), to(PrimitiveClasses_getInstance().w6(), serializer_9(ByteCompanionObject_instance)), to(PrimitiveClasses_getInstance().g7(), ByteArraySerializer()), to(getKClass(UByte), serializer_10(Companion_getInstance_5())), to(getKClass(UByteArray), UByteArraySerializer()), to(PrimitiveClasses_getInstance().v6(), serializer_11(BooleanCompanionObject_instance)), to(PrimitiveClasses_getInstance().e7(), BooleanArraySerializer()), to(getKClass(Unit), serializer_12(Unit_instance)), to(PrimitiveClasses_getInstance().u6(), NothingSerializer()), to(getKClass(Duration), serializer_13(Companion_getInstance()))]);
    }
  }
  function NamedValueDecoder() {
    TaggedDecoder.call(this);
  }
  protoOf(NamedValueDecoder).l1m = function (_this__u8e3s4, index) {
    return this.n1m(this.m1m(_this__u8e3s4, index));
  };
  protoOf(NamedValueDecoder).n1m = function (nestedName) {
    var tmp0_elvis_lhs = this.q1m();
    return this.r1m(tmp0_elvis_lhs == null ? '' : tmp0_elvis_lhs, nestedName);
  };
  protoOf(NamedValueDecoder).m1m = function (descriptor, index) {
    return descriptor.f19(index);
  };
  protoOf(NamedValueDecoder).r1m = function (parentName, childName) {
    var tmp;
    // Inline function 'kotlin.text.isEmpty' call
    if (charSequenceLength(parentName) === 0) {
      tmp = childName;
    } else {
      tmp = parentName + '.' + childName;
    }
    return tmp;
  };
  function tagBlock($this, tag, block) {
    $this.e1n(tag);
    var r = block();
    if (!$this.p1m_1) {
      $this.f1n();
    }
    $this.p1m_1 = false;
    return r;
  }
  function TaggedDecoder$decodeSerializableElement$lambda(this$0, $deserializer, $previousValue) {
    return function () {
      return this$0.x1a($deserializer, $previousValue);
    };
  }
  function TaggedDecoder() {
    var tmp = this;
    // Inline function 'kotlin.collections.arrayListOf' call
    tmp.o1m_1 = ArrayList_init_$Create$();
    this.p1m_1 = false;
  }
  protoOf(TaggedDecoder).m1b = function () {
    return EmptySerializersModule_0();
  };
  protoOf(TaggedDecoder).s1m = function (tag) {
    throw SerializationException_init_$Create$_0('' + getKClassFromExpression(this) + " can't retrieve untyped values");
  };
  protoOf(TaggedDecoder).t1m = function (tag) {
    return true;
  };
  protoOf(TaggedDecoder).u1m = function (tag) {
    var tmp = this.s1m(tag);
    return typeof tmp === 'boolean' ? tmp : THROW_CCE();
  };
  protoOf(TaggedDecoder).v1m = function (tag) {
    var tmp = this.s1m(tag);
    return typeof tmp === 'number' ? tmp : THROW_CCE();
  };
  protoOf(TaggedDecoder).w1m = function (tag) {
    var tmp = this.s1m(tag);
    return typeof tmp === 'number' ? tmp : THROW_CCE();
  };
  protoOf(TaggedDecoder).x1m = function (tag) {
    var tmp = this.s1m(tag);
    return typeof tmp === 'number' ? tmp : THROW_CCE();
  };
  protoOf(TaggedDecoder).y1m = function (tag) {
    var tmp = this.s1m(tag);
    return tmp instanceof Long ? tmp : THROW_CCE();
  };
  protoOf(TaggedDecoder).z1m = function (tag) {
    var tmp = this.s1m(tag);
    return typeof tmp === 'number' ? tmp : THROW_CCE();
  };
  protoOf(TaggedDecoder).a1n = function (tag) {
    var tmp = this.s1m(tag);
    return typeof tmp === 'number' ? tmp : THROW_CCE();
  };
  protoOf(TaggedDecoder).b1n = function (tag) {
    var tmp = this.s1m(tag);
    return tmp instanceof Char ? tmp.s8_1 : THROW_CCE();
  };
  protoOf(TaggedDecoder).c1n = function (tag) {
    var tmp = this.s1m(tag);
    return typeof tmp === 'string' ? tmp : THROW_CCE();
  };
  protoOf(TaggedDecoder).d1n = function (tag, inlineDescriptor) {
    // Inline function 'kotlin.apply' call
    // Inline function 'kotlin.contracts.contract' call
    // Inline function 'kotlinx.serialization.internal.TaggedDecoder.decodeTaggedInline.<anonymous>' call
    this.e1n(tag);
    return this;
  };
  protoOf(TaggedDecoder).x1a = function (deserializer, previousValue) {
    return this.y1a(deserializer);
  };
  protoOf(TaggedDecoder).w1a = function (descriptor) {
    return this.d1n(this.f1n(), descriptor);
  };
  protoOf(TaggedDecoder).l1a = function () {
    var tmp0_elvis_lhs = this.q1m();
    var tmp;
    if (tmp0_elvis_lhs == null) {
      return false;
    } else {
      tmp = tmp0_elvis_lhs;
    }
    var currentTag = tmp;
    return this.t1m(currentTag);
  };
  protoOf(TaggedDecoder).m1a = function () {
    return null;
  };
  protoOf(TaggedDecoder).n1a = function () {
    return this.u1m(this.f1n());
  };
  protoOf(TaggedDecoder).o1a = function () {
    return this.v1m(this.f1n());
  };
  protoOf(TaggedDecoder).p1a = function () {
    return this.w1m(this.f1n());
  };
  protoOf(TaggedDecoder).q1a = function () {
    return this.x1m(this.f1n());
  };
  protoOf(TaggedDecoder).r1a = function () {
    return this.y1m(this.f1n());
  };
  protoOf(TaggedDecoder).s1a = function () {
    return this.z1m(this.f1n());
  };
  protoOf(TaggedDecoder).t1a = function () {
    return this.a1n(this.f1n());
  };
  protoOf(TaggedDecoder).u1a = function () {
    return this.b1n(this.f1n());
  };
  protoOf(TaggedDecoder).v1a = function () {
    return this.c1n(this.f1n());
  };
  protoOf(TaggedDecoder).z1a = function (descriptor) {
    return this;
  };
  protoOf(TaggedDecoder).a1b = function (descriptor) {
  };
  protoOf(TaggedDecoder).b1b = function (descriptor, index) {
    return this.u1m(this.l1m(descriptor, index));
  };
  protoOf(TaggedDecoder).c1b = function (descriptor, index) {
    return this.v1m(this.l1m(descriptor, index));
  };
  protoOf(TaggedDecoder).d1b = function (descriptor, index) {
    return this.w1m(this.l1m(descriptor, index));
  };
  protoOf(TaggedDecoder).e1b = function (descriptor, index) {
    return this.x1m(this.l1m(descriptor, index));
  };
  protoOf(TaggedDecoder).f1b = function (descriptor, index) {
    return this.y1m(this.l1m(descriptor, index));
  };
  protoOf(TaggedDecoder).g1b = function (descriptor, index) {
    return this.z1m(this.l1m(descriptor, index));
  };
  protoOf(TaggedDecoder).h1b = function (descriptor, index) {
    return this.a1n(this.l1m(descriptor, index));
  };
  protoOf(TaggedDecoder).i1b = function (descriptor, index) {
    return this.b1n(this.l1m(descriptor, index));
  };
  protoOf(TaggedDecoder).j1b = function (descriptor, index) {
    return this.d1n(this.l1m(descriptor, index), descriptor.i19(index));
  };
  protoOf(TaggedDecoder).k1b = function (descriptor, index, deserializer, previousValue) {
    var tmp = this.l1m(descriptor, index);
    return tagBlock(this, tmp, TaggedDecoder$decodeSerializableElement$lambda(this, deserializer, previousValue));
  };
  protoOf(TaggedDecoder).q1m = function () {
    return lastOrNull(this.o1m_1);
  };
  protoOf(TaggedDecoder).e1n = function (name) {
    this.o1m_1.r(name);
  };
  protoOf(TaggedDecoder).f1n = function () {
    var r = this.o1m_1.h1(get_lastIndex_0(this.o1m_1));
    this.p1m_1 = true;
    return r;
  };
  function ULongSerializer() {
    ULongSerializer_instance = this;
    this.g1n_1 = InlinePrimitiveDescriptor('kotlin.ULong', serializer_3(Companion_getInstance_0()));
  }
  protoOf(ULongSerializer).p18 = function () {
    return this.g1n_1;
  };
  protoOf(ULongSerializer).h1n = function (encoder, value) {
    var tmp = encoder.c1c(this.g1n_1);
    // Inline function 'kotlin.ULong.toLong' call
    var tmp$ret$0 = _ULong___get_data__impl__fggpzb(value);
    tmp.x1b(tmp$ret$0);
  };
  protoOf(ULongSerializer).q18 = function (encoder, value) {
    return this.h1n(encoder, value instanceof ULong ? value.eh_1 : THROW_CCE());
  };
  protoOf(ULongSerializer).i1n = function (decoder) {
    // Inline function 'kotlin.toULong' call
    var this_0 = decoder.w1a(this.g1n_1).r1a();
    return _ULong___init__impl__c78o9k(this_0);
  };
  protoOf(ULongSerializer).r18 = function (decoder) {
    return new ULong(this.i1n(decoder));
  };
  var ULongSerializer_instance;
  function ULongSerializer_getInstance() {
    if (ULongSerializer_instance == null)
      new ULongSerializer();
    return ULongSerializer_instance;
  }
  function UIntSerializer() {
    UIntSerializer_instance = this;
    this.j1n_1 = InlinePrimitiveDescriptor('kotlin.UInt', serializer_5(IntCompanionObject_instance));
  }
  protoOf(UIntSerializer).p18 = function () {
    return this.j1n_1;
  };
  protoOf(UIntSerializer).k1n = function (encoder, value) {
    var tmp = encoder.c1c(this.j1n_1);
    // Inline function 'kotlin.UInt.toInt' call
    var tmp$ret$0 = _UInt___get_data__impl__f0vqqw(value);
    tmp.w1b(tmp$ret$0);
  };
  protoOf(UIntSerializer).q18 = function (encoder, value) {
    return this.k1n(encoder, value instanceof UInt ? value.tg_1 : THROW_CCE());
  };
  protoOf(UIntSerializer).l1n = function (decoder) {
    // Inline function 'kotlin.toUInt' call
    var this_0 = decoder.w1a(this.j1n_1).q1a();
    return _UInt___init__impl__l7qpdl(this_0);
  };
  protoOf(UIntSerializer).r18 = function (decoder) {
    return new UInt(this.l1n(decoder));
  };
  var UIntSerializer_instance;
  function UIntSerializer_getInstance() {
    if (UIntSerializer_instance == null)
      new UIntSerializer();
    return UIntSerializer_instance;
  }
  function UShortSerializer() {
    UShortSerializer_instance = this;
    this.m1n_1 = InlinePrimitiveDescriptor('kotlin.UShort', serializer_7(ShortCompanionObject_instance));
  }
  protoOf(UShortSerializer).p18 = function () {
    return this.m1n_1;
  };
  protoOf(UShortSerializer).n1n = function (encoder, value) {
    var tmp = encoder.c1c(this.m1n_1);
    // Inline function 'kotlin.UShort.toShort' call
    var tmp$ret$0 = _UShort___get_data__impl__g0245(value);
    tmp.v1b(tmp$ret$0);
  };
  protoOf(UShortSerializer).q18 = function (encoder, value) {
    return this.n1n(encoder, value instanceof UShort ? value.ph_1 : THROW_CCE());
  };
  protoOf(UShortSerializer).o1n = function (decoder) {
    // Inline function 'kotlin.toUShort' call
    var this_0 = decoder.w1a(this.m1n_1).p1a();
    return _UShort___init__impl__jigrne(this_0);
  };
  protoOf(UShortSerializer).r18 = function (decoder) {
    return new UShort(this.o1n(decoder));
  };
  var UShortSerializer_instance;
  function UShortSerializer_getInstance() {
    if (UShortSerializer_instance == null)
      new UShortSerializer();
    return UShortSerializer_instance;
  }
  function UByteSerializer() {
    UByteSerializer_instance = this;
    this.p1n_1 = InlinePrimitiveDescriptor('kotlin.UByte', serializer_9(ByteCompanionObject_instance));
  }
  protoOf(UByteSerializer).p18 = function () {
    return this.p1n_1;
  };
  protoOf(UByteSerializer).q1n = function (encoder, value) {
    var tmp = encoder.c1c(this.p1n_1);
    // Inline function 'kotlin.UByte.toByte' call
    var tmp$ret$0 = _UByte___get_data__impl__jof9qr(value);
    tmp.u1b(tmp$ret$0);
  };
  protoOf(UByteSerializer).q18 = function (encoder, value) {
    return this.q1n(encoder, value instanceof UByte ? value.ig_1 : THROW_CCE());
  };
  protoOf(UByteSerializer).r1n = function (decoder) {
    // Inline function 'kotlin.toUByte' call
    var this_0 = decoder.w1a(this.p1n_1).o1a();
    return _UByte___init__impl__g9hnc4(this_0);
  };
  protoOf(UByteSerializer).r18 = function (decoder) {
    return new UByte(this.r1n(decoder));
  };
  var UByteSerializer_instance;
  function UByteSerializer_getInstance() {
    if (UByteSerializer_instance == null)
      new UByteSerializer();
    return UByteSerializer_instance;
  }
  function get_EmptySerializersModuleLegacyJs() {
    _init_properties_SerializersModule_kt__u78ha3();
    return EmptySerializersModule;
  }
  var EmptySerializersModule;
  function SerializersModule() {
  }
  protoOf(SerializersModule).w18 = function (kClass, typeArgumentsSerializers, $super) {
    typeArgumentsSerializers = typeArgumentsSerializers === VOID ? emptyList() : typeArgumentsSerializers;
    return $super === VOID ? this.s1n(kClass, typeArgumentsSerializers) : $super.s1n.call(this, kClass, typeArgumentsSerializers);
  };
  function SerialModuleImpl(class2ContextualFactory, polyBase2Serializers, polyBase2DefaultSerializerProvider, polyBase2NamedSerializers, polyBase2DefaultDeserializerProvider) {
    SerializersModule.call(this);
    this.u1n_1 = class2ContextualFactory;
    this.v1n_1 = polyBase2Serializers;
    this.w1n_1 = polyBase2DefaultSerializerProvider;
    this.x1n_1 = polyBase2NamedSerializers;
    this.y1n_1 = polyBase2DefaultDeserializerProvider;
  }
  protoOf(SerialModuleImpl).s1c = function (baseClass, value) {
    if (!baseClass.h6(value))
      return null;
    var tmp0_safe_receiver = this.v1n_1.m2(baseClass);
    var tmp = tmp0_safe_receiver == null ? null : tmp0_safe_receiver.m2(getKClassFromExpression(value));
    var registered = (!(tmp == null) ? isInterface(tmp, SerializationStrategy) : false) ? tmp : null;
    if (!(registered == null))
      return registered;
    var tmp_0 = this.w1n_1.m2(baseClass);
    var tmp1_safe_receiver = (!(tmp_0 == null) ? typeof tmp_0 === 'function' : false) ? tmp_0 : null;
    return tmp1_safe_receiver == null ? null : tmp1_safe_receiver(value);
  };
  protoOf(SerialModuleImpl).r1c = function (baseClass, serializedClassName) {
    var tmp0_safe_receiver = this.x1n_1.m2(baseClass);
    var tmp;
    if (tmp0_safe_receiver == null) {
      tmp = null;
    } else {
      // Inline function 'kotlin.collections.get' call
      tmp = (isInterface(tmp0_safe_receiver, Map) ? tmp0_safe_receiver : THROW_CCE()).m2(serializedClassName);
    }
    var tmp_0 = tmp;
    var registered = (!(tmp_0 == null) ? isInterface(tmp_0, KSerializer) : false) ? tmp_0 : null;
    if (!(registered == null))
      return registered;
    var tmp_1 = this.y1n_1.m2(baseClass);
    var tmp1_safe_receiver = (!(tmp_1 == null) ? typeof tmp_1 === 'function' : false) ? tmp_1 : null;
    return tmp1_safe_receiver == null ? null : tmp1_safe_receiver(serializedClassName);
  };
  protoOf(SerialModuleImpl).s1n = function (kClass, typeArgumentsSerializers) {
    var tmp0_safe_receiver = this.u1n_1.m2(kClass);
    var tmp = tmp0_safe_receiver == null ? null : tmp0_safe_receiver.z1n(typeArgumentsSerializers);
    return (tmp == null ? true : isInterface(tmp, KSerializer)) ? tmp : null;
  };
  protoOf(SerialModuleImpl).t1n = function (collector) {
    // Inline function 'kotlin.collections.forEach' call
    // Inline function 'kotlin.collections.iterator' call
    var tmp0_iterator = this.u1n_1.b2().u();
    while (tmp0_iterator.v()) {
      var element = tmp0_iterator.w();
      // Inline function 'kotlinx.serialization.modules.SerialModuleImpl.dumpTo.<anonymous>' call
      // Inline function 'kotlin.collections.component1' call
      var kclass = element.e2();
      // Inline function 'kotlin.collections.component2' call
      var serial = element.f2();
      if (serial instanceof Argless) {
        var tmp = isInterface(kclass, KClass) ? kclass : THROW_CCE();
        var tmp_0 = serial.c1o_1;
        collector.d1o(tmp, isInterface(tmp_0, KSerializer) ? tmp_0 : THROW_CCE());
      } else {
        if (serial instanceof WithTypeArguments) {
          collector.b1o(kclass, serial.a1o_1);
        }
      }
    }
    // Inline function 'kotlin.collections.forEach' call
    // Inline function 'kotlin.collections.iterator' call
    var tmp0_iterator_0 = this.v1n_1.b2().u();
    while (tmp0_iterator_0.v()) {
      var element_0 = tmp0_iterator_0.w();
      // Inline function 'kotlinx.serialization.modules.SerialModuleImpl.dumpTo.<anonymous>' call
      // Inline function 'kotlin.collections.component1' call
      var baseClass = element_0.e2();
      // Inline function 'kotlin.collections.component2' call
      var classMap = element_0.f2();
      // Inline function 'kotlin.collections.forEach' call
      // Inline function 'kotlin.collections.iterator' call
      var tmp0_iterator_1 = classMap.b2().u();
      while (tmp0_iterator_1.v()) {
        var element_1 = tmp0_iterator_1.w();
        // Inline function 'kotlinx.serialization.modules.SerialModuleImpl.dumpTo.<anonymous>.<anonymous>' call
        // Inline function 'kotlin.collections.component1' call
        var actualClass = element_1.e2();
        // Inline function 'kotlin.collections.component2' call
        var serializer = element_1.f2();
        var tmp_1 = isInterface(baseClass, KClass) ? baseClass : THROW_CCE();
        var tmp_2 = isInterface(actualClass, KClass) ? actualClass : THROW_CCE();
        // Inline function 'kotlinx.serialization.internal.cast' call
        var tmp$ret$9 = isInterface(serializer, KSerializer) ? serializer : THROW_CCE();
        collector.e1o(tmp_1, tmp_2, tmp$ret$9);
      }
    }
    // Inline function 'kotlin.collections.forEach' call
    // Inline function 'kotlin.collections.iterator' call
    var tmp0_iterator_2 = this.w1n_1.b2().u();
    while (tmp0_iterator_2.v()) {
      var element_2 = tmp0_iterator_2.w();
      // Inline function 'kotlinx.serialization.modules.SerialModuleImpl.dumpTo.<anonymous>' call
      // Inline function 'kotlin.collections.component1' call
      var baseClass_0 = element_2.e2();
      // Inline function 'kotlin.collections.component2' call
      var provider = element_2.f2();
      var tmp_3 = isInterface(baseClass_0, KClass) ? baseClass_0 : THROW_CCE();
      collector.f1o(tmp_3, typeof provider === 'function' ? provider : THROW_CCE());
    }
    // Inline function 'kotlin.collections.forEach' call
    // Inline function 'kotlin.collections.iterator' call
    var tmp0_iterator_3 = this.y1n_1.b2().u();
    while (tmp0_iterator_3.v()) {
      var element_3 = tmp0_iterator_3.w();
      // Inline function 'kotlinx.serialization.modules.SerialModuleImpl.dumpTo.<anonymous>' call
      // Inline function 'kotlin.collections.component1' call
      var baseClass_1 = element_3.e2();
      // Inline function 'kotlin.collections.component2' call
      var provider_0 = element_3.f2();
      var tmp_4 = isInterface(baseClass_1, KClass) ? baseClass_1 : THROW_CCE();
      collector.g1o(tmp_4, typeof provider_0 === 'function' ? provider_0 : THROW_CCE());
    }
  };
  function Argless() {
  }
  function WithTypeArguments() {
  }
  function ContextualProvider() {
  }
  var properties_initialized_SerializersModule_kt_fjigjn;
  function _init_properties_SerializersModule_kt__u78ha3() {
    if (!properties_initialized_SerializersModule_kt_fjigjn) {
      properties_initialized_SerializersModule_kt_fjigjn = true;
      EmptySerializersModule = new SerialModuleImpl(emptyMap(), emptyMap(), emptyMap(), emptyMap(), emptyMap());
    }
  }
  function EmptySerializersModule_0() {
    return get_EmptySerializersModuleLegacyJs();
  }
  function SerializersModuleCollector$contextual$lambda($serializer) {
    return function (it) {
      return $serializer;
    };
  }
  function SerializersModuleCollector() {
  }
  function SerializableWith() {
  }
  function getChecked(_this__u8e3s4, index) {
    if (!(0 <= index ? index <= (_this__u8e3s4.length - 1 | 0) : false))
      throw IndexOutOfBoundsException_init_$Create$('Index ' + index + ' out of bounds ' + get_indices(_this__u8e3s4));
    return _this__u8e3s4[index];
  }
  function getChecked_0(_this__u8e3s4, index) {
    if (!(0 <= index ? index <= (_this__u8e3s4.length - 1 | 0) : false))
      throw IndexOutOfBoundsException_init_$Create$('Index ' + index + ' out of bounds ' + get_indices_0(_this__u8e3s4));
    return _this__u8e3s4[index];
  }
  //region block: post-declaration
  protoOf(SerialDescriptorImpl).b19 = get_isNullable;
  protoOf(SerialDescriptorImpl).c19 = get_isInline;
  protoOf(AbstractDecoder).l1b = decodeSerializableElement$default;
  protoOf(AbstractDecoder).y1a = decodeSerializableValue;
  protoOf(AbstractDecoder).n1b = decodeSequentially;
  protoOf(AbstractDecoder).p1b = decodeCollectionSize;
  protoOf(AbstractEncoder).o1c = beginCollection;
  protoOf(AbstractEncoder).n1c = encodeSerializableValue;
  protoOf(ListLikeDescriptor).b19 = get_isNullable;
  protoOf(ListLikeDescriptor).c19 = get_isInline;
  protoOf(ListLikeDescriptor).e19 = get_annotations;
  protoOf(MapLikeDescriptor).b19 = get_isNullable;
  protoOf(MapLikeDescriptor).c19 = get_isInline;
  protoOf(MapLikeDescriptor).e19 = get_annotations;
  protoOf(PluginGeneratedSerialDescriptor).b19 = get_isNullable;
  protoOf(PluginGeneratedSerialDescriptor).c19 = get_isInline;
  protoOf(InlinePrimitiveDescriptor$1).r1g = typeParametersSerializers;
  protoOf(NothingSerialDescriptor).b19 = get_isNullable;
  protoOf(NothingSerialDescriptor).c19 = get_isInline;
  protoOf(NothingSerialDescriptor).e19 = get_annotations;
  protoOf(PrimitiveSerialDescriptor_0).b19 = get_isNullable;
  protoOf(PrimitiveSerialDescriptor_0).c19 = get_isInline;
  protoOf(PrimitiveSerialDescriptor_0).e19 = get_annotations;
  protoOf(TaggedDecoder).l1b = decodeSerializableElement$default;
  protoOf(TaggedDecoder).y1a = decodeSerializableValue;
  protoOf(TaggedDecoder).n1b = decodeSequentially;
  protoOf(TaggedDecoder).p1b = decodeCollectionSize;
  //endregion
  //region block: init
  Companion_instance = new Companion();
  //endregion
  //region block: exports
  _.$_$ = _.$_$ || {};
  _.$_$.a = SerializationException_init_$Init$_0;
  _.$_$.b = UnknownFieldException_init_$Create$;
  _.$_$.c = SEALED_getInstance;
  _.$_$.d = STRING_getInstance;
  _.$_$.e = CONTEXTUAL_getInstance;
  _.$_$.f = ENUM_getInstance;
  _.$_$.g = CLASS_getInstance;
  _.$_$.h = LIST_getInstance;
  _.$_$.i = MAP_getInstance;
  _.$_$.j = Companion_instance;
  _.$_$.k = IntSerializer_getInstance;
  _.$_$.l = LongSerializer_getInstance;
  _.$_$.m = ListSerializer;
  _.$_$.n = MapSerializer;
  _.$_$.o = serializer;
  _.$_$.p = serializer_8;
  _.$_$.q = serializer_6;
  _.$_$.r = serializer_10;
  _.$_$.s = serializer_4;
  _.$_$.t = PolymorphicKind;
  _.$_$.u = PrimitiveKind;
  _.$_$.v = PrimitiveSerialDescriptor;
  _.$_$.w = get_annotations;
  _.$_$.x = get_isInline;
  _.$_$.y = get_isNullable;
  _.$_$.z = SerialDescriptor;
  _.$_$.a1 = ENUM;
  _.$_$.b1 = buildSerialDescriptor;
  _.$_$.c1 = getContextualDescriptor;
  _.$_$.d1 = AbstractDecoder;
  _.$_$.e1 = AbstractEncoder;
  _.$_$.f1 = CompositeDecoder;
  _.$_$.g1 = Decoder;
  _.$_$.h1 = Encoder;
  _.$_$.i1 = AbstractPolymorphicSerializer;
  _.$_$.j1 = ArrayListSerializer;
  _.$_$.k1 = ElementMarker;
  _.$_$.l1 = typeParametersSerializers;
  _.$_$.m1 = GeneratedSerializer;
  _.$_$.n1 = InlinePrimitiveDescriptor;
  _.$_$.o1 = NamedValueDecoder;
  _.$_$.p1 = PluginGeneratedSerialDescriptor;
  _.$_$.q1 = jsonCachedSerialNames;
  _.$_$.r1 = throwMissingFieldException;
  _.$_$.s1 = EmptySerializersModule_0;
  _.$_$.t1 = contextual;
  _.$_$.u1 = SerializersModuleCollector;
  _.$_$.v1 = DeserializationStrategy;
  _.$_$.w1 = KSerializer;
  _.$_$.x1 = MissingFieldException;
  _.$_$.y1 = SealedClassSerializer;
  _.$_$.z1 = SerializationException;
  _.$_$.a2 = findPolymorphicSerializer_0;
  _.$_$.b2 = findPolymorphicSerializer;
  //endregion
  return _;
}));

//# sourceMappingURL=kotlinx-serialization-kotlinx-serialization-core.js.map
