(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', './kotlinx-serialization-kotlinx-serialization-core.js', './kotlin-kotlin-stdlib.js'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('./kotlinx-serialization-kotlinx-serialization-core.js'), require('./kotlin-kotlin-stdlib.js'));
  else {
    if (typeof this['kotlinx-serialization-kotlinx-serialization-core'] === 'undefined') {
      throw new Error("Error loading module 'kotlinx-serialization-kotlinx-serialization-json'. Its dependency 'kotlinx-serialization-kotlinx-serialization-core' was not found. Please, check whether 'kotlinx-serialization-kotlinx-serialization-core' is loaded prior to 'kotlinx-serialization-kotlinx-serialization-json'.");
    }
    if (typeof this['kotlin-kotlin-stdlib'] === 'undefined') {
      throw new Error("Error loading module 'kotlinx-serialization-kotlinx-serialization-json'. Its dependency 'kotlin-kotlin-stdlib' was not found. Please, check whether 'kotlin-kotlin-stdlib' is loaded prior to 'kotlinx-serialization-kotlinx-serialization-json'.");
    }
    root['kotlinx-serialization-kotlinx-serialization-json'] = factory(typeof this['kotlinx-serialization-kotlinx-serialization-json'] === 'undefined' ? {} : this['kotlinx-serialization-kotlinx-serialization-json'], this['kotlinx-serialization-kotlinx-serialization-core'], this['kotlin-kotlin-stdlib']);
  }
}(this, function (_, kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core, kotlin_kotlin) {
  'use strict';
  //region block: imports
  var imul = Math.imul;
  var EmptySerializersModule = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.s1;
  var protoOf = kotlin_kotlin.$_$.w9;
  var objectMeta = kotlin_kotlin.$_$.v9;
  var setMetadataFor = kotlin_kotlin.$_$.x9;
  var Unit_instance = kotlin_kotlin.$_$.p4;
  var classMeta = kotlin_kotlin.$_$.q8;
  var VOID = kotlin_kotlin.$_$.d;
  var toString = kotlin_kotlin.$_$.ba;
  var IllegalArgumentException_init_$Create$ = kotlin_kotlin.$_$.h1;
  var charSequenceLength = kotlin_kotlin.$_$.o8;
  var charSequenceGet = kotlin_kotlin.$_$.n8;
  var _Char___init__impl__6a9atx = kotlin_kotlin.$_$.a2;
  var equals = kotlin_kotlin.$_$.t8;
  var Decoder = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.g1;
  var CompositeDecoder = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.f1;
  var interfaceMeta = kotlin_kotlin.$_$.a9;
  var StringBuilder_init_$Create$ = kotlin_kotlin.$_$.y;
  var THROW_CCE = kotlin_kotlin.$_$.bd;
  var hashCode = kotlin_kotlin.$_$.z8;
  var joinToString = kotlin_kotlin.$_$.e6;
  var Map = kotlin_kotlin.$_$.w4;
  var LazyThreadSafetyMode_PUBLICATION_getInstance = kotlin_kotlin.$_$.g;
  var lazy = kotlin_kotlin.$_$.vd;
  var getKClassFromExpression = kotlin_kotlin.$_$.b;
  var getBooleanHashCode = kotlin_kotlin.$_$.w8;
  var getStringHashCode = kotlin_kotlin.$_$.y8;
  var List = kotlin_kotlin.$_$.u4;
  var NumberFormatException_init_$Create$ = kotlin_kotlin.$_$.s1;
  var IntCompanionObject_instance = kotlin_kotlin.$_$.c4;
  var numberRangeToNumber = kotlin_kotlin.$_$.q9;
  var ClosedRange = kotlin_kotlin.$_$.ea;
  var isInterface = kotlin_kotlin.$_$.i9;
  var contains = kotlin_kotlin.$_$.ja;
  var toDouble = kotlin_kotlin.$_$.xb;
  var IllegalStateException_init_$Create$ = kotlin_kotlin.$_$.l1;
  var StringCompanionObject_instance = kotlin_kotlin.$_$.e4;
  var serializer = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.o;
  var InlinePrimitiveDescriptor = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.n1;
  var SEALED_getInstance = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.c;
  var buildSerialDescriptor = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.b1;
  var KSerializer = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.w1;
  var MapSerializer = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.n;
  var SerialDescriptor = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.z;
  var ListSerializer = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.m;
  var STRING_getInstance = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.d;
  var ENUM_getInstance = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.f;
  var PrimitiveSerialDescriptor = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.v;
  var toLongOrNull = kotlin_kotlin.$_$.ac;
  var toULongOrNull = kotlin_kotlin.$_$.gc;
  var ULong = kotlin_kotlin.$_$.hd;
  var Companion_getInstance = kotlin_kotlin.$_$.n4;
  var serializer_0 = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.s;
  var _ULong___get_data__impl__fggpzb = kotlin_kotlin.$_$.f3;
  var toDoubleOrNull = kotlin_kotlin.$_$.wb;
  var toBooleanStrictOrNull = kotlin_kotlin.$_$.vb;
  var lazy_0 = kotlin_kotlin.$_$.wd;
  var get_isNullable = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.y;
  var get_isInline = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.x;
  var get_annotations = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.w;
  var KProperty1 = kotlin_kotlin.$_$.oa;
  var getPropertyCallableRef = kotlin_kotlin.$_$.x8;
  var Encoder = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.h1;
  var toLong = kotlin_kotlin.$_$.z9;
  var _UInt___init__impl__l7qpdl = kotlin_kotlin.$_$.v2;
  var UInt__toString_impl_dbgl21 = kotlin_kotlin.$_$.x2;
  var _ULong___init__impl__c78o9k = kotlin_kotlin.$_$.e3;
  var ULong__toString_impl_f9au7k = kotlin_kotlin.$_$.g3;
  var _UByte___init__impl__g9hnc4 = kotlin_kotlin.$_$.m2;
  var UByte__toString_impl_v72jg = kotlin_kotlin.$_$.o2;
  var _UShort___init__impl__jigrne = kotlin_kotlin.$_$.n3;
  var UShort__toString_impl_edaoee = kotlin_kotlin.$_$.p3;
  var ElementMarker = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.k1;
  var captureStack = kotlin_kotlin.$_$.k8;
  var SerializationException = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.z1;
  var SerializationException_init_$Init$ = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.a;
  var charSequenceSubSequence = kotlin_kotlin.$_$.p8;
  var coerceAtLeast = kotlin_kotlin.$_$.fa;
  var coerceAtMost = kotlin_kotlin.$_$.ha;
  var Companion_instance = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.j;
  var CLASS_getInstance = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.g;
  var LinkedHashMap_init_$Create$ = kotlin_kotlin.$_$.q;
  var ArrayList_init_$Create$ = kotlin_kotlin.$_$.j;
  var singleOrNull = kotlin_kotlin.$_$.d7;
  var emptyMap = kotlin_kotlin.$_$.u5;
  var getValue = kotlin_kotlin.$_$.a6;
  var fillArrayVal = kotlin_kotlin.$_$.v8;
  var copyOf = kotlin_kotlin.$_$.p5;
  var copyOf_0 = kotlin_kotlin.$_$.q5;
  var LIST_getInstance = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.h;
  var DeepRecursiveFunction = kotlin_kotlin.$_$.qc;
  var invoke = kotlin_kotlin.$_$.rd;
  var CoroutineImpl = kotlin_kotlin.$_$.f8;
  var DeepRecursiveScope = kotlin_kotlin.$_$.rc;
  var Unit = kotlin_kotlin.$_$.kd;
  var get_COROUTINE_SUSPENDED = kotlin_kotlin.$_$.r7;
  var AbstractPolymorphicSerializer = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.i1;
  var getKClass = kotlin_kotlin.$_$.c;
  var findPolymorphicSerializer = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.a2;
  var ensureNotNull = kotlin_kotlin.$_$.qd;
  var DeserializationStrategy = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.v1;
  var SealedClassSerializer = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.y1;
  var jsonCachedSerialNames = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.q1;
  var ENUM = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.a1;
  var PrimitiveKind = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.u;
  var PolymorphicKind = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.t;
  var CONTEXTUAL_getInstance = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.e;
  var MAP_getInstance = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.i;
  var contextual = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.t1;
  var SerializersModuleCollector = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.u1;
  var AbstractDecoder = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.d1;
  var substringBefore = kotlin_kotlin.$_$.sb;
  var removeSuffix = kotlin_kotlin.$_$.kb;
  var substringAfter = kotlin_kotlin.$_$.qb;
  var contains_0 = kotlin_kotlin.$_$.sa;
  var plus = kotlin_kotlin.$_$.yd;
  var MissingFieldException = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.x1;
  var IllegalArgumentException = kotlin_kotlin.$_$.vc;
  var isFinite = kotlin_kotlin.$_$.td;
  var isFinite_0 = kotlin_kotlin.$_$.sd;
  var toUInt = kotlin_kotlin.$_$.fc;
  var _UInt___get_data__impl__f0vqqw = kotlin_kotlin.$_$.w2;
  var toULong = kotlin_kotlin.$_$.hc;
  var toUByte = kotlin_kotlin.$_$.ec;
  var _UByte___get_data__impl__jof9qr = kotlin_kotlin.$_$.n2;
  var toUShort = kotlin_kotlin.$_$.ic;
  var _UShort___get_data__impl__g0245 = kotlin_kotlin.$_$.o3;
  var objectCreate = kotlin_kotlin.$_$.u9;
  var AbstractEncoder = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.e1;
  var findPolymorphicSerializer_0 = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.b2;
  var toString_0 = kotlin_kotlin.$_$.h2;
  var Companion_getInstance_0 = kotlin_kotlin.$_$.m4;
  var serializer_1 = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.q;
  var Companion_getInstance_1 = kotlin_kotlin.$_$.l4;
  var serializer_2 = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.r;
  var Companion_getInstance_2 = kotlin_kotlin.$_$.o4;
  var serializer_3 = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.p;
  var setOf = kotlin_kotlin.$_$.c7;
  var Char__toInt_impl_vasixd = kotlin_kotlin.$_$.g2;
  var numberToChar = kotlin_kotlin.$_$.r9;
  var equals_0 = kotlin_kotlin.$_$.wa;
  var NamedValueDecoder = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.o1;
  var ByteCompanionObject_instance = kotlin_kotlin.$_$.z3;
  var toByte = kotlin_kotlin.$_$.y9;
  var ShortCompanionObject_instance = kotlin_kotlin.$_$.d4;
  var toShort = kotlin_kotlin.$_$.aa;
  var single = kotlin_kotlin.$_$.mb;
  var Char = kotlin_kotlin.$_$.oc;
  var emptySet = kotlin_kotlin.$_$.v5;
  var plus_0 = kotlin_kotlin.$_$.s6;
  var toInt = kotlin_kotlin.$_$.zb;
  var toList = kotlin_kotlin.$_$.i7;
  var enumEntries = kotlin_kotlin.$_$.h8;
  var Enum = kotlin_kotlin.$_$.sc;
  var getContextualDescriptor = kotlin_org_jetbrains_kotlinx_kotlinx_serialization_core.$_$.c1;
  var noWhenBranchMatchedException = kotlin_kotlin.$_$.xd;
  var last = kotlin_kotlin.$_$.l6;
  var removeLast = kotlin_kotlin.$_$.z6;
  var lastIndexOf = kotlin_kotlin.$_$.ib;
  var Long = kotlin_kotlin.$_$.xc;
  var Char__minus_impl_a2frrh = kotlin_kotlin.$_$.c2;
  var Companion_getInstance_3 = kotlin_kotlin.$_$.j4;
  var numberToLong = kotlin_kotlin.$_$.t9;
  var charArray = kotlin_kotlin.$_$.m8;
  var indexOf = kotlin_kotlin.$_$.ab;
  var StringBuilder_init_$Create$_0 = kotlin_kotlin.$_$.x;
  var HashMap_init_$Create$ = kotlin_kotlin.$_$.l;
  //endregion
  //region block: pre-declaration
  setMetadataFor(Json, 'Json', classMeta);
  setMetadataFor(Default, 'Default', objectMeta, Json);
  setMetadataFor(JsonBuilder, 'JsonBuilder', classMeta);
  setMetadataFor(JsonImpl, 'JsonImpl', classMeta, Json);
  setMetadataFor(JsonClassDiscriminator, 'JsonClassDiscriminator', classMeta);
  setMetadataFor(JsonNames, 'JsonNames', classMeta);
  setMetadataFor(JsonConfiguration, 'JsonConfiguration', classMeta);
  setMetadataFor(JsonDecoder, 'JsonDecoder', interfaceMeta, VOID, [Decoder, CompositeDecoder]);
  setMetadataFor(Companion, 'Companion', objectMeta);
  setMetadataFor(JsonElement, 'JsonElement', classMeta, VOID, VOID, VOID, VOID, {0: JsonElementSerializer_getInstance});
  setMetadataFor(Companion_0, 'Companion', objectMeta);
  setMetadataFor(JsonObject, 'JsonObject', classMeta, JsonElement, [JsonElement, Map], VOID, VOID, {0: JsonObjectSerializer_getInstance});
  setMetadataFor(JsonPrimitive, 'JsonPrimitive', classMeta, JsonElement, VOID, VOID, VOID, {0: JsonPrimitiveSerializer_getInstance});
  setMetadataFor(JsonNull, 'JsonNull', objectMeta, JsonPrimitive, VOID, VOID, VOID, {0: JsonNull_getInstance});
  setMetadataFor(Companion_1, 'Companion', objectMeta);
  setMetadataFor(JsonLiteral, 'JsonLiteral', classMeta, JsonPrimitive);
  setMetadataFor(Companion_2, 'Companion', objectMeta);
  setMetadataFor(JsonArray, 'JsonArray', classMeta, JsonElement, [JsonElement, List], VOID, VOID, {0: JsonArraySerializer_getInstance});
  setMetadataFor(JsonElementSerializer, 'JsonElementSerializer', objectMeta, VOID, [KSerializer]);
  setMetadataFor(JsonObjectDescriptor, 'JsonObjectDescriptor', objectMeta, VOID, [SerialDescriptor]);
  setMetadataFor(JsonObjectSerializer, 'JsonObjectSerializer', objectMeta, VOID, [KSerializer]);
  setMetadataFor(JsonArrayDescriptor, 'JsonArrayDescriptor', objectMeta, VOID, [SerialDescriptor]);
  setMetadataFor(JsonArraySerializer, 'JsonArraySerializer', objectMeta, VOID, [KSerializer]);
  setMetadataFor(JsonPrimitiveSerializer, 'JsonPrimitiveSerializer', objectMeta, VOID, [KSerializer]);
  setMetadataFor(JsonNullSerializer, 'JsonNullSerializer', objectMeta, VOID, [KSerializer]);
  setMetadataFor(JsonLiteralSerializer, 'JsonLiteralSerializer', objectMeta, VOID, [KSerializer]);
  setMetadataFor(defer$1, VOID, classMeta, VOID, [SerialDescriptor]);
  setMetadataFor(JsonEncoder, 'JsonEncoder', interfaceMeta, VOID, [Encoder]);
  setMetadataFor(Composer, 'Composer', classMeta);
  setMetadataFor(ComposerForUnsignedNumbers, 'ComposerForUnsignedNumbers', classMeta, Composer);
  setMetadataFor(ComposerForUnquotedLiterals, 'ComposerForUnquotedLiterals', classMeta, Composer);
  setMetadataFor(ComposerWithPrettyPrint, 'ComposerWithPrettyPrint', classMeta, Composer);
  setMetadataFor(JsonElementMarker, 'JsonElementMarker', classMeta);
  setMetadataFor(JsonException, 'JsonException', classMeta, SerializationException);
  setMetadataFor(JsonEncodingException, 'JsonEncodingException', classMeta, JsonException);
  setMetadataFor(JsonDecodingException, 'JsonDecodingException', classMeta, JsonException);
  setMetadataFor(Tombstone, 'Tombstone', objectMeta);
  setMetadataFor(JsonPath, 'JsonPath', classMeta, VOID, VOID, JsonPath);
  setMetadataFor(JsonTreeReader$readDeepRecursive$slambda, 'JsonTreeReader$readDeepRecursive$slambda', classMeta, CoroutineImpl, VOID, VOID, VOID, VOID, [2]);
  setMetadataFor($readObjectCOROUTINE$0, '$readObjectCOROUTINE$0', classMeta, CoroutineImpl);
  setMetadataFor(JsonTreeReader, 'JsonTreeReader', classMeta, VOID, VOID, VOID, VOID, VOID, [0]);
  setMetadataFor(PolymorphismValidator, 'PolymorphismValidator', classMeta, VOID, [SerializersModuleCollector]);
  setMetadataFor(Key, 'Key', classMeta, VOID, VOID, Key);
  setMetadataFor(DescriptorSchemaCache, 'DescriptorSchemaCache', classMeta, VOID, VOID, DescriptorSchemaCache);
  setMetadataFor(DiscriminatorHolder, 'DiscriminatorHolder', classMeta);
  setMetadataFor(StreamingJsonDecoder, 'StreamingJsonDecoder', classMeta, AbstractDecoder, [JsonDecoder, AbstractDecoder]);
  setMetadataFor(JsonDecoderForUnsignedTypes, 'JsonDecoderForUnsignedTypes', classMeta, AbstractDecoder);
  setMetadataFor(StreamingJsonEncoder, 'StreamingJsonEncoder', classMeta, AbstractEncoder, [JsonEncoder, AbstractEncoder]);
  setMetadataFor(AbstractJsonTreeDecoder, 'AbstractJsonTreeDecoder', classMeta, NamedValueDecoder, [NamedValueDecoder, JsonDecoder]);
  setMetadataFor(JsonTreeDecoder, 'JsonTreeDecoder', classMeta, AbstractJsonTreeDecoder);
  setMetadataFor(JsonTreeListDecoder, 'JsonTreeListDecoder', classMeta, AbstractJsonTreeDecoder);
  setMetadataFor(JsonPrimitiveDecoder, 'JsonPrimitiveDecoder', classMeta, AbstractJsonTreeDecoder);
  setMetadataFor(JsonTreeMapDecoder, 'JsonTreeMapDecoder', classMeta, JsonTreeDecoder);
  setMetadataFor(WriteMode, 'WriteMode', classMeta, Enum);
  setMetadataFor(AbstractJsonLexer, 'AbstractJsonLexer', classMeta);
  setMetadataFor(CharMappings, 'CharMappings', objectMeta);
  setMetadataFor(StringJsonLexer, 'StringJsonLexer', classMeta, AbstractJsonLexer);
  setMetadataFor(JsonToStringWriter, 'JsonToStringWriter', classMeta, VOID, VOID, JsonToStringWriter);
  //endregion
  function Default() {
    Default_instance = this;
    Json.call(this, new JsonConfiguration(), EmptySerializersModule());
  }
  var Default_instance;
  function Default_getInstance() {
    if (Default_instance == null)
      new Default();
    return Default_instance;
  }
  function Json(configuration, serializersModule) {
    Default_getInstance();
    this.h1o_1 = configuration;
    this.i1o_1 = serializersModule;
    this.j1o_1 = new DescriptorSchemaCache();
  }
  protoOf(Json).m1b = function () {
    return this.i1o_1;
  };
  protoOf(Json).k1o = function (serializer, value) {
    var result = new JsonToStringWriter();
    try {
      encodeByWriter(this, result, serializer, value);
      return result.toString();
    }finally {
      result.wo();
    }
  };
  protoOf(Json).l1o = function (deserializer, string) {
    var lexer = new StringJsonLexer(string);
    var input = new StreamingJsonDecoder(this, WriteMode_OBJ_getInstance(), lexer, deserializer.p18(), null);
    var result = input.y1a(deserializer);
    lexer.z1o();
    return result;
  };
  function Json_0(from, builderAction) {
    from = from === VOID ? Default_getInstance() : from;
    var builder = new JsonBuilder(from);
    builderAction(builder);
    var conf = builder.u2();
    return new JsonImpl(conf, builder.p1p_1);
  }
  function JsonBuilder(json) {
    this.a1p_1 = json.h1o_1.q1p_1;
    this.b1p_1 = json.h1o_1.v1p_1;
    this.c1p_1 = json.h1o_1.r1p_1;
    this.d1p_1 = json.h1o_1.s1p_1;
    this.e1p_1 = json.h1o_1.t1p_1;
    this.f1p_1 = json.h1o_1.u1p_1;
    this.g1p_1 = json.h1o_1.w1p_1;
    this.h1p_1 = json.h1o_1.x1p_1;
    this.i1p_1 = json.h1o_1.y1p_1;
    this.j1p_1 = json.h1o_1.z1p_1;
    this.k1p_1 = json.h1o_1.a1q_1;
    this.l1p_1 = json.h1o_1.b1q_1;
    this.m1p_1 = json.h1o_1.c1q_1;
    this.n1p_1 = json.h1o_1.d1q_1;
    this.o1p_1 = json.h1o_1.e1q_1;
    this.p1p_1 = json.m1b();
  }
  protoOf(JsonBuilder).u2 = function () {
    if (this.i1p_1) {
      // Inline function 'kotlin.require' call
      // Inline function 'kotlin.contracts.contract' call
      if (!(this.j1p_1 === 'type')) {
        // Inline function 'kotlinx.serialization.json.JsonBuilder.build.<anonymous>' call
        var message = 'Class discriminator should not be specified when array polymorphism is specified';
        throw IllegalArgumentException_init_$Create$(toString(message));
      }
    }
    if (!this.f1p_1) {
      // Inline function 'kotlin.require' call
      // Inline function 'kotlin.contracts.contract' call
      if (!(this.g1p_1 === '    ')) {
        // Inline function 'kotlinx.serialization.json.JsonBuilder.build.<anonymous>' call
        var message_0 = 'Indent should not be specified when default printing mode is used';
        throw IllegalArgumentException_init_$Create$(toString(message_0));
      }
    } else if (!(this.g1p_1 === '    ')) {
      var tmp$ret$3;
      $l$block: {
        // Inline function 'kotlin.text.all' call
        var indexedObject = this.g1p_1;
        var inductionVariable = 0;
        while (inductionVariable < charSequenceLength(indexedObject)) {
          var element = charSequenceGet(indexedObject, inductionVariable);
          inductionVariable = inductionVariable + 1 | 0;
          // Inline function 'kotlinx.serialization.json.JsonBuilder.build.<anonymous>' call
          if (!(((element === _Char___init__impl__6a9atx(32) ? true : element === _Char___init__impl__6a9atx(9)) ? true : element === _Char___init__impl__6a9atx(13)) ? true : element === _Char___init__impl__6a9atx(10))) {
            tmp$ret$3 = false;
            break $l$block;
          }
        }
        tmp$ret$3 = true;
      }
      var allWhitespaces = tmp$ret$3;
      // Inline function 'kotlin.require' call
      // Inline function 'kotlin.contracts.contract' call
      if (!allWhitespaces) {
        // Inline function 'kotlinx.serialization.json.JsonBuilder.build.<anonymous>' call
        var message_1 = 'Only whitespace, tab, newline and carriage return are allowed as pretty print symbols. Had ' + this.g1p_1;
        throw IllegalArgumentException_init_$Create$(toString(message_1));
      }
    }
    return new JsonConfiguration(this.a1p_1, this.c1p_1, this.d1p_1, this.e1p_1, this.f1p_1, this.b1p_1, this.g1p_1, this.h1p_1, this.i1p_1, this.j1p_1, this.k1p_1, this.l1p_1, this.m1p_1, this.n1p_1, this.o1p_1);
  };
  function validateConfiguration($this) {
    if (equals($this.m1b(), EmptySerializersModule()))
      return Unit_instance;
    var collector = new PolymorphismValidator($this.h1o_1.y1p_1, $this.h1o_1.z1p_1);
    $this.m1b().t1n(collector);
  }
  function JsonImpl(configuration, module_0) {
    Json.call(this, configuration, module_0);
    validateConfiguration(this);
  }
  function JsonClassDiscriminator() {
  }
  function JsonNames() {
  }
  function JsonConfiguration(encodeDefaults, ignoreUnknownKeys, isLenient, allowStructuredMapKeys, prettyPrint, explicitNulls, prettyPrintIndent, coerceInputValues, useArrayPolymorphism, classDiscriminator, allowSpecialFloatingPointValues, useAlternativeNames, namingStrategy, decodeEnumsCaseInsensitive, allowTrailingComma) {
    encodeDefaults = encodeDefaults === VOID ? false : encodeDefaults;
    ignoreUnknownKeys = ignoreUnknownKeys === VOID ? false : ignoreUnknownKeys;
    isLenient = isLenient === VOID ? false : isLenient;
    allowStructuredMapKeys = allowStructuredMapKeys === VOID ? false : allowStructuredMapKeys;
    prettyPrint = prettyPrint === VOID ? false : prettyPrint;
    explicitNulls = explicitNulls === VOID ? true : explicitNulls;
    prettyPrintIndent = prettyPrintIndent === VOID ? '    ' : prettyPrintIndent;
    coerceInputValues = coerceInputValues === VOID ? false : coerceInputValues;
    useArrayPolymorphism = useArrayPolymorphism === VOID ? false : useArrayPolymorphism;
    classDiscriminator = classDiscriminator === VOID ? 'type' : classDiscriminator;
    allowSpecialFloatingPointValues = allowSpecialFloatingPointValues === VOID ? false : allowSpecialFloatingPointValues;
    useAlternativeNames = useAlternativeNames === VOID ? true : useAlternativeNames;
    namingStrategy = namingStrategy === VOID ? null : namingStrategy;
    decodeEnumsCaseInsensitive = decodeEnumsCaseInsensitive === VOID ? false : decodeEnumsCaseInsensitive;
    allowTrailingComma = allowTrailingComma === VOID ? false : allowTrailingComma;
    this.q1p_1 = encodeDefaults;
    this.r1p_1 = ignoreUnknownKeys;
    this.s1p_1 = isLenient;
    this.t1p_1 = allowStructuredMapKeys;
    this.u1p_1 = prettyPrint;
    this.v1p_1 = explicitNulls;
    this.w1p_1 = prettyPrintIndent;
    this.x1p_1 = coerceInputValues;
    this.y1p_1 = useArrayPolymorphism;
    this.z1p_1 = classDiscriminator;
    this.a1q_1 = allowSpecialFloatingPointValues;
    this.b1q_1 = useAlternativeNames;
    this.c1q_1 = namingStrategy;
    this.d1q_1 = decodeEnumsCaseInsensitive;
    this.e1q_1 = allowTrailingComma;
  }
  protoOf(JsonConfiguration).toString = function () {
    return 'JsonConfiguration(encodeDefaults=' + this.q1p_1 + ', ignoreUnknownKeys=' + this.r1p_1 + ', isLenient=' + this.s1p_1 + ', ' + ('allowStructuredMapKeys=' + this.t1p_1 + ', prettyPrint=' + this.u1p_1 + ', explicitNulls=' + this.v1p_1 + ', ') + ("prettyPrintIndent='" + this.w1p_1 + "', coerceInputValues=" + this.x1p_1 + ', useArrayPolymorphism=' + this.y1p_1 + ', ') + ("classDiscriminator='" + this.z1p_1 + "', allowSpecialFloatingPointValues=" + this.a1q_1 + ', useAlternativeNames=' + this.b1q_1 + ', ') + ('namingStrategy=' + this.c1q_1 + ', decodeEnumsCaseInsensitive=' + this.d1q_1 + ', allowTrailingComma=' + this.e1q_1 + ')');
  };
  function JsonDecoder() {
  }
  function get_jsonUnquotedLiteralDescriptor() {
    _init_properties_JsonElement_kt__7cbdc2();
    return jsonUnquotedLiteralDescriptor;
  }
  var jsonUnquotedLiteralDescriptor;
  function Companion() {
  }
  var Companion_instance_0;
  function Companion_getInstance_4() {
    return Companion_instance_0;
  }
  function JsonElement() {
  }
  function Companion_0() {
  }
  var Companion_instance_1;
  function Companion_getInstance_5() {
    return Companion_instance_1;
  }
  function JsonObject$toString$lambda(_name_for_destructuring_parameter_0__wldtmu) {
    // Inline function 'kotlin.collections.component1' call
    var k = _name_for_destructuring_parameter_0__wldtmu.e2();
    // Inline function 'kotlin.collections.component2' call
    var v = _name_for_destructuring_parameter_0__wldtmu.f2();
    // Inline function 'kotlin.text.buildString' call
    // Inline function 'kotlin.contracts.contract' call
    // Inline function 'kotlin.apply' call
    var this_0 = StringBuilder_init_$Create$();
    // Inline function 'kotlin.contracts.contract' call
    // Inline function 'kotlinx.serialization.json.JsonObject.toString.<anonymous>.<anonymous>' call
    printQuoted(this_0, k);
    this_0.k5(_Char___init__impl__6a9atx(58));
    this_0.i5(v);
    return this_0.toString();
  }
  function JsonObject(content) {
    JsonElement.call(this);
    this.h1q_1 = content;
  }
  protoOf(JsonObject).b2 = function () {
    return this.h1q_1.b2();
  };
  protoOf(JsonObject).z1 = function () {
    return this.h1q_1.z1();
  };
  protoOf(JsonObject).n = function () {
    return this.h1q_1.n();
  };
  protoOf(JsonObject).a2 = function () {
    return this.h1q_1.a2();
  };
  protoOf(JsonObject).i1q = function (key) {
    return this.h1q_1.j2(key);
  };
  protoOf(JsonObject).j2 = function (key) {
    if (!(!(key == null) ? typeof key === 'string' : false))
      return false;
    return this.i1q((!(key == null) ? typeof key === 'string' : false) ? key : THROW_CCE());
  };
  protoOf(JsonObject).j1q = function (key) {
    return this.h1q_1.m2(key);
  };
  protoOf(JsonObject).m2 = function (key) {
    if (!(!(key == null) ? typeof key === 'string' : false))
      return null;
    return this.j1q((!(key == null) ? typeof key === 'string' : false) ? key : THROW_CCE());
  };
  protoOf(JsonObject).b1 = function () {
    return this.h1q_1.b1();
  };
  protoOf(JsonObject).equals = function (other) {
    return equals(this.h1q_1, other);
  };
  protoOf(JsonObject).hashCode = function () {
    return hashCode(this.h1q_1);
  };
  protoOf(JsonObject).toString = function () {
    var tmp = this.h1q_1.b2();
    return joinToString(tmp, ',', '{', '}', VOID, VOID, JsonObject$toString$lambda);
  };
  function JsonNull$_anonymous__enib48() {
    return JsonNullSerializer_getInstance();
  }
  function JsonNull() {
    JsonNull_instance = this;
    JsonPrimitive.call(this);
    this.k1q_1 = 'null';
    var tmp = this;
    var tmp_0 = LazyThreadSafetyMode_PUBLICATION_getInstance();
    tmp.l1q_1 = lazy(tmp_0, JsonNull$_anonymous__enib48);
  }
  protoOf(JsonNull).m1q = function () {
    return this.k1q_1;
  };
  var JsonNull_instance;
  function JsonNull_getInstance() {
    if (JsonNull_instance == null)
      new JsonNull();
    return JsonNull_instance;
  }
  function Companion_1() {
  }
  var Companion_instance_2;
  function Companion_getInstance_6() {
    return Companion_instance_2;
  }
  function JsonPrimitive() {
    JsonElement.call(this);
  }
  protoOf(JsonPrimitive).toString = function () {
    return this.m1q();
  };
  function JsonPrimitive_0(value) {
    _init_properties_JsonElement_kt__7cbdc2();
    if (value == null)
      return JsonNull_getInstance();
    return new JsonLiteral(value, false);
  }
  function JsonPrimitive_1(value) {
    _init_properties_JsonElement_kt__7cbdc2();
    if (value == null)
      return JsonNull_getInstance();
    return new JsonLiteral(value, false);
  }
  function JsonPrimitive_2(value) {
    _init_properties_JsonElement_kt__7cbdc2();
    if (value == null)
      return JsonNull_getInstance();
    return new JsonLiteral(value, true);
  }
  function JsonLiteral(body, isString, coerceToInlineType) {
    coerceToInlineType = coerceToInlineType === VOID ? null : coerceToInlineType;
    JsonPrimitive.call(this);
    this.n1q_1 = isString;
    this.o1q_1 = coerceToInlineType;
    this.p1q_1 = toString(body);
    if (!(this.o1q_1 == null)) {
      // Inline function 'kotlin.require' call
      // Inline function 'kotlin.contracts.contract' call
      // Inline function 'kotlin.require' call
      // Inline function 'kotlin.contracts.contract' call
      if (!this.o1q_1.c19()) {
        // Inline function 'kotlin.require.<anonymous>' call
        var message = 'Failed requirement.';
        throw IllegalArgumentException_init_$Create$(toString(message));
      }
    }
  }
  protoOf(JsonLiteral).m1q = function () {
    return this.p1q_1;
  };
  protoOf(JsonLiteral).toString = function () {
    var tmp;
    if (this.n1q_1) {
      // Inline function 'kotlin.text.buildString' call
      // Inline function 'kotlin.contracts.contract' call
      // Inline function 'kotlin.apply' call
      var this_0 = StringBuilder_init_$Create$();
      // Inline function 'kotlin.contracts.contract' call
      // Inline function 'kotlinx.serialization.json.JsonLiteral.toString.<anonymous>' call
      printQuoted(this_0, this.p1q_1);
      tmp = this_0.toString();
    } else {
      tmp = this.p1q_1;
    }
    return tmp;
  };
  protoOf(JsonLiteral).equals = function (other) {
    if (this === other)
      return true;
    if (other == null ? true : !getKClassFromExpression(this).equals(getKClassFromExpression(other)))
      return false;
    if (!(other instanceof JsonLiteral))
      THROW_CCE();
    if (!(this.n1q_1 === other.n1q_1))
      return false;
    if (!(this.p1q_1 === other.p1q_1))
      return false;
    return true;
  };
  protoOf(JsonLiteral).hashCode = function () {
    var result = getBooleanHashCode(this.n1q_1);
    result = imul(31, result) + getStringHashCode(this.p1q_1) | 0;
    return result;
  };
  function Companion_2() {
  }
  var Companion_instance_3;
  function Companion_getInstance_7() {
    return Companion_instance_3;
  }
  function JsonArray(content) {
    JsonElement.call(this);
    this.q1q_1 = content;
  }
  protoOf(JsonArray).n = function () {
    return this.q1q_1.n();
  };
  protoOf(JsonArray).r1q = function (element) {
    return this.q1q_1.z(element);
  };
  protoOf(JsonArray).z = function (element) {
    if (!(element instanceof JsonElement))
      return false;
    return this.r1q(element instanceof JsonElement ? element : THROW_CCE());
  };
  protoOf(JsonArray).s1q = function (elements) {
    return this.q1q_1.a1(elements);
  };
  protoOf(JsonArray).a1 = function (elements) {
    return this.s1q(elements);
  };
  protoOf(JsonArray).f1 = function (index) {
    return this.q1q_1.f1(index);
  };
  protoOf(JsonArray).b1 = function () {
    return this.q1q_1.b1();
  };
  protoOf(JsonArray).u = function () {
    return this.q1q_1.u();
  };
  protoOf(JsonArray).equals = function (other) {
    return equals(this.q1q_1, other);
  };
  protoOf(JsonArray).hashCode = function () {
    return hashCode(this.q1q_1);
  };
  protoOf(JsonArray).toString = function () {
    return joinToString(this.q1q_1, ',', '[', ']');
  };
  function get_booleanOrNull(_this__u8e3s4) {
    _init_properties_JsonElement_kt__7cbdc2();
    return toBooleanStrictOrNull_0(_this__u8e3s4.m1q());
  }
  function get_int(_this__u8e3s4) {
    _init_properties_JsonElement_kt__7cbdc2();
    // Inline function 'kotlinx.serialization.json.mapExceptions' call
    var tmp;
    try {
      // Inline function 'kotlinx.serialization.json.<get-int>.<anonymous>' call
      tmp = (new StringJsonLexer(_this__u8e3s4.m1q())).t1q();
    } catch ($p) {
      var tmp_0;
      if ($p instanceof JsonDecodingException) {
        var e = $p;
        throw NumberFormatException_init_$Create$(e.message);
      } else {
        throw $p;
      }
    }
    var result = tmp;
    // Inline function 'kotlin.ranges.contains' call
    var this_0 = numberRangeToNumber(IntCompanionObject_instance.MIN_VALUE, IntCompanionObject_instance.MAX_VALUE);
    if (!contains(isInterface(this_0, ClosedRange) ? this_0 : THROW_CCE(), result))
      throw NumberFormatException_init_$Create$(_this__u8e3s4.m1q() + ' is not an Int');
    return result.q8();
  }
  function get_long(_this__u8e3s4) {
    _init_properties_JsonElement_kt__7cbdc2();
    // Inline function 'kotlinx.serialization.json.mapExceptions' call
    var tmp;
    try {
      // Inline function 'kotlinx.serialization.json.<get-long>.<anonymous>' call
      tmp = (new StringJsonLexer(_this__u8e3s4.m1q())).t1q();
    } catch ($p) {
      var tmp_0;
      if ($p instanceof JsonDecodingException) {
        var e = $p;
        throw NumberFormatException_init_$Create$(e.message);
      } else {
        throw $p;
      }
    }
    return tmp;
  }
  function get_float(_this__u8e3s4) {
    _init_properties_JsonElement_kt__7cbdc2();
    // Inline function 'kotlin.text.toFloat' call
    var this_0 = _this__u8e3s4.m1q();
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    return toDouble(this_0);
  }
  function get_double(_this__u8e3s4) {
    _init_properties_JsonElement_kt__7cbdc2();
    return toDouble(_this__u8e3s4.m1q());
  }
  function get_contentOrNull(_this__u8e3s4) {
    _init_properties_JsonElement_kt__7cbdc2();
    var tmp;
    if (_this__u8e3s4 instanceof JsonNull) {
      tmp = null;
    } else {
      tmp = _this__u8e3s4.m1q();
    }
    return tmp;
  }
  function get_jsonPrimitive(_this__u8e3s4) {
    _init_properties_JsonElement_kt__7cbdc2();
    var tmp0_elvis_lhs = _this__u8e3s4 instanceof JsonPrimitive ? _this__u8e3s4 : null;
    var tmp;
    if (tmp0_elvis_lhs == null) {
      error(_this__u8e3s4, 'JsonPrimitive');
    } else {
      tmp = tmp0_elvis_lhs;
    }
    return tmp;
  }
  function error(_this__u8e3s4, element) {
    _init_properties_JsonElement_kt__7cbdc2();
    throw IllegalArgumentException_init_$Create$('Element ' + getKClassFromExpression(_this__u8e3s4) + ' is not a ' + element);
  }
  function get_boolean(_this__u8e3s4) {
    _init_properties_JsonElement_kt__7cbdc2();
    var tmp0_elvis_lhs = toBooleanStrictOrNull_0(_this__u8e3s4.m1q());
    var tmp;
    if (tmp0_elvis_lhs == null) {
      throw IllegalStateException_init_$Create$('' + _this__u8e3s4 + ' does not represent a Boolean');
    } else {
      tmp = tmp0_elvis_lhs;
    }
    return tmp;
  }
  var properties_initialized_JsonElement_kt_abxy8s;
  function _init_properties_JsonElement_kt__7cbdc2() {
    if (!properties_initialized_JsonElement_kt_abxy8s) {
      properties_initialized_JsonElement_kt_abxy8s = true;
      jsonUnquotedLiteralDescriptor = InlinePrimitiveDescriptor('kotlinx.serialization.json.JsonUnquotedLiteral', serializer(StringCompanionObject_instance));
    }
  }
  function JsonElementSerializer$descriptor$lambda($this$buildSerialDescriptor) {
    $this$buildSerialDescriptor.w19('JsonPrimitive', defer(JsonElementSerializer$descriptor$lambda$lambda));
    $this$buildSerialDescriptor.w19('JsonNull', defer(JsonElementSerializer$descriptor$lambda$lambda_0));
    $this$buildSerialDescriptor.w19('JsonLiteral', defer(JsonElementSerializer$descriptor$lambda$lambda_1));
    $this$buildSerialDescriptor.w19('JsonObject', defer(JsonElementSerializer$descriptor$lambda$lambda_2));
    $this$buildSerialDescriptor.w19('JsonArray', defer(JsonElementSerializer$descriptor$lambda$lambda_3));
    return Unit_instance;
  }
  function JsonElementSerializer$descriptor$lambda$lambda() {
    return JsonPrimitiveSerializer_getInstance().u1q_1;
  }
  function JsonElementSerializer$descriptor$lambda$lambda_0() {
    return JsonNullSerializer_getInstance().v1q_1;
  }
  function JsonElementSerializer$descriptor$lambda$lambda_1() {
    return JsonLiteralSerializer_getInstance().w1q_1;
  }
  function JsonElementSerializer$descriptor$lambda$lambda_2() {
    return JsonObjectSerializer_getInstance().x1q_1;
  }
  function JsonElementSerializer$descriptor$lambda$lambda_3() {
    return JsonArraySerializer_getInstance().y1q_1;
  }
  function JsonElementSerializer() {
    JsonElementSerializer_instance = this;
    var tmp = this;
    var tmp_0 = SEALED_getInstance();
    tmp.z1q_1 = buildSerialDescriptor('kotlinx.serialization.json.JsonElement', tmp_0, [], JsonElementSerializer$descriptor$lambda);
  }
  protoOf(JsonElementSerializer).p18 = function () {
    return this.z1q_1;
  };
  protoOf(JsonElementSerializer).a1r = function (encoder, value) {
    verify(encoder);
    if (value instanceof JsonPrimitive) {
      encoder.n1c(JsonPrimitiveSerializer_getInstance(), value);
    } else {
      if (value instanceof JsonObject) {
        encoder.n1c(JsonObjectSerializer_getInstance(), value);
      } else {
        if (value instanceof JsonArray) {
          encoder.n1c(JsonArraySerializer_getInstance(), value);
        }
      }
    }
  };
  protoOf(JsonElementSerializer).q18 = function (encoder, value) {
    return this.a1r(encoder, value instanceof JsonElement ? value : THROW_CCE());
  };
  protoOf(JsonElementSerializer).r18 = function (decoder) {
    var input = asJsonDecoder(decoder);
    return input.g1q();
  };
  var JsonElementSerializer_instance;
  function JsonElementSerializer_getInstance() {
    if (JsonElementSerializer_instance == null)
      new JsonElementSerializer();
    return JsonElementSerializer_instance;
  }
  function JsonObjectDescriptor() {
    JsonObjectDescriptor_instance = this;
    this.b1r_1 = MapSerializer(serializer(StringCompanionObject_instance), JsonElementSerializer_getInstance()).p18();
    this.c1r_1 = 'kotlinx.serialization.json.JsonObject';
  }
  protoOf(JsonObjectDescriptor).e19 = function () {
    return this.b1r_1.e19();
  };
  protoOf(JsonObjectDescriptor).d19 = function () {
    return this.b1r_1.d19();
  };
  protoOf(JsonObjectDescriptor).c19 = function () {
    return this.b1r_1.c19();
  };
  protoOf(JsonObjectDescriptor).b19 = function () {
    return this.b1r_1.b19();
  };
  protoOf(JsonObjectDescriptor).a19 = function () {
    return this.b1r_1.a19();
  };
  protoOf(JsonObjectDescriptor).h19 = function (index) {
    return this.b1r_1.h19(index);
  };
  protoOf(JsonObjectDescriptor).i19 = function (index) {
    return this.b1r_1.i19(index);
  };
  protoOf(JsonObjectDescriptor).g19 = function (name) {
    return this.b1r_1.g19(name);
  };
  protoOf(JsonObjectDescriptor).f19 = function (index) {
    return this.b1r_1.f19(index);
  };
  protoOf(JsonObjectDescriptor).j19 = function (index) {
    return this.b1r_1.j19(index);
  };
  protoOf(JsonObjectDescriptor).z18 = function () {
    return this.c1r_1;
  };
  var JsonObjectDescriptor_instance;
  function JsonObjectDescriptor_getInstance() {
    if (JsonObjectDescriptor_instance == null)
      new JsonObjectDescriptor();
    return JsonObjectDescriptor_instance;
  }
  function JsonObjectSerializer() {
    JsonObjectSerializer_instance = this;
    this.x1q_1 = JsonObjectDescriptor_getInstance();
  }
  protoOf(JsonObjectSerializer).p18 = function () {
    return this.x1q_1;
  };
  protoOf(JsonObjectSerializer).d1r = function (encoder, value) {
    verify(encoder);
    MapSerializer(serializer(StringCompanionObject_instance), JsonElementSerializer_getInstance()).q18(encoder, value);
  };
  protoOf(JsonObjectSerializer).q18 = function (encoder, value) {
    return this.d1r(encoder, value instanceof JsonObject ? value : THROW_CCE());
  };
  protoOf(JsonObjectSerializer).r18 = function (decoder) {
    verify_0(decoder);
    return new JsonObject(MapSerializer(serializer(StringCompanionObject_instance), JsonElementSerializer_getInstance()).r18(decoder));
  };
  var JsonObjectSerializer_instance;
  function JsonObjectSerializer_getInstance() {
    if (JsonObjectSerializer_instance == null)
      new JsonObjectSerializer();
    return JsonObjectSerializer_instance;
  }
  function JsonArrayDescriptor() {
    JsonArrayDescriptor_instance = this;
    this.e1r_1 = ListSerializer(JsonElementSerializer_getInstance()).p18();
    this.f1r_1 = 'kotlinx.serialization.json.JsonArray';
  }
  protoOf(JsonArrayDescriptor).e19 = function () {
    return this.e1r_1.e19();
  };
  protoOf(JsonArrayDescriptor).d19 = function () {
    return this.e1r_1.d19();
  };
  protoOf(JsonArrayDescriptor).c19 = function () {
    return this.e1r_1.c19();
  };
  protoOf(JsonArrayDescriptor).b19 = function () {
    return this.e1r_1.b19();
  };
  protoOf(JsonArrayDescriptor).a19 = function () {
    return this.e1r_1.a19();
  };
  protoOf(JsonArrayDescriptor).h19 = function (index) {
    return this.e1r_1.h19(index);
  };
  protoOf(JsonArrayDescriptor).i19 = function (index) {
    return this.e1r_1.i19(index);
  };
  protoOf(JsonArrayDescriptor).g19 = function (name) {
    return this.e1r_1.g19(name);
  };
  protoOf(JsonArrayDescriptor).f19 = function (index) {
    return this.e1r_1.f19(index);
  };
  protoOf(JsonArrayDescriptor).j19 = function (index) {
    return this.e1r_1.j19(index);
  };
  protoOf(JsonArrayDescriptor).z18 = function () {
    return this.f1r_1;
  };
  var JsonArrayDescriptor_instance;
  function JsonArrayDescriptor_getInstance() {
    if (JsonArrayDescriptor_instance == null)
      new JsonArrayDescriptor();
    return JsonArrayDescriptor_instance;
  }
  function JsonArraySerializer() {
    JsonArraySerializer_instance = this;
    this.y1q_1 = JsonArrayDescriptor_getInstance();
  }
  protoOf(JsonArraySerializer).p18 = function () {
    return this.y1q_1;
  };
  protoOf(JsonArraySerializer).g1r = function (encoder, value) {
    verify(encoder);
    ListSerializer(JsonElementSerializer_getInstance()).q18(encoder, value);
  };
  protoOf(JsonArraySerializer).q18 = function (encoder, value) {
    return this.g1r(encoder, value instanceof JsonArray ? value : THROW_CCE());
  };
  protoOf(JsonArraySerializer).r18 = function (decoder) {
    verify_0(decoder);
    return new JsonArray(ListSerializer(JsonElementSerializer_getInstance()).r18(decoder));
  };
  var JsonArraySerializer_instance;
  function JsonArraySerializer_getInstance() {
    if (JsonArraySerializer_instance == null)
      new JsonArraySerializer();
    return JsonArraySerializer_instance;
  }
  function defer(deferred) {
    return new defer$1(deferred);
  }
  function JsonPrimitiveSerializer() {
    JsonPrimitiveSerializer_instance = this;
    this.u1q_1 = buildSerialDescriptor('kotlinx.serialization.json.JsonPrimitive', STRING_getInstance(), []);
  }
  protoOf(JsonPrimitiveSerializer).p18 = function () {
    return this.u1q_1;
  };
  protoOf(JsonPrimitiveSerializer).h1r = function (encoder, value) {
    verify(encoder);
    var tmp;
    if (value instanceof JsonNull) {
      encoder.n1c(JsonNullSerializer_getInstance(), JsonNull_getInstance());
      tmp = Unit_instance;
    } else {
      var tmp_0 = JsonLiteralSerializer_getInstance();
      encoder.n1c(tmp_0, value instanceof JsonLiteral ? value : THROW_CCE());
      tmp = Unit_instance;
    }
    return tmp;
  };
  protoOf(JsonPrimitiveSerializer).q18 = function (encoder, value) {
    return this.h1r(encoder, value instanceof JsonPrimitive ? value : THROW_CCE());
  };
  protoOf(JsonPrimitiveSerializer).r18 = function (decoder) {
    var result = asJsonDecoder(decoder).g1q();
    if (!(result instanceof JsonPrimitive))
      throw JsonDecodingException_0(-1, 'Unexpected JSON element, expected JsonPrimitive, had ' + getKClassFromExpression(result), toString(result));
    return result;
  };
  var JsonPrimitiveSerializer_instance;
  function JsonPrimitiveSerializer_getInstance() {
    if (JsonPrimitiveSerializer_instance == null)
      new JsonPrimitiveSerializer();
    return JsonPrimitiveSerializer_instance;
  }
  function JsonNullSerializer() {
    JsonNullSerializer_instance = this;
    this.v1q_1 = buildSerialDescriptor('kotlinx.serialization.json.JsonNull', ENUM_getInstance(), []);
  }
  protoOf(JsonNullSerializer).p18 = function () {
    return this.v1q_1;
  };
  protoOf(JsonNullSerializer).i1r = function (encoder, value) {
    verify(encoder);
    encoder.s1b();
  };
  protoOf(JsonNullSerializer).q18 = function (encoder, value) {
    return this.i1r(encoder, value instanceof JsonNull ? value : THROW_CCE());
  };
  protoOf(JsonNullSerializer).r18 = function (decoder) {
    verify_0(decoder);
    if (decoder.l1a()) {
      throw new JsonDecodingException("Expected 'null' literal");
    }
    decoder.m1a();
    return JsonNull_getInstance();
  };
  var JsonNullSerializer_instance;
  function JsonNullSerializer_getInstance() {
    if (JsonNullSerializer_instance == null)
      new JsonNullSerializer();
    return JsonNullSerializer_instance;
  }
  function JsonLiteralSerializer() {
    JsonLiteralSerializer_instance = this;
    this.w1q_1 = PrimitiveSerialDescriptor('kotlinx.serialization.json.JsonLiteral', STRING_getInstance());
  }
  protoOf(JsonLiteralSerializer).p18 = function () {
    return this.w1q_1;
  };
  protoOf(JsonLiteralSerializer).j1r = function (encoder, value) {
    verify(encoder);
    if (value.n1q_1) {
      return encoder.b1c(value.p1q_1);
    }
    if (!(value.o1q_1 == null)) {
      return encoder.c1c(value.o1q_1).b1c(value.p1q_1);
    }
    var tmp0_safe_receiver = toLongOrNull(value.p1q_1);
    if (tmp0_safe_receiver == null)
      null;
    else {
      // Inline function 'kotlin.let' call
      // Inline function 'kotlin.contracts.contract' call
      return encoder.x1b(tmp0_safe_receiver);
    }
    var tmp1_safe_receiver = toULongOrNull(value.p1q_1);
    var tmp = tmp1_safe_receiver;
    if ((tmp == null ? null : new ULong(tmp)) == null)
      null;
    else {
      // Inline function 'kotlin.let' call
      var tmp_0 = tmp1_safe_receiver;
      // Inline function 'kotlin.contracts.contract' call
      var it = (tmp_0 == null ? null : new ULong(tmp_0)).eh_1;
      var tmp_1 = encoder.c1c(serializer_0(Companion_getInstance()).p18());
      // Inline function 'kotlin.ULong.toLong' call
      var tmp$ret$1 = _ULong___get_data__impl__fggpzb(it);
      tmp_1.x1b(tmp$ret$1);
      return Unit_instance;
    }
    var tmp2_safe_receiver = toDoubleOrNull(value.p1q_1);
    if (tmp2_safe_receiver == null)
      null;
    else {
      // Inline function 'kotlin.let' call
      // Inline function 'kotlin.contracts.contract' call
      return encoder.z1b(tmp2_safe_receiver);
    }
    var tmp3_safe_receiver = toBooleanStrictOrNull(value.p1q_1);
    if (tmp3_safe_receiver == null)
      null;
    else {
      // Inline function 'kotlin.let' call
      // Inline function 'kotlin.contracts.contract' call
      return encoder.t1b(tmp3_safe_receiver);
    }
    encoder.b1c(value.p1q_1);
  };
  protoOf(JsonLiteralSerializer).q18 = function (encoder, value) {
    return this.j1r(encoder, value instanceof JsonLiteral ? value : THROW_CCE());
  };
  protoOf(JsonLiteralSerializer).r18 = function (decoder) {
    var result = asJsonDecoder(decoder).g1q();
    if (!(result instanceof JsonLiteral))
      throw JsonDecodingException_0(-1, 'Unexpected JSON element, expected JsonLiteral, had ' + getKClassFromExpression(result), toString(result));
    return result;
  };
  var JsonLiteralSerializer_instance;
  function JsonLiteralSerializer_getInstance() {
    if (JsonLiteralSerializer_instance == null)
      new JsonLiteralSerializer();
    return JsonLiteralSerializer_instance;
  }
  function verify(encoder) {
    asJsonEncoder(encoder);
  }
  function asJsonDecoder(_this__u8e3s4) {
    var tmp0_elvis_lhs = isInterface(_this__u8e3s4, JsonDecoder) ? _this__u8e3s4 : null;
    var tmp;
    if (tmp0_elvis_lhs == null) {
      throw IllegalStateException_init_$Create$('This serializer can be used only with Json format.' + ('Expected Decoder to be JsonDecoder, got ' + getKClassFromExpression(_this__u8e3s4)));
    } else {
      tmp = tmp0_elvis_lhs;
    }
    return tmp;
  }
  function verify_0(decoder) {
    asJsonDecoder(decoder);
  }
  function asJsonEncoder(_this__u8e3s4) {
    var tmp0_elvis_lhs = isInterface(_this__u8e3s4, JsonEncoder) ? _this__u8e3s4 : null;
    var tmp;
    if (tmp0_elvis_lhs == null) {
      throw IllegalStateException_init_$Create$('This serializer can be used only with Json format.' + ('Expected Encoder to be JsonEncoder, got ' + getKClassFromExpression(_this__u8e3s4)));
    } else {
      tmp = tmp0_elvis_lhs;
    }
    return tmp;
  }
  function _get_original__l7ku1m($this) {
    // Inline function 'kotlin.getValue' call
    var this_0 = $this.k1r_1;
    original$factory();
    return this_0.f2();
  }
  function defer$1($deferred) {
    this.k1r_1 = lazy_0($deferred);
  }
  protoOf(defer$1).z18 = function () {
    return _get_original__l7ku1m(this).z18();
  };
  protoOf(defer$1).a19 = function () {
    return _get_original__l7ku1m(this).a19();
  };
  protoOf(defer$1).d19 = function () {
    return _get_original__l7ku1m(this).d19();
  };
  protoOf(defer$1).f19 = function (index) {
    return _get_original__l7ku1m(this).f19(index);
  };
  protoOf(defer$1).g19 = function (name) {
    return _get_original__l7ku1m(this).g19(name);
  };
  protoOf(defer$1).h19 = function (index) {
    return _get_original__l7ku1m(this).h19(index);
  };
  protoOf(defer$1).i19 = function (index) {
    return _get_original__l7ku1m(this).i19(index);
  };
  protoOf(defer$1).j19 = function (index) {
    return _get_original__l7ku1m(this).j19(index);
  };
  function original$factory() {
    return getPropertyCallableRef('original', 1, KProperty1, function (receiver) {
      return _get_original__l7ku1m(receiver);
    }, null);
  }
  function JsonEncoder() {
  }
  function Composer(writer) {
    this.l1r_1 = writer;
    this.m1r_1 = true;
  }
  protoOf(Composer).n1r = function () {
    this.m1r_1 = true;
  };
  protoOf(Composer).o1r = function () {
    return Unit_instance;
  };
  protoOf(Composer).p1r = function () {
    this.m1r_1 = false;
  };
  protoOf(Composer).q1r = function () {
    return Unit_instance;
  };
  protoOf(Composer).r1r = function (v) {
    return this.l1r_1.s1r(v);
  };
  protoOf(Composer).t1r = function (v) {
    return this.l1r_1.u1r(v);
  };
  protoOf(Composer).v1r = function (v) {
    return this.l1r_1.u1r(v.toString());
  };
  protoOf(Composer).w1r = function (v) {
    return this.l1r_1.u1r(v.toString());
  };
  protoOf(Composer).x1r = function (v) {
    return this.l1r_1.y1r(toLong(v));
  };
  protoOf(Composer).z1r = function (v) {
    return this.l1r_1.y1r(toLong(v));
  };
  protoOf(Composer).a1s = function (v) {
    return this.l1r_1.y1r(toLong(v));
  };
  protoOf(Composer).b1s = function (v) {
    return this.l1r_1.y1r(v);
  };
  protoOf(Composer).c1s = function (v) {
    return this.l1r_1.u1r(v.toString());
  };
  protoOf(Composer).d1s = function (value) {
    return this.l1r_1.e1s(value);
  };
  function Composer_0(sb, json) {
    return json.h1o_1.u1p_1 ? new ComposerWithPrettyPrint(sb, json) : new Composer(sb);
  }
  function ComposerForUnsignedNumbers(writer, forceQuoting) {
    Composer.call(this, writer);
    this.h1s_1 = forceQuoting;
  }
  protoOf(ComposerForUnsignedNumbers).a1s = function (v) {
    if (this.h1s_1) {
      // Inline function 'kotlin.toUInt' call
      var tmp$ret$0 = _UInt___init__impl__l7qpdl(v);
      this.d1s(UInt__toString_impl_dbgl21(tmp$ret$0));
    } else {
      // Inline function 'kotlin.toUInt' call
      var tmp$ret$1 = _UInt___init__impl__l7qpdl(v);
      this.t1r(UInt__toString_impl_dbgl21(tmp$ret$1));
    }
  };
  protoOf(ComposerForUnsignedNumbers).b1s = function (v) {
    if (this.h1s_1) {
      // Inline function 'kotlin.toULong' call
      var tmp$ret$0 = _ULong___init__impl__c78o9k(v);
      this.d1s(ULong__toString_impl_f9au7k(tmp$ret$0));
    } else {
      // Inline function 'kotlin.toULong' call
      var tmp$ret$1 = _ULong___init__impl__c78o9k(v);
      this.t1r(ULong__toString_impl_f9au7k(tmp$ret$1));
    }
  };
  protoOf(ComposerForUnsignedNumbers).x1r = function (v) {
    if (this.h1s_1) {
      // Inline function 'kotlin.toUByte' call
      var tmp$ret$0 = _UByte___init__impl__g9hnc4(v);
      this.d1s(UByte__toString_impl_v72jg(tmp$ret$0));
    } else {
      // Inline function 'kotlin.toUByte' call
      var tmp$ret$1 = _UByte___init__impl__g9hnc4(v);
      this.t1r(UByte__toString_impl_v72jg(tmp$ret$1));
    }
  };
  protoOf(ComposerForUnsignedNumbers).z1r = function (v) {
    if (this.h1s_1) {
      // Inline function 'kotlin.toUShort' call
      var tmp$ret$0 = _UShort___init__impl__jigrne(v);
      this.d1s(UShort__toString_impl_edaoee(tmp$ret$0));
    } else {
      // Inline function 'kotlin.toUShort' call
      var tmp$ret$1 = _UShort___init__impl__jigrne(v);
      this.t1r(UShort__toString_impl_edaoee(tmp$ret$1));
    }
  };
  function ComposerForUnquotedLiterals(writer, forceQuoting) {
    Composer.call(this, writer);
    this.k1s_1 = forceQuoting;
  }
  protoOf(ComposerForUnquotedLiterals).d1s = function (value) {
    if (this.k1s_1) {
      protoOf(Composer).d1s.call(this, value);
    } else {
      protoOf(Composer).t1r.call(this, value);
    }
  };
  function ComposerWithPrettyPrint(writer, json) {
    Composer.call(this, writer);
    this.n1s_1 = json;
    this.o1s_1 = 0;
  }
  protoOf(ComposerWithPrettyPrint).n1r = function () {
    this.m1r_1 = true;
    this.o1s_1 = this.o1s_1 + 1 | 0;
  };
  protoOf(ComposerWithPrettyPrint).o1r = function () {
    this.o1s_1 = this.o1s_1 - 1 | 0;
  };
  protoOf(ComposerWithPrettyPrint).p1r = function () {
    this.m1r_1 = false;
    this.t1r('\n');
    // Inline function 'kotlin.repeat' call
    var times = this.o1s_1;
    // Inline function 'kotlin.contracts.contract' call
    var inductionVariable = 0;
    if (inductionVariable < times)
      do {
        var index = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        // Inline function 'kotlinx.serialization.json.internal.ComposerWithPrettyPrint.nextItem.<anonymous>' call
        this.t1r(this.n1s_1.h1o_1.w1p_1);
      }
       while (inductionVariable < times);
  };
  protoOf(ComposerWithPrettyPrint).q1r = function () {
    this.r1r(_Char___init__impl__6a9atx(32));
  };
  function readIfAbsent($this, descriptor, index) {
    $this.q1s_1 = !descriptor.j19(index) ? descriptor.i19(index).b19() : false;
    return $this.q1s_1;
  }
  function JsonElementMarker$readIfAbsent$ref($boundThis) {
    var l = function (p0, p1) {
      return readIfAbsent($boundThis, p0, p1);
    };
    l.callableName = 'readIfAbsent';
    return l;
  }
  function JsonElementMarker(descriptor) {
    var tmp = this;
    tmp.p1s_1 = new ElementMarker(descriptor, JsonElementMarker$readIfAbsent$ref(this));
    this.q1s_1 = false;
  }
  protoOf(JsonElementMarker).m1f = function (index) {
    this.p1s_1.m1f(index);
  };
  protoOf(JsonElementMarker).n1f = function () {
    return this.p1s_1.n1f();
  };
  function invalidTrailingComma(_this__u8e3s4, entity) {
    entity = entity === VOID ? 'object' : entity;
    _this__u8e3s4.r1s('Trailing comma before the end of JSON ' + entity, _this__u8e3s4.v1o_1 - 1 | 0, "Trailing commas are non-complaint JSON and not allowed by default. Use 'allowTrailingCommas = true' in 'Json {}' builder to support them.");
  }
  function throwInvalidFloatingPointDecoded(_this__u8e3s4, result) {
    _this__u8e3s4.s1s('Unexpected special floating-point value ' + toString(result) + '. By default, ' + 'non-finite floating point values are prohibited because they do not conform JSON specification', VOID, get_specialFlowingValuesHint());
  }
  function JsonEncodingException(message) {
    JsonException.call(this, message);
    captureStack(this, JsonEncodingException);
  }
  function InvalidKeyKindException(keyDescriptor) {
    return new JsonEncodingException("Value of type '" + keyDescriptor.z18() + "' can't be used in JSON as a key in the map. " + ("It should have either primitive or enum kind, but its kind is '" + keyDescriptor.a19() + "'.\n") + get_allowStructuredMapKeysHint());
  }
  function JsonDecodingException(message) {
    JsonException.call(this, message);
    captureStack(this, JsonDecodingException);
  }
  function JsonDecodingException_0(offset, message, input) {
    return JsonDecodingException_1(offset, message + '\nJSON input: ' + minify(input, offset));
  }
  function InvalidFloatingPointDecoded(value, key, output) {
    return JsonDecodingException_1(-1, unexpectedFpErrorMessage(value, key, output));
  }
  function JsonDecodingException_1(offset, message) {
    return new JsonDecodingException(offset >= 0 ? 'Unexpected JSON token at offset ' + offset + ': ' + message : message);
  }
  function UnknownKeyException(key, input) {
    return JsonDecodingException_1(-1, "Encountered an unknown key '" + key + "'.\n" + (get_ignoreUnknownKeysHint() + '\n') + ('Current input: ' + minify(input)));
  }
  function InvalidFloatingPointEncoded(value, output) {
    return new JsonEncodingException('Unexpected special floating-point value ' + toString(value) + '. By default, ' + 'non-finite floating point values are prohibited because they do not conform JSON specification. ' + (get_specialFlowingValuesHint() + '\n') + ('Current output: ' + minify(output)));
  }
  function JsonException(message) {
    SerializationException_init_$Init$(message, this);
    captureStack(this, JsonException);
  }
  function unexpectedFpErrorMessage(value, key, output) {
    return 'Unexpected special floating-point value ' + toString(value) + ' with key ' + key + '. By default, ' + 'non-finite floating point values are prohibited because they do not conform JSON specification. ' + (get_specialFlowingValuesHint() + '\n') + ('Current output: ' + minify(output));
  }
  function minify(_this__u8e3s4, offset) {
    offset = offset === VOID ? -1 : offset;
    if (charSequenceLength(_this__u8e3s4) < 200)
      return _this__u8e3s4;
    if (offset === -1) {
      var start = charSequenceLength(_this__u8e3s4) - 60 | 0;
      if (start <= 0)
        return _this__u8e3s4;
      // Inline function 'kotlin.text.substring' call
      var endIndex = charSequenceLength(_this__u8e3s4);
      return '.....' + toString(charSequenceSubSequence(_this__u8e3s4, start, endIndex));
    }
    var start_0 = offset - 30 | 0;
    var end = offset + 30 | 0;
    var prefix = start_0 <= 0 ? '' : '.....';
    var suffix = end >= charSequenceLength(_this__u8e3s4) ? '' : '.....';
    // Inline function 'kotlin.text.substring' call
    var startIndex = coerceAtLeast(start_0, 0);
    var endIndex_0 = coerceAtMost(end, charSequenceLength(_this__u8e3s4));
    return prefix + toString(charSequenceSubSequence(_this__u8e3s4, startIndex, endIndex_0)) + suffix;
  }
  function get_JsonDeserializationNamesKey() {
    _init_properties_JsonNamesMap_kt__cbbp0k();
    return JsonDeserializationNamesKey;
  }
  var JsonDeserializationNamesKey;
  function get_JsonSerializationNamesKey() {
    _init_properties_JsonNamesMap_kt__cbbp0k();
    return JsonSerializationNamesKey;
  }
  var JsonSerializationNamesKey;
  function getJsonNameIndex(_this__u8e3s4, json, name) {
    _init_properties_JsonNamesMap_kt__cbbp0k();
    if (decodeCaseInsensitive(json, _this__u8e3s4)) {
      // Inline function 'kotlin.text.lowercase' call
      // Inline function 'kotlin.js.asDynamic' call
      var tmp$ret$1 = name.toLowerCase();
      return getJsonNameIndexSlowPath(_this__u8e3s4, json, tmp$ret$1);
    }
    var strategy = namingStrategy(_this__u8e3s4, json);
    if (!(strategy == null))
      return getJsonNameIndexSlowPath(_this__u8e3s4, json, name);
    var index = _this__u8e3s4.g19(name);
    if (!(index === -3))
      return index;
    if (!json.h1o_1.b1q_1)
      return index;
    return getJsonNameIndexSlowPath(_this__u8e3s4, json, name);
  }
  function getJsonElementName(_this__u8e3s4, json, index) {
    _init_properties_JsonNamesMap_kt__cbbp0k();
    var strategy = namingStrategy(_this__u8e3s4, json);
    return strategy == null ? _this__u8e3s4.f19(index) : serializationNamesIndices(_this__u8e3s4, json, strategy)[index];
  }
  function namingStrategy(_this__u8e3s4, json) {
    _init_properties_JsonNamesMap_kt__cbbp0k();
    return equals(_this__u8e3s4.a19(), CLASS_getInstance()) ? json.h1o_1.c1q_1 : null;
  }
  function deserializationNamesMap(_this__u8e3s4, descriptor) {
    _init_properties_JsonNamesMap_kt__cbbp0k();
    var tmp = get_schemaCache(_this__u8e3s4);
    var tmp_0 = get_JsonDeserializationNamesKey();
    return tmp.u1s(descriptor, tmp_0, deserializationNamesMap$lambda(descriptor, _this__u8e3s4));
  }
  function decodeCaseInsensitive(_this__u8e3s4, descriptor) {
    _init_properties_JsonNamesMap_kt__cbbp0k();
    return _this__u8e3s4.h1o_1.d1q_1 ? equals(descriptor.a19(), ENUM_getInstance()) : false;
  }
  function getJsonNameIndexSlowPath(_this__u8e3s4, json, name) {
    _init_properties_JsonNamesMap_kt__cbbp0k();
    var tmp0_elvis_lhs = deserializationNamesMap(json, _this__u8e3s4).m2(name);
    var tmp;
    if (tmp0_elvis_lhs == null) {
      tmp = -3;
    } else {
      tmp = tmp0_elvis_lhs;
    }
    return tmp;
  }
  function serializationNamesIndices(_this__u8e3s4, json, strategy) {
    _init_properties_JsonNamesMap_kt__cbbp0k();
    var tmp = get_schemaCache(json);
    var tmp_0 = get_JsonSerializationNamesKey();
    return tmp.u1s(_this__u8e3s4, tmp_0, serializationNamesIndices$lambda(_this__u8e3s4, strategy));
  }
  function buildDeserializationNamesMap(_this__u8e3s4, json) {
    _init_properties_JsonNamesMap_kt__cbbp0k();
    // Inline function 'kotlin.collections.mutableMapOf' call
    var builder = LinkedHashMap_init_$Create$();
    var useLowercaseEnums = decodeCaseInsensitive(json, _this__u8e3s4);
    var strategyForClasses = namingStrategy(_this__u8e3s4, json);
    var inductionVariable = 0;
    var last = _this__u8e3s4.d19();
    if (inductionVariable < last)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        // Inline function 'kotlin.collections.filterIsInstance' call
        // Inline function 'kotlin.collections.filterIsInstanceTo' call
        var this_0 = _this__u8e3s4.h19(i);
        var destination = ArrayList_init_$Create$();
        var tmp0_iterator = this_0.u();
        while (tmp0_iterator.v()) {
          var element = tmp0_iterator.w();
          if (element instanceof JsonNames) {
            destination.r(element);
          }
        }
        var tmp1_safe_receiver = singleOrNull(destination);
        var tmp2_safe_receiver = tmp1_safe_receiver == null ? null : tmp1_safe_receiver.v1s_1;
        if (tmp2_safe_receiver == null)
          null;
        else {
          // Inline function 'kotlin.collections.forEach' call
          var inductionVariable_0 = 0;
          var last_0 = tmp2_safe_receiver.length;
          while (inductionVariable_0 < last_0) {
            var element_0 = tmp2_safe_receiver[inductionVariable_0];
            inductionVariable_0 = inductionVariable_0 + 1 | 0;
            // Inline function 'kotlinx.serialization.json.internal.buildDeserializationNamesMap.<anonymous>' call
            var tmp;
            if (useLowercaseEnums) {
              // Inline function 'kotlin.text.lowercase' call
              // Inline function 'kotlin.js.asDynamic' call
              tmp = element_0.toLowerCase();
            } else {
              tmp = element_0;
            }
            buildDeserializationNamesMap$putOrThrow(builder, _this__u8e3s4, tmp, i);
          }
        }
        var tmp_0;
        if (useLowercaseEnums) {
          // Inline function 'kotlin.text.lowercase' call
          // Inline function 'kotlin.js.asDynamic' call
          tmp_0 = _this__u8e3s4.f19(i).toLowerCase();
        } else if (!(strategyForClasses == null)) {
          tmp_0 = strategyForClasses.w1s(_this__u8e3s4, i, _this__u8e3s4.f19(i));
        } else {
          tmp_0 = null;
        }
        var nameToPut = tmp_0;
        if (nameToPut == null)
          null;
        else {
          // Inline function 'kotlin.let' call
          // Inline function 'kotlin.contracts.contract' call
          buildDeserializationNamesMap$putOrThrow(builder, _this__u8e3s4, nameToPut, i);
        }
      }
       while (inductionVariable < last);
    // Inline function 'kotlin.collections.ifEmpty' call
    var tmp_1;
    if (builder.b1()) {
      // Inline function 'kotlinx.serialization.json.internal.buildDeserializationNamesMap.<anonymous>' call
      tmp_1 = emptyMap();
    } else {
      tmp_1 = builder;
    }
    return tmp_1;
  }
  function buildDeserializationNamesMap$putOrThrow(_this__u8e3s4, $this_buildDeserializationNamesMap, name, index) {
    var entity = equals($this_buildDeserializationNamesMap.a19(), ENUM_getInstance()) ? 'enum value' : 'property';
    // Inline function 'kotlin.collections.contains' call
    // Inline function 'kotlin.collections.containsKey' call
    if ((isInterface(_this__u8e3s4, Map) ? _this__u8e3s4 : THROW_CCE()).j2(name)) {
      throw new JsonException("The suggested name '" + name + "' for " + entity + ' ' + $this_buildDeserializationNamesMap.f19(index) + ' is already one of the names for ' + entity + ' ' + ($this_buildDeserializationNamesMap.f19(getValue(_this__u8e3s4, name)) + ' in ' + $this_buildDeserializationNamesMap));
    }
    // Inline function 'kotlin.collections.set' call
    _this__u8e3s4.c2(name, index);
  }
  function deserializationNamesMap$lambda($descriptor, $this_deserializationNamesMap) {
    return function () {
      return buildDeserializationNamesMap($descriptor, $this_deserializationNamesMap);
    };
  }
  function serializationNamesIndices$lambda($this_serializationNamesIndices, $strategy) {
    return function () {
      var tmp = 0;
      var tmp_0 = $this_serializationNamesIndices.d19();
      // Inline function 'kotlin.arrayOfNulls' call
      var tmp_1 = fillArrayVal(Array(tmp_0), null);
      while (tmp < tmp_0) {
        var tmp_2 = tmp;
        var baseName = $this_serializationNamesIndices.f19(tmp_2);
        tmp_1[tmp_2] = $strategy.w1s($this_serializationNamesIndices, tmp_2, baseName);
        tmp = tmp + 1 | 0;
      }
      return tmp_1;
    };
  }
  var properties_initialized_JsonNamesMap_kt_ljpf42;
  function _init_properties_JsonNamesMap_kt__cbbp0k() {
    if (!properties_initialized_JsonNamesMap_kt_ljpf42) {
      properties_initialized_JsonNamesMap_kt_ljpf42 = true;
      JsonDeserializationNamesKey = new Key();
      JsonSerializationNamesKey = new Key();
    }
  }
  function Tombstone() {
  }
  var Tombstone_instance;
  function Tombstone_getInstance() {
    return Tombstone_instance;
  }
  function resize($this) {
    var newSize = imul($this.z1s_1, 2);
    $this.x1s_1 = copyOf($this.x1s_1, newSize);
    $this.y1s_1 = copyOf_0($this.y1s_1, newSize);
  }
  function JsonPath() {
    var tmp = this;
    // Inline function 'kotlin.arrayOfNulls' call
    tmp.x1s_1 = fillArrayVal(Array(8), null);
    var tmp_0 = this;
    var tmp_1 = 0;
    var tmp_2 = new Int32Array(8);
    while (tmp_1 < 8) {
      tmp_2[tmp_1] = -1;
      tmp_1 = tmp_1 + 1 | 0;
    }
    tmp_0.y1s_1 = tmp_2;
    this.z1s_1 = -1;
  }
  protoOf(JsonPath).a1t = function (sd) {
    this.z1s_1 = this.z1s_1 + 1 | 0;
    var depth = this.z1s_1;
    if (depth === this.x1s_1.length) {
      resize(this);
    }
    this.x1s_1[depth] = sd;
  };
  protoOf(JsonPath).b1t = function (index) {
    this.y1s_1[this.z1s_1] = index;
  };
  protoOf(JsonPath).c1t = function (key) {
    var tmp;
    if (!(this.y1s_1[this.z1s_1] === -2)) {
      this.z1s_1 = this.z1s_1 + 1 | 0;
      tmp = this.z1s_1 === this.x1s_1.length;
    } else {
      tmp = false;
    }
    if (tmp) {
      resize(this);
    }
    this.x1s_1[this.z1s_1] = key;
    this.y1s_1[this.z1s_1] = -2;
  };
  protoOf(JsonPath).d1t = function () {
    if (this.y1s_1[this.z1s_1] === -2) {
      this.x1s_1[this.z1s_1] = Tombstone_instance;
    }
  };
  protoOf(JsonPath).e1t = function () {
    var depth = this.z1s_1;
    if (this.y1s_1[depth] === -2) {
      this.y1s_1[depth] = -1;
      this.z1s_1 = this.z1s_1 - 1 | 0;
    }
    if (!(this.z1s_1 === -1)) {
      this.z1s_1 = this.z1s_1 - 1 | 0;
    }
  };
  protoOf(JsonPath).f1t = function () {
    // Inline function 'kotlin.text.buildString' call
    // Inline function 'kotlin.contracts.contract' call
    // Inline function 'kotlin.apply' call
    var this_0 = StringBuilder_init_$Create$();
    // Inline function 'kotlin.contracts.contract' call
    // Inline function 'kotlinx.serialization.json.internal.JsonPath.getPath.<anonymous>' call
    this_0.j5('$');
    // Inline function 'kotlin.repeat' call
    var times = this.z1s_1 + 1 | 0;
    // Inline function 'kotlin.contracts.contract' call
    var inductionVariable = 0;
    if (inductionVariable < times)
      do {
        var index = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        // Inline function 'kotlinx.serialization.json.internal.JsonPath.getPath.<anonymous>.<anonymous>' call
        var element = this.x1s_1[index];
        if (!(element == null) ? isInterface(element, SerialDescriptor) : false) {
          if (equals(element.a19(), LIST_getInstance())) {
            if (!(this.y1s_1[index] === -1)) {
              this_0.j5('[');
              this_0.p7(this.y1s_1[index]);
              this_0.j5(']');
            }
          } else {
            var idx = this.y1s_1[index];
            if (idx >= 0) {
              this_0.j5('.');
              this_0.j5(element.f19(idx));
            }
          }
        } else {
          if (!(element === Tombstone_instance)) {
            this_0.j5('[');
            this_0.j5("'");
            this_0.i5(element);
            this_0.j5("'");
            this_0.j5(']');
          }
        }
      }
       while (inductionVariable < times);
    return this_0.toString();
  };
  protoOf(JsonPath).toString = function () {
    return this.f1t();
  };
  function encodeByWriter(json, writer, serializer, value) {
    var tmp = WriteMode_OBJ_getInstance();
    // Inline function 'kotlin.arrayOfNulls' call
    var size = get_entries().n();
    var tmp$ret$0 = fillArrayVal(Array(size), null);
    var encoder = StreamingJsonEncoder_init_$Create$(writer, json, tmp, tmp$ret$0);
    encoder.n1c(serializer, value);
  }
  function readObject($this) {
    // Inline function 'kotlinx.serialization.json.internal.JsonTreeReader.readObjectImpl' call
    var lastToken = $this.o1t_1.s1t(get_TC_BEGIN_OBJ());
    if ($this.o1t_1.t1t() === get_TC_COMMA()) {
      $this.o1t_1.s1s('Unexpected leading comma');
    }
    // Inline function 'kotlin.collections.linkedMapOf' call
    var result = LinkedHashMap_init_$Create$();
    $l$loop: while ($this.o1t_1.u1t()) {
      var key = $this.p1t_1 ? $this.o1t_1.w1t() : $this.o1t_1.v1t();
      $this.o1t_1.s1t(get_TC_COLON());
      // Inline function 'kotlinx.serialization.json.internal.JsonTreeReader.readObject.<anonymous>' call
      var element = $this.x1t();
      // Inline function 'kotlin.collections.set' call
      result.c2(key, element);
      lastToken = $this.o1t_1.y1t();
      var tmp0_subject = lastToken;
      if (tmp0_subject !== get_TC_COMMA())
        if (tmp0_subject === get_TC_END_OBJ())
          break $l$loop;
        else {
          $this.o1t_1.s1s('Expected end of the object or comma');
        }
    }
    if (lastToken === get_TC_BEGIN_OBJ()) {
      $this.o1t_1.s1t(get_TC_END_OBJ());
    } else if (lastToken === get_TC_COMMA()) {
      if (!$this.q1t_1) {
        invalidTrailingComma($this.o1t_1);
      }
      $this.o1t_1.s1t(get_TC_END_OBJ());
    }
    return new JsonObject(result);
  }
  function readObject_0(_this__u8e3s4, $this, $completion) {
    var tmp = new $readObjectCOROUTINE$0($this, _this__u8e3s4, $completion);
    tmp.ha_1 = Unit_instance;
    tmp.ia_1 = null;
    return tmp.sa();
  }
  function readArray($this) {
    var lastToken = $this.o1t_1.y1t();
    if ($this.o1t_1.t1t() === get_TC_COMMA()) {
      $this.o1t_1.s1s('Unexpected leading comma');
    }
    // Inline function 'kotlin.collections.arrayListOf' call
    var result = ArrayList_init_$Create$();
    while ($this.o1t_1.u1t()) {
      var element = $this.x1t();
      result.r(element);
      lastToken = $this.o1t_1.y1t();
      if (!(lastToken === get_TC_COMMA())) {
        // Inline function 'kotlinx.serialization.json.internal.AbstractJsonLexer.require' call
        var this_0 = $this.o1t_1;
        var condition = lastToken === get_TC_END_LIST();
        var position = this_0.v1o_1;
        if (!condition) {
          // Inline function 'kotlinx.serialization.json.internal.JsonTreeReader.readArray.<anonymous>' call
          var tmp$ret$1 = 'Expected end of the array or comma';
          this_0.s1s(tmp$ret$1, position);
        }
      }
    }
    if (lastToken === get_TC_BEGIN_LIST()) {
      $this.o1t_1.s1t(get_TC_END_LIST());
    } else if (lastToken === get_TC_COMMA()) {
      if (!$this.q1t_1) {
        invalidTrailingComma($this.o1t_1, 'array');
      }
      $this.o1t_1.s1t(get_TC_END_LIST());
    }
    return new JsonArray(result);
  }
  function readValue($this, isString) {
    var tmp;
    if ($this.p1t_1 ? true : !isString) {
      tmp = $this.o1t_1.w1t();
    } else {
      tmp = $this.o1t_1.v1t();
    }
    var string = tmp;
    if (!isString ? string === get_NULL() : false)
      return JsonNull_getInstance();
    return new JsonLiteral(string, isString);
  }
  function readDeepRecursive($this) {
    return invoke(new DeepRecursiveFunction(JsonTreeReader$readDeepRecursive$slambda_0($this, null)), Unit_instance);
  }
  function JsonTreeReader$readDeepRecursive$slambda(this$0, resultContinuation) {
    this.v1u_1 = this$0;
    CoroutineImpl.call(this, resultContinuation);
  }
  protoOf(JsonTreeReader$readDeepRecursive$slambda).a1v = function ($this$$receiver, it, $completion) {
    var tmp = this.b1v($this$$receiver, it, $completion);
    tmp.ha_1 = Unit_instance;
    tmp.ia_1 = null;
    return tmp.sa();
  };
  protoOf(JsonTreeReader$readDeepRecursive$slambda).yf = function (p1, p2, $completion) {
    var tmp = p1 instanceof DeepRecursiveScope ? p1 : THROW_CCE();
    return this.a1v(tmp, p2 instanceof Unit ? p2 : THROW_CCE(), $completion);
  };
  protoOf(JsonTreeReader$readDeepRecursive$slambda).sa = function () {
    var suspendResult = this.ha_1;
    $sm: do
      try {
        var tmp = this.fa_1;
        switch (tmp) {
          case 0:
            this.ga_1 = 3;
            this.y1u_1 = this.v1u_1.o1t_1.t1t();
            if (this.y1u_1 === get_TC_STRING()) {
              this.z1u_1 = readValue(this.v1u_1, true);
              this.fa_1 = 2;
              continue $sm;
            } else {
              if (this.y1u_1 === get_TC_OTHER()) {
                this.z1u_1 = readValue(this.v1u_1, false);
                this.fa_1 = 2;
                continue $sm;
              } else {
                if (this.y1u_1 === get_TC_BEGIN_OBJ()) {
                  this.fa_1 = 1;
                  suspendResult = readObject_0(this.w1u_1, this.v1u_1, this);
                  if (suspendResult === get_COROUTINE_SUSPENDED()) {
                    return suspendResult;
                  }
                  continue $sm;
                } else {
                  if (this.y1u_1 === get_TC_BEGIN_LIST()) {
                    this.z1u_1 = readArray(this.v1u_1);
                    this.fa_1 = 2;
                    continue $sm;
                  } else {
                    var tmp_0 = this;
                    this.v1u_1.o1t_1.s1s("Can't begin reading element, unexpected token");
                  }
                }
              }
            }

            break;
          case 1:
            this.z1u_1 = suspendResult;
            this.fa_1 = 2;
            continue $sm;
          case 2:
            return this.z1u_1;
          case 3:
            throw this.ia_1;
        }
      } catch ($p) {
        var e = $p;
        if (this.ga_1 === 3) {
          throw e;
        } else {
          this.fa_1 = this.ga_1;
          this.ia_1 = e;
        }
      }
     while (true);
  };
  protoOf(JsonTreeReader$readDeepRecursive$slambda).b1v = function ($this$$receiver, it, completion) {
    var i = new JsonTreeReader$readDeepRecursive$slambda(this.v1u_1, completion);
    i.w1u_1 = $this$$receiver;
    i.x1u_1 = it;
    return i;
  };
  function JsonTreeReader$readDeepRecursive$slambda_0(this$0, resultContinuation) {
    var i = new JsonTreeReader$readDeepRecursive$slambda(this$0, resultContinuation);
    var l = function ($this$$receiver, it, $completion) {
      return i.a1v($this$$receiver, it, $completion);
    };
    l.$arity = 2;
    return l;
  }
  function $readObjectCOROUTINE$0(_this__u8e3s4, _this__u8e3s4_0, resultContinuation) {
    CoroutineImpl.call(this, resultContinuation);
    this.h1u_1 = _this__u8e3s4;
    this.i1u_1 = _this__u8e3s4_0;
  }
  protoOf($readObjectCOROUTINE$0).sa = function () {
    var suspendResult = this.ha_1;
    $sm: do
      try {
        var tmp = this.fa_1;
        switch (tmp) {
          case 0:
            this.ga_1 = 5;
            var tmp_0 = this;
            tmp_0.j1u_1 = this.h1u_1;
            this.k1u_1 = this.j1u_1.o1t_1.s1t(get_TC_BEGIN_OBJ());
            if (this.j1u_1.o1t_1.t1t() === get_TC_COMMA()) {
              this.j1u_1.o1t_1.s1s('Unexpected leading comma');
            }

            var tmp_1 = this;
            tmp_1.l1u_1 = LinkedHashMap_init_$Create$();
            this.fa_1 = 1;
            continue $sm;
          case 1:
            if (!this.j1u_1.o1t_1.u1t()) {
              this.fa_1 = 4;
              continue $sm;
            }

            this.m1u_1 = this.j1u_1.p1t_1 ? this.j1u_1.o1t_1.w1t() : this.j1u_1.o1t_1.v1t();
            this.j1u_1.o1t_1.s1t(get_TC_COLON());
            this.fa_1 = 2;
            suspendResult = this.i1u_1.qf(Unit_instance, this);
            if (suspendResult === get_COROUTINE_SUSPENDED()) {
              return suspendResult;
            }

            continue $sm;
          case 2:
            var element = suspendResult;
            var this_0 = this.l1u_1;
            var key = this.m1u_1;
            this_0.c2(key, element);
            this.k1u_1 = this.j1u_1.o1t_1.y1t();
            var tmp0_subject = this.k1u_1;
            if (tmp0_subject === get_TC_COMMA()) {
              this.fa_1 = 3;
              continue $sm;
            } else {
              if (tmp0_subject === get_TC_END_OBJ()) {
                this.fa_1 = 4;
                continue $sm;
              } else {
                this.j1u_1.o1t_1.s1s('Expected end of the object or comma');
              }
            }

            break;
          case 3:
            this.fa_1 = 1;
            continue $sm;
          case 4:
            if (this.k1u_1 === get_TC_BEGIN_OBJ()) {
              this.j1u_1.o1t_1.s1t(get_TC_END_OBJ());
            } else if (this.k1u_1 === get_TC_COMMA()) {
              if (!this.j1u_1.q1t_1) {
                invalidTrailingComma(this.j1u_1.o1t_1);
              }
              this.j1u_1.o1t_1.s1t(get_TC_END_OBJ());
            }

            return new JsonObject(this.l1u_1);
          case 5:
            throw this.ia_1;
        }
      } catch ($p) {
        var e = $p;
        if (this.ga_1 === 5) {
          throw e;
        } else {
          this.fa_1 = this.ga_1;
          this.ia_1 = e;
        }
      }
     while (true);
  };
  function JsonTreeReader(configuration, lexer) {
    this.o1t_1 = lexer;
    this.p1t_1 = configuration.s1p_1;
    this.q1t_1 = configuration.e1q_1;
    this.r1t_1 = 0;
  }
  protoOf(JsonTreeReader).x1t = function () {
    var token = this.o1t_1.t1t();
    var tmp;
    if (token === get_TC_STRING()) {
      tmp = readValue(this, true);
    } else if (token === get_TC_OTHER()) {
      tmp = readValue(this, false);
    } else if (token === get_TC_BEGIN_OBJ()) {
      var tmp_0;
      this.r1t_1 = this.r1t_1 + 1 | 0;
      if (this.r1t_1 === 200) {
        tmp_0 = readDeepRecursive(this);
      } else {
        tmp_0 = readObject(this);
      }
      var result = tmp_0;
      this.r1t_1 = this.r1t_1 - 1 | 0;
      tmp = result;
    } else if (token === get_TC_BEGIN_LIST()) {
      tmp = readArray(this);
    } else {
      this.o1t_1.s1s('Cannot read Json element because of unexpected ' + tokenDescription(token));
    }
    return tmp;
  };
  function classDiscriminator(_this__u8e3s4, json) {
    var tmp0_iterator = _this__u8e3s4.e19().u();
    while (tmp0_iterator.v()) {
      var annotation = tmp0_iterator.w();
      if (annotation instanceof JsonClassDiscriminator)
        return annotation.c1v_1;
    }
    return json.h1o_1.z1p_1;
  }
  function decodeSerializableValuePolymorphic(_this__u8e3s4, deserializer) {
    var tmp;
    if (!(deserializer instanceof AbstractPolymorphicSerializer)) {
      tmp = true;
    } else {
      tmp = _this__u8e3s4.f1q().h1o_1.y1p_1;
    }
    if (tmp) {
      return deserializer.r18(_this__u8e3s4);
    }
    var discriminator = classDiscriminator(deserializer.p18(), _this__u8e3s4.f1q());
    // Inline function 'kotlinx.serialization.json.internal.cast' call
    var value = _this__u8e3s4.g1q();
    var descriptor = deserializer.p18();
    if (!(value instanceof JsonObject)) {
      throw JsonDecodingException_1(-1, 'Expected ' + getKClass(JsonObject) + ' as the serialized body of ' + descriptor.z18() + ', but had ' + getKClassFromExpression(value));
    }
    var jsonTree = value;
    var tmp0_safe_receiver = jsonTree.j1q(discriminator);
    var tmp1_safe_receiver = tmp0_safe_receiver == null ? null : get_jsonPrimitive(tmp0_safe_receiver);
    var type = tmp1_safe_receiver == null ? null : get_contentOrNull(tmp1_safe_receiver);
    var tmp_0;
    try {
      tmp_0 = findPolymorphicSerializer(deserializer, _this__u8e3s4, type);
    } catch ($p) {
      var tmp_1;
      if ($p instanceof SerializationException) {
        var it = $p;
        throw JsonDecodingException_0(-1, ensureNotNull(it.message), jsonTree.toString());
      } else {
        throw $p;
      }
    }
    var tmp_2 = tmp_0;
    var actualSerializer = isInterface(tmp_2, DeserializationStrategy) ? tmp_2 : THROW_CCE();
    return readPolymorphicJson(_this__u8e3s4.f1q(), discriminator, jsonTree, actualSerializer);
  }
  function validateIfSealed(serializer, actualSerializer, classDiscriminator) {
    if (!(serializer instanceof SealedClassSerializer))
      return Unit_instance;
    if (jsonCachedSerialNames(actualSerializer.p18()).z(classDiscriminator)) {
      var baseName = serializer.p18().z18();
      var actualName = actualSerializer.p18().z18();
      // Inline function 'kotlin.error' call
      var message = "Sealed class '" + actualName + "' cannot be serialized as base class '" + baseName + "' because" + (" it has property name that conflicts with JSON class discriminator '" + classDiscriminator + "'. ") + 'You can either change class discriminator in JsonConfiguration, ' + 'rename property with @SerialName annotation or fall back to array polymorphism';
      throw IllegalStateException_init_$Create$(toString(message));
    }
  }
  function checkKind(kind) {
    if (kind instanceof ENUM) {
      // Inline function 'kotlin.error' call
      var message = "Enums cannot be serialized polymorphically with 'type' parameter. You can use 'JsonBuilder.useArrayPolymorphism' instead";
      throw IllegalStateException_init_$Create$(toString(message));
    }
    if (kind instanceof PrimitiveKind) {
      // Inline function 'kotlin.error' call
      var message_0 = "Primitives cannot be serialized polymorphically with 'type' parameter. You can use 'JsonBuilder.useArrayPolymorphism' instead";
      throw IllegalStateException_init_$Create$(toString(message_0));
    }
    if (kind instanceof PolymorphicKind) {
      // Inline function 'kotlin.error' call
      var message_1 = 'Actual serializer for polymorphic cannot be polymorphic itself';
      throw IllegalStateException_init_$Create$(toString(message_1));
    }
  }
  function validateIfSealed$accessor$1rk9rdt(serializer, actualSerializer, classDiscriminator) {
    return validateIfSealed(serializer, actualSerializer, classDiscriminator);
  }
  function checkKind_0($this, descriptor, actualClass) {
    var kind = descriptor.a19();
    var tmp;
    if (kind instanceof PolymorphicKind) {
      tmp = true;
    } else {
      tmp = equals(kind, CONTEXTUAL_getInstance());
    }
    if (tmp) {
      throw IllegalArgumentException_init_$Create$('Serializer for ' + actualClass.g6() + " can't be registered as a subclass for polymorphic serialization " + ('because its kind ' + kind + ' is not concrete. To work with multiple hierarchies, register it as a base class.'));
    }
    if ($this.d1v_1)
      return Unit_instance;
    var tmp_0;
    var tmp_1;
    if (equals(kind, LIST_getInstance()) ? true : equals(kind, MAP_getInstance())) {
      tmp_1 = true;
    } else {
      tmp_1 = kind instanceof PrimitiveKind;
    }
    if (tmp_1) {
      tmp_0 = true;
    } else {
      tmp_0 = kind instanceof ENUM;
    }
    if (tmp_0) {
      throw IllegalArgumentException_init_$Create$('Serializer for ' + actualClass.g6() + ' of kind ' + kind + ' cannot be serialized polymorphically with class discriminator.');
    }
  }
  function checkDiscriminatorCollisions($this, descriptor, actualClass) {
    var inductionVariable = 0;
    var last = descriptor.d19();
    if (inductionVariable < last)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        var name = descriptor.f19(i);
        if (name === $this.e1v_1) {
          throw IllegalArgumentException_init_$Create$('Polymorphic serializer for ' + actualClass + " has property '" + name + "' that conflicts " + 'with JSON class discriminator. You can either change class discriminator in JsonConfiguration, ' + 'rename property with @SerialName annotation ' + 'or fall back to array polymorphism');
        }
      }
       while (inductionVariable < last);
  }
  function PolymorphismValidator(useArrayPolymorphism, discriminator) {
    this.d1v_1 = useArrayPolymorphism;
    this.e1v_1 = discriminator;
  }
  protoOf(PolymorphismValidator).b1o = function (kClass, provider) {
  };
  protoOf(PolymorphismValidator).e1o = function (baseClass, actualClass, actualSerializer) {
    var descriptor = actualSerializer.p18();
    checkKind_0(this, descriptor, actualClass);
    if (!this.d1v_1) {
      checkDiscriminatorCollisions(this, descriptor, actualClass);
    }
  };
  protoOf(PolymorphismValidator).f1o = function (baseClass, defaultSerializerProvider) {
  };
  protoOf(PolymorphismValidator).g1o = function (baseClass, defaultDeserializerProvider) {
  };
  function Key() {
  }
  function DescriptorSchemaCache() {
    this.t1s_1 = createMapForCache(16);
  }
  protoOf(DescriptorSchemaCache).f1v = function (descriptor, key, value) {
    // Inline function 'kotlin.collections.set' call
    // Inline function 'kotlin.collections.getOrPut' call
    var this_0 = this.t1s_1;
    var value_0 = this_0.m2(descriptor);
    var tmp;
    if (value_0 == null) {
      // Inline function 'kotlinx.serialization.json.internal.DescriptorSchemaCache.set.<anonymous>' call
      var answer = createMapForCache(2);
      this_0.c2(descriptor, answer);
      tmp = answer;
    } else {
      tmp = value_0;
    }
    var this_1 = tmp;
    var key_0 = key instanceof Key ? key : THROW_CCE();
    var value_1 = !(value == null) ? value : THROW_CCE();
    this_1.c2(key_0, value_1);
  };
  protoOf(DescriptorSchemaCache).u1s = function (descriptor, key, defaultValue) {
    var tmp0_safe_receiver = this.g1v(descriptor, key);
    if (tmp0_safe_receiver == null)
      null;
    else {
      // Inline function 'kotlin.let' call
      // Inline function 'kotlin.contracts.contract' call
      return tmp0_safe_receiver;
    }
    var value = defaultValue();
    this.f1v(descriptor, key, value);
    return value;
  };
  protoOf(DescriptorSchemaCache).g1v = function (descriptor, key) {
    var tmp0_safe_receiver = this.t1s_1.m2(descriptor);
    var tmp;
    if (tmp0_safe_receiver == null) {
      tmp = null;
    } else {
      tmp = tmp0_safe_receiver.m2(key instanceof Key ? key : THROW_CCE());
    }
    var tmp_0 = tmp;
    return !(tmp_0 == null) ? tmp_0 : null;
  };
  function DiscriminatorHolder(discriminatorToSkip) {
    this.h1v_1 = discriminatorToSkip;
  }
  function trySkip(_this__u8e3s4, $this, unknownKey) {
    if (_this__u8e3s4 == null)
      return false;
    if (_this__u8e3s4.h1v_1 === unknownKey) {
      _this__u8e3s4.h1v_1 = null;
      return true;
    }
    return false;
  }
  function skipLeftoverElements($this, descriptor) {
    $l$loop: while (true) {
      var tmp = $this.o1b(descriptor);
      if (!!(tmp === -1)) {
        break $l$loop;
      }
    }
  }
  function checkLeadingComma($this) {
    if ($this.p1o_1.t1t() === get_TC_COMMA()) {
      $this.p1o_1.s1s('Unexpected leading comma');
    }
  }
  function decodeMapIndex($this) {
    var hasComma = false;
    var decodingKey = !(($this.r1o_1 % 2 | 0) === 0);
    if (decodingKey) {
      if (!($this.r1o_1 === -1)) {
        hasComma = $this.p1o_1.j1v();
      }
    } else {
      $this.p1o_1.i1v(get_COLON());
    }
    var tmp;
    if ($this.p1o_1.u1t()) {
      if (decodingKey) {
        if ($this.r1o_1 === -1) {
          // Inline function 'kotlinx.serialization.json.internal.AbstractJsonLexer.require' call
          var this_0 = $this.p1o_1;
          var condition = !hasComma;
          var position = this_0.v1o_1;
          if (!condition) {
            // Inline function 'kotlinx.serialization.json.internal.StreamingJsonDecoder.decodeMapIndex.<anonymous>' call
            var tmp$ret$0 = 'Unexpected leading comma';
            this_0.s1s(tmp$ret$0, position);
          }
        } else {
          // Inline function 'kotlinx.serialization.json.internal.AbstractJsonLexer.require' call
          var this_1 = $this.p1o_1;
          var condition_0 = hasComma;
          var position_0 = this_1.v1o_1;
          if (!condition_0) {
            // Inline function 'kotlinx.serialization.json.internal.StreamingJsonDecoder.decodeMapIndex.<anonymous>' call
            var tmp$ret$1 = 'Expected comma after the key-value pair';
            this_1.s1s(tmp$ret$1, position_0);
          }
        }
      }
      $this.r1o_1 = $this.r1o_1 + 1 | 0;
      tmp = $this.r1o_1;
    } else {
      if (hasComma ? !$this.n1o_1.h1o_1.e1q_1 : false) {
        invalidTrailingComma($this.p1o_1);
      }
      tmp = -1;
    }
    return tmp;
  }
  function coerceInputValue($this, descriptor, index) {
    var tmp$ret$1;
    $l$block_2: {
      // Inline function 'kotlinx.serialization.json.internal.tryCoerceValue' call
      var this_0 = $this.n1o_1;
      var elementDescriptor = descriptor.i19(index);
      var tmp;
      if (!elementDescriptor.b19()) {
        // Inline function 'kotlinx.serialization.json.internal.StreamingJsonDecoder.coerceInputValue.<anonymous>' call
        tmp = $this.p1o_1.k1v(true);
      } else {
        tmp = false;
      }
      if (tmp) {
        tmp$ret$1 = true;
        break $l$block_2;
      }
      if (equals(elementDescriptor.a19(), ENUM_getInstance())) {
        var tmp_0;
        if (elementDescriptor.b19()) {
          // Inline function 'kotlinx.serialization.json.internal.StreamingJsonDecoder.coerceInputValue.<anonymous>' call
          tmp_0 = $this.p1o_1.k1v(false);
        } else {
          tmp_0 = false;
        }
        if (tmp_0) {
          tmp$ret$1 = false;
          break $l$block_2;
        }
        // Inline function 'kotlinx.serialization.json.internal.StreamingJsonDecoder.coerceInputValue.<anonymous>' call
        var tmp0_elvis_lhs = $this.p1o_1.l1v($this.t1o_1.s1p_1);
        var tmp_1;
        if (tmp0_elvis_lhs == null) {
          tmp$ret$1 = false;
          break $l$block_2;
        } else {
          tmp_1 = tmp0_elvis_lhs;
        }
        var enumValue = tmp_1;
        var enumIndex = getJsonNameIndex(elementDescriptor, this_0, enumValue);
        if (enumIndex === -3) {
          // Inline function 'kotlinx.serialization.json.internal.StreamingJsonDecoder.coerceInputValue.<anonymous>' call
          $this.p1o_1.v1t();
          tmp$ret$1 = true;
          break $l$block_2;
        }
      }
      tmp$ret$1 = false;
    }
    return tmp$ret$1;
  }
  function decodeObjectIndex($this, descriptor) {
    var hasComma = $this.p1o_1.j1v();
    while ($this.p1o_1.u1t()) {
      hasComma = false;
      var key = decodeStringKey($this);
      $this.p1o_1.i1v(get_COLON());
      var index = getJsonNameIndex(descriptor, $this.n1o_1, key);
      var tmp;
      if (!(index === -3)) {
        var tmp_0;
        if ($this.t1o_1.x1p_1 ? coerceInputValue($this, descriptor, index) : false) {
          hasComma = $this.p1o_1.j1v();
          tmp_0 = false;
        } else {
          var tmp0_safe_receiver = $this.u1o_1;
          if (tmp0_safe_receiver == null)
            null;
          else {
            tmp0_safe_receiver.m1f(index);
          }
          return index;
        }
        tmp = tmp_0;
      } else {
        tmp = true;
      }
      var isUnknown = tmp;
      if (isUnknown) {
        hasComma = handleUnknown($this, key);
      }
    }
    if (hasComma ? !$this.n1o_1.h1o_1.e1q_1 : false) {
      invalidTrailingComma($this.p1o_1);
    }
    var tmp1_safe_receiver = $this.u1o_1;
    var tmp2_elvis_lhs = tmp1_safe_receiver == null ? null : tmp1_safe_receiver.n1f();
    var tmp_1;
    if (tmp2_elvis_lhs == null) {
      tmp_1 = -1;
    } else {
      tmp_1 = tmp2_elvis_lhs;
    }
    return tmp_1;
  }
  function handleUnknown($this, key) {
    if ($this.t1o_1.r1p_1 ? true : trySkip($this.s1o_1, $this, key)) {
      $this.p1o_1.n1v($this.t1o_1.s1p_1);
    } else {
      $this.p1o_1.m1v(key);
    }
    return $this.p1o_1.j1v();
  }
  function decodeListIndex($this) {
    var hasComma = $this.p1o_1.j1v();
    var tmp;
    if ($this.p1o_1.u1t()) {
      if (!($this.r1o_1 === -1) ? !hasComma : false) {
        $this.p1o_1.s1s('Expected end of the array or comma');
      }
      $this.r1o_1 = $this.r1o_1 + 1 | 0;
      tmp = $this.r1o_1;
    } else {
      if (hasComma ? !$this.n1o_1.h1o_1.e1q_1 : false) {
        invalidTrailingComma($this.p1o_1, 'array');
      }
      tmp = -1;
    }
    return tmp;
  }
  function decodeStringKey($this) {
    var tmp;
    if ($this.t1o_1.s1p_1) {
      tmp = $this.p1o_1.p1v();
    } else {
      tmp = $this.p1o_1.o1v();
    }
    return tmp;
  }
  function StreamingJsonDecoder(json, mode, lexer, descriptor, discriminatorHolder) {
    AbstractDecoder.call(this);
    this.n1o_1 = json;
    this.o1o_1 = mode;
    this.p1o_1 = lexer;
    this.q1o_1 = this.n1o_1.m1b();
    this.r1o_1 = -1;
    this.s1o_1 = discriminatorHolder;
    this.t1o_1 = this.n1o_1.h1o_1;
    this.u1o_1 = this.t1o_1.v1p_1 ? null : new JsonElementMarker(descriptor);
  }
  protoOf(StreamingJsonDecoder).f1q = function () {
    return this.n1o_1;
  };
  protoOf(StreamingJsonDecoder).m1b = function () {
    return this.q1o_1;
  };
  protoOf(StreamingJsonDecoder).g1q = function () {
    return (new JsonTreeReader(this.n1o_1.h1o_1, this.p1o_1)).x1t();
  };
  protoOf(StreamingJsonDecoder).y1a = function (deserializer) {
    try {
      var tmp;
      if (!(deserializer instanceof AbstractPolymorphicSerializer)) {
        tmp = true;
      } else {
        tmp = this.n1o_1.h1o_1.y1p_1;
      }
      if (tmp) {
        return deserializer.r18(this);
      }
      var discriminator = classDiscriminator(deserializer.p18(), this.n1o_1);
      var tmp0_elvis_lhs = this.p1o_1.q1v(discriminator, this.t1o_1.s1p_1);
      var tmp_0;
      if (tmp0_elvis_lhs == null) {
        return decodeSerializableValuePolymorphic(this, isInterface(deserializer, DeserializationStrategy) ? deserializer : THROW_CCE());
      } else {
        tmp_0 = tmp0_elvis_lhs;
      }
      var type = tmp_0;
      var tmp_1;
      try {
        tmp_1 = findPolymorphicSerializer(deserializer, this, type);
      } catch ($p) {
        var tmp_2;
        if ($p instanceof SerializationException) {
          var it = $p;
          var message = removeSuffix(substringBefore(ensureNotNull(it.message), _Char___init__impl__6a9atx(10)), '.');
          var hint = substringAfter(ensureNotNull(it.message), _Char___init__impl__6a9atx(10), '');
          this.p1o_1.s1s(message, VOID, hint);
        } else {
          throw $p;
        }
        tmp_1 = tmp_2;
      }
      var tmp_3 = tmp_1;
      var actualSerializer = isInterface(tmp_3, DeserializationStrategy) ? tmp_3 : THROW_CCE();
      this.s1o_1 = new DiscriminatorHolder(discriminator);
      return actualSerializer.r18(this);
    } catch ($p) {
      if ($p instanceof MissingFieldException) {
        var e = $p;
        if (contains_0(ensureNotNull(e.message), 'at path'))
          throw e;
        throw new MissingFieldException(e.v18_1, plus(e.message, ' at path: ') + this.p1o_1.w1o_1.f1t(), e);
      } else {
        throw $p;
      }
    }
  };
  protoOf(StreamingJsonDecoder).z1a = function (descriptor) {
    var newMode = switchMode(this.n1o_1, descriptor);
    this.p1o_1.w1o_1.a1t(descriptor);
    this.p1o_1.i1v(newMode.t1v_1);
    checkLeadingComma(this);
    var tmp;
    switch (newMode.g8_1) {
      case 1:
      case 2:
      case 3:
        tmp = new StreamingJsonDecoder(this.n1o_1, newMode, this.p1o_1, descriptor, this.s1o_1);
        break;
      default:
        var tmp_0;
        if (this.o1o_1.equals(newMode) ? this.n1o_1.h1o_1.v1p_1 : false) {
          tmp_0 = this;
        } else {
          tmp_0 = new StreamingJsonDecoder(this.n1o_1, newMode, this.p1o_1, descriptor, this.s1o_1);
        }

        tmp = tmp_0;
        break;
    }
    return tmp;
  };
  protoOf(StreamingJsonDecoder).a1b = function (descriptor) {
    if (this.n1o_1.h1o_1.r1p_1 ? descriptor.d19() === 0 : false) {
      skipLeftoverElements(this, descriptor);
    }
    if (this.p1o_1.j1v() ? !this.n1o_1.h1o_1.e1q_1 : false) {
      invalidTrailingComma(this.p1o_1, '');
    }
    this.p1o_1.i1v(this.o1o_1.u1v_1);
    this.p1o_1.w1o_1.e1t();
  };
  protoOf(StreamingJsonDecoder).l1a = function () {
    var tmp;
    var tmp0_safe_receiver = this.u1o_1;
    var tmp1_elvis_lhs = tmp0_safe_receiver == null ? null : tmp0_safe_receiver.q1s_1;
    if (!(tmp1_elvis_lhs == null ? false : tmp1_elvis_lhs)) {
      tmp = !this.p1o_1.v1v();
    } else {
      tmp = false;
    }
    return tmp;
  };
  protoOf(StreamingJsonDecoder).m1a = function () {
    return null;
  };
  protoOf(StreamingJsonDecoder).k1b = function (descriptor, index, deserializer, previousValue) {
    var isMapKey = this.o1o_1.equals(WriteMode_MAP_getInstance()) ? (index & 1) === 0 : false;
    if (isMapKey) {
      this.p1o_1.w1o_1.d1t();
    }
    var value = protoOf(AbstractDecoder).k1b.call(this, descriptor, index, deserializer, previousValue);
    if (isMapKey) {
      this.p1o_1.w1o_1.c1t(value);
    }
    return value;
  };
  protoOf(StreamingJsonDecoder).o1b = function (descriptor) {
    var index;
    switch (this.o1o_1.g8_1) {
      case 0:
        index = decodeObjectIndex(this, descriptor);
        break;
      case 2:
        index = decodeMapIndex(this);
        break;
      default:
        index = decodeListIndex(this);
        break;
    }
    if (!this.o1o_1.equals(WriteMode_MAP_getInstance())) {
      this.p1o_1.w1o_1.b1t(index);
    }
    return index;
  };
  protoOf(StreamingJsonDecoder).n1a = function () {
    return this.p1o_1.w1v();
  };
  protoOf(StreamingJsonDecoder).o1a = function () {
    var value = this.p1o_1.t1q();
    if (!value.equals(toLong(value.w9()))) {
      this.p1o_1.s1s("Failed to parse byte for input '" + value.toString() + "'");
    }
    return value.w9();
  };
  protoOf(StreamingJsonDecoder).p1a = function () {
    var value = this.p1o_1.t1q();
    if (!value.equals(toLong(value.x9()))) {
      this.p1o_1.s1s("Failed to parse short for input '" + value.toString() + "'");
    }
    return value.x9();
  };
  protoOf(StreamingJsonDecoder).q1a = function () {
    var value = this.p1o_1.t1q();
    if (!value.equals(toLong(value.q8()))) {
      this.p1o_1.s1s("Failed to parse int for input '" + value.toString() + "'");
    }
    return value.q8();
  };
  protoOf(StreamingJsonDecoder).r1a = function () {
    return this.p1o_1.t1q();
  };
  protoOf(StreamingJsonDecoder).s1a = function () {
    var tmp$ret$4;
    $l$block: {
      // Inline function 'kotlinx.serialization.json.internal.parseString' call
      var this_0 = this.p1o_1;
      var input = this_0.w1t();
      try {
        // Inline function 'kotlinx.serialization.json.internal.StreamingJsonDecoder.decodeFloat.<anonymous>' call
        // Inline function 'kotlin.text.toFloat' call
        // Inline function 'kotlin.js.unsafeCast' call
        // Inline function 'kotlin.js.asDynamic' call
        tmp$ret$4 = toDouble(input);
        break $l$block;
      } catch ($p) {
        if ($p instanceof IllegalArgumentException) {
          var e = $p;
          this_0.s1s("Failed to parse type '" + 'float' + "' for input '" + input + "'");
        } else {
          throw $p;
        }
      }
    }
    var result = tmp$ret$4;
    var specialFp = this.n1o_1.h1o_1.a1q_1;
    if (specialFp ? true : isFinite(result))
      return result;
    throwInvalidFloatingPointDecoded(this.p1o_1, result);
  };
  protoOf(StreamingJsonDecoder).t1a = function () {
    var tmp$ret$1;
    $l$block: {
      // Inline function 'kotlinx.serialization.json.internal.parseString' call
      var this_0 = this.p1o_1;
      var input = this_0.w1t();
      try {
        // Inline function 'kotlinx.serialization.json.internal.StreamingJsonDecoder.decodeDouble.<anonymous>' call
        tmp$ret$1 = toDouble(input);
        break $l$block;
      } catch ($p) {
        if ($p instanceof IllegalArgumentException) {
          var e = $p;
          this_0.s1s("Failed to parse type '" + 'double' + "' for input '" + input + "'");
        } else {
          throw $p;
        }
      }
    }
    var result = tmp$ret$1;
    var specialFp = this.n1o_1.h1o_1.a1q_1;
    if (specialFp ? true : isFinite_0(result))
      return result;
    throwInvalidFloatingPointDecoded(this.p1o_1, result);
  };
  protoOf(StreamingJsonDecoder).u1a = function () {
    var string = this.p1o_1.w1t();
    if (!(string.length === 1)) {
      this.p1o_1.s1s("Expected single char, but got '" + string + "'");
    }
    return charSequenceGet(string, 0);
  };
  protoOf(StreamingJsonDecoder).v1a = function () {
    var tmp;
    if (this.t1o_1.s1p_1) {
      tmp = this.p1o_1.p1v();
    } else {
      tmp = this.p1o_1.v1t();
    }
    return tmp;
  };
  protoOf(StreamingJsonDecoder).w1a = function (descriptor) {
    return get_isUnsignedNumber(descriptor) ? new JsonDecoderForUnsignedTypes(this.p1o_1, this.n1o_1) : protoOf(AbstractDecoder).w1a.call(this, descriptor);
  };
  function JsonDecoderForUnsignedTypes(lexer, json) {
    AbstractDecoder.call(this);
    this.x1v_1 = lexer;
    this.y1v_1 = json.m1b();
  }
  protoOf(JsonDecoderForUnsignedTypes).m1b = function () {
    return this.y1v_1;
  };
  protoOf(JsonDecoderForUnsignedTypes).o1b = function (descriptor) {
    var message = 'unsupported';
    throw IllegalStateException_init_$Create$(toString(message));
  };
  protoOf(JsonDecoderForUnsignedTypes).q1a = function () {
    var tmp$ret$2;
    $l$block: {
      // Inline function 'kotlinx.serialization.json.internal.parseString' call
      var this_0 = this.x1v_1;
      var input = this_0.w1t();
      try {
        // Inline function 'kotlinx.serialization.json.internal.JsonDecoderForUnsignedTypes.decodeInt.<anonymous>' call
        // Inline function 'kotlin.UInt.toInt' call
        var this_1 = toUInt(input);
        tmp$ret$2 = _UInt___get_data__impl__f0vqqw(this_1);
        break $l$block;
      } catch ($p) {
        if ($p instanceof IllegalArgumentException) {
          var e = $p;
          this_0.s1s("Failed to parse type '" + 'UInt' + "' for input '" + input + "'");
        } else {
          throw $p;
        }
      }
    }
    return tmp$ret$2;
  };
  protoOf(JsonDecoderForUnsignedTypes).r1a = function () {
    var tmp$ret$2;
    $l$block: {
      // Inline function 'kotlinx.serialization.json.internal.parseString' call
      var this_0 = this.x1v_1;
      var input = this_0.w1t();
      try {
        // Inline function 'kotlinx.serialization.json.internal.JsonDecoderForUnsignedTypes.decodeLong.<anonymous>' call
        // Inline function 'kotlin.ULong.toLong' call
        var this_1 = toULong(input);
        tmp$ret$2 = _ULong___get_data__impl__fggpzb(this_1);
        break $l$block;
      } catch ($p) {
        if ($p instanceof IllegalArgumentException) {
          var e = $p;
          this_0.s1s("Failed to parse type '" + 'ULong' + "' for input '" + input + "'");
        } else {
          throw $p;
        }
      }
    }
    return tmp$ret$2;
  };
  protoOf(JsonDecoderForUnsignedTypes).o1a = function () {
    var tmp$ret$2;
    $l$block: {
      // Inline function 'kotlinx.serialization.json.internal.parseString' call
      var this_0 = this.x1v_1;
      var input = this_0.w1t();
      try {
        // Inline function 'kotlinx.serialization.json.internal.JsonDecoderForUnsignedTypes.decodeByte.<anonymous>' call
        // Inline function 'kotlin.UByte.toByte' call
        var this_1 = toUByte(input);
        tmp$ret$2 = _UByte___get_data__impl__jof9qr(this_1);
        break $l$block;
      } catch ($p) {
        if ($p instanceof IllegalArgumentException) {
          var e = $p;
          this_0.s1s("Failed to parse type '" + 'UByte' + "' for input '" + input + "'");
        } else {
          throw $p;
        }
      }
    }
    return tmp$ret$2;
  };
  protoOf(JsonDecoderForUnsignedTypes).p1a = function () {
    var tmp$ret$2;
    $l$block: {
      // Inline function 'kotlinx.serialization.json.internal.parseString' call
      var this_0 = this.x1v_1;
      var input = this_0.w1t();
      try {
        // Inline function 'kotlinx.serialization.json.internal.JsonDecoderForUnsignedTypes.decodeShort.<anonymous>' call
        // Inline function 'kotlin.UShort.toShort' call
        var this_1 = toUShort(input);
        tmp$ret$2 = _UShort___get_data__impl__g0245(this_1);
        break $l$block;
      } catch ($p) {
        if ($p instanceof IllegalArgumentException) {
          var e = $p;
          this_0.s1s("Failed to parse type '" + 'UShort' + "' for input '" + input + "'");
        } else {
          throw $p;
        }
      }
    }
    return tmp$ret$2;
  };
  function get_unsignedNumberDescriptors() {
    _init_properties_StreamingJsonEncoder_kt__pn1bsi();
    return unsignedNumberDescriptors;
  }
  var unsignedNumberDescriptors;
  function StreamingJsonEncoder_init_$Init$(output, json, mode, modeReuseCache, $this) {
    StreamingJsonEncoder.call($this, Composer_0(output, json), json, mode, modeReuseCache);
    return $this;
  }
  function StreamingJsonEncoder_init_$Create$(output, json, mode, modeReuseCache) {
    return StreamingJsonEncoder_init_$Init$(output, json, mode, modeReuseCache, objectCreate(protoOf(StreamingJsonEncoder)));
  }
  function encodeTypeInfo($this, descriptor) {
    $this.g1t_1.p1r();
    $this.b1c(ensureNotNull($this.n1t_1));
    $this.g1t_1.r1r(get_COLON());
    $this.g1t_1.q1r();
    $this.b1c(descriptor.z18());
  }
  function StreamingJsonEncoder(composer, json, mode, modeReuseCache) {
    AbstractEncoder.call(this);
    this.g1t_1 = composer;
    this.h1t_1 = json;
    this.i1t_1 = mode;
    this.j1t_1 = modeReuseCache;
    this.k1t_1 = this.h1t_1.m1b();
    this.l1t_1 = this.h1t_1.h1o_1;
    this.m1t_1 = false;
    this.n1t_1 = null;
    var i = this.i1t_1.g8_1;
    if (!(this.j1t_1 == null)) {
      if (!(this.j1t_1[i] === null) ? true : !(this.j1t_1[i] === this)) {
        this.j1t_1[i] = this;
      }
    }
  }
  protoOf(StreamingJsonEncoder).f1q = function () {
    return this.h1t_1;
  };
  protoOf(StreamingJsonEncoder).m1b = function () {
    return this.k1t_1;
  };
  protoOf(StreamingJsonEncoder).n1c = function (serializer, value) {
    $l$block: {
      // Inline function 'kotlinx.serialization.json.internal.encodePolymorphically' call
      var tmp;
      if (!(serializer instanceof AbstractPolymorphicSerializer)) {
        tmp = true;
      } else {
        tmp = this.f1q().h1o_1.y1p_1;
      }
      if (tmp) {
        serializer.q18(this, value);
        break $l$block;
      }
      var casted = serializer instanceof AbstractPolymorphicSerializer ? serializer : THROW_CCE();
      var baseClassDiscriminator = classDiscriminator(serializer.p18(), this.f1q());
      var actualSerializer = findPolymorphicSerializer_0(casted, this, !(value == null) ? value : THROW_CCE());
      validateIfSealed$accessor$1rk9rdt(casted, actualSerializer, baseClassDiscriminator);
      checkKind(actualSerializer.p18().a19());
      // Inline function 'kotlinx.serialization.json.internal.StreamingJsonEncoder.encodeSerializableValue.<anonymous>' call
      this.n1t_1 = baseClassDiscriminator;
      actualSerializer.q18(this, value);
    }
  };
  protoOf(StreamingJsonEncoder).z1a = function (descriptor) {
    var newMode = switchMode(this.h1t_1, descriptor);
    if (!(newMode.t1v_1 === get_INVALID())) {
      this.g1t_1.r1r(newMode.t1v_1);
      this.g1t_1.n1r();
    }
    if (!(this.n1t_1 == null)) {
      encodeTypeInfo(this, descriptor);
      this.n1t_1 = null;
    }
    if (this.i1t_1.equals(newMode)) {
      return this;
    }
    var tmp0_safe_receiver = this.j1t_1;
    var tmp1_elvis_lhs = tmp0_safe_receiver == null ? null : tmp0_safe_receiver[newMode.g8_1];
    return tmp1_elvis_lhs == null ? new StreamingJsonEncoder(this.g1t_1, this.h1t_1, newMode, this.j1t_1) : tmp1_elvis_lhs;
  };
  protoOf(StreamingJsonEncoder).a1b = function (descriptor) {
    if (!(this.i1t_1.u1v_1 === get_INVALID())) {
      this.g1t_1.o1r();
      this.g1t_1.p1r();
      this.g1t_1.r1r(this.i1t_1.u1v_1);
    }
  };
  protoOf(StreamingJsonEncoder).q1b = function (descriptor, index) {
    switch (this.i1t_1.g8_1) {
      case 1:
        if (!this.g1t_1.m1r_1) {
          this.g1t_1.r1r(get_COMMA());
        }

        this.g1t_1.p1r();
        break;
      case 2:
        if (!this.g1t_1.m1r_1) {
          var tmp = this;
          var tmp_0;
          if ((index % 2 | 0) === 0) {
            this.g1t_1.r1r(get_COMMA());
            this.g1t_1.p1r();
            tmp_0 = true;
          } else {
            this.g1t_1.r1r(get_COLON());
            this.g1t_1.q1r();
            tmp_0 = false;
          }
          tmp.m1t_1 = tmp_0;
        } else {
          this.m1t_1 = true;
          this.g1t_1.p1r();
        }

        break;
      case 3:
        if (index === 0)
          this.m1t_1 = true;
        if (index === 1) {
          this.g1t_1.r1r(get_COMMA());
          this.g1t_1.q1r();
          this.m1t_1 = false;
        }

        break;
      default:
        if (!this.g1t_1.m1r_1) {
          this.g1t_1.r1r(get_COMMA());
        }

        this.g1t_1.p1r();
        this.b1c(getJsonElementName(descriptor, this.h1t_1, index));
        this.g1t_1.r1r(get_COLON());
        this.g1t_1.q1r();
        break;
    }
    return true;
  };
  protoOf(StreamingJsonEncoder).c1c = function (descriptor) {
    var tmp;
    if (get_isUnsignedNumber(descriptor)) {
      // Inline function 'kotlinx.serialization.json.internal.StreamingJsonEncoder.composerAs' call
      var tmp_0;
      var tmp_1 = this.g1t_1;
      if (tmp_1 instanceof ComposerForUnsignedNumbers) {
        tmp_0 = this.g1t_1;
      } else {
        tmp_0 = new ComposerForUnsignedNumbers(this.g1t_1.l1r_1, this.m1t_1);
      }
      var tmp$ret$1 = tmp_0;
      tmp = new StreamingJsonEncoder(tmp$ret$1, this.h1t_1, this.i1t_1, null);
    } else if (get_isUnquotedLiteral(descriptor)) {
      // Inline function 'kotlinx.serialization.json.internal.StreamingJsonEncoder.composerAs' call
      var tmp_2;
      var tmp_3 = this.g1t_1;
      if (tmp_3 instanceof ComposerForUnquotedLiterals) {
        tmp_2 = this.g1t_1;
      } else {
        tmp_2 = new ComposerForUnquotedLiterals(this.g1t_1.l1r_1, this.m1t_1);
      }
      var tmp$ret$3 = tmp_2;
      tmp = new StreamingJsonEncoder(tmp$ret$3, this.h1t_1, this.i1t_1, null);
    } else {
      tmp = protoOf(AbstractEncoder).c1c.call(this, descriptor);
    }
    return tmp;
  };
  protoOf(StreamingJsonEncoder).s1b = function () {
    this.g1t_1.t1r(get_NULL());
  };
  protoOf(StreamingJsonEncoder).t1b = function (value) {
    if (this.m1t_1) {
      this.b1c(value.toString());
    } else {
      this.g1t_1.c1s(value);
    }
  };
  protoOf(StreamingJsonEncoder).u1b = function (value) {
    if (this.m1t_1) {
      this.b1c(value.toString());
    } else {
      this.g1t_1.x1r(value);
    }
  };
  protoOf(StreamingJsonEncoder).v1b = function (value) {
    if (this.m1t_1) {
      this.b1c(value.toString());
    } else {
      this.g1t_1.z1r(value);
    }
  };
  protoOf(StreamingJsonEncoder).w1b = function (value) {
    if (this.m1t_1) {
      this.b1c(value.toString());
    } else {
      this.g1t_1.a1s(value);
    }
  };
  protoOf(StreamingJsonEncoder).x1b = function (value) {
    if (this.m1t_1) {
      this.b1c(value.toString());
    } else {
      this.g1t_1.b1s(value);
    }
  };
  protoOf(StreamingJsonEncoder).y1b = function (value) {
    if (this.m1t_1) {
      this.b1c(value.toString());
    } else {
      this.g1t_1.v1r(value);
    }
    if (!this.l1t_1.a1q_1 ? !isFinite(value) : false) {
      throw InvalidFloatingPointEncoded(value, toString(this.g1t_1.l1r_1));
    }
  };
  protoOf(StreamingJsonEncoder).z1b = function (value) {
    if (this.m1t_1) {
      this.b1c(value.toString());
    } else {
      this.g1t_1.w1r(value);
    }
    if (!this.l1t_1.a1q_1 ? !isFinite_0(value) : false) {
      throw InvalidFloatingPointEncoded(value, toString(this.g1t_1.l1r_1));
    }
  };
  protoOf(StreamingJsonEncoder).a1c = function (value) {
    this.b1c(toString_0(value));
  };
  protoOf(StreamingJsonEncoder).b1c = function (value) {
    return this.g1t_1.d1s(value);
  };
  function get_isUnsignedNumber(_this__u8e3s4) {
    _init_properties_StreamingJsonEncoder_kt__pn1bsi();
    return _this__u8e3s4.c19() ? get_unsignedNumberDescriptors().z(_this__u8e3s4) : false;
  }
  function get_isUnquotedLiteral(_this__u8e3s4) {
    _init_properties_StreamingJsonEncoder_kt__pn1bsi();
    return _this__u8e3s4.c19() ? equals(_this__u8e3s4, get_jsonUnquotedLiteralDescriptor()) : false;
  }
  var properties_initialized_StreamingJsonEncoder_kt_6ifwwk;
  function _init_properties_StreamingJsonEncoder_kt__pn1bsi() {
    if (!properties_initialized_StreamingJsonEncoder_kt_6ifwwk) {
      properties_initialized_StreamingJsonEncoder_kt_6ifwwk = true;
      unsignedNumberDescriptors = setOf([serializer_1(Companion_getInstance_0()).p18(), serializer_0(Companion_getInstance()).p18(), serializer_2(Companion_getInstance_1()).p18(), serializer_3(Companion_getInstance_2()).p18()]);
    }
  }
  function get_ESCAPE_STRINGS() {
    _init_properties_StringOps_kt__fcy1db();
    return ESCAPE_STRINGS;
  }
  var ESCAPE_STRINGS;
  var ESCAPE_MARKERS;
  function toHexChar(i) {
    _init_properties_StringOps_kt__fcy1db();
    var d = i & 15;
    var tmp;
    if (d < 10) {
      // Inline function 'kotlin.code' call
      var this_0 = _Char___init__impl__6a9atx(48);
      var tmp$ret$0 = Char__toInt_impl_vasixd(this_0);
      tmp = numberToChar(d + tmp$ret$0 | 0);
    } else {
      var tmp_0 = d - 10 | 0;
      // Inline function 'kotlin.code' call
      var this_1 = _Char___init__impl__6a9atx(97);
      var tmp$ret$1 = Char__toInt_impl_vasixd(this_1);
      tmp = numberToChar(tmp_0 + tmp$ret$1 | 0);
    }
    return tmp;
  }
  function printQuoted(_this__u8e3s4, value) {
    _init_properties_StringOps_kt__fcy1db();
    _this__u8e3s4.k5(get_STRING());
    var lastPos = 0;
    var inductionVariable = 0;
    var last = charSequenceLength(value) - 1 | 0;
    if (inductionVariable <= last)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        // Inline function 'kotlin.code' call
        var this_0 = charSequenceGet(value, i);
        var c = Char__toInt_impl_vasixd(this_0);
        if (c < get_ESCAPE_STRINGS().length ? !(get_ESCAPE_STRINGS()[c] == null) : false) {
          _this__u8e3s4.n7(value, lastPos, i);
          _this__u8e3s4.j5(get_ESCAPE_STRINGS()[c]);
          lastPos = i + 1 | 0;
        }
      }
       while (inductionVariable <= last);
    if (!(lastPos === 0)) {
      _this__u8e3s4.n7(value, lastPos, value.length);
    } else {
      _this__u8e3s4.j5(value);
    }
    _this__u8e3s4.k5(get_STRING());
  }
  function toBooleanStrictOrNull_0(_this__u8e3s4) {
    _init_properties_StringOps_kt__fcy1db();
    return equals_0(_this__u8e3s4, 'true', true) ? true : equals_0(_this__u8e3s4, 'false', true) ? false : null;
  }
  var properties_initialized_StringOps_kt_wzaea7;
  function _init_properties_StringOps_kt__fcy1db() {
    if (!properties_initialized_StringOps_kt_wzaea7) {
      properties_initialized_StringOps_kt_wzaea7 = true;
      // Inline function 'kotlin.apply' call
      // Inline function 'kotlin.arrayOfNulls' call
      var this_0 = fillArrayVal(Array(93), null);
      // Inline function 'kotlin.contracts.contract' call
      // Inline function 'kotlinx.serialization.json.internal.ESCAPE_STRINGS.<anonymous>' call
      var inductionVariable = 0;
      if (inductionVariable <= 31)
        do {
          var c = inductionVariable;
          inductionVariable = inductionVariable + 1 | 0;
          var c1 = toHexChar(c >> 12);
          var c2 = toHexChar(c >> 8);
          var c3 = toHexChar(c >> 4);
          var c4 = toHexChar(c);
          this_0[c] = '\\u' + toString_0(c1) + toString_0(c2) + toString_0(c3) + toString_0(c4);
        }
         while (inductionVariable <= 31);
      // Inline function 'kotlin.code' call
      var this_1 = _Char___init__impl__6a9atx(34);
      this_0[Char__toInt_impl_vasixd(this_1)] = '\\"';
      // Inline function 'kotlin.code' call
      var this_2 = _Char___init__impl__6a9atx(92);
      this_0[Char__toInt_impl_vasixd(this_2)] = '\\\\';
      // Inline function 'kotlin.code' call
      var this_3 = _Char___init__impl__6a9atx(9);
      this_0[Char__toInt_impl_vasixd(this_3)] = '\\t';
      // Inline function 'kotlin.code' call
      var this_4 = _Char___init__impl__6a9atx(8);
      this_0[Char__toInt_impl_vasixd(this_4)] = '\\b';
      // Inline function 'kotlin.code' call
      var this_5 = _Char___init__impl__6a9atx(10);
      this_0[Char__toInt_impl_vasixd(this_5)] = '\\n';
      // Inline function 'kotlin.code' call
      var this_6 = _Char___init__impl__6a9atx(13);
      this_0[Char__toInt_impl_vasixd(this_6)] = '\\r';
      this_0[12] = '\\f';
      ESCAPE_STRINGS = this_0;
      // Inline function 'kotlin.apply' call
      var this_7 = new Int8Array(93);
      // Inline function 'kotlin.contracts.contract' call
      // Inline function 'kotlinx.serialization.json.internal.ESCAPE_MARKERS.<anonymous>' call
      var inductionVariable_0 = 0;
      if (inductionVariable_0 <= 31)
        do {
          var c_0 = inductionVariable_0;
          inductionVariable_0 = inductionVariable_0 + 1 | 0;
          this_7[c_0] = 1;
        }
         while (inductionVariable_0 <= 31);
      // Inline function 'kotlin.code' call
      var this_8 = _Char___init__impl__6a9atx(34);
      this_7[Char__toInt_impl_vasixd(this_8)] = 34;
      // Inline function 'kotlin.code' call
      var this_9 = _Char___init__impl__6a9atx(92);
      this_7[Char__toInt_impl_vasixd(this_9)] = 92;
      // Inline function 'kotlin.code' call
      var this_10 = _Char___init__impl__6a9atx(9);
      this_7[Char__toInt_impl_vasixd(this_10)] = 116;
      // Inline function 'kotlin.code' call
      var this_11 = _Char___init__impl__6a9atx(8);
      this_7[Char__toInt_impl_vasixd(this_11)] = 98;
      // Inline function 'kotlin.code' call
      var this_12 = _Char___init__impl__6a9atx(10);
      this_7[Char__toInt_impl_vasixd(this_12)] = 110;
      // Inline function 'kotlin.code' call
      var this_13 = _Char___init__impl__6a9atx(13);
      this_7[Char__toInt_impl_vasixd(this_13)] = 114;
      this_7[12] = 102;
      ESCAPE_MARKERS = this_7;
    }
  }
  function unparsedPrimitive($this, primitive) {
    throw JsonDecodingException_0(-1, "Failed to parse literal as '" + primitive + "' value", toString($this.e1w()));
  }
  function asLiteral(_this__u8e3s4, $this, type) {
    var tmp0_elvis_lhs = _this__u8e3s4 instanceof JsonLiteral ? _this__u8e3s4 : null;
    var tmp;
    if (tmp0_elvis_lhs == null) {
      throw JsonDecodingException_1(-1, "Unexpected 'null' literal when non-nullable " + type + ' was expected');
    } else {
      tmp = tmp0_elvis_lhs;
    }
    return tmp;
  }
  function AbstractJsonTreeDecoder(json, value) {
    NamedValueDecoder.call(this);
    this.b1w_1 = json;
    this.c1w_1 = value;
    this.d1w_1 = this.f1q().h1o_1;
  }
  protoOf(AbstractJsonTreeDecoder).f1q = function () {
    return this.b1w_1;
  };
  protoOf(AbstractJsonTreeDecoder).f2 = function () {
    return this.c1w_1;
  };
  protoOf(AbstractJsonTreeDecoder).m1b = function () {
    return this.f1q().m1b();
  };
  protoOf(AbstractJsonTreeDecoder).e1w = function () {
    var tmp0_safe_receiver = this.q1m();
    var tmp;
    if (tmp0_safe_receiver == null) {
      tmp = null;
    } else {
      // Inline function 'kotlin.let' call
      // Inline function 'kotlin.contracts.contract' call
      // Inline function 'kotlinx.serialization.json.internal.AbstractJsonTreeDecoder.currentObject.<anonymous>' call
      tmp = this.f1w(tmp0_safe_receiver);
    }
    var tmp1_elvis_lhs = tmp;
    return tmp1_elvis_lhs == null ? this.f2() : tmp1_elvis_lhs;
  };
  protoOf(AbstractJsonTreeDecoder).g1q = function () {
    return this.e1w();
  };
  protoOf(AbstractJsonTreeDecoder).y1a = function (deserializer) {
    return decodeSerializableValuePolymorphic(this, deserializer);
  };
  protoOf(AbstractJsonTreeDecoder).r1m = function (parentName, childName) {
    return childName;
  };
  protoOf(AbstractJsonTreeDecoder).z1a = function (descriptor) {
    var currentObject = this.e1w();
    var tmp0_subject = descriptor.a19();
    var tmp;
    var tmp_0;
    if (equals(tmp0_subject, LIST_getInstance())) {
      tmp_0 = true;
    } else {
      tmp_0 = tmp0_subject instanceof PolymorphicKind;
    }
    if (tmp_0) {
      var tmp_1 = this.f1q();
      // Inline function 'kotlinx.serialization.json.internal.cast' call
      if (!(currentObject instanceof JsonArray)) {
        throw JsonDecodingException_1(-1, 'Expected ' + getKClass(JsonArray) + ' as the serialized body of ' + descriptor.z18() + ', but had ' + getKClassFromExpression(currentObject));
      }
      tmp = new JsonTreeListDecoder(tmp_1, currentObject);
    } else {
      if (equals(tmp0_subject, MAP_getInstance())) {
        // Inline function 'kotlinx.serialization.json.internal.selectMapMode' call
        var this_0 = this.f1q();
        var keyDescriptor = carrierDescriptor(descriptor.i19(0), this_0.m1b());
        var keyKind = keyDescriptor.a19();
        var tmp_2;
        var tmp_3;
        if (keyKind instanceof PrimitiveKind) {
          tmp_3 = true;
        } else {
          tmp_3 = equals(keyKind, ENUM_getInstance());
        }
        if (tmp_3) {
          // Inline function 'kotlinx.serialization.json.internal.AbstractJsonTreeDecoder.beginStructure.<anonymous>' call
          var tmp_4 = this.f1q();
          // Inline function 'kotlinx.serialization.json.internal.cast' call
          if (!(currentObject instanceof JsonObject)) {
            throw JsonDecodingException_1(-1, 'Expected ' + getKClass(JsonObject) + ' as the serialized body of ' + descriptor.z18() + ', but had ' + getKClassFromExpression(currentObject));
          }
          tmp_2 = new JsonTreeMapDecoder(tmp_4, currentObject);
        } else {
          if (this_0.h1o_1.t1p_1) {
            // Inline function 'kotlinx.serialization.json.internal.AbstractJsonTreeDecoder.beginStructure.<anonymous>' call
            var tmp_5 = this.f1q();
            // Inline function 'kotlinx.serialization.json.internal.cast' call
            if (!(currentObject instanceof JsonArray)) {
              throw JsonDecodingException_1(-1, 'Expected ' + getKClass(JsonArray) + ' as the serialized body of ' + descriptor.z18() + ', but had ' + getKClassFromExpression(currentObject));
            }
            tmp_2 = new JsonTreeListDecoder(tmp_5, currentObject);
          } else {
            throw InvalidKeyKindException(keyDescriptor);
          }
        }
        tmp = tmp_2;
      } else {
        var tmp_6 = this.f1q();
        // Inline function 'kotlinx.serialization.json.internal.cast' call
        if (!(currentObject instanceof JsonObject)) {
          throw JsonDecodingException_1(-1, 'Expected ' + getKClass(JsonObject) + ' as the serialized body of ' + descriptor.z18() + ', but had ' + getKClassFromExpression(currentObject));
        }
        tmp = new JsonTreeDecoder(tmp_6, currentObject);
      }
    }
    return tmp;
  };
  protoOf(AbstractJsonTreeDecoder).a1b = function (descriptor) {
  };
  protoOf(AbstractJsonTreeDecoder).l1a = function () {
    var tmp = this.e1w();
    return !(tmp instanceof JsonNull);
  };
  protoOf(AbstractJsonTreeDecoder).g1w = function (tag) {
    var currentElement = this.f1w(tag);
    var tmp0_elvis_lhs = currentElement instanceof JsonPrimitive ? currentElement : null;
    var tmp;
    if (tmp0_elvis_lhs == null) {
      throw JsonDecodingException_0(-1, 'Expected JsonPrimitive at ' + tag + ', found ' + currentElement, toString(this.e1w()));
    } else {
      tmp = tmp0_elvis_lhs;
    }
    return tmp;
  };
  protoOf(AbstractJsonTreeDecoder).h1w = function (tag) {
    return !(this.f1w(tag) === JsonNull_getInstance());
  };
  protoOf(AbstractJsonTreeDecoder).t1m = function (tag) {
    return this.h1w((!(tag == null) ? typeof tag === 'string' : false) ? tag : THROW_CCE());
  };
  protoOf(AbstractJsonTreeDecoder).i1w = function (tag) {
    var tmp$ret$1;
    $l$block: {
      // Inline function 'kotlinx.serialization.json.internal.AbstractJsonTreeDecoder.primitive' call
      var this_0 = this.g1w(tag);
      try {
        var tmp0_elvis_lhs = get_booleanOrNull(this_0);
        var tmp;
        if (tmp0_elvis_lhs == null) {
          unparsedPrimitive(this, 'boolean');
        } else {
          tmp = tmp0_elvis_lhs;
        }
        tmp$ret$1 = tmp;
        break $l$block;
      } catch ($p) {
        if ($p instanceof IllegalArgumentException) {
          var e = $p;
          unparsedPrimitive(this, 'boolean');
        } else {
          throw $p;
        }
      }
    }
    return tmp$ret$1;
  };
  protoOf(AbstractJsonTreeDecoder).u1m = function (tag) {
    return this.i1w((!(tag == null) ? typeof tag === 'string' : false) ? tag : THROW_CCE());
  };
  protoOf(AbstractJsonTreeDecoder).j1w = function (tag) {
    var tmp$ret$1;
    $l$block: {
      // Inline function 'kotlinx.serialization.json.internal.AbstractJsonTreeDecoder.primitive' call
      var this_0 = this.g1w(tag);
      try {
        // Inline function 'kotlinx.serialization.json.internal.AbstractJsonTreeDecoder.decodeTaggedByte.<anonymous>' call
        var result = get_int(this_0);
        var tmp;
        var containsLower = ByteCompanionObject_instance.MIN_VALUE;
        if (result <= ByteCompanionObject_instance.MAX_VALUE ? containsLower <= result : false) {
          tmp = toByte(result);
        } else {
          tmp = null;
        }
        var tmp0_elvis_lhs = tmp;
        var tmp_0;
        if (tmp0_elvis_lhs == null) {
          unparsedPrimitive(this, 'byte');
        } else {
          tmp_0 = tmp0_elvis_lhs;
        }
        tmp$ret$1 = tmp_0;
        break $l$block;
      } catch ($p) {
        if ($p instanceof IllegalArgumentException) {
          var e = $p;
          unparsedPrimitive(this, 'byte');
        } else {
          throw $p;
        }
      }
    }
    return tmp$ret$1;
  };
  protoOf(AbstractJsonTreeDecoder).v1m = function (tag) {
    return this.j1w((!(tag == null) ? typeof tag === 'string' : false) ? tag : THROW_CCE());
  };
  protoOf(AbstractJsonTreeDecoder).k1w = function (tag) {
    var tmp$ret$1;
    $l$block: {
      // Inline function 'kotlinx.serialization.json.internal.AbstractJsonTreeDecoder.primitive' call
      var this_0 = this.g1w(tag);
      try {
        // Inline function 'kotlinx.serialization.json.internal.AbstractJsonTreeDecoder.decodeTaggedShort.<anonymous>' call
        var result = get_int(this_0);
        var tmp;
        var containsLower = ShortCompanionObject_instance.MIN_VALUE;
        if (result <= ShortCompanionObject_instance.MAX_VALUE ? containsLower <= result : false) {
          tmp = toShort(result);
        } else {
          tmp = null;
        }
        var tmp0_elvis_lhs = tmp;
        var tmp_0;
        if (tmp0_elvis_lhs == null) {
          unparsedPrimitive(this, 'short');
        } else {
          tmp_0 = tmp0_elvis_lhs;
        }
        tmp$ret$1 = tmp_0;
        break $l$block;
      } catch ($p) {
        if ($p instanceof IllegalArgumentException) {
          var e = $p;
          unparsedPrimitive(this, 'short');
        } else {
          throw $p;
        }
      }
    }
    return tmp$ret$1;
  };
  protoOf(AbstractJsonTreeDecoder).w1m = function (tag) {
    return this.k1w((!(tag == null) ? typeof tag === 'string' : false) ? tag : THROW_CCE());
  };
  protoOf(AbstractJsonTreeDecoder).l1w = function (tag) {
    var tmp$ret$1;
    $l$block: {
      // Inline function 'kotlinx.serialization.json.internal.AbstractJsonTreeDecoder.primitive' call
      var this_0 = this.g1w(tag);
      try {
        // Inline function 'kotlinx.serialization.json.internal.AbstractJsonTreeDecoder.decodeTaggedInt.<anonymous>' call
        var tmp0_elvis_lhs = get_int(this_0);
        var tmp;
        if (tmp0_elvis_lhs == null) {
          unparsedPrimitive(this, 'int');
        } else {
          tmp = tmp0_elvis_lhs;
        }
        tmp$ret$1 = tmp;
        break $l$block;
      } catch ($p) {
        if ($p instanceof IllegalArgumentException) {
          var e = $p;
          unparsedPrimitive(this, 'int');
        } else {
          throw $p;
        }
      }
    }
    return tmp$ret$1;
  };
  protoOf(AbstractJsonTreeDecoder).x1m = function (tag) {
    return this.l1w((!(tag == null) ? typeof tag === 'string' : false) ? tag : THROW_CCE());
  };
  protoOf(AbstractJsonTreeDecoder).m1w = function (tag) {
    var tmp$ret$1;
    $l$block: {
      // Inline function 'kotlinx.serialization.json.internal.AbstractJsonTreeDecoder.primitive' call
      var this_0 = this.g1w(tag);
      try {
        // Inline function 'kotlinx.serialization.json.internal.AbstractJsonTreeDecoder.decodeTaggedLong.<anonymous>' call
        var tmp0_elvis_lhs = get_long(this_0);
        var tmp;
        if (tmp0_elvis_lhs == null) {
          unparsedPrimitive(this, 'long');
        } else {
          tmp = tmp0_elvis_lhs;
        }
        tmp$ret$1 = tmp;
        break $l$block;
      } catch ($p) {
        if ($p instanceof IllegalArgumentException) {
          var e = $p;
          unparsedPrimitive(this, 'long');
        } else {
          throw $p;
        }
      }
    }
    return tmp$ret$1;
  };
  protoOf(AbstractJsonTreeDecoder).y1m = function (tag) {
    return this.m1w((!(tag == null) ? typeof tag === 'string' : false) ? tag : THROW_CCE());
  };
  protoOf(AbstractJsonTreeDecoder).n1w = function (tag) {
    var tmp$ret$1;
    $l$block: {
      // Inline function 'kotlinx.serialization.json.internal.AbstractJsonTreeDecoder.primitive' call
      var this_0 = this.g1w(tag);
      try {
        // Inline function 'kotlinx.serialization.json.internal.AbstractJsonTreeDecoder.decodeTaggedFloat.<anonymous>' call
        var tmp0_elvis_lhs = get_float(this_0);
        var tmp;
        if (tmp0_elvis_lhs == null) {
          unparsedPrimitive(this, 'float');
        } else {
          tmp = tmp0_elvis_lhs;
        }
        tmp$ret$1 = tmp;
        break $l$block;
      } catch ($p) {
        if ($p instanceof IllegalArgumentException) {
          var e = $p;
          unparsedPrimitive(this, 'float');
        } else {
          throw $p;
        }
      }
    }
    var result = tmp$ret$1;
    var specialFp = this.f1q().h1o_1.a1q_1;
    if (specialFp ? true : isFinite(result))
      return result;
    throw InvalidFloatingPointDecoded(result, tag, toString(this.e1w()));
  };
  protoOf(AbstractJsonTreeDecoder).z1m = function (tag) {
    return this.n1w((!(tag == null) ? typeof tag === 'string' : false) ? tag : THROW_CCE());
  };
  protoOf(AbstractJsonTreeDecoder).o1w = function (tag) {
    var tmp$ret$1;
    $l$block: {
      // Inline function 'kotlinx.serialization.json.internal.AbstractJsonTreeDecoder.primitive' call
      var this_0 = this.g1w(tag);
      try {
        // Inline function 'kotlinx.serialization.json.internal.AbstractJsonTreeDecoder.decodeTaggedDouble.<anonymous>' call
        var tmp0_elvis_lhs = get_double(this_0);
        var tmp;
        if (tmp0_elvis_lhs == null) {
          unparsedPrimitive(this, 'double');
        } else {
          tmp = tmp0_elvis_lhs;
        }
        tmp$ret$1 = tmp;
        break $l$block;
      } catch ($p) {
        if ($p instanceof IllegalArgumentException) {
          var e = $p;
          unparsedPrimitive(this, 'double');
        } else {
          throw $p;
        }
      }
    }
    var result = tmp$ret$1;
    var specialFp = this.f1q().h1o_1.a1q_1;
    if (specialFp ? true : isFinite_0(result))
      return result;
    throw InvalidFloatingPointDecoded(result, tag, toString(this.e1w()));
  };
  protoOf(AbstractJsonTreeDecoder).a1n = function (tag) {
    return this.o1w((!(tag == null) ? typeof tag === 'string' : false) ? tag : THROW_CCE());
  };
  protoOf(AbstractJsonTreeDecoder).p1w = function (tag) {
    var tmp$ret$1;
    $l$block: {
      // Inline function 'kotlinx.serialization.json.internal.AbstractJsonTreeDecoder.primitive' call
      var this_0 = this.g1w(tag);
      try {
        // Inline function 'kotlinx.serialization.json.internal.AbstractJsonTreeDecoder.decodeTaggedChar.<anonymous>' call
        var tmp0_elvis_lhs = single(this_0.m1q());
        var tmp;
        var tmp_0 = tmp0_elvis_lhs;
        if ((tmp_0 == null ? null : new Char(tmp_0)) == null) {
          unparsedPrimitive(this, 'char');
        } else {
          tmp = tmp0_elvis_lhs;
        }
        tmp$ret$1 = tmp;
        break $l$block;
      } catch ($p) {
        if ($p instanceof IllegalArgumentException) {
          var e = $p;
          unparsedPrimitive(this, 'char');
        } else {
          throw $p;
        }
      }
    }
    return tmp$ret$1;
  };
  protoOf(AbstractJsonTreeDecoder).b1n = function (tag) {
    return this.p1w((!(tag == null) ? typeof tag === 'string' : false) ? tag : THROW_CCE());
  };
  protoOf(AbstractJsonTreeDecoder).q1w = function (tag) {
    var value = this.g1w(tag);
    if (!this.f1q().h1o_1.s1p_1) {
      var literal = asLiteral(value, this, 'string');
      if (!literal.n1q_1)
        throw JsonDecodingException_0(-1, "String literal for key '" + tag + "' should be quoted.\n" + get_lenientHint(), toString(this.e1w()));
    }
    if (value instanceof JsonNull)
      throw JsonDecodingException_0(-1, "Unexpected 'null' value instead of string literal", toString(this.e1w()));
    return value.m1q();
  };
  protoOf(AbstractJsonTreeDecoder).c1n = function (tag) {
    return this.q1w((!(tag == null) ? typeof tag === 'string' : false) ? tag : THROW_CCE());
  };
  protoOf(AbstractJsonTreeDecoder).r1w = function (tag, inlineDescriptor) {
    return get_isUnsignedNumber(inlineDescriptor) ? new JsonDecoderForUnsignedTypes(new StringJsonLexer(this.g1w(tag).m1q()), this.f1q()) : protoOf(NamedValueDecoder).d1n.call(this, tag, inlineDescriptor);
  };
  protoOf(AbstractJsonTreeDecoder).d1n = function (tag, inlineDescriptor) {
    return this.r1w((!(tag == null) ? typeof tag === 'string' : false) ? tag : THROW_CCE(), inlineDescriptor);
  };
  protoOf(AbstractJsonTreeDecoder).w1a = function (descriptor) {
    return !(this.q1m() == null) ? protoOf(NamedValueDecoder).w1a.call(this, descriptor) : (new JsonPrimitiveDecoder(this.f1q(), this.f2())).w1a(descriptor);
  };
  function coerceInputValue_0($this, descriptor, index, tag) {
    var tmp$ret$1;
    $l$block_2: {
      // Inline function 'kotlinx.serialization.json.internal.tryCoerceValue' call
      var this_0 = $this.f1q();
      var elementDescriptor = descriptor.i19(index);
      var tmp;
      if (!elementDescriptor.b19()) {
        // Inline function 'kotlinx.serialization.json.internal.JsonTreeDecoder.coerceInputValue.<anonymous>' call
        var tmp_0 = $this.f1w(tag);
        tmp = tmp_0 instanceof JsonNull;
      } else {
        tmp = false;
      }
      if (tmp) {
        tmp$ret$1 = true;
        break $l$block_2;
      }
      if (equals(elementDescriptor.a19(), ENUM_getInstance())) {
        var tmp_1;
        if (elementDescriptor.b19()) {
          // Inline function 'kotlinx.serialization.json.internal.JsonTreeDecoder.coerceInputValue.<anonymous>' call
          var tmp_2 = $this.f1w(tag);
          tmp_1 = tmp_2 instanceof JsonNull;
        } else {
          tmp_1 = false;
        }
        if (tmp_1) {
          tmp$ret$1 = false;
          break $l$block_2;
        }
        // Inline function 'kotlinx.serialization.json.internal.JsonTreeDecoder.coerceInputValue.<anonymous>' call
        var tmp_3 = $this.f1w(tag);
        var tmp0_safe_receiver = tmp_3 instanceof JsonPrimitive ? tmp_3 : null;
        var tmp0_elvis_lhs = tmp0_safe_receiver == null ? null : get_contentOrNull(tmp0_safe_receiver);
        var tmp_4;
        if (tmp0_elvis_lhs == null) {
          tmp$ret$1 = false;
          break $l$block_2;
        } else {
          tmp_4 = tmp0_elvis_lhs;
        }
        var enumValue = tmp_4;
        var enumIndex = getJsonNameIndex(elementDescriptor, this_0, enumValue);
        if (enumIndex === -3) {
          // Inline function 'kotlinx.serialization.json.internal.tryCoerceValue.<anonymous>' call
          tmp$ret$1 = true;
          break $l$block_2;
        }
      }
      tmp$ret$1 = false;
    }
    return tmp$ret$1;
  }
  function absenceIsNull($this, descriptor, index) {
    $this.b1x_1 = (!$this.f1q().h1o_1.v1p_1 ? !descriptor.j19(index) : false) ? descriptor.i19(index).b19() : false;
    return $this.b1x_1;
  }
  function JsonTreeDecoder(json, value, polyDiscriminator, polyDescriptor) {
    polyDiscriminator = polyDiscriminator === VOID ? null : polyDiscriminator;
    polyDescriptor = polyDescriptor === VOID ? null : polyDescriptor;
    AbstractJsonTreeDecoder.call(this, json, value);
    this.x1w_1 = value;
    this.y1w_1 = polyDiscriminator;
    this.z1w_1 = polyDescriptor;
    this.a1x_1 = 0;
    this.b1x_1 = false;
  }
  protoOf(JsonTreeDecoder).f2 = function () {
    return this.x1w_1;
  };
  protoOf(JsonTreeDecoder).o1b = function (descriptor) {
    while (this.a1x_1 < descriptor.d19()) {
      var tmp1 = this.a1x_1;
      this.a1x_1 = tmp1 + 1 | 0;
      var name = this.l1m(descriptor, tmp1);
      var index = this.a1x_1 - 1 | 0;
      this.b1x_1 = false;
      var tmp;
      var tmp_0;
      // Inline function 'kotlin.collections.contains' call
      // Inline function 'kotlin.collections.containsKey' call
      var this_0 = this.f2();
      if ((isInterface(this_0, Map) ? this_0 : THROW_CCE()).j2(name)) {
        tmp_0 = true;
      } else {
        tmp_0 = absenceIsNull(this, descriptor, index);
      }
      if (tmp_0) {
        tmp = !this.d1w_1.x1p_1 ? true : !coerceInputValue_0(this, descriptor, index, name);
      } else {
        tmp = false;
      }
      if (tmp) {
        return index;
      }
    }
    return -1;
  };
  protoOf(JsonTreeDecoder).l1a = function () {
    return !this.b1x_1 ? protoOf(AbstractJsonTreeDecoder).l1a.call(this) : false;
  };
  protoOf(JsonTreeDecoder).m1m = function (descriptor, index) {
    var strategy = namingStrategy(descriptor, this.f1q());
    var baseName = descriptor.f19(index);
    if (strategy == null) {
      if (!this.d1w_1.b1q_1)
        return baseName;
      if (this.f2().z1().z(baseName))
        return baseName;
    }
    var deserializationNamesMap_0 = deserializationNamesMap(this.f1q(), descriptor);
    // Inline function 'kotlin.collections.find' call
    var this_0 = this.f2().z1();
    var tmp$ret$1;
    $l$block: {
      // Inline function 'kotlin.collections.firstOrNull' call
      var tmp0_iterator = this_0.u();
      while (tmp0_iterator.v()) {
        var element = tmp0_iterator.w();
        // Inline function 'kotlinx.serialization.json.internal.JsonTreeDecoder.elementName.<anonymous>' call
        if (deserializationNamesMap_0.m2(element) === index) {
          tmp$ret$1 = element;
          break $l$block;
        }
      }
      tmp$ret$1 = null;
    }
    var tmp0_safe_receiver = tmp$ret$1;
    if (tmp0_safe_receiver == null)
      null;
    else {
      // Inline function 'kotlin.let' call
      // Inline function 'kotlin.contracts.contract' call
      return tmp0_safe_receiver;
    }
    var fallbackName = strategy == null ? null : strategy.w1s(descriptor, index, baseName);
    return fallbackName == null ? baseName : fallbackName;
  };
  protoOf(JsonTreeDecoder).f1w = function (tag) {
    return getValue(this.f2(), tag);
  };
  protoOf(JsonTreeDecoder).z1a = function (descriptor) {
    if (descriptor === this.z1w_1) {
      var tmp = this.f1q();
      // Inline function 'kotlinx.serialization.json.internal.cast' call
      var value = this.e1w();
      var descriptor_0 = this.z1w_1;
      if (!(value instanceof JsonObject)) {
        throw JsonDecodingException_1(-1, 'Expected ' + getKClass(JsonObject) + ' as the serialized body of ' + descriptor_0.z18() + ', but had ' + getKClassFromExpression(value));
      }
      return new JsonTreeDecoder(tmp, value, this.y1w_1, this.z1w_1);
    }
    return protoOf(AbstractJsonTreeDecoder).z1a.call(this, descriptor);
  };
  protoOf(JsonTreeDecoder).a1b = function (descriptor) {
    var tmp;
    if (this.d1w_1.r1p_1) {
      tmp = true;
    } else {
      var tmp_0 = descriptor.a19();
      tmp = tmp_0 instanceof PolymorphicKind;
    }
    if (tmp)
      return Unit_instance;
    var strategy = namingStrategy(descriptor, this.f1q());
    var tmp_1;
    if (strategy == null ? !this.d1w_1.b1q_1 : false) {
      tmp_1 = jsonCachedSerialNames(descriptor);
    } else if (!(strategy == null)) {
      tmp_1 = deserializationNamesMap(this.f1q(), descriptor).z1();
    } else {
      var tmp_2 = jsonCachedSerialNames(descriptor);
      // Inline function 'kotlin.collections.orEmpty' call
      var tmp0_safe_receiver = get_schemaCache(this.f1q()).g1v(descriptor, get_JsonDeserializationNamesKey());
      var tmp0_elvis_lhs = tmp0_safe_receiver == null ? null : tmp0_safe_receiver.z1();
      var tmp$ret$0 = tmp0_elvis_lhs == null ? emptySet() : tmp0_elvis_lhs;
      tmp_1 = plus_0(tmp_2, tmp$ret$0);
    }
    var names = tmp_1;
    var tmp1_iterator = this.f2().z1().u();
    while (tmp1_iterator.v()) {
      var key = tmp1_iterator.w();
      if (!names.z(key) ? !(key === this.y1w_1) : false) {
        throw UnknownKeyException(key, this.f2().toString());
      }
    }
  };
  function JsonTreeListDecoder(json, value) {
    AbstractJsonTreeDecoder.call(this, json, value);
    this.h1x_1 = value;
    this.i1x_1 = this.h1x_1.n();
    this.j1x_1 = -1;
  }
  protoOf(JsonTreeListDecoder).f2 = function () {
    return this.h1x_1;
  };
  protoOf(JsonTreeListDecoder).m1m = function (descriptor, index) {
    return index.toString();
  };
  protoOf(JsonTreeListDecoder).f1w = function (tag) {
    return this.h1x_1.f1(toInt(tag));
  };
  protoOf(JsonTreeListDecoder).o1b = function (descriptor) {
    while (this.j1x_1 < (this.i1x_1 - 1 | 0)) {
      this.j1x_1 = this.j1x_1 + 1 | 0;
      return this.j1x_1;
    }
    return -1;
  };
  function JsonPrimitiveDecoder(json, value) {
    AbstractJsonTreeDecoder.call(this, json, value);
    this.p1x_1 = value;
    this.e1n(get_PRIMITIVE_TAG());
  }
  protoOf(JsonPrimitiveDecoder).f2 = function () {
    return this.p1x_1;
  };
  protoOf(JsonPrimitiveDecoder).o1b = function (descriptor) {
    return 0;
  };
  protoOf(JsonPrimitiveDecoder).f1w = function (tag) {
    // Inline function 'kotlin.require' call
    // Inline function 'kotlin.contracts.contract' call
    if (!(tag === get_PRIMITIVE_TAG())) {
      // Inline function 'kotlinx.serialization.json.internal.JsonPrimitiveDecoder.currentElement.<anonymous>' call
      var message = "This input can only handle primitives with '" + get_PRIMITIVE_TAG() + "' tag";
      throw IllegalArgumentException_init_$Create$(toString(message));
    }
    return this.p1x_1;
  };
  function JsonTreeMapDecoder(json, value) {
    JsonTreeDecoder.call(this, json, value);
    this.a1y_1 = value;
    this.b1y_1 = toList(this.a1y_1.z1());
    this.c1y_1 = imul(this.b1y_1.n(), 2);
    this.d1y_1 = -1;
  }
  protoOf(JsonTreeMapDecoder).f2 = function () {
    return this.a1y_1;
  };
  protoOf(JsonTreeMapDecoder).m1m = function (descriptor, index) {
    var i = index / 2 | 0;
    return this.b1y_1.f1(i);
  };
  protoOf(JsonTreeMapDecoder).o1b = function (descriptor) {
    while (this.d1y_1 < (this.c1y_1 - 1 | 0)) {
      this.d1y_1 = this.d1y_1 + 1 | 0;
      return this.d1y_1;
    }
    return -1;
  };
  protoOf(JsonTreeMapDecoder).f1w = function (tag) {
    return (this.d1y_1 % 2 | 0) === 0 ? JsonPrimitive_2(tag) : getValue(this.a1y_1, tag);
  };
  protoOf(JsonTreeMapDecoder).a1b = function (descriptor) {
  };
  function readPolymorphicJson(_this__u8e3s4, discriminator, element, deserializer) {
    return (new JsonTreeDecoder(_this__u8e3s4, element, discriminator, deserializer.p18())).y1a(deserializer);
  }
  function get_PRIMITIVE_TAG() {
    return PRIMITIVE_TAG;
  }
  var PRIMITIVE_TAG;
  var WriteMode_OBJ_instance;
  var WriteMode_LIST_instance;
  var WriteMode_MAP_instance;
  var WriteMode_POLY_OBJ_instance;
  function values() {
    return [WriteMode_OBJ_getInstance(), WriteMode_LIST_getInstance(), WriteMode_MAP_getInstance(), WriteMode_POLY_OBJ_getInstance()];
  }
  function get_entries() {
    if ($ENTRIES == null)
      $ENTRIES = enumEntries(values());
    return $ENTRIES;
  }
  var WriteMode_entriesInitialized;
  function WriteMode_initEntries() {
    if (WriteMode_entriesInitialized)
      return Unit_instance;
    WriteMode_entriesInitialized = true;
    WriteMode_OBJ_instance = new WriteMode('OBJ', 0, get_BEGIN_OBJ(), get_END_OBJ());
    WriteMode_LIST_instance = new WriteMode('LIST', 1, get_BEGIN_LIST(), get_END_LIST());
    WriteMode_MAP_instance = new WriteMode('MAP', 2, get_BEGIN_OBJ(), get_END_OBJ());
    WriteMode_POLY_OBJ_instance = new WriteMode('POLY_OBJ', 3, get_BEGIN_LIST(), get_END_LIST());
  }
  var $ENTRIES;
  function WriteMode(name, ordinal, begin, end) {
    Enum.call(this, name, ordinal);
    this.t1v_1 = begin;
    this.u1v_1 = end;
  }
  function switchMode(_this__u8e3s4, desc) {
    var tmp0_subject = desc.a19();
    var tmp;
    if (tmp0_subject instanceof PolymorphicKind) {
      tmp = WriteMode_POLY_OBJ_getInstance();
    } else {
      if (equals(tmp0_subject, LIST_getInstance())) {
        tmp = WriteMode_LIST_getInstance();
      } else {
        if (equals(tmp0_subject, MAP_getInstance())) {
          // Inline function 'kotlinx.serialization.json.internal.selectMapMode' call
          var keyDescriptor = carrierDescriptor(desc.i19(0), _this__u8e3s4.m1b());
          var keyKind = keyDescriptor.a19();
          var tmp_0;
          var tmp_1;
          if (keyKind instanceof PrimitiveKind) {
            tmp_1 = true;
          } else {
            tmp_1 = equals(keyKind, ENUM_getInstance());
          }
          if (tmp_1) {
            // Inline function 'kotlinx.serialization.json.internal.switchMode.<anonymous>' call
            tmp_0 = WriteMode_MAP_getInstance();
          } else {
            if (_this__u8e3s4.h1o_1.t1p_1) {
              // Inline function 'kotlinx.serialization.json.internal.switchMode.<anonymous>' call
              tmp_0 = WriteMode_LIST_getInstance();
            } else {
              throw InvalidKeyKindException(keyDescriptor);
            }
          }
          tmp = tmp_0;
        } else {
          tmp = WriteMode_OBJ_getInstance();
        }
      }
    }
    return tmp;
  }
  function carrierDescriptor(_this__u8e3s4, module_0) {
    var tmp;
    if (equals(_this__u8e3s4.a19(), CONTEXTUAL_getInstance())) {
      var tmp0_safe_receiver = getContextualDescriptor(module_0, _this__u8e3s4);
      var tmp1_elvis_lhs = tmp0_safe_receiver == null ? null : carrierDescriptor(tmp0_safe_receiver, module_0);
      tmp = tmp1_elvis_lhs == null ? _this__u8e3s4 : tmp1_elvis_lhs;
    } else if (_this__u8e3s4.c19()) {
      tmp = carrierDescriptor(_this__u8e3s4.i19(0), module_0);
    } else {
      tmp = _this__u8e3s4;
    }
    return tmp;
  }
  function WriteMode_OBJ_getInstance() {
    WriteMode_initEntries();
    return WriteMode_OBJ_instance;
  }
  function WriteMode_LIST_getInstance() {
    WriteMode_initEntries();
    return WriteMode_LIST_instance;
  }
  function WriteMode_MAP_getInstance() {
    WriteMode_initEntries();
    return WriteMode_MAP_instance;
  }
  function WriteMode_POLY_OBJ_getInstance() {
    WriteMode_initEntries();
    return WriteMode_POLY_OBJ_instance;
  }
  function appendEscape($this, lastPosition, current) {
    $this.e1y(lastPosition, current);
    return appendEsc($this, current + 1 | 0);
  }
  function decodedString($this, lastPosition, currentPosition) {
    $this.e1y(lastPosition, currentPosition);
    var result = $this.y1o_1.toString();
    $this.y1o_1.s7(0);
    return result;
  }
  function takePeeked($this) {
    // Inline function 'kotlin.also' call
    var this_0 = ensureNotNull($this.x1o_1);
    // Inline function 'kotlin.contracts.contract' call
    // Inline function 'kotlinx.serialization.json.internal.AbstractJsonLexer.takePeeked.<anonymous>' call
    $this.x1o_1 = null;
    return this_0;
  }
  function wasUnquotedString($this) {
    return !(charSequenceGet($this.f1y(), $this.v1o_1 - 1 | 0) === _Char___init__impl__6a9atx(34));
  }
  function appendEsc($this, startPosition) {
    var currentPosition = startPosition;
    currentPosition = $this.g1y(currentPosition);
    if (currentPosition === -1) {
      $this.s1s('Expected escape sequence to continue, got EOF');
    }
    var tmp = $this.f1y();
    var tmp0 = currentPosition;
    currentPosition = tmp0 + 1 | 0;
    var currentChar = charSequenceGet(tmp, tmp0);
    if (currentChar === _Char___init__impl__6a9atx(117)) {
      return appendHex($this, $this.f1y(), currentPosition);
    }
    // Inline function 'kotlin.code' call
    var tmp$ret$0 = Char__toInt_impl_vasixd(currentChar);
    var c = escapeToChar(tmp$ret$0);
    if (c === _Char___init__impl__6a9atx(0)) {
      $this.s1s("Invalid escaped char '" + toString_0(currentChar) + "'");
    }
    $this.y1o_1.k5(c);
    return currentPosition;
  }
  function appendHex($this, source, startPos) {
    if ((startPos + 4 | 0) >= charSequenceLength(source)) {
      $this.v1o_1 = startPos;
      $this.h1y();
      if (($this.v1o_1 + 4 | 0) >= charSequenceLength(source)) {
        $this.s1s('Unexpected EOF during unicode escape');
      }
      return appendHex($this, source, $this.v1o_1);
    }
    $this.y1o_1.k5(numberToChar((((fromHexChar($this, source, startPos) << 12) + (fromHexChar($this, source, startPos + 1 | 0) << 8) | 0) + (fromHexChar($this, source, startPos + 2 | 0) << 4) | 0) + fromHexChar($this, source, startPos + 3 | 0) | 0));
    return startPos + 4 | 0;
  }
  function fromHexChar($this, source, currentPosition) {
    var character = charSequenceGet(source, currentPosition);
    var tmp;
    if (_Char___init__impl__6a9atx(48) <= character ? character <= _Char___init__impl__6a9atx(57) : false) {
      // Inline function 'kotlin.code' call
      var tmp_0 = Char__toInt_impl_vasixd(character);
      // Inline function 'kotlin.code' call
      var this_0 = _Char___init__impl__6a9atx(48);
      tmp = tmp_0 - Char__toInt_impl_vasixd(this_0) | 0;
    } else if (_Char___init__impl__6a9atx(97) <= character ? character <= _Char___init__impl__6a9atx(102) : false) {
      // Inline function 'kotlin.code' call
      var tmp_1 = Char__toInt_impl_vasixd(character);
      // Inline function 'kotlin.code' call
      var this_1 = _Char___init__impl__6a9atx(97);
      tmp = (tmp_1 - Char__toInt_impl_vasixd(this_1) | 0) + 10 | 0;
    } else if (_Char___init__impl__6a9atx(65) <= character ? character <= _Char___init__impl__6a9atx(70) : false) {
      // Inline function 'kotlin.code' call
      var tmp_2 = Char__toInt_impl_vasixd(character);
      // Inline function 'kotlin.code' call
      var this_2 = _Char___init__impl__6a9atx(65);
      tmp = (tmp_2 - Char__toInt_impl_vasixd(this_2) | 0) + 10 | 0;
    } else {
      $this.s1s("Invalid toHexChar char '" + toString_0(character) + "' in unicode escape");
    }
    return tmp;
  }
  function consumeBoolean($this, start) {
    var current = $this.g1y(start);
    if (current >= charSequenceLength($this.f1y()) ? true : current === -1) {
      $this.s1s('EOF');
    }
    // Inline function 'kotlin.code' call
    var tmp = $this.f1y();
    var tmp0 = current;
    current = tmp0 + 1 | 0;
    var this_0 = charSequenceGet(tmp, tmp0);
    var tmp1_subject = Char__toInt_impl_vasixd(this_0) | 32;
    var tmp_0;
    // Inline function 'kotlin.code' call
    var this_1 = _Char___init__impl__6a9atx(116);
    if (tmp1_subject === Char__toInt_impl_vasixd(this_1)) {
      consumeBooleanLiteral($this, 'rue', current);
      tmp_0 = true;
    } else {
      // Inline function 'kotlin.code' call
      var this_2 = _Char___init__impl__6a9atx(102);
      if (tmp1_subject === Char__toInt_impl_vasixd(this_2)) {
        consumeBooleanLiteral($this, 'alse', current);
        tmp_0 = false;
      } else {
        $this.s1s("Expected valid boolean literal prefix, but had '" + $this.w1t() + "'");
      }
    }
    return tmp_0;
  }
  function consumeBooleanLiteral($this, literalSuffix, current) {
    if ((charSequenceLength($this.f1y()) - current | 0) < literalSuffix.length) {
      $this.s1s('Unexpected end of boolean literal');
    }
    var inductionVariable = 0;
    var last = charSequenceLength(literalSuffix) - 1 | 0;
    if (inductionVariable <= last)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        var expected = charSequenceGet(literalSuffix, i);
        var actual = charSequenceGet($this.f1y(), current + i | 0);
        // Inline function 'kotlin.code' call
        var tmp = Char__toInt_impl_vasixd(expected);
        // Inline function 'kotlin.code' call
        if (!(tmp === (Char__toInt_impl_vasixd(actual) | 32))) {
          $this.s1s("Expected valid boolean literal prefix, but had '" + $this.w1t() + "'");
        }
      }
       while (inductionVariable <= last);
    $this.v1o_1 = current + literalSuffix.length | 0;
  }
  function consumeNumericLiteral$calculateExponent(exponentAccumulator, isExponentPositive) {
    var tmp;
    switch (isExponentPositive) {
      case false:
        // Inline function 'kotlin.math.pow' call

        var x = -exponentAccumulator.b6();
        tmp = Math.pow(10.0, x);
        break;
      case true:
        // Inline function 'kotlin.math.pow' call

        var x_0 = exponentAccumulator.b6();
        tmp = Math.pow(10.0, x_0);
        break;
      default:
        noWhenBranchMatchedException();
        break;
    }
    return tmp;
  }
  function AbstractJsonLexer() {
    this.v1o_1 = 0;
    this.w1o_1 = new JsonPath();
    this.x1o_1 = null;
    this.y1o_1 = StringBuilder_init_$Create$();
  }
  protoOf(AbstractJsonLexer).h1y = function () {
  };
  protoOf(AbstractJsonLexer).i1y = function (c) {
    return (((c === _Char___init__impl__6a9atx(125) ? true : c === _Char___init__impl__6a9atx(93)) ? true : c === _Char___init__impl__6a9atx(58)) ? true : c === _Char___init__impl__6a9atx(44)) ? false : true;
  };
  protoOf(AbstractJsonLexer).z1o = function () {
    var nextToken = this.y1t();
    if (!(nextToken === 10)) {
      this.s1s('Expected EOF after parsing, but had ' + toString_0(charSequenceGet(this.f1y(), this.v1o_1 - 1 | 0)) + ' instead');
    }
  };
  protoOf(AbstractJsonLexer).s1t = function (expected) {
    var token = this.y1t();
    if (!(token === expected)) {
      this.j1y(expected);
    }
    return token;
  };
  protoOf(AbstractJsonLexer).i1v = function (expected) {
    this.h1y();
    var source = this.f1y();
    var cpos = this.v1o_1;
    $l$loop_0: while (true) {
      cpos = this.g1y(cpos);
      if (cpos === -1)
        break $l$loop_0;
      var tmp0 = cpos;
      cpos = tmp0 + 1 | 0;
      var c = charSequenceGet(source, tmp0);
      if (((c === _Char___init__impl__6a9atx(32) ? true : c === _Char___init__impl__6a9atx(10)) ? true : c === _Char___init__impl__6a9atx(13)) ? true : c === _Char___init__impl__6a9atx(9))
        continue $l$loop_0;
      this.v1o_1 = cpos;
      if (c === expected)
        return Unit_instance;
      this.k1y(expected);
    }
    this.v1o_1 = cpos;
    this.k1y(expected);
  };
  protoOf(AbstractJsonLexer).k1y = function (expected) {
    if (this.v1o_1 > 0 ? expected === _Char___init__impl__6a9atx(34) : false) {
      var tmp$ret$1;
      $l$block: {
        // Inline function 'kotlinx.serialization.json.internal.AbstractJsonLexer.withPositionRollback' call
        var snapshot = this.v1o_1;
        try {
          // Inline function 'kotlinx.serialization.json.internal.AbstractJsonLexer.unexpectedToken.<anonymous>' call
          this.v1o_1 = this.v1o_1 - 1 | 0;
          tmp$ret$1 = this.w1t();
          break $l$block;
        }finally {
          this.v1o_1 = snapshot;
        }
      }
      var inputLiteral = tmp$ret$1;
      if (inputLiteral === 'null') {
        this.r1s("Expected string literal but 'null' literal was found", this.v1o_1 - 1 | 0, "Use 'coerceInputValues = true' in 'Json {}' builder to coerce nulls to default values.");
      }
    }
    this.j1y(charToTokenClass(expected));
  };
  protoOf(AbstractJsonLexer).l1y = function (expectedToken, wasConsumed) {
    var expected = tokenDescription(expectedToken);
    var position = wasConsumed ? this.v1o_1 - 1 | 0 : this.v1o_1;
    var s = (this.v1o_1 === charSequenceLength(this.f1y()) ? true : position < 0) ? 'EOF' : toString_0(charSequenceGet(this.f1y(), position));
    this.s1s('Expected ' + expected + ", but had '" + s + "' instead", position);
  };
  protoOf(AbstractJsonLexer).j1y = function (expectedToken, wasConsumed, $super) {
    wasConsumed = wasConsumed === VOID ? true : wasConsumed;
    return $super === VOID ? this.l1y(expectedToken, wasConsumed) : $super.l1y.call(this, expectedToken, wasConsumed);
  };
  protoOf(AbstractJsonLexer).t1t = function () {
    var source = this.f1y();
    var cpos = this.v1o_1;
    $l$loop_0: while (true) {
      cpos = this.g1y(cpos);
      if (cpos === -1)
        break $l$loop_0;
      var ch = charSequenceGet(source, cpos);
      if (((ch === _Char___init__impl__6a9atx(32) ? true : ch === _Char___init__impl__6a9atx(10)) ? true : ch === _Char___init__impl__6a9atx(13)) ? true : ch === _Char___init__impl__6a9atx(9)) {
        cpos = cpos + 1 | 0;
        continue $l$loop_0;
      }
      this.v1o_1 = cpos;
      return charToTokenClass(ch);
    }
    this.v1o_1 = cpos;
    return 10;
  };
  protoOf(AbstractJsonLexer).k1v = function (doConsume) {
    var current = this.m1y();
    current = this.g1y(current);
    var len = charSequenceLength(this.f1y()) - current | 0;
    if (len < 4 ? true : current === -1)
      return false;
    var inductionVariable = 0;
    if (inductionVariable <= 3)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        if (!(charSequenceGet('null', i) === charSequenceGet(this.f1y(), current + i | 0)))
          return false;
      }
       while (inductionVariable <= 3);
    if (len > 4 ? charToTokenClass(charSequenceGet(this.f1y(), current + 4 | 0)) === 0 : false)
      return false;
    if (doConsume) {
      this.v1o_1 = current + 4 | 0;
    }
    return true;
  };
  protoOf(AbstractJsonLexer).v1v = function (doConsume, $super) {
    doConsume = doConsume === VOID ? true : doConsume;
    return $super === VOID ? this.k1v(doConsume) : $super.k1v.call(this, doConsume);
  };
  protoOf(AbstractJsonLexer).m1y = function () {
    var current = this.v1o_1;
    $l$loop_0: while (true) {
      current = this.g1y(current);
      if (current === -1)
        break $l$loop_0;
      var c = charSequenceGet(this.f1y(), current);
      if (((c === _Char___init__impl__6a9atx(32) ? true : c === _Char___init__impl__6a9atx(10)) ? true : c === _Char___init__impl__6a9atx(13)) ? true : c === _Char___init__impl__6a9atx(9)) {
        current = current + 1 | 0;
      } else {
        break $l$loop_0;
      }
    }
    this.v1o_1 = current;
    return current;
  };
  protoOf(AbstractJsonLexer).l1v = function (isLenient) {
    var token = this.t1t();
    var tmp;
    if (isLenient) {
      if (!(token === 1) ? !(token === 0) : false)
        return null;
      tmp = this.w1t();
    } else {
      if (!(token === 1))
        return null;
      tmp = this.v1t();
    }
    var string = tmp;
    this.x1o_1 = string;
    return string;
  };
  protoOf(AbstractJsonLexer).n1y = function () {
    this.x1o_1 = null;
  };
  protoOf(AbstractJsonLexer).o1y = function (startPos, endPos) {
    // Inline function 'kotlin.text.substring' call
    var this_0 = this.f1y();
    return toString(charSequenceSubSequence(this_0, startPos, endPos));
  };
  protoOf(AbstractJsonLexer).v1t = function () {
    if (!(this.x1o_1 == null)) {
      return takePeeked(this);
    }
    return this.o1v();
  };
  protoOf(AbstractJsonLexer).consumeString2 = function (source, startPosition, current) {
    var currentPosition = current;
    var lastPosition = startPosition;
    var char = charSequenceGet(source, currentPosition);
    var usedAppend = false;
    while (!(char === _Char___init__impl__6a9atx(34))) {
      if (char === _Char___init__impl__6a9atx(92)) {
        usedAppend = true;
        currentPosition = this.g1y(appendEscape(this, lastPosition, currentPosition));
        if (currentPosition === -1) {
          this.s1s('Unexpected EOF', currentPosition);
        }
        lastPosition = currentPosition;
      } else {
        currentPosition = currentPosition + 1 | 0;
        if (currentPosition >= charSequenceLength(source)) {
          usedAppend = true;
          this.e1y(lastPosition, currentPosition);
          currentPosition = this.g1y(currentPosition);
          if (currentPosition === -1) {
            this.s1s('Unexpected EOF', currentPosition);
          }
          lastPosition = currentPosition;
        }
      }
      char = charSequenceGet(source, currentPosition);
    }
    var tmp;
    if (!usedAppend) {
      tmp = this.o1y(lastPosition, currentPosition);
    } else {
      tmp = decodedString(this, lastPosition, currentPosition);
    }
    var string = tmp;
    this.v1o_1 = currentPosition + 1 | 0;
    return string;
  };
  protoOf(AbstractJsonLexer).p1v = function () {
    var result = this.w1t();
    if (result === 'null' ? wasUnquotedString(this) : false) {
      this.s1s("Unexpected 'null' value instead of string literal");
    }
    return result;
  };
  protoOf(AbstractJsonLexer).w1t = function () {
    if (!(this.x1o_1 == null)) {
      return takePeeked(this);
    }
    var current = this.m1y();
    if (current >= charSequenceLength(this.f1y()) ? true : current === -1) {
      this.s1s('EOF', current);
    }
    var token = charToTokenClass(charSequenceGet(this.f1y(), current));
    if (token === 1) {
      return this.v1t();
    }
    if (!(token === 0)) {
      this.s1s('Expected beginning of the string, but got ' + toString_0(charSequenceGet(this.f1y(), current)));
    }
    var usedAppend = false;
    while (charToTokenClass(charSequenceGet(this.f1y(), current)) === 0) {
      current = current + 1 | 0;
      if (current >= charSequenceLength(this.f1y())) {
        usedAppend = true;
        this.e1y(this.v1o_1, current);
        var eof = this.g1y(current);
        if (eof === -1) {
          this.v1o_1 = current;
          return decodedString(this, 0, 0);
        } else {
          current = eof;
        }
      }
    }
    var tmp;
    if (!usedAppend) {
      tmp = this.o1y(this.v1o_1, current);
    } else {
      tmp = decodedString(this, this.v1o_1, current);
    }
    var result = tmp;
    this.v1o_1 = current;
    return result;
  };
  protoOf(AbstractJsonLexer).e1y = function (fromIndex, toIndex) {
    this.y1o_1.n7(this.f1y(), fromIndex, toIndex);
  };
  protoOf(AbstractJsonLexer).n1v = function (allowLenientStrings) {
    // Inline function 'kotlin.collections.mutableListOf' call
    var tokenStack = ArrayList_init_$Create$();
    var lastToken = this.t1t();
    if (!(lastToken === 8) ? !(lastToken === 6) : false) {
      this.w1t();
      return Unit_instance;
    }
    $l$loop: while (true) {
      lastToken = this.t1t();
      if (lastToken === 1) {
        if (allowLenientStrings) {
          this.w1t();
        } else {
          this.o1v();
        }
        continue $l$loop;
      }
      var tmp0_subject = lastToken;
      if (tmp0_subject === 8 ? true : tmp0_subject === 6) {
        tokenStack.r(lastToken);
      } else if (tmp0_subject === 9) {
        if (!(last(tokenStack) === 8))
          throw JsonDecodingException_0(this.v1o_1, 'found ] instead of } at path: ' + this.w1o_1, this.f1y());
        removeLast(tokenStack);
      } else if (tmp0_subject === 7) {
        if (!(last(tokenStack) === 6))
          throw JsonDecodingException_0(this.v1o_1, 'found } instead of ] at path: ' + this.w1o_1, this.f1y());
        removeLast(tokenStack);
      } else if (tmp0_subject === 10) {
        this.s1s('Unexpected end of input due to malformed JSON during ignoring unknown keys');
      }
      this.y1t();
      if (tokenStack.n() === 0)
        return Unit_instance;
    }
  };
  protoOf(AbstractJsonLexer).toString = function () {
    return "JsonReader(source='" + this.f1y() + "', currentPosition=" + this.v1o_1 + ')';
  };
  protoOf(AbstractJsonLexer).m1v = function (key) {
    var processed = this.o1y(0, this.v1o_1);
    var lastIndexOf_0 = lastIndexOf(processed, key);
    this.r1s("Encountered an unknown key '" + key + "'", lastIndexOf_0, "Use 'ignoreUnknownKeys = true' in 'Json {}' builder to ignore unknown keys.");
  };
  protoOf(AbstractJsonLexer).r1s = function (message, position, hint) {
    var tmp;
    // Inline function 'kotlin.text.isEmpty' call
    if (charSequenceLength(hint) === 0) {
      tmp = '';
    } else {
      tmp = '\n' + hint;
    }
    var hintMessage = tmp;
    throw JsonDecodingException_0(position, message + ' at path: ' + this.w1o_1.f1t() + hintMessage, this.f1y());
  };
  protoOf(AbstractJsonLexer).s1s = function (message, position, hint, $super) {
    position = position === VOID ? this.v1o_1 : position;
    hint = hint === VOID ? '' : hint;
    return $super === VOID ? this.r1s(message, position, hint) : $super.r1s.call(this, message, position, hint);
  };
  protoOf(AbstractJsonLexer).t1q = function () {
    var current = this.m1y();
    current = this.g1y(current);
    if (current >= charSequenceLength(this.f1y()) ? true : current === -1) {
      this.s1s('EOF');
    }
    var tmp;
    if (charSequenceGet(this.f1y(), current) === _Char___init__impl__6a9atx(34)) {
      current = current + 1 | 0;
      if (current === charSequenceLength(this.f1y())) {
        this.s1s('EOF');
      }
      tmp = true;
    } else {
      tmp = false;
    }
    var hasQuotation = tmp;
    var accumulator = new Long(0, 0);
    var exponentAccumulator = new Long(0, 0);
    var isNegative = false;
    var isExponentPositive = false;
    var hasExponent = false;
    var start = current;
    $l$loop_4: while (!(current === charSequenceLength(this.f1y()))) {
      var ch = charSequenceGet(this.f1y(), current);
      if ((ch === _Char___init__impl__6a9atx(101) ? true : ch === _Char___init__impl__6a9atx(69)) ? !hasExponent : false) {
        if (current === start) {
          this.s1s('Unexpected symbol ' + toString_0(ch) + ' in numeric literal');
        }
        isExponentPositive = true;
        hasExponent = true;
        current = current + 1 | 0;
        continue $l$loop_4;
      }
      if (ch === _Char___init__impl__6a9atx(45) ? hasExponent : false) {
        if (current === start) {
          this.s1s("Unexpected symbol '-' in numeric literal");
        }
        isExponentPositive = false;
        current = current + 1 | 0;
        continue $l$loop_4;
      }
      if (ch === _Char___init__impl__6a9atx(43) ? hasExponent : false) {
        if (current === start) {
          this.s1s("Unexpected symbol '+' in numeric literal");
        }
        isExponentPositive = true;
        current = current + 1 | 0;
        continue $l$loop_4;
      }
      if (ch === _Char___init__impl__6a9atx(45)) {
        if (!(current === start)) {
          this.s1s("Unexpected symbol '-' in numeric literal");
        }
        isNegative = true;
        current = current + 1 | 0;
        continue $l$loop_4;
      }
      var token = charToTokenClass(ch);
      if (!(token === 0))
        break $l$loop_4;
      current = current + 1 | 0;
      var digit = Char__minus_impl_a2frrh(ch, _Char___init__impl__6a9atx(48));
      if (!(0 <= digit ? digit <= 9 : false)) {
        this.s1s("Unexpected symbol '" + toString_0(ch) + "' in numeric literal");
      }
      if (hasExponent) {
        // Inline function 'kotlin.Long.plus' call
        // Inline function 'kotlin.Long.times' call
        exponentAccumulator = exponentAccumulator.j8(toLong(10)).k9(toLong(digit));
        continue $l$loop_4;
      }
      // Inline function 'kotlin.Long.minus' call
      // Inline function 'kotlin.Long.times' call
      accumulator = accumulator.j8(toLong(10)).l9(toLong(digit));
      if (accumulator.d6(new Long(0, 0)) > 0) {
        this.s1s('Numeric value overflow');
      }
    }
    var hasChars = !(current === start);
    if (start === current ? true : isNegative ? start === (current - 1 | 0) : false) {
      this.s1s('Expected numeric literal');
    }
    if (hasQuotation) {
      if (!hasChars) {
        this.s1s('EOF');
      }
      if (!(charSequenceGet(this.f1y(), current) === _Char___init__impl__6a9atx(34))) {
        this.s1s('Expected closing quotation mark');
      }
      current = current + 1 | 0;
    }
    this.v1o_1 = current;
    if (hasExponent) {
      var doubleAccumulator = accumulator.b6() * consumeNumericLiteral$calculateExponent(exponentAccumulator, isExponentPositive);
      var tmp_0;
      Companion_getInstance_3();
      if (doubleAccumulator > (new Long(-1, 2147483647)).b6()) {
        tmp_0 = true;
      } else {
        Companion_getInstance_3();
        tmp_0 = doubleAccumulator < (new Long(0, -2147483648)).b6();
      }
      if (tmp_0) {
        this.s1s('Numeric value overflow');
      }
      // Inline function 'kotlin.math.floor' call
      if (!(Math.floor(doubleAccumulator) === doubleAccumulator)) {
        this.s1s("Can't convert " + doubleAccumulator + ' to Long');
      }
      accumulator = numberToLong(doubleAccumulator);
    }
    var tmp_1;
    if (isNegative) {
      tmp_1 = accumulator;
    } else {
      var tmp_2 = accumulator;
      Companion_getInstance_3();
      if (!tmp_2.equals(new Long(0, -2147483648))) {
        tmp_1 = accumulator.c6();
      } else {
        this.s1s('Numeric value overflow');
      }
    }
    return tmp_1;
  };
  protoOf(AbstractJsonLexer).w1v = function () {
    var current = this.m1y();
    if (current === charSequenceLength(this.f1y())) {
      this.s1s('EOF');
    }
    var tmp;
    if (charSequenceGet(this.f1y(), current) === _Char___init__impl__6a9atx(34)) {
      current = current + 1 | 0;
      tmp = true;
    } else {
      tmp = false;
    }
    var hasQuotation = tmp;
    var result = consumeBoolean(this, current);
    if (hasQuotation) {
      if (this.v1o_1 === charSequenceLength(this.f1y())) {
        this.s1s('EOF');
      }
      if (!(charSequenceGet(this.f1y(), this.v1o_1) === _Char___init__impl__6a9atx(34))) {
        this.s1s('Expected closing quotation mark');
      }
      this.v1o_1 = this.v1o_1 + 1 | 0;
    }
    return result;
  };
  function charToTokenClass(c) {
    var tmp;
    // Inline function 'kotlin.code' call
    if (Char__toInt_impl_vasixd(c) < 126) {
      var tmp_0 = CharMappings_getInstance().q1y_1;
      // Inline function 'kotlin.code' call
      tmp = tmp_0[Char__toInt_impl_vasixd(c)];
    } else {
      tmp = 0;
    }
    return tmp;
  }
  function get_TC_WHITESPACE() {
    return TC_WHITESPACE;
  }
  var TC_WHITESPACE;
  function get_TC_EOF() {
    return TC_EOF;
  }
  var TC_EOF;
  function get_STRING() {
    return STRING;
  }
  var STRING;
  function get_TC_STRING() {
    return TC_STRING;
  }
  var TC_STRING;
  function get_STRING_ESC() {
    return STRING_ESC;
  }
  var STRING_ESC;
  function get_TC_BEGIN_OBJ() {
    return TC_BEGIN_OBJ;
  }
  var TC_BEGIN_OBJ;
  function get_TC_COLON() {
    return TC_COLON;
  }
  var TC_COLON;
  function get_TC_COMMA() {
    return TC_COMMA;
  }
  var TC_COMMA;
  function get_COLON() {
    return COLON;
  }
  var COLON;
  function get_BEGIN_OBJ() {
    return BEGIN_OBJ;
  }
  var BEGIN_OBJ;
  function get_END_OBJ() {
    return END_OBJ;
  }
  var END_OBJ;
  function get_BEGIN_LIST() {
    return BEGIN_LIST;
  }
  var BEGIN_LIST;
  function get_END_LIST() {
    return END_LIST;
  }
  var END_LIST;
  function get_lenientHint() {
    return lenientHint;
  }
  var lenientHint;
  function get_INVALID() {
    return INVALID;
  }
  var INVALID;
  function get_COMMA() {
    return COMMA;
  }
  var COMMA;
  function get_NULL() {
    return NULL;
  }
  var NULL;
  function tokenDescription(token) {
    return token === 1 ? "quotation mark '\"'" : token === 2 ? "string escape sequence '\\'" : token === 4 ? "comma ','" : token === 5 ? "colon ':'" : token === 6 ? "start of the object '{'" : token === 7 ? "end of the object '}'" : token === 8 ? "start of the array '['" : token === 9 ? "end of the array ']'" : token === 10 ? 'end of the input' : token === 127 ? 'invalid token' : 'valid token';
  }
  function get_TC_OTHER() {
    return TC_OTHER;
  }
  var TC_OTHER;
  function escapeToChar(c) {
    return c < 117 ? CharMappings_getInstance().p1y_1[c] : _Char___init__impl__6a9atx(0);
  }
  function get_TC_BEGIN_LIST() {
    return TC_BEGIN_LIST;
  }
  var TC_BEGIN_LIST;
  function get_TC_END_LIST() {
    return TC_END_LIST;
  }
  var TC_END_LIST;
  function get_TC_END_OBJ() {
    return TC_END_OBJ;
  }
  var TC_END_OBJ;
  function get_ignoreUnknownKeysHint() {
    return ignoreUnknownKeysHint;
  }
  var ignoreUnknownKeysHint;
  function initEscape($this) {
    var inductionVariable = 0;
    if (inductionVariable <= 31)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        initC2ESC($this, i, _Char___init__impl__6a9atx(117));
      }
       while (inductionVariable <= 31);
    initC2ESC($this, 8, _Char___init__impl__6a9atx(98));
    initC2ESC($this, 9, _Char___init__impl__6a9atx(116));
    initC2ESC($this, 10, _Char___init__impl__6a9atx(110));
    initC2ESC($this, 12, _Char___init__impl__6a9atx(102));
    initC2ESC($this, 13, _Char___init__impl__6a9atx(114));
    initC2ESC_0($this, _Char___init__impl__6a9atx(47), _Char___init__impl__6a9atx(47));
    initC2ESC_0($this, _Char___init__impl__6a9atx(34), _Char___init__impl__6a9atx(34));
    initC2ESC_0($this, _Char___init__impl__6a9atx(92), _Char___init__impl__6a9atx(92));
  }
  function initCharToToken($this) {
    var inductionVariable = 0;
    if (inductionVariable <= 32)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        initC2TC($this, i, 127);
      }
       while (inductionVariable <= 32);
    initC2TC($this, 9, 3);
    initC2TC($this, 10, 3);
    initC2TC($this, 13, 3);
    initC2TC($this, 32, 3);
    initC2TC_0($this, _Char___init__impl__6a9atx(44), 4);
    initC2TC_0($this, _Char___init__impl__6a9atx(58), 5);
    initC2TC_0($this, _Char___init__impl__6a9atx(123), 6);
    initC2TC_0($this, _Char___init__impl__6a9atx(125), 7);
    initC2TC_0($this, _Char___init__impl__6a9atx(91), 8);
    initC2TC_0($this, _Char___init__impl__6a9atx(93), 9);
    initC2TC_0($this, _Char___init__impl__6a9atx(34), 1);
    initC2TC_0($this, _Char___init__impl__6a9atx(92), 2);
  }
  function initC2ESC($this, c, esc) {
    if (!(esc === _Char___init__impl__6a9atx(117))) {
      // Inline function 'kotlin.code' call
      var tmp$ret$0 = Char__toInt_impl_vasixd(esc);
      $this.p1y_1[tmp$ret$0] = numberToChar(c);
    }
  }
  function initC2ESC_0($this, c, esc) {
    // Inline function 'kotlin.code' call
    var tmp$ret$0 = Char__toInt_impl_vasixd(c);
    return initC2ESC($this, tmp$ret$0, esc);
  }
  function initC2TC($this, c, cl) {
    $this.q1y_1[c] = cl;
  }
  function initC2TC_0($this, c, cl) {
    // Inline function 'kotlin.code' call
    var tmp$ret$0 = Char__toInt_impl_vasixd(c);
    return initC2TC($this, tmp$ret$0, cl);
  }
  function CharMappings() {
    CharMappings_instance = this;
    this.p1y_1 = charArray(117);
    this.q1y_1 = new Int8Array(126);
    initEscape(this);
    initCharToToken(this);
  }
  var CharMappings_instance;
  function CharMappings_getInstance() {
    if (CharMappings_instance == null)
      new CharMappings();
    return CharMappings_instance;
  }
  function get_specialFlowingValuesHint() {
    return specialFlowingValuesHint;
  }
  var specialFlowingValuesHint;
  function get_allowStructuredMapKeysHint() {
    return allowStructuredMapKeysHint;
  }
  var allowStructuredMapKeysHint;
  function StringJsonLexer(source) {
    AbstractJsonLexer.call(this);
    this.v1y_1 = source;
  }
  protoOf(StringJsonLexer).f1y = function () {
    return this.v1y_1;
  };
  protoOf(StringJsonLexer).g1y = function (position) {
    return position < this.v1y_1.length ? position : -1;
  };
  protoOf(StringJsonLexer).y1t = function () {
    var source = this.v1y_1;
    $l$loop: while (!(this.v1o_1 === -1) ? this.v1o_1 < source.length : false) {
      var tmp1 = this.v1o_1;
      this.v1o_1 = tmp1 + 1 | 0;
      var ch = charSequenceGet(source, tmp1);
      var tc = charToTokenClass(ch);
      var tmp;
      if (tc === get_TC_WHITESPACE()) {
        continue $l$loop;
      } else {
        tmp = tc;
      }
      return tmp;
    }
    return get_TC_EOF();
  };
  protoOf(StringJsonLexer).j1v = function () {
    var current = this.m1y();
    if (current === this.v1y_1.length ? true : current === -1)
      return false;
    if (charSequenceGet(this.v1y_1, current) === _Char___init__impl__6a9atx(44)) {
      this.v1o_1 = this.v1o_1 + 1 | 0;
      return true;
    }
    return false;
  };
  protoOf(StringJsonLexer).u1t = function () {
    var current = this.v1o_1;
    if (current === -1)
      return false;
    $l$loop: while (current < this.v1y_1.length) {
      var c = charSequenceGet(this.v1y_1, current);
      if (((c === _Char___init__impl__6a9atx(32) ? true : c === _Char___init__impl__6a9atx(10)) ? true : c === _Char___init__impl__6a9atx(13)) ? true : c === _Char___init__impl__6a9atx(9)) {
        current = current + 1 | 0;
        continue $l$loop;
      }
      this.v1o_1 = current;
      return this.i1y(c);
    }
    this.v1o_1 = current;
    return false;
  };
  protoOf(StringJsonLexer).m1y = function () {
    var current = this.v1o_1;
    if (current === -1)
      return current;
    $l$loop: while (current < this.v1y_1.length) {
      var c = charSequenceGet(this.v1y_1, current);
      if (((c === _Char___init__impl__6a9atx(32) ? true : c === _Char___init__impl__6a9atx(10)) ? true : c === _Char___init__impl__6a9atx(13)) ? true : c === _Char___init__impl__6a9atx(9)) {
        current = current + 1 | 0;
      } else {
        break $l$loop;
      }
    }
    this.v1o_1 = current;
    return current;
  };
  protoOf(StringJsonLexer).i1v = function (expected) {
    if (this.v1o_1 === -1) {
      this.k1y(expected);
    }
    var source = this.v1y_1;
    $l$loop: while (this.v1o_1 < source.length) {
      var tmp1 = this.v1o_1;
      this.v1o_1 = tmp1 + 1 | 0;
      var c = charSequenceGet(source, tmp1);
      if (((c === _Char___init__impl__6a9atx(32) ? true : c === _Char___init__impl__6a9atx(10)) ? true : c === _Char___init__impl__6a9atx(13)) ? true : c === _Char___init__impl__6a9atx(9))
        continue $l$loop;
      if (c === expected)
        return Unit_instance;
      this.k1y(expected);
    }
    this.v1o_1 = -1;
    this.k1y(expected);
  };
  protoOf(StringJsonLexer).o1v = function () {
    this.i1v(get_STRING());
    var current = this.v1o_1;
    var closingQuote = indexOf(this.v1y_1, _Char___init__impl__6a9atx(34), current);
    if (closingQuote === -1) {
      this.w1t();
      this.l1y(get_TC_STRING(), false);
    }
    var inductionVariable = current;
    if (inductionVariable < closingQuote)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        if (charSequenceGet(this.v1y_1, i) === get_STRING_ESC()) {
          return this.consumeString2(this.v1y_1, this.v1o_1, i);
        }
      }
       while (inductionVariable < closingQuote);
    this.v1o_1 = closingQuote + 1 | 0;
    // Inline function 'kotlin.text.substring' call
    // Inline function 'kotlin.js.asDynamic' call
    return this.v1y_1.substring(current, closingQuote);
  };
  protoOf(StringJsonLexer).q1v = function (keyToMatch, isLenient) {
    var positionSnapshot = this.v1o_1;
    try {
      if (!(this.y1t() === get_TC_BEGIN_OBJ()))
        return null;
      var firstKey = this.l1v(isLenient);
      if (!(firstKey === keyToMatch))
        return null;
      this.n1y();
      if (!(this.y1t() === get_TC_COLON()))
        return null;
      return this.l1v(isLenient);
    }finally {
      this.v1o_1 = positionSnapshot;
      this.n1y();
    }
  };
  function get_schemaCache(_this__u8e3s4) {
    return _this__u8e3s4.j1o_1;
  }
  function JsonToStringWriter() {
    this.m1o_1 = StringBuilder_init_$Create$_0(128);
  }
  protoOf(JsonToStringWriter).y1r = function (value) {
    this.m1o_1.q7(value);
  };
  protoOf(JsonToStringWriter).s1r = function (char) {
    this.m1o_1.k5(char);
  };
  protoOf(JsonToStringWriter).u1r = function (text) {
    this.m1o_1.j5(text);
  };
  protoOf(JsonToStringWriter).e1s = function (text) {
    printQuoted(this.m1o_1, text);
  };
  protoOf(JsonToStringWriter).wo = function () {
    this.m1o_1.t7();
  };
  protoOf(JsonToStringWriter).toString = function () {
    return this.m1o_1.toString();
  };
  function createMapForCache(initialCapacity) {
    return HashMap_init_$Create$(initialCapacity);
  }
  //region block: post-declaration
  protoOf(defer$1).b19 = get_isNullable;
  protoOf(defer$1).c19 = get_isInline;
  protoOf(defer$1).e19 = get_annotations;
  protoOf(PolymorphismValidator).d1o = contextual;
  //endregion
  //region block: init
  Companion_instance_0 = new Companion();
  Companion_instance_1 = new Companion_0();
  Companion_instance_2 = new Companion_1();
  Companion_instance_3 = new Companion_2();
  Tombstone_instance = new Tombstone();
  PRIMITIVE_TAG = 'primitive';
  TC_WHITESPACE = 3;
  TC_EOF = 10;
  STRING = _Char___init__impl__6a9atx(34);
  TC_STRING = 1;
  STRING_ESC = _Char___init__impl__6a9atx(92);
  TC_BEGIN_OBJ = 6;
  TC_COLON = 5;
  TC_COMMA = 4;
  COLON = _Char___init__impl__6a9atx(58);
  BEGIN_OBJ = _Char___init__impl__6a9atx(123);
  END_OBJ = _Char___init__impl__6a9atx(125);
  BEGIN_LIST = _Char___init__impl__6a9atx(91);
  END_LIST = _Char___init__impl__6a9atx(93);
  lenientHint = "Use 'isLenient = true' in 'Json {}' builder to accept non-compliant JSON.";
  INVALID = _Char___init__impl__6a9atx(0);
  COMMA = _Char___init__impl__6a9atx(44);
  NULL = 'null';
  TC_OTHER = 0;
  TC_BEGIN_LIST = 8;
  TC_END_LIST = 9;
  TC_END_OBJ = 7;
  ignoreUnknownKeysHint = "Use 'ignoreUnknownKeys = true' in 'Json {}' builder to ignore unknown keys.";
  specialFlowingValuesHint = "It is possible to deserialize them using 'JsonBuilder.allowSpecialFloatingPointValues = true'";
  allowStructuredMapKeysHint = "Use 'allowStructuredMapKeys = true' in 'Json {}' builder to convert such maps to [key1, value1, key2, value2,...] arrays.";
  //endregion
  //region block: exports
  _.$_$ = _.$_$ || {};
  _.$_$.a = JsonNull_getInstance;
  _.$_$.b = JsonObjectSerializer_getInstance;
  _.$_$.c = JsonNull;
  _.$_$.d = JsonObject;
  _.$_$.e = JsonPrimitive_2;
  _.$_$.f = JsonPrimitive_0;
  _.$_$.g = JsonPrimitive_1;
  _.$_$.h = Json_0;
  _.$_$.i = get_boolean;
  _.$_$.j = get_double;
  _.$_$.k = get_float;
  _.$_$.l = get_int;
  _.$_$.m = get_jsonPrimitive;
  _.$_$.n = get_long;
  //endregion
  return _;
}));

//# sourceMappingURL=kotlinx-serialization-kotlinx-serialization-json.js.map
