/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.meshrabiya.server;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.bluetooth.BluetoothServerSocket;
import android.bluetooth.BluetoothSocket;
import android.content.Context;
import android.util.Log;
import com.ustadmobile.meshrabiya.log.MNetLogger;
import com.ustadmobile.meshrabiya.log.MNetLoggerStdout;
import com.ustadmobile.meshrabiya.server.OnUuidAllocatedListener;
import com.ustadmobile.meshrabiya.vnet.bluetooth.VirtualNodeGattServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.functions.Function6;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rawhttp.core.RawHttp;
import rawhttp.core.RawHttpRequest;
import rawhttp.core.RawHttpResponse;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 ,2\u00020\u0001:\u0001,B\u00bd\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u008d\u0001\b\u0002\u0010\u000b\u001a\u0086\u0001\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0002\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0006\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00130\f\u00a2\u0006\u0002\u0010\u0014J\u0006\u0010\"\u001a\u00020#J\u001c\u0010$\u001a\u0006\u0012\u0002\b\u00030%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H&J\u0006\u0010*\u001a\u00020#J\u0006\u0010+\u001a\u00020#R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/ustadmobile/meshrabiya/server/AbstractHttpOverBluetoothServer;", "", "appContext", "Landroid/content/Context;", "rawHttp", "Lrawhttp/core/RawHttp;", "allocationServiceUuid", "Ljava/util/UUID;", "allocationCharacteristicUuid", "maxClients", "", "uuidAllocationServerFactory", "Lkotlin/Function6;", "Lkotlin/ParameterName;", "name", "Lcom/ustadmobile/meshrabiya/log/MNetLogger;", "vnetLogger", "Lcom/ustadmobile/meshrabiya/server/OnUuidAllocatedListener;", "onUuidAllocated", "Lcom/ustadmobile/meshrabiya/vnet/bluetooth/VirtualNodeGattServer;", "(Landroid/content/Context;Lrawhttp/core/RawHttp;Ljava/util/UUID;Ljava/util/UUID;ILkotlin/jvm/functions/Function6;)V", "getAppContext", "()Landroid/content/Context;", "bluetoothAdapter", "Landroid/bluetooth/BluetoothAdapter;", "bluetoothManager", "Landroid/bluetooth/BluetoothManager;", "isClosed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isStarted", "onUuidAllocatedListener", "getRawHttp", "()Lrawhttp/core/RawHttp;", "uuidAllocationServer", "close", "", "handleRequest", "Lrawhttp/core/RawHttpResponse;", "remoteDeviceAddress", "", "request", "Lrawhttp/core/RawHttpRequest;", "start", "stop", "Companion", "lib-meshrabiya_release"})
public abstract class AbstractHttpOverBluetoothServer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context appContext;
    @NotNull
    private final RawHttp rawHttp;
    @NotNull
    private final AtomicBoolean isClosed;
    @NotNull
    private final AtomicBoolean isStarted;
    @NotNull
    private final BluetoothManager bluetoothManager;
    @Nullable
    private final BluetoothAdapter bluetoothAdapter;
    @NotNull
    private final OnUuidAllocatedListener onUuidAllocatedListener;
    @NotNull
    private final VirtualNodeGattServer uuidAllocationServer;
    public static final int SOCKET_ACCEPT_TIMEOUT = 12000;

    public AbstractHttpOverBluetoothServer(@NotNull Context appContext, @NotNull RawHttp rawHttp, @NotNull UUID allocationServiceUuid, @NotNull UUID allocationCharacteristicUuid, int maxClients, @NotNull Function6<? super Context, ? super UUID, ? super UUID, ? super MNetLogger, ? super Integer, ? super OnUuidAllocatedListener, VirtualNodeGattServer> uuidAllocationServerFactory) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Intrinsics.checkNotNullParameter((Object)rawHttp, (String)"rawHttp");
        Intrinsics.checkNotNullParameter((Object)allocationServiceUuid, (String)"allocationServiceUuid");
        Intrinsics.checkNotNullParameter((Object)allocationCharacteristicUuid, (String)"allocationCharacteristicUuid");
        Intrinsics.checkNotNullParameter(uuidAllocationServerFactory, (String)"uuidAllocationServerFactory");
        this.appContext = appContext;
        this.rawHttp = rawHttp;
        this.isClosed = new AtomicBoolean(false);
        this.isStarted = new AtomicBoolean(false);
        Object object = this.appContext.getSystemService(BluetoothManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSystemService(...)");
        this.bluetoothManager = (BluetoothManager)object;
        this.bluetoothAdapter = this.bluetoothManager.getAdapter();
        this.onUuidAllocatedListener = arg_0 -> AbstractHttpOverBluetoothServer.onUuidAllocatedListener$lambda$1(this, arg_0);
        this.uuidAllocationServer = (VirtualNodeGattServer)uuidAllocationServerFactory.invoke((Object)this.appContext, (Object)allocationServiceUuid, (Object)allocationCharacteristicUuid, (Object)new MNetLoggerStdout(0, 1, null), (Object)maxClients, (Object)this.onUuidAllocatedListener);
    }

    public /* synthetic */ AbstractHttpOverBluetoothServer(Context context, RawHttp rawHttp, UUID uUID, UUID uUID2, int n, Function6 function6, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            function6 = 1.INSTANCE;
        }
        this(context, rawHttp, uUID, uUID2, n, (Function6<? super Context, ? super UUID, ? super UUID, ? super MNetLogger, ? super Integer, ? super OnUuidAllocatedListener, VirtualNodeGattServer>)function6);
    }

    @NotNull
    protected final Context getAppContext() {
        return this.appContext;
    }

    @NotNull
    protected final RawHttp getRawHttp() {
        return this.rawHttp;
    }

    public final void start() {
        if (this.isClosed.get()) {
            throw new IllegalStateException("HttpOverBluetoothServer is closed.");
        }
        this.isStarted.set(true);
        this.uuidAllocationServer.start();
    }

    public final void stop() {
        this.isStarted.set(false);
        this.uuidAllocationServer.stop();
    }

    public final void close() {
        if (!this.isClosed.getAndSet(true)) {
            Log.d((String)"Meshrabiya", (String)"Closing BluetoothOverHttpServer");
            this.uuidAllocationServer.close();
        }
    }

    @NotNull
    public abstract RawHttpResponse<?> handleRequest(@NotNull String var1, @NotNull RawHttpRequest var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void onUuidAllocatedListener$lambda$1(AbstractHttpOverBluetoothServer this$0, UUID uuid) {
        block11: {
            BluetoothSocket clientSocket;
            BluetoothSocket bluetoothSocket;
            BluetoothServerSocket bluetoothServerSocket;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            try {
                BluetoothAdapter bluetoothAdapter2 = this$0.bluetoothAdapter;
                bluetoothServerSocket = bluetoothAdapter2 != null ? bluetoothAdapter2.listenUsingInsecureRfcommWithServiceRecord("ustad", uuid) : null;
            }
            catch (SecurityException e) {
                bluetoothServerSocket = null;
            }
            BluetoothServerSocket serverSocket = bluetoothServerSocket;
            try {
                Log.d((String)"Meshrabiya", (String)("Listening for data request on " + uuid));
                BluetoothServerSocket bluetoothServerSocket2 = serverSocket;
                bluetoothSocket = bluetoothServerSocket2 != null ? bluetoothServerSocket2.accept(12000) : null;
            }
            catch (IOException e) {
                Log.e((String)"Meshrabiya", (String)"Exception accepting socket", (Throwable)e);
                bluetoothSocket = null;
            }
            BluetoothSocket bluetoothSocket2 = clientSocket = bluetoothSocket;
            if (bluetoothSocket2 == null) break block11;
            BluetoothSocket socket = bluetoothSocket = bluetoothSocket2;
            boolean bl = false;
            Log.d((String)"Meshrabiya", (String)("client connected to " + uuid));
            try {
                InputStream inStream = socket.getInputStream();
                OutputStream outStream = socket.getOutputStream();
                while (this$0.isStarted.get()) {
                    RawHttpRequest request = this$0.rawHttp.parseRequest(inStream);
                    String string = socket.getRemoteDevice().getAddress();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAddress(...)");
                    Intrinsics.checkNotNull((Object)request);
                    RawHttpResponse<?> response = this$0.handleRequest(string, request);
                    response.writeTo(outStream);
                    outStream.flush();
                }
            }
            catch (Exception e) {
                Log.w((String)"Meshrabiya", (String)("Exception handling socket " + uuid), (Throwable)e);
            }
            finally {
                Log.d((String)"Meshrabiya", (String)("Closing server socket on " + uuid));
                BluetoothServerSocket bluetoothServerSocket3 = serverSocket;
                if (bluetoothServerSocket3 != null) {
                    bluetoothServerSocket3.close();
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/ustadmobile/meshrabiya/server/AbstractHttpOverBluetoothServer$Companion;", "", "()V", "SOCKET_ACCEPT_TIMEOUT", "", "lib-meshrabiya_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

