/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.meshrabiya.vnet.quic;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a6\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"generateKeyPair", "Ljava/security/KeyPair;", "generateX509Cert", "Ljava/security/cert/X509Certificate;", "keyPair", "startDate", "Ljava/util/Date;", "endDate", "issuerName", "Lorg/bouncycastle/asn1/x500/X500Name;", "subjectName", "lib-meshrabiya_release"})
public final class CertGeneratorKt {
    @NotNull
    public static final KeyPair generateKeyPair() {
        KeyPairGenerator keyGenerator = KeyPairGenerator.getInstance("RSA");
        keyGenerator.initialize(2048, new SecureRandom());
        KeyPair keyPair = keyGenerator.generateKeyPair();
        Intrinsics.checkNotNull((Object)keyPair);
        return keyPair;
    }

    @NotNull
    public static final X509Certificate generateX509Cert(@NotNull KeyPair keyPair, @NotNull Date startDate, @NotNull Date endDate, @NotNull X500Name issuerName, @NotNull X500Name subjectName) {
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        Intrinsics.checkNotNullParameter((Object)startDate, (String)"startDate");
        Intrinsics.checkNotNullParameter((Object)endDate, (String)"endDate");
        Intrinsics.checkNotNullParameter((Object)issuerName, (String)"issuerName");
        Intrinsics.checkNotNullParameter((Object)subjectName, (String)"subjectName");
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded());
        X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(issuerName, BigInteger.valueOf(System.currentTimeMillis()), startDate, endDate, subjectName, subjectPublicKeyInfo);
        ContentSigner signer = new JcaContentSignerBuilder("SHA256WithRSA").setProvider((Provider)new BouncyCastleProvider()).build(keyPair.getPrivate());
        X509CertificateHolder certHolder = certBuilder.build(signer);
        X509Certificate cert = new JcaX509CertificateConverter().setProvider((Provider)new BouncyCastleProvider()).getCertificate(certHolder);
        Intrinsics.checkNotNull((Object)cert);
        return cert;
    }

    public static /* synthetic */ X509Certificate generateX509Cert$default(KeyPair keyPair, Date date, Date date2, X500Name x500Name, X500Name x500Name2, int n, Object object) {
        if ((n & 2) != 0) {
            date = new Date();
        }
        if ((n & 4) != 0) {
            Calendar it = Calendar.getInstance();
            boolean bl = false;
            it.set(1, it.get(1) + 10);
            date2 = new Date(it.getTimeInMillis());
        }
        if ((n & 8) != 0) {
            x500Name = new X500Name("CN=Meshrabiya");
        }
        if ((n & 0x10) != 0) {
            x500Name2 = new X500Name("CN=Meshrabiya, OU=Mesh Net, O=UstadMobile FZLLC, L=Dubai, C=AE");
        }
        return CertGeneratorKt.generateX509Cert(keyPair, date, date2, x500Name, x500Name2);
    }
}

