/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.meshrabiya.vnet.socket;

import android.net.Network;
import com.ustadmobile.meshrabiya.ext.InetAddressExtKt;
import com.ustadmobile.meshrabiya.log.MNetLogger;
import com.ustadmobile.meshrabiya.vnet.VirtualRouter;
import com.ustadmobile.meshrabiya.vnet.socket.ChainSocket;
import com.ustadmobile.meshrabiya.vnet.socket.ChainSocketExtKt;
import com.ustadmobile.meshrabiya.vnet.socket.ChainSocketFactory;
import com.ustadmobile.meshrabiya.vnet.socket.ChainSocketInitRequest;
import com.ustadmobile.meshrabiya.vnet.socket.ChainSocketNextHop;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.SocketFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J5\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0012H\u0002\u00a2\u0006\u0002\u0010\u0019J\f\u0010\u001a\u001a\u00020\u001b*\u00020\u0010H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001c"}, d2={"Lcom/ustadmobile/meshrabiya/vnet/socket/ChainSocketFactoryImpl;", "Lcom/ustadmobile/meshrabiya/vnet/socket/ChainSocketFactory;", "virtualRouter", "Lcom/ustadmobile/meshrabiya/vnet/VirtualRouter;", "systemSocketFactory", "Ljavax/net/SocketFactory;", "logger", "Lcom/ustadmobile/meshrabiya/log/MNetLogger;", "(Lcom/ustadmobile/meshrabiya/vnet/VirtualRouter;Ljavax/net/SocketFactory;Lcom/ustadmobile/meshrabiya/log/MNetLogger;)V", "logPrefix", "", "getVirtualRouter$lib_meshrabiya_release", "()Lcom/ustadmobile/meshrabiya/vnet/VirtualRouter;", "createChainSocket", "Lcom/ustadmobile/meshrabiya/vnet/socket/ChainSocketFactory$ChainSocketResult;", "address", "Ljava/net/InetAddress;", "port", "", "createSocket", "Ljava/net/Socket;", "localAddress", "localPort", "host", "createSocketForVirtualAddress", "(Ljava/net/InetAddress;ILjava/net/InetAddress;Ljava/lang/Integer;)Lcom/ustadmobile/meshrabiya/vnet/socket/ChainSocketFactory$ChainSocketResult;", "isVirtualAddress", "", "lib-meshrabiya_release"})
public final class ChainSocketFactoryImpl
extends ChainSocketFactory {
    @NotNull
    private final VirtualRouter virtualRouter;
    @NotNull
    private final SocketFactory systemSocketFactory;
    @NotNull
    private final MNetLogger logger;
    @NotNull
    private final String logPrefix;

    public ChainSocketFactoryImpl(@NotNull VirtualRouter virtualRouter, @NotNull SocketFactory systemSocketFactory, @NotNull MNetLogger logger) {
        Intrinsics.checkNotNullParameter((Object)virtualRouter, (String)"virtualRouter");
        Intrinsics.checkNotNullParameter((Object)systemSocketFactory, (String)"systemSocketFactory");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.virtualRouter = virtualRouter;
        this.systemSocketFactory = systemSocketFactory;
        this.logger = logger;
        this.logPrefix = "[ChainSocketFactoryImpl for " + this.virtualRouter.getAddress() + "]";
    }

    public /* synthetic */ ChainSocketFactoryImpl(VirtualRouter virtualRouter, SocketFactory socketFactory, MNetLogger mNetLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            SocketFactory socketFactory2 = SocketFactory.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)socketFactory2, (String)"getDefault(...)");
            socketFactory = socketFactory2;
        }
        this(virtualRouter, socketFactory, mNetLogger);
    }

    @NotNull
    public final VirtualRouter getVirtualRouter$lib_meshrabiya_release() {
        return this.virtualRouter;
    }

    private final ChainSocketFactory.ChainSocketResult createSocketForVirtualAddress(InetAddress address, int port, InetAddress localAddress, Integer localPort) {
        try {
            ChainSocketNextHop nextHop = this.virtualRouter.lookupNextHopForChainSocket(address, port);
            Network network = nextHop.getNetwork();
            SocketFactory socketFactory = network != null ? network.getSocketFactory() : null;
            if (socketFactory == null) {
                socketFactory = this.systemSocketFactory;
            }
            SocketFactory socketFactory2 = socketFactory;
            Socket socket = localAddress != null && localPort != null ? socketFactory2.createSocket(nextHop.getAddress(), nextHop.getPort(), localAddress, (int)localPort) : socketFactory2.createSocket(nextHop.getAddress(), nextHop.getPort());
            Intrinsics.checkNotNull((Object)socket);
            ChainSocketExtKt.initializeChainIfNotFinalDest(socket, new ChainSocketInitRequest(address, port, this.virtualRouter.getAddress(), 0, 8, null), nextHop);
            MNetLogger.invoke$default(this.logger, 4, this.logPrefix + " created socket to " + address + ":" + port + " nexthop = " + nextHop.getAddress() + ":" + nextHop.getPort(), null, 4, null);
            return new ChainSocketFactory.ChainSocketResult(socket, nextHop);
        }
        catch (Exception e) {
            this.logger.invoke(6, this.logPrefix + " exception creating socket", e);
            throw e;
        }
    }

    static /* synthetic */ ChainSocketFactory.ChainSocketResult createSocketForVirtualAddress$default(ChainSocketFactoryImpl chainSocketFactoryImpl, InetAddress inetAddress, int n, InetAddress inetAddress2, Integer n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            inetAddress2 = null;
        }
        if ((n3 & 8) != 0) {
            n2 = null;
        }
        return chainSocketFactoryImpl.createSocketForVirtualAddress(inetAddress, n, inetAddress2, n2);
    }

    private final boolean isVirtualAddress(InetAddress $this$isVirtualAddress) {
        return InetAddressExtKt.prefixMatches($this$isVirtualAddress, this.virtualRouter.getNetworkPrefixLength(), this.virtualRouter.getAddress());
    }

    @Override
    @NotNull
    public Socket createSocket(@NotNull String host, int port) {
        Socket socket;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        InetAddress address = InetAddress.getByName(host);
        Intrinsics.checkNotNull((Object)address);
        if (this.isVirtualAddress(address)) {
            socket = ChainSocketFactoryImpl.createSocketForVirtualAddress$default(this, address, port, null, null, 12, null).getSocket();
        } else {
            Socket socket2 = this.systemSocketFactory.createSocket(host, port);
            Intrinsics.checkNotNull((Object)socket2);
            socket = socket2;
        }
        return socket;
    }

    @Override
    @NotNull
    public Socket createSocket(@NotNull String host, int port, @NotNull InetAddress localAddress, int localPort) {
        Socket socket;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)localAddress, (String)"localAddress");
        InetAddress address = InetAddress.getByName(host);
        Intrinsics.checkNotNull((Object)address);
        if (this.isVirtualAddress(address)) {
            socket = this.createSocketForVirtualAddress(address, port, localAddress, localPort).getSocket();
        } else {
            Socket socket2 = this.systemSocketFactory.createSocket(host, port, localAddress, localPort);
            Intrinsics.checkNotNull((Object)socket2);
            socket = socket2;
        }
        return socket;
    }

    @Override
    @NotNull
    public Socket createSocket(@NotNull InetAddress address, int port) {
        Socket socket;
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        if (this.isVirtualAddress(address)) {
            socket = ChainSocketFactoryImpl.createSocketForVirtualAddress$default(this, address, port, null, null, 12, null).getSocket();
        } else {
            Socket socket2 = this.systemSocketFactory.createSocket(address, port);
            Intrinsics.checkNotNull((Object)socket2);
            socket = socket2;
        }
        return socket;
    }

    @Override
    @NotNull
    public Socket createSocket(@NotNull InetAddress address, int port, @NotNull InetAddress localAddress, int localPort) {
        Socket socket;
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)localAddress, (String)"localAddress");
        if (this.isVirtualAddress(address)) {
            socket = this.createSocketForVirtualAddress(address, port, localAddress, localPort).getSocket();
        } else {
            Socket socket2 = this.systemSocketFactory.createSocket(address, port, localAddress, localPort);
            Intrinsics.checkNotNull((Object)socket2);
            socket = socket2;
        }
        return socket;
    }

    @Override
    @NotNull
    public Socket createSocket() {
        return new ChainSocket(this.virtualRouter, this.logger);
    }

    @Override
    @NotNull
    public ChainSocketFactory.ChainSocketResult createChainSocket(@NotNull InetAddress address, int port) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return ChainSocketFactoryImpl.createSocketForVirtualAddress$default(this, address, port, null, null, 12, null);
    }
}

