/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.meshrabiya.vnet.socket;

import com.ustadmobile.meshrabiya.ext.InputStreamExtKt;
import com.ustadmobile.meshrabiya.ext.OutputStreamExtKt;
import com.ustadmobile.meshrabiya.log.MNetLogger;
import com.ustadmobile.meshrabiya.vnet.socket.ChainSocketFactory;
import com.ustadmobile.meshrabiya.vnet.socket.ChainSocketInitRequest;
import com.ustadmobile.meshrabiya.vnet.socket.ChainSocketInitResponse;
import com.ustadmobile.meshrabiya.vnet.socket.ChainSocketServer;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002&'Br\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012C\b\u0002\u0010\f\u001a=\u0012\u0004\u0012\u00020\u0007\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\b\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u000f\u0012\b\b\b\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00130\r\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\u0010\u0015J\b\u0010\"\u001a\u00020#H\u0016J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u0012\u0012\u0002\b\u0003 \u001a*\b\u0012\u0002\b\u0003\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001b\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00190\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RI\u0010\f\u001a=\u0012\u0004\u0012\u00020\u0007\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\b\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u000f\u0012\b\b\b\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00130\r\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/ustadmobile/meshrabiya/vnet/socket/ChainSocketServer;", "Ljava/io/Closeable;", "serverSocket", "Ljava/net/ServerSocket;", "executorService", "Ljava/util/concurrent/ExecutorService;", "chainSocketFactory", "Lcom/ustadmobile/meshrabiya/vnet/socket/ChainSocketFactory;", "name", "", "logger", "Lcom/ustadmobile/meshrabiya/log/MNetLogger;", "onMakeChainSocket", "Lkotlin/Function3;", "Ljava/net/InetAddress;", "Lkotlin/ParameterName;", "address", "", "port", "Lcom/ustadmobile/meshrabiya/vnet/socket/ChainSocketFactory$ChainSocketResult;", "Lkotlin/ExtensionFunctionType;", "(Ljava/net/ServerSocket;Ljava/util/concurrent/ExecutorService;Lcom/ustadmobile/meshrabiya/vnet/socket/ChainSocketFactory;Ljava/lang/String;Lcom/ustadmobile/meshrabiya/log/MNetLogger;Lkotlin/jvm/functions/Function3;)V", "acceptRunnable", "Ljava/lang/Runnable;", "acceptRunnableFuture", "Ljava/util/concurrent/Future;", "kotlin.jvm.PlatformType", "clientFutures", "", "Ljava/lang/ref/WeakReference;", "localPort", "getLocalPort", "()I", "logPrefix", "close", "", "closeSocket", "", "ClientInitRunnable", "CopyStreamRunnable", "lib-meshrabiya_release"})
@SourceDebugExtension(value={"SMAP\nChainSocketServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChainSocketServer.kt\ncom/ustadmobile/meshrabiya/vnet/socket/ChainSocketServer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,179:1\n1855#2,2:180\n1#3:182\n*S KotlinDebug\n*F\n+ 1 ChainSocketServer.kt\ncom/ustadmobile/meshrabiya/vnet/socket/ChainSocketServer\n*L\n168#1:180,2\n*E\n"})
public final class ChainSocketServer
implements Closeable {
    @NotNull
    private final ServerSocket serverSocket;
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private final ChainSocketFactory chainSocketFactory;
    @NotNull
    private final MNetLogger logger;
    @NotNull
    private final Function3<ChainSocketFactory, InetAddress, Integer, ChainSocketFactory.ChainSocketResult> onMakeChainSocket;
    @NotNull
    private final String logPrefix;
    @NotNull
    private final List<WeakReference<Future<?>>> clientFutures;
    @NotNull
    private final Runnable acceptRunnable;
    private final int localPort;
    private final Future<?> acceptRunnableFuture;

    public ChainSocketServer(@NotNull ServerSocket serverSocket, @NotNull ExecutorService executorService, @NotNull ChainSocketFactory chainSocketFactory, @NotNull String name, @NotNull MNetLogger logger, @NotNull Function3<? super ChainSocketFactory, ? super InetAddress, ? super Integer, ChainSocketFactory.ChainSocketResult> onMakeChainSocket) {
        Intrinsics.checkNotNullParameter((Object)serverSocket, (String)"serverSocket");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        Intrinsics.checkNotNullParameter((Object)chainSocketFactory, (String)"chainSocketFactory");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(onMakeChainSocket, (String)"onMakeChainSocket");
        this.serverSocket = serverSocket;
        this.executorService = executorService;
        this.chainSocketFactory = chainSocketFactory;
        this.logger = logger;
        this.onMakeChainSocket = onMakeChainSocket;
        this.logPrefix = "[ChainSocketServer: " + name + "] ";
        this.clientFutures = new CopyOnWriteArrayList();
        this.acceptRunnable = () -> ChainSocketServer.acceptRunnable$lambda$0(this);
        this.localPort = this.serverSocket.getLocalPort();
        this.acceptRunnableFuture = this.executorService.submit(this.acceptRunnable);
        MNetLogger.invoke$default(this.logger, 4, this.logPrefix + " init", null, 4, null);
    }

    public /* synthetic */ ChainSocketServer(ServerSocket serverSocket, ExecutorService executorService, ChainSocketFactory chainSocketFactory, String string, MNetLogger mNetLogger, Function3 function3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            function3 = 1.INSTANCE;
        }
        this(serverSocket, executorService, chainSocketFactory, string, mNetLogger, (Function3<? super ChainSocketFactory, ? super InetAddress, ? super Integer, ChainSocketFactory.ChainSocketResult>)function3);
    }

    public final int getLocalPort() {
        return this.localPort;
    }

    public final void close(boolean closeSocket) {
        ServerSocket serverSocket;
        this.acceptRunnableFuture.cancel(true);
        Iterable $this$forEach$iv = this.clientFutures;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WeakReference it = (WeakReference)element$iv;
            boolean bl = false;
            Future future = (Future)it.get();
            if (future == null) continue;
            future.cancel(true);
        }
        ServerSocket it = serverSocket = this.serverSocket;
        boolean bl = false;
        ServerSocket serverSocket2 = closeSocket ? serverSocket : null;
        if (serverSocket2 != null) {
            serverSocket2.close();
        }
        MNetLogger.invoke$default(this.logger, 4, this.logPrefix + " closed", null, 4, null);
    }

    @Override
    public void close() {
        this.close(false);
    }

    private static final void acceptRunnable$lambda$0(ChainSocketServer this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        while (!Thread.interrupted() && !this$0.serverSocket.isClosed()) {
            try {
                Socket incomingSocket = this$0.serverSocket.accept();
                MNetLogger.invoke$default(this$0.logger, 3, this$0.logPrefix + " accepted new client", null, 4, null);
                ExecutorService executorService = this$0.executorService;
                Intrinsics.checkNotNull((Object)incomingSocket);
                executorService.submit(this$0.new ClientInitRunnable(incomingSocket));
            }
            catch (Exception e) {
                if (this$0.serverSocket.isClosed()) continue;
                this$0.logger.invoke(5, this$0.logPrefix + " exception accepting client", e);
                Thread.sleep(1000L);
            }
        }
    }

    public static final /* synthetic */ String access$getLogPrefix$p(ChainSocketServer $this) {
        return $this.logPrefix;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/ustadmobile/meshrabiya/vnet/socket/ChainSocketServer$ClientInitRunnable;", "Ljava/lang/Runnable;", "incomingSocket", "Ljava/net/Socket;", "(Lcom/ustadmobile/meshrabiya/vnet/socket/ChainSocketServer;Ljava/net/Socket;)V", "run", "", "lib-meshrabiya_release"})
    private final class ClientInitRunnable
    implements Runnable {
        @NotNull
        private final Socket incomingSocket;

        public ClientInitRunnable(Socket incomingSocket) {
            Intrinsics.checkNotNullParameter((Object)incomingSocket, (String)"incomingSocket");
            this.incomingSocket = incomingSocket;
        }

        @Override
        public void run() {
            MNetLogger.invoke$default(ChainSocketServer.this.logger, 3, (Function0)new Function0<String>(ChainSocketServer.this, this){
                final /* synthetic */ ChainSocketServer this$0;
                final /* synthetic */ ClientInitRunnable this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return ChainSocketServer.access$getLogPrefix$p(this.this$0) + " " + ClientInitRunnable.access$getIncomingSocket$p(this.this$1).getRemoteSocketAddress() + " : init client - reading init request...";
                }
            }, null, 4, null);
            InputStream inStream = this.incomingSocket.getInputStream();
            Intrinsics.checkNotNull((Object)inStream);
            ChainSocketInitRequest initRequest = ChainSocketInitRequest.Companion.fromBytes$default(ChainSocketInitRequest.Companion, InputStreamExtKt.readyByteArrayOfSizeOrThrow(inStream, 13), 0, 2, null);
            SocketAddress clientAddr = this.incomingSocket.getRemoteSocketAddress();
            MNetLogger.invoke$default(ChainSocketServer.this.logger, 3, (Function0)new Function0<String>(ChainSocketServer.this, clientAddr, initRequest){
                final /* synthetic */ ChainSocketServer this$0;
                final /* synthetic */ SocketAddress $clientAddr;
                final /* synthetic */ ChainSocketInitRequest $initRequest;
                {
                    this.this$0 = $receiver;
                    this.$clientAddr = $clientAddr;
                    this.$initRequest = $initRequest;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return ChainSocketServer.access$getLogPrefix$p(this.this$0) + " " + this.$clientAddr + " : receive init request to connect to " + this.$initRequest.getVirtualDestAddr() + ":" + this.$initRequest.getVirtualDestPort();
                }
            }, null, 4, null);
            ChainSocketFactory.ChainSocketResult chainSocketResult = (ChainSocketFactory.ChainSocketResult)ChainSocketServer.this.onMakeChainSocket.invoke((Object)ChainSocketServer.this.chainSocketFactory, (Object)initRequest.getVirtualDestAddr(), (Object)initRequest.getVirtualDestPort());
            MNetLogger.invoke$default(ChainSocketServer.this.logger, 3, (Function0)new Function0<String>(ChainSocketServer.this, clientAddr){
                final /* synthetic */ ChainSocketServer this$0;
                final /* synthetic */ SocketAddress $clientAddr;
                {
                    this.this$0 = $receiver;
                    this.$clientAddr = $clientAddr;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return ChainSocketServer.access$getLogPrefix$p(this.this$0) + " " + this.$clientAddr + " : created onward socket";
                }
            }, null, 4, null);
            OutputStream outputStream = this.incomingSocket.getOutputStream();
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
            OutputStreamExtKt.writeChainSocketInitResponse(outputStream, new ChainSocketInitResponse(200));
            this.incomingSocket.getOutputStream().flush();
            MNetLogger.invoke$default(ChainSocketServer.this.logger, 3, (Function0)new Function0<String>(ChainSocketServer.this, clientAddr){
                final /* synthetic */ ChainSocketServer this$0;
                final /* synthetic */ SocketAddress $clientAddr;
                {
                    this.this$0 = $receiver;
                    this.$clientAddr = $clientAddr;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return ChainSocketServer.access$getLogPrefix$p(this.this$0) + " " + this.$clientAddr + " : wrote chain init response";
                }
            }, null, 4, null);
            Socket onwardSocket = chainSocketResult.getSocket();
            ExecutorService executorService = ChainSocketServer.this.executorService;
            Intrinsics.checkNotNull((Object)clientAddr);
            Future<?> onwardToIncomingFuture = executorService.submit(new CopyStreamRunnable(ChainSocketServer.this, clientAddr, onwardSocket, this.incomingSocket, "onwardToIncoming", null, 16, null));
            Future<?> incomingToOnwardFuture = ChainSocketServer.this.executorService.submit(new CopyStreamRunnable(ChainSocketServer.this, clientAddr, this.incomingSocket, onwardSocket, "incomingToOnward", onwardToIncomingFuture));
            ((Collection)ChainSocketServer.this.clientFutures).add(new WeakReference(onwardToIncomingFuture));
            ((Collection)ChainSocketServer.this.clientFutures).add(new WeakReference(incomingToOnwardFuture));
        }

        public static final /* synthetic */ Socket access$getIncomingSocket$p(ClientInitRunnable $this) {
            return $this.incomingSocket;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/ustadmobile/meshrabiya/vnet/socket/ChainSocketServer$CopyStreamRunnable;", "Ljava/lang/Runnable;", "clientAddr", "Ljava/net/SocketAddress;", "fromSocket", "Ljava/net/Socket;", "toSocket", "name", "", "otherFuture", "Ljava/util/concurrent/Future;", "(Lcom/ustadmobile/meshrabiya/vnet/socket/ChainSocketServer;Ljava/net/SocketAddress;Ljava/net/Socket;Ljava/net/Socket;Ljava/lang/String;Ljava/util/concurrent/Future;)V", "run", "", "lib-meshrabiya_release"})
    private final class CopyStreamRunnable
    implements Runnable {
        @NotNull
        private final SocketAddress clientAddr;
        @NotNull
        private final Socket fromSocket;
        @NotNull
        private final Socket toSocket;
        @NotNull
        private final String name;
        @Nullable
        private final Future<?> otherFuture;
        final /* synthetic */ ChainSocketServer this$0;

        public CopyStreamRunnable(@NotNull ChainSocketServer this$0, @NotNull SocketAddress clientAddr, @NotNull Socket fromSocket, @NotNull Socket toSocket, @Nullable String name, Future<?> otherFuture) {
            Intrinsics.checkNotNullParameter((Object)clientAddr, (String)"clientAddr");
            Intrinsics.checkNotNullParameter((Object)fromSocket, (String)"fromSocket");
            Intrinsics.checkNotNullParameter((Object)toSocket, (String)"toSocket");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.this$0 = this$0;
            this.clientAddr = clientAddr;
            this.fromSocket = fromSocket;
            this.toSocket = toSocket;
            this.name = name;
            this.otherFuture = otherFuture;
        }

        public /* synthetic */ CopyStreamRunnable(ChainSocketServer chainSocketServer, SocketAddress socketAddress, Socket socket, Socket socket2, String string, Future future, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                future = null;
            }
            this(chainSocketServer, socketAddress, socket, socket2, string, future);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            OutputStream outStream = this.toSocket.getOutputStream();
            InputStream inStream = this.fromSocket.getInputStream();
            try {
                MNetLogger.invoke$default(this.this$0.logger, 2, (Function0)new Function0<String>(this.this$0, this){
                    final /* synthetic */ ChainSocketServer this$0;
                    final /* synthetic */ CopyStreamRunnable this$1;
                    {
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return ChainSocketServer.access$getLogPrefix$p(this.this$0) + " " + CopyStreamRunnable.access$getClientAddr$p(this.this$1) + " : CopyStream: " + CopyStreamRunnable.access$getName$p(this.this$1) + " - start copying input to output";
                    }
                }, null, 4, null);
                Intrinsics.checkNotNull((Object)inStream);
                Intrinsics.checkNotNull((Object)outStream);
                ByteStreamsKt.copyTo$default((InputStream)inStream, (OutputStream)outStream, (int)0, (int)2, null);
                MNetLogger.invoke$default(this.this$0.logger, 2, (Function0)new Function0<String>(this.this$0, this){
                    final /* synthetic */ ChainSocketServer this$0;
                    final /* synthetic */ CopyStreamRunnable this$1;
                    {
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return ChainSocketServer.access$getLogPrefix$p(this.this$0) + " " + CopyStreamRunnable.access$getClientAddr$p(this.this$1) + " : CopyStream: " + CopyStreamRunnable.access$getName$p(this.this$1) + " - finished copying - reached end of stream";
                    }
                }, null, 4, null);
            }
            catch (Exception e) {
                this.this$0.logger.invoke(5, (Function0<String>)((Function0)new Function0<String>(this.this$0, this){
                    final /* synthetic */ ChainSocketServer this$0;
                    final /* synthetic */ CopyStreamRunnable this$1;
                    {
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return ChainSocketServer.access$getLogPrefix$p(this.this$0) + " " + CopyStreamRunnable.access$getClientAddr$p(this.this$1) + ": CopyStream: aborting";
                    }
                }), e);
            }
            finally {
                inStream.close();
                outStream.close();
                if (this.otherFuture != null) {
                    this.otherFuture.get();
                    this.fromSocket.close();
                    this.toSocket.close();
                }
            }
            this.this$0.clientFutures.removeIf(arg_0 -> CopyStreamRunnable.run$lambda$0(run.4.INSTANCE, arg_0));
        }

        private static final boolean run$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ SocketAddress access$getClientAddr$p(CopyStreamRunnable $this) {
            return $this.clientAddr;
        }

        public static final /* synthetic */ String access$getName$p(CopyStreamRunnable $this) {
            return $this.name;
        }
    }
}

