/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.meshrabiya.vnet;

import com.ustadmobile.meshrabiya.ext.InetAddressExtKt;
import com.ustadmobile.meshrabiya.ext.IntExtKt;
import com.ustadmobile.meshrabiya.vnet.bluetooth.MeshrabiyaBluetoothState;
import com.ustadmobile.meshrabiya.vnet.wifi.WifiConnectConfig;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\tH\u00c6\u0003J5\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lcom/ustadmobile/meshrabiya/vnet/MeshrabiyaConnectLink;", "", "uri", "", "virtualAddress", "", "hotspotConfig", "Lcom/ustadmobile/meshrabiya/vnet/wifi/WifiConnectConfig;", "bluetoothConfig", "Lcom/ustadmobile/meshrabiya/vnet/bluetooth/MeshrabiyaBluetoothState;", "(Ljava/lang/String;ILcom/ustadmobile/meshrabiya/vnet/wifi/WifiConnectConfig;Lcom/ustadmobile/meshrabiya/vnet/bluetooth/MeshrabiyaBluetoothState;)V", "getBluetoothConfig", "()Lcom/ustadmobile/meshrabiya/vnet/bluetooth/MeshrabiyaBluetoothState;", "getHotspotConfig", "()Lcom/ustadmobile/meshrabiya/vnet/wifi/WifiConnectConfig;", "getUri", "()Ljava/lang/String;", "getVirtualAddress", "()I", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "lib-meshrabiya_release"})
public final class MeshrabiyaConnectLink {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String uri;
    private final int virtualAddress;
    @Nullable
    private final WifiConnectConfig hotspotConfig;
    @Nullable
    private final MeshrabiyaBluetoothState bluetoothConfig;
    @NotNull
    public static final String PROTO = "meshrabiya";
    @NotNull
    private static final String PROTO_PREFIX = "meshrabiya://";

    public MeshrabiyaConnectLink(@NotNull String uri, int virtualAddress, @Nullable WifiConnectConfig hotspotConfig, @Nullable MeshrabiyaBluetoothState bluetoothConfig) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.uri = uri;
        this.virtualAddress = virtualAddress;
        this.hotspotConfig = hotspotConfig;
        this.bluetoothConfig = bluetoothConfig;
    }

    @NotNull
    public final String getUri() {
        return this.uri;
    }

    public final int getVirtualAddress() {
        return this.virtualAddress;
    }

    @Nullable
    public final WifiConnectConfig getHotspotConfig() {
        return this.hotspotConfig;
    }

    @Nullable
    public final MeshrabiyaBluetoothState getBluetoothConfig() {
        return this.bluetoothConfig;
    }

    @NotNull
    public final String component1() {
        return this.uri;
    }

    public final int component2() {
        return this.virtualAddress;
    }

    @Nullable
    public final WifiConnectConfig component3() {
        return this.hotspotConfig;
    }

    @Nullable
    public final MeshrabiyaBluetoothState component4() {
        return this.bluetoothConfig;
    }

    @NotNull
    public final MeshrabiyaConnectLink copy(@NotNull String uri, int virtualAddress, @Nullable WifiConnectConfig hotspotConfig, @Nullable MeshrabiyaBluetoothState bluetoothConfig) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return new MeshrabiyaConnectLink(uri, virtualAddress, hotspotConfig, bluetoothConfig);
    }

    public static /* synthetic */ MeshrabiyaConnectLink copy$default(MeshrabiyaConnectLink meshrabiyaConnectLink, String string, int n, WifiConnectConfig wifiConnectConfig, MeshrabiyaBluetoothState meshrabiyaBluetoothState, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = meshrabiyaConnectLink.uri;
        }
        if ((n2 & 2) != 0) {
            n = meshrabiyaConnectLink.virtualAddress;
        }
        if ((n2 & 4) != 0) {
            wifiConnectConfig = meshrabiyaConnectLink.hotspotConfig;
        }
        if ((n2 & 8) != 0) {
            meshrabiyaBluetoothState = meshrabiyaConnectLink.bluetoothConfig;
        }
        return meshrabiyaConnectLink.copy(string, n, wifiConnectConfig, meshrabiyaBluetoothState);
    }

    @NotNull
    public String toString() {
        return "MeshrabiyaConnectLink(uri=" + this.uri + ", virtualAddress=" + this.virtualAddress + ", hotspotConfig=" + this.hotspotConfig + ", bluetoothConfig=" + this.bluetoothConfig + ")";
    }

    public int hashCode() {
        int result = this.uri.hashCode();
        result = result * 31 + Integer.hashCode(this.virtualAddress);
        result = result * 31 + (this.hotspotConfig == null ? 0 : this.hotspotConfig.hashCode());
        result = result * 31 + (this.bluetoothConfig == null ? 0 : this.bluetoothConfig.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MeshrabiyaConnectLink)) {
            return false;
        }
        MeshrabiyaConnectLink meshrabiyaConnectLink = (MeshrabiyaConnectLink)other;
        if (!Intrinsics.areEqual((Object)this.uri, (Object)meshrabiyaConnectLink.uri)) {
            return false;
        }
        if (this.virtualAddress != meshrabiyaConnectLink.virtualAddress) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.hotspotConfig, (Object)meshrabiyaConnectLink.hotspotConfig)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.bluetoothConfig, (Object)meshrabiyaConnectLink.bluetoothConfig);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00042\b\b\u0002\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/ustadmobile/meshrabiya/vnet/MeshrabiyaConnectLink$Companion;", "", "()V", "PROTO", "", "PROTO_PREFIX", "fromComponents", "Lcom/ustadmobile/meshrabiya/vnet/MeshrabiyaConnectLink;", "nodeAddr", "", "port", "hotspotConfig", "Lcom/ustadmobile/meshrabiya/vnet/wifi/WifiConnectConfig;", "bluetoothConfig", "Lcom/ustadmobile/meshrabiya/vnet/bluetooth/MeshrabiyaBluetoothState;", "json", "Lkotlinx/serialization/json/Json;", "parseUri", "uri", "lib-meshrabiya_release"})
    @SourceDebugExtension(value={"SMAP\nMeshrabiyaConnectLink.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MeshrabiyaConnectLink.kt\ncom/ustadmobile/meshrabiya/vnet/MeshrabiyaConnectLink$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1549#2:102\n1620#2,3:103\n*S KotlinDebug\n*F\n+ 1 MeshrabiyaConnectLink.kt\ncom/ustadmobile/meshrabiya/vnet/MeshrabiyaConnectLink$Companion\n*L\n78#1:102\n78#1:103,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MeshrabiyaConnectLink fromComponents(int nodeAddr, int port, @Nullable WifiConnectConfig hotspotConfig, @Nullable MeshrabiyaBluetoothState bluetoothConfig, @NotNull Json json) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            StringBuilder $this$fromComponents_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$fromComponents_u24lambda_u240.append(MeshrabiyaConnectLink.PROTO_PREFIX + IntExtKt.addressToDotNotation(nodeAddr) + ":" + port + "/?");
            if (hotspotConfig != null) {
                $this$fromComponents_u24lambda_u240.append("hotspot=");
                $this$fromComponents_u24lambda_u240.append(URLEncoder.encode(json.encodeToString((SerializationStrategy)WifiConnectConfig.Companion.serializer(), (Object)hotspotConfig), "UTF-8"));
            }
            if (hotspotConfig != null && bluetoothConfig != null) {
                $this$fromComponents_u24lambda_u240.append("&");
            }
            if (bluetoothConfig != null) {
                $this$fromComponents_u24lambda_u240.append("bluetooth=");
                $this$fromComponents_u24lambda_u240.append(URLEncoder.encode(json.encodeToString((SerializationStrategy)MeshrabiyaBluetoothState.Companion.serializer(), (Object)bluetoothConfig), "UTF-8"));
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            String uri = string;
            return new MeshrabiyaConnectLink(uri, nodeAddr, hotspotConfig, bluetoothConfig);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final MeshrabiyaConnectLink parseUri(@NotNull String uri, @NotNull Json json) {
            MeshrabiyaBluetoothState meshrabiyaBluetoothState;
            WifiConnectConfig wifiConnectConfig;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            String string = uri.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            String uriLowerCase = string;
            if (!StringsKt.startsWith$default((String)uriLowerCase, (String)MeshrabiyaConnectLink.PROTO_PREFIX, (boolean)false, (int)2, null)) {
                throw new IllegalArgumentException("Meshrabiya connect url must start with meshrabiya://");
            }
            String addr = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)uri, (String)MeshrabiyaConnectLink.PROTO_PREFIX, null, (int)2, null), (String)":", null, (int)2, null);
            InetAddress inetAddr = InetAddress.getByName(addr);
            String searchStr = StringsKt.substringAfter$default((String)uri, (String)"?", null, (int)2, null);
            char[] cArray = new char[]{'&'};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)searchStr, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void param;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String[] stringArray = new String[]{"="};
                List it = StringsKt.split$default((CharSequence)((CharSequence)param), (String[])stringArray, (boolean)false, (int)2, (int)2, null);
                boolean bl2 = false;
                collection.add(new Pair((Object)URLDecoder.decode((String)it.get(0), "UTF-8"), (Object)URLDecoder.decode((String)it.get(1), "UTF-8")));
            }
            Map searchComponents = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            String string3 = (String)searchComponents.get("hotspot");
            if (string3 != null) {
                String it = string3;
                boolean bl = false;
                wifiConnectConfig = (WifiConnectConfig)json.decodeFromString((DeserializationStrategy)WifiConnectConfig.Companion.serializer(), it);
            } else {
                wifiConnectConfig = null;
            }
            WifiConnectConfig hotspotConfig = wifiConnectConfig;
            String string4 = (String)searchComponents.get("bluetooth");
            if (string4 != null) {
                String it = string4;
                boolean bl = false;
                meshrabiyaBluetoothState = (MeshrabiyaBluetoothState)json.decodeFromString((DeserializationStrategy)MeshrabiyaBluetoothState.Companion.serializer(), it);
            } else {
                meshrabiyaBluetoothState = null;
            }
            MeshrabiyaBluetoothState bluetoothConfig = meshrabiyaBluetoothState;
            Intrinsics.checkNotNull((Object)inetAddr);
            return new MeshrabiyaConnectLink(uri, InetAddressExtKt.requireAddressAsInt(inetAddr), hotspotConfig, bluetoothConfig);
        }

        public static /* synthetic */ MeshrabiyaConnectLink parseUri$default(Companion companion, String string, Json json, int n, Object object) {
            if ((n & 2) != 0) {
                json = (Json)Json.Default;
            }
            return companion.parseUri(string, json);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

