/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.meshrabiya.vnet.wifi;

import android.net.MacAddress;
import android.net.wifi.SoftApConfiguration;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiManager;
import android.os.Build;
import androidx.annotation.RequiresApi;
import com.ustadmobile.meshrabiya.ext.SoftApConfigurationExtKt;
import com.ustadmobile.meshrabiya.ext.WifiConfigurationExtKt;
import com.ustadmobile.meshrabiya.log.MNetLogger;
import com.ustadmobile.meshrabiya.vnet.wifi.HotspotType;
import com.ustadmobile.meshrabiya.vnet.wifi.WifiConnectConfig;
import java.lang.reflect.Method;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u001a*\u0010\t\u001a\u00020\n*\u00060\u000bR\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a8\u0006\u0011"}, d2={"startLocalOnlyHotspotWithConfig", "", "Landroid/net/wifi/WifiManager;", "config", "Landroid/net/wifi/SoftApConfiguration;", "executor", "Ljava/util/concurrent/Executor;", "callback", "Landroid/net/wifi/WifiManager$LocalOnlyHotspotCallback;", "toLocalHotspotConfig", "Lcom/ustadmobile/meshrabiya/vnet/wifi/WifiConnectConfig;", "Landroid/net/wifi/WifiManager$LocalOnlyHotspotReservation;", "nodeVirtualAddr", "", "port", "logger", "Lcom/ustadmobile/meshrabiya/log/MNetLogger;", "lib-meshrabiya_release"})
public final class WifiManagerLocalOnlyHotspotExtKt {
    @RequiresApi(value=33)
    public static final void startLocalOnlyHotspotWithConfig(@NotNull WifiManager $this$startLocalOnlyHotspotWithConfig, @NotNull SoftApConfiguration config, @Nullable Executor executor, @NotNull WifiManager.LocalOnlyHotspotCallback callback) {
        Intrinsics.checkNotNullParameter((Object)$this$startLocalOnlyHotspotWithConfig, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Object[] objectArray = new Class[]{SoftApConfiguration.class, Executor.class, WifiManager.LocalOnlyHotspotCallback.class};
        Method method = WifiManager.class.getMethod("startLocalOnlyHotspot", (Class<?>[])objectArray);
        objectArray = new Object[]{config, executor, callback};
        method.invoke((Object)$this$startLocalOnlyHotspotWithConfig, objectArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final WifiConnectConfig toLocalHotspotConfig(@NotNull WifiManager.LocalOnlyHotspotReservation $this$toLocalHotspotConfig, int nodeVirtualAddr, int port, @Nullable MNetLogger logger) {
        WifiConfiguration wifiConfig;
        WifiConnectConfig wifiConnectConfig;
        Intrinsics.checkNotNullParameter((Object)$this$toLocalHotspotConfig, (String)"<this>");
        if (Build.VERSION.SDK_INT >= 30) {
            SoftApConfiguration softApConfiguration = $this$toLocalHotspotConfig.getSoftApConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)softApConfiguration, (String)"getSoftApConfiguration(...)");
            SoftApConfiguration softApConfig = softApConfiguration;
            String ssid = SoftApConfigurationExtKt.getSsidCompat(softApConfig);
            String passphrase = softApConfig.getPassphrase();
            MacAddress bssid = softApConfig.getBssid();
            MNetLogger mNetLogger = logger;
            if (mNetLogger != null) {
                MNetLogger.invoke$default(mNetLogger, 3, "toLocalOnlyHotspotConfig: got SoftApConfig: " + SoftApConfigurationExtKt.prettyPrint(softApConfig), null, 4, null);
            }
            if (ssid != null && passphrase != null) {
                HotspotType hotspotType = HotspotType.LOCALONLY_HOTSPOT;
                MacAddress macAddress = bssid;
                String string = macAddress != null ? macAddress.toString() : null;
                wifiConnectConfig = new WifiConnectConfig(nodeVirtualAddr, ssid, passphrase, null, port, hotspotType, null, null, string, 192, null);
                return wifiConnectConfig;
            }
            MNetLogger mNetLogger2 = logger;
            if (mNetLogger2 == null) throw new IllegalStateException("toLocalHotspotConfig: ssid and passphrase not provided by SoftApConfig: " + SoftApConfigurationExtKt.prettyPrint(softApConfig) + "!");
            MNetLogger.invoke$default(mNetLogger2, 6, "toLocalHotspotConfig: ssid and passphrase not provided by SoftApConfig: " + SoftApConfigurationExtKt.prettyPrint(softApConfig), null, 4, null);
            throw new IllegalStateException("toLocalHotspotConfig: ssid and passphrase not provided by SoftApConfig: " + SoftApConfigurationExtKt.prettyPrint(softApConfig) + "!");
        }
        WifiConfiguration wifiConfiguration = wifiConfig = $this$toLocalHotspotConfig.getWifiConfiguration();
        String ssid = wifiConfiguration != null ? wifiConfiguration.SSID : null;
        Object object = wifiConfig;
        String passphrase = object != null && (object = object.preSharedKey) != null ? StringsKt.removeSurrounding((String)object, (CharSequence)"\"") : null;
        WifiConfiguration wifiConfiguration2 = wifiConfig;
        String bssid = wifiConfiguration2 != null ? wifiConfiguration2.BSSID : null;
        MNetLogger mNetLogger = logger;
        if (mNetLogger != null) {
            WifiConfiguration wifiConfiguration3 = wifiConfig;
            MNetLogger.invoke$default(mNetLogger, 3, "toLocalOnlyHotspotConfig: Got wifiConfiguration: " + (wifiConfiguration3 != null ? WifiConfigurationExtKt.prettyPrint(wifiConfiguration3) : null), null, 4, null);
        }
        if (ssid != null && passphrase != null) {
            HotspotType hotspotType = HotspotType.LOCALONLY_HOTSPOT;
            wifiConnectConfig = new WifiConnectConfig(nodeVirtualAddr, ssid, passphrase, null, port, hotspotType, null, null, bssid, 192, null);
            return wifiConnectConfig;
        }
        MNetLogger mNetLogger3 = logger;
        if (mNetLogger3 == null) throw new IllegalStateException("toLocalHotspotConfig: ssid and passphrase not provided by SoftApConfig: " + wifiConfig + "!");
        MNetLogger.invoke$default(mNetLogger3, 6, "toLocalHotspotConfig: ssid and passphrase not provided by WifiConfig: " + wifiConfig, null, 4, null);
        throw new IllegalStateException("toLocalHotspotConfig: ssid and passphrase not provided by SoftApConfig: " + wifiConfig + "!");
    }

    public static /* synthetic */ WifiConnectConfig toLocalHotspotConfig$default(WifiManager.LocalOnlyHotspotReservation localOnlyHotspotReservation, int n, int n2, MNetLogger mNetLogger, int n3, Object object) {
        if ((n3 & 4) != 0) {
            mNetLogger = null;
        }
        return WifiManagerLocalOnlyHotspotExtKt.toLocalHotspotConfig(localOnlyHotspotReservation, n, n2, mNetLogger);
    }
}

