/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.meshrabiya.portforward;

import com.ustadmobile.meshrabiya.log.MNetLogger;
import com.ustadmobile.meshrabiya.portforward.ReturnPathSocketFactory;
import java.io.Closeable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0001 B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020\u001cH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u0019\u0012\b\u0012\u00060\u001aR\u00020\u00000\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/ustadmobile/meshrabiya/portforward/UdpForwardRule;", "Ljava/lang/Runnable;", "Ljava/io/Closeable;", "boundSocket", "Ljava/net/DatagramSocket;", "ioExecutor", "Ljava/util/concurrent/ExecutorService;", "destAddress", "Ljava/net/InetAddress;", "destPort", "", "returnPathSocketFactory", "Lcom/ustadmobile/meshrabiya/portforward/ReturnPathSocketFactory;", "logger", "Lcom/ustadmobile/meshrabiya/log/MNetLogger;", "(Ljava/net/DatagramSocket;Ljava/util/concurrent/ExecutorService;Ljava/net/InetAddress;ILcom/ustadmobile/meshrabiya/portforward/ReturnPathSocketFactory;Lcom/ustadmobile/meshrabiya/log/MNetLogger;)V", "future", "Ljava/util/concurrent/Future;", "localPort", "getLocalPort", "()I", "logPrefix", "", "returnSockets", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/net/SocketAddress;", "Lcom/ustadmobile/meshrabiya/portforward/UdpForwardRule$ReturnPathDatagramSocket;", "close", "", "closeLocalSocket", "", "run", "ReturnPathDatagramSocket", "lib-meshrabiya_release"})
@SourceDebugExtension(value={"SMAP\nUdpForwardRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UdpForwardRule.kt\ncom/ustadmobile/meshrabiya/portforward/UdpForwardRule\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n72#2,2:128\n1#3:130\n1855#4,2:131\n*S KotlinDebug\n*F\n+ 1 UdpForwardRule.kt\ncom/ustadmobile/meshrabiya/portforward/UdpForwardRule\n*L\n90#1:128,2\n90#1:130\n114#1:131,2\n*E\n"})
public final class UdpForwardRule
implements Runnable,
Closeable {
    @NotNull
    private final DatagramSocket boundSocket;
    @NotNull
    private final ExecutorService ioExecutor;
    @NotNull
    private final InetAddress destAddress;
    private final int destPort;
    @NotNull
    private final ReturnPathSocketFactory returnPathSocketFactory;
    @NotNull
    private final MNetLogger logger;
    private final int localPort;
    @NotNull
    private final String logPrefix;
    @NotNull
    private final Future<?> future;
    @NotNull
    private final ConcurrentHashMap<SocketAddress, ReturnPathDatagramSocket> returnSockets;

    public UdpForwardRule(@NotNull DatagramSocket boundSocket, @NotNull ExecutorService ioExecutor, @NotNull InetAddress destAddress, int destPort, @NotNull ReturnPathSocketFactory returnPathSocketFactory, @NotNull MNetLogger logger) {
        Intrinsics.checkNotNullParameter((Object)boundSocket, (String)"boundSocket");
        Intrinsics.checkNotNullParameter((Object)ioExecutor, (String)"ioExecutor");
        Intrinsics.checkNotNullParameter((Object)destAddress, (String)"destAddress");
        Intrinsics.checkNotNullParameter((Object)returnPathSocketFactory, (String)"returnPathSocketFactory");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.boundSocket = boundSocket;
        this.ioExecutor = ioExecutor;
        this.destAddress = destAddress;
        this.destPort = destPort;
        this.returnPathSocketFactory = returnPathSocketFactory;
        this.logger = logger;
        this.localPort = this.boundSocket.getLocalPort();
        this.logPrefix = "[UdpForwardRule : " + this.boundSocket.getLocalPort() + " -> " + this.destAddress.getHostAddress() + ":" + this.destPort + "]";
        Future<?> future = this.ioExecutor.submit(this);
        Intrinsics.checkNotNullExpressionValue(future, (String)"submit(...)");
        this.future = future;
        this.returnSockets = new ConcurrentHashMap();
    }

    public /* synthetic */ UdpForwardRule(DatagramSocket datagramSocket, ExecutorService executorService, InetAddress inetAddress, int n, ReturnPathSocketFactory returnPathSocketFactory, MNetLogger mNetLogger, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            returnPathSocketFactory = UdpForwardRule::_init_$lambda$0;
        }
        this(datagramSocket, executorService, inetAddress, n, returnPathSocketFactory, mNetLogger);
    }

    public final int getLocalPort() {
        return this.localPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void run() {
        try {
            byte[] buffer = new byte[1500];
            this.logger.invoke(3, this.logPrefix + " listening", null);
            while (!Thread.interrupted()) {
                void $this$getOrPut$iv;
                DatagramPacket packet = new DatagramPacket(buffer, 0, buffer.length);
                this.boundSocket.receive(packet);
                ConcurrentMap concurrentMap = this.returnSockets;
                SocketAddress key$iv = packet.getSocketAddress();
                boolean $i$f$getOrPut = false;
                Object object = $this$getOrPut$iv.get(key$iv);
                if (object == null) {
                    boolean bl = false;
                    DatagramSocket datagramSocket = this.returnPathSocketFactory.createSocket(this.destAddress, 0);
                    InetAddress inetAddress = packet.getAddress();
                    Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getAddress(...)");
                    ReturnPathDatagramSocket default$iv = new ReturnPathDatagramSocket(datagramSocket, inetAddress, packet.getPort());
                    boolean bl2 = false;
                    object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                    if (object == null) {
                        object = default$iv;
                    }
                }
                ReturnPathDatagramSocket returnSocket = (ReturnPathDatagramSocket)object;
                packet.setAddress(this.destAddress);
                packet.setPort(this.destPort);
                returnSocket.getReturnPathSocket().send(packet);
            }
        }
        catch (Exception e) {
            this.logger.invoke(6, this.logPrefix + " : exception running", e);
        }
    }

    public final void close(boolean closeLocalSocket) {
        Collection<ReturnPathDatagramSocket> collection = this.returnSockets.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ReturnPathDatagramSocket it = (ReturnPathDatagramSocket)element$iv;
            boolean bl = false;
            it.close();
        }
        this.future.cancel(true);
        if (closeLocalSocket) {
            this.boundSocket.close();
        }
    }

    @Override
    public void close() {
        this.close(true);
    }

    private static final DatagramSocket _init_$lambda$0(InetAddress addr, int port) {
        Intrinsics.checkNotNullParameter((Object)addr, (String)"addr");
        return new DatagramSocket(port);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u000eH\u0016R\u0012\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/ustadmobile/meshrabiya/portforward/UdpForwardRule$ReturnPathDatagramSocket;", "Ljava/lang/Runnable;", "returnPathSocket", "Ljava/net/DatagramSocket;", "returnToAddress", "Ljava/net/InetAddress;", "returnToPort", "", "(Lcom/ustadmobile/meshrabiya/portforward/UdpForwardRule;Ljava/net/DatagramSocket;Ljava/net/InetAddress;I)V", "returnFuture", "Ljava/util/concurrent/Future;", "getReturnPathSocket", "()Ljava/net/DatagramSocket;", "close", "", "run", "lib-meshrabiya_release"})
    private final class ReturnPathDatagramSocket
    implements Runnable {
        @NotNull
        private final DatagramSocket returnPathSocket;
        @NotNull
        private final InetAddress returnToAddress;
        private final int returnToPort;
        @NotNull
        private final Future<?> returnFuture;

        public ReturnPathDatagramSocket(@NotNull DatagramSocket returnPathSocket, InetAddress returnToAddress, int returnToPort) {
            Intrinsics.checkNotNullParameter((Object)returnPathSocket, (String)"returnPathSocket");
            Intrinsics.checkNotNullParameter((Object)returnToAddress, (String)"returnToAddress");
            this.returnPathSocket = returnPathSocket;
            this.returnToAddress = returnToAddress;
            this.returnToPort = returnToPort;
            Future<?> future = UdpForwardRule.this.ioExecutor.submit(this);
            Intrinsics.checkNotNullExpressionValue(future, (String)"submit(...)");
            this.returnFuture = future;
        }

        @NotNull
        public final DatagramSocket getReturnPathSocket() {
            return this.returnPathSocket;
        }

        @Override
        public void run() {
            byte[] buffer = new byte[1520];
            while (!Thread.interrupted()) {
                DatagramPacket packet = new DatagramPacket(buffer, 0, buffer.length);
                this.returnPathSocket.receive(packet);
                packet.setAddress(this.returnToAddress);
                packet.setPort(this.returnToPort);
                UdpForwardRule.this.boundSocket.send(packet);
            }
        }

        public final void close() {
            this.returnPathSocket.close();
            this.returnFuture.cancel(true);
        }
    }
}

