/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.meshrabiya.vnet.wifi;

import android.net.MacAddress;
import androidx.annotation.RequiresApi;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bJ\b\u0010\u0010\u001a\u00020\u0004H\u0007J\u0018\u0010\u0010\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u0016\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/ustadmobile/meshrabiya/vnet/wifi/MacAddressUtils;", "", "()V", "DEFAULT_MAC_ADDRESS", "Landroid/net/MacAddress;", "ETHER_ADDR_LEN", "", "LOCALLY_ASSIGNED_MASK", "", "MULTICAST_MASK", "NIC_MASK", "OUI_MASK", "VALID_LONG_MASK", "byteAddrFromLongAddr", "", "addr", "createRandomUnicastAddress", "base", "r", "Ljava/util/Random;", "isMacAddress", "", "longAddrFromByteAddr", "lib-meshrabiya_release"})
@RequiresApi(value=28)
public final class MacAddressUtils {
    @NotNull
    public static final MacAddressUtils INSTANCE = new MacAddressUtils();
    private static final long VALID_LONG_MASK = 0xFFFFFFFFFFFFL;
    private static final long LOCALLY_ASSIGNED_MASK;
    private static final long MULTICAST_MASK;
    private static final long OUI_MASK;
    private static final long NIC_MASK;
    @NotNull
    private static final MacAddress DEFAULT_MAC_ADDRESS;
    private static final int ETHER_ADDR_LEN = 6;

    private MacAddressUtils() {
    }

    @RequiresApi(value=28)
    @NotNull
    public final MacAddress createRandomUnicastAddress() {
        return this.createRandomUnicastAddress(null, new SecureRandom());
    }

    @NotNull
    public final MacAddress createRandomUnicastAddress(@Nullable MacAddress base, @NotNull Random r) {
        long l;
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        long addr = 0L;
        if (base == null) {
            l = r.nextLong() & 0xFFFFFFFFFFFFL;
        } else {
            byte[] byArray = base.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            l = this.longAddrFromByteAddr(byArray) & OUI_MASK | NIC_MASK & r.nextLong();
        }
        addr = l;
        addr |= LOCALLY_ASSIGNED_MASK;
        MacAddress macAddress = MacAddress.fromBytes((byte[])this.byteAddrFromLongAddr(addr &= MULTICAST_MASK ^ 0xFFFFFFFFFFFFFFFFL));
        Intrinsics.checkNotNullExpressionValue((Object)macAddress, (String)"fromBytes(...)");
        MacAddress mac = macAddress;
        return Intrinsics.areEqual((Object)mac, (Object)DEFAULT_MAC_ADDRESS) ? this.createRandomUnicastAddress(base, r) : mac;
    }

    @NotNull
    public final byte[] byteAddrFromLongAddr(long addr) {
        long addr2 = addr;
        byte[] bytes = new byte[6];
        int index = 6;
        while (index-- > 0) {
            bytes[index] = (byte)addr2;
            addr2 >>= 8;
        }
        return bytes;
    }

    public final long longAddrFromByteAddr(@NotNull byte[] addr) {
        Intrinsics.checkNotNullParameter((Object)addr, (String)"addr");
        if (!this.isMacAddress(addr)) {
            throw new IllegalArgumentException(Arrays.toString(addr) + " was not a valid MAC address");
        }
        long longAddr = 0L;
        for (byte b : addr) {
            int uint8Byte = b & 0xFF;
            longAddr = (longAddr << 8) + (long)uint8Byte;
        }
        return longAddr;
    }

    public final boolean isMacAddress(@Nullable byte[] addr) {
        return addr != null && addr.length == 6;
    }

    static {
        byte[] byArray = MacAddress.fromString((String)"2:0:0:0:0:0").toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        LOCALLY_ASSIGNED_MASK = INSTANCE.longAddrFromByteAddr(byArray);
        byte[] byArray2 = MacAddress.fromString((String)"1:0:0:0:0:0").toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"toByteArray(...)");
        MULTICAST_MASK = INSTANCE.longAddrFromByteAddr(byArray2);
        byte[] byArray3 = MacAddress.fromString((String)"ff:ff:ff:0:0:0").toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"toByteArray(...)");
        OUI_MASK = INSTANCE.longAddrFromByteAddr(byArray3);
        byte[] byArray4 = MacAddress.fromString((String)"0:0:0:ff:ff:ff").toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"toByteArray(...)");
        NIC_MASK = INSTANCE.longAddrFromByteAddr(byArray4);
        MacAddress macAddress = MacAddress.fromString((String)"02:00:00:00:00:00");
        Intrinsics.checkNotNullExpressionValue((Object)macAddress, (String)"fromString(...)");
        DEFAULT_MAC_ADDRESS = macAddress;
    }
}

