/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.meshrabiya.client;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import com.ustadmobile.meshrabiya.RemoteEndpoint;
import com.ustadmobile.meshrabiya.UuidUtil;
import com.ustadmobile.meshrabiya.client.UuidAllocationClient;
import com.ustadmobile.meshrabiya.ext.IntExtKt;
import com.ustadmobile.meshrabiya.log.MNetLogger;
import com.ustadmobile.meshrabiya.util.UuidMaskUtilKt;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J!\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001aH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006 "}, d2={"Lcom/ustadmobile/meshrabiya/client/UuidAllocationClient;", "Ljava/io/Closeable;", "appContext", "Landroid/content/Context;", "onLog", "Lcom/ustadmobile/meshrabiya/log/MNetLogger;", "clientNodeAddr", "", "(Landroid/content/Context;Lcom/ustadmobile/meshrabiya/log/MNetLogger;I)V", "bluetoothAdapter", "Landroid/bluetooth/BluetoothAdapter;", "bluetoothManager", "Landroid/bluetooth/BluetoothManager;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "lockByRemote", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/ustadmobile/meshrabiya/RemoteEndpoint;", "Lkotlinx/coroutines/sync/Mutex;", "logPrefix", "", "mapLock", "Ljava/util/concurrent/locks/ReentrantLock;", "close", "", "requestUuidAllocation", "Ljava/util/UUID;", "remoteAddress", "uuidMask", "(Ljava/lang/String;Ljava/util/UUID;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "GetDataUuidGattCallback", "lib-meshrabiya_debug"})
@SourceDebugExtension(value={"SMAP\nUuidAllocationClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UuidAllocationClient.kt\ncom/ustadmobile/meshrabiya/client/UuidAllocationClient\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n*L\n1#1,420:1\n72#2,2:421\n1#3:423\n107#4,10:424\n*S KotlinDebug\n*F\n+ 1 UuidAllocationClient.kt\ncom/ustadmobile/meshrabiya/client/UuidAllocationClient\n*L\n374#1:421,2\n374#1:423\n381#1:424,10\n*E\n"})
public final class UuidAllocationClient
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context appContext;
    @NotNull
    private final MNetLogger onLog;
    @NotNull
    private final String logPrefix;
    @NotNull
    private final ConcurrentHashMap<RemoteEndpoint, Mutex> lockByRemote;
    @NotNull
    private final ReentrantLock mapLock;
    @NotNull
    private final BluetoothManager bluetoothManager;
    @Nullable
    private final BluetoothAdapter bluetoothAdapter;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private static final AtomicInteger CALLBACK_ID_ATOMIC = new AtomicInteger(1);
    public static final long DEFAULT_TIMEOUT = 12000L;

    public UuidAllocationClient(@NotNull Context appContext, @NotNull MNetLogger onLog, int clientNodeAddr) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Intrinsics.checkNotNullParameter((Object)onLog, (String)"onLog");
        this.appContext = appContext;
        this.onLog = onLog;
        this.logPrefix = "[UuidAllocationClient for " + IntExtKt.addressToDotNotation(clientNodeAddr) + "] ";
        this.lockByRemote = new ConcurrentHashMap();
        this.mapLock = new ReentrantLock();
        Object object = this.appContext.getSystemService(BluetoothManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSystemService(...)");
        this.bluetoothManager = (BluetoothManager)object;
        this.bluetoothAdapter = this.bluetoothManager.getAdapter();
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getMain().plus((CoroutineContext)JobKt.Job$default(null, (int)1, null)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Object requestUuidAllocation(@NotNull String var1_1, @NotNull UUID var2_2, @NotNull Continuation<? super UUID> var3_3) {
        if (!(var3_3 instanceof requestUuidAllocation.1)) ** GOTO lbl-1000
        var22_4 = var3_3;
        if ((var22_4.label & -2147483648) != 0) {
            var22_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ UuidAllocationClient this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.requestUuidAllocation(null, null, (Continuation<? super UUID>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var23_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.bluetoothAdapter;
                if (v0 == null) {
                    throw new IllegalStateException("Bluetooth not supported");
                }
                bluetoothAdapterVal = v0;
                if (!bluetoothAdapterVal.isEnabled()) {
                    throw new IOException("requestUuidAllocation: bluetooth is not enabled");
                }
                remoteDevice = bluetoothAdapterVal.getRemoteDevice((String)remoteAddress);
                var7_9 = this.mapLock;
                var7_9.lock();
                try {
                    $i$a$-withLock-UuidAllocationClient$requestUuidAllocation$getDataPortMutex$1 = false;
                    $this$getOrPut$iv = this.lockByRemote;
                    key$iv = new RemoteEndpoint((String)remoteAddress, uuidMask);
                    $i$f$getOrPut = false;
                    v1 /* !! */  = $this$getOrPut$iv.get(key$iv);
                    if (v1 /* !! */  == null) {
                        $i$a$-getOrPut-UuidAllocationClient$requestUuidAllocation$getDataPortMutex$1$1 = false;
                        default$iv = MutexKt.Mutex$default((boolean)false, (int)1, null);
                        $i$a$-let-MapsKt__MapsJVMKt$getOrPut$1$iv = false;
                        v1 /* !! */  = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                        if (v1 /* !! */  == null) {
                            v1 /* !! */  = default$iv;
                        }
                    }
                    var8_11 = (Mutex)v1 /* !! */ ;
                }
                finally {
                    var7_9.unlock();
                }
                getDataPortMutex = var8_11;
                Intrinsics.checkNotNull((Object)getDataPortMutex);
                $this$withLock_u24default$iv = getDataPortMutex;
                owner$iv = null;
                $i$f$withLock = false;
                $continuation.L$0 = this;
                $continuation.L$1 = uuidMask;
                $continuation.L$2 = remoteDevice;
                $continuation.L$3 = $this$withLock_u24default$iv;
                $continuation.label = 1;
                v2 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v2 == var23_6) {
                    return var23_6;
                }
                ** GOTO lbl68
            }
            case 1: {
                $i$f$withLock = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$3;
                remoteDevice = (BluetoothDevice)$continuation.L$2;
                uuidMask = (UUID)$continuation.L$1;
                this = (UuidAllocationClient)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl68:
                // 3 sources

                $i$a$-withLock$default-UuidAllocationClient$requestUuidAllocation$dataUuid$1 = false;
                startTime = System.currentTimeMillis();
                getDataUuidGattCallback = new GetDataUuidGattCallback(var2_2, this.coroutineScope, 0L, this.onLog, this.logPrefix, 4, null);
                gatt = remoteDevice.connectGatt(this.appContext, false, (BluetoothGattCallback)getDataUuidGattCallback);
                Intrinsics.checkNotNull((Object)gatt);
                $continuation.L$0 = this;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.J$0 = startTime;
                $continuation.label = 2;
                v3 = getDataUuidGattCallback.getDataPortUuid(gatt, (Continuation<? super UUID>)$continuation);
                ** if (v3 != var23_6) goto lbl85
lbl84:
                // 1 sources

                return var23_6;
lbl85:
                // 1 sources

                ** GOTO lbl98
            }
            case 2: {
                $i$f$withLock = false;
                $i$a$-withLock$default-UuidAllocationClient$requestUuidAllocation$dataUuid$1 = false;
                startTime = $continuation.J$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                this = (UuidAllocationClient)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl98:
                    // 2 sources

                    uuid = (UUID)v3;
                    this.onLog.invoke(3, "Got allocated uuid " + uuid + " in " + (System.currentTimeMillis() - startTime) + "ms", null);
                    var18_27 = uuid;
                    {
                        catch (SecurityException e) {
                            e.printStackTrace();
                            var18_27 = null;
                        }
                    }
                    var20_29 = var18_27;
                    v4 = var20_29;
                }
                catch (Throwable var20_30) {
                    throw var20_30;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                if (v4 == null) {
                    throw new IOException("Unable to get data port");
                }
                dataUuid = v4;
                return dataUuid;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public void close() {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/ustadmobile/meshrabiya/client/UuidAllocationClient$Companion;", "", "()V", "CALLBACK_ID_ATOMIC", "Ljava/util/concurrent/atomic/AtomicInteger;", "getCALLBACK_ID_ATOMIC", "()Ljava/util/concurrent/atomic/AtomicInteger;", "DEFAULT_TIMEOUT", "", "lib-meshrabiya_debug"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AtomicInteger getCALLBACK_ID_ATOMIC() {
            return CALLBACK_ID_ATOMIC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ&\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020\u000b2\u000e\u0010)\u001a\n\u0018\u00010*j\u0004\u0018\u0001`+J\"\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020\u000e2\u0010\b\u0002\u0010)\u001a\n\u0018\u00010*j\u0004\u0018\u0001`+H\u0002J\u0019\u0010\u0019\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u000eH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010.J(\u0010/\u001a\u00020&2\u0006\u0010-\u001a\u00020\u000e2\u0006\u00100\u001a\u00020\u001d2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u0011H\u0016J$\u0010/\u001a\u00020&2\b\u0010-\u001a\u0004\u0018\u00010\u000e2\b\u00100\u001a\u0004\u0018\u00010\u001d2\u0006\u00103\u001a\u00020\u0011H\u0017J.\u00104\u001a\u00020&2\b\u0010-\u001a\u0004\u0018\u00010\u000e2\b\u00100\u001a\u0004\u0018\u00010\u001d2\b\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u00020\u0011H\u0002J\"\u00105\u001a\u00020&2\b\u0010-\u001a\u0004\u0018\u00010\u000e2\u0006\u00103\u001a\u00020\u00112\u0006\u00106\u001a\u00020\u0011H\u0016J\u001a\u00107\u001a\u00020&2\b\u0010-\u001a\u0004\u0018\u00010\u000e2\u0006\u00103\u001a\u00020\u0011H\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00068"}, d2={"Lcom/ustadmobile/meshrabiya/client/UuidAllocationClient$GetDataUuidGattCallback;", "Landroid/bluetooth/BluetoothGattCallback;", "uuidMask", "Ljava/util/UUID;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "timeout", "", "logger", "Lcom/ustadmobile/meshrabiya/log/MNetLogger;", "logPrefix", "", "(Ljava/util/UUID;Lkotlinx/coroutines/CoroutineScope;JLcom/ustadmobile/meshrabiya/log/MNetLogger;Ljava/lang/String;)V", "callbackGatt", "Landroid/bluetooth/BluetoothGatt;", "characteristicUuid", "clientId", "", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "connectionEstablished", "", "connectionState", "dataPortUuid", "Lkotlinx/coroutines/CompletableDeferred;", "getDataPortUuid", "()Lkotlinx/coroutines/CompletableDeferred;", "disconnectCalled", "discoveredCharacteristic", "Landroid/bluetooth/BluetoothGattCharacteristic;", "readAttempts", "serviceDiscoveryAttempts", "startTime", "timeoutJob", "Lkotlinx/coroutines/Job;", "getTimeoutJob", "()Lkotlinx/coroutines/Job;", "callbackLog", "", "priority", "message", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "disconnectAndCloseIfRequired", "gatt", "(Landroid/bluetooth/BluetoothGatt;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onCharacteristicRead", "characteristic", "value", "", "status", "onCharacteristicReadCompat", "onConnectionStateChange", "newState", "onServicesDiscovered", "lib-meshrabiya_debug"})
    @SourceDebugExtension(value={"SMAP\nUuidAllocationClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UuidAllocationClient.kt\ncom/ustadmobile/meshrabiya/client/UuidAllocationClient$GetDataUuidGattCallback\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,420:1\n1855#2,2:421\n288#2,2:423\n1#3:425\n*S KotlinDebug\n*F\n+ 1 UuidAllocationClient.kt\ncom/ustadmobile/meshrabiya/client/UuidAllocationClient$GetDataUuidGattCallback\n*L\n173#1:421,2\n183#1:423,2\n*E\n"})
    private static final class GetDataUuidGattCallback
    extends BluetoothGattCallback {
        @NotNull
        private final UUID uuidMask;
        @NotNull
        private final CoroutineScope scope;
        private final long timeout;
        @NotNull
        private final MNetLogger logger;
        @NotNull
        private final String logPrefix;
        @NotNull
        private final CompletableDeferred<UUID> dataPortUuid;
        private volatile BluetoothGatt callbackGatt;
        @NotNull
        private final AtomicBoolean disconnectCalled;
        @NotNull
        private final AtomicBoolean closed;
        private int connectionState;
        private boolean connectionEstablished;
        private final long startTime;
        private final int clientId;
        private int serviceDiscoveryAttempts;
        private int readAttempts;
        @Nullable
        private BluetoothGattCharacteristic discoveredCharacteristic;
        @Nullable
        private UUID characteristicUuid;
        @NotNull
        private final Job timeoutJob;

        public GetDataUuidGattCallback(@NotNull UUID uuidMask, @NotNull CoroutineScope scope, long timeout, @NotNull MNetLogger logger, @NotNull String logPrefix) {
            Intrinsics.checkNotNullParameter((Object)uuidMask, (String)"uuidMask");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Intrinsics.checkNotNullParameter((Object)logPrefix, (String)"logPrefix");
            this.uuidMask = uuidMask;
            this.scope = scope;
            this.timeout = timeout;
            this.logger = logger;
            this.logPrefix = logPrefix;
            this.dataPortUuid = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
            this.disconnectCalled = new AtomicBoolean(false);
            this.closed = new AtomicBoolean(false);
            this.startTime = System.currentTimeMillis();
            this.clientId = Companion.getCALLBACK_ID_ATOMIC().getAndIncrement();
            this.timeoutJob = BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ GetDataUuidGattCallback this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = DelayKt.delay((long)GetDataUuidGattCallback.access$getTimeout$p(this.this$0), (Continuation)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            this.this$0.callbackLog(3, "Timeout after " + GetDataUuidGattCallback.access$getTimeout$p(this.this$0) + "ms: calling disconnectAndCloseIfRequired", null);
                            v1 = GetDataUuidGattCallback.access$getCallbackGatt$p(this.this$0);
                            if (v1 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"callbackGatt");
                                v1 = null;
                            }
                            GetDataUuidGattCallback.access$disconnectAndCloseIfRequired(this.this$0, v1, new TimeoutException("GetDataUuidGattCallback for " + GetDataUuidGattCallback.access$getUuidMask$p(this.this$0) + " timed out after " + GetDataUuidGattCallback.access$getTimeout$p(this.this$0) + "ms"));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        public /* synthetic */ GetDataUuidGattCallback(UUID uUID, CoroutineScope coroutineScope, long l, MNetLogger mNetLogger, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                l = 12000L;
            }
            this(uUID, coroutineScope, l, mNetLogger, string);
        }

        @NotNull
        public final CompletableDeferred<UUID> getDataPortUuid() {
            return this.dataPortUuid;
        }

        public final void callbackLog(int priority, @NotNull String message, @Nullable Exception exception) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.logger.invoke(priority, this.logPrefix + " - Callback #" + this.clientId + " - " + message, exception);
        }

        @NotNull
        public final Job getTimeoutJob() {
            return this.timeoutJob;
        }

        public void onConnectionStateChange(@Nullable BluetoothGatt gatt, int status, int newState) {
            this.callbackLog(4, "onConnectionStateChange state=" + newState + " status=" + status, null);
            if (gatt == null) {
                this.callbackLog(5, "onConnectionStateChange: gatt is null, can't do anything", null);
                return;
            }
            this.connectionState = newState;
            if (status == 0 && newState == 2) {
                this.connectionEstablished = true;
                if (this.timeoutJob.isCancelled()) {
                    this.callbackLog(3, "onConnectionStateChange: already cancelled", null);
                    return;
                }
                try {
                    if (!gatt.discoverServices()) {
                        this.callbackLog(5, "onConnectionStateChange: connected, but failed to submit discover services request", null);
                        this.disconnectAndCloseIfRequired(gatt, new IllegalStateException("Failed to submit discover services request"));
                    }
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
            }
            if (newState == 0 && this.disconnectCalled.get() && !this.closed.getAndSet(true)) {
                try {
                    gatt.close();
                    this.callbackLog(3, "Closed client Gatt callback.", null);
                }
                catch (SecurityException e) {
                    this.callbackLog(6, "Security exception closing Gatt", e);
                }
            }
        }

        public void onServicesDiscovered(@Nullable BluetoothGatt gatt, int status) {
            block13: {
                BluetoothGattCharacteristic characteristic;
                Object object;
                Object v5;
                CoroutineScope coroutineScope;
                block12: {
                    Object object2 = gatt;
                    this.callbackLog(3, "onServicesDiscovered: status = " + status + " services discovered: " + (object2 != null && (object2 = object2.getServices()) != null ? Integer.valueOf(object2.size()) : null), null);
                    if (gatt == null) {
                        this.callbackLog(5, "onServicesDiscovered: gatt is null, can't do anything", null);
                        return;
                    }
                    List services = gatt.getServices();
                    List list = gatt.getServices();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getServices(...)");
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        BluetoothGattService service = (BluetoothGattService)element$iv;
                        boolean bl = false;
                        UUID uUID = service.getUuid();
                        List list2 = service.getCharacteristics();
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getCharacteristics(...)");
                        this.callbackLog(3, "Service " + uUID + " characteristics: " + CollectionsKt.joinToString$default((Iterable)list2, null, null, null, (int)0, null, (Function1)onServicesDiscovered.1.1.INSTANCE, (int)31, null), null);
                    }
                    if (this.timeoutJob.isCancelled()) {
                        this.callbackLog(3, "onServicesDiscovered: already cancelled", null);
                        return;
                    }
                    Intrinsics.checkNotNull((Object)services);
                    Iterable $this$firstOrNull$iv = services;
                    boolean $i$f$firstOrNull = false;
                    coroutineScope = $this$firstOrNull$iv.iterator();
                    while (coroutineScope.hasNext()) {
                        Object element$iv = coroutineScope.next();
                        BluetoothGattService it = (BluetoothGattService)element$iv;
                        boolean bl = false;
                        UUID uUID = it.getUuid();
                        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
                        if (!UuidMaskUtilKt.matchesMask(uUID, this.uuidMask)) continue;
                        v5 = element$iv;
                        break block12;
                    }
                    v5 = null;
                }
                BluetoothGattService service = v5;
                if (service != null && service.getCharacteristics().size() == 1) {
                    List list = service.getCharacteristics();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCharacteristics(...)");
                    this.characteristicUuid = ((BluetoothGattCharacteristic)CollectionsKt.first((List)list)).getUuid();
                }
                if (service == null) {
                    this.callbackLog(5, "onServicesDiscovered: did not discover service matching mask " + this.uuidMask, null);
                }
                BluetoothGattCharacteristic bluetoothGattCharacteristic = (object = service) != null && (object = object.getCharacteristics()) != null ? (BluetoothGattCharacteristic)CollectionsKt.firstOrNull((List)object) : (characteristic = null);
                if (characteristic != null) {
                    this.callbackLog(3, "permissions = " + characteristic.getPermissions() + ", properties=" + characteristic.getProperties(), null);
                    try {
                        boolean requestedRead = gatt.readCharacteristic(characteristic);
                        if (!requestedRead) {
                            this.callbackLog(5, "Found UUID allocation service/characteristic, but request to read submission failed", null);
                            this.disconnectAndCloseIfRequired(gatt, new IllegalStateException("Found UUID allocation service/characteristic, but request to read submission failed"));
                            break block13;
                        }
                        this.callbackLog(3, "found target characteristic - submitted request to read OK.", null);
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                } else {
                    int e = this.serviceDiscoveryAttempts;
                    this.serviceDiscoveryAttempts = e + 1;
                    CoroutineScope it = coroutineScope = this.scope;
                    boolean bl = false;
                    Object object3 = this.serviceDiscoveryAttempts < 5 ? coroutineScope : null;
                    if (object3 != null) {
                        BuildersKt.launch$default((CoroutineScope)object3, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, gatt, null){
                            int label;
                            final /* synthetic */ GetDataUuidGattCallback this$0;
                            final /* synthetic */ BluetoothGatt $gatt;
                            {
                                this.this$0 = $receiver;
                                this.$gatt = $gatt;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object var1_1) {
                                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        this.this$0.callbackLog(3, "Retry service discovery", null);
                                        this.label = 1;
                                        v0 = DelayKt.delay((long)1000L, (Continuation)((Continuation)this));
                                        if (v0 == var3_2) {
                                            return var3_2;
                                        }
                                        ** GOTO lbl14
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl14:
                                        // 2 sources

                                        try {
                                            this.$gatt.discoverServices();
                                        }
                                        catch (SecurityException e) {
                                            this.this$0.callbackLog(6, "Security exception", e);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                    }
                    String errorCause = service == null ? "Service matching UUID mask not found" : "Service matching UUID found, but did not find characteristic.";
                    this.callbackLog(5, errorCause, null);
                }
            }
        }

        private final void onCharacteristicReadCompat(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, byte[] value, int status) {
            BluetoothGattCharacteristic bluetoothGattCharacteristic = characteristic;
            this.callbackLog(3, "onCharacteristicReadCompat status=" + status + " characteristic uuid=" + (bluetoothGattCharacteristic != null ? bluetoothGattCharacteristic.getUuid() : null) + " value=" + (value != null ? Integer.valueOf(value.length) : null) + " bytes", null);
            if (gatt == null) {
                this.callbackLog(5, "onCharacteristicReadCompat: gatt is null, can't do anything", null);
                return;
            }
            if (characteristic != null && Intrinsics.areEqual((Object)characteristic.getUuid(), (Object)this.characteristicUuid)) {
                this.callbackLog(3, "onCharacteristicReadCompat: for target characteristic", null);
                if (value != null && status == 0) {
                    try {
                        UUID uuid = UuidUtil.INSTANCE.uuidFromBytes(value);
                        this.callbackLog(4, "Got allocated uuid: " + uuid, null);
                        Job.DefaultImpls.cancel$default((Job)this.timeoutJob, null, (int)1, null);
                        this.dataPortUuid.complete((Object)uuid);
                        GetDataUuidGattCallback.disconnectAndCloseIfRequired$default(this, gatt, null, 2, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.disconnectAndCloseIfRequired(gatt, e);
                    }
                } else {
                    this.callbackLog(6, "onCharacteristicRead: Characteristic status (" + status + ") != GATT_SUCCESS", null);
                    BluetoothGattCharacteristic discoveredCharacteristicVal = this.discoveredCharacteristic;
                    BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, gatt, discoveredCharacteristicVal, null){
                        int label;
                        final /* synthetic */ GetDataUuidGattCallback this$0;
                        final /* synthetic */ BluetoothGatt $gatt;
                        final /* synthetic */ BluetoothGattCharacteristic $discoveredCharacteristicVal;
                        {
                            this.this$0 = $receiver;
                            this.$gatt = $gatt;
                            this.$discoveredCharacteristicVal = $discoveredCharacteristicVal;
                            super(2, $completion);
                        }

                        /*
                         * Exception decompiling
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object var1_1) {
                            /*
                             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                             * 
                             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[WHILELOOP]
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                             *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                             *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.dump(StructuredExpressionStatement.java:29)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredIf.dump(StructuredIf.java:65)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredIf.dump(StructuredIf.java:61)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                             *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                             *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                             *     at org.benf.cfr.reader.entities.ClassFile.dumpNamedInnerClasses(ClassFile.java:1161)
                             *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:71)
                             *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                             *     at org.benf.cfr.reader.Main.main(Main.java:54)
                             */
                            throw new IllegalStateException("Decompilation failed");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }
            }
        }

        public void onCharacteristicRead(@NotNull BluetoothGatt gatt, @NotNull BluetoothGattCharacteristic characteristic, @NotNull byte[] value, int status) {
            Intrinsics.checkNotNullParameter((Object)gatt, (String)"gatt");
            Intrinsics.checkNotNullParameter((Object)characteristic, (String)"characteristic");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.onCharacteristicReadCompat(gatt, characteristic, value, status);
        }

        @Deprecated(message="\n            Might be deprecated, but pre-SDK33 this is the function that gets called, so not much\n            we can do about it until SDK32 is obsolete. Gonna be a while.\n        ")
        public void onCharacteristicRead(@Nullable BluetoothGatt gatt, @Nullable BluetoothGattCharacteristic characteristic, int status) {
            BluetoothGattCharacteristic bluetoothGattCharacteristic = characteristic;
            this.onCharacteristicReadCompat(gatt, characteristic, (byte[])(bluetoothGattCharacteristic != null ? bluetoothGattCharacteristic.getValue() : null), status);
        }

        private final void disconnectAndCloseIfRequired(BluetoothGatt gatt, Exception exception) {
            this.callbackLog(3, "disconnectAndCloseIfRequired exception=" + exception, null);
            if (!this.disconnectCalled.getAndSet(true)) {
                this.callbackLog(3, "disconnectAndCloseIfRequired - disconnect not called before - cancel timeout", null);
                Job.DefaultImpls.cancel$default((Job)this.timeoutJob, null, (int)1, null);
                try {
                    boolean alreadyDisconnected = this.connectionState == 0;
                    gatt.disconnect();
                    this.callbackLog(3, "UuidAllocationClient: submitted GATT disconnect request", null);
                    if (alreadyDisconnected) {
                        this.callbackLog(3, "UuidAllocationClient: disconnectAndClose: already disconnected, so will close now", null);
                        this.closed.set(true);
                        gatt.close();
                    }
                }
                catch (SecurityException e) {
                    this.callbackLog(6, "Security exception on disconnect/close", e);
                }
                if (exception != null && !this.dataPortUuid.isCompleted()) {
                    this.callbackLog(5, "disconnectAndCloseIfRequired: complete exceptionally", exception);
                    this.dataPortUuid.completeExceptionally((Throwable)exception);
                }
            }
        }

        static /* synthetic */ void disconnectAndCloseIfRequired$default(GetDataUuidGattCallback getDataUuidGattCallback, BluetoothGatt bluetoothGatt, Exception exception, int n, Object object) {
            if ((n & 2) != 0) {
                exception = null;
            }
            getDataUuidGattCallback.disconnectAndCloseIfRequired(bluetoothGatt, exception);
        }

        @Nullable
        public final Object getDataPortUuid(@NotNull BluetoothGatt gatt, @NotNull Continuation<? super UUID> $completion) {
            this.callbackLog(3, "getDataPortUuid", null);
            this.callbackGatt = gatt;
            try {
                this.callbackLog(3, "getDataPortUid: request connect", null);
                if (!gatt.connect()) {
                    this.callbackLog(6, "getDataPortUid: request to connect not submitted", null);
                    this.dataPortUuid.completeExceptionally((Throwable)new IOException("Failed to submit connect request"));
                }
            }
            catch (SecurityException e) {
                this.callbackLog(6, "SecurityException on GATT connect", e);
            }
            return this.dataPortUuid.await($completion);
        }

        public static final /* synthetic */ int access$getReadAttempts$p(GetDataUuidGattCallback $this) {
            return $this.readAttempts;
        }

        public static final /* synthetic */ void access$setReadAttempts$p(GetDataUuidGattCallback $this, int n) {
            $this.readAttempts = n;
        }

        public static final /* synthetic */ void access$disconnectAndCloseIfRequired(GetDataUuidGattCallback $this, BluetoothGatt gatt, Exception exception) {
            $this.disconnectAndCloseIfRequired(gatt, exception);
        }

        public static final /* synthetic */ long access$getTimeout$p(GetDataUuidGattCallback $this) {
            return $this.timeout;
        }

        public static final /* synthetic */ BluetoothGatt access$getCallbackGatt$p(GetDataUuidGattCallback $this) {
            return $this.callbackGatt;
        }

        public static final /* synthetic */ UUID access$getUuidMask$p(GetDataUuidGattCallback $this) {
            return $this.uuidMask;
        }
    }
}

