/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.meshrabiya.vnet;

import com.ustadmobile.meshrabiya.ext.InetAddressExtKt;
import com.ustadmobile.meshrabiya.ext.IntExtKt;
import com.ustadmobile.meshrabiya.log.MNetLogger;
import com.ustadmobile.meshrabiya.log.MNetLoggerStdout;
import com.ustadmobile.meshrabiya.mmcp.MmcpHotspotRequest;
import com.ustadmobile.meshrabiya.mmcp.MmcpHotspotResponse;
import com.ustadmobile.meshrabiya.mmcp.MmcpMessage;
import com.ustadmobile.meshrabiya.mmcp.MmcpMessageAndPacketHeader;
import com.ustadmobile.meshrabiya.mmcp.MmcpOriginatorMessage;
import com.ustadmobile.meshrabiya.mmcp.MmcpPing;
import com.ustadmobile.meshrabiya.mmcp.MmcpPong;
import com.ustadmobile.meshrabiya.portforward.ForwardBindPoint;
import com.ustadmobile.meshrabiya.portforward.UdpForwardRule;
import com.ustadmobile.meshrabiya.util.FindFreePortKt;
import com.ustadmobile.meshrabiya.vnet.LocalNodeState;
import com.ustadmobile.meshrabiya.vnet.MeshrabiyaConnectLink;
import com.ustadmobile.meshrabiya.vnet.NodeConfig;
import com.ustadmobile.meshrabiya.vnet.OriginatingMessageManager;
import com.ustadmobile.meshrabiya.vnet.PongListener;
import com.ustadmobile.meshrabiya.vnet.Protocol;
import com.ustadmobile.meshrabiya.vnet.VirtualNode;
import com.ustadmobile.meshrabiya.vnet.VirtualNodeDatagramSocket;
import com.ustadmobile.meshrabiya.vnet.VirtualNodeKt;
import com.ustadmobile.meshrabiya.vnet.VirtualNodeReturnPathSocketFactory;
import com.ustadmobile.meshrabiya.vnet.VirtualPacket;
import com.ustadmobile.meshrabiya.vnet.VirtualRouter;
import com.ustadmobile.meshrabiya.vnet.bluetooth.MeshrabiyaBluetoothState;
import com.ustadmobile.meshrabiya.vnet.datagram.VirtualDatagramSocket2;
import com.ustadmobile.meshrabiya.vnet.datagram.VirtualDatagramSocketImpl;
import com.ustadmobile.meshrabiya.vnet.socket.ChainSocketFactory;
import com.ustadmobile.meshrabiya.vnet.socket.ChainSocketFactoryImpl;
import com.ustadmobile.meshrabiya.vnet.socket.ChainSocketNextHop;
import com.ustadmobile.meshrabiya.vnet.socket.ChainSocketServer;
import com.ustadmobile.meshrabiya.vnet.wifi.ConnectBand;
import com.ustadmobile.meshrabiya.vnet.wifi.HotspotType;
import com.ustadmobile.meshrabiya.vnet.wifi.LocalHotspotRequest;
import com.ustadmobile.meshrabiya.vnet.wifi.LocalHotspotResponse;
import com.ustadmobile.meshrabiya.vnet.wifi.MeshrabiyaWifiManager;
import com.ustadmobile.meshrabiya.vnet.wifi.WifiConnectConfig;
import com.ustadmobile.meshrabiya.vnet.wifi.state.MeshrabiyaWifiState;
import java.io.Closeable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.SocketFactory;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.StateFlowKt;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u00012\u00020\u0002:\u0004\u0096\u0001\u0097\u0001BA\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0004\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ&\u0010`\u001a\u00020a2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010b\u001a\u00020\u00042\u0006\u0010c\u001a\u000200J\u000e\u0010d\u001a\u00020a2\u0006\u0010e\u001a\u00020TJ\u0018\u0010f\u001a\u00020\u00042\u0006\u0010g\u001a\u00020\u00192\u0006\u0010h\u001a\u00020\u0004H\u0016J\b\u0010i\u001a\u00020aH\u0016J\u000e\u0010j\u001a\u00020k2\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010l\u001a\u00020kJ \u0010m\u001a\u0002052\u0006\u0010n\u001a\u00020k2\u0006\u0010o\u001a\u00020\n2\u0006\u0010p\u001a\u00020\u0004H\u0002J\u0018\u0010q\u001a\u00020a2\u0006\u0010r\u001a\u00020s2\u0006\u0010h\u001a\u00020\u0004H\u0016J&\u0010t\u001a\u00020\u00042\u0006\u0010u\u001a\u00020v2\u0006\u0010w\u001a\u00020\u00042\u0006\u0010o\u001a\u00020\n2\u0006\u0010p\u001a\u00020\u0004J&\u0010t\u001a\u00020\u00042\u0006\u0010x\u001a\u00020\n2\u0006\u0010w\u001a\u00020\u00042\u0006\u0010o\u001a\u00020\n2\u0006\u0010p\u001a\u00020\u0004J\u001e\u0010y\u001a\u00020z2\b\u0010{\u001a\u0004\u0018\u00010|2\n\b\u0002\u0010}\u001a\u0004\u0018\u00010~H\u0004J\u0019\u0010\u007f\u001a\u00030\u0080\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\t\u0010\u0081\u0001\u001a\u00020\u0004H\u0016J*\u0010\u0082\u0001\u001a\u00030\u0083\u00012\b\u0010\u0084\u0001\u001a\u00030\u0085\u00012\n\u0010\u0086\u0001\u001a\u0005\u0018\u00010\u0087\u00012\b\u0010/\u001a\u0004\u0018\u000100H\u0002J\u000f\u0010\u0088\u0001\u001a\u00020a2\u0006\u0010e\u001a\u00020TJ*\u0010\u0089\u0001\u001a\u00020a2\b\u0010\u008a\u0001\u001a\u00030\u0085\u00012\n\u0010\u0086\u0001\u001a\u0005\u0018\u00010\u0087\u00012\t\u0010\u008b\u0001\u001a\u0004\u0018\u000100H\u0016J8\u0010\u008c\u0001\u001a\u0005\u0018\u00010\u008d\u00012\b\u0010\u008e\u0001\u001a\u00030\u0083\u00012\n\b\u0002\u0010\u008f\u0001\u001a\u00030\u0090\u00012\n\b\u0002\u0010\u0091\u0001\u001a\u00030\u0092\u0001H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0093\u0001J\u0017\u0010\u0094\u0001\u001a\u00020a2\u0006\u0010u\u001a\u00020v2\u0006\u0010w\u001a\u00020\u0004J\u0018\u0010\u0094\u0001\u001a\u00020a2\u0007\u0010\u0095\u0001\u001a\u00020\n2\u0006\u0010w\u001a\u00020\u0004R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020(X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020,X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010/\u001a\u000200\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u001a\u00103\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u0002050\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00106\u001a\u000207X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0017\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00110;\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u0014\u0010@\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010\u001eR\u000e\u0010B\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010C\u001a\u00020DX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010FR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010HR\u0012\u0010I\u001a\u00020JX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u0010LR\u000e\u0010M\u001a\u00020NX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010\u001eR\u000e\u0010P\u001a\u00020QX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010R\u001a\b\u0012\u0004\u0012\u00020T0SX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010\u001eR\u0014\u0010V\u001a\u00020WX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bX\u0010YR\u0011\u0010Z\u001a\u00020[8F\u00a2\u0006\u0006\u001a\u0004\b\\\u0010]R\u0017\u0010^\u001a\b\u0012\u0004\u0012\u00020\u00140;\u00a2\u0006\b\n\u0000\u001a\u0004\b_\u0010=\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0098\u0001"}, d2={"Lcom/ustadmobile/meshrabiya/vnet/VirtualNode;", "Lcom/ustadmobile/meshrabiya/vnet/VirtualRouter;", "Ljava/io/Closeable;", "port", "", "json", "Lkotlinx/serialization/json/Json;", "logger", "Lcom/ustadmobile/meshrabiya/log/MNetLogger;", "address", "Ljava/net/InetAddress;", "networkPrefixLength", "config", "Lcom/ustadmobile/meshrabiya/vnet/NodeConfig;", "(ILkotlinx/serialization/json/Json;Lcom/ustadmobile/meshrabiya/log/MNetLogger;Ljava/net/InetAddress;ILcom/ustadmobile/meshrabiya/vnet/NodeConfig;)V", "_incomingMmcpMessages", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lcom/ustadmobile/meshrabiya/mmcp/MmcpMessageAndPacketHeader;", "_state", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/ustadmobile/meshrabiya/vnet/LocalNodeState;", "get_state", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "activeSockets", "", "Lcom/ustadmobile/meshrabiya/vnet/datagram/VirtualDatagramSocketImpl;", "getAddress", "()Ljava/net/InetAddress;", "addressAsInt", "getAddressAsInt", "()I", "chainSocketFactory", "Lcom/ustadmobile/meshrabiya/vnet/socket/ChainSocketFactory;", "getChainSocketFactory", "()Lcom/ustadmobile/meshrabiya/vnet/socket/ChainSocketFactory;", "chainSocketServer", "Lcom/ustadmobile/meshrabiya/vnet/socket/ChainSocketServer;", "getConfig", "()Lcom/ustadmobile/meshrabiya/vnet/NodeConfig;", "connectionExecutor", "Ljava/util/concurrent/ExecutorService;", "getConnectionExecutor", "()Ljava/util/concurrent/ExecutorService;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "datagramSocket", "Lcom/ustadmobile/meshrabiya/vnet/VirtualNodeDatagramSocket;", "getDatagramSocket", "()Lcom/ustadmobile/meshrabiya/vnet/VirtualNodeDatagramSocket;", "forwardingRules", "Lcom/ustadmobile/meshrabiya/portforward/ForwardBindPoint;", "Lcom/ustadmobile/meshrabiya/portforward/UdpForwardRule;", "iDatagramSocketFactory", "Lcom/ustadmobile/meshrabiya/vnet/VirtualNodeReturnPathSocketFactory;", "getIDatagramSocketFactory", "()Lcom/ustadmobile/meshrabiya/vnet/VirtualNodeReturnPathSocketFactory;", "incomingMmcpMessages", "Lkotlinx/coroutines/flow/Flow;", "getIncomingMmcpMessages", "()Lkotlinx/coroutines/flow/Flow;", "getJson", "()Lkotlinx/serialization/json/Json;", "localDatagramPort", "getLocalDatagramPort", "localPort", "logPrefix", "", "getLogPrefix", "()Ljava/lang/String;", "getLogger", "()Lcom/ustadmobile/meshrabiya/log/MNetLogger;", "meshrabiyaWifiManager", "Lcom/ustadmobile/meshrabiya/vnet/wifi/MeshrabiyaWifiManager;", "getMeshrabiyaWifiManager", "()Lcom/ustadmobile/meshrabiya/vnet/wifi/MeshrabiyaWifiManager;", "mmcpMessageIdAtomic", "Ljava/util/concurrent/atomic/AtomicInteger;", "getNetworkPrefixLength", "originatingMessageManager", "Lcom/ustadmobile/meshrabiya/vnet/OriginatingMessageManager;", "pongListeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/ustadmobile/meshrabiya/vnet/PongListener;", "getPort", "scheduledExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "getScheduledExecutor", "()Ljava/util/concurrent/ScheduledExecutorService;", "socketFactory", "Ljavax/net/SocketFactory;", "getSocketFactory", "()Ljavax/net/SocketFactory;", "state", "getState", "addNewNeighborConnection", "", "neighborNodeVirtualAddr", "socket", "addPongListener", "listener", "allocateUdpPortOrThrow", "virtualDatagramSocketImpl", "portNum", "close", "createBoundDatagramSocket", "Ljava/net/DatagramSocket;", "createDatagramSocket", "createForwardRule", "listenSocket", "destAddress", "destPort", "deallocatePort", "protocol", "Lcom/ustadmobile/meshrabiya/vnet/Protocol;", "forward", "bindZone", "Lcom/ustadmobile/meshrabiya/vnet/VirtualNode$Zone;", "bindPort", "bindAddress", "generateConnectLink", "Lcom/ustadmobile/meshrabiya/vnet/MeshrabiyaConnectLink;", "hotspot", "Lcom/ustadmobile/meshrabiya/vnet/wifi/WifiConnectConfig;", "bluetoothConfig", "Lcom/ustadmobile/meshrabiya/vnet/bluetooth/MeshrabiyaBluetoothState;", "lookupNextHopForChainSocket", "Lcom/ustadmobile/meshrabiya/vnet/socket/ChainSocketNextHop;", "nextMmcpMessageId", "onIncomingMmcpMessage", "", "virtualPacket", "Lcom/ustadmobile/meshrabiya/vnet/VirtualPacket;", "datagramPacket", "Ljava/net/DatagramPacket;", "removePongListener", "route", "packet", "virtualNodeDatagramSocket", "setWifiHotspotEnabled", "Lcom/ustadmobile/meshrabiya/vnet/wifi/LocalHotspotResponse;", "enabled", "preferredBand", "Lcom/ustadmobile/meshrabiya/vnet/wifi/ConnectBand;", "hotspotType", "Lcom/ustadmobile/meshrabiya/vnet/wifi/HotspotType;", "(ZLcom/ustadmobile/meshrabiya/vnet/wifi/ConnectBand;Lcom/ustadmobile/meshrabiya/vnet/wifi/HotspotType;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stopForward", "bindAddr", "LastOriginatorMessage", "Zone", "lib-meshrabiya_debug"})
@SourceDebugExtension(value={"SMAP\nVirtualNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualNode.kt\ncom/ustadmobile/meshrabiya/vnet/VirtualNode\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,580:1\n230#2,5:581\n1855#3,2:586\n766#3:588\n857#3,2:589\n1855#3,2:591\n*S KotlinDebug\n*F\n+ 1 VirtualNode.kt\ncom/ustadmobile/meshrabiya/vnet/VirtualNode\n*L\n181#1:581,5\n376#1:586,2\n465#1:588\n465#1:589,2\n467#1:591,2\n*E\n"})
public abstract class VirtualNode
implements VirtualRouter,
Closeable {
    private final int port;
    @NotNull
    private final Json json;
    @NotNull
    private final MNetLogger logger;
    @NotNull
    private final InetAddress address;
    private final int networkPrefixLength;
    @NotNull
    private final NodeConfig config;
    private final int addressAsInt;
    @NotNull
    private final ExecutorService connectionExecutor;
    @NotNull
    private final ScheduledExecutorService scheduledExecutor;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final AtomicInteger mmcpMessageIdAtomic;
    @NotNull
    private final MutableStateFlow<LocalNodeState> _state;
    @NotNull
    private final Flow<LocalNodeState> state;
    @NotNull
    private final CopyOnWriteArrayList<PongListener> pongListeners;
    @NotNull
    private final String logPrefix;
    @NotNull
    private final VirtualNodeReturnPathSocketFactory iDatagramSocketFactory;
    @NotNull
    private final Map<ForwardBindPoint, UdpForwardRule> forwardingRules;
    @NotNull
    private final OriginatingMessageManager originatingMessageManager;
    private final int localPort;
    @NotNull
    private final VirtualNodeDatagramSocket datagramSocket;
    @NotNull
    private final ChainSocketFactory chainSocketFactory;
    @NotNull
    private final ChainSocketServer chainSocketServer;
    @NotNull
    private final MutableSharedFlow<MmcpMessageAndPacketHeader> _incomingMmcpMessages;
    @NotNull
    private final Flow<MmcpMessageAndPacketHeader> incomingMmcpMessages;
    @NotNull
    private final Map<Integer, VirtualDatagramSocketImpl> activeSockets;

    public VirtualNode(int port, @NotNull Json json, @NotNull MNetLogger logger, @NotNull InetAddress address, int networkPrefixLength, @NotNull NodeConfig config) {
        LocalNodeState prev;
        LocalNodeState nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.port = port;
        this.json = json;
        this.logger = logger;
        this.address = address;
        this.networkPrefixLength = networkPrefixLength;
        this.config = config;
        this.addressAsInt = InetAddressExtKt.requireAddressAsInt(this.address);
        ExecutorService executorService = Executors.newCachedThreadPool();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newCachedThreadPool(...)");
        this.connectionExecutor = executorService;
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(2);
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newScheduledThreadPool(...)");
        this.scheduledExecutor = scheduledExecutorService;
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getDefault().plus((CoroutineContext)JobKt.Job$default(null, (int)1, null)));
        this.mmcpMessageIdAtomic = new AtomicInteger();
        this._state = StateFlowKt.MutableStateFlow((Object)new LocalNodeState(0, null, null, null, null, 31, null));
        this.state = (Flow)FlowKt.asStateFlow(this._state);
        this.pongListeners = new CopyOnWriteArrayList();
        this.logPrefix = "[VirtualNode " + IntExtKt.addressToDotNotation(this.addressAsInt) + "]";
        this.iDatagramSocketFactory = new VirtualNodeReturnPathSocketFactory(this);
        this.forwardingRules = new ConcurrentHashMap();
        this.originatingMessageManager = new OriginatingMessageManager(this.address, this.logger, this.scheduledExecutor, (Function0)new Function0<Integer>((Object)this){

            @NotNull
            public final Integer invoke() {
                return ((VirtualNode)this.receiver).nextMmcpMessageId();
            }
        }, (Function0)new Function0<MeshrabiyaWifiState>(this){
            final /* synthetic */ VirtualNode this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final MeshrabiyaWifiState invoke() {
                return ((LocalNodeState)this.this$0.get_state().getValue()).getWifiState();
            }
        }, 0, 0, 0, 224, null);
        this.localPort = FindFreePortKt.findFreePort(0);
        DatagramSocket datagramSocket = new DatagramSocket(this.localPort);
        ExecutorService executorService2 = this.connectionExecutor;
        int n = this.addressAsInt;
        MNetLogger mNetLogger = this.logger;
        this.datagramSocket = new VirtualNodeDatagramSocket(datagramSocket, n, executorService2, this, mNetLogger, null, null, 96, null);
        this.chainSocketFactory = new ChainSocketFactoryImpl(this, null, this.logger, 2, null);
        this.chainSocketServer = new ChainSocketServer(new ServerSocket(this.localPort), this.connectionExecutor, this.chainSocketFactory, IntExtKt.addressToDotNotation(this.addressAsInt), this.logger, null, 32, null);
        this._incomingMmcpMessages = SharedFlowKt.MutableSharedFlow$default((int)8, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        this.incomingMmcpMessages = (Flow)FlowKt.asSharedFlow(this._incomingMmcpMessages);
        this.activeSockets = new ConcurrentHashMap();
        MutableStateFlow<LocalNodeState> $this$update$iv = this._state;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            prev = (LocalNodeState)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = LocalNodeState.copy$default(prev, this.addressAsInt, null, null, VirtualNode.generateConnectLink$default(this, null, null, 2, null).getUri(), null, 22, null))));
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ VirtualNode this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.originatingMessageManager.getState().collect(new FlowCollector(){

                            @Nullable
                            public final Object emit(@NotNull Map<Integer, LastOriginatorMessage> it, @NotNull Continuation<? super Unit> $completion) {
                                LocalNodeState prev;
                                LocalNodeState nextValue$iv;
                                Object prevValue$iv;
                                MutableStateFlow<LocalNodeState> $this$update$iv = this$0.get_state();
                                boolean $i$f$update = false;
                                do {
                                    prevValue$iv = $this$update$iv.getValue();
                                    prev = (LocalNodeState)prevValue$iv;
                                    boolean bl = false;
                                } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = LocalNodeState.copy$default(prev, 0, null, null, null, it, 15, null))));
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public /* synthetic */ VirtualNode(int n, Json json, MNetLogger mNetLogger, InetAddress inetAddress, int n2, NodeConfig nodeConfig, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            json = (Json)Json.Default;
        }
        if ((n3 & 4) != 0) {
            mNetLogger = new MNetLoggerStdout(0, 1, null);
        }
        if ((n3 & 8) != 0) {
            InetAddress inetAddress2 = VirtualNodeKt.randomApipaInetAddr();
            Intrinsics.checkNotNullExpressionValue((Object)inetAddress2, (String)"randomApipaInetAddr(...)");
            inetAddress = inetAddress2;
        }
        if ((n3 & 0x10) != 0) {
            n2 = 16;
        }
        if ((n3 & 0x20) != 0) {
            nodeConfig = NodeConfig.Companion.getDEFAULT_CONFIG();
        }
        this(n, json, mNetLogger, inetAddress, n2, nodeConfig);
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final Json getJson() {
        return this.json;
    }

    @NotNull
    public final MNetLogger getLogger() {
        return this.logger;
    }

    @Override
    @NotNull
    public final InetAddress getAddress() {
        return this.address;
    }

    @Override
    public int getNetworkPrefixLength() {
        return this.networkPrefixLength;
    }

    @NotNull
    public final NodeConfig getConfig() {
        return this.config;
    }

    public final int getAddressAsInt() {
        return this.addressAsInt;
    }

    @NotNull
    protected final ExecutorService getConnectionExecutor() {
        return this.connectionExecutor;
    }

    @NotNull
    protected final ScheduledExecutorService getScheduledExecutor() {
        return this.scheduledExecutor;
    }

    @NotNull
    protected final CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    @NotNull
    protected final MutableStateFlow<LocalNodeState> get_state() {
        return this._state;
    }

    @NotNull
    public final Flow<LocalNodeState> getState() {
        return this.state;
    }

    @NotNull
    public abstract MeshrabiyaWifiManager getMeshrabiyaWifiManager();

    @NotNull
    protected final String getLogPrefix() {
        return this.logPrefix;
    }

    @NotNull
    protected final VirtualNodeReturnPathSocketFactory getIDatagramSocketFactory() {
        return this.iDatagramSocketFactory;
    }

    @NotNull
    public final VirtualNodeDatagramSocket getDatagramSocket() {
        return this.datagramSocket;
    }

    @NotNull
    protected final ChainSocketFactory getChainSocketFactory() {
        return this.chainSocketFactory;
    }

    @NotNull
    public final SocketFactory getSocketFactory() {
        return this.chainSocketFactory;
    }

    @NotNull
    public final Flow<MmcpMessageAndPacketHeader> getIncomingMmcpMessages() {
        return this.incomingMmcpMessages;
    }

    @Override
    public int nextMmcpMessageId() {
        return this.mmcpMessageIdAtomic.incrementAndGet();
    }

    @Override
    public int allocateUdpPortOrThrow(@NotNull VirtualDatagramSocketImpl virtualDatagramSocketImpl, int portNum) {
        Intrinsics.checkNotNullParameter((Object)virtualDatagramSocketImpl, (String)"virtualDatagramSocketImpl");
        if (portNum > 0) {
            if (this.activeSockets.containsKey(portNum)) {
                throw new IllegalStateException("VirtualNode: port " + portNum + " already allocated!");
            }
            Integer n = portNum;
            this.activeSockets.put(n, virtualDatagramSocketImpl);
            return portNum;
        }
        int attemptCount = 0;
        do {
            int randomPort;
            if (this.activeSockets.containsKey(randomPort = Random.Default.nextInt(0, Short.MAX_VALUE))) continue;
            Integer n = randomPort;
            this.activeSockets.put(n, virtualDatagramSocketImpl);
            return randomPort;
        } while (++attemptCount < 100);
        throw new IllegalStateException("Could not allocate random free port");
    }

    @Override
    public void deallocatePort(@NotNull Protocol protocol, int portNum) {
        Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"protocol");
        this.activeSockets.remove(portNum);
    }

    @NotNull
    public final DatagramSocket createDatagramSocket() {
        return new VirtualDatagramSocket2(this, this.addressAsInt, this.logger);
    }

    @NotNull
    public final DatagramSocket createBoundDatagramSocket(int port) {
        DatagramSocket datagramSocket;
        DatagramSocket it = datagramSocket = this.createDatagramSocket();
        boolean bl = false;
        it.bind(new InetSocketAddress(this.address, port));
        return datagramSocket;
    }

    public final int forward(@NotNull InetAddress bindAddress, int bindPort, @NotNull InetAddress destAddress, int destPort) {
        Intrinsics.checkNotNullParameter((Object)bindAddress, (String)"bindAddress");
        Intrinsics.checkNotNullParameter((Object)destAddress, (String)"destAddress");
        DatagramSocket listenSocket = InetAddressExtKt.prefixMatches(bindAddress, this.getNetworkPrefixLength(), this.address) ? this.createBoundDatagramSocket(bindPort) : new DatagramSocket(bindPort, bindAddress);
        UdpForwardRule forwardRule = this.createForwardRule(listenSocket, destAddress, destPort);
        int boundPort = listenSocket.getLocalPort();
        this.forwardingRules.put(new ForwardBindPoint(bindAddress, null, boundPort), forwardRule);
        return boundPort;
    }

    public final int forward(@NotNull Zone bindZone, int bindPort, @NotNull InetAddress destAddress, int destPort) {
        Intrinsics.checkNotNullParameter((Object)((Object)bindZone), (String)"bindZone");
        Intrinsics.checkNotNullParameter((Object)destAddress, (String)"destAddress");
        DatagramSocket listenSocket = bindZone == Zone.VNET ? this.createBoundDatagramSocket(bindPort) : new DatagramSocket(bindPort);
        UdpForwardRule forwardRule = this.createForwardRule(listenSocket, destAddress, destPort);
        int boundPort = listenSocket.getLocalPort();
        this.forwardingRules.put(new ForwardBindPoint(null, bindZone, boundPort), forwardRule);
        return boundPort;
    }

    public final void stopForward(@NotNull Zone bindZone, int bindPort) {
        Intrinsics.checkNotNullParameter((Object)((Object)bindZone), (String)"bindZone");
    }

    public final void stopForward(@NotNull InetAddress bindAddr, int bindPort) {
        Intrinsics.checkNotNullParameter((Object)bindAddr, (String)"bindAddr");
    }

    private final UdpForwardRule createForwardRule(DatagramSocket listenSocket, InetAddress destAddress, int destPort) {
        ExecutorService executorService = this.connectionExecutor;
        MNetLogger mNetLogger = this.logger;
        VirtualNodeReturnPathSocketFactory virtualNodeReturnPathSocketFactory = this.iDatagramSocketFactory;
        return new UdpForwardRule(listenSocket, executorService, destAddress, destPort, virtualNodeReturnPathSocketFactory, mNetLogger);
    }

    @Override
    public int getLocalDatagramPort() {
        return this.datagramSocket.getLocalPort();
    }

    @NotNull
    protected final MeshrabiyaConnectLink generateConnectLink(@Nullable WifiConnectConfig hotspot, @Nullable MeshrabiyaBluetoothState bluetoothConfig) {
        return MeshrabiyaConnectLink.Companion.fromComponents(this.addressAsInt, this.getLocalDatagramPort(), hotspot, bluetoothConfig, this.json);
    }

    public static /* synthetic */ MeshrabiyaConnectLink generateConnectLink$default(VirtualNode virtualNode, WifiConnectConfig wifiConnectConfig, MeshrabiyaBluetoothState meshrabiyaBluetoothState, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: generateConnectLink");
        }
        if ((n & 2) != 0) {
            meshrabiyaBluetoothState = null;
        }
        return virtualNode.generateConnectLink(wifiConnectConfig, meshrabiyaBluetoothState);
    }

    private final boolean onIncomingMmcpMessage(VirtualPacket virtualPacket, DatagramPacket datagramPacket, VirtualNodeDatagramSocket datagramSocket) {
        try {
            MmcpMessage mmcpMessage = MmcpMessage.Companion.fromVirtualPacket(virtualPacket);
            int from = virtualPacket.getHeader().getFromAddr();
            MNetLogger.invoke$default(this.logger, 2, (Function0)new Function0<String>(this, mmcpMessage, from){
                final /* synthetic */ VirtualNode this$0;
                final /* synthetic */ MmcpMessage $mmcpMessage;
                final /* synthetic */ int $from;
                {
                    this.this$0 = $receiver;
                    this.$mmcpMessage = $mmcpMessage;
                    this.$from = $from;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.this$0.getLogPrefix() + " received MMCP message (" + Reflection.getOrCreateKotlinClass(this.$mmcpMessage.getClass()).getSimpleName() + ") from " + IntExtKt.addressToDotNotation(this.$from);
                }
            }, null, 4, null);
            boolean isToThisNode = virtualPacket.getHeader().getToAddr() == this.addressAsInt;
            boolean shouldRoute = true;
            if (mmcpMessage instanceof MmcpPing && isToThisNode) {
                MNetLogger.invoke$default(this.logger, 2, (Function0)new Function0<String>(this, mmcpMessage, from){
                    final /* synthetic */ VirtualNode this$0;
                    final /* synthetic */ MmcpMessage $mmcpMessage;
                    final /* synthetic */ int $from;
                    {
                        this.this$0 = $receiver;
                        this.$mmcpMessage = $mmcpMessage;
                        this.$from = $from;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return this.this$0.getLogPrefix() + " Received ping(id=" + this.$mmcpMessage.getMessageId() + ") from " + IntExtKt.addressToDotNotation(this.$from);
                    }
                }, null, 4, null);
                MmcpPong pongMessage = new MmcpPong(this.nextMmcpMessageId(), mmcpMessage.getMessageId());
                VirtualPacket replyPacket = MmcpMessage.toVirtualPacket$default(pongMessage, from, this.addressAsInt, 0, (byte)0, 12, null);
                MNetLogger.invoke$default(this.logger, 2, (Function0)new Function0<String>(this, from){
                    final /* synthetic */ VirtualNode this$0;
                    final /* synthetic */ int $from;
                    {
                        this.this$0 = $receiver;
                        this.$from = $from;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return this.this$0.getLogPrefix() + " Sending pong to " + IntExtKt.addressToDotNotation(this.$from);
                    }
                }, null, 4, null);
                VirtualRouter.DefaultImpls.route$default(this, replyPacket, null, null, 6, null);
            } else if (mmcpMessage instanceof MmcpPong && isToThisNode) {
                MNetLogger.invoke$default(this.logger, 2, (Function0)new Function0<String>(this, mmcpMessage){
                    final /* synthetic */ VirtualNode this$0;
                    final /* synthetic */ MmcpMessage $mmcpMessage;
                    {
                        this.this$0 = $receiver;
                        this.$mmcpMessage = $mmcpMessage;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return this.this$0.getLogPrefix() + " Received pong(id=" + this.$mmcpMessage.getMessageId() + ")}";
                    }
                }, null, 4, null);
                this.originatingMessageManager.onPongReceived(from, (MmcpPong)mmcpMessage);
                Iterable $this$forEach$iv = this.pongListeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PongListener it = (PongListener)element$iv;
                    boolean bl = false;
                    it.onPongReceived(from, (MmcpPong)mmcpMessage);
                }
            } else if (mmcpMessage instanceof MmcpHotspotRequest && isToThisNode) {
                this.logger.invoke(4, this.logPrefix + " Received hotspotrequest (id=" + mmcpMessage.getMessageId() + ")", null);
                BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, mmcpMessage, from, null){
                    int label;
                    final /* synthetic */ VirtualNode this$0;
                    final /* synthetic */ MmcpMessage $mmcpMessage;
                    final /* synthetic */ int $from;
                    {
                        this.this$0 = $receiver;
                        this.$mmcpMessage = $mmcpMessage;
                        this.$from = $from;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                this.label = 1;
                                v0 = this.this$0.getMeshrabiyaWifiManager().requestHotspot(this.$mmcpMessage.getMessageId(), ((MmcpHotspotRequest)this.$mmcpMessage).getHotspotRequest(), (Continuation<? super LocalHotspotResponse>)((Continuation)this));
                                if (v0 == var4_2) {
                                    return var4_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                hotspotResult = (LocalHotspotResponse)v0;
                                if (this.$from != this.this$0.getAddressAsInt()) {
                                    replyPacket = MmcpMessage.toVirtualPacket$default(new MmcpHotspotResponse(this.$mmcpMessage.getMessageId(), (LocalHotspotResponse)var2_3), this.$from, this.this$0.getAddressAsInt(), 0, (byte)0, 12, null);
                                    this.this$0.getLogger().invoke(4, this.this$0.getLogPrefix() + " sending hotspotresponse to " + IntExtKt.addressToDotNotation(this.$from), null);
                                    VirtualRouter.DefaultImpls.route$default(this.this$0, replyPacket, null, null, 6, null);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            } else if (mmcpMessage instanceof MmcpOriginatorMessage) {
                DatagramPacket datagramPacket2 = datagramPacket;
                if (datagramPacket2 == null) {
                    return false;
                }
                VirtualNodeDatagramSocket virtualNodeDatagramSocket = datagramSocket;
                if (virtualNodeDatagramSocket == null) {
                    return false;
                }
                shouldRoute = this.originatingMessageManager.onReceiveOriginatingMessage((MmcpOriginatorMessage)mmcpMessage, datagramPacket2, virtualNodeDatagramSocket, virtualPacket);
            }
            this._incomingMmcpMessages.tryEmit((Object)new MmcpMessageAndPacketHeader(mmcpMessage, virtualPacket.getHeader()));
            return shouldRoute;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void route(@NotNull VirtualPacket packet, @Nullable DatagramPacket datagramPacket, @Nullable VirtualNodeDatagramSocket virtualNodeDatagramSocket) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        try {
            int fromLastHop = packet.getHeader().getLastHopAddr();
            if (packet.getHeader().getHopCount() >= this.config.getMaxHops()) {
                this.logger.invoke(3, "Drop packet from " + IntExtKt.addressToDotNotation(packet.getHeader().getFromAddr()) + " - " + packet.getHeader().getHopCount() + " exceeds " + this.config.getMaxHops(), null);
                return;
            }
            if (packet.getHeader().getToPort() == 0 && packet.getHeader().getFromAddr() != this.addressAsInt && !this.onIncomingMmcpMessage(packet, datagramPacket, virtualNodeDatagramSocket)) {
                this.logger.invoke(3, "Drop mmcp packet from " + packet.getHeader().getFromAddr(), null);
            }
            if (packet.getHeader().getToAddr() == this.addressAsInt) {
                VirtualDatagramSocketImpl listeningSocket = this.activeSockets.get(packet.getHeader().getToPort());
                if (listeningSocket != null) {
                    listeningSocket.onIncomingPacket$lib_meshrabiya_debug(packet);
                } else {
                    MNetLogger.invoke$default(this.logger, 3, this.logPrefix + " Incoming packet received, but no socket listening on: " + packet.getHeader().getToPort(), null, 4, null);
                }
            } else {
                int toAddr = packet.getHeader().getToAddr();
                packet.updateLastHopAddrAndIncrementHopCountInData$lib_meshrabiya_debug(this.addressAsInt);
                if (toAddr == -1) {
                    void $this$forEach$iv;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = this.originatingMessageManager.neighbors();
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        Pair it = (Pair)element$iv$iv;
                        boolean bl = false;
                        if (!(((Number)it.getFirst()).intValue() != fromLastHop && ((Number)it.getFirst()).intValue() != packet.getHeader().getFromAddr())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Pair it = (Pair)element$iv;
                        boolean bl = false;
                        MNetLogger.invoke$default(this.logger, 2, (Function0)new Function0<String>(this, packet, fromLastHop, (Pair<Integer, LastOriginatorMessage>)it){
                            final /* synthetic */ VirtualNode this$0;
                            final /* synthetic */ VirtualPacket $packet;
                            final /* synthetic */ int $fromLastHop;
                            final /* synthetic */ Pair<Integer, LastOriginatorMessage> $it;
                            {
                                this.this$0 = $receiver;
                                this.$packet = $packet;
                                this.$fromLastHop = $fromLastHop;
                                this.$it = $it;
                                super(0);
                            }

                            @NotNull
                            public final String invoke() {
                                return this.this$0.getLogPrefix() + " broadcast packet from=" + IntExtKt.addressToDotNotation(this.$packet.getHeader().getFromAddr()) + " lasthop=" + IntExtKt.addressToDotNotation(this.$fromLastHop) + " send to " + IntExtKt.addressToDotNotation(((Number)this.$it.getFirst()).intValue());
                            }
                        }, null, 4, null);
                        ((LastOriginatorMessage)it.getSecond()).getReceivedFromSocket().send(((LastOriginatorMessage)it.getSecond()).getLastHopRealInetAddr(), ((LastOriginatorMessage)it.getSecond()).getLastHopRealPort(), packet);
                    }
                } else {
                    LastOriginatorMessage originatorMessage = this.originatingMessageManager.findOriginatingMessageFor(packet.getHeader().getToAddr());
                    if (originatorMessage != null) {
                        originatorMessage.getReceivedFromSocket().send(originatorMessage.getLastHopRealInetAddr(), originatorMessage.getLastHopRealPort(), packet);
                    } else {
                        MNetLogger.invoke$default(this.logger, 5, this.logPrefix + " route: Cannot route packet to " + IntExtKt.addressToDotNotation(packet.getHeader().getToAddr()) + " : no known nexthop", null, 4, null);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.invoke(6, this.logPrefix + " : route : exception routing packet from " + IntExtKt.addressToDotNotation(packet.getHeader().getFromAddr()), e);
            throw e;
        }
    }

    @Override
    @NotNull
    public ChainSocketNextHop lookupNextHopForChainSocket(@NotNull InetAddress address, int port) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return this.originatingMessageManager.lookupNextHopForChainSocket(address, port);
    }

    public final void addNewNeighborConnection(@NotNull InetAddress address, int port, int neighborNodeVirtualAddr, @NotNull VirtualNodeDatagramSocket socket) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        this.logger.invoke(3, this.logPrefix + " addNewNeighborConnection connection to virtual addr " + IntExtKt.addressToDotNotation(neighborNodeVirtualAddr) + " via datagram to " + address + ":" + port, null);
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, address, port, socket, null){
            int label;
            final /* synthetic */ VirtualNode this$0;
            final /* synthetic */ InetAddress $address;
            final /* synthetic */ int $port;
            final /* synthetic */ VirtualNodeDatagramSocket $socket;
            {
                this.this$0 = $receiver;
                this.$address = $address;
                this.$port = $port;
                this.$socket = $socket;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = OriginatingMessageManager.addNeighbor$default(VirtualNode.access$getOriginatingMessageManager$p(this.this$0), this.$address, this.$port, this.$socket, 0, 0, (Continuation)this, 24, null);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void addPongListener(@NotNull PongListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        ((Collection)this.pongListeners).add(listener);
    }

    public final void removePongListener(@NotNull PongListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        ((Collection)this.pongListeners).remove(listener);
    }

    @Nullable
    public Object setWifiHotspotEnabled(boolean enabled, @NotNull ConnectBand preferredBand, @NotNull HotspotType hotspotType, @NotNull Continuation<? super LocalHotspotResponse> $completion) {
        return VirtualNode.setWifiHotspotEnabled$suspendImpl(this, enabled, preferredBand, hotspotType, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object setWifiHotspotEnabled$suspendImpl(VirtualNode var0, boolean var1_1, ConnectBand var2_2, HotspotType var3_3, Continuation<? super LocalHotspotResponse> var4_4) {
        if (!(var4_4 instanceof setWifiHotspotEnabled.1)) ** GOTO lbl-1000
        var6_5 = var4_4;
        if ((var6_5.label & -2147483648) != 0) {
            var6_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, var4_4){
                /* synthetic */ Object result;
                final /* synthetic */ VirtualNode this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return VirtualNode.setWifiHotspotEnabled$suspendImpl(this.this$0, false, null, null, (Continuation<? super LocalHotspotResponse>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (enabled == false) break;
                $continuation.label = 1;
                v0 = $this.getMeshrabiyaWifiManager().requestHotspot($this.nextMmcpMessageId(), new LocalHotspotRequest(var2_2, var3_3), (Continuation<? super LocalHotspotResponse>)$continuation);
                if (v0 == var7_7) {
                    return var7_7;
                }
                ** GOTO lbl21
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl21:
                // 2 sources

                v1 = (LocalHotspotResponse)v0;
                ** GOTO lbl32
            }
        }
        $continuation.label = 2;
        v2 = $this.getMeshrabiyaWifiManager().deactivateHotspot((Continuation<? super Unit>)$continuation);
        if (v2 == var7_7) {
            return var7_7;
        }
        ** GOTO lbl31
        {
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl31:
                // 2 sources

                v1 = new LocalHotspotResponse(0, 0, null, 0);
lbl32:
                // 2 sources

                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object setWifiHotspotEnabled$default(VirtualNode virtualNode, boolean bl, ConnectBand connectBand, HotspotType hotspotType, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setWifiHotspotEnabled");
        }
        if ((n & 2) != 0) {
            connectBand = ConnectBand.BAND_2GHZ;
        }
        if ((n & 4) != 0) {
            hotspotType = HotspotType.AUTO;
        }
        return virtualNode.setWifiHotspotEnabled(bl, connectBand, hotspotType, (Continuation<? super LocalHotspotResponse>)continuation);
    }

    @Override
    public void close() {
        this.datagramSocket.close(true);
        this.chainSocketServer.close(true);
        CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, (String)"VirtualNode closed", null, (int)2, null);
        this.connectionExecutor.shutdown();
        this.scheduledExecutor.shutdown();
    }

    public VirtualNode() {
        this(0, null, null, null, 0, null, 63, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00c6\u0003J\t\u0010 \u001a\u00020\tH\u00c6\u0003J\t\u0010!\u001a\u00020\u000bH\u00c6\u0003J\t\u0010\"\u001a\u00020\rH\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003JO\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020\u0007H\u00d6\u0001J\t\u0010)\u001a\u00020*H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006+"}, d2={"Lcom/ustadmobile/meshrabiya/vnet/VirtualNode$LastOriginatorMessage;", "", "originatorMessage", "Lcom/ustadmobile/meshrabiya/mmcp/MmcpOriginatorMessage;", "timeReceived", "", "lastHopAddr", "", "hopCount", "", "lastHopRealInetAddr", "Ljava/net/InetAddress;", "receivedFromSocket", "Lcom/ustadmobile/meshrabiya/vnet/VirtualNodeDatagramSocket;", "lastHopRealPort", "(Lcom/ustadmobile/meshrabiya/mmcp/MmcpOriginatorMessage;JIBLjava/net/InetAddress;Lcom/ustadmobile/meshrabiya/vnet/VirtualNodeDatagramSocket;I)V", "getHopCount", "()B", "getLastHopAddr", "()I", "getLastHopRealInetAddr", "()Ljava/net/InetAddress;", "getLastHopRealPort", "getOriginatorMessage", "()Lcom/ustadmobile/meshrabiya/mmcp/MmcpOriginatorMessage;", "getReceivedFromSocket", "()Lcom/ustadmobile/meshrabiya/vnet/VirtualNodeDatagramSocket;", "getTimeReceived", "()J", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "toString", "", "lib-meshrabiya_debug"})
    public static final class LastOriginatorMessage {
        @NotNull
        private final MmcpOriginatorMessage originatorMessage;
        private final long timeReceived;
        private final int lastHopAddr;
        private final byte hopCount;
        @NotNull
        private final InetAddress lastHopRealInetAddr;
        @NotNull
        private final VirtualNodeDatagramSocket receivedFromSocket;
        private final int lastHopRealPort;

        public LastOriginatorMessage(@NotNull MmcpOriginatorMessage originatorMessage, long timeReceived, int lastHopAddr, byte hopCount, @NotNull InetAddress lastHopRealInetAddr, @NotNull VirtualNodeDatagramSocket receivedFromSocket, int lastHopRealPort) {
            Intrinsics.checkNotNullParameter((Object)originatorMessage, (String)"originatorMessage");
            Intrinsics.checkNotNullParameter((Object)lastHopRealInetAddr, (String)"lastHopRealInetAddr");
            Intrinsics.checkNotNullParameter((Object)receivedFromSocket, (String)"receivedFromSocket");
            this.originatorMessage = originatorMessage;
            this.timeReceived = timeReceived;
            this.lastHopAddr = lastHopAddr;
            this.hopCount = hopCount;
            this.lastHopRealInetAddr = lastHopRealInetAddr;
            this.receivedFromSocket = receivedFromSocket;
            this.lastHopRealPort = lastHopRealPort;
        }

        @NotNull
        public final MmcpOriginatorMessage getOriginatorMessage() {
            return this.originatorMessage;
        }

        public final long getTimeReceived() {
            return this.timeReceived;
        }

        public final int getLastHopAddr() {
            return this.lastHopAddr;
        }

        public final byte getHopCount() {
            return this.hopCount;
        }

        @NotNull
        public final InetAddress getLastHopRealInetAddr() {
            return this.lastHopRealInetAddr;
        }

        @NotNull
        public final VirtualNodeDatagramSocket getReceivedFromSocket() {
            return this.receivedFromSocket;
        }

        public final int getLastHopRealPort() {
            return this.lastHopRealPort;
        }

        @NotNull
        public final MmcpOriginatorMessage component1() {
            return this.originatorMessage;
        }

        public final long component2() {
            return this.timeReceived;
        }

        public final int component3() {
            return this.lastHopAddr;
        }

        public final byte component4() {
            return this.hopCount;
        }

        @NotNull
        public final InetAddress component5() {
            return this.lastHopRealInetAddr;
        }

        @NotNull
        public final VirtualNodeDatagramSocket component6() {
            return this.receivedFromSocket;
        }

        public final int component7() {
            return this.lastHopRealPort;
        }

        @NotNull
        public final LastOriginatorMessage copy(@NotNull MmcpOriginatorMessage originatorMessage, long timeReceived, int lastHopAddr, byte hopCount, @NotNull InetAddress lastHopRealInetAddr, @NotNull VirtualNodeDatagramSocket receivedFromSocket, int lastHopRealPort) {
            Intrinsics.checkNotNullParameter((Object)originatorMessage, (String)"originatorMessage");
            Intrinsics.checkNotNullParameter((Object)lastHopRealInetAddr, (String)"lastHopRealInetAddr");
            Intrinsics.checkNotNullParameter((Object)receivedFromSocket, (String)"receivedFromSocket");
            return new LastOriginatorMessage(originatorMessage, timeReceived, lastHopAddr, hopCount, lastHopRealInetAddr, receivedFromSocket, lastHopRealPort);
        }

        public static /* synthetic */ LastOriginatorMessage copy$default(LastOriginatorMessage lastOriginatorMessage, MmcpOriginatorMessage mmcpOriginatorMessage, long l, int n, byte by, InetAddress inetAddress, VirtualNodeDatagramSocket virtualNodeDatagramSocket, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                mmcpOriginatorMessage = lastOriginatorMessage.originatorMessage;
            }
            if ((n3 & 2) != 0) {
                l = lastOriginatorMessage.timeReceived;
            }
            if ((n3 & 4) != 0) {
                n = lastOriginatorMessage.lastHopAddr;
            }
            if ((n3 & 8) != 0) {
                by = lastOriginatorMessage.hopCount;
            }
            if ((n3 & 0x10) != 0) {
                inetAddress = lastOriginatorMessage.lastHopRealInetAddr;
            }
            if ((n3 & 0x20) != 0) {
                virtualNodeDatagramSocket = lastOriginatorMessage.receivedFromSocket;
            }
            if ((n3 & 0x40) != 0) {
                n2 = lastOriginatorMessage.lastHopRealPort;
            }
            return lastOriginatorMessage.copy(mmcpOriginatorMessage, l, n, by, inetAddress, virtualNodeDatagramSocket, n2);
        }

        @NotNull
        public String toString() {
            return "LastOriginatorMessage(originatorMessage=" + this.originatorMessage + ", timeReceived=" + this.timeReceived + ", lastHopAddr=" + this.lastHopAddr + ", hopCount=" + this.hopCount + ", lastHopRealInetAddr=" + this.lastHopRealInetAddr + ", receivedFromSocket=" + this.receivedFromSocket + ", lastHopRealPort=" + this.lastHopRealPort + ")";
        }

        public int hashCode() {
            int result = this.originatorMessage.hashCode();
            result = result * 31 + Long.hashCode(this.timeReceived);
            result = result * 31 + Integer.hashCode(this.lastHopAddr);
            result = result * 31 + Byte.hashCode(this.hopCount);
            result = result * 31 + this.lastHopRealInetAddr.hashCode();
            result = result * 31 + this.receivedFromSocket.hashCode();
            result = result * 31 + Integer.hashCode(this.lastHopRealPort);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LastOriginatorMessage)) {
                return false;
            }
            LastOriginatorMessage lastOriginatorMessage = (LastOriginatorMessage)other;
            if (!Intrinsics.areEqual((Object)this.originatorMessage, (Object)lastOriginatorMessage.originatorMessage)) {
                return false;
            }
            if (this.timeReceived != lastOriginatorMessage.timeReceived) {
                return false;
            }
            if (this.lastHopAddr != lastOriginatorMessage.lastHopAddr) {
                return false;
            }
            if (this.hopCount != lastOriginatorMessage.hopCount) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.lastHopRealInetAddr, (Object)lastOriginatorMessage.lastHopRealInetAddr)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.receivedFromSocket, (Object)lastOriginatorMessage.receivedFromSocket)) {
                return false;
            }
            return this.lastHopRealPort == lastOriginatorMessage.lastHopRealPort;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/ustadmobile/meshrabiya/vnet/VirtualNode$Zone;", "", "(Ljava/lang/String;I)V", "VNET", "REAL", "lib-meshrabiya_debug"})
    public static final class Zone
    extends Enum<Zone> {
        public static final /* enum */ Zone VNET = new Zone();
        public static final /* enum */ Zone REAL = new Zone();
        private static final /* synthetic */ Zone[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Zone[] values() {
            return (Zone[])$VALUES.clone();
        }

        public static Zone valueOf(String value) {
            return Enum.valueOf(Zone.class, value);
        }

        @NotNull
        public static EnumEntries<Zone> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = zoneArray = new Zone[]{Zone.VNET, Zone.REAL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

