/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.meshrabiya.ext;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\f\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u0002\u001a\n\u0010\u0007\u001a\u00020\u0006*\u00020\u0002\u001a\u0012\u0010\b\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\t\u001a\u00020\u0001\u001a\u0012\u0010\n\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0004\u001a\u0014\u0010\f\u001a\u00020\u0002*\u00020\u00022\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a8\u0006\u000f"}, d2={"getBoolean", "", "Ljava/nio/ByteBuffer;", "getInet4Address", "Ljava/net/InetAddress;", "getString", "", "getStringOrThrow", "putBoolean", "boolean", "putInet4Address", "inetAddress", "putStringFromBytes", "strBytes", "", "lib-meshrabiya_debug"})
public final class ByteBufferExtKt {
    @NotNull
    public static final ByteBuffer putStringFromBytes(@NotNull ByteBuffer $this$putStringFromBytes, @Nullable byte[] strBytes) {
        Intrinsics.checkNotNullParameter((Object)$this$putStringFromBytes, (String)"<this>");
        if (strBytes != null) {
            $this$putStringFromBytes.putInt(strBytes.length);
            $this$putStringFromBytes.put(strBytes);
        } else {
            $this$putStringFromBytes.putInt(-1);
        }
        return $this$putStringFromBytes;
    }

    @Nullable
    public static final String getString(@NotNull ByteBuffer $this$getString) {
        Intrinsics.checkNotNullParameter((Object)$this$getString, (String)"<this>");
        int len = $this$getString.getInt();
        if (len != -1) {
            byte[] strBytes = new byte[len];
            $this$getString.get(strBytes);
            return new String(strBytes, Charsets.UTF_8);
        }
        return null;
    }

    @NotNull
    public static final ByteBuffer putBoolean(@NotNull ByteBuffer $this$putBoolean, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)$this$putBoolean, (String)"<this>");
        ByteBuffer byteBuffer = $this$putBoolean.put(bl ? (byte)1 : 0);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"put(...)");
        return byteBuffer;
    }

    public static final boolean getBoolean(@NotNull ByteBuffer $this$getBoolean) {
        Intrinsics.checkNotNullParameter((Object)$this$getBoolean, (String)"<this>");
        return $this$getBoolean.get() != 0;
    }

    @NotNull
    public static final String getStringOrThrow(@NotNull ByteBuffer $this$getStringOrThrow) {
        Intrinsics.checkNotNullParameter((Object)$this$getStringOrThrow, (String)"<this>");
        String string = ByteBufferExtKt.getString($this$getStringOrThrow);
        if (string == null) {
            throw new NullPointerException("ByteBuffer.getStringOrThrow: stored string was null");
        }
        return string;
    }

    @NotNull
    public static final ByteBuffer putInet4Address(@NotNull ByteBuffer $this$putInet4Address, @NotNull InetAddress inetAddress) {
        Intrinsics.checkNotNullParameter((Object)$this$putInet4Address, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)inetAddress, (String)"inetAddress");
        byte[] addressBytes = inetAddress.getAddress();
        if (addressBytes.length != 4) {
            throw new IllegalArgumentException("putInetAddr: expected address of 4 bytes got " + addressBytes.length);
        }
        $this$putInet4Address.put(inetAddress.getAddress());
        return $this$putInet4Address;
    }

    @NotNull
    public static final InetAddress getInet4Address(@NotNull ByteBuffer $this$getInet4Address) {
        Intrinsics.checkNotNullParameter((Object)$this$getInet4Address, (String)"<this>");
        byte[] addressBytes = new byte[4];
        $this$getInet4Address.get(addressBytes);
        InetAddress inetAddress = InetAddress.getByAddress(addressBytes);
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getByAddress(...)");
        return inetAddress;
    }
}

