/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.meshrabiya.ext;

import com.ustadmobile.meshrabiya.ext.ByteArrayExtKt;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001a\u0010\u0005\u001a\u00020\u0006*\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001\u001a\n\u0010\n\u001a\u00020\b*\u00020\u0001\u001a\n\u0010\u000b\u001a\u00020\u0004*\u00020\u0001\u00a8\u0006\f"}, d2={"findLocalInetAddressForDestinationAddress", "Ljava/net/InetAddress;", "destAddress", "unspecifiedIpv6Address", "Ljava/net/Inet6Address;", "prefixMatches", "", "networkPrefixLength", "", "other", "requireAddressAsInt", "requireAsIpv6", "lib-meshrabiya_debug"})
@SourceDebugExtension(value={"SMAP\nInetAddressExt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InetAddressExt.kt\ncom/ustadmobile/meshrabiya/ext/InetAddressExtKt\n+ 2 EnumerationExt.kt\ncom/ustadmobile/meshrabiya/ext/EnumerationExtKt\n*L\n1#1,51:1\n12#2,7:52\n*S KotlinDebug\n*F\n+ 1 InetAddressExt.kt\ncom/ustadmobile/meshrabiya/ext/InetAddressExtKt\n*L\n39#1:52,7\n*E\n"})
public final class InetAddressExtKt {
    public static final int requireAddressAsInt(@NotNull InetAddress $this$requireAddressAsInt) {
        Intrinsics.checkNotNullParameter((Object)$this$requireAddressAsInt, (String)"<this>");
        byte[] addrData = $this$requireAddressAsInt.getAddress();
        if (addrData.length != 4) {
            throw new IllegalArgumentException("requireAddressAsInt: not 32-bit address");
        }
        Intrinsics.checkNotNull((Object)addrData);
        return ByteArrayExtKt.ip4AddressToInt(addrData);
    }

    @NotNull
    public static final Inet6Address requireAsIpv6(@NotNull InetAddress $this$requireAsIpv6) {
        Intrinsics.checkNotNullParameter((Object)$this$requireAsIpv6, (String)"<this>");
        Inet6Address inet6Address = $this$requireAsIpv6 instanceof Inet6Address ? (Inet6Address)$this$requireAsIpv6 : null;
        if (inet6Address == null) {
            throw new IllegalStateException($this$requireAsIpv6 + " not an ipv6 address");
        }
        return inet6Address;
    }

    @NotNull
    public static final Inet6Address unspecifiedIpv6Address() {
        InetAddress inetAddress = Inet6Address.getByName("::");
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getByName(...)");
        return InetAddressExtKt.requireAsIpv6(inetAddress);
    }

    public static final boolean prefixMatches(@NotNull InetAddress $this$prefixMatches, int networkPrefixLength, @NotNull InetAddress other) {
        Intrinsics.checkNotNullParameter((Object)$this$prefixMatches, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        byte[] byArray = $this$prefixMatches.getAddress();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getAddress(...)");
        byte[] byArray2 = other.getAddress();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getAddress(...)");
        return ByteArrayExtKt.prefixMatches(byArray, networkPrefixLength, byArray2);
    }

    @Nullable
    public static final InetAddress findLocalInetAddressForDestinationAddress(@NotNull InetAddress destAddress) {
        InetAddress inetAddress;
        block3: {
            Intrinsics.checkNotNullParameter((Object)destAddress, (String)"destAddress");
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getNetworkInterfaces(...)");
            Enumeration<NetworkInterface> $this$firstNotNullOfOrNull$iv = enumeration;
            boolean $i$f$firstNotNullOfOrNull = false;
            while ($this$firstNotNullOfOrNull$iv.hasMoreElements()) {
                InetAddress transformed$iv;
                InetAddress inetAddress2;
                block2: {
                    NetworkInterface netInterface = $this$firstNotNullOfOrNull$iv.nextElement();
                    boolean bl = false;
                    List<InterfaceAddress> list = netInterface.getInterfaceAddresses();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getInterfaceAddresses(...)");
                    for (InterfaceAddress interfaceAddress : (Iterable)list) {
                        boolean bl2 = false;
                        InetAddress inetAddress3 = interfaceAddress.getAddress();
                        Intrinsics.checkNotNullExpressionValue((Object)inetAddress3, (String)"getAddress(...)");
                        InetAddress inetAddress4 = InetAddressExtKt.prefixMatches(inetAddress3, interfaceAddress.getNetworkPrefixLength(), destAddress) ? interfaceAddress.getAddress() : null;
                        if (inetAddress4 == null) continue;
                        inetAddress2 = inetAddress4;
                        break block2;
                    }
                    inetAddress2 = null;
                }
                if ((transformed$iv = inetAddress2) == null) continue;
                inetAddress = transformed$iv;
                break block3;
            }
            inetAddress = null;
        }
        return inetAddress;
    }
}

