/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.meshrabiya.mmcp;

import com.ustadmobile.meshrabiya.mmcp.MmcpHeader;
import com.ustadmobile.meshrabiya.mmcp.MmcpMessage;
import com.ustadmobile.meshrabiya.vnet.VirtualPacket;
import com.ustadmobile.meshrabiya.vnet.wifi.WifiConnectConfig;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0005J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0003H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/ustadmobile/meshrabiya/mmcp/MmcpOriginatorMessage;", "Lcom/ustadmobile/meshrabiya/mmcp/MmcpMessage;", "messageId", "", "pingTimeSum", "", "connectConfig", "Lcom/ustadmobile/meshrabiya/vnet/wifi/WifiConnectConfig;", "sentTime", "", "(ISLcom/ustadmobile/meshrabiya/vnet/wifi/WifiConnectConfig;J)V", "getConnectConfig", "()Lcom/ustadmobile/meshrabiya/vnet/wifi/WifiConnectConfig;", "getPingTimeSum", "()S", "getSentTime", "()J", "copyWithPingTimeIncrement", "pingTimeIncrement", "equals", "", "other", "", "hashCode", "toBytes", "", "Companion", "lib-meshrabiya_debug"})
public final class MmcpOriginatorMessage
extends MmcpMessage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final short pingTimeSum;
    @Nullable
    private final WifiConnectConfig connectConfig;
    private final long sentTime;
    public static final int CONNECT_CONFIG_OFFSET = 12;

    public MmcpOriginatorMessage(int messageId, short pingTimeSum, @Nullable WifiConnectConfig connectConfig, long sentTime) {
        super((byte)7, messageId, null);
        this.pingTimeSum = pingTimeSum;
        this.connectConfig = connectConfig;
        this.sentTime = sentTime;
    }

    public /* synthetic */ MmcpOriginatorMessage(int n, short s, WifiConnectConfig wifiConnectConfig, long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            l = System.currentTimeMillis();
        }
        this(n, s, wifiConnectConfig, l);
    }

    public final short getPingTimeSum() {
        return this.pingTimeSum;
    }

    @Nullable
    public final WifiConnectConfig getConnectConfig() {
        return this.connectConfig;
    }

    public final long getSentTime() {
        return this.sentTime;
    }

    @Override
    @NotNull
    public byte[] toBytes() {
        byte[] payload;
        block0: {
            WifiConnectConfig wifiConnectConfig = this.connectConfig;
            int connectConfigSize = wifiConnectConfig != null ? wifiConnectConfig.getSizeInBytes() : 0;
            int payloadSize = 12 + connectConfigSize;
            payload = new byte[payloadSize];
            ByteBuffer.wrap(payload).order(ByteOrder.BIG_ENDIAN).putShort(this.pingTimeSum).putLong(this.sentTime).putShort((short)connectConfigSize);
            WifiConnectConfig wifiConnectConfig2 = this.connectConfig;
            if (wifiConnectConfig2 == null) break block0;
            wifiConnectConfig2.toBytes(payload, 12);
        }
        return MmcpMessage.Companion.headerAndPayloadToBytes(this.getHeader(), payload);
    }

    @NotNull
    public final MmcpOriginatorMessage copyWithPingTimeIncrement(short pingTimeIncrement) {
        return new MmcpOriginatorMessage(this.getMessageId(), (short)(this.pingTimeSum + pingTimeIncrement), this.connectConfig, this.sentTime);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MmcpOriginatorMessage)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (this.pingTimeSum != ((MmcpOriginatorMessage)other).pingTimeSum) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.connectConfig, (Object)((MmcpOriginatorMessage)other).connectConfig)) {
            return false;
        }
        return this.sentTime == ((MmcpOriginatorMessage)other).sentTime;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.pingTimeSum;
        WifiConnectConfig wifiConnectConfig = this.connectConfig;
        result = 31 * result + (wifiConnectConfig != null ? wifiConnectConfig.hashCode() : 0);
        result = 31 * result + Long.hashCode(this.sentTime);
        return result;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\u0004J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/ustadmobile/meshrabiya/mmcp/MmcpOriginatorMessage$Companion;", "", "()V", "CONNECT_CONFIG_OFFSET", "", "fromBytes", "Lcom/ustadmobile/meshrabiya/mmcp/MmcpOriginatorMessage;", "byteArray", "", "offset", "len", "incrementPingTimeSum", "", "packet", "Lcom/ustadmobile/meshrabiya/vnet/VirtualPacket;", "pingTimeIncrement", "", "lib-meshrabiya_debug"})
    public static final class Companion {
        private Companion() {
        }

        public final void incrementPingTimeSum(@NotNull VirtualPacket packet, short pingTimeIncrement) {
            Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
            byte what = packet.getData()[packet.getPayloadOffset()];
            if (what != 7) {
                throw new IllegalArgumentException("This is NOT an originator message");
            }
            int timeOffset = packet.getPayloadOffset() + 5;
            ByteBuffer readBuf = ByteBuffer.wrap(packet.getData(), timeOffset, 2).order(ByteOrder.BIG_ENDIAN);
            short setPingTime = readBuf.getShort();
            ByteBuffer writeBuf = ByteBuffer.wrap(packet.getData(), timeOffset, 2).order(ByteOrder.BIG_ENDIAN);
            writeBuf.putShort((short)(setPingTime + pingTimeIncrement));
        }

        @NotNull
        public final MmcpOriginatorMessage fromBytes(@NotNull byte[] byteArray, int offset, int len) {
            Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
            MmcpHeader header = MmcpHeader.Companion.fromBytes(byteArray, offset);
            ByteBuffer byteBuf = ByteBuffer.wrap(byteArray, offset + 5, byteArray.length - (offset + 5)).order(ByteOrder.BIG_ENDIAN);
            short pingTimeSum = byteBuf.getShort();
            long sentTime = byteBuf.getLong();
            short connectConfigSize = byteBuf.getShort();
            WifiConnectConfig connectConfig = connectConfigSize > 0 ? WifiConnectConfig.Companion.fromBytes(byteArray, offset + 5 + 12) : null;
            return new MmcpOriginatorMessage(header.getMessageId(), pingTimeSum, connectConfig, sentTime);
        }

        public static /* synthetic */ MmcpOriginatorMessage fromBytes$default(Companion companion, byte[] byArray, int n, int n2, int n3, Object object) {
            if ((n3 & 4) != 0) {
                n2 = byArray.length;
            }
            return companion.fromBytes(byArray, n, n2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

