/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.meshrabiya.vnet;

import android.net.Network;
import com.ustadmobile.meshrabiya.ext.IntExtKt;
import com.ustadmobile.meshrabiya.log.MNetLogger;
import com.ustadmobile.meshrabiya.vnet.VirtualPacket;
import com.ustadmobile.meshrabiya.vnet.VirtualRouter;
import java.io.Closeable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002BE\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u001bH\u0016J\u001e\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020$R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/ustadmobile/meshrabiya/vnet/VirtualNodeDatagramSocket;", "Ljava/lang/Runnable;", "Ljava/io/Closeable;", "socket", "Ljava/net/DatagramSocket;", "localNodeVirtualAddress", "", "ioExecutorService", "Ljava/util/concurrent/ExecutorService;", "router", "Lcom/ustadmobile/meshrabiya/vnet/VirtualRouter;", "logger", "Lcom/ustadmobile/meshrabiya/log/MNetLogger;", "name", "", "boundNetwork", "Landroid/net/Network;", "(Ljava/net/DatagramSocket;ILjava/util/concurrent/ExecutorService;Lcom/ustadmobile/meshrabiya/vnet/VirtualRouter;Lcom/ustadmobile/meshrabiya/log/MNetLogger;Ljava/lang/String;Landroid/net/Network;)V", "getBoundNetwork", "()Landroid/net/Network;", "future", "Ljava/util/concurrent/Future;", "localPort", "getLocalPort", "()I", "logPrefix", "close", "", "closeSocket", "", "run", "send", "nextHopAddress", "Ljava/net/InetAddress;", "nextHopPort", "virtualPacket", "Lcom/ustadmobile/meshrabiya/vnet/VirtualPacket;", "lib-meshrabiya_debug"})
@SourceDebugExtension(value={"SMAP\nVirtualNodeDatagramSocket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualNodeDatagramSocket.kt\ncom/ustadmobile/meshrabiya/vnet/VirtualNodeDatagramSocket\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1#2:102\n*E\n"})
public final class VirtualNodeDatagramSocket
implements Runnable,
Closeable {
    @NotNull
    private final DatagramSocket socket;
    private final int localNodeVirtualAddress;
    @NotNull
    private final VirtualRouter router;
    @NotNull
    private final MNetLogger logger;
    @Nullable
    private final Network boundNetwork;
    @NotNull
    private final Future<?> future;
    @NotNull
    private final String logPrefix;
    private final int localPort;

    /*
     * WARNING - void declaration
     */
    public VirtualNodeDatagramSocket(@NotNull DatagramSocket socket, int localNodeVirtualAddress, @NotNull ExecutorService ioExecutorService, @NotNull VirtualRouter router, @NotNull MNetLogger logger, @Nullable String name, @Nullable Network boundNetwork) {
        void $this$_init__u24lambda_u240;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        Intrinsics.checkNotNullParameter((Object)ioExecutorService, (String)"ioExecutorService");
        Intrinsics.checkNotNullParameter((Object)router, (String)"router");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.socket = socket;
        this.localNodeVirtualAddress = localNodeVirtualAddress;
        this.router = router;
        this.logger = logger;
        this.boundNetwork = boundNetwork;
        this.localPort = this.socket.getLocalPort();
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        VirtualNodeDatagramSocket virtualNodeDatagramSocket = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.append("[VirtualNodeDatagramSocket for " + IntExtKt.addressToDotNotation(this.localNodeVirtualAddress) + " ");
        if (name != null) {
            $this$_init__u24lambda_u240.append("- " + name);
        }
        $this$_init__u24lambda_u240.append("] ");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        virtualNodeDatagramSocket.logPrefix = string;
        Future<?> future = ioExecutorService.submit(this);
        Intrinsics.checkNotNullExpressionValue(future, (String)"submit(...)");
        this.future = future;
    }

    public /* synthetic */ VirtualNodeDatagramSocket(DatagramSocket datagramSocket, int n, ExecutorService executorService, VirtualRouter virtualRouter, MNetLogger mNetLogger, String string, Network network, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            string = null;
        }
        if ((n2 & 0x40) != 0) {
            network = null;
        }
        this(datagramSocket, n, executorService, virtualRouter, mNetLogger, string, network);
    }

    @Nullable
    public final Network getBoundNetwork() {
        return this.boundNetwork;
    }

    public final int getLocalPort() {
        return this.localPort;
    }

    @Override
    public void run() {
        byte[] buffer = new byte[1500];
        this.logger.invoke(3, this.logPrefix + " Started on " + this.socket.getLocalPort() + " waiting for first packet", null);
        while (!Thread.interrupted() && !this.socket.isClosed()) {
            try {
                DatagramPacket rxPacket = new DatagramPacket(buffer, 0, buffer.length);
                this.socket.receive(rxPacket);
                VirtualPacket rxVirtualPacket = VirtualPacket.Companion.fromDatagramPacket(rxPacket);
                this.router.route(rxVirtualPacket, rxPacket, this);
            }
            catch (Exception e) {
                if (this.socket.isClosed()) continue;
                this.logger.invoke(5, this.logPrefix + " : run : exception handling packet", e);
            }
        }
        MNetLogger.invoke$default(this.logger, 3, this.logPrefix + " : run : finished", null, 4, null);
    }

    public final void send(@NotNull InetAddress nextHopAddress, int nextHopPort, @NotNull VirtualPacket virtualPacket) {
        Intrinsics.checkNotNullParameter((Object)nextHopAddress, (String)"nextHopAddress");
        Intrinsics.checkNotNullParameter((Object)virtualPacket, (String)"virtualPacket");
        DatagramPacket datagramPacket = virtualPacket.toDatagramPacket();
        datagramPacket.setAddress(nextHopAddress);
        datagramPacket.setPort(nextHopPort);
        this.socket.send(datagramPacket);
    }

    public final void close(boolean closeSocket) {
        block0: {
            DatagramSocket datagramSocket;
            this.future.cancel(true);
            DatagramSocket it = datagramSocket = this.socket;
            boolean bl = false;
            DatagramSocket datagramSocket2 = closeSocket ? datagramSocket : null;
            if (datagramSocket2 == null) break block0;
            datagramSocket2.close();
        }
    }

    @Override
    public void close() {
        this.close(false);
    }
}

