/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.meshrabiya.vnet;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 +2\u00020\u0001:\u0001+BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003JY\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010$\u001a\u00020%J\u0016\u0010$\u001a\u00020&2\u0006\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020\u0003J\t\u0010)\u001a\u00020*H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000e\u00a8\u0006,"}, d2={"Lcom/ustadmobile/meshrabiya/vnet/VirtualPacketHeader;", "", "toAddr", "", "toPort", "fromAddr", "fromPort", "lastHopAddr", "hopCount", "", "maxHops", "payloadSize", "(IIIIIBBI)V", "getFromAddr", "()I", "getFromPort", "getHopCount", "()B", "getLastHopAddr", "getMaxHops", "getPayloadSize", "getToAddr", "getToPort", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "hashCode", "toBytes", "", "", "byteArray", "offset", "toString", "", "Companion", "lib-meshrabiya_debug"})
public final class VirtualPacketHeader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int toAddr;
    private final int toPort;
    private final int fromAddr;
    private final int fromPort;
    private final int lastHopAddr;
    private final byte hopCount;
    private final byte maxHops;
    private final int payloadSize;
    public static final int HEADER_SIZE = 20;
    public static final int MAX_PAYLOAD = 2000;

    public VirtualPacketHeader(int toAddr, int toPort, int fromAddr, int fromPort, int lastHopAddr, byte hopCount, byte maxHops, int payloadSize) {
        this.toAddr = toAddr;
        this.toPort = toPort;
        this.fromAddr = fromAddr;
        this.fromPort = fromPort;
        this.lastHopAddr = lastHopAddr;
        this.hopCount = hopCount;
        this.maxHops = maxHops;
        this.payloadSize = payloadSize;
        if (this.payloadSize > 2000) {
            throw new IllegalArgumentException("Payload size must not be > 2000");
        }
    }

    public final int getToAddr() {
        return this.toAddr;
    }

    public final int getToPort() {
        return this.toPort;
    }

    public final int getFromAddr() {
        return this.fromAddr;
    }

    public final int getFromPort() {
        return this.fromPort;
    }

    public final int getLastHopAddr() {
        return this.lastHopAddr;
    }

    public final byte getHopCount() {
        return this.hopCount;
    }

    public final byte getMaxHops() {
        return this.maxHops;
    }

    public final int getPayloadSize() {
        return this.payloadSize;
    }

    public final void toBytes(@NotNull byte[] byteArray, int offset) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        ByteBuffer buf = ByteBuffer.wrap(byteArray, offset, 20).order(ByteOrder.BIG_ENDIAN);
        buf.putInt(this.toAddr);
        buf.putShort((short)this.toPort);
        buf.putInt(this.fromAddr);
        buf.putShort((short)this.fromPort);
        buf.putInt(this.lastHopAddr);
        buf.put(this.hopCount);
        buf.put(this.maxHops);
        buf.putShort((short)this.payloadSize);
    }

    @NotNull
    public final byte[] toBytes() {
        byte[] byArray;
        byte[] it = byArray = new byte[20];
        boolean bl = false;
        this.toBytes(it, 0);
        return byArray;
    }

    public final int component1() {
        return this.toAddr;
    }

    public final int component2() {
        return this.toPort;
    }

    public final int component3() {
        return this.fromAddr;
    }

    public final int component4() {
        return this.fromPort;
    }

    public final int component5() {
        return this.lastHopAddr;
    }

    public final byte component6() {
        return this.hopCount;
    }

    public final byte component7() {
        return this.maxHops;
    }

    public final int component8() {
        return this.payloadSize;
    }

    @NotNull
    public final VirtualPacketHeader copy(int toAddr, int toPort, int fromAddr, int fromPort, int lastHopAddr, byte hopCount, byte maxHops, int payloadSize) {
        return new VirtualPacketHeader(toAddr, toPort, fromAddr, fromPort, lastHopAddr, hopCount, maxHops, payloadSize);
    }

    public static /* synthetic */ VirtualPacketHeader copy$default(VirtualPacketHeader virtualPacketHeader, int n, int n2, int n3, int n4, int n5, byte by, byte by2, int n6, int n7, Object object) {
        if ((n7 & 1) != 0) {
            n = virtualPacketHeader.toAddr;
        }
        if ((n7 & 2) != 0) {
            n2 = virtualPacketHeader.toPort;
        }
        if ((n7 & 4) != 0) {
            n3 = virtualPacketHeader.fromAddr;
        }
        if ((n7 & 8) != 0) {
            n4 = virtualPacketHeader.fromPort;
        }
        if ((n7 & 0x10) != 0) {
            n5 = virtualPacketHeader.lastHopAddr;
        }
        if ((n7 & 0x20) != 0) {
            by = virtualPacketHeader.hopCount;
        }
        if ((n7 & 0x40) != 0) {
            by2 = virtualPacketHeader.maxHops;
        }
        if ((n7 & 0x80) != 0) {
            n6 = virtualPacketHeader.payloadSize;
        }
        return virtualPacketHeader.copy(n, n2, n3, n4, n5, by, by2, n6);
    }

    @NotNull
    public String toString() {
        return "VirtualPacketHeader(toAddr=" + this.toAddr + ", toPort=" + this.toPort + ", fromAddr=" + this.fromAddr + ", fromPort=" + this.fromPort + ", lastHopAddr=" + this.lastHopAddr + ", hopCount=" + this.hopCount + ", maxHops=" + this.maxHops + ", payloadSize=" + this.payloadSize + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.toAddr);
        result = result * 31 + Integer.hashCode(this.toPort);
        result = result * 31 + Integer.hashCode(this.fromAddr);
        result = result * 31 + Integer.hashCode(this.fromPort);
        result = result * 31 + Integer.hashCode(this.lastHopAddr);
        result = result * 31 + Byte.hashCode(this.hopCount);
        result = result * 31 + Byte.hashCode(this.maxHops);
        result = result * 31 + Integer.hashCode(this.payloadSize);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VirtualPacketHeader)) {
            return false;
        }
        VirtualPacketHeader virtualPacketHeader = (VirtualPacketHeader)other;
        if (this.toAddr != virtualPacketHeader.toAddr) {
            return false;
        }
        if (this.toPort != virtualPacketHeader.toPort) {
            return false;
        }
        if (this.fromAddr != virtualPacketHeader.fromAddr) {
            return false;
        }
        if (this.fromPort != virtualPacketHeader.fromPort) {
            return false;
        }
        if (this.lastHopAddr != virtualPacketHeader.lastHopAddr) {
            return false;
        }
        if (this.hopCount != virtualPacketHeader.hopCount) {
            return false;
        }
        if (this.maxHops != virtualPacketHeader.maxHops) {
            return false;
        }
        return this.payloadSize == virtualPacketHeader.payloadSize;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/ustadmobile/meshrabiya/vnet/VirtualPacketHeader$Companion;", "", "()V", "HEADER_SIZE", "", "MAX_PAYLOAD", "fromBytes", "Lcom/ustadmobile/meshrabiya/vnet/VirtualPacketHeader;", "bytes", "", "offset", "lib-meshrabiya_debug"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VirtualPacketHeader fromBytes(@NotNull byte[] bytes, int offset) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            ByteBuffer buf = ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN);
            buf.position(offset);
            int _toAddr = buf.getInt();
            short _toPort = buf.getShort();
            int _fromAddr = buf.getInt();
            short _fromPort = buf.getShort();
            int _lastHopAddr = buf.getInt();
            byte _hopCount = buf.get();
            byte _maxHops = buf.get();
            short _payloadSize = buf.getShort();
            return new VirtualPacketHeader(_toAddr, _toPort, _fromAddr, _fromPort, _lastHopAddr, _hopCount, _maxHops, _payloadSize);
        }

        public static /* synthetic */ VirtualPacketHeader fromBytes$default(Companion companion, byte[] byArray, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            return companion.fromBytes(byArray, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

